/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.crmf.DhSigStatic;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.PermissionConstants;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.SubjectDnSpec;
import org.xipki.ca.server.DhpocControl;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.AlgorithmValidator;
import org.xipki.security.DHSigStaticKeyCertPair;
import org.xipki.security.EdECConstants;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.FileOrBinary;
import org.xipki.util.FileOrValue;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class CaUtil {
    private CaUtil() {
    }

    public static Extensions getExtensions(CertificationRequestInfo csr) {
        Args.notNull((Object)csr, (String)"csr");
        ASN1Set attrs = csr.getAttributes();
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute attr = Attribute.getInstance((Object)attrs.getObjectAt(i));
            if (!PKCSObjectIdentifiers.pkcs_9_at_extensionRequest.equals((ASN1Primitive)attr.getAttrType())) continue;
            return Extensions.getInstance((Object)attr.getAttributeValues()[0]);
        }
        return null;
    }

    public static String getChallengePassword(CertificationRequestInfo csr) {
        Args.notNull((Object)csr, (String)"csr");
        ASN1Set attrs = csr.getAttributes();
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute attr = Attribute.getInstance((Object)attrs.getObjectAt(i));
            if (!PKCSObjectIdentifiers.pkcs_9_at_challengePassword.equals((ASN1Primitive)attr.getAttrType())) continue;
            ASN1String str = (ASN1String)attr.getAttributeValues()[0];
            return str.getString();
        }
        return null;
    }

    public static BasicConstraints createBasicConstraints(Certprofile.CertLevel level, Integer pathLen) {
        BasicConstraints basicConstraints;
        if (level == Certprofile.CertLevel.RootCA || level == Certprofile.CertLevel.SubCA) {
            basicConstraints = pathLen != null ? new BasicConstraints(pathLen.intValue()) : new BasicConstraints(true);
        } else if (level == Certprofile.CertLevel.EndEntity) {
            basicConstraints = new BasicConstraints(false);
        } else {
            throw new IllegalStateException("unknown CertLevel " + level);
        }
        return basicConstraints;
    }

    public static AuthorityInformationAccess createAuthorityInformationAccess(List<String> caIssuerUris, List<String> ocspUris) {
        GeneralName gn;
        if (CollectionUtil.isEmpty(caIssuerUris) && CollectionUtil.isEmpty(ocspUris)) {
            throw new IllegalArgumentException("caIssuerUris and ospUris may not be both empty");
        }
        ArrayList<AccessDescription> accessDescriptions = new ArrayList<AccessDescription>(ocspUris.size());
        if (CollectionUtil.isNotEmpty(caIssuerUris)) {
            for (String uri : caIssuerUris) {
                gn = new GeneralName(6, uri);
                accessDescriptions.add(new AccessDescription(X509ObjectIdentifiers.id_ad_caIssuers, gn));
            }
        }
        if (CollectionUtil.isNotEmpty(ocspUris)) {
            for (String uri : ocspUris) {
                gn = new GeneralName(6, uri);
                accessDescriptions.add(new AccessDescription(X509ObjectIdentifiers.id_ad_ocsp, gn));
            }
        }
        DERSequence seq = new DERSequence((ASN1Encodable[])accessDescriptions.toArray(new AccessDescription[0]));
        return AuthorityInformationAccess.getInstance((Object)seq);
    }

    public static CRLDistPoint createCrlDistributionPoints(List<String> crlUris, X500Name caSubject, X500Name crlSignerSubject) {
        Args.notEmpty(crlUris, (String)"crlUris");
        int size = crlUris.size();
        DistributionPoint[] points = new DistributionPoint[1];
        GeneralName[] names = new GeneralName[size];
        for (int i = 0; i < size; ++i) {
            names[i] = new GeneralName(6, crlUris.get(i));
        }
        GeneralNames gns = new GeneralNames(names);
        DistributionPointName pointName = new DistributionPointName(gns);
        GeneralNames crlIssuer = null;
        if (crlSignerSubject != null && !crlSignerSubject.equals((Object)caSubject)) {
            GeneralName crlIssuerName = new GeneralName(crlSignerSubject);
            crlIssuer = new GeneralNames(crlIssuerName);
        }
        points[0] = new DistributionPoint(pointName, null, crlIssuer);
        return new CRLDistPoint(points);
    }

    public static X500Name sortX509Name(X500Name name) {
        Args.notNull((Object)name, (String)"name");
        RDN[] requstedRdns = name.getRDNs();
        LinkedList<RDN> rdns = new LinkedList<RDN>();
        List sortedDNs = SubjectDnSpec.getForwardDNs();
        for (ASN1ObjectIdentifier type : sortedDNs) {
            RDN[] thisRdns = CaUtil.getRdns(requstedRdns, type);
            if (thisRdns == null || thisRdns.length == 0) continue;
            rdns.addAll(Arrays.asList(thisRdns));
        }
        return new X500Name(rdns.toArray(new RDN[0]));
    }

    public static boolean verifyCsr(CertificationRequest csr, SecurityFactory securityFactory, AlgorithmValidator algorithmValidator, DhpocControl dhpocControl) {
        Args.notNull((Object)csr, (String)"csr");
        ASN1ObjectIdentifier algOid = csr.getSignatureAlgorithm().getAlgorithm();
        DHSigStaticKeyCertPair kaKeyAndCert = null;
        if (ObjectIdentifiers.Xipki.id_alg_dhPop_x25519.equals((ASN1Primitive)algOid) || ObjectIdentifiers.Xipki.id_alg_dhPop_x448.equals((ASN1Primitive)algOid)) {
            if (dhpocControl != null) {
                DhSigStatic dhSigStatic = DhSigStatic.getInstance((Object)csr.getSignature().getBytes());
                IssuerAndSerialNumber isn = dhSigStatic.getIssuerAndSerial();
                ASN1ObjectIdentifier keyOid = csr.getCertificationRequestInfo().getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm();
                kaKeyAndCert = dhpocControl.getKeyCertPair(isn.getName(), isn.getSerialNumber().getValue(), EdECConstants.getName((ASN1ObjectIdentifier)keyOid));
            }
            if (kaKeyAndCert == null) {
                return false;
            }
        }
        return securityFactory.verifyPopo(csr, algorithmValidator, kaKeyAndCert);
    }

    private static RDN[] getRdns(RDN[] rdns, ASN1ObjectIdentifier type) {
        Args.notNull((Object)rdns, (String)"rdns");
        Args.notNull((Object)type, (String)"type");
        ArrayList<RDN> ret = new ArrayList<RDN>(1);
        for (RDN rdn : rdns) {
            if (!rdn.getFirst().getType().equals((ASN1Primitive)type)) continue;
            ret.add(rdn);
        }
        return CollectionUtil.isEmpty(ret) ? null : ret.toArray(new RDN[0]);
    }

    public static String canonicalizeSignerConf(String keystoreType, String signerConf, X509Cert[] certChain, SecurityFactory securityFactory) throws CaMgmtException {
        byte[] ksBytes;
        if (!signerConf.contains("file:") && !signerConf.contains("base64:")) {
            return signerConf;
        }
        ConfPairs pairs = new ConfPairs(signerConf);
        String algo = pairs.value("algo");
        if (algo != null) {
            try {
                algo = SignAlgo.getInstance((String)algo).getJceName();
            }
            catch (NoSuchAlgorithmException ex) {
                throw new CaMgmtException((Throwable)ex);
            }
            pairs.putPair("algo", algo);
        }
        String keystoreConf = pairs.value("keystore");
        String passwordHint = pairs.value("password");
        String keyLabel = pairs.value("key-label");
        if (StringUtil.startsWithIgnoreCase((String)keystoreConf, (String)"file:")) {
            String keystoreFile = keystoreConf.substring("file:".length());
            try {
                ksBytes = IoUtil.read((String)keystoreFile, (boolean)true);
            }
            catch (IOException ex) {
                throw new CaMgmtException("IOException: " + ex.getMessage(), (Throwable)ex);
            }
        } else if (StringUtil.startsWithIgnoreCase((String)keystoreConf, (String)"base64:")) {
            ksBytes = Base64.decode((String)keystoreConf.substring("base64:".length()));
        } else {
            return signerConf;
        }
        try {
            char[] password = securityFactory.getPasswordResolver().resolvePassword(passwordHint);
            ksBytes = securityFactory.extractMinimalKeyStore(keystoreType, ksBytes, keyLabel, password, certChain);
        }
        catch (KeyStoreException ex) {
            throw new CaMgmtException("KeyStoreException: " + ex.getMessage(), (Throwable)ex);
        }
        catch (PasswordResolverException ex) {
            throw new CaMgmtException("PasswordResolverException: " + ex.getMessage(), (Throwable)ex);
        }
        pairs.putPair("keystore", "base64:" + Base64.encodeToString((byte[])ksBytes));
        return pairs.getEncoded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileOrValue createFileOrValue(ZipOutputStream zipStream, String content, String fileName) throws IOException {
        if (StringUtil.isBlank((String)content)) {
            return null;
        }
        FileOrValue ret = new FileOrValue();
        if (content.length() < 256) {
            ret.setValue(content);
        } else {
            ret.setFile(fileName);
            ZipEntry certZipEntry = new ZipEntry(fileName);
            zipStream.putNextEntry(certZipEntry);
            try {
                zipStream.write(StringUtil.toUtf8Bytes((String)content));
            }
            finally {
                zipStream.closeEntry();
            }
        }
        return ret;
    }

    public static FileOrBinary createFileOrBase64Value(ZipOutputStream zipStream, String b64Content, String fileName) throws IOException {
        if (StringUtil.isBlank((String)b64Content)) {
            return null;
        }
        return CaUtil.createFileOrBinary(zipStream, Base64.decode((String)b64Content), fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileOrBinary createFileOrBinary(ZipOutputStream zipStream, byte[] content, String fileName) throws IOException {
        if (content == null || content.length == 0) {
            return null;
        }
        FileOrBinary ret = new FileOrBinary();
        if (content.length < 256) {
            ret.setBinary(content);
        } else {
            ret.setFile(fileName);
            ZipEntry certZipEntry = new ZipEntry(fileName);
            zipStream.putNextEntry(certZipEntry);
            try {
                zipStream.write(content);
            }
            finally {
                zipStream.closeEntry();
            }
        }
        return ret;
    }

    public static List<String> getPermissions(int permission) {
        LinkedList<String> list = new LinkedList<String>();
        if (511 == permission) {
            list.add(PermissionConstants.getTextForCode((int)permission));
        } else {
            for (Integer code : PermissionConstants.getPermissions()) {
                if ((permission & code) == 0) continue;
                list.add(PermissionConstants.getTextForCode((int)code));
            }
        }
        return list;
    }

    public static String encodeCertchain(List<X509Cert> certs) throws CaMgmtException {
        try {
            return X509Util.encodeCertificates((X509Cert[])certs.toArray(new X509Cert[0]));
        }
        catch (IOException | CertificateException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    public static List<X509Cert> buildCertChain(X509Cert targetCert, List<X509Cert> certs) throws CaMgmtException {
        X509Cert[] certchain;
        try {
            certchain = X509Util.buildCertPath((X509Cert)targetCert, certs, (boolean)false);
        }
        catch (CertPathBuilderException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
        if (certchain == null || certs.size() != certchain.length) {
            throw new CaMgmtException("could not build certchain containing all specified certs");
        }
        return Arrays.asList(certchain);
    }

    public static X509Cert parseCert(byte[] encodedCert) throws CaMgmtException {
        try {
            return X509Util.parseCert((byte[])encodedCert);
        }
        catch (CertificateException ex) {
            throw new CaMgmtException("could not parse certificate", (Throwable)ex);
        }
    }

    public static X500Name removeEmptyRdns(X500Name name) {
        RDN[] rdns = name.getRDNs();
        ArrayList<RDN> tmpRdns = new ArrayList<RDN>(rdns.length);
        boolean changed = false;
        for (RDN rdn : rdns) {
            String textValue = X509Util.rdnValueToString((ASN1Encodable)rdn.getFirst().getValue());
            if (StringUtil.isBlank((String)textValue)) {
                changed = true;
                continue;
            }
            tmpRdns.add(rdn);
        }
        return changed ? new X500Name(tmpRdns.toArray(new RDN[0])) : name;
    }
}

