/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.xipki.ca.api.BadCertTemplateException;
import org.xipki.ca.api.profile.BaseCertprofile;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.ExtensionSpec;
import org.xipki.ca.api.profile.ExtensionValue;
import org.xipki.ca.api.profile.ExtensionValues;
import org.xipki.ca.api.profile.KeyParametersOption;
import org.xipki.ca.api.profile.SubjectDnSpec;
import org.xipki.security.EdECConstants;
import org.xipki.security.HashAlgo;
import org.xipki.security.KeyUsage;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SignAlgo;
import org.xipki.util.CollectionUtil;
import org.xipki.util.Validity;

class CertprofileUtil {
    private static final Validity maxCabEeValidity = new Validity(397, Validity.Unit.DAY);

    CertprofileUtil() {
    }

    public static Certprofile.SubjectInfo getSubject(Certprofile certprofile, X500Name requestedSubject) throws CertprofileException, BadCertTemplateException {
        ASN1ObjectIdentifier[] countryOids;
        Certprofile.SubjectInfo subjectInfo = certprofile.getSubject(requestedSubject);
        if (certprofile.getCertDomain() == Certprofile.CertDomain.CABForumBR) {
            X500Name subject = subjectInfo.getGrantedSubject();
            if (certprofile.getCertLevel() == Certprofile.CertLevel.EndEntity) {
                ASN1ObjectIdentifier[] includeSubjectFields;
                CertificatePolicies policies = certprofile.getCertificatePolicies();
                ASN1ObjectIdentifier policyId = null;
                if (policies != null) {
                    for (PolicyInformation m : policies.getPolicyInformation()) {
                        ASN1ObjectIdentifier pid = m.getPolicyIdentifier();
                        if (!ObjectIdentifiers.BaseRequirements.id_domain_validated.equals((ASN1Primitive)pid) && !ObjectIdentifiers.BaseRequirements.id_organization_validated.equals((ASN1Primitive)pid) && !ObjectIdentifiers.BaseRequirements.id_individual_validated.equals((ASN1Primitive)pid)) continue;
                        policyId = pid;
                        break;
                    }
                }
                if (CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.street) && !CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.O) && !CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.givenName) && !CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.surname)) {
                    throw new BadCertTemplateException("subject:street is prohibited if the subject:organizationName field, subject:givenName, and subject:surname field are absent.");
                }
                if (CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.localityName)) {
                    if (!(CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.O) || CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.givenName) || CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                        throw new BadCertTemplateException("subject:localityName is prohibited if the subject:organizationName field, subject:givenName, and subject:surname field are absent.");
                    }
                } else if (!CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.ST) && (CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.O) || CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.givenName) || CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                    throw new BadCertTemplateException("subject:localityName is required if the subject:organizationName field, subject:givenName field, or subject:surname field are present and the subject:stateOrProvinceName field is absent.");
                }
                if (CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.ST)) {
                    if (!(CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.O) || CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.givenName) || CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                        throw new BadCertTemplateException("subject:stateOrProvinceName is prohibited if the subject:organizationName field, subject:givenName, and subject:surname field are absent.");
                    }
                } else if (!CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.localityName) && (CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.O) || CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.givenName) || CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                    throw new BadCertTemplateException("subject:stateOrProvinceName is required if the subject:organizationName field, subject:givenName field, or subject:surname field are present and the subject:localityName field is absent.");
                }
                if (CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.postalCode) && !CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.O) && !CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.givenName) && !CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.surname)) {
                    throw new BadCertTemplateException("subject:postalCode is prohibited if the subject:organizationName field, subject:givenName, and subject:surname field are absent.");
                }
                if (!CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.C) && (CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.O) || CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.givenName) || CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                    throw new BadCertTemplateException("subject:countryCode is required if the subject:organizationName field, subject:givenName, and subject:surname field are present");
                }
                if (ObjectIdentifiers.BaseRequirements.id_domain_validated.equals((ASN1Primitive)policyId)) {
                    ASN1ObjectIdentifier[] excludeSubjectFields;
                    for (ASN1ObjectIdentifier m : excludeSubjectFields = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.O, ObjectIdentifiers.DN.givenName, ObjectIdentifiers.DN.surname, ObjectIdentifiers.DN.street, ObjectIdentifiers.DN.localityName, ObjectIdentifiers.DN.ST, ObjectIdentifiers.DN.postalCode}) {
                        if (!CertprofileUtil.containsRdn(subject, m)) continue;
                        throw new BadCertTemplateException("subject " + ObjectIdentifiers.getName((ASN1ObjectIdentifier)m) + " is prohibited in domain validated certificate");
                    }
                } else if (ObjectIdentifiers.BaseRequirements.id_organization_validated.equals((ASN1Primitive)policyId)) {
                    for (ASN1ObjectIdentifier m : includeSubjectFields = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.O, ObjectIdentifiers.DN.C}) {
                        if (CertprofileUtil.containsRdn(subject, m)) continue;
                        throw new BadCertTemplateException("subject " + ObjectIdentifiers.getName((ASN1ObjectIdentifier)m) + " is required in organization validated certificate");
                    }
                    if (!CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.localityName) && !CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.ST)) {
                        throw new BadCertTemplateException("at least one of subject:localityName and subject:stateOrProvinceName is required in organization validated certificate");
                    }
                } else if (ObjectIdentifiers.BaseRequirements.id_individual_validated.equals((ASN1Primitive)policyId)) {
                    for (ASN1ObjectIdentifier m : includeSubjectFields = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.C}) {
                        if (CertprofileUtil.containsRdn(subject, m)) continue;
                        throw new BadCertTemplateException("subject " + ObjectIdentifiers.getName((ASN1ObjectIdentifier)m) + " is required in individual validated certificate");
                    }
                    if (!(CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.O) || CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.givenName) && CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                        throw new BadCertTemplateException("at least one of subject:organizationName and (subject:givenName, subject:surName) is required in individual validated certificate");
                    }
                    if (!CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.localityName) && !CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.ST)) {
                        throw new BadCertTemplateException("at least one of subject:localityName and subject:stateOrProvinceName is required in individual validated certificate");
                    }
                }
            } else {
                ASN1ObjectIdentifier[] requiredTypes;
                for (ASN1ObjectIdentifier m : requiredTypes = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.CN, ObjectIdentifiers.DN.O, ObjectIdentifiers.DN.C}) {
                    if (CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.CN)) continue;
                    throw new BadCertTemplateException("missing " + ObjectIdentifiers.getName((ASN1ObjectIdentifier)m) + " in subject");
                }
            }
        }
        for (ASN1ObjectIdentifier oid : countryOids = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.C, ObjectIdentifiers.DN.countryOfCitizenship, ObjectIdentifiers.DN.countryOfResidence, ObjectIdentifiers.DN.jurisdictionOfIncorporationCountryName}) {
            RDN[] countryRdns = subjectInfo.getGrantedSubject().getRDNs(oid);
            if (countryRdns == null) continue;
            for (RDN rdn : countryRdns) {
                String textValue = IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue());
                if (SubjectDnSpec.isValidCountryAreaCode((String)textValue)) continue;
                String name = ObjectIdentifiers.getName((ASN1ObjectIdentifier)oid);
                if (name == null) {
                    name = oid.getId();
                }
                throw new BadCertTemplateException("invalid country/area code '" + textValue + "' in subject attribute " + name);
            }
        }
        return subjectInfo;
    }

    public static void validate(Certprofile certprofile) throws CertprofileException {
        int len;
        boolean withMontgomeryCurves;
        Map keyAlgorithms;
        Integer pathLen;
        Certprofile.ExtensionControl control;
        StringBuilder msg = new StringBuilder();
        Map controls = certprofile.getExtensionControls();
        HashSet types = new HashSet(controls.keySet());
        Certprofile.CertLevel certLevel = certprofile.getCertLevel();
        Certprofile.CertDomain certDomain = certprofile.getCertDomain();
        ExtensionSpec spec = ExtensionSpec.getExtensionSpec((Certprofile.CertDomain)certDomain, (Certprofile.CertLevel)certLevel);
        HashSet<ASN1ObjectIdentifier> set = new HashSet<ASN1ObjectIdentifier>();
        for (Object type : types) {
            control = (Certprofile.ExtensionControl)controls.get(type);
            if (!control.isRequest() || !spec.isNonRequest((ASN1ObjectIdentifier)type)) continue;
            set.add((ASN1ObjectIdentifier)type);
        }
        if (CollectionUtil.isNotEmpty(set)) {
            msg.append("extensions ").append(CertprofileUtil.toString(set)).append(" must not be contained in request, ");
        }
        set.clear();
        for (Object type : types) {
            if (!spec.isNotPermitted((ASN1ObjectIdentifier)type)) continue;
            set.add((ASN1ObjectIdentifier)type);
        }
        if (CollectionUtil.isNotEmpty(set)) {
            msg.append("extensions ").append(CertprofileUtil.toString(set)).append(" must not be contained, ");
        }
        set.clear();
        for (Object type : types) {
            control = (Certprofile.ExtensionControl)controls.get(type);
            if (!control.isCritical() || !spec.isNonCriticalOnly((ASN1ObjectIdentifier)type)) continue;
            set.add((ASN1ObjectIdentifier)type);
        }
        if (CollectionUtil.isNotEmpty(set)) {
            msg.append("critical only extensions are marked as non-critical ").append(CertprofileUtil.toString(set)).append(", ");
        }
        set.clear();
        for (Object type : types) {
            control = (Certprofile.ExtensionControl)controls.get(type);
            if (control.isCritical() || !spec.isCriticalOnly((ASN1ObjectIdentifier)type)) continue;
            set.add((ASN1ObjectIdentifier)type);
        }
        if (CollectionUtil.isNotEmpty(set)) {
            msg.append("non-critical only extensions are marked as critical ").append(CertprofileUtil.toString(set)).append(", ");
        }
        set.clear();
        Set requiredTypes = spec.getRequiredExtensions();
        for (ASN1ObjectIdentifier type : requiredTypes) {
            KeyUsage[] extCtrl = (KeyUsage[])controls.get(type);
            if (extCtrl != null && extCtrl.isRequired()) continue;
            set.add(type);
        }
        if (!set.isEmpty()) {
            msg.append("required extensions are not configured or not marked as required ").append(CertprofileUtil.toString(set)).append(", ");
        }
        Set usages = certprofile.getKeyUsage();
        if (certLevel == Certprofile.CertLevel.SubCA || certLevel == Certprofile.CertLevel.RootCA) {
            KeyUsage[] requiredUsages;
            for (KeyUsage usage : requiredUsages = new KeyUsage[]{KeyUsage.keyCertSign, KeyUsage.cRLSign}) {
                if (CertprofileUtil.containsKeyusage(usages, usage)) continue;
                msg.append("CA profile does not contain keyUsage ").append(usage).append(", ");
            }
        } else {
            KeyUsage[] caOnlyUsages = new KeyUsage[]{KeyUsage.keyCertSign};
            HashSet<KeyUsage> setUsages = new HashSet<KeyUsage>();
            for (KeyUsage caOnlyUsage : caOnlyUsages) {
                if (!CertprofileUtil.containsKeyusage(usages, caOnlyUsage)) continue;
                setUsages.add(caOnlyUsage);
            }
            if (CollectionUtil.isNotEmpty(set)) {
                msg.append("EndEntity profile must not contain CA-only keyUsage ").append(setUsages).append(", ");
            }
        }
        if (certLevel == Certprofile.CertLevel.RootCA && (pathLen = certprofile.getPathLenBasicConstraint()) != null) {
            msg.append("Root CA must not set PathLen, ");
        }
        if (certDomain == Certprofile.CertDomain.CABForumBR) {
            CertprofileUtil.validateCABForumBR(certprofile, msg);
        }
        boolean withEdwardsCurves = (keyAlgorithms = certprofile.getKeyAlgorithms()).containsKey(EdECConstants.id_ED25519) || keyAlgorithms.containsKey(EdECConstants.id_ED448);
        boolean bl = withMontgomeryCurves = keyAlgorithms.containsKey(EdECConstants.id_X25519) || keyAlgorithms.containsKey(EdECConstants.id_X448);
        if (withEdwardsCurves || withMontgomeryCurves) {
            List<KeyUsage> allowedUsages;
            HashSet<KeyUsage> requiredUsages = new HashSet<KeyUsage>();
            HashSet<KeyUsage> optionalUsages = new HashSet<KeyUsage>();
            for (Certprofile.KeyUsageControl m : usages) {
                if (m.isRequired()) {
                    requiredUsages.add(m.getKeyUsage());
                    continue;
                }
                optionalUsages.add(m.getKeyUsage());
            }
            if (withMontgomeryCurves) {
                if (certLevel != Certprofile.CertLevel.EndEntity) {
                    msg.append("montgomery curves are not permitted in CA certificates, ");
                }
                if (!requiredUsages.contains(KeyUsage.keyAgreement)) {
                    msg.append("required KeyUsage KeyAgreement is not marked as 'required', ");
                }
                allowedUsages = Arrays.asList(KeyUsage.keyAgreement, KeyUsage.encipherOnly, KeyUsage.decipherOnly);
            } else if (certLevel == Certprofile.CertLevel.EndEntity) {
                if (!requiredUsages.contains(KeyUsage.digitalSignature) && !requiredUsages.contains(KeyUsage.contentCommitment)) {
                    msg.append("required KeyUsage digitalSignature or contentCommitment is not marked as 'required', ");
                }
                allowedUsages = Arrays.asList(KeyUsage.digitalSignature, KeyUsage.contentCommitment);
            } else {
                allowedUsages = Arrays.asList(KeyUsage.digitalSignature, KeyUsage.contentCommitment, KeyUsage.keyCertSign, KeyUsage.cRLSign);
            }
            requiredUsages.removeAll(allowedUsages);
            optionalUsages.removeAll(allowedUsages);
            if (!requiredUsages.isEmpty()) {
                msg.append("Required KeyUsage items ").append(requiredUsages).append(" are not permitted, ");
            }
            if (!optionalUsages.isEmpty()) {
                msg.append("Optional KeyUsage items ").append(requiredUsages).append(" are not permitted, ");
            }
        }
        if ((len = msg.length()) > 2) {
            msg.delete(len - 2, len);
            throw new CertprofileException(msg.toString());
        }
    }

    private static void validateCABForumBR(Certprofile certprofile, StringBuilder msg) {
        CertificatePolicies certPolicyValue;
        List sigAlgos;
        Validity validity;
        Certprofile.SubjectControl subjectCtl = certprofile.getSubjectControl();
        if (CollectionUtil.isNotEmpty((Collection)subjectCtl.getGroups())) {
            msg.append("multiple AttributeAndTypes in one RDN is not permitted, ");
        }
        for (ASN1ObjectIdentifier m : subjectCtl.getTypes()) {
            Certprofile.RdnControl ctl = subjectCtl.getControl(m);
            if (ctl.getMaxOccurs() <= 1) continue;
            msg.append("multiple RDNs of the same type are not permitted, ");
        }
        Certprofile.CertLevel certLevel = certprofile.getCertLevel();
        if (certLevel == Certprofile.CertLevel.EndEntity && (validity = certprofile.getValidity()).compareTo(maxCabEeValidity) > 0) {
            msg.append("validity exceeds the maximal validity of subscriber certificate, ");
        }
        if ((sigAlgos = certprofile.getSignatureAlgorithms()) == null) {
            msg.append("signature algorithms not defined, ");
        } else {
            List<HashAlgo> allowedHashAlgos = Arrays.asList(HashAlgo.SHA256, HashAlgo.SHA384, HashAlgo.SHA512);
            for (SignAlgo signAlgo : sigAlgos) {
                HashAlgo hashAlgo = signAlgo.getHashAlgo();
                if (allowedHashAlgos.contains(hashAlgo)) continue;
                msg.append("unpermitted hash algorithm ").append(hashAlgo).append(", ");
            }
        }
        Map keyAlgorithms = certprofile.getKeyAlgorithms();
        if (CollectionUtil.isEmpty((Map)keyAlgorithms)) {
            msg.append("keyAlgorithms is not configured, ");
        } else {
            for (ASN1ObjectIdentifier m : keyAlgorithms.keySet()) {
                KeyParametersOption opt = (KeyParametersOption)keyAlgorithms.get(m);
                if (m.equals((ASN1Primitive)PKCSObjectIdentifiers.rsaEncryption)) {
                    if (opt instanceof KeyParametersOption.RSAParametersOption) {
                        if (!((KeyParametersOption.RSAParametersOption)opt).allowsModulusLength(2047)) continue;
                        msg.append("minimum RSA modulus size 2048 bit not satisfied, ");
                        continue;
                    }
                    msg.append("unpermitted RSA modulus are configured, ");
                    continue;
                }
                if (m.equals((ASN1Primitive)X9ObjectIdentifiers.id_ecPublicKey)) {
                    if (opt instanceof KeyParametersOption.ECParamatersOption) {
                        HashSet curveOids = new HashSet(((KeyParametersOption.ECParamatersOption)opt).getCurveOids());
                        curveOids.remove(SECObjectIdentifiers.secp256r1);
                        curveOids.remove(SECObjectIdentifiers.secp384r1);
                        curveOids.remove(SECObjectIdentifiers.secp521r1);
                        if (curveOids.isEmpty()) continue;
                        msg.append("EC curves ").append(curveOids).append(" are not permitted, ");
                        continue;
                    }
                    msg.append("unpermitted EC curves are configured, ");
                    continue;
                }
                if (m.equals((ASN1Primitive)X9ObjectIdentifiers.id_dsa)) {
                    if (opt instanceof KeyParametersOption.DSAParametersOption) {
                        KeyParametersOption.DSAParametersOption dsaOpt = (KeyParametersOption.DSAParametersOption)opt;
                        if (dsaOpt.allowsPlength(2047)) {
                            msg.append("minimum L (2048) not satisfied, ");
                        }
                        if (!dsaOpt.allowsQlength(223)) continue;
                        msg.append("minimum N (224) not satisfied, ");
                        continue;
                    }
                    msg.append("unpermitted DSA (p,q) are configured, ");
                    continue;
                }
                msg.append("keyAlgorithm ").append(m.getId()).append(" is not permitted, ");
            }
        }
        Certprofile.CrlDistributionPointsControl crlDpControl = certprofile.getCrlDpControl();
        if (crlDpControl == null) {
            msg.append("restriction of CRLDistributionPoints is not configured, ");
        } else {
            Set protocols = crlDpControl.getProtocols();
            if (protocols == null || protocols.size() != 1 || !protocols.contains("http")) {
                msg.append("CRLDistributionPoints allows protocol other than http, ");
            }
        }
        Certprofile.CrlDistributionPointsControl freshestCrlControl = certprofile.getFreshestCrlControl();
        if (freshestCrlControl == null) {
            msg.append("restriction of FreshestCRL is not configured, ");
        } else {
            Set protocols = freshestCrlControl.getProtocols();
            if (protocols == null || protocols.size() != 1 || !protocols.contains("http")) {
                msg.append("FreshestCRL allows protocol other than http, ");
            }
        }
        Certprofile.AuthorityInfoAccessControl aiaControl = certprofile.getAiaControl();
        if (aiaControl == null) {
            msg.append("restriction of AuthorityInfoAccess is not configured, ");
        } else {
            Set protocols;
            if (!aiaControl.isIncludesOcsp()) {
                msg.append("access method id-ad-ocsp is not configured, ");
            } else {
                protocols = aiaControl.getOcspProtocols();
                if (protocols == null || protocols.size() != 1 || !protocols.contains("http")) {
                    msg.append("AIA OCSP allows protocol other than http, ");
                }
            }
            if (!aiaControl.isIncludesCaIssuers()) {
                msg.append("access method id-ad-caIssuers is not configured, ");
            } else {
                protocols = aiaControl.getCaIssuersProtocols();
                if (protocols == null || protocols.size() != 1 || !protocols.contains("http")) {
                    msg.append("AIA CAIssuers allows protocol other than http, ");
                }
            }
        }
        if ((certLevel == Certprofile.CertLevel.SubCA || certLevel == Certprofile.CertLevel.EndEntity) && (certPolicyValue = certprofile.getCertificatePolicies()) == null) {
            msg.append("CertificatePolicies is not configured, ");
        }
        if (certLevel == Certprofile.CertLevel.EndEntity) {
            Set sanModes = certprofile.getSubjectAltNameModes();
            if (sanModes == null) {
                msg.append("Restriction of SubjectAltNames is not configured, ");
            } else {
                HashSet<Certprofile.GeneralNameMode> tmp = new HashSet<Certprofile.GeneralNameMode>(sanModes);
                for (Certprofile.GeneralNameMode m : sanModes) {
                    if (m.getTag() == Certprofile.GeneralNameTag.uniformResourceIdentifier || m.getTag() != Certprofile.GeneralNameTag.IPAddress) continue;
                    tmp.add(m);
                }
                if (!tmp.isEmpty()) {
                    msg.append("SubjectAltNames ").append(tmp).append(" is not configured, ");
                }
            }
        }
        Set usages = certprofile.getKeyUsage();
        if (certLevel == Certprofile.CertLevel.RootCA || certLevel == Certprofile.CertLevel.SubCA) {
            if (!CertprofileUtil.containsKeyusage(usages, KeyUsage.cRLSign)) {
                msg.append("RootCA profile does contain keyUsage ").append(KeyUsage.cRLSign).append(", ");
            }
        } else if (certLevel == Certprofile.CertLevel.EndEntity && CertprofileUtil.containsKeyusage(usages, KeyUsage.cRLSign)) {
            msg.append("EndEntity profile must not contain keyUsage ").append(KeyUsage.cRLSign).append(", ");
        }
        Set ekuControls = certprofile.getExtendedKeyUsages();
        if (certLevel == Certprofile.CertLevel.EndEntity) {
            boolean xkuTlsServerRequired = false;
            boolean xkuTlsClientRequired = false;
            for (Certprofile.ExtKeyUsageControl m : ekuControls) {
                ASN1ObjectIdentifier oid = m.getExtKeyUsage();
                if (m.isRequired()) {
                    if (ObjectIdentifiers.XKU.id_kp_serverAuth.equals((ASN1Primitive)oid)) {
                        xkuTlsServerRequired = true;
                    } else if (ObjectIdentifiers.XKU.id_kp_clientAuth.equals((ASN1Primitive)oid)) {
                        xkuTlsClientRequired = true;
                    }
                }
                if (ObjectIdentifiers.XKU.id_kp_serverAuth.equals((ASN1Primitive)oid) || ObjectIdentifiers.XKU.id_kp_clientAuth.equals((ASN1Primitive)oid) || ObjectIdentifiers.XKU.id_kp_emailProtection.equals((ASN1Primitive)oid)) continue;
                msg.append("extendedKeyUsage ").append(oid.getId()).append(" is not permitted, ");
            }
            if (!(xkuTlsClientRequired | xkuTlsServerRequired)) {
                msg.append("none of ").append(ObjectIdentifiers.XKU.id_kp_clientAuth).append(" and ").append(ObjectIdentifiers.XKU.id_kp_serverAuth).append(" is not configured, ");
            }
        } else if (ekuControls != null) {
            for (Certprofile.GeneralNameMode m : ekuControls) {
                if (!m.getExtKeyUsage().equals((ASN1Primitive)ObjectIdentifiers.XKU.id_kp_anyExtendedKeyUsage)) continue;
                msg.append(ObjectIdentifiers.XKU.id_kp_clientAuth).append(" is not allowed, ");
            }
        }
    }

    static boolean containsRdn(X500Name name, ASN1ObjectIdentifier rdnType) {
        RDN[] rdns = name.getRDNs(rdnType);
        return rdns != null && rdns.length > 0;
    }

    static boolean containsKeyusage(Set<Certprofile.KeyUsageControl> usageControls, KeyUsage usage) {
        for (Certprofile.KeyUsageControl entry : usageControls) {
            if (usage != entry.getKeyUsage()) continue;
            return true;
        }
        return false;
    }

    static void addRequestedKeyusage(Set<KeyUsage> usages, Map<ASN1ObjectIdentifier, Extension> requestedExtensions, Set<Certprofile.KeyUsageControl> usageOccs) {
        Extension extension = requestedExtensions.get(Extension.keyUsage);
        if (extension == null) {
            return;
        }
        org.bouncycastle.asn1.x509.KeyUsage reqKeyUsage = org.bouncycastle.asn1.x509.KeyUsage.getInstance((Object)extension.getParsedValue());
        for (Certprofile.KeyUsageControl k : usageOccs) {
            if (k.isRequired() || !reqKeyUsage.hasUsages(k.getKeyUsage().getBcUsage())) continue;
            usages.add(k.getKeyUsage());
        }
    }

    static void addRequestedExtKeyusage(List<ASN1ObjectIdentifier> usages, Map<ASN1ObjectIdentifier, Extension> requestedExtensions, Set<Certprofile.ExtKeyUsageControl> usageOccs) {
        Extension extension = requestedExtensions.get(Extension.extendedKeyUsage);
        if (extension == null) {
            return;
        }
        ExtendedKeyUsage reqKeyUsage = ExtendedKeyUsage.getInstance((Object)extension.getParsedValue());
        for (Certprofile.ExtKeyUsageControl k : usageOccs) {
            if (k.isRequired() || !reqKeyUsage.hasKeyPurposeId(KeyPurposeId.getInstance((Object)k.getExtKeyUsage()))) continue;
            usages.add(k.getExtKeyUsage());
        }
    }

    static ASN1Sequence createSubjectInfoAccess(Map<ASN1ObjectIdentifier, Extension> requestedExtensions, Map<ASN1ObjectIdentifier, Set<Certprofile.GeneralNameMode>> modes) throws BadCertTemplateException {
        if (modes == null) {
            return null;
        }
        Extension extn = requestedExtensions.get(Extension.subjectInfoAccess);
        if (extn == null) {
            return null;
        }
        ASN1Encodable extValue = extn.getParsedValue();
        if (extValue == null) {
            return null;
        }
        ASN1Sequence reqSeq = ASN1Sequence.getInstance((Object)extValue);
        int size = reqSeq.size();
        ASN1EncodableVector vec = new ASN1EncodableVector();
        for (int i = 0; i < size; ++i) {
            AccessDescription ad = AccessDescription.getInstance((Object)reqSeq.getObjectAt(i));
            ASN1ObjectIdentifier accessMethod = ad.getAccessMethod();
            Set<Certprofile.GeneralNameMode> generalNameModes = modes.get(accessMethod);
            if (generalNameModes == null) {
                throw new BadCertTemplateException("subjectInfoAccess.accessMethod " + accessMethod.getId() + " is not allowed");
            }
            GeneralName accessLocation = BaseCertprofile.createGeneralName((GeneralName)ad.getAccessLocation(), generalNameModes);
            vec.add((ASN1Encodable)new AccessDescription(accessMethod, accessLocation));
        }
        return vec.size() > 0 ? new DERSequence(vec) : null;
    }

    static void addExtension(ExtensionValues values, ASN1ObjectIdentifier extType, ExtensionValue extValue, Certprofile.ExtensionControl extControl) throws CertprofileException {
        if (extValue != null) {
            values.addExtension(extType, extValue);
        } else if (extControl.isRequired()) {
            String description = ObjectIdentifiers.getName((ASN1ObjectIdentifier)extType);
            if (description == null) {
                description = extType.getId();
            }
            throw new CertprofileException("could not add required extension " + description);
        }
    }

    static void addExtension(ExtensionValues values, ASN1ObjectIdentifier extType, ASN1Encodable extValue, Certprofile.ExtensionControl extControl) throws CertprofileException {
        if (extValue != null) {
            values.addExtension(extType, extControl.isCritical(), extValue);
        } else if (extControl.isRequired()) {
            String description = ObjectIdentifiers.getName((ASN1ObjectIdentifier)extType);
            if (description == null) {
                description = extType.getId();
            }
            throw new CertprofileException("could not add required extension " + description);
        }
    }

    static String toString(Set<ASN1ObjectIdentifier> oids) {
        if (oids == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (ASN1ObjectIdentifier oid : oids) {
            String name = ObjectIdentifiers.getName((ASN1ObjectIdentifier)oid);
            if (name != null) {
                sb.append(name);
                sb.append(" (").append(oid.getId()).append(")");
            } else {
                sb.append(oid.getId());
            }
            sb.append(", ");
        }
        if (CollectionUtil.isNotEmpty(oids)) {
            int len = sb.length();
            sb.delete(len - 2, len);
        }
        sb.append("]");
        return sb.toString();
    }
}

