/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.math.BigInteger;
import java.security.SecureRandom;

class RandomSerialNumberGenerator {
    private static RandomSerialNumberGenerator instance;
    private final SecureRandom random = new SecureRandom();

    private RandomSerialNumberGenerator() {
    }

    public BigInteger nextSerialNumber(int byteLen) {
        BigInteger bi;
        BigInteger threeBi;
        BigInteger diff;
        int nafWeight;
        byte[] rndBytes = new byte[byteLen];
        int minWeight = byteLen * 2;
        do {
            this.random.nextBytes(rndBytes);
            rndBytes[0] = (byte)(rndBytes[0] & 0x7F);
        } while ((nafWeight = (diff = (threeBi = (bi = new BigInteger(rndBytes)).shiftLeft(1).add(bi)).xor(bi)).bitCount()) < minWeight);
        return bi;
    }

    public static synchronized RandomSerialNumberGenerator getInstance() {
        if (instance == null) {
            instance = new RandomSerialNumberGenerator();
        }
        return instance;
    }
}

