/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.security.cert.CertificateException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.mgmt.entry.RequestorEntry;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.HashAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

public class RequestorEntryWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(RequestorEntryWrapper.class);
    private RequestorEntry dbEntry;
    private CertWithDbId cert;
    private byte[] keyId;
    private char[] password;

    public void setDbEntry(RequestorEntry dbEntry, PasswordResolver passwordResolver) {
        this.dbEntry = (RequestorEntry)Args.notNull((Object)dbEntry, (String)"dbEntry");
        String type = dbEntry.getType();
        String conf = dbEntry.getConf();
        dbEntry.setFaulty(true);
        if ("cert".equalsIgnoreCase(type)) {
            try {
                X509Cert x509Cert = X509Util.parseCert((byte[])StringUtil.toUtf8Bytes((String)conf));
                dbEntry.setFaulty(false);
                this.cert = new CertWithDbId(x509Cert);
            }
            catch (CertificateException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("error while parsing certificate of requestor" + dbEntry.getIdent()));
            }
        } else if ("pbm".equalsIgnoreCase(type)) {
            try {
                this.keyId = HashAlgo.SHA1.hash((byte[][])new byte[][]{StringUtil.toUtf8Bytes((String)dbEntry.getIdent().getName())});
                this.password = passwordResolver.resolvePassword(conf);
                dbEntry.setFaulty(false);
            }
            catch (PasswordResolverException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("error while resolve password of requestor" + dbEntry.getIdent()));
            }
        }
    }

    public CertWithDbId getCert() {
        return this.cert;
    }

    public RequestorEntry getDbEntry() {
        return this.dbEntry;
    }

    public boolean matchKeyId(byte[] keyId) {
        return Arrays.equals(keyId, this.keyId);
    }

    public char[] getPassword() {
        return this.password;
    }
}

