/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.security.PublicKey;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditService;
import org.xipki.audit.AuditStatus;
import org.xipki.audit.Audits;
import org.xipki.ca.api.NameId;
import org.xipki.ca.server.CaInfo;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;

public abstract class X509CaModule {
    protected static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
    protected static final long MS_PER_SECOND = 1000L;
    protected static final long MS_PER_MINUTE = 60000L;
    protected static final long MS_PER_HOUR = 3600000L;
    protected static final int MINUTE_PER_DAY = 1440;
    protected static final long MS_PER_DAY = 86400000L;
    protected static final long MS_PER_WEEK = 604800000L;
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected final NameId caIdent;
    protected final CaInfo caInfo;
    protected final X509Cert caCert;

    public X509CaModule(CaInfo caInfo) {
        this.caInfo = (CaInfo)Args.notNull((Object)caInfo, (String)"caInfo");
        this.caIdent = caInfo.getIdent();
        this.caCert = caInfo.getCert();
    }

    protected static AuditService auditService() {
        return Audits.getAuditService();
    }

    protected AuditEvent newPerfAuditEvent(String eventType, String msgId) {
        return this.newAuditEvent("perf", eventType, msgId);
    }

    protected AuditEvent newAuditEvent(String name, String eventType, String msgId) {
        Args.notNull((Object)name, (String)"name");
        Args.notNull((Object)eventType, (String)"eventType");
        Args.notNull((Object)msgId, (String)"msgId");
        AuditEvent event = new AuditEvent(new Date());
        event.setApplicationName("ca");
        event.setName(name);
        event.addEventData("ca", (Object)this.caIdent.getName());
        event.addEventType(eventType);
        event.addEventData("mid", (Object)msgId);
        return event;
    }

    protected void finish(AuditEvent event, boolean successful) {
        event.finish();
        event.setLevel(successful ? AuditLevel.INFO : AuditLevel.ERROR);
        event.setStatus(successful ? AuditStatus.SUCCESSFUL : AuditStatus.FAILED);
        X509CaModule.auditService().logEvent(event);
    }

    protected boolean verifySignature(X509Cert cert) {
        Args.notNull((Object)cert, (String)"cert");
        PublicKey caPublicKey = this.caCert.getPublicKey();
        try {
            cert.verify(caPublicKey);
            return true;
        }
        catch (Exception ex) {
            this.LOG.debug("{} while verifying signature: {}", (Object)ex.getClass().getName(), (Object)ex.getMessage());
            return false;
        }
    }
}

