/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.OperationException;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.server.CaIdNameMap;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.CertRepublisher;
import org.xipki.ca.server.IdentifiedCertPublisher;
import org.xipki.ca.server.X509CaModule;
import org.xipki.ca.server.db.CertStore;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.HealthCheckResult;
import org.xipki.util.LogUtil;

class X509PublisherModule
extends X509CaModule {
    private final CertStore certstore;
    private final CaIdNameMap caIdNameMap;
    private final CaManagerImpl caManager;

    X509PublisherModule(CaManagerImpl caManager, CaInfo caInfo, CertStore certstore) {
        super(caInfo);
        this.caManager = (CaManagerImpl)Args.notNull((Object)caManager, (String)"caManager");
        this.caIdNameMap = caManager.idNameMap();
        this.certstore = (CertStore)Args.notNull((Object)certstore, (String)"certstore");
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            publisher.caAdded(this.caCert);
        }
    }

    boolean publishCert(CertificateInfo certInfo) {
        return this.publishCert0(certInfo) == 0;
    }

    int publishCert0(CertificateInfo certInfo) {
        Args.notNull((Object)certInfo, (String)"certInfo");
        if (certInfo.isAlreadyIssued()) {
            return 0;
        }
        if (!this.certstore.addCert(certInfo)) {
            return 1;
        }
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            if (!publisher.isAsyn()) {
                boolean successful;
                try {
                    successful = publisher.certificateAdded(certInfo);
                }
                catch (RuntimeException ex) {
                    successful = false;
                    LogUtil.warn((Logger)this.LOG, (Throwable)ex, (String)("could not publish certificate to the publisher " + publisher.getIdent()));
                }
                if (successful) continue;
            }
            Long certId = certInfo.getCert().getCertId();
            try {
                this.certstore.addToPublishQueue(publisher.getIdent(), certId, this.caIdent);
            }
            catch (Throwable th) {
                LogUtil.error((Logger)this.LOG, (Throwable)th, (String)"could not add entry to PublishQueue");
                return 2;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean republishCerts(List<String> publisherNames, int numThreads) {
        List<IdentifiedCertPublisher> publishers;
        if (publisherNames == null) {
            publishers = this.publishers();
        } else {
            publishers = new ArrayList<IdentifiedCertPublisher>(publisherNames.size());
            for (String publisherName : publisherNames) {
                Object publisher = null;
                for (IdentifiedCertPublisher p : this.publishers()) {
                    if (!p.getIdent().getName().equals(publisherName)) continue;
                    publisher = p;
                    break;
                }
                if (publisher == null) {
                    throw new IllegalArgumentException("could not find publisher " + publisherName + " for CA " + this.caIdent.getName());
                }
                publishers.add((IdentifiedCertPublisher)publisher);
            }
        }
        if (CollectionUtil.isEmpty(publishers)) {
            return true;
        }
        CaStatus status = this.caInfo.getStatus();
        this.caInfo.setStatus(CaStatus.INACTIVE);
        boolean onlyRevokedCerts = true;
        for (IdentifiedCertPublisher publisher : publishers) {
            if (publisher.publishsGoodCert()) {
                onlyRevokedCerts = false;
            }
            NameId publisherIdent = publisher.getIdent();
            String name = publisherIdent.getName();
            try {
                this.LOG.info("clearing PublishQueue for publisher {}", (Object)name);
                this.certstore.clearPublishQueue(this.caIdent, publisherIdent);
                this.LOG.info(" cleared PublishQueue for publisher {}", (Object)name);
            }
            catch (OperationException ex) {
                LogUtil.error((Logger)this.LOG, (Throwable)ex, (String)("could not clear PublishQueue for publisher " + name));
            }
        }
        try {
            for (IdentifiedCertPublisher publisher : publishers) {
                boolean successful = publisher.caAdded(this.caCert);
                if (successful) continue;
                this.LOG.error("republish CA certificate {} to publisher {} failed", (Object)this.caIdent.getName(), (Object)publisher.getIdent().getName());
                boolean bl = false;
                return bl;
            }
            if (this.caInfo.getRevocationInfo() != null) {
                for (IdentifiedCertPublisher publisher : publishers) {
                    boolean successful = publisher.caRevoked(this.caCert, this.caInfo.getRevocationInfo());
                    if (successful) continue;
                    this.LOG.error("republishing CA revocation to publisher {} failed", (Object)publisher.getIdent().getName());
                    boolean bl = false;
                    return bl;
                }
            }
            CertRepublisher republisher = new CertRepublisher(this.caIdent, this.caCert, this.caIdNameMap, this.certstore, publishers, onlyRevokedCerts, numThreads);
            boolean bl = republisher.republish();
            return bl;
        }
        finally {
            this.caInfo.setStatus(status);
        }
    }

    void clearPublishQueue(List<String> publisherNames) throws CaMgmtException {
        if (publisherNames == null) {
            try {
                this.certstore.clearPublishQueue(this.caIdent, null);
            }
            catch (OperationException ex) {
                throw new CaMgmtException("could not clear publish queue of CA " + this.caIdent + ": " + ex.getMessage(), (Throwable)ex);
            }
            return;
        }
        for (String publisherName : publisherNames) {
            NameId publisherIdent = this.caIdNameMap.getPublisher(publisherName);
            try {
                this.certstore.clearPublishQueue(this.caIdent, publisherIdent);
            }
            catch (OperationException ex) {
                throw new CaMgmtException("could not clear publish queue of CA " + this.caIdent + ": " + ex.getMessage() + " for publisher " + publisherName, (Throwable)ex);
            }
        }
    }

    boolean publishCertsInQueue() {
        boolean allSuccessful = true;
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            if (this.publishCertsInQueue(publisher)) continue;
            allSuccessful = false;
        }
        return allSuccessful;
    }

    boolean publishCertsInQueue(IdentifiedCertPublisher publisher) {
        Args.notNull((Object)publisher, (String)"publisher");
        int numEntries = 500;
        block6: while (true) {
            List<Long> certIds;
            try {
                certIds = this.certstore.getPublishQueueEntries(this.caIdent, publisher.getIdent(), 500);
            }
            catch (OperationException ex) {
                LogUtil.error((Logger)this.LOG, (Throwable)ex);
                return false;
            }
            if (CollectionUtil.isEmpty(certIds)) break;
            Iterator<Long> iterator = certIds.iterator();
            while (true) {
                CertificateInfo certInfo;
                if (!iterator.hasNext()) continue block6;
                Long certId = iterator.next();
                try {
                    certInfo = this.certstore.getCertForId(this.caIdent, this.caCert, certId, this.caIdNameMap);
                }
                catch (OperationException ex) {
                    LogUtil.error((Logger)this.LOG, (Throwable)ex);
                    return false;
                }
                boolean successful = publisher.certificateAdded(certInfo);
                if (!successful) {
                    this.LOG.error("republishing certificate id={} failed", (Object)certId);
                    return false;
                }
                try {
                    this.certstore.removeFromPublishQueue(publisher.getIdent(), certId);
                }
                catch (OperationException ex) {
                    LogUtil.warn((Logger)this.LOG, (Throwable)ex, (String)("could not remove republished cert id=" + certId + " and publisher=" + publisher.getIdent().getName()));
                }
            }
            break;
        }
        return true;
    }

    boolean publishCrl(X509CRLHolder crl) {
        try {
            this.certstore.addCrl(this.caIdent, crl);
        }
        catch (Exception ex) {
            this.LOG.error("could not add CRL ca={}, thisUpdate={}: {}, ", new Object[]{this.caIdent.getName(), crl.getThisUpdate(), ex.getMessage()});
            this.LOG.debug("Exception", (Throwable)ex);
            return false;
        }
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            try {
                publisher.crlAdded(this.caCert, crl);
            }
            catch (RuntimeException ex) {
                LogUtil.error((Logger)this.LOG, (Throwable)ex, (String)("could not publish CRL to the publisher " + publisher.getIdent()));
            }
        }
        return true;
    }

    boolean publishCertRemoved(CertWithDbId certToRemove) {
        boolean successful = true;
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            boolean singleSuccessful;
            try {
                singleSuccessful = publisher.certificateRemoved(this.caCert, certToRemove);
            }
            catch (RuntimeException ex) {
                singleSuccessful = false;
                LogUtil.warn((Logger)this.LOG, (Throwable)ex, (String)("could not remove certificate from the publisher " + publisher.getIdent()));
            }
            if (singleSuccessful) continue;
            successful = false;
            X509Cert cert = certToRemove.getCert();
            if (!this.LOG.isErrorEnabled()) continue;
            this.LOG.error("removing certificate issuer='{}', serial={}, subject='{}' from publisher {} failed.", new Object[]{cert.getIssuerRfc4519Text(), cert.getSerialNumberHex(), cert.getSubjectRfc4519Text(), publisher.getIdent()});
        }
        return successful;
    }

    void publishCertRevoked(CertWithRevocationInfo revokedCert) {
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            if (!publisher.isAsyn()) {
                boolean successful;
                try {
                    successful = publisher.certificateRevoked(this.caCert, revokedCert.getCert(), revokedCert.getCertprofile(), revokedCert.getRevInfo());
                }
                catch (RuntimeException ex) {
                    successful = false;
                    LogUtil.error((Logger)this.LOG, (Throwable)ex, (String)("could not publish revocation of certificate to the publisher " + publisher.getIdent()));
                }
                if (successful) continue;
            }
            Long certId = revokedCert.getCert().getCertId();
            try {
                this.certstore.addToPublishQueue(publisher.getIdent(), certId, this.caIdent);
            }
            catch (Throwable th) {
                LogUtil.error((Logger)this.LOG, (Throwable)th, (String)"could not add entry to PublishQueue");
            }
        }
    }

    void publishCertUnrevoked(CertWithDbId unrevokedCert) {
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            if (!publisher.isAsyn()) {
                boolean successful;
                try {
                    successful = publisher.certificateUnrevoked(this.caCert, unrevokedCert);
                }
                catch (RuntimeException ex) {
                    successful = false;
                    LogUtil.error((Logger)this.LOG, (Throwable)ex, (String)("could not publish unrevocation of certificate to the publisher " + publisher.getIdent().getName()));
                }
                if (successful) continue;
            }
            Long certId = unrevokedCert.getCertId();
            try {
                this.certstore.addToPublishQueue(publisher.getIdent(), certId, this.caIdent);
            }
            catch (Throwable th) {
                LogUtil.error((Logger)this.LOG, (Throwable)th, (String)"could not add entry to PublishQueue");
            }
        }
    }

    boolean publishCaRevoked(CertRevocationInfo revocationInfo) {
        boolean succ = true;
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            NameId ident = publisher.getIdent();
            boolean successful = publisher.caRevoked(this.caCert, revocationInfo);
            if (successful) {
                this.LOG.info("published event caUnrevoked of CA {} to publisher {}", (Object)this.caIdent.getName(), (Object)ident.getName());
                continue;
            }
            succ = false;
            this.LOG.error("could not publish event caUnrevoked of CA {} to publisher {}", (Object)this.caIdent.getName(), (Object)ident.getName());
        }
        return succ;
    }

    boolean publishCaUnrevoked() {
        boolean succ = true;
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            NameId ident = publisher.getIdent();
            boolean successful = publisher.caUnrevoked(this.caCert);
            if (successful) {
                this.LOG.info("published event caUnrevoked of CA {} to publisher {}", (Object)this.caIdent.getName(), (Object)ident.getName());
                continue;
            }
            succ = false;
            this.LOG.error("could not publish event caUnrevoked of CA {} to publisher {}", (Object)this.caIdent.getName(), (Object)ident.getName());
        }
        return succ;
    }

    boolean healthCheck(HealthCheckResult parentResult) {
        boolean healthy = true;
        for (IdentifiedCertPublisher publisher : this.publishers()) {
            boolean ph = publisher.isHealthy();
            healthy &= ph;
            HealthCheckResult publisherHealth = new HealthCheckResult();
            publisherHealth.setName("Publisher");
            publisherHealth.setHealthy(publisher.isHealthy());
            parentResult.addChildCheck(publisherHealth);
        }
        return healthy;
    }

    private List<IdentifiedCertPublisher> publishers() {
        return this.caManager.getIdentifiedPublishersForCa(this.caIdent.getName());
    }
}

