/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.cmp;

import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CMPObjectIdentifiers;
import org.bouncycastle.asn1.cmp.CertConfirmContent;
import org.bouncycastle.asn1.cmp.CertRepMessage;
import org.bouncycastle.asn1.cmp.CertResponse;
import org.bouncycastle.asn1.cmp.CertStatus;
import org.bouncycastle.asn1.cmp.ErrorMsgContent;
import org.bouncycastle.asn1.cmp.GenMsgContent;
import org.bouncycastle.asn1.cmp.GenRepContent;
import org.bouncycastle.asn1.cmp.InfoTypeAndValue;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIFailureInfo;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIHeaderBuilder;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.cmp.PKIStatus;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.cmp.RevDetails;
import org.bouncycastle.asn1.cmp.RevRepContentBuilder;
import org.bouncycastle.asn1.cmp.RevReqContent;
import org.bouncycastle.asn1.crmf.AttributeTypeAndValue;
import org.bouncycastle.asn1.crmf.CertId;
import org.bouncycastle.asn1.crmf.CertReqMessages;
import org.bouncycastle.asn1.crmf.CertReqMsg;
import org.bouncycastle.asn1.crmf.CertTemplate;
import org.bouncycastle.asn1.crmf.Controls;
import org.bouncycastle.asn1.crmf.OptionalValidity;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.crmf.CertificateRequestMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditStatus;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.InsufficientPermissionException;
import org.xipki.ca.api.OperationException;
import org.xipki.ca.api.RequestType;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.api.mgmt.CmpControl;
import org.xipki.ca.api.mgmt.PermissionConstants;
import org.xipki.ca.api.mgmt.RequestorInfo;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.CertTemplateData;
import org.xipki.ca.server.X509Ca;
import org.xipki.ca.server.cmp.BaseCmpResponder;
import org.xipki.ca.server.cmp.PendingCertificatePool;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.security.CrlReason;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.X509Cert;
import org.xipki.security.cmp.CmpUtf8Pairs;
import org.xipki.security.cmp.CmpUtil;
import org.xipki.util.CollectionUtil;
import org.xipki.util.DateUtil;
import org.xipki.util.Hex;
import org.xipki.util.LogUtil;

public class CmpResponder
extends BaseCmpResponder {
    private static final Logger LOG = LoggerFactory.getLogger(BaseCmpResponder.class);
    private final PendingCertificatePool pendingCertPool = new PendingCertificatePool();

    public CmpResponder(CaManagerImpl caManager, String caName) throws NoSuchAlgorithmException {
        super(caManager, caName);
        caManager.getScheduledThreadPoolExecutor().scheduleAtFixedRate(new PendingPoolCleaner(), 10L, 10L, TimeUnit.MINUTES);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CertRepMessage processCertReqMessages(String dfltCertprofileName, Boolean dfltCaGenKeypair, PKIMessage request, RequestorInfo.CmpRequestorInfo requestor, ASN1OctetString tid, CertReqMessages cr, boolean allowKeyGen, CmpControl cmpControl, String msgId, AuditEvent event) throws InsufficientPermissionException {
        CertReqMsg[] certReqMsgs = cr.toCertReqMsgArray();
        int n = certReqMsgs.length;
        ArrayList<CertTemplateData> certTemplateDatas = new ArrayList<CertTemplateData>(n);
        ArrayList<CertResponse> resps = new ArrayList<CertResponse>(1);
        boolean kup = request.getBody().getType() == 7;
        int i = 0;
        while (true) {
            block32: {
                boolean caGenerateKeypair;
                String certprofileName;
                Extensions extensions;
                X500Name subject;
                SubjectPublicKeyInfo publicKey;
                CertTemplate certTemp;
                ASN1Integer certReqId;
                block46: {
                    block47: {
                        block48: {
                            block44: {
                                CertificateRequestMessage req;
                                block45: {
                                    block43: {
                                        block37: {
                                            ASN1ObjectIdentifier[] oldOids;
                                            CertWithRevocationInfo oldCert;
                                            block42: {
                                                block41: {
                                                    BigInteger serialNumber;
                                                    X500Name issuer;
                                                    block40: {
                                                        CertId oldCertId;
                                                        block39: {
                                                            AttributeTypeAndValue oldCertIdAtv;
                                                            block38: {
                                                                block35: {
                                                                    int seqSize;
                                                                    ASN1Sequence seq;
                                                                    block36: {
                                                                        block33: {
                                                                            block34: {
                                                                                String tmpStr;
                                                                                if (i >= n || cmpControl.isGroupEnroll() && certTemplateDatas.size() != i) break block33;
                                                                                CertReqMsg reqMsg = certReqMsgs[i];
                                                                                certReqId = reqMsg.getCertReq().getCertReqId();
                                                                                req = new CertificateRequestMessage(reqMsg);
                                                                                certTemp = req.getCertTemplate();
                                                                                CmpUtf8Pairs keyvalues = CmpUtil.extract((AttributeTypeAndValue[])reqMsg.getRegInfo());
                                                                                publicKey = certTemp.getPublicKey();
                                                                                subject = certTemp.getSubject();
                                                                                extensions = certTemp.getExtensions();
                                                                                String string = certprofileName = keyvalues == null ? null : keyvalues.value("certprofile");
                                                                                if (certprofileName == null) {
                                                                                    certprofileName = dfltCertprofileName;
                                                                                }
                                                                                if (certprofileName != null) {
                                                                                    certprofileName = certprofileName.toLowerCase();
                                                                                }
                                                                                String string2 = tmpStr = keyvalues == null ? null : keyvalues.value("ca-generate-keypair");
                                                                                if (dfltCaGenKeypair == null) {
                                                                                    caGenerateKeypair = "true".equalsIgnoreCase(tmpStr);
                                                                                } else {
                                                                                    boolean bl = caGenerateKeypair = tmpStr == null ? dfltCaGenKeypair.booleanValue() : "true".equalsIgnoreCase(tmpStr);
                                                                                }
                                                                                if (!kup) break block34;
                                                                                Controls controls = reqMsg.getCertReq().getControls();
                                                                                oldCertIdAtv = null;
                                                                                if (controls == null) break block35;
                                                                                try {
                                                                                    seq = ASN1Sequence.getInstance((Object)controls.getEncoded());
                                                                                }
                                                                                catch (IOException ex) {
                                                                                    CmpResponder.addErrCertResp(resps, certReqId, 0x40000000, "could not parse the controls");
                                                                                    break block32;
                                                                                }
                                                                                seqSize = seq.size();
                                                                                break block36;
                                                                            }
                                                                            if (certprofileName != null) break block37;
                                                                            LOG.warn("no certprofile is specified");
                                                                            CmpResponder.addErrCertResp(resps, certReqId, 0x100000, "no certificate profile");
                                                                            break block32;
                                                                        }
                                                                        if (resps.size() == n) {
                                                                            CertResponse[] certResps = new CertResponse[n];
                                                                            int i2 = 0;
                                                                            while (true) {
                                                                                if (i2 >= n) {
                                                                                    event.setStatus(AuditStatus.FAILED);
                                                                                    return new CertRepMessage(null, certResps);
                                                                                }
                                                                                certResps[i2] = (CertResponse)resps.get(i2);
                                                                                ++i2;
                                                                            }
                                                                        }
                                                                        if (cmpControl.isGroupEnroll() && certTemplateDatas.size() != n) break;
                                                                        List<CertResponse> generateCertResponses = this.generateCertificates(certTemplateDatas, requestor, tid, kup, request, cmpControl, msgId, event);
                                                                        CertResponse[] certResps = new CertResponse[n];
                                                                        int index = 0;
                                                                        for (CertResponse errorResp : resps) {
                                                                            certResps[index++] = errorResp;
                                                                        }
                                                                        for (CertResponse certResp : generateCertResponses) {
                                                                            certResps[index++] = certResp;
                                                                        }
                                                                        CMPCertificate[] caPubs = null;
                                                                        if (cmpControl.isSendCaCert() || cmpControl.isSendCertChain()) {
                                                                            boolean anyCertEnrolled = false;
                                                                            for (CertResponse certResp : generateCertResponses) {
                                                                                if (certResp.getCertifiedKeyPair() == null) continue;
                                                                                anyCertEnrolled = true;
                                                                                break;
                                                                            }
                                                                            if (anyCertEnrolled) {
                                                                                ArrayList<CMPCertificate> certchain = new ArrayList<CMPCertificate>(2);
                                                                                certchain.add(this.getCa().getCaInfo().getCertInCmpFormat());
                                                                                if (cmpControl.isSendCertChain()) {
                                                                                    certchain.addAll(this.getCa().getCaInfo().getCertchainInCmpFormat());
                                                                                }
                                                                                caPubs = certchain.toArray(new CMPCertificate[0]);
                                                                            }
                                                                        }
                                                                        return new CertRepMessage(caPubs, certResps);
                                                                    }
                                                                    for (int j = 0; j < seqSize; ++j) {
                                                                        AttributeTypeAndValue atv = AttributeTypeAndValue.getInstance((Object)seq.getObjectAt(j));
                                                                        if (!atv.getType().equals((ASN1Primitive)CMPObjectIdentifiers.regCtrl_oldCertID)) continue;
                                                                        oldCertIdAtv = atv;
                                                                        break;
                                                                    }
                                                                }
                                                                if (oldCertIdAtv != null) break block38;
                                                                CmpResponder.addErrCertResp(resps, certReqId, 0x100000, "no getCtrl oldCertID is specified");
                                                                break block32;
                                                            }
                                                            oldCertId = CertId.getInstance((Object)oldCertIdAtv.getValue());
                                                            if (4 == oldCertId.getIssuer().getTagNo()) break block39;
                                                            CmpResponder.addErrCertResp(resps, certReqId, 8, "invalid regCtrl oldCertID");
                                                            break block32;
                                                        }
                                                        issuer = X500Name.getInstance((Object)oldCertId.getIssuer().getName());
                                                        serialNumber = oldCertId.getSerialNumber().getValue();
                                                        try {
                                                            oldCert = this.caManager.getCert(issuer, serialNumber);
                                                        }
                                                        catch (CaMgmtException ex) {
                                                            CmpResponder.addErrCertResp(resps, certReqId, 0x40000000, "error while finding certificate with the issuer " + issuer + "and serial number " + serialNumber);
                                                            break block32;
                                                        }
                                                        if (oldCert != null) break block40;
                                                        CmpResponder.addErrCertResp(resps, certReqId, 8, "found no certificate with the issuer " + issuer + "and serial number " + serialNumber);
                                                        break block32;
                                                    }
                                                    if (!oldCert.isRevoked()) break block41;
                                                    CmpResponder.addErrCertResp(resps, certReqId, 8192, "could not update a revoked certificate with the issuer " + issuer + "and serial number " + serialNumber);
                                                    break block32;
                                                }
                                                if (certprofileName == null) {
                                                    certprofileName = oldCert.getCertprofile();
                                                }
                                                if (certprofileName != null) break block42;
                                                LOG.warn("no certprofile is specified");
                                                CmpResponder.addErrCertResp(resps, certReqId, 0x100000, "no certificate profile");
                                                break block32;
                                            }
                                            if (subject == null) {
                                                subject = oldCert.getCert().getCert().getSubject();
                                            }
                                            if (publicKey == null && !caGenerateKeypair) {
                                                publicKey = oldCert.getCert().getCert().getSubjectPublicKeyInfo();
                                            }
                                            HashMap<String, Extension> extns = new HashMap<String, Extension>();
                                            if (extensions != null) {
                                                ASN1ObjectIdentifier[] oids;
                                                for (ASN1ObjectIdentifier oid : oids = extensions.getExtensionOIDs()) {
                                                    extns.put(oid.getId(), extensions.getExtension(oid));
                                                }
                                            }
                                            Extensions oldExtensions = oldCert.getCert().getCert().toBcCert().getExtensions();
                                            for (ASN1ObjectIdentifier oid : oldOids = oldExtensions.getExtensionOIDs()) {
                                                String id = oid.getId();
                                                if (extns.containsKey(id) || kupCertExtnIds.contains(id)) continue;
                                                extns.put(id, oldExtensions.getExtension(oid));
                                            }
                                            extensions = new Extensions(extns.values().toArray(new Extension[0]));
                                        }
                                        if (requestor.isCertprofilePermitted(certprofileName)) break block43;
                                        CmpResponder.addErrCertResp(resps, certReqId, 65536, "certprofile " + certprofileName + " is not allowed");
                                        break block32;
                                    }
                                    if (publicKey == null) break block44;
                                    if (req.hasProofOfPossession()) break block45;
                                    CmpResponder.addErrCertResp(resps, certReqId, 16384, "no POP");
                                    break block32;
                                }
                                if (this.verifyPopo(req, publicKey, requestor.isRa())) break block46;
                                LOG.warn("could not validate POP for request {}", (Object)certReqId.getValue());
                                CmpResponder.addErrCertResp(resps, certReqId, 16384, "invalid POP");
                                break block32;
                            }
                            if (!caGenerateKeypair) break block47;
                            if (!allowKeyGen) break block48;
                            this.checkPermission(requestor, 256);
                            break block46;
                        }
                        LOG.warn("no public key is specified and key generation is not allowed {}", (Object)certReqId.getValue());
                        CmpResponder.addErrCertResp(resps, certReqId, 0x100000, "no public key");
                        break block32;
                    }
                    LOG.warn("no public key is specified {}", (Object)certReqId.getValue());
                    CmpResponder.addErrCertResp(resps, certReqId, 0x100000, "no public key");
                    break block32;
                }
                OptionalValidity validity = certTemp.getValidity();
                Date notBefore = null;
                Date notAfter = null;
                if (validity != null) {
                    Time time = validity.getNotBefore();
                    if (time != null) {
                        notBefore = time.getDate();
                    }
                    if ((time = validity.getNotAfter()) != null) {
                        notAfter = time.getDate();
                    }
                }
                certTemplateDatas.add(new CertTemplateData(subject, publicKey, notBefore, notAfter, extensions, certprofileName, certReqId, caGenerateKeypair));
            }
            ++i;
        }
        event.setStatus(AuditStatus.FAILED);
        int lastFailureIndex = certTemplateDatas.size();
        BigInteger failCertReqId = certReqMsgs[lastFailureIndex].getCertReq().getCertReqId().getValue();
        CertResponse failCertResp = (CertResponse)resps.get(lastFailureIndex);
        Iterator<Object> failStatus = PKIStatus.getInstance((Object)new ASN1Integer(failCertResp.getStatus().getStatus()));
        PKIFailureInfo failureInfo = new PKIFailureInfo(failCertResp.getStatus().getFailInfo());
        CertResponse[] certResps = new CertResponse[n];
        int i3 = 0;
        while (i3 < n) {
            if (i3 == lastFailureIndex) {
                certResps[i3] = failCertResp;
            } else {
                PKIStatusInfo tmpStatus = CmpResponder.generateRejectionStatus(failStatus, failureInfo.intValue(), "error in certReq " + failCertReqId);
                certResps[i3] = new CertResponse(certResps[i3].getCertReqId(), tmpStatus);
            }
            ++i3;
        }
        return new CertRepMessage(null, certResps);
    }

    private PKIBody processP10cr(String dfltCertprofileName, PKIMessage request, RequestorInfo.CmpRequestorInfo requestor, ASN1OctetString tid, PKIHeader reqHeader, CertificationRequest p10cr, CmpControl cmpControl, String msgId, AuditEvent event) {
        int status;
        CertResponse certResp = null;
        ASN1Integer certReqId = new ASN1Integer(-1L);
        boolean certGenerated = false;
        X509Ca ca = this.getCa();
        if (!ca.verifyCsr(p10cr)) {
            LOG.warn("could not validate POP for the pkcs#10 requst");
            certResp = CmpResponder.buildErrCertResp(certReqId, 16384, "invalid POP");
        } else {
            Extensions extensions;
            CertificationRequestInfo certTemp = p10cr.getCertificationRequestInfo();
            try {
                extensions = CaUtil.getExtensions(certTemp);
            }
            catch (IllegalArgumentException ex) {
                extensions = null;
                LOG.warn("could not parse extensions of the pkcs#10 requst");
                certResp = CmpResponder.buildErrCertResp(certReqId, 0x100000, "invalid extensions");
            }
            if (certResp == null) {
                X500Name subject = certTemp.getSubject();
                SubjectPublicKeyInfo publicKeyInfo = certTemp.getSubjectPublicKeyInfo();
                CmpUtf8Pairs keyvalues = CmpUtil.extract((InfoTypeAndValue[])reqHeader.getGeneralInfo());
                Date notBefore = null;
                Date notAfter = null;
                String certprofileName = null;
                if (keyvalues != null) {
                    certprofileName = keyvalues.value("certprofile");
                    String str = keyvalues.value("notbefore");
                    if (str != null) {
                        notBefore = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)str);
                    }
                    if ((str = keyvalues.value("notafter")) != null) {
                        notAfter = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)str);
                    }
                }
                if (certprofileName == null) {
                    certprofileName = dfltCertprofileName;
                }
                if (certprofileName == null) {
                    LOG.warn("no certprofile is specified");
                    certResp = CmpResponder.buildErrCertResp(certReqId, 0x100000, "badCertTemplate");
                } else if (!requestor.isCertprofilePermitted(certprofileName = certprofileName.toLowerCase())) {
                    String msg = "certprofile " + certprofileName + " is not allowed";
                    certResp = CmpResponder.buildErrCertResp(certReqId, 65536, msg);
                } else {
                    CertTemplateData certTemplateData = new CertTemplateData(subject, publicKeyInfo, notBefore, notAfter, extensions, certprofileName, certReqId, false);
                    certResp = this.generateCertificates(Collections.singletonList(certTemplateData), requestor, tid, false, request, cmpControl, msgId, event).get(0);
                    certGenerated = true;
                }
            }
        }
        CMPCertificate[] caPubs = null;
        if (certGenerated && (cmpControl.isSendCaCert() || cmpControl.isSendCertChain())) {
            ArrayList<CMPCertificate> certchain = new ArrayList<CMPCertificate>(2);
            certchain.add(this.getCa().getCaInfo().getCertInCmpFormat());
            if (cmpControl.isSendCertChain()) {
                certchain.addAll(this.getCa().getCaInfo().getCertchainInCmpFormat());
            }
            caPubs = certchain.toArray(new CMPCertificate[0]);
        }
        if ((event.getStatus() == null || event.getStatus() != AuditStatus.FAILED) && (status = certResp.getStatus().getStatus().intValue()) != 0 && status != 1 && status != 3) {
            event.setStatus(AuditStatus.FAILED);
            PKIFreeText statusStr = certResp.getStatus().getStatusString();
            if (statusStr != null) {
                event.addEventData("message", (Object)statusStr.getStringAt(0).getString());
            }
        }
        return new PKIBody(3, (ASN1Encodable)new CertRepMessage(caPubs, new CertResponse[]{certResp}));
    }

    private List<CertResponse> generateCertificates(List<CertTemplateData> certTemplates, RequestorInfo.CmpRequestorInfo requestor, ASN1OctetString tid, boolean kup, PKIMessage request, CmpControl cmpControl, String msgId, AuditEvent event) {
        X509Ca ca = this.getCa();
        int n = certTemplates.size();
        ArrayList<CertResponse> ret = new ArrayList<CertResponse>(n);
        if (cmpControl.isGroupEnroll()) {
            List<CertificateInfo> certInfos = null;
            try {
                certInfos = kup ? ca.regenerateCerts(certTemplates, (RequestorInfo)requestor, RequestType.CMP, tid.getOctets(), msgId) : ca.generateCerts(certTemplates, (RequestorInfo)requestor, RequestType.CMP, tid.getOctets(), msgId);
                Long reqDbId = null;
                if (ca.getCaInfo().isSaveRequest()) {
                    try {
                        reqDbId = ca.addRequest(request.getEncoded());
                    }
                    catch (Exception ex) {
                        LOG.warn("could not save request");
                    }
                }
                for (int i = 0; i < n; ++i) {
                    CertificateInfo certInfo = certInfos.get(i);
                    ASN1Integer certReqId = certTemplates.get(i).getCertReqId();
                    if (cmpControl.isConfirmCert()) {
                        this.pendingCertPool.addCertificate(tid.getOctets(), certReqId.getPositiveValue(), certInfo, System.currentTimeMillis() + cmpControl.getConfirmWaitTimeMs());
                    }
                    ret.add(this.postProcessCertInfo(certReqId, requestor, certInfo));
                    if (reqDbId == null) continue;
                    ca.addRequestCert(reqDbId, certInfo.getCert().getCertId());
                }
            }
            catch (OperationException ex) {
                if (certInfos != null) {
                    for (CertificateInfo certInfo : certInfos) {
                        BigInteger sn = certInfo.getCert().getCert().getSerialNumber();
                        try {
                            ca.revokeCert(sn, CrlReason.CESSATION_OF_OPERATION, null, msgId);
                        }
                        catch (OperationException ex2) {
                            LogUtil.error((Logger)LOG, (Throwable)ex2, (String)("CA " + this.getCaName() + " could not revoke certificate " + sn));
                        }
                    }
                }
                event.setStatus(AuditStatus.FAILED);
                ret.clear();
                for (CertTemplateData certTemplate : certTemplates) {
                    ret.add(CmpResponder.postProcessException(certTemplate.getCertReqId(), ex));
                }
            }
        } else {
            Long reqDbId = null;
            boolean savingRequestFailed = false;
            for (CertTemplateData certTemplate : certTemplates) {
                ASN1Integer certReqId = certTemplate.getCertReqId();
                try {
                    CertificateInfo certInfo;
                    CertificateInfo certificateInfo = certInfo = kup ? ca.regenerateCert(certTemplate, (RequestorInfo)requestor, RequestType.CMP, tid.getOctets(), msgId) : ca.generateCert(certTemplate, (RequestorInfo)requestor, RequestType.CMP, tid.getOctets(), msgId);
                    if (ca.getCaInfo().isSaveRequest()) {
                        if (reqDbId == null && !savingRequestFailed) {
                            try {
                                byte[] encodedRequest = request.getEncoded();
                                reqDbId = ca.addRequest(encodedRequest);
                            }
                            catch (Exception ex) {
                                savingRequestFailed = true;
                                LOG.warn("could not save request");
                            }
                        }
                        if (reqDbId != null) {
                            ca.addRequestCert(reqDbId, certInfo.getCert().getCertId());
                        }
                    }
                    ret.add(this.postProcessCertInfo(certReqId, requestor, certInfo));
                }
                catch (OperationException ex) {
                    event.setStatus(AuditStatus.FAILED);
                    ret.add(CmpResponder.postProcessException(certReqId, ex));
                }
            }
        }
        return ret;
    }

    private PKIBody unRevokeRemoveCertificates(PKIMessage request, RevReqContent rr, int permission, CmpControl cmpControl, String msgId, AuditEvent event) {
        RevDetails[] revContent = rr.toRevDetailsArray();
        RevRepContentBuilder repContentBuilder = new RevRepContentBuilder();
        for (RevDetails revDetails : revContent) {
            CertTemplate certDetails = revDetails.getCertDetails();
            X500Name issuer = certDetails.getIssuer();
            ASN1Integer serialNumber = certDetails.getSerialNumber();
            try {
                BigInteger caSerial;
                Extension ext;
                X500Name caSubject = this.getCa().getCaInfo().getCert().getSubject();
                if (issuer == null) {
                    return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "issuer is not present");
                }
                if (!issuer.equals((Object)caSubject)) {
                    return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "issuer does not target at the CA");
                }
                if (serialNumber == null) {
                    return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "serialNumber is not present");
                }
                if (certDetails.getSigningAlg() != null || certDetails.getValidity() != null || certDetails.getSubject() != null || certDetails.getPublicKey() != null || certDetails.getIssuerUID() != null || certDetails.getSubjectUID() != null) {
                    return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "only version, issuer and serialNumber in RevDetails.certDetails are allowed, but more is specified");
                }
                if (certDetails.getExtensions() == null) {
                    if (!cmpControl.isRrAkiRequired()) continue;
                    return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "issuer's AKI not present");
                }
                Extensions exts = certDetails.getExtensions();
                ASN1ObjectIdentifier[] oids = exts.getCriticalExtensionOIDs();
                if (oids != null) {
                    for (ASN1ObjectIdentifier oid : oids) {
                        if (Extension.authorityKeyIdentifier.equals((ASN1Primitive)oid)) continue;
                        return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "unknown critical extension " + oid.getId());
                    }
                }
                if ((ext = exts.getExtension(Extension.authorityKeyIdentifier)) == null) {
                    return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "issuer's AKI not present");
                }
                AuthorityKeyIdentifier aki = AuthorityKeyIdentifier.getInstance((Object)ext.getParsedValue());
                if (aki.getKeyIdentifier() == null) {
                    return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "issuer's AKI not present");
                }
                boolean issuerMatched = true;
                byte[] caSki = this.getCa().getCaInfo().getCert().getSubjectKeyId();
                if (!Arrays.equals(caSki, aki.getKeyIdentifier())) {
                    issuerMatched = false;
                }
                if (issuerMatched && aki.getAuthorityCertSerialNumber() != null && !(caSerial = this.getCa().getCaInfo().getSerialNumber()).equals(aki.getAuthorityCertSerialNumber())) {
                    issuerMatched = false;
                }
                if (issuerMatched && aki.getAuthorityCertIssuer() != null) {
                    GeneralName[] names;
                    for (GeneralName name : names = aki.getAuthorityCertIssuer().getNames()) {
                        if (name.getTagNo() != 4) {
                            issuerMatched = false;
                            break;
                        }
                        if (caSubject.equals((Object)name.getName())) continue;
                        issuerMatched = false;
                        break;
                    }
                }
                if (issuerMatched) continue;
                return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "issuer does not target at the CA");
            }
            catch (IllegalArgumentException ex) {
                return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 32, "the request is not invalid");
            }
        }
        byte[] encodedRequest = null;
        if (this.getCa().getCaInfo().isSaveRequest()) {
            try {
                encodedRequest = request.getEncoded();
            }
            catch (IOException ex) {
                LOG.warn("could not encode request");
            }
        }
        Long reqDbId = null;
        for (RevDetails revDetails : revContent) {
            PKIStatusInfo status;
            CertTemplate certDetails = revDetails.getCertDetails();
            ASN1Integer serialNumber = certDetails.getSerialNumber();
            X500Name caSubject = this.getCa().getCaInfo().getCert().getSubject();
            BigInteger snBigInt = serialNumber.getPositiveValue();
            CertId certId = new CertId(new GeneralName(caSubject), serialNumber);
            try {
                CertWithDbId returnedObj;
                Long certDbId = null;
                X509Ca ca = this.getCa();
                if (4 == permission) {
                    returnedObj = ca.unrevokeCert(snBigInt, msgId);
                    if (returnedObj != null) {
                        certDbId = returnedObj.getCertId();
                    }
                } else if (8 == permission) {
                    returnedObj = ca.removeCert(snBigInt, msgId);
                } else {
                    Date invalidityDate = null;
                    CrlReason reason = null;
                    Extensions crlDetails = revDetails.getCrlEntryDetails();
                    if (crlDetails != null) {
                        ASN1ObjectIdentifier extId = Extension.reasonCode;
                        ASN1Encodable extValue = crlDetails.getExtensionParsedValue(extId);
                        if (extValue != null) {
                            int reasonCode = ASN1Enumerated.getInstance((Object)extValue).getValue().intValue();
                            reason = CrlReason.forReasonCode((int)reasonCode);
                        }
                        if ((extValue = crlDetails.getExtensionParsedValue(extId = Extension.invalidityDate)) != null) {
                            try {
                                invalidityDate = ASN1GeneralizedTime.getInstance((Object)extValue).getDate();
                            }
                            catch (ParseException ex) {
                                throw new OperationException(OperationException.ErrorCode.INVALID_EXTENSION, "invalid extension " + extId.getId());
                            }
                        }
                    }
                    if (reason == null) {
                        reason = CrlReason.UNSPECIFIED;
                    }
                    if ((returnedObj = ca.revokeCert(snBigInt, reason, invalidityDate, msgId)) != null) {
                        certDbId = ((CertWithRevocationInfo)returnedObj).getCert().getCertId();
                    }
                }
                if (returnedObj == null) {
                    throw new OperationException(OperationException.ErrorCode.UNKNOWN_CERT, "cert not exists");
                }
                if (certDbId != null && ca.getCaInfo().isSaveRequest()) {
                    if (reqDbId == null) {
                        reqDbId = ca.addRequest(encodedRequest);
                    }
                    ca.addRequestCert(reqDbId, certDbId);
                }
                status = new PKIStatusInfo(PKIStatus.granted);
            }
            catch (OperationException ex) {
                OperationException.ErrorCode code = ex.getErrorCode();
                LOG.warn("{}, OperationException: code={}, message={}", new Object[]{PermissionConstants.getTextForCode((int)permission), code.name(), ex.getErrorMessage()});
                String errorMsg = code == OperationException.ErrorCode.DATABASE_FAILURE || code == OperationException.ErrorCode.SYSTEM_FAILURE ? code.name() : code.name() + ": " + ex.getErrorMessage();
                int failureInfo = CmpResponder.getPKiFailureInfo(ex);
                status = CmpResponder.generateRejectionStatus(failureInfo, errorMsg);
                event.update(AuditLevel.ERROR, AuditStatus.FAILED);
                event.addEventData("message", (Object)errorMsg);
            }
            repContentBuilder.add(status, certId);
        }
        return new PKIBody(12, (ASN1Encodable)repContentBuilder.build());
    }

    @Override
    protected PKIBody confirmCertificates(ASN1OctetString transactionId, CertConfirmContent certConf, String msgId) {
        CertStatus[] certStatuses = certConf.toCertStatusArray();
        boolean successful = true;
        for (CertStatus certStatus : certStatuses) {
            int status;
            ASN1Integer certReqId = certStatus.getCertReqId();
            byte[] certHash = certStatus.getCertHash().getOctets();
            CertificateInfo certInfo = this.pendingCertPool.removeCertificate(transactionId.getOctets(), certReqId.getPositiveValue(), certHash);
            if (certInfo == null) {
                LOG.warn("no cert under transactionId={}, certReqId={} and certHash=0X{}", new Object[]{transactionId, certReqId.getPositiveValue(), Hex.encode((byte[])certHash)});
                continue;
            }
            PKIStatusInfo statusInfo = certStatus.getStatusInfo();
            boolean accept = true;
            if (statusInfo != null && 0 != (status = statusInfo.getStatus().intValue()) && 1 != status) {
                accept = false;
            }
            if (accept) continue;
            BigInteger serialNumber = certInfo.getCert().getCert().getSerialNumber();
            X509Ca ca = this.getCa();
            try {
                ca.revokeCert(serialNumber, CrlReason.CESSATION_OF_OPERATION, new Date(), msgId);
            }
            catch (OperationException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("could not revoke certificate ca=" + ca.getCaInfo().getIdent() + " serialNumber=" + LogUtil.formatCsn((BigInteger)serialNumber)));
            }
            successful = false;
        }
        if (this.revokePendingCertificates(transactionId, msgId)) {
            successful = false;
        }
        if (successful) {
            return new PKIBody(19, (ASN1Encodable)DERNull.INSTANCE);
        }
        return new PKIBody(23, (ASN1Encodable)new ErrorMsgContent(new PKIStatusInfo(PKIStatus.rejection, null, new PKIFailureInfo(0x40000000))));
    }

    @Override
    protected boolean revokePendingCertificates(ASN1OctetString transactionId, String msgId) {
        Set<CertificateInfo> remainingCerts = this.pendingCertPool.removeCertificates(transactionId.getOctets());
        if (CollectionUtil.isEmpty(remainingCerts)) {
            return true;
        }
        boolean successful = true;
        Date invalidityDate = new Date();
        X509Ca ca = this.getCa();
        for (CertificateInfo remainingCert : remainingCerts) {
            try {
                ca.revokeCert(remainingCert.getCert().getCert().getSerialNumber(), CrlReason.CESSATION_OF_OPERATION, invalidityDate, msgId);
            }
            catch (OperationException ex) {
                successful = false;
            }
        }
        return successful;
    }

    @Override
    protected PKIBody cmpEnrollCert(String dfltCertprofileName, Boolean dfltCaGenKeypair, PKIMessage request, PKIHeaderBuilder respHeader, CmpControl cmpControl, PKIHeader reqHeader, PKIBody reqBody, RequestorInfo.CmpRequestorInfo requestor, ASN1OctetString tid, String msgId, AuditEvent event) throws InsufficientPermissionException {
        InfoTypeAndValue tv;
        PKIBody respBody;
        long confirmWaitTime = cmpControl.getConfirmWaitTime();
        if (confirmWaitTime < 0L) {
            confirmWaitTime *= -1L;
        }
        confirmWaitTime *= 1000L;
        int type = reqBody.getType();
        if (type == 0) {
            this.checkPermission(requestor, 1);
            CertReqMessages cr = CertReqMessages.getInstance((Object)reqBody.getContent());
            CertRepMessage repMessage = this.processCertReqMessages(dfltCertprofileName, dfltCaGenKeypair, request, requestor, tid, cr, true, cmpControl, msgId, event);
            return new PKIBody(1, (ASN1Encodable)repMessage);
        }
        if (type == 2) {
            this.checkPermission(requestor, 1);
            CertReqMessages cr = CertReqMessages.getInstance((Object)reqBody.getContent());
            CertRepMessage repMessage = this.processCertReqMessages(dfltCertprofileName, dfltCaGenKeypair, request, requestor, tid, cr, true, cmpControl, msgId, event);
            respBody = new PKIBody(3, (ASN1Encodable)repMessage);
        } else {
            if (type == 7) {
                this.checkPermission(requestor, 16);
                CertReqMessages kur = CertReqMessages.getInstance((Object)reqBody.getContent());
                CertRepMessage repMessage = this.processCertReqMessages(dfltCertprofileName, dfltCaGenKeypair, request, requestor, tid, kur, true, cmpControl, msgId, event);
                return new PKIBody(8, (ASN1Encodable)repMessage);
            }
            if (type == 4) {
                this.checkPermission(requestor, 1);
                respBody = this.processP10cr(dfltCertprofileName, request, requestor, tid, reqHeader, CertificationRequest.getInstance((Object)reqBody.getContent()), cmpControl, msgId, event);
            } else {
                if (type == 13) {
                    this.checkPermission(requestor, 128);
                    CertReqMessages cr = CertReqMessages.getInstance((Object)reqBody.getContent());
                    CertRepMessage repMessage = this.processCertReqMessages(dfltCertprofileName, Boolean.FALSE, request, requestor, tid, cr, false, cmpControl, msgId, event);
                    return new PKIBody(14, (ASN1Encodable)repMessage);
                }
                throw new IllegalStateException("should not reach here");
            }
        }
        if (!cmpControl.isConfirmCert() && CmpUtil.isImplictConfirm((PKIHeader)reqHeader)) {
            this.pendingCertPool.removeCertificates(tid.getOctets());
            tv = CmpUtil.getImplictConfirmGeneralInfo();
        } else {
            Date now = new Date();
            respHeader.setMessageTime(new ASN1GeneralizedTime(now));
            tv = new InfoTypeAndValue(CMPObjectIdentifiers.it_confirmWaitTime, (ASN1Encodable)new ASN1GeneralizedTime(new Date(System.currentTimeMillis() + confirmWaitTime)));
        }
        respHeader.setGeneralInfo(tv);
        return respBody;
    }

    @Override
    protected PKIBody cmpUnRevokeRemoveCertificates(PKIMessage request, PKIHeaderBuilder respHeader, CmpControl cmpControl, PKIHeader reqHeader, PKIBody reqBody, RequestorInfo.CmpRequestorInfo requestor, String msgId, AuditEvent event) {
        RevDetails[] revContent;
        Integer requiredPermission = null;
        boolean allRevdetailsOfSameType = true;
        RevReqContent rr = RevReqContent.getInstance((Object)reqBody.getContent());
        for (RevDetails revDetails : revContent = rr.toRevDetailsArray()) {
            ASN1ObjectIdentifier extId;
            ASN1Encodable extValue;
            Extensions crlDetails = revDetails.getCrlEntryDetails();
            int reasonCode = CrlReason.UNSPECIFIED.getCode();
            if (crlDetails != null && (extValue = crlDetails.getExtensionParsedValue(extId = Extension.reasonCode)) != null) {
                reasonCode = ASN1Enumerated.getInstance((Object)extValue).getValue().intValue();
            }
            if (reasonCode == -1) {
                if (requiredPermission == null) {
                    event.addEventType("rr_remove");
                    requiredPermission = 8;
                    continue;
                }
                if (requiredPermission == 8) continue;
                allRevdetailsOfSameType = false;
                break;
            }
            if (reasonCode == CrlReason.REMOVE_FROM_CRL.getCode()) {
                if (requiredPermission == null) {
                    event.addEventType("rr_unrevoke");
                    requiredPermission = 4;
                    continue;
                }
                if (requiredPermission == 4) continue;
                allRevdetailsOfSameType = false;
                break;
            }
            if (requiredPermission == null) {
                event.addEventType("rr_revoke");
                requiredPermission = 2;
                continue;
            }
            if (requiredPermission == 2) continue;
            allRevdetailsOfSameType = false;
            break;
        }
        if (!allRevdetailsOfSameType) {
            ErrorMsgContent emc = new ErrorMsgContent(new PKIStatusInfo(PKIStatus.rejection, new PKIFreeText("not all revDetails are of the same type"), new PKIFailureInfo(32)));
            return new PKIBody(23, (ASN1Encodable)emc);
        }
        try {
            this.checkPermission(requestor, requiredPermission);
        }
        catch (InsufficientPermissionException ex) {
            event.setStatus(AuditStatus.FAILED);
            event.addEventData("message", (Object)"NOT_PERMITTED");
            return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 65536, null);
        }
        return this.unRevokeRemoveCertificates(request, rr, requiredPermission, cmpControl, msgId, event);
    }

    @Override
    protected PKIBody cmpGeneralMsg(PKIHeaderBuilder respHeader, CmpControl cmpControl, PKIHeader reqHeader, PKIBody reqBody, RequestorInfo.CmpRequestorInfo requestor, ASN1OctetString tid, String msgId, AuditEvent event) throws InsufficientPermissionException {
        GenMsgContent genMsgBody = GenMsgContent.getInstance((Object)reqBody.getContent());
        InfoTypeAndValue[] itvs = genMsgBody.toInfoTypeAndValueArray();
        InfoTypeAndValue itv = null;
        if (itvs != null && itvs.length > 0) {
            for (InfoTypeAndValue entry : itvs) {
                String itvType = entry.getInfoType().getId();
                if (!KNOWN_GENMSG_IDS.contains(itvType)) continue;
                itv = entry;
                break;
            }
        }
        if (itv == null) {
            String statusMessage = "PKIBody type 21 is only supported with the sub-types " + KNOWN_GENMSG_IDS.toString();
            return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 32, statusMessage);
        }
        InfoTypeAndValue itvResp = null;
        ASN1ObjectIdentifier infoType = itv.getInfoType();
        try {
            X509Ca ca = this.getCa();
            if (CMPObjectIdentifiers.it_currentCRL.equals((ASN1Primitive)infoType)) {
                CertificateList crl;
                event.addEventType("genm_current_crl");
                this.checkPermission(requestor, 64);
                if (itv.getInfoValue() == null) {
                    crl = ca.getBcCurrentCrl();
                } else {
                    ASN1Integer crlNumber = ASN1Integer.getInstance((Object)itv.getInfoValue());
                    crl = ca.getBcCrl(crlNumber.getPositiveValue());
                }
                if (crl == null) {
                    return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x40000000, "no CRL is available");
                }
                itvResp = new InfoTypeAndValue(infoType, (ASN1Encodable)crl);
            } else if (ObjectIdentifiers.Xipki.id_xipki_cmp_cmpGenmsg.equals((ASN1Primitive)infoType)) {
                ASN1EncodableVector vec;
                CertificateList respValue;
                ASN1Integer asn1Code;
                ASN1Encodable asn1 = itv.getInfoValue();
                ASN1Encodable reqValue = null;
                try {
                    ASN1Sequence seq = ASN1Sequence.getInstance((Object)asn1);
                    asn1Code = ASN1Integer.getInstance((Object)seq.getObjectAt(0));
                    if (seq.size() > 1) {
                        reqValue = seq.getObjectAt(1);
                    }
                }
                catch (IllegalArgumentException ex) {
                    return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 32, "invalid value of the InfoTypeAndValue for " + infoType.getId());
                }
                int action = asn1Code.getPositiveValue().intValue();
                if (action == 1) {
                    event.addEventType("genm_gen_crl");
                    this.checkPermission(requestor, 32);
                    X509CRLHolder tmpCrl = ca.generateCrlOnDemand(msgId);
                    if (tmpCrl == null) {
                        return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x40000000, "CRL generation is not activated");
                    }
                    respValue = tmpCrl.toASN1Structure();
                } else if (action == 2) {
                    event.addEventType("genm_crl4number");
                    this.checkPermission(requestor, 64);
                    respValue = ca.getBcCrl(ASN1Integer.getInstance((Object)reqValue).getPositiveValue());
                    if (respValue == null) {
                        return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x40000000, "no CRL is available");
                    }
                } else if (action == 3) {
                    event.addEventType("genm_cainfo");
                    HashSet<Integer> acceptVersions = new HashSet<Integer>();
                    if (reqValue != null) {
                        ASN1Sequence seq = DERSequence.getInstance((Object)reqValue);
                        int size = seq.size();
                        for (int i = 0; i < size; ++i) {
                            ASN1Integer ai = ASN1Integer.getInstance((Object)seq.getObjectAt(i));
                            acceptVersions.add(ai.getPositiveValue().intValue());
                        }
                    }
                    if (CollectionUtil.isEmpty(acceptVersions)) {
                        acceptVersions.add(3);
                    }
                    String systemInfo = this.getSystemInfo(requestor, acceptVersions);
                    respValue = new DERUTF8String(systemInfo);
                } else if (action == 4) {
                    event.addEventType("genm_cacertchain");
                    vec = new ASN1EncodableVector();
                    vec.add((ASN1Encodable)ca.getCaInfo().getCertInCmpFormat());
                    List<X509Cert> certchain = ca.getCaInfo().getCertchain();
                    if (CollectionUtil.isNotEmpty(certchain)) {
                        for (X509Cert m : certchain) {
                            vec.add((ASN1Encodable)m.toBcCert().toASN1Structure());
                        }
                    }
                    respValue = new DERSequence(vec);
                } else {
                    return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 32, "unsupported XiPKI action code " + action);
                }
                vec = new ASN1EncodableVector();
                vec.add((ASN1Encodable)asn1Code);
                if (respValue != null) {
                    vec.add((ASN1Encodable)respValue);
                }
                itvResp = new InfoTypeAndValue(infoType, (ASN1Encodable)new DERSequence(vec));
            }
            GenRepContent genRepContent = new GenRepContent(itvResp);
            return new PKIBody(22, (ASN1Encodable)genRepContent);
        }
        catch (OperationException ex) {
            int failureInfo = CmpResponder.getPKiFailureInfo(ex);
            OperationException.ErrorCode code = ex.getErrorCode();
            String errorMessage = code == OperationException.ErrorCode.DATABASE_FAILURE || code == OperationException.ErrorCode.SYSTEM_FAILURE ? code.name() : code.name() + ": " + ex.getErrorMessage();
            return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, failureInfo, errorMessage);
        }
    }

    private class PendingPoolCleaner
    implements Runnable {
        private PendingPoolCleaner() {
        }

        @Override
        public void run() {
            Set<CertificateInfo> remainingCerts = CmpResponder.this.pendingCertPool.removeConfirmTimeoutedCertificates();
            if (CollectionUtil.isEmpty(remainingCerts)) {
                return;
            }
            Date invalidityDate = new Date();
            X509Ca ca = CmpResponder.this.getCa();
            for (CertificateInfo remainingCert : remainingCerts) {
                BigInteger serialNumber = remainingCert.getCert().getCert().getSerialNumber();
                try {
                    ca.revokeCert(serialNumber, CrlReason.CESSATION_OF_OPERATION, invalidityDate, "ca_routine");
                }
                catch (Throwable th) {
                    LOG.error("could not revoke certificate (CA={}, serialNumber={}): {}", new Object[]{ca.getCaInfo().getIdent(), LogUtil.formatCsn((BigInteger)serialNumber), th.getMessage()});
                }
            }
        }
    }
}

