/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.cmp;

import java.security.Key;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSAESOAEPparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.IESEngine;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher;
import org.bouncycastle.jce.spec.IESParameterSpec;
import org.bouncycastle.operator.OperatorException;
import org.xipki.security.HashAlgo;
import org.xipki.security.ObjectIdentifiers;

abstract class CrmfKeyWrapper {
    CrmfKeyWrapper() {
    }

    abstract AlgorithmIdentifier getAlgorithmIdentifier();

    abstract byte[] generateWrappedKey(byte[] var1) throws OperatorException;

    static class ECIESAsymmetricKeyWrapper
    extends CrmfKeyWrapper {
        private final AlgorithmIdentifier algorithmIdentifier;
        private final int ephemeralPublicKeyLen = 65;
        private final int macLen = 20;
        private final int aesKeySize = 128;
        private final PublicKey publicKey;

        public ECIESAsymmetricKeyWrapper(PublicKey publicKey) {
            this.publicKey = publicKey;
            this.algorithmIdentifier = new AlgorithmIdentifier(ObjectIdentifiers.Secg.id_ecies_specifiedParameters, (ASN1Encodable)this.buildECIESParameters());
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithmIdentifier;
        }

        @Override
        public byte[] generateWrappedKey(byte[] keyToWrap) throws OperatorException {
            try {
                CBCBlockCipher cbcCipher = new CBCBlockCipher((BlockCipher)new AESEngine());
                IESCipher cipher = new IESCipher(new IESEngine((BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest()), (BufferedBlockCipher)new PaddedBufferedBlockCipher((BlockCipher)cbcCipher)), 16);
                byte[] iv = new byte[16];
                IESParameterSpec spec = new IESParameterSpec(null, null, 128, 128, iv);
                cipher.engineInit(1, (Key)this.publicKey, (AlgorithmParameterSpec)spec, new SecureRandom());
                byte[] bcResult = cipher.engineDoFinal(keyToWrap, 0, keyToWrap.length);
                ASN1Encodable[] array = new ASN1Encodable[3];
                byte[] ephemeralPublicKey = new byte[65];
                System.arraycopy(bcResult, 0, ephemeralPublicKey, 0, 65);
                array[0] = new DEROctetString(ephemeralPublicKey);
                int symmetricCiphertextLen = bcResult.length - 65 - 20;
                byte[] symmetricCiphertext = new byte[symmetricCiphertextLen];
                System.arraycopy(bcResult, 65, symmetricCiphertext, 0, symmetricCiphertextLen);
                array[1] = new DEROctetString(symmetricCiphertext);
                byte[] macTag = new byte[20];
                System.arraycopy(bcResult, 65 + symmetricCiphertextLen, macTag, 0, 20);
                array[2] = new DEROctetString(macTag);
                return new DERSequence(array).getEncoded();
            }
            catch (Exception ex) {
                throw new OperatorException("error while generateWrappedKey", (Throwable)ex);
            }
        }

        private ASN1Sequence buildECIESParameters() {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            AlgorithmIdentifier keyDerivationFunction = new AlgorithmIdentifier(ObjectIdentifiers.Misc.id_iso18033_kdf2, (ASN1Encodable)new AlgorithmIdentifier(HashAlgo.SHA1.getOid()));
            vec.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)keyDerivationFunction));
            AlgorithmIdentifier symmetricEncryption = new AlgorithmIdentifier(ObjectIdentifiers.Secg.id_aes128_cbc_in_ecies);
            vec.add((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)symmetricEncryption));
            AlgorithmIdentifier mac = new AlgorithmIdentifier(ObjectIdentifiers.Secg.id_hmac_full_ecies, (ASN1Encodable)new AlgorithmIdentifier(HashAlgo.SHA1.getOid()));
            vec.add((ASN1Encodable)new DERTaggedObject(true, 2, (ASN1Encodable)mac));
            return new DERSequence(vec);
        }
    }

    static class RSAOAEPAsymmetricKeyWrapper
    extends CrmfKeyWrapper {
        private static final AlgorithmIdentifier OAEP_DFLT = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSAES_OAEP, (ASN1Encodable)new RSAESOAEPparams());
        private final PublicKey publicKey;

        public RSAOAEPAsymmetricKeyWrapper(PublicKey publicKey) {
            this.publicKey = publicKey;
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return OAEP_DFLT;
        }

        @Override
        public byte[] generateWrappedKey(byte[] encryptionKey) throws OperatorException {
            try {
                Cipher cipher = Cipher.getInstance("RSA/NONE/OAEPPADDING", "BC");
                cipher.init(1, this.publicKey);
                return cipher.doFinal(encryptionKey);
            }
            catch (Exception ex) {
                throw new OperatorException("error in generateWrappedKey", (Throwable)ex);
            }
        }
    }
}

