/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.db;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.OperationException;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CertListInfo;
import org.xipki.ca.api.mgmt.CertListOrderBy;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.api.mgmt.entry.CaHasUserEntry;
import org.xipki.ca.server.CaIdNameMap;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.CertRevInfoWithSerial;
import org.xipki.ca.server.PasswordHash;
import org.xipki.ca.server.UniqueIdGenerator;
import org.xipki.ca.server.db.CertStoreBase;
import org.xipki.ca.server.db.QueryExecutor;
import org.xipki.ca.server.db.ResultRow;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.security.HashAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.LogUtil;
import org.xipki.util.LruCache;
import org.xipki.util.StringUtil;

public class CertStore
extends CertStoreBase {
    private static final Logger LOG = LoggerFactory.getLogger(CertStore.class);
    private final String sqlCertForId;
    private final String sqlCertWithRevInfo;
    private final String sqlCertInfo;
    private final String sqlActiveUserInfoForName;
    private final String sqlActiveUserNameForId;
    private final String sqlCaHasUser;
    private final String sqlKnowsCertForSerial;
    private final String sqlCertStatusForSubjectFp;
    private final String sqlCrl;
    private final String sqlCrlWithNo;
    private final String sqlReqIdForSerial;
    private final String sqlReqForId;
    private final String sqlSelectUnrevokedSn100;
    private final String sqlSelectUnrevokedSn;
    private final LruCache<Integer, String> cacheSqlCidFromPublishQueue = new LruCache(5);
    private final LruCache<Integer, String> cacheSqlExpiredSerials = new LruCache(5);
    private final LruCache<Integer, String> cacheSqlSuspendedSerials = new LruCache(5);
    private final LruCache<Integer, String> cacheSqlRevokedCerts = new LruCache(5);
    private final LruCache<Integer, String> cacheSqlSerials = new LruCache(5);
    private final LruCache<Integer, String> cacheSqlSerialsRevoked = new LruCache(5);
    private final UniqueIdGenerator idGenerator;
    private final AtomicInteger cachedCrlId = new AtomicInteger(0);

    public CertStore(DataSourceWrapper datasource, UniqueIdGenerator idGenerator) throws DataAccessException, CaMgmtException {
        super(datasource);
        this.idGenerator = (UniqueIdGenerator)Args.notNull((Object)idGenerator, (String)"idGenerator");
        this.sqlCertForId = this.buildSelectFirstSql("PID,RID,REV,RR,RT,RIT,CERT FROM CERT WHERE ID=?");
        this.sqlCertWithRevInfo = this.buildSelectFirstSql("ID,REV,RR,RT,RIT,PID,CERT FROM CERT WHERE CA_ID=? AND SN=?");
        this.sqlCertInfo = this.buildSelectFirstSql("PID,RID,REV,RR,RT,RIT,CERT FROM CERT WHERE CA_ID=? AND SN=?");
        this.sqlActiveUserInfoForName = this.buildSelectFirstSql("ID,PASSWORD FROM TUSER WHERE NAME=? AND ACTIVE=1");
        this.sqlActiveUserNameForId = this.buildSelectFirstSql("NAME FROM TUSER WHERE ID=? AND ACTIVE=1");
        this.sqlCaHasUser = this.buildSelectFirstSql("PERMISSION,PROFILES FROM CA_HAS_USER WHERE CA_ID=? AND USER_ID=?");
        this.sqlKnowsCertForSerial = this.buildSelectFirstSql("UID FROM CERT WHERE SN=? AND CA_ID=?");
        this.sqlCertStatusForSubjectFp = this.buildSelectFirstSql("REV FROM CERT WHERE FP_S=? AND CA_ID=?");
        this.sqlReqIdForSerial = this.buildSelectFirstSql("REQCERT.RID as REQ_ID FROM REQCERT INNER JOIN CERT ON CERT.CA_ID=? AND CERT.SN=? AND REQCERT.CID=CERT.ID");
        this.sqlReqForId = this.buildSelectFirstSql("DATA FROM REQUEST WHERE ID=?");
        this.sqlCrl = this.buildSelectFirstSql("THISUPDATE DESC", "THISUPDATE,CRL FROM CRL WHERE CA_ID=?");
        this.sqlCrlWithNo = this.buildSelectFirstSql("THISUPDATE DESC", "THISUPDATE,CRL FROM CRL WHERE CA_ID=? AND CRL_NO=?");
        this.sqlSelectUnrevokedSn = this.buildSelectFirstSql("LUPDATE FROM CERT WHERE REV=0 AND SN=?");
        String prefix = "SN,LUPDATE FROM CERT WHERE REV=0 AND SN";
        this.sqlSelectUnrevokedSn100 = CertStore.buildArraySql(datasource, "SN,LUPDATE FROM CERT WHERE REV=0 AND SN", 100);
    }

    public boolean addCert(CertificateInfo certInfo) {
        Args.notNull((Object)certInfo, (String)"certInfo");
        byte[] encodedCert = null;
        try {
            CertWithDbId cert = certInfo.getCert();
            byte[] transactionId = certInfo.getTransactionId();
            X500Name reqSubject = certInfo.getRequestedSubject();
            long certId = this.idGenerator.nextId();
            String subjectText = X509Util.cutText((String)cert.getCert().getSubjectRfc4519Text(), (int)this.maxX500nameLen);
            long fpSubject = X509Util.fpCanonicalizedName((X500Name)cert.getCert().getSubject());
            String reqSubjectText = null;
            Long fpReqSubject = null;
            if (reqSubject != null) {
                fpReqSubject = X509Util.fpCanonicalizedName((X500Name)reqSubject);
                if (fpSubject == fpReqSubject) {
                    fpReqSubject = null;
                } else {
                    reqSubjectText = X509Util.cutX500Name((X500Name)CaUtil.sortX509Name(reqSubject), (int)this.maxX500nameLen);
                }
            }
            encodedCert = cert.getCert().getEncoded();
            String b64FpCert = HashAlgo.SHA1.base64Hash((byte[][])new byte[][]{encodedCert});
            String tid = transactionId == null ? null : Base64.encodeToString((byte[])transactionId);
            X509Cert cert0 = cert.getCert();
            boolean isEeCert = cert0.getBasicConstraints() == -1;
            this.execUpdatePrepStmt0(this.dbSchemaVersion < 5 ? SQL_ADD_CERT_V4 : "INSERT INTO CERT (ID,LUPDATE,SN,SUBJECT,FP_S,FP_RS,NBEFORE,NAFTER,REV,PID,CA_ID,RID,UID,EE,RTYPE,TID,SHA1,REQ_SUBJECT,CRL_SCOPE,CERT) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", CertStore.col2Long(certId), CertStore.col2Long(System.currentTimeMillis() / 1000L), CertStore.col2Str(cert0.getSerialNumber().toString(16)), CertStore.col2Str(subjectText), CertStore.col2Long(fpSubject), CertStore.col2Long(fpReqSubject), CertStore.col2Long(cert0.getNotBefore().getTime() / 1000L), CertStore.col2Long(cert0.getNotAfter().getTime() / 1000L), CertStore.col2Bool(false), CertStore.col2Int(certInfo.getProfile().getId()), CertStore.col2Int(certInfo.getIssuer().getId()), CertStore.col2Int(certInfo.getRequestor().getId()), CertStore.col2Int(certInfo.getUser()), CertStore.col2Int(isEeCert ? 1 : 0), CertStore.col2Int(certInfo.getReqType().getCode()), CertStore.col2Str(tid), CertStore.col2Str(b64FpCert), CertStore.col2Str(reqSubjectText), CertStore.col2Int(0), CertStore.col2Str(Base64.encodeToString((byte[])encodedCert)));
            cert.setCertId(Long.valueOf(certId));
        }
        catch (Exception ex) {
            LOG.error("could not save certificate {}: {}. Message: {}", new Object[]{certInfo.getCert().getCert().getSubject(), encodedCert == null ? "null" : Base64.encodeToString(encodedCert, (boolean)true), ex.getMessage()});
            LOG.debug("error", (Throwable)ex);
            return false;
        }
        return true;
    }

    public void addToPublishQueue(NameId publisher, long certId, NameId ca) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        this.execUpdatePrepStmt0("INSERT INTO PUBLISHQUEUE (PID,CA_ID,CID) VALUES (?,?,?)", CertStore.col2Int(publisher.getId()), CertStore.col2Int(ca.getId()), CertStore.col2Long(certId));
    }

    public void removeFromPublishQueue(NameId publisher, long certId) throws OperationException {
        this.execUpdatePrepStmt0("DELETE FROM PUBLISHQUEUE WHERE PID=? AND CID=?", CertStore.col2Int(publisher.getId()), CertStore.col2Long(certId));
    }

    public void clearPublishQueue(NameId ca, NameId publisher) throws OperationException {
        StringBuilder sqlBuilder = new StringBuilder(80);
        sqlBuilder.append("DELETE FROM PUBLISHQUEUE");
        ArrayList<QueryExecutor.SqlColumn2> params = new ArrayList<QueryExecutor.SqlColumn2>(2);
        if (ca != null || publisher != null) {
            sqlBuilder.append(" WHERE");
            if (ca != null) {
                sqlBuilder.append(" CA_ID=?");
                params.add(CertStore.col2Int(ca.getId()));
                if (publisher != null) {
                    sqlBuilder.append(" AND");
                }
            }
            if (publisher != null) {
                sqlBuilder.append(" PID=?");
                params.add(CertStore.col2Int(publisher.getId()));
            }
        }
        this.execUpdatePrepStmt0(sqlBuilder.toString(), params.toArray(new QueryExecutor.SqlColumn2[0]));
    }

    public long getMaxFullCrlNumber(NameId ca) throws OperationException {
        return this.getMaxCrlNumber(ca, "SELECT MAX(CRL_NO) FROM CRL WHERE CA_ID=? AND DELTACRL = 0");
    }

    public long getMaxCrlNumber(NameId ca) throws OperationException {
        return this.getMaxCrlNumber(ca, "SELECT MAX(CRL_NO) FROM CRL WHERE CA_ID=?");
    }

    private long getMaxCrlNumber(NameId ca, String sql) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        long maxCrlNumber = this.execQueryLongPrepStmt(sql, CertStore.col2Int(ca.getId()));
        return maxCrlNumber < 0L ? 0L : maxCrlNumber;
    }

    public long getThisUpdateOfCurrentCrl(NameId ca, boolean deltaCrl) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        return this.execQueryLongPrepStmt("SELECT MAX(THISUPDATE) FROM CRL WHERE CA_ID=? AND DELTACRL=?", CertStore.col2Int(ca.getId()), CertStore.col2Int(deltaCrl ? 1 : 0));
    }

    public void addCrl(NameId ca, X509CRLHolder crl) throws OperationException, CRLException {
        String b64Crl;
        this.notNulls(ca, "ca", crl, "crl");
        Extensions extns = crl.getExtensions();
        byte[] extnValue = X509Util.getCoreExtValue((Extensions)extns, (ASN1ObjectIdentifier)Extension.cRLNumber);
        Long crlNumber = extnValue == null ? null : Long.valueOf(ASN1Integer.getInstance((Object)extnValue).getPositiveValue().longValue());
        extnValue = X509Util.getCoreExtValue((Extensions)extns, (ASN1ObjectIdentifier)Extension.deltaCRLIndicator);
        Long baseCrlNumber = null;
        if (extnValue != null) {
            baseCrlNumber = ASN1Integer.getInstance((Object)extnValue).getPositiveValue().longValue();
        }
        int currentMaxCrlId = (int)this.getMax("CRL", "ID");
        int crlId = Math.max(this.cachedCrlId.get(), currentMaxCrlId) + 1;
        this.cachedCrlId.set(crlId);
        try {
            b64Crl = Base64.encodeToString((byte[])crl.getEncoded());
        }
        catch (IOException ex) {
            throw new CRLException(ex.getMessage(), ex);
        }
        this.execUpdatePrepStmt0("INSERT INTO CRL (ID,CA_ID,CRL_NO,THISUPDATE,NEXTUPDATE,DELTACRL,BASECRL_NO,CRL_SCOPE,CRL) VALUES (?,?,?,?,?,?,?,?,?)", CertStore.col2Int(crlId), CertStore.col2Int(ca.getId()), CertStore.col2Long(crlNumber), CertStore.col2Long(crl.getThisUpdate().getTime() / 1000L), CertStore.col2Long(CertStore.getDateSeconds(crl.getNextUpdate())), CertStore.col2Bool(baseCrlNumber != null), CertStore.col2Long(baseCrlNumber), CertStore.col2Int(0), CertStore.col2Str(b64Crl));
    }

    public CertWithRevocationInfo revokeCert(NameId ca, BigInteger serialNumber, CertRevocationInfo revInfo, boolean force, CaIdNameMap idNameMap) throws OperationException {
        int count;
        this.notNulls(ca, "ca", serialNumber, "serialNumber", revInfo, "revInfo");
        CertWithRevocationInfo certWithRevInfo = this.getCertWithRevocationInfo(ca.getId(), serialNumber, idNameMap);
        if (certWithRevInfo == null) {
            LOG.warn("certificate with CA={} and serialNumber={} does not exist", (Object)ca.getName(), (Object)LogUtil.formatCsn((BigInteger)serialNumber));
            return null;
        }
        CertRevocationInfo currentRevInfo = certWithRevInfo.getRevInfo();
        if (currentRevInfo != null) {
            CrlReason currentReason = currentRevInfo.getReason();
            if (currentReason == CrlReason.CERTIFICATE_HOLD) {
                if (revInfo.getReason() == CrlReason.CERTIFICATE_HOLD) {
                    throw new OperationException(OperationException.ErrorCode.CERT_REVOKED, "certificate already revoked with the requested reason " + currentReason.getDescription());
                }
                revInfo.setRevocationTime(currentRevInfo.getRevocationTime());
                revInfo.setInvalidityTime(currentRevInfo.getInvalidityTime());
            } else if (!force) {
                throw new OperationException(OperationException.ErrorCode.CERT_REVOKED, "certificate already revoked with reason " + currentReason.getDescription());
            }
        }
        Long invTimeSeconds = null;
        if (revInfo.getInvalidityTime() != null) {
            invTimeSeconds = revInfo.getInvalidityTime().getTime() / 1000L;
        }
        if ((count = this.execUpdatePrepStmt0("UPDATE CERT SET LUPDATE=?,REV=?,RT=?,RIT=?,RR=? WHERE ID=?", CertStore.col2Long(System.currentTimeMillis() / 1000L), CertStore.col2Bool(true), CertStore.col2Long(revInfo.getRevocationTime().getTime() / 1000L), CertStore.col2Long(invTimeSeconds), CertStore.col2Int(revInfo.getReason().getCode()), CertStore.col2Long(certWithRevInfo.getCert().getCertId()))) != 1) {
            String message = count > 1 ? count + " rows modified, but exactly one is expected" : "no row is modified, but exactly one is expected";
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, message);
        }
        certWithRevInfo.setRevInfo(revInfo);
        return certWithRevInfo;
    }

    public CertWithRevocationInfo revokeSuspendedCert(NameId ca, SerialWithId serialNumber, CrlReason reason, CaIdNameMap idNameMap) throws OperationException {
        this.notNulls(ca, "ca", serialNumber, "serialNumber", reason, "reason");
        CertWithRevocationInfo certWithRevInfo = this.getCertWithRevocationInfo(serialNumber.getId(), idNameMap);
        if (certWithRevInfo == null) {
            LOG.warn("certificate with CA={} and serialNumber={} does not exist", (Object)ca.getName(), (Object)LogUtil.formatCsn((BigInteger)serialNumber.getSerial()));
            return null;
        }
        CertRevocationInfo currentRevInfo = certWithRevInfo.getRevInfo();
        if (currentRevInfo == null) {
            throw new OperationException(OperationException.ErrorCode.CERT_UNREVOKED, "certificate is not revoked");
        }
        CrlReason currentReason = currentRevInfo.getReason();
        if (currentReason != CrlReason.CERTIFICATE_HOLD) {
            throw new OperationException(OperationException.ErrorCode.CERT_REVOKED, "certificate is revoked but not with reason " + CrlReason.CERTIFICATE_HOLD.getDescription());
        }
        int count = this.execUpdatePrepStmt0("UPDATE CERT SET LUPDATE=?,RR=? WHERE ID=?", CertStore.col2Long(System.currentTimeMillis() / 1000L), CertStore.col2Int(reason.getCode()), CertStore.col2Long(serialNumber.getId()));
        if (count != 1) {
            String message = count > 1 ? count + " rows modified, but exactly one is expected" : "no row is modified, but exactly one is expected";
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, message);
        }
        currentRevInfo.setReason(reason);
        return certWithRevInfo;
    }

    public CertWithDbId unrevokeCert(NameId ca, BigInteger serialNumber, boolean force, CaIdNameMap idNamMap) throws OperationException {
        this.notNulls(ca, "ca", serialNumber, "serialNumber");
        CertWithRevocationInfo certWithRevInfo = this.getCertWithRevocationInfo(ca.getId(), serialNumber, idNamMap);
        if (certWithRevInfo == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("certificate with CA={} and serialNumber={} does not exist", (Object)ca.getName(), (Object)LogUtil.formatCsn((BigInteger)serialNumber));
            }
            return null;
        }
        CertRevocationInfo currentRevInfo = certWithRevInfo.getRevInfo();
        if (currentRevInfo == null) {
            throw new OperationException(OperationException.ErrorCode.CERT_UNREVOKED, "certificate is not revoked");
        }
        CrlReason currentReason = currentRevInfo.getReason();
        if (!force && currentReason != CrlReason.CERTIFICATE_HOLD) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "could not unrevoke certificate revoked with reason " + currentReason.getDescription());
        }
        QueryExecutor.SqlColumn2 nullInt = new QueryExecutor.SqlColumn2(QueryExecutor.ColumnType.INT, null);
        int count = this.execUpdatePrepStmt0("UPDATE CERT SET LUPDATE=?,REV=?,RT=?,RIT=?,RR=? WHERE ID=?", CertStore.col2Long(System.currentTimeMillis() / 1000L), CertStore.col2Bool(false), nullInt, nullInt, nullInt, CertStore.col2Long(certWithRevInfo.getCert().getCertId()));
        if (count != 1) {
            String message = count > 1 ? count + " rows modified, but exactly one is expected" : "no row is modified, but exactly one is expected";
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, message);
        }
        return certWithRevInfo.getCert();
    }

    public void removeCert(NameId ca, BigInteger serialNumber) throws OperationException {
        this.notNulls(ca, "ca", serialNumber, "serialNumber");
        long id = this.getCertId(ca, serialNumber);
        if (id == 0L) {
            return;
        }
        this.removeCert(id);
    }

    public void removeCert(long id) throws OperationException {
        this.execUpdatePrepStmt0("DELETE FROM CERT WHERE ID=?", CertStore.col2Long(id));
    }

    public List<Long> getPublishQueueEntries(NameId ca, NameId publisher, int numEntries) throws OperationException {
        String sql = (String)this.cacheSqlCidFromPublishQueue.get((Object)numEntries);
        if (sql == null) {
            sql = this.datasource.buildSelectFirstSql(numEntries, "CID ASC", "CID FROM PUBLISHQUEUE WHERE PID=? AND CA_ID=?");
            this.cacheSqlCidFromPublishQueue.put((Object)numEntries, (Object)sql);
        }
        List<ResultRow> rows = this.execQueryPrepStmt0(sql, CertStore.col2Int(publisher.getId()), CertStore.col2Int(ca.getId()));
        ArrayList<Long> ret = new ArrayList<Long>();
        for (ResultRow rs : rows) {
            long certId = rs.getLong("CID");
            if (!ret.contains(certId)) {
                ret.add(certId);
            }
            if (ret.size() < numEntries) continue;
            break;
        }
        return ret;
    }

    public long getCountOfCerts(NameId ca, boolean onlyRevoked) throws OperationException {
        String sql = onlyRevoked ? "SELECT COUNT(*) FROM CERT WHERE CA_ID=? AND REV=1" : "SELECT COUNT(*) FROM CERT WHERE CA_ID=?";
        return this.execQueryLongPrepStmt(sql, CertStore.col2Int(ca.getId()));
    }

    public List<SerialWithId> getSerialNumbers(NameId ca, long startId, int numEntries, boolean onlyRevoked) throws OperationException {
        this.notNulls(ca, "ca", numEntries, "numEntries");
        LruCache<Integer, String> cache = onlyRevoked ? this.cacheSqlSerialsRevoked : this.cacheSqlSerials;
        String sql = (String)cache.get((Object)numEntries);
        if (sql == null) {
            String coreSql = "ID,SN FROM CERT WHERE ID>? AND CA_ID=?";
            if (onlyRevoked) {
                coreSql = coreSql + "AND REV=1";
            }
            sql = this.datasource.buildSelectFirstSql(numEntries, "ID ASC", coreSql);
            cache.put((Object)numEntries, (Object)sql);
        }
        return this.getSerialWithIds(sql, numEntries, CertStore.col2Long(startId - 1L), CertStore.col2Int(ca.getId()));
    }

    private List<SerialWithId> getSerialWithIds(String sql, int numEntries, QueryExecutor.SqlColumn2 ... params) throws OperationException {
        List<ResultRow> rows = this.execQueryPrepStmt0(sql, params);
        ArrayList<SerialWithId> ret = new ArrayList<SerialWithId>();
        for (ResultRow rs : rows) {
            ret.add(new SerialWithId(rs.getLong("ID"), new BigInteger(rs.getString("SN"), 16)));
            if (ret.size() < numEntries) continue;
            break;
        }
        return ret;
    }

    public List<SerialWithId> getExpiredUnrevokedSerialNumbers(NameId ca, long expiredAt, int numEntries) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        Args.positive((int)numEntries, (String)"numEntries");
        String sql = (String)this.cacheSqlExpiredSerials.get((Object)numEntries);
        if (sql == null) {
            sql = this.datasource.buildSelectFirstSql(numEntries, "ID,SN FROM CERT WHERE CA_ID=? AND NAFTER<? AND REV=0");
            this.cacheSqlExpiredSerials.put((Object)numEntries, (Object)sql);
        }
        return this.getSerialNumbers0(sql, numEntries, CertStore.col2Int(ca.getId()), CertStore.col2Long(expiredAt));
    }

    public List<SerialWithId> getSuspendedCertSerials(NameId ca, long latestLastUpdate, int numEntries) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        Args.positive((int)numEntries, (String)"numEntries");
        String sql = (String)this.cacheSqlSuspendedSerials.get((Object)numEntries);
        if (sql == null) {
            sql = this.datasource.buildSelectFirstSql(numEntries, "ID,SN FROM CERT WHERE CA_ID=? AND LUPDATE<? AND RR=?");
            this.cacheSqlSuspendedSerials.put((Object)numEntries, (Object)sql);
        }
        return this.getSerialNumbers0(sql, numEntries, CertStore.col2Int(ca.getId()), CertStore.col2Long(latestLastUpdate + 1L), CertStore.col2Int(CrlReason.CERTIFICATE_HOLD.getCode()));
    }

    private List<SerialWithId> getSerialNumbers0(String sql, int numEntries, QueryExecutor.SqlColumn2 ... params) throws OperationException {
        List<ResultRow> rows = this.execQueryPrepStmt0(sql, params);
        ArrayList<SerialWithId> ret = new ArrayList<SerialWithId>();
        for (ResultRow row : rows) {
            ret.add(new SerialWithId(row.getLong("ID"), new BigInteger(row.getString("SN"), 16)));
            if (ret.size() < numEntries) continue;
            break;
        }
        return ret;
    }

    private byte[] getEncodedCrl(NameId ca) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        List<ResultRow> rows = this.execQueryPrepStmt0(this.sqlCrl, CertStore.col2Int(ca.getId()));
        long currentThisUpdate = 0L;
        String b64Crl = null;
        for (ResultRow rs : rows) {
            long thisUpdate = rs.getLong("THISUPDATE");
            if (thisUpdate < currentThisUpdate) continue;
            b64Crl = rs.getString("CRL");
            currentThisUpdate = thisUpdate;
        }
        return b64Crl == null ? null : Base64.decodeFast(b64Crl);
    }

    public byte[] getEncodedCrl(NameId ca, BigInteger crlNumber) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        if (crlNumber == null) {
            return this.getEncodedCrl(ca);
        }
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlCrlWithNo, CertStore.col2Int(ca.getId()), CertStore.col2Long(crlNumber.longValue()));
        return rs == null ? null : Base64.decodeFast((String)rs.getString("CRL"));
    }

    public int cleanupCrls(NameId ca, int numCrls) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        Args.positive((int)numCrls, (String)"numCrls");
        LinkedList<Long> crlNumbers = new LinkedList<Long>();
        List<ResultRow> rows = this.execQueryPrepStmt0("SELECT CRL_NO FROM CRL WHERE CA_ID=? AND DELTACRL=?", CertStore.col2Int(ca.getId()), CertStore.col2Bool(false));
        for (ResultRow rs : rows) {
            crlNumbers.add(rs.getLong("CRL_NO"));
        }
        int size = crlNumbers.size();
        Collections.sort(crlNumbers);
        int numCrlsToDelete = size - numCrls;
        if (numCrlsToDelete < 1) {
            return 0;
        }
        long crlNumber = (Long)crlNumbers.get(numCrlsToDelete - 1);
        this.execUpdatePrepStmt0("DELETE FROM CRL WHERE CA_ID=? AND CRL_NO<?", CertStore.col2Long(crlNumber + 1L));
        return numCrlsToDelete;
    }

    public CertificateInfo getCertForId(NameId ca, X509Cert caCert, long certId, CaIdNameMap idNameMap) throws OperationException {
        this.notNulls(ca, "ca", caCert, "caCert", idNameMap, "idNameMap");
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlCertForId, CertStore.col2Long(certId));
        if (rs == null) {
            return null;
        }
        X509Cert cert = CertStore.parseCert(Base64.decodeFast((String)rs.getString("CERT")));
        CertWithDbId certWithMeta = new CertWithDbId(cert);
        certWithMeta.setCertId(Long.valueOf(certId));
        CertificateInfo certInfo = new CertificateInfo(certWithMeta, null, ca, caCert, idNameMap.getCertprofile(rs.getInt("PID")), idNameMap.getRequestor(rs.getInt("RID")));
        certInfo.setRevocationInfo(CertStore.buildCertRevInfo(rs));
        return certInfo;
    }

    public CertWithRevocationInfo getCertWithRevocationInfo(long certId, CaIdNameMap idNameMap) throws OperationException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlCertForId, CertStore.col2Long(certId));
        if (rs == null) {
            return null;
        }
        return this.buildCertWithRevInfo(certId, rs, idNameMap);
    }

    public CertWithRevocationInfo getCertWithRevocationInfo(int caId, BigInteger serial, CaIdNameMap idNameMap) throws OperationException {
        this.notNulls(serial, "serial", idNameMap, "idNameMap");
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlCertWithRevInfo, CertStore.col2Int(caId), CertStore.col2Str(serial.toString(16)));
        if (rs == null) {
            return null;
        }
        return this.buildCertWithRevInfo(rs.getLong("ID"), rs, idNameMap);
    }

    private CertWithRevocationInfo buildCertWithRevInfo(long certId, ResultRow rs, CaIdNameMap idNameMap) throws OperationException {
        X509Cert cert = CertStore.parseCert(Base64.decodeFast((String)rs.getString("CERT")));
        CertWithDbId certWithMeta = new CertWithDbId(cert);
        certWithMeta.setCertId(Long.valueOf(certId));
        CertWithRevocationInfo ret = new CertWithRevocationInfo();
        ret.setCertprofile(idNameMap.getCertprofileName(rs.getInt("PID")));
        ret.setCert(certWithMeta);
        ret.setRevInfo(CertStore.buildCertRevInfo(rs));
        return ret;
    }

    public long getCertId(NameId ca, BigInteger serial) throws OperationException {
        this.notNulls(ca, "ca", serial, "serial");
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlCertInfo, CertStore.col2Int(ca.getId()), CertStore.col2Str(serial.toString(16)));
        if (rs == null) {
            return 0L;
        }
        return rs.getLong("ID");
    }

    public CertificateInfo getCertInfo(NameId ca, X509Cert caCert, BigInteger serial, CaIdNameMap idNameMap) throws OperationException {
        this.notNulls(ca, "ca", caCert, "caCert", idNameMap, "idNameMap", serial, "serial");
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlCertInfo, CertStore.col2Int(ca.getId()), CertStore.col2Str(serial.toString(16)));
        if (rs == null) {
            return null;
        }
        byte[] encodedCert = Base64.decodeFast((String)rs.getString("CERT"));
        CertWithDbId certWithMeta = new CertWithDbId(CertStore.parseCert(encodedCert));
        CertificateInfo certInfo = new CertificateInfo(certWithMeta, null, ca, caCert, idNameMap.getCertprofile(rs.getInt("PID")), idNameMap.getRequestor(rs.getInt("RID")));
        certInfo.setRevocationInfo(CertStore.buildCertRevInfo(rs));
        return certInfo;
    }

    public List<X509Cert> getCert(X500Name subjectName, byte[] transactionId) throws OperationException {
        String sql = transactionId != null ? "SELECT CERT FROM CERT WHERE TID=? AND (FP_S=? OR FP_RS=?)" : "SELECT CERT FROM CERT WHERE FP_S=? OR FP_RS=?";
        long fpSubject = X509Util.fpCanonicalizedName((X500Name)subjectName);
        LinkedList<X509Cert> certs = new LinkedList<X509Cert>();
        QueryExecutor.SqlColumn2[] params = new QueryExecutor.SqlColumn2[transactionId == null ? 2 : 3];
        int idx = 0;
        if (transactionId != null) {
            params[idx++] = CertStore.col2Str(Base64.encodeToString((byte[])transactionId));
        }
        params[idx++] = CertStore.col2Long(fpSubject);
        params[idx] = CertStore.col2Long(fpSubject);
        List<ResultRow> rows = this.execQueryPrepStmt0(sql, params);
        for (ResultRow rs : rows) {
            certs.add(CertStore.parseCert(Base64.decodeFast((String)rs.getString("CERT"))));
        }
        return certs;
    }

    public byte[] getCertRequest(NameId ca, BigInteger serialNumber) throws OperationException {
        this.notNulls(ca, "ca", serialNumber, "serialNumber");
        ResultRow row = this.execQuery1PrepStmt0(this.sqlReqIdForSerial, CertStore.col2Int(ca.getId()), CertStore.col2Str(serialNumber.toString(16)));
        if (row == null) {
            return null;
        }
        return (row = this.execQuery1PrepStmt0(this.sqlReqForId, CertStore.col2Long(row.getLong("REQ_ID")))) == null ? null : Base64.decodeFast((String)row.getString("DATA"));
    }

    public List<CertListInfo> listCerts(NameId ca, X500Name subjectPattern, Date validFrom, Date validTo, CertListOrderBy orderBy, int numEntries) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        Args.positive((int)numEntries, (String)"numEntries");
        StringBuilder sb = new StringBuilder(200);
        sb.append("SN,NBEFORE,NAFTER,SUBJECT FROM CERT WHERE CA_ID=?");
        ArrayList<QueryExecutor.SqlColumn2> params = new ArrayList<QueryExecutor.SqlColumn2>(4);
        params.add(CertStore.col2Int(ca.getId()));
        if (validFrom != null) {
            sb.append(" AND NBEFORE<?");
            params.add(CertStore.col2Long(validFrom.getTime() / 1000L - 1L));
        }
        if (validTo != null) {
            sb.append(" AND NAFTER>?");
            params.add(CertStore.col2Long(validTo.getTime() / 1000L));
        }
        if (subjectPattern != null) {
            RDN[] rdns;
            sb.append(" AND SUBJECT LIKE ?");
            StringBuilder buffer = new StringBuilder(100);
            buffer.append("%");
            for (RDN rdn : rdns = subjectPattern.getRDNs()) {
                X500Name rdnName = new X500Name(new RDN[]{rdn});
                String rdnStr = X509Util.getRfc4519Name((X500Name)rdnName);
                if (rdnStr.indexOf(37) != -1) {
                    throw new OperationException(OperationException.ErrorCode.BAD_REQUEST, "the character '%' is not allowed in subjectPattern");
                }
                if (rdnStr.indexOf(42) != -1) {
                    rdnStr = rdnStr.replace('*', '%');
                }
                buffer.append(rdnStr);
                buffer.append("%");
            }
            params.add(CertStore.col2Str(buffer.toString()));
        }
        String sortByStr = null;
        if (orderBy != null) {
            if (orderBy == CertListOrderBy.NOT_BEFORE) {
                sortByStr = "NBEFORE";
            } else if (orderBy == CertListOrderBy.NOT_BEFORE_DESC) {
                sortByStr = "NBEFORE DESC";
            } else if (orderBy == CertListOrderBy.NOT_AFTER) {
                sortByStr = "NAFTER";
            } else if (orderBy == CertListOrderBy.NOT_AFTER_DESC) {
                sortByStr = "NAFTER DESC";
            } else if (orderBy == CertListOrderBy.SUBJECT) {
                sortByStr = "SUBJECT";
            } else if (orderBy == CertListOrderBy.SUBJECT_DESC) {
                sortByStr = "SUBJECT DESC";
            } else {
                throw new IllegalStateException("unknown CertListOrderBy " + orderBy);
            }
        }
        String sql = this.datasource.buildSelectFirstSql(numEntries, sortByStr, sb.toString());
        List<ResultRow> rows = this.execQueryPrepStmt0(sql, params.toArray(new QueryExecutor.SqlColumn2[0]));
        LinkedList<CertListInfo> ret = new LinkedList<CertListInfo>();
        for (ResultRow rs : rows) {
            CertListInfo info = new CertListInfo(new BigInteger(rs.getString("SN"), 16), rs.getString("SUBJECT"), new Date(rs.getLong("NBEFORE") * 1000L), new Date(rs.getLong("NAFTER") * 1000L));
            ret.add(info);
        }
        return ret;
    }

    public NameId authenticateUser(String user, byte[] password) throws OperationException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlActiveUserInfoForName, CertStore.col2Str(user));
        if (rs == null) {
            return null;
        }
        int id = rs.getInt("ID");
        String expPasswordText = rs.getString("PASSWORD");
        if (StringUtil.isBlank((String)expPasswordText)) {
            return null;
        }
        boolean valid = PasswordHash.validatePassword(password, expPasswordText);
        return valid ? new NameId(Integer.valueOf(id), user) : null;
    }

    public String getUsername(int id) throws OperationException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlActiveUserNameForId, CertStore.col2Int(id));
        return rs == null ? null : rs.getString("NAME");
    }

    public CaHasUserEntry getCaHasUser(NameId ca, NameId user) throws OperationException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlCaHasUser, CertStore.col2Int(ca.getId()), CertStore.col2Int(user.getId()));
        if (rs == null) {
            return null;
        }
        List list = StringUtil.split((String)rs.getString("PROFILES"), (String)",");
        HashSet profiles = list == null ? null : new HashSet(list);
        CaHasUserEntry entry = new CaHasUserEntry(user);
        entry.setPermission(rs.getInt("PERMISSION"));
        entry.setProfiles(profiles);
        return entry;
    }

    public KnowCertResult knowsCertForSerial(NameId ca, BigInteger serial) throws OperationException {
        Args.notNull((Object)serial, (String)"serial");
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlKnowsCertForSerial, CertStore.col2Str(serial.toString(16)), CertStore.col2Int(ca.getId()));
        return rs == null ? KnowCertResult.UNKNOWN : new KnowCertResult(true, rs.getInt("UID"));
    }

    public List<CertRevInfoWithSerial> getRevokedCerts(NameId ca, Date notExpiredAt, long startId, int numEntries) throws OperationException {
        this.notNulls(ca, "ca", notExpiredAt, "notExpiredAt");
        Args.positive((int)numEntries, (String)"numEntries");
        String sql = (String)this.cacheSqlRevokedCerts.get((Object)numEntries);
        if (sql == null) {
            String coreSql = "ID,SN,RR,RT,RIT FROM CERT WHERE ID>? AND CA_ID=? AND REV=1 AND NAFTER>?";
            sql = this.datasource.buildSelectFirstSql(numEntries, "ID ASC", coreSql);
            this.cacheSqlRevokedCerts.put((Object)numEntries, (Object)sql);
        }
        List<ResultRow> rows = this.execQueryPrepStmt0(sql, CertStore.col2Long(startId - 1L), CertStore.col2Int(ca.getId()), CertStore.col2Long(notExpiredAt.getTime() / 1000L + 1L));
        LinkedList<CertRevInfoWithSerial> ret = new LinkedList<CertRevInfoWithSerial>();
        for (ResultRow rs : rows) {
            long revInvalidityTime = rs.getLong("RIT");
            Date invalidityTime = revInvalidityTime == 0L ? null : new Date(1000L * revInvalidityTime);
            CertRevInfoWithSerial revInfo = new CertRevInfoWithSerial(rs.getLong("ID"), new BigInteger(rs.getString("SN"), 16), rs.getInt("RR"), new Date(1000L * rs.getLong("RT")), invalidityTime);
            ret.add(revInfo);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CertRevInfoWithSerial> getCertsForDeltaCrl(NameId ca, BigInteger baseCrlNumber, Date notExpiredAt) throws OperationException {
        ResultSet rs;
        this.notNulls(ca, "ca", notExpiredAt, "notExpiredAt", baseCrlNumber, "baseCrlNumber");
        byte[] encodedCrl = this.getEncodedCrl(ca, baseCrlNumber);
        CertificateList crl = CertificateList.getInstance((Object)encodedCrl);
        Enumeration revokedCertsInCrl = crl.getRevokedCertificateEnumeration();
        HashSet<BigInteger> allSnSet = null;
        boolean supportInSql = this.datasource.getDatabaseType().supportsInArray();
        LinkedList<BigInteger> snList = new LinkedList<BigInteger>();
        LinkedList<CertRevInfoWithSerial> ret = new LinkedList<CertRevInfoWithSerial>();
        PreparedStatement ps = null;
        try {
            while (revokedCertsInCrl.hasMoreElements()) {
                TBSCertList.CRLEntry crlEntry = (TBSCertList.CRLEntry)revokedCertsInCrl.nextElement();
                if (allSnSet == null) {
                    int averageSize = encodedCrl.length / crlEntry.getEncoded().length;
                    allSnSet = new HashSet<BigInteger>((int)(1.1 * (double)averageSize));
                }
                BigInteger sn = crlEntry.getUserCertificate().getPositiveValue();
                snList.add(sn);
                allSnSet.add(sn);
                if (!supportInSql || snList.size() != 100) continue;
                if (ps == null) {
                    ps = this.prepareStatement(this.sqlSelectUnrevokedSn100);
                }
                for (int i = 1; i < 101; ++i) {
                    ps.setString(i, ((BigInteger)snList.get(i - 1)).toString(16));
                }
                snList.clear();
                rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        ret.add(new CertRevInfoWithSerial(0L, new BigInteger(rs.getString("SN"), 16), CrlReason.REMOVE_FROM_CRL, new Date(100L * rs.getLong("LUPDATE")), null));
                    }
                }
                finally {
                    this.datasource.releaseResources(null, rs);
                }
            }
        }
        catch (SQLException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(this.sqlSelectUnrevokedSn100, ex).getMessage());
        }
        catch (IOException ex) {
            throw new OperationException(OperationException.ErrorCode.CRL_FAILURE, ex.getMessage());
        }
        finally {
            this.datasource.releaseResources(ps, null);
        }
        if (!snList.isEmpty()) {
            ps = this.prepareStatement(this.sqlSelectUnrevokedSn);
            try {
                for (BigInteger sn : snList) {
                    ps.setString(1, sn.toString(16));
                    rs = ps.executeQuery();
                    try {
                        if (!rs.next()) continue;
                        ret.add(new CertRevInfoWithSerial(0L, sn, CrlReason.REMOVE_FROM_CRL, new Date(100L * rs.getLong("LUPDATE")), null));
                    }
                    finally {
                        this.datasource.releaseResources(null, rs);
                    }
                }
            }
            catch (SQLException ex) {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(this.sqlSelectUnrevokedSn, ex).getMessage());
            }
            finally {
                this.datasource.releaseResources((Statement)ps, null);
            }
        }
        int numEntries = 1000;
        String coreSql = "ID,SN,RR,RT,RIT FROM CERT WHERE ID>? AND CA_ID=? AND REV=1 AND NAFTER>? AND LUPDATE>?";
        String sql = this.datasource.buildSelectFirstSql(1000, "ID ASC", coreSql);
        ps = this.prepareStatement(sql);
        long startId = 1L;
        long updatedSince = crl.getThisUpdate().getDate().getTime() / 1000L - 1L;
        try {
            while (true) {
                ps.setLong(1, startId - 1L);
                ps.setInt(2, ca.getId());
                ps.setLong(3, notExpiredAt.getTime() / 1000L + 1L);
                ps.setLong(4, updatedSince);
                ResultSet rs2 = ps.executeQuery();
                try {
                    int num = 0;
                    while (rs2.next()) {
                        ++num;
                        long id = rs2.getLong("ID");
                        if (id > startId) {
                            startId = id;
                        }
                        BigInteger sn = new BigInteger(rs2.getString("SN"), 16);
                        if (allSnSet != null && allSnSet.contains(sn)) continue;
                        long revInvalidityTime = rs2.getLong("RIT");
                        Date invalidityTime = revInvalidityTime == 0L ? null : new Date(1000L * revInvalidityTime);
                        CertRevInfoWithSerial revInfo = new CertRevInfoWithSerial(id, sn, rs2.getInt("RR"), new Date(1000L * rs2.getLong("RT")), invalidityTime);
                        ret.add(revInfo);
                    }
                    if (num >= 1000) continue;
                }
                finally {
                    this.datasource.releaseResources(null, rs2);
                    continue;
                }
                break;
            }
        }
        catch (SQLException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
        return ret;
    }

    public CertStatus getCertStatusForSubject(NameId ca, X500Name subject) throws OperationException {
        long subjectFp = X509Util.fpCanonicalizedName((X500Name)subject);
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlCertStatusForSubjectFp, CertStore.col2Long(subjectFp), CertStore.col2Int(ca.getId()));
        return rs == null ? CertStatus.UNKNOWN : (rs.getBoolean("REV") ? CertStatus.REVOKED : CertStatus.GOOD);
    }

    public boolean isHealthy() {
        try {
            this.execUpdateStmt("SELECT ID FROM CA");
            return true;
        }
        catch (Exception ex) {
            LOG.error("isHealthy(). {}: {}", (Object)ex.getClass().getName(), (Object)ex.getMessage());
            LOG.debug("isHealthy()", (Throwable)ex);
            return false;
        }
    }

    public void deleteUnreferencedRequests() throws OperationException {
        this.execUpdateStmt0("DELETE FROM REQUEST WHERE ID NOT IN (SELECT req.RID FROM REQCERT req)");
    }

    public long addRequest(byte[] request) throws OperationException {
        Args.notNull((Object)request, (String)"request");
        long id = this.idGenerator.nextId();
        long currentTimeSeconds = System.currentTimeMillis() / 1000L;
        this.execUpdatePrepStmt0("INSERT INTO REQUEST (ID,LUPDATE,DATA) VALUES(?,?,?)", CertStore.col2Long(id), CertStore.col2Long(currentTimeSeconds), CertStore.col2Str(Base64.encodeToString((byte[])request)));
        return id;
    }

    public void addRequestCert(long requestId, long certId) throws OperationException {
        long id = this.idGenerator.nextId();
        this.execUpdatePrepStmt0("INSERT INTO REQCERT (ID,RID,CID) VALUES(?,?,?)", CertStore.col2Long(id), CertStore.col2Long(requestId), CertStore.col2Long(certId));
    }

    private static Long getDateSeconds(Date date) {
        return date == null ? null : Long.valueOf(date.getTime() / 1000L);
    }

    public static class KnowCertResult {
        public static final KnowCertResult UNKNOWN = new KnowCertResult(false, null);
        private final boolean known;
        private final Integer userId;

        public KnowCertResult(boolean known, Integer userId) {
            this.known = known;
            this.userId = userId;
        }

        public boolean isKnown() {
            return this.known;
        }

        public Integer getUserId() {
            return this.userId;
        }
    }

    public static class SystemEvent {
        private final String name;
        private final String owner;
        private final long eventTime;

        public SystemEvent(String name, String owner, long eventTime) {
            this.name = Args.notBlank((String)name, (String)"name");
            this.owner = Args.notBlank((String)owner, (String)"owner");
            this.eventTime = eventTime;
        }

        public String getName() {
            return this.name;
        }

        public String getOwner() {
            return this.owner;
        }

        public long getEventTime() {
            return this.eventTime;
        }
    }

    public static class SerialWithId {
        private final long id;
        private final BigInteger serial;

        public SerialWithId(long id, BigInteger serial) {
            this.id = id;
            this.serial = serial;
        }

        public BigInteger getSerial() {
            return this.serial;
        }

        public long getId() {
            return this.id;
        }
    }

    public static enum CertStatus {
        UNKNOWN,
        REVOKED,
        GOOD;

    }
}

