/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.mgmt.CaConf;
import org.xipki.ca.api.mgmt.CaConfType;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.entry.AddUserEntry;
import org.xipki.ca.api.mgmt.entry.CaEntry;
import org.xipki.ca.api.mgmt.entry.CaHasRequestorEntry;
import org.xipki.ca.api.mgmt.entry.CaHasUserEntry;
import org.xipki.ca.api.mgmt.entry.CertprofileEntry;
import org.xipki.ca.api.mgmt.entry.PublisherEntry;
import org.xipki.ca.api.mgmt.entry.RequestorEntry;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.ca.api.mgmt.entry.UserEntry;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.PasswordHash;
import org.xipki.ca.server.db.CaManagerQueryExecutor;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.FileOrBinary;
import org.xipki.util.FileOrValue;
import org.xipki.util.InvalidConfException;
import org.xipki.util.LogUtil;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.StringUtil;

class ConfLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ConfLoader.class);
    CaManagerImpl manager;

    ConfLoader(CaManagerImpl manager) {
        this.manager = (CaManagerImpl)Args.notNull((Object)manager, (String)"manager");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Map<String, X509Cert> loadConf(InputStream zippedConfStream) throws CaMgmtException {
        RequestorEntry entryB;
        RequestorEntry entry;
        CaConf conf;
        this.manager.assertMasterModeAndSetuped();
        Args.notNull((Object)zippedConfStream, (String)"zippedConfStream");
        SecurityFactory securityFactory = this.manager.securityFactory;
        CaManagerQueryExecutor queryExecutor = this.manager.queryExecutor;
        try {
            conf = new CaConf(zippedConfStream, securityFactory);
        }
        catch (IOException | InvalidConfException ex) {
            throw new CaMgmtException("could not parse the CA configuration", ex);
        }
        catch (RuntimeException ex) {
            throw new CaMgmtException("caught RuntimeException while parsing the CA configuration", (Throwable)ex);
        }
        HashMap<String, X509Cert> generatedRootCerts = new HashMap<String, X509Cert>(2);
        for (String name : conf.getSignerNames()) {
            SignerEntry entry2 = conf.getSigner(name);
            SignerEntry entryB2 = this.manager.signerDbEntries.get(name);
            if (entryB2 != null) {
                if (!entry2.equals((Object)entryB2)) throw ConfLoader.logAndCreateException(StringUtil.concat((String)"signer ", (String[])new String[]{name, " existed, could not re-added it"}));
                LOG.info("ignore existed signer {}", (Object)name);
                continue;
            }
            try {
                this.manager.addSigner(entry2);
                LOG.info("added signer {}", (Object)name);
            }
            catch (CaMgmtException ex) {
                String msg = StringUtil.concat((String)"could not add signer ", (String[])new String[]{name});
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                throw new CaMgmtException(msg);
            }
        }
        boolean ignoreId = true;
        for (String name : conf.getRequestorNames()) {
            entry = conf.getRequestor(name);
            entryB = this.manager.getRequestor(name);
            if (entryB != null) {
                if (!entry.equals(entryB, true)) throw ConfLoader.logAndCreateException(StringUtil.concat((String)"CMP requestor ", (String[])new String[]{name, " existed, could not re-added it"}));
                LOG.info("ignore existed CMP requestor {}", (Object)name);
                continue;
            }
            try {
                this.manager.addRequestor(entry);
                LOG.info("added CMP requestor {}", (Object)name);
            }
            catch (CaMgmtException ex) {
                String msg = StringUtil.concat((String)"could not add CMP requestor ", (String[])new String[]{name});
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                throw new CaMgmtException(msg);
            }
        }
        for (String name : conf.getPublisherNames()) {
            entry = conf.getPublisher(name);
            entryB = this.manager.getPublisher(name);
            if (entryB != null) {
                if (!entry.equals((PublisherEntry)entryB, true)) throw ConfLoader.logAndCreateException(StringUtil.concat((String)"publisher ", (String[])new String[]{name, " existed, could not re-added it"}));
                LOG.info("ignore existed publisher {}", (Object)name);
                continue;
            }
            try {
                this.manager.addPublisher((PublisherEntry)entry);
                LOG.info("added publisher {}", (Object)name);
            }
            catch (CaMgmtException ex) {
                String msg = "could not add publisher " + name;
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                throw new CaMgmtException(msg);
            }
        }
        for (String name : conf.getCertprofileNames()) {
            entry = conf.getCertprofile(name);
            entryB = this.manager.getCertprofile(name);
            if (entryB != null) {
                if (!entry.equals((CertprofileEntry)entryB, true)) throw ConfLoader.logAndCreateException(StringUtil.concat((String)"certprofile ", (String[])new String[]{name, " existed, could not re-added it"}));
                LOG.info("ignore existed certprofile {}", (Object)name);
                continue;
            }
            try {
                this.manager.addCertprofile((CertprofileEntry)entry);
                LOG.info("added certprofile {}", (Object)name);
            }
            catch (CaMgmtException ex) {
                String msg = StringUtil.concat((String)"could not add certprofile ", (String[])new String[]{name});
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                throw new CaMgmtException(msg);
            }
        }
        for (String name : conf.getUserNames()) {
            Object obj = conf.getUser(name);
            entryB = queryExecutor.getUser(name, true);
            if (entryB != null) {
                boolean equals;
                UserEntry entry3;
                if (obj instanceof UserEntry) {
                    entry3 = (UserEntry)obj;
                    equals = entry3.equals((UserEntry)entryB, true);
                } else {
                    entry3 = (AddUserEntry)obj;
                    equals = PasswordHash.validatePassword(entry3.getPassword(), entryB.getHashedPassword());
                }
                if (!equals) throw ConfLoader.logAndCreateException(StringUtil.concat((String)"user ", (String[])new String[]{name, " existed, could not re-added it"}));
                LOG.info("ignore existed user {}", (Object)name);
                continue;
            }
            try {
                if (obj instanceof UserEntry) {
                    queryExecutor.addUser((UserEntry)obj);
                } else {
                    queryExecutor.addUser((AddUserEntry)obj);
                }
                LOG.info("added user {}", (Object)name);
            }
            catch (CaMgmtException ex) {
                String msg = StringUtil.concat((String)"could not add user ", (String[])new String[]{name});
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                throw new CaMgmtException(msg);
            }
        }
        for (String caName : conf.getCaNames()) {
            String msg;
            CaConf.SingleCa scc = conf.getCa(caName);
            CaConf.GenSelfIssued genSelfIssued = scc.getGenSelfIssued();
            CaEntry caEntry = scc.getCaEntry();
            if (caEntry != null) {
                if (this.manager.caInfos.containsKey(caName)) {
                    CaEntry entryB3 = this.manager.caInfos.get(caName).getCaEntry();
                    if (caEntry.getCert() == null && genSelfIssued != null) {
                        ConcurrentContentSigner signer;
                        SignerConf signerConf = new SignerConf(caEntry.getSignerConf());
                        try {
                            signer = securityFactory.createSigner(caEntry.getSignerType(), signerConf, (X509Cert)null);
                        }
                        catch (ObjectCreationException ex) {
                            throw new CaMgmtException(StringUtil.concat((String)"could not create signer for CA ", (String[])new String[]{caName}), (Throwable)ex);
                        }
                        caEntry.setCert(signer.getCertificate());
                    }
                    if (!caEntry.equals(entryB3, true, true)) throw ConfLoader.logAndCreateException(StringUtil.concat((String)"CA ", (String[])new String[]{caName, " existed, could not re-added it"}));
                    LOG.info("ignore existing CA {}", (Object)caName);
                } else if (genSelfIssued != null) {
                    X509Cert cert = this.manager.generateRootCa(caEntry, genSelfIssued.getProfile(), genSelfIssued.getCsr(), genSelfIssued.getSerialNumber());
                    LOG.info("generated root CA {}", (Object)caName);
                    generatedRootCerts.put(caName, cert);
                } else {
                    try {
                        this.manager.addCa(caEntry);
                        LOG.info("added CA {}", (Object)caName);
                    }
                    catch (CaMgmtException ex) {
                        String msg2 = StringUtil.concat((String)"could not add CA ", (String[])new String[]{caName});
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg2);
                        throw new CaMgmtException(msg2);
                    }
                }
            }
            if (scc.getAliases() != null) {
                Set<String> aliasesB = this.manager.getAliasesForCa(caName);
                for (String aliasName : scc.getAliases()) {
                    if (aliasesB != null && aliasesB.contains(aliasName)) {
                        LOG.info("ignored adding existing CA alias {} to CA {}", (Object)aliasName, (Object)caName);
                        continue;
                    }
                    try {
                        this.manager.addCaAlias(aliasName, caName);
                        LOG.info("associated alias {} to CA {}", (Object)aliasName, (Object)caName);
                    }
                    catch (CaMgmtException ex) {
                        msg = StringUtil.concat((String)"could not associate alias ", (String[])new String[]{aliasName, " to CA ", caName});
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                        throw new CaMgmtException(msg);
                    }
                }
            }
            if (scc.getProfileNames() != null) {
                Set<String> profilesB = this.manager.caHasProfiles.get(caName);
                for (String profileName : scc.getProfileNames()) {
                    if (profilesB != null && profilesB.contains(profileName)) {
                        LOG.info("ignored adding certprofile {} to CA {}", (Object)profileName, (Object)caName);
                        continue;
                    }
                    try {
                        this.manager.addCertprofileToCa(profileName, caName);
                        LOG.info("added certprofile {} to CA {}", (Object)profileName, (Object)caName);
                    }
                    catch (CaMgmtException ex) {
                        msg = StringUtil.concat((String)"could not add certprofile ", (String[])new String[]{profileName, " to CA ", caName});
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                        throw new CaMgmtException(msg);
                    }
                }
            }
            if (scc.getPublisherNames() != null) {
                Set<String> publishersB = this.manager.caHasPublishers.get(caName);
                for (String publisherName : scc.getPublisherNames()) {
                    if (publishersB != null && publishersB.contains(publisherName)) {
                        LOG.info("ignored adding publisher {} to CA {}", (Object)publisherName, (Object)caName);
                        continue;
                    }
                    try {
                        this.manager.addPublisherToCa(publisherName, caName);
                        LOG.info("added publisher {} to CA {}", (Object)publisherName, (Object)caName);
                    }
                    catch (CaMgmtException ex) {
                        msg = StringUtil.concat((String)"could not add publisher ", (String[])new String[]{publisherName, " to CA ", caName});
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                        throw new CaMgmtException(msg);
                    }
                }
            }
            if (scc.getRequestors() != null) {
                Set<CaHasRequestorEntry> requestorsB = this.manager.caHasRequestors.get(caName);
                for (CaHasRequestorEntry requestor : scc.getRequestors()) {
                    String requestorName = requestor.getRequestorIdent().getName();
                    CaHasRequestorEntry requestorB = null;
                    if (requestorsB != null) {
                        for (CaHasRequestorEntry caHasRequestorEntry : requestorsB) {
                            if (!caHasRequestorEntry.getRequestorIdent().getName().equals(requestorName)) continue;
                            requestorB = caHasRequestorEntry;
                            break;
                        }
                    }
                    if (requestorB != null) {
                        if (!requestor.equals(requestorB, true)) throw ConfLoader.logAndCreateException(StringUtil.concat((String)"could not add requestor ", (String[])new String[]{requestorName, " to CA", caName}));
                        LOG.info("ignored adding requestor {} to CA {}", (Object)requestorName, (Object)caName);
                        continue;
                    }
                    try {
                        this.manager.addRequestorToCa(requestor, caName);
                        LOG.info("added publisher {} to CA {}", (Object)requestorName, (Object)caName);
                    }
                    catch (CaMgmtException ex) {
                        String string = StringUtil.concat((String)"could not add requestor ", (String[])new String[]{requestorName, " to CA ", caName});
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)string);
                        throw new CaMgmtException(string);
                    }
                }
            }
            if (scc.getUsers() == null) continue;
            List<CaHasUserEntry> usersB = queryExecutor.getCaHasUsersForCa(caName, this.manager.idNameMap);
            for (CaHasUserEntry user : scc.getUsers()) {
                String userName = user.getUserIdent().getName();
                CaHasUserEntry userB = null;
                if (usersB != null) {
                    for (CaHasUserEntry caHasUserEntry : usersB) {
                        if (!caHasUserEntry.getUserIdent().getName().equals(userName)) continue;
                        userB = caHasUserEntry;
                        break;
                    }
                }
                if (userB != null) {
                    if (!user.equals(userB, true)) throw ConfLoader.logAndCreateException(StringUtil.concat((String)"could not add user ", (String[])new String[]{userName, " to CA", caName}));
                    LOG.info("ignored adding user {} to CA {}", (Object)userName, (Object)caName);
                    continue;
                }
                try {
                    this.manager.addUserToCa(user, caName);
                    LOG.info("added user {} to CA {}", (Object)userName, (Object)caName);
                }
                catch (CaMgmtException ex) {
                    String string = StringUtil.concat((String)"could not add user ", (String[])new String[]{userName, " to CA ", caName});
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)string);
                    throw new CaMgmtException(string);
                }
            }
        }
        if (generatedRootCerts.isEmpty()) {
            return null;
        }
        HashMap<String, X509Cert> hashMap = generatedRootCerts;
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream exportConf(List<String> caNames) throws CaMgmtException, IOException {
        this.manager.assertMasterModeAndSetuped();
        if (caNames != null) {
            ArrayList<String> tmpCaNames = new ArrayList<String>(caNames.size());
            for (String name : caNames) {
                if (!this.manager.x509cas.containsKey(name = name.toLowerCase())) continue;
                tmpCaNames.add(name);
            }
            caNames = tmpCaNames;
        } else {
            caNames = new ArrayList<String>(this.manager.x509cas.keySet());
        }
        ByteArrayOutputStream bytesStream = new ByteArrayOutputStream(0x100000);
        ZipOutputStream zipStream = new ZipOutputStream(bytesStream);
        zipStream.setLevel(1);
        CaConfType.CaSystem root = new CaConfType.CaSystem();
        CaManagerQueryExecutor queryExecutor = this.manager.queryExecutor;
        try {
            CaConfType.NameTypeConf conf;
            RequestorEntry entry;
            LinkedList<Object> list;
            HashSet<String> includeSignerNames = new HashSet<String>();
            HashSet<String> includeRequestorNames = new HashSet<String>();
            HashSet<String> includeProfileNames = new HashSet<String>();
            HashSet<String> includePublisherNames = new HashSet<String>();
            HashSet<String> includeCrlSignerNames = new HashSet<String>();
            HashSet<String> includeUserNames = new HashSet<String>();
            LinkedList<CaConfType.User> users = new LinkedList<CaConfType.User>();
            root.setUsers(users);
            if (CollectionUtil.isNotEmpty(caNames)) {
                list = new LinkedList<Object>();
                for (String name : this.manager.x509cas.keySet()) {
                    List<CaHasUserEntry> caHasUsers;
                    Set<CaHasRequestorEntry> requestors;
                    if (!caNames.contains(name)) continue;
                    CaConfType.Ca ca = new CaConfType.Ca();
                    ca.setName(name);
                    Set<String> strs = this.manager.getAliasesForCa(name);
                    if (CollectionUtil.isNotEmpty(strs)) {
                        ca.setAliases(new ArrayList<String>(strs));
                    }
                    if (CollectionUtil.isNotEmpty(requestors = this.manager.caHasRequestors.get(name))) {
                        ca.setRequestors(new ArrayList());
                        for (CaHasRequestorEntry caHasRequestorEntry : requestors) {
                            String requestorName = caHasRequestorEntry.getRequestorIdent().getName();
                            includeRequestorNames.add(requestorName);
                            CaConfType.CaHasRequestor chr = new CaConfType.CaHasRequestor();
                            chr.setRequestorName(requestorName);
                            chr.setRa(caHasRequestorEntry.isRa());
                            chr.setProfiles(new ArrayList(caHasRequestorEntry.getProfiles()));
                            chr.setPermissions(CaUtil.getPermissions(caHasRequestorEntry.getPermission()));
                            ca.getRequestors().add(chr);
                        }
                    }
                    if (CollectionUtil.isNotEmpty(caHasUsers = queryExecutor.getCaHasUsersForCa(name, this.manager.idNameMap))) {
                        ca.setUsers(new ArrayList());
                        for (CaHasUserEntry m2 : caHasUsers) {
                            String username = m2.getUserIdent().getName();
                            CaConfType.CaHasUser chu = new CaConfType.CaHasUser();
                            chu.setUserName(username);
                            chu.setProfiles(new ArrayList(m2.getProfiles()));
                            chu.setPermissions(CaUtil.getPermissions(m2.getPermission()));
                            ca.getUsers().add(chu);
                            if (includeUserNames.contains(username)) continue;
                            UserEntry userEntry = queryExecutor.getUser(username);
                            CaConfType.User userType = new CaConfType.User();
                            if (!userEntry.isActive()) {
                                userType.setActive(Boolean.FALSE);
                            }
                            userType.setName(username);
                            userType.setHashedPassword(userEntry.getHashedPassword());
                            users.add(userType);
                            includeUserNames.add(username);
                        }
                    }
                    if (CollectionUtil.isNotEmpty(strs = this.manager.caHasProfiles.get(name))) {
                        includeProfileNames.addAll(strs);
                        ca.setProfiles(new ArrayList<String>(strs));
                    }
                    if (CollectionUtil.isNotEmpty(strs = this.manager.caHasPublishers.get(name))) {
                        includePublisherNames.addAll(strs);
                        ca.setPublishers(new ArrayList<String>(strs));
                    }
                    CaConfType.CaInfo caInfo = new CaConfType.CaInfo();
                    ca.setCaInfo(caInfo);
                    CaEntry entry2 = this.manager.x509cas.get(name).getCaInfo().getCaEntry();
                    CaUris caUris = entry2.getCaUris();
                    if (caUris != null) {
                        CaConfType.CaUris caUrisType = new CaConfType.CaUris();
                        caUrisType.setCacertUris(caUris.getCacertUris());
                        caUrisType.setOcspUris(caUris.getOcspUris());
                        caUrisType.setCrlUris(caUris.getCrlUris());
                        caUrisType.setDeltacrlUris(caUris.getDeltaCrlUris());
                        caInfo.setCaUris(caUrisType);
                    }
                    byte[] certBytes = entry2.getCert().getEncoded();
                    caInfo.setCert(CaUtil.createFileOrBinary(zipStream, certBytes, StringUtil.concat((String)"files/ca-", (String[])new String[]{name, "-cert.der"})));
                    List certchain = entry2.getCertchain();
                    if (CollectionUtil.isNotEmpty((Collection)certchain)) {
                        LinkedList<FileOrBinary> ccList = new LinkedList<FileOrBinary>();
                        for (int i = 0; i < certchain.size(); ++i) {
                            certBytes = ((X509Cert)certchain.get(i)).getEncoded();
                            ccList.add(CaUtil.createFileOrBinary(zipStream, certBytes, StringUtil.concat((String)"files/ca-", (String[])new String[]{name, "-certchain-" + i + ".der"})));
                        }
                        caInfo.setCertchain(ccList);
                    }
                    if (entry2.getCmpControl() != null) {
                        caInfo.setCmpControl(new HashMap(new ConfPairs(entry2.getCmpControl().getConf()).asMap()));
                    }
                    if (entry2.getCmpResponderName() != null) {
                        includeSignerNames.add(entry2.getCmpResponderName());
                        caInfo.setCmpResponderName(entry2.getCmpResponderName());
                    }
                    if (entry2.getCrlControl() != null) {
                        caInfo.setCrlControl(new HashMap(new ConfPairs(entry2.getCrlControl().getConf()).asMap()));
                    }
                    if (entry2.getCrlSignerName() != null) {
                        includeCrlSignerNames.add(entry2.getCrlSignerName());
                        caInfo.setCrlSignerName(entry2.getCrlSignerName());
                    }
                    if (entry2.getCtlogControl() != null) {
                        caInfo.setCtlogControl(new HashMap(new ConfPairs(entry2.getCtlogControl().getConf()).asMap()));
                    }
                    if (entry2.getDhpocControl() != null) {
                        FileOrValue fv = CaUtil.createFileOrValue(zipStream, entry2.getDhpocControl(), StringUtil.concat((String)"files/ca-", (String[])new String[]{name, "-dhpoc.conf"}));
                        caInfo.setDhpocControl(fv);
                    }
                    caInfo.setExpirationPeriod(Integer.valueOf(entry2.getExpirationPeriod()));
                    if (entry2.getExtraControl() != null) {
                        caInfo.setExtraControl(entry2.getExtraControl().asMap());
                    }
                    caInfo.setKeepExpiredCertDays(Integer.valueOf(entry2.getKeepExpiredCertInDays()));
                    caInfo.setMaxValidity(entry2.getMaxValidity().toString());
                    caInfo.setNextCrlNo(entry2.getNextCrlNumber());
                    caInfo.setNumCrls(Integer.valueOf(entry2.getNumCrls()));
                    caInfo.setPermissions(CaUtil.getPermissions(entry2.getPermission()));
                    caInfo.setProtocolSupport(StringUtil.splitAsSet((String)entry2.getProtocoSupport().getEncoded(), (String)","));
                    if (entry2.getRevokeSuspendedControl() != null) {
                        caInfo.setRevokeSuspendedControl(new HashMap(new ConfPairs(entry2.getRevokeSuspendedControl().getConf()).asMap()));
                    }
                    caInfo.setSaveReq(entry2.isSaveRequest());
                    if (entry2.getScepControl() != null) {
                        caInfo.setScepControl(new HashMap(new ConfPairs(entry2.getScepControl().getConf()).asMap()));
                    }
                    if (entry2.getScepResponderName() != null) {
                        includeSignerNames.add(entry2.getScepResponderName());
                        caInfo.setScepResponderName(entry2.getScepResponderName());
                    }
                    caInfo.setSignerConf(CaUtil.createFileOrValue(zipStream, entry2.getSignerConf(), StringUtil.concat((String)"files/ca-", (String[])new String[]{name, "-signerconf.conf"})));
                    caInfo.setSignerType(entry2.getSignerType());
                    caInfo.setSnSize(entry2.getSerialNoLen());
                    caInfo.setStatus(entry2.getStatus().getStatus());
                    caInfo.setValidityMode(entry2.getValidityMode().name());
                    list.add(ca);
                }
                if (!list.isEmpty()) {
                    root.setCas(list);
                }
            }
            if (users.isEmpty()) {
                root.setUsers(null);
            }
            if (CollectionUtil.isNotEmpty(this.manager.requestorDbEntries)) {
                list = new LinkedList();
                for (String name : this.manager.requestorDbEntries.keySet()) {
                    if (!includeRequestorNames.contains(name)) continue;
                    entry = this.manager.requestorDbEntries.get(name);
                    CaConfType.Requestor type = new CaConfType.Requestor();
                    type.setName(name);
                    type.setType(entry.getType());
                    if ("cert".equalsIgnoreCase(entry.getType())) {
                        FileOrBinary fob = CaUtil.createFileOrBinary(zipStream, Base64.decode((String)entry.getConf()), StringUtil.concat((String)"files/requestor-", (String[])new String[]{name, ".der"}));
                        type.setBinaryConf(fob);
                    } else {
                        FileOrValue fov = CaUtil.createFileOrValue(zipStream, entry.getConf(), StringUtil.concat((String)"files/requestor-", (String[])new String[]{name, ".conf"}));
                        type.setConf(fov);
                    }
                    list.add(type);
                }
                if (!list.isEmpty()) {
                    root.setRequestors(list);
                }
            }
            if (CollectionUtil.isNotEmpty(this.manager.publisherDbEntries)) {
                list = new LinkedList();
                for (String name : this.manager.publisherDbEntries.keySet()) {
                    if (!includePublisherNames.contains(name)) continue;
                    entry = this.manager.publisherDbEntries.get(name);
                    conf = new CaConfType.NameTypeConf();
                    conf.setName(name);
                    conf.setType(entry.getType());
                    conf.setConf(CaUtil.createFileOrValue(zipStream, entry.getConf(), StringUtil.concat((String)"files/publisher-", (String[])new String[]{name, ".conf"})));
                    list.add(conf);
                }
                if (!list.isEmpty()) {
                    root.setPublishers(list);
                }
            }
            if (CollectionUtil.isNotEmpty(this.manager.certprofileDbEntries)) {
                list = new LinkedList();
                for (String name : this.manager.certprofileDbEntries.keySet()) {
                    if (!includeProfileNames.contains(name)) continue;
                    entry = this.manager.certprofileDbEntries.get(name);
                    conf = new CaConfType.NameTypeConf();
                    conf.setName(name);
                    conf.setType(entry.getType());
                    conf.setConf(CaUtil.createFileOrValue(zipStream, entry.getConf(), StringUtil.concat((String)"files/certprofile-", (String[])new String[]{name, ".conf"})));
                    list.add(conf);
                }
                if (!list.isEmpty()) {
                    root.setProfiles(list);
                }
            }
            if (CollectionUtil.isNotEmpty(this.manager.signerDbEntries)) {
                list = new LinkedList();
                for (String name : this.manager.signerDbEntries.keySet()) {
                    if (!includeSignerNames.contains(name)) continue;
                    entry = this.manager.signerDbEntries.get(name);
                    conf = new CaConfType.Signer();
                    conf.setName(name);
                    conf.setType(entry.getType());
                    conf.setConf(CaUtil.createFileOrValue(zipStream, entry.getConf(), StringUtil.concat((String)"files/signer-", (String[])new String[]{name, ".conf"})));
                    conf.setCert(CaUtil.createFileOrBase64Value(zipStream, entry.getBase64Cert(), StringUtil.concat((String)"files/signer-", (String[])new String[]{name, ".der"})));
                    list.add(conf);
                }
                if (!list.isEmpty()) {
                    root.setSigners(list);
                }
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                root.validate();
                JSON.writeJSONString((OutputStream)bout, (Object)root, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
            }
            catch (InvalidConfException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not marshal CAConf");
                throw new CaMgmtException(StringUtil.concat((String)"could not marshal CAConf: ", (String[])new String[]{ex.getMessage()}), (Throwable)ex);
            }
            finally {
                bout.flush();
            }
            zipStream.putNextEntry(new ZipEntry("caconf.json"));
            try {
                zipStream.write(bout.toByteArray());
            }
            finally {
                zipStream.closeEntry();
            }
        }
        finally {
            zipStream.flush();
            zipStream.close();
        }
        return new ByteArrayInputStream(bytesStream.toByteArray());
    }

    private static CaMgmtException logAndCreateException(String msg) {
        LOG.error(msg);
        return new CaMgmtException(msg);
    }
}

