/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.SignerEntryWrapper;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.util.Args;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.StringUtil;

class SignerManager {
    private static final Logger LOG = LoggerFactory.getLogger(SignerManager.class);
    private boolean signerInitialized;
    private final CaManagerImpl manager;

    SignerManager(CaManagerImpl manager) {
        this.manager = manager;
    }

    void reset() {
        this.signerInitialized = false;
    }

    void initSigners() throws CaMgmtException {
        if (this.signerInitialized) {
            return;
        }
        this.manager.signerDbEntries.clear();
        this.manager.signers.clear();
        List names = this.manager.queryExecutor.namesFromTable("SIGNER");
        for (String name : names) {
            SignerEntry entry = this.manager.queryExecutor.createSigner(name);
            if (entry == null) {
                LOG.error("could not initialize signer '{}'", (Object)name);
                continue;
            }
            entry.setConfFaulty(true);
            this.manager.signerDbEntries.put(name, entry);
            SignerEntryWrapper signer = this.createSigner(entry);
            if (signer != null) {
                entry.setConfFaulty(false);
                this.manager.signers.put(name, signer);
                LOG.info("loaded signer {}", (Object)name);
                continue;
            }
            LOG.error("could not load signer {}", (Object)name);
        }
        this.signerInitialized = true;
    }

    void addSigner(SignerEntry signerEntry) throws CaMgmtException {
        String newConf;
        this.manager.assertMasterModeAndSetuped();
        Args.notNull((Object)signerEntry, (String)"signerEntry");
        String name = signerEntry.getName();
        if (this.manager.signerDbEntries.containsKey(name)) {
            throw new CaMgmtException(StringUtil.concat((String)"Signer named ", (String[])new String[]{name, " exists"}));
        }
        String conf = signerEntry.getConf();
        if (conf != null && !conf.equals(newConf = CaUtil.canonicalizeSignerConf(signerEntry.getType(), conf, null, this.manager.securityFactory))) {
            signerEntry.setConf(newConf);
        }
        SignerEntryWrapper signer = this.createSigner(signerEntry);
        this.manager.queryExecutor.addSigner(signerEntry);
        this.manager.signers.put(name, signer);
        this.manager.signerDbEntries.put(name, signerEntry);
    }

    void removeSigner(String name) throws CaMgmtException {
        this.manager.assertMasterModeAndSetuped();
        name = Args.toNonBlankLower((String)name, (String)"name");
        boolean bo = this.manager.queryExecutor.deleteRowWithName(name, "SIGNER");
        if (!bo) {
            throw new CaMgmtException("unknown signer " + name);
        }
        for (String caName : this.manager.caInfos.keySet()) {
            CaInfo caInfo = this.manager.caInfos.get(caName);
            if (name.equals(caInfo.getCmpResponderName())) {
                caInfo.setCmpResponderName(null);
            }
            if (name.equals(caInfo.getScepResponderName())) {
                caInfo.setScepResponderName(null);
            }
            if (!name.equals(caInfo.getCrlSignerName())) continue;
            caInfo.setCrlSignerName(null);
        }
        this.manager.signerDbEntries.remove(name);
        this.manager.signers.remove(name);
        LOG.info("removed signer '{}'", (Object)name);
    }

    void changeSigner(String name, String type, String conf, String base64Cert) throws CaMgmtException {
        this.manager.assertMasterModeAndSetuped();
        name = Args.toNonBlankLower((String)name, (String)"name");
        if (type == null && conf == null && base64Cert == null) {
            throw new IllegalArgumentException("nothing to change");
        }
        if (type != null) {
            type = type.toLowerCase();
        }
        SignerEntryWrapper newResponder = this.manager.queryExecutor.changeSigner(name, type, conf, base64Cert, this.manager, this.manager.securityFactory);
        this.manager.signers.remove(name);
        this.manager.signerDbEntries.remove(name);
        this.manager.signerDbEntries.put(name, newResponder.getDbEntry());
        this.manager.signers.put(name, newResponder);
        for (String caName : this.manager.scepResponders.keySet()) {
            if (!this.manager.getCa(caName).getScepResponderName().equals(name)) continue;
            this.manager.scepResponders.get(caName).setResponder(newResponder);
        }
    }

    SignerEntryWrapper createSigner(SignerEntry entry) throws CaMgmtException {
        Args.notNull((Object)entry, (String)"entry");
        SignerEntryWrapper ret = new SignerEntryWrapper();
        ret.setDbEntry(entry);
        try {
            ret.initSigner(this.manager.securityFactory);
        }
        catch (ObjectCreationException ex) {
            String message = "createSigner";
            LOG.debug("createSigner", (Throwable)ex);
            throw new CaMgmtException(ex.getMessage());
        }
        return ret;
    }
}

