/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xipki.audit.Audits;
import org.xipki.datasource.DataSourceConf;
import org.xipki.security.Securities;
import org.xipki.util.Args;
import org.xipki.util.FileOrBinary;
import org.xipki.util.InvalidConfException;
import org.xipki.util.ValidatableConf;
import org.xipki.util.http.SslContextConf;

public class CaServerConf
extends ValidatableConf {
    private Audits.AuditConf audit;
    private Securities.SecurityConf security;
    private RemoteMgmt remoteMgmt;
    private boolean master = true;
    private int shardId = 0;
    private List<DataSourceConf> datasources;
    private List<SslContext> sslContexts;
    private CtLogConf ctLog;
    private List<String> certprofileFactories;
    @JSONField(serialize=false, deserialize=false)
    private Map<String, SslContextConf> sslContextConfMap = new HashMap<String, SslContextConf>();

    public static CaServerConf readConfFromFile(String fileName) throws IOException, InvalidConfException {
        Args.notBlank((String)fileName, (String)"fileName");
        try (InputStream is = Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]);){
            CaServerConf conf = (CaServerConf)((Object)JSON.parseObject((InputStream)is, CaServerConf.class, (Feature[])new Feature[0]));
            conf.validate();
            CaServerConf caServerConf = conf;
            return caServerConf;
        }
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    public int getShardId() {
        return this.shardId;
    }

    public void setShardId(int shardId) {
        this.shardId = shardId;
    }

    public List<DataSourceConf> getDatasources() {
        return this.datasources;
    }

    public void setDatasources(List<DataSourceConf> datasources) {
        this.datasources = datasources;
    }

    public List<SslContext> getSslContexts() {
        return this.sslContexts;
    }

    public void setSslContexts(List<SslContext> sslContexts) {
        this.sslContexts = sslContexts;
    }

    public SslContext getSslContext(String name) {
        if (this.sslContexts == null) {
            return null;
        }
        for (SslContext m : this.sslContexts) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public Audits.AuditConf getAudit() {
        return this.audit == null ? Audits.AuditConf.DEFAULT : this.audit;
    }

    public void setAudit(Audits.AuditConf audit) {
        this.audit = audit;
    }

    public Securities.SecurityConf getSecurity() {
        return this.security == null ? Securities.SecurityConf.DEFAULT : this.security;
    }

    public void setSecurity(Securities.SecurityConf security) {
        this.security = security;
    }

    public RemoteMgmt getRemoteMgmt() {
        return this.remoteMgmt;
    }

    public void setRemoteMgmt(RemoteMgmt remoteMgmt) {
        this.remoteMgmt = remoteMgmt;
    }

    public List<String> getCertprofileFactories() {
        return this.certprofileFactories;
    }

    public void setCertprofileFactories(List<String> certprofileFactories) {
        this.certprofileFactories = certprofileFactories;
    }

    public CtLogConf getCtLog() {
        return this.ctLog;
    }

    public void setCtLog(CtLogConf ctLog) {
        this.ctLog = ctLog;
    }

    public synchronized SslContextConf getSslContextConf(String name) {
        if (this.sslContexts == null || this.sslContexts.isEmpty()) {
            return null;
        }
        if (this.sslContextConfMap.isEmpty()) {
            for (SslContext m : this.sslContexts) {
                SslContextConf conf = new SslContextConf();
                conf.setSslHostnameVerifier(m.getHostverifier());
                Securities.KeystoreConf truststore = m.getTruststore();
                conf.setSslTruststore(truststore.getKeystore());
                conf.setSslTruststorePassword(truststore.getPassword());
                conf.setSslStoreType(truststore.getType());
                this.sslContextConfMap.put(m.getName(), conf);
            }
        }
        return this.sslContextConfMap.get(name);
    }

    public void validate() throws InvalidConfException {
        if (this.shardId < 0 || this.shardId > 127) {
            throw new InvalidConfException("shardId is not in [0, 127]");
        }
        CaServerConf.notEmpty(this.datasources, (String)"datasources");
        CaServerConf.validate((ValidatableConf)this.remoteMgmt);
        CaServerConf.validate((ValidatableConf)this.security);
    }

    public static class CtLogConf {
        private String keydir;

        public String getKeydir() {
            return this.keydir;
        }

        public void setKeydir(String keydir) {
            this.keydir = keydir;
        }
    }

    public static class RemoteMgmt
    extends ValidatableConf {
        private boolean enabled;
        private List<FileOrBinary> certs;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public List<FileOrBinary> getCerts() {
            return this.certs;
        }

        public void setCerts(List<FileOrBinary> certs) {
            this.certs = certs;
        }

        public void validate() throws InvalidConfException {
        }
    }

    public static class SslContext
    extends ValidatableConf {
        private String name;
        private Securities.KeystoreConf truststore;
        private String hostverifier;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Securities.KeystoreConf getTruststore() {
            return this.truststore;
        }

        public void setTruststore(Securities.KeystoreConf truststore) {
            this.truststore = truststore;
        }

        public String getHostverifier() {
            return this.hostverifier;
        }

        public void setHostverifier(String hostverifier) {
            this.hostverifier = hostverifier;
        }

        public void validate() throws InvalidConfException {
            SslContext.notBlank((String)this.name, (String)"name");
        }
    }
}

