/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.BadCertTemplateException;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.OperationException;
import org.xipki.ca.api.mgmt.RequestorInfo;
import org.xipki.ca.api.mgmt.ValidityMode;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.KeypairGenControl;
import org.xipki.ca.api.profile.NotAfterMode;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.CertTemplateData;
import org.xipki.ca.server.IdentifiedCertprofile;
import org.xipki.ca.server.X509Ca;
import org.xipki.ca.server.db.CertStore;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.EdECConstants;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.X509Cert;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.RSABrokenKey;
import org.xipki.security.util.X509Util;
import org.xipki.util.LogUtil;
import org.xipki.util.Validity;

class GrandCertTemplateBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(GrandCertTemplateBuilder.class);
    private static final long MAX_CERT_TIME_MS = 253402300799982L;
    private static final Date MAX_CERT_TIME = new Date(253402300799982L);
    private static final long MS_PER_10MINUTES = 300000L;
    private final KeypairGenControl keypairGenControlByImplictCA;
    private final CertStore certstore;
    private final CaInfo caInfo;
    private final SecureRandom random = new SecureRandom();

    GrandCertTemplateBuilder(CaInfo caInfo, CertStore certstore) {
        this.caInfo = caInfo;
        this.certstore = certstore;
        X509Cert caCert = caInfo.getCaEntry().getCert();
        SubjectPublicKeyInfo caSpki = caCert.getSubjectPublicKeyInfo();
        ASN1ObjectIdentifier caSpkiAlgId = caSpki.getAlgorithm().getAlgorithm();
        if (caSpkiAlgId.equals((ASN1Primitive)PKCSObjectIdentifiers.rsaEncryption)) {
            java.security.interfaces.RSAPublicKey pubKey = (java.security.interfaces.RSAPublicKey)caCert.getPublicKey();
            this.keypairGenControlByImplictCA = new KeypairGenControl.RSAKeypairGenControl(pubKey.getModulus().bitLength(), pubKey.getPublicExponent(), caSpkiAlgId);
        } else if (caSpkiAlgId.equals((ASN1Primitive)X9ObjectIdentifiers.id_ecPublicKey)) {
            ASN1ObjectIdentifier curveOid = ASN1ObjectIdentifier.getInstance((Object)caSpki.getAlgorithm().getParameters());
            this.keypairGenControlByImplictCA = new KeypairGenControl.ECKeypairGenControl(curveOid, caSpkiAlgId);
        } else if (caSpkiAlgId.equals((ASN1Primitive)X9ObjectIdentifiers.id_dsa)) {
            ASN1Sequence seq = DERSequence.getInstance((Object)caSpki.getAlgorithm().getParameters());
            BigInteger p = ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue();
            BigInteger q = ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getValue();
            BigInteger g = ASN1Integer.getInstance((Object)seq.getObjectAt(2)).getValue();
            this.keypairGenControlByImplictCA = new KeypairGenControl.DSAKeypairGenControl(p, q, g, caSpkiAlgId);
        } else {
            this.keypairGenControlByImplictCA = caSpkiAlgId.equals((ASN1Primitive)EdECConstants.id_ED25519) || caSpkiAlgId.equals((ASN1Primitive)EdECConstants.id_ED448) ? new KeypairGenControl.EDDSAKeypairGenControl(caSpkiAlgId) : null;
        }
    }

    X509Ca.GrantedCertTemplate create(IdentifiedCertprofile certprofile, CertTemplateData certTemplate, RequestorInfo requestor, boolean update) throws OperationException {
        Date grantedNotAfter;
        Validity validity;
        Certprofile.SubjectInfo subjectInfo;
        PrivateKeyInfo privateKey;
        SubjectPublicKeyInfo grantedPublicKeyInfo;
        RDN[] rdns;
        if (this.caInfo.getRevocationInfo() != null) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "CA is revoked");
        }
        if (certprofile == null) {
            throw new OperationException(OperationException.ErrorCode.UNKNOWN_CERT_PROFILE, "unknown cert profile " + certTemplate.getCertprofileName());
        }
        ConcurrentContentSigner signer = this.caInfo.getSigner(certprofile.getSignatureAlgorithms());
        if (signer == null) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "CA does not support any signature algorithm restricted by the cert profile");
        }
        NameId certprofileIdent = certprofile.getIdent();
        if (certprofile.getVersion() != Certprofile.X509CertVersion.v3) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "unknown cert version " + certprofile.getVersion());
        }
        if (certprofile.isOnlyForRa() && (requestor == null || !requestor.isRa())) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "profile " + certprofileIdent + " not applied to non-RA");
        }
        switch (certprofile.getCertLevel()) {
            case RootCA: {
                throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "CA is not allowed to generate Root CA certificate");
            }
            case SubCA: {
                boolean allowed;
                Integer reqPathlen = certprofile.getPathLenBasicConstraint();
                int caPathLen = this.caInfo.getPathLenConstraint();
                boolean bl = allowed = reqPathlen == null && caPathLen == Integer.MAX_VALUE || reqPathlen != null && reqPathlen < caPathLen;
                if (allowed) break;
                throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "invalid BasicConstraint.pathLenConstraint");
            }
        }
        X500Name requestedSubject = CaUtil.removeEmptyRdns(certTemplate.getSubject());
        if (!certprofile.isSerialNumberInReqPermitted() && (rdns = requestedSubject.getRDNs(ObjectIdentifiers.DN.SN)) != null && rdns.length > 0) {
            throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "subjectDN SerialNumber in request is not permitted");
        }
        Date reqNotBefore = certTemplate.getNotBefore();
        Date grantedNotBefore = certprofile.getNotBefore(reqNotBefore);
        long currentMillis = System.currentTimeMillis();
        if (currentMillis - grantedNotBefore.getTime() > 300000L) {
            grantedNotBefore = new Date(currentMillis - 300000L);
        }
        long time = this.caInfo.getNoNewCertificateAfter();
        if (grantedNotBefore.getTime() > time) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "CA is not permitted to issue certifate after " + new Date(time));
        }
        if (grantedNotBefore.before(this.caInfo.getNotBefore())) {
            grantedNotBefore = this.caInfo.getNotBefore();
        }
        if ((grantedPublicKeyInfo = certTemplate.getPublicKeyInfo()) != null) {
            privateKey = null;
            try {
                grantedPublicKeyInfo = X509Util.toRfc3279Style((SubjectPublicKeyInfo)certTemplate.getPublicKeyInfo());
            }
            catch (InvalidKeySpecException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)"invalid SubjectPublicKeyInfo");
                throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "invalid SubjectPublicKeyInfo");
            }
            if (grantedPublicKeyInfo.getAlgorithm().getAlgorithm().equals((ASN1Primitive)PKCSObjectIdentifiers.rsaEncryption)) {
                try {
                    ASN1Sequence seq = ASN1Sequence.getInstance((Object)grantedPublicKeyInfo.getPublicKeyData().getOctets());
                    if (seq.size() != 2) {
                        throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "invalid format of RSA public key");
                    }
                    BigInteger modulus = ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getPositiveValue();
                    if (RSABrokenKey.isAffected((BigInteger)modulus)) {
                        throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "RSA public key is too weak");
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "invalid format of RSA public key");
                }
            }
        } else if (certTemplate.isCaGenerateKeypair()) {
            KeypairGenControl kg = certprofile.getKeypairGenControl();
            try {
                KeypairGenControl.RSAKeypairGenControl tkg;
                if (kg instanceof KeypairGenControl.InheritCAKeypairGenControl) {
                    kg = this.keypairGenControlByImplictCA;
                }
                if (kg == null || kg instanceof KeypairGenControl.ForbiddenKeypairGenControl) {
                    throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "no public key is specified");
                }
                if (kg instanceof KeypairGenControl.RSAKeypairGenControl) {
                    tkg = (KeypairGenControl.RSAKeypairGenControl)kg;
                    int keysize = tkg.getKeysize();
                    if (keysize > 4096) {
                        throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "keysize too large");
                    }
                    BigInteger publicExponent = tkg.getPublicExponent();
                    KeyPair kp = KeyUtil.generateRSAKeypair((int)keysize, (BigInteger)publicExponent, (SecureRandom)this.random);
                    java.security.interfaces.RSAPublicKey rsaPubKey = (java.security.interfaces.RSAPublicKey)kp.getPublic();
                    grantedPublicKeyInfo = new SubjectPublicKeyInfo(tkg.getKeyAlgorithm(), (ASN1Encodable)new RSAPublicKey(rsaPubKey.getModulus(), rsaPubKey.getPublicExponent()));
                    RSAPrivateCrtKey priv = (RSAPrivateCrtKey)kp.getPrivate();
                    privateKey = new PrivateKeyInfo(tkg.getKeyAlgorithm(), (ASN1Encodable)new RSAPrivateKey(priv.getModulus(), priv.getPublicExponent(), priv.getPrivateExponent(), priv.getPrimeP(), priv.getPrimeQ(), priv.getPrimeExponentP(), priv.getPrimeExponentQ(), priv.getCrtCoefficient()));
                }
                if (kg instanceof KeypairGenControl.ECKeypairGenControl) {
                    tkg = (KeypairGenControl.ECKeypairGenControl)kg;
                    ASN1ObjectIdentifier curveOid = tkg.getCurveOid();
                    KeyPair kp = KeyUtil.generateECKeypair((ASN1ObjectIdentifier)curveOid, (SecureRandom)this.random);
                    ECPublicKey pub = (ECPublicKey)kp.getPublic();
                    int orderBitLength = pub.getParams().getOrder().bitLength();
                    byte[] keyData = KeyUtil.getUncompressedEncodedECPoint((ECPoint)pub.getW(), (int)orderBitLength);
                    grantedPublicKeyInfo = new SubjectPublicKeyInfo(tkg.getKeyAlgorithm(), keyData);
                    java.security.interfaces.ECPrivateKey priv = (java.security.interfaces.ECPrivateKey)kp.getPrivate();
                    privateKey = new PrivateKeyInfo(tkg.getKeyAlgorithm(), (ASN1Encodable)new ECPrivateKey(orderBitLength, priv.getS()));
                }
                if (kg instanceof KeypairGenControl.DSAKeypairGenControl) {
                    tkg = (KeypairGenControl.DSAKeypairGenControl)kg;
                    KeyPair kp = KeyUtil.generateDSAKeypair((DSAParameterSpec)tkg.getParameterSpec(), (SecureRandom)this.random);
                    grantedPublicKeyInfo = new SubjectPublicKeyInfo(tkg.getKeyAlgorithm(), (ASN1Encodable)new ASN1Integer(((DSAPublicKey)kp.getPublic()).getY()));
                    DSAPrivateKey priv = (DSAPrivateKey)kp.getPrivate();
                    privateKey = new PrivateKeyInfo(grantedPublicKeyInfo.getAlgorithm(), (ASN1Encodable)new ASN1Integer(priv.getX()));
                }
                if (kg instanceof KeypairGenControl.EDDSAKeypairGenControl) {
                    tkg = (KeypairGenControl.EDDSAKeypairGenControl)kg;
                    KeyPair kp = KeyUtil.generateEdECKeypair((ASN1ObjectIdentifier)tkg.getKeyAlgorithm().getAlgorithm(), (SecureRandom)this.random);
                    grantedPublicKeyInfo = KeyUtil.createSubjectPublicKeyInfo((PublicKey)kp.getPublic());
                    if (!grantedPublicKeyInfo.getAlgorithm().equals((Object)tkg.getKeyAlgorithm())) {
                        throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "invalid SubjectPublicKeyInfo.algorithm");
                    }
                    privateKey = PrivateKeyInfo.getInstance((Object)kp.getPrivate().getEncoded());
                }
                throw new RuntimeCryptoException("unknown KeyPairGenControl " + kg);
            }
            catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException ex) {
                throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
            }
        } else {
            throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "no public key is specified  genkey");
        }
        try {
            grantedPublicKeyInfo = certprofile.checkPublicKey(grantedPublicKeyInfo);
        }
        catch (CertprofileException ex) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "exception in cert profile " + certprofileIdent);
        }
        catch (BadCertTemplateException ex) {
            throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, (Throwable)ex);
        }
        try {
            subjectInfo = certprofile.getSubject(requestedSubject, grantedPublicKeyInfo);
        }
        catch (CertprofileException ex) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "exception in cert profile " + certprofileIdent);
        }
        catch (BadCertTemplateException ex) {
            throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, (Throwable)ex);
        }
        X500Name grantedSubject = subjectInfo.getGrantedSubject();
        ASN1ObjectIdentifier[] attrTypes = grantedSubject.getAttributeTypes();
        if (attrTypes == null || attrTypes.length == 0) {
            throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "empty subject is not permitted");
        }
        if (X509Util.canonicalizName((X500Name)grantedSubject).equals(this.caInfo.getPublicCaInfo().getC14nSubject())) {
            throw new OperationException(OperationException.ErrorCode.ALREADY_ISSUED, "certificate with the same subject as CA is not allowed");
        }
        if (update) {
            CertStore.CertStatus certStatus = this.certstore.getCertStatusForSubject(this.caInfo.getIdent(), grantedSubject);
            if (certStatus == CertStore.CertStatus.REVOKED) {
                throw new OperationException(OperationException.ErrorCode.CERT_REVOKED);
            }
            if (certStatus == CertStore.CertStatus.UNKNOWN) {
                throw new OperationException(OperationException.ErrorCode.UNKNOWN_CERT);
            }
        }
        StringBuilder msgBuilder = new StringBuilder();
        if (subjectInfo.getWarning() != null) {
            msgBuilder.append(", ").append(subjectInfo.getWarning());
        }
        if ((validity = certprofile.getValidity()) == null) {
            validity = this.caInfo.getMaxValidity();
        } else if (validity.compareTo(this.caInfo.getMaxValidity()) > 0) {
            validity = this.caInfo.getMaxValidity();
        }
        Date maxNotAfter = validity.add(grantedNotBefore);
        if (maxNotAfter.getTime() > 253402300799982L) {
            maxNotAfter = MAX_CERT_TIME;
        }
        if ((grantedNotAfter = certTemplate.getNotAfter()) != null) {
            if (grantedNotAfter.after(maxNotAfter)) {
                grantedNotAfter = maxNotAfter;
                msgBuilder.append(", notAfter modified");
            }
        } else {
            grantedNotAfter = maxNotAfter;
        }
        if (grantedNotAfter.after(this.caInfo.getNotAfter())) {
            ValidityMode caMode = this.caInfo.getValidityMode();
            NotAfterMode profileMode = certprofile.getNotAfterMode();
            if (profileMode == null) {
                profileMode = NotAfterMode.BY_CA;
            }
            if (profileMode == NotAfterMode.STRICT) {
                throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "notAfter outside of CA's validity is not permitted by the CertProfile");
            }
            if (caMode == ValidityMode.STRICT) {
                throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "notAfter outside of CA's validity is not permitted by the CA");
            }
            if (caMode == ValidityMode.CUTOFF) {
                grantedNotAfter = this.caInfo.getNotAfter();
            } else if (caMode == ValidityMode.LAX) {
                if (profileMode == NotAfterMode.CUTOFF) {
                    grantedNotAfter = this.caInfo.getNotAfter();
                }
            } else {
                throw new IllegalStateException("should not reach here, CA ValidityMode " + caMode + " CertProfile NotAfterMode " + profileMode);
            }
        }
        String warning = null;
        if (msgBuilder.length() > 2) {
            warning = msgBuilder.substring(2);
        }
        X509Ca.GrantedCertTemplate gct = new X509Ca.GrantedCertTemplate(certTemplate.getExtensions(), certprofile, grantedNotBefore, grantedNotAfter, requestedSubject, grantedPublicKeyInfo, privateKey, signer, warning);
        gct.setGrantedSubject(grantedSubject);
        return gct;
    }
}

