/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.ObjectCreationException;

public class SignerEntryWrapper {
    private SignerEntry dbEntry;
    private ConcurrentContentSigner signer;
    private X500Name subject;
    private GeneralName subjectAsGeneralName;

    public void setDbEntry(SignerEntry dbEntry) {
        this.dbEntry = (SignerEntry)Args.notNull((Object)dbEntry, (String)"dbEntry");
        this.signer = null;
        if (dbEntry.getCertificate() != null) {
            this.subject = dbEntry.getCertificate().getSubject();
            this.subjectAsGeneralName = new GeneralName(this.subject);
        }
    }

    public ConcurrentContentSigner getSigner() {
        return this.signer;
    }

    public void initSigner(SecurityFactory securityFactory) throws ObjectCreationException {
        Args.notNull((Object)securityFactory, (String)"securityFactory");
        if (this.signer != null) {
            return;
        }
        if (this.dbEntry == null) {
            throw new ObjectCreationException("dbEntry is null");
        }
        X509Cert responderCert = this.dbEntry.getCertificate();
        this.dbEntry.setConfFaulty(true);
        this.signer = securityFactory.createSigner(this.dbEntry.getType(), new SignerConf(this.dbEntry.getConf()), responderCert);
        if (this.signer.getCertificate() == null) {
            throw new ObjectCreationException("signer without certificate is not allowed");
        }
        this.dbEntry.setConfFaulty(false);
        if (this.dbEntry.getBase64Cert() == null) {
            this.dbEntry.setCertificate(this.signer.getCertificate());
            this.subject = this.signer.getCertificate().getSubject();
            this.subjectAsGeneralName = new GeneralName(this.subject);
        }
    }

    public SignerEntry getDbEntry() {
        return this.dbEntry;
    }

    public boolean isHealthy() {
        return this.signer != null && this.signer.isHealthy();
    }

    public GeneralName getSubjectAsGeneralName() {
        return this.subjectAsGeneralName;
    }

    public X500Name getSubject() {
        return this.subject;
    }
}

