/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.ca.api.BadCertTemplateException;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.OperationException;
import org.xipki.ca.api.RequestType;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CertListInfo;
import org.xipki.ca.api.mgmt.CertListOrderBy;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.api.mgmt.CmpControl;
import org.xipki.ca.api.mgmt.RequestorInfo;
import org.xipki.ca.api.mgmt.entry.CaHasRequestorEntry;
import org.xipki.ca.api.mgmt.entry.CaHasUserEntry;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.ExtensionValue;
import org.xipki.ca.api.profile.ExtensionValues;
import org.xipki.ca.server.CaIdNameMap;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.CertTemplateData;
import org.xipki.ca.server.CtLogClient;
import org.xipki.ca.server.CtLogPublicKeyFinder;
import org.xipki.ca.server.GrandCertTemplateBuilder;
import org.xipki.ca.server.IdentifiedCertprofile;
import org.xipki.ca.server.RequestorEntryWrapper;
import org.xipki.ca.server.SignerEntryWrapper;
import org.xipki.ca.server.X509CaModule;
import org.xipki.ca.server.X509CrlModule;
import org.xipki.ca.server.X509PublisherModule;
import org.xipki.ca.server.X509RemoverModule;
import org.xipki.ca.server.X509RevokerModule;
import org.xipki.ca.server.db.CertStore;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.ConcurrentBagEntrySigner;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.CrlReason;
import org.xipki.security.NoIdleSignerException;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.ctlog.CtLog;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.DateUtil;
import org.xipki.util.HealthCheckResult;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

public class X509Ca
extends X509CaModule
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(X509Ca.class);
    private final CtLogClient ctlogClient;
    private final CertStore certstore;
    private final CaIdNameMap caIdNameMap;
    private final CaManagerImpl caManager;
    private final X509PublisherModule publisherModule;
    private final X509CrlModule crlModule;
    private final GrandCertTemplateBuilder grandCertTemplateBuilder;
    private final X509RevokerModule revokerModule;
    private final X509RemoverModule removerModule;

    public X509Ca(CaManagerImpl caManager, CaInfo caInfo, CertStore certstore, CtLogClient ctlogClient) throws OperationException {
        super(caInfo);
        try {
            caInfo.initDhpocControl(caManager.getSecurityFactory());
        }
        catch (XiSecurityException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)("initDhpocControl for CA " + this.caIdent));
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
        }
        if (caInfo.isSignerRequired()) {
            try {
                caInfo.initSigner(caManager.getSecurityFactory());
            }
            catch (XiSecurityException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("security.createSigner caSigner for CA " + this.caIdent));
                throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
            }
        }
        this.caManager = (CaManagerImpl)Args.notNull((Object)caManager, (String)"caManager");
        this.caIdNameMap = caManager.idNameMap();
        this.ctlogClient = ctlogClient;
        this.certstore = (CertStore)Args.notNull((Object)certstore, (String)"certstore");
        this.publisherModule = new X509PublisherModule(caManager, caInfo, certstore);
        this.crlModule = new X509CrlModule(caManager, caInfo, certstore, this.publisherModule);
        this.grandCertTemplateBuilder = new GrandCertTemplateBuilder(caInfo, certstore);
        this.revokerModule = new X509RevokerModule(caManager, caInfo, certstore, this.publisherModule);
        this.removerModule = new X509RemoverModule(caManager, caInfo, certstore, this.publisherModule);
    }

    public NameId getCaIdent() {
        return this.caIdent;
    }

    public CaInfo getCaInfo() {
        return this.caInfo;
    }

    public X509Cert getCaCert() {
        return this.caCert;
    }

    public CmpControl getCmpControl() {
        return this.caInfo.getCmpControl();
    }

    public X509Cert getCert(BigInteger serialNumber) throws CertificateException, OperationException {
        CertificateInfo certInfo = this.certstore.getCertInfo(this.caIdent, this.caCert, serialNumber, this.caIdNameMap);
        return certInfo == null ? null : certInfo.getCert().getCert();
    }

    public List<X509Cert> getCert(X500Name subjectName, byte[] transactionId) throws OperationException {
        return this.certstore.getCert(subjectName, transactionId);
    }

    public CertStore.KnowCertResult knowsCert(X509Cert cert) throws OperationException {
        Args.notNull((Object)cert, (String)"cert");
        X500Name issuerX500 = cert.getIssuer();
        if (!this.caInfo.getSubject().equals(X509Util.getRfc4519Name((X500Name)issuerX500))) {
            return CertStore.KnowCertResult.UNKNOWN;
        }
        return this.certstore.knowsCertForSerial(this.caIdent, cert.getSerialNumber());
    }

    public CertWithRevocationInfo getCertWithRevocationInfo(BigInteger serialNumber) throws CertificateException, OperationException {
        return this.certstore.getCertWithRevocationInfo(this.caIdent.getId(), serialNumber, this.caIdNameMap);
    }

    public byte[] getCertRequest(BigInteger serialNumber) throws OperationException {
        return this.certstore.getCertRequest(this.caIdent, serialNumber);
    }

    public boolean verifyCsr(CertificationRequest csr) {
        Args.notNull((Object)csr, (String)"csr");
        return CaUtil.verifyCsr(csr, this.caManager.getSecurityFactory(), this.caInfo.getCmpControl().getPopoAlgoValidator(), this.caInfo.getDhpocControl());
    }

    public List<CertListInfo> listCerts(X500Name subjectPattern, Date validFrom, Date validTo, CertListOrderBy orderBy, int numEntries) throws OperationException {
        return this.certstore.listCerts(this.caIdent, subjectPattern, validFrom, validTo, orderBy, numEntries);
    }

    public NameId authenticateUser(String user, byte[] password) throws OperationException {
        return this.certstore.authenticateUser(user.toLowerCase(), password);
    }

    public NameId getUserIdent(int userId) throws OperationException {
        String name = this.certstore.getUsername(userId);
        return name == null ? null : new NameId(Integer.valueOf(userId), name);
    }

    public RequestorInfo.ByUserRequestorInfo getByUserRequestor(NameId userIdent) throws OperationException {
        CaHasUserEntry caHasUser = this.certstore.getCaHasUser(this.caIdent, userIdent);
        return caHasUser == null ? null : this.caManager.createByUserRequestor(caHasUser);
    }

    public X509CRLHolder getCurrentCrl(String msgId) throws OperationException {
        return this.crlModule.getCurrentCrl(msgId);
    }

    public X509CRLHolder getCrl(BigInteger crlNumber, String msgId) throws OperationException {
        return this.crlModule.getCrl(crlNumber, msgId);
    }

    public CertificateList getBcCurrentCrl(String msgId) throws OperationException {
        return this.crlModule.getBcCurrentCrl(msgId);
    }

    public CertificateList getBcCrl(BigInteger crlNumber, String msgId) throws OperationException {
        return this.crlModule.getBcCrl(crlNumber, msgId);
    }

    public X509CRLHolder generateCrlOnDemand(String msgId) throws OperationException {
        return this.crlModule.generateCrlOnDemand(msgId);
    }

    public CertificateInfo regenerateCert(CertTemplateData certTemplate, RequestorInfo requestor, RequestType reqType, byte[] transactionId, String msgId) throws OperationException {
        return this.regenerateCerts(Collections.singletonList(certTemplate), requestor, reqType, transactionId, msgId).get(0);
    }

    public List<CertificateInfo> regenerateCerts(List<CertTemplateData> certTemplates, RequestorInfo requestor, RequestType reqType, byte[] transactionId, String msgId) throws OperationException {
        return this.generateCerts(certTemplates, requestor, true, reqType, transactionId, msgId);
    }

    public boolean republishCerts(List<String> publisherNames, int numThreads) {
        return this.publisherModule.republishCerts(publisherNames, numThreads);
    }

    public void clearPublishQueue(List<String> publisherNames) throws CaMgmtException {
        this.publisherModule.clearPublishQueue(publisherNames);
    }

    public boolean publishCertsInQueue() {
        return this.publisherModule.publishCertsInQueue();
    }

    public CertWithRevocationInfo revokeCert(BigInteger serialNumber, CrlReason reason, Date invalidityTime, String msgId) throws OperationException {
        return this.revokerModule.revokeCert(serialNumber, reason, invalidityTime, msgId);
    }

    public CertWithDbId unrevokeCert(BigInteger serialNumber, String msgId) throws OperationException {
        return this.revokerModule.unrevokeCert(serialNumber, msgId);
    }

    public CertWithDbId removeCert(BigInteger serialNumber, String msgId) throws OperationException {
        return this.removerModule.removeCert(serialNumber, msgId);
    }

    public void revokeCa(CertRevocationInfo revocationInfo, String msgId) throws OperationException {
        this.revokerModule.revokeCa(revocationInfo, msgId);
    }

    public void unrevokeCa(String msgId) throws OperationException {
        this.revokerModule.unrevokeCa(msgId);
    }

    public long addRequest(byte[] request) throws OperationException {
        return this.certstore.addRequest(request);
    }

    public void addRequestCert(long requestId, long certId) throws OperationException {
        this.certstore.addRequestCert(requestId, certId);
    }

    public List<CertificateInfo> generateCerts(List<CertTemplateData> certTemplates, RequestorInfo requestor, RequestType reqType, byte[] transactionId, String msgId) throws OperationException {
        return this.generateCerts(certTemplates, requestor, false, reqType, transactionId, msgId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<CertificateInfo> generateCerts(List<CertTemplateData> certTemplates, RequestorInfo requestor, boolean update, RequestType reqType, byte[] transactionId, String msgId) throws OperationExceptionWithIndex {
        Args.notEmpty(certTemplates, (String)"certTemplates");
        int n = certTemplates.size();
        ArrayList<GrantedCertTemplate> gcts = new ArrayList<GrantedCertTemplate>(n);
        for (int i = 0; i < n; ++i) {
            CertTemplateData certTemplate = certTemplates.get(i);
            try {
                IdentifiedCertprofile certprofile = this.getX509Certprofile(certTemplate.getCertprofileName());
                if (certprofile == null) {
                    throw new OperationException(OperationException.ErrorCode.UNKNOWN_CERT_PROFILE, "unknown cert profile " + certTemplate.getCertprofileName());
                }
                gcts.add(this.grandCertTemplateBuilder.create(certprofile, certTemplate, requestor, update));
                continue;
            }
            catch (OperationException ex) {
                LOG.error("     FAILED createGrantedCertTemplate: CA={}, profile={}, subject='{}'", new Object[]{this.caIdent.getName(), certTemplate.getCertprofileName(), certTemplate.getSubject()});
                throw new OperationExceptionWithIndex(i, ex);
            }
        }
        ArrayList<CertificateInfo> certInfos = new ArrayList<CertificateInfo>(n);
        OperationExceptionWithIndex exception = null;
        for (int i = 0; i < n && exception == null; ++i) {
            GrantedCertTemplate gct = (GrantedCertTemplate)gcts.get(i);
            NameId certprofilIdent = gct.certprofile.getIdent();
            String subjectText = gct.grantedSubjectText;
            LOG.info("     START generateCertificate: CA={}, profile={}, subject='{}'", new Object[]{this.caIdent.getName(), certprofilIdent.getName(), subjectText});
            boolean successful = false;
            try {
                CertificateInfo certInfo = this.generateCert(gct, requestor, reqType, transactionId, msgId);
                successful = true;
                certInfos.add(certInfo);
                if (LOG.isInfoEnabled()) {
                    String prefix = certInfo.isAlreadyIssued() ? "RETURN_OLD_CERT" : "SUCCESSFUL";
                    CertWithDbId cert = certInfo.getCert();
                    LOG.info("{} generateCertificate: CA={}, profile={}, subject='{}', serialNumber={}", new Object[]{prefix, this.caIdent.getName(), certprofilIdent.getName(), cert.getCert().getSubjectRfc4519Text(), cert.getCert().getSerialNumberHex()});
                }
                if (successful) continue;
            }
            catch (OperationException ex) {
                exception = new OperationExceptionWithIndex(i, ex);
                if (successful) continue;
                LOG.error("    FAILED generateCertificate: CA={}, profile={}, subject='{}'", new Object[]{this.caIdent.getName(), certprofilIdent.getName(), subjectText});
                continue;
            }
            catch (Throwable th) {
                exception = new OperationExceptionWithIndex(i, new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, th));
                if (successful) continue;
                {
                    catch (Throwable throwable) {
                        if (!successful) {
                            LOG.error("    FAILED generateCertificate: CA={}, profile={}, subject='{}'", new Object[]{this.caIdent.getName(), certprofilIdent.getName(), subjectText});
                        }
                        throw throwable;
                    }
                }
                LOG.error("    FAILED generateCertificate: CA={}, profile={}, subject='{}'", new Object[]{this.caIdent.getName(), certprofilIdent.getName(), subjectText});
                continue;
            }
            LOG.error("    FAILED generateCertificate: CA={}, profile={}, subject='{}'", new Object[]{this.caIdent.getName(), certprofilIdent.getName(), subjectText});
            continue;
        }
        if (exception != null) {
            LOG.error("could not generate certificate for request[{}], reverted all generated certificates", (Object)exception.getIndex());
            for (CertificateInfo m : certInfos) {
                BigInteger serial = m.getCert().getCert().getSerialNumber();
                try {
                    this.removeCert(serial, msgId);
                }
                catch (Throwable thr) {
                    LogUtil.error((Logger)LOG, (Throwable)thr, (String)("could not delete certificate serial=" + serial));
                }
            }
            LogUtil.warn((Logger)LOG, (Throwable)((Object)exception));
            throw exception;
        }
        return certInfos;
    }

    public CertificateInfo generateCert(CertTemplateData certTemplate, RequestorInfo requestor, RequestType reqType, byte[] transactionId, String msgId) throws OperationException {
        Args.notNull((Object)certTemplate, (String)"certTemplate");
        return this.generateCerts(Collections.singletonList(certTemplate), requestor, reqType, transactionId, msgId).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CertificateInfo generateCert(GrantedCertTemplate gct, RequestorInfo requestor, RequestType reqType, byte[] transactionId, String msgId) throws OperationException {
        AuditEvent event = this.newPerfAuditEvent("gen_cert", msgId);
        boolean successful = false;
        try {
            CertificateInfo ret = this.generateCert0(gct, requestor, reqType, transactionId, event);
            successful = ret != null;
            CertificateInfo certificateInfo = ret;
            return certificateInfo;
        }
        finally {
            this.finish(event, successful);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CertificateInfo generateCert0(GrantedCertTemplate gct, RequestorInfo requestor, RequestType reqType, byte[] transactionId, AuditEvent event) throws OperationException {
        CertificateInfo ret;
        boolean ctlogEnabled;
        Args.notNull((Object)gct, (String)"gct");
        event.addEventData("req_subject", (Object)X509Util.getRfc4519Name((X500Name)gct.requestedSubject));
        event.addEventData("certprofile", (Object)gct.certprofile.getIdent().getName());
        event.addEventData("not_before", (Object)DateUtil.toUtcTimeyyyyMMddhhmmss((Date)gct.grantedNotBefore));
        event.addEventData("not_after", (Object)DateUtil.toUtcTimeyyyyMMddhhmmss((Date)gct.grantedNotAfter));
        IdentifiedCertprofile certprofile = gct.certprofile;
        Certprofile.ExtensionControl extnSctCtrl = certprofile.getExtensionControls().get(ObjectIdentifiers.Extn.id_SCTs);
        boolean bl = ctlogEnabled = this.caInfo.getCtlogControl() != null && this.caInfo.getCtlogControl().isEnabled();
        if (!ctlogEnabled && extnSctCtrl != null && extnSctCtrl.isRequired()) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "extension " + ObjectIdentifiers.getName((ASN1ObjectIdentifier)ObjectIdentifiers.Extn.id_SCTs) + " is required but CTLog of the CA is not activated");
        }
        String serialNumberMode = certprofile.getSerialNumberMode();
        BigInteger serialNumber = null;
        do {
            if (StringUtil.isBlank((String)serialNumberMode) || "CA".equalsIgnoreCase(serialNumberMode)) {
                serialNumber = this.caInfo.nextSerial();
                continue;
            }
            if ("PROFILE".equalsIgnoreCase(serialNumberMode)) {
                try {
                    BigInteger previousSerialNumber = serialNumber;
                    ConfPairs extraControl = this.caInfo.getExtraControl();
                    serialNumber = certprofile.generateSerialNumber(this.caInfo.getCert().getSubject(), this.caInfo.getCert().getSubjectPublicKeyInfo(), gct.requestedSubject, gct.grantedPublicKey, extraControl == null ? null : extraControl.unmodifiable());
                    if (!serialNumber.equals(previousSerialNumber)) continue;
                    break;
                }
                catch (CertprofileException ex) {
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error generateSerialNumber");
                    throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "unknown SerialNumberMode '" + serialNumberMode + "'");
                }
            }
            throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "unknown SerialNumberMode '" + serialNumberMode + "'");
        } while (this.certstore.getCertId(this.caIdent, serialNumber) != 0L);
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(this.caInfo.getPublicCaInfo().getSubject(), serialNumber, gct.grantedNotBefore, gct.grantedNotAfter, gct.grantedSubject, gct.grantedPublicKey);
        try {
            int certSize;
            X509CertificateHolder bcCert;
            ConcurrentBagEntrySigner signer0;
            boolean addCtlog;
            SignerEntryWrapper crlSigner = this.crlModule.getCrlSigner();
            X509Cert crlSignerCert = crlSigner == null ? null : crlSigner.getSigner().getCertificate();
            ExtensionValues extensionTuples = certprofile.getExtensions(gct.requestedSubject, gct.grantedSubject, gct.extensions, gct.grantedPublicKey, this.caInfo.getPublicCaInfo(), crlSignerCert, gct.grantedNotBefore, gct.grantedNotAfter);
            if (extensionTuples != null) {
                for (ASN1ObjectIdentifier extensionType : extensionTuples.getExtensionTypes()) {
                    ExtensionValue extValue = extensionTuples.getExtensionValue(extensionType);
                    certBuilder.addExtension(extensionType, extValue.isCritical(), extValue.getValue());
                }
            }
            boolean bl2 = addCtlog = ctlogEnabled && extnSctCtrl != null;
            if (addCtlog) {
                DEROctetString extnValue;
                X509CertificateHolder precert;
                certBuilder.addExtension(ObjectIdentifiers.Extn.id_precertificate, true, (ASN1Encodable)DERNull.INSTANCE);
                try {
                    signer0 = gct.signer.borrowSigner();
                }
                catch (NoIdleSignerException ex) {
                    throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
                }
                try {
                    precert = certBuilder.build((ContentSigner)signer0.value());
                }
                finally {
                    gct.signer.requiteSigner(signer0);
                }
                CtLogPublicKeyFinder finder = this.caManager.getCtLogPublicKeyFinder();
                if (finder == null) {
                    throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "ctLog not configured for CA " + this.caInfo.getIdent().getName());
                }
                CtLog.SignedCertificateTimestampList scts = this.ctlogClient.getCtLogScts(precert, this.caCert, this.caInfo.getCertchain(), finder);
                certBuilder.removeExtension(ObjectIdentifiers.Extn.id_precertificate);
                try {
                    extnValue = new DEROctetString(new DEROctetString(scts.getEncoded()).getEncoded());
                }
                catch (IOException ex) {
                    throw new CertIOException("could not encode SCT extension", (Throwable)ex);
                }
                certBuilder.addExtension(new Extension(ObjectIdentifiers.Extn.id_SCTs, extnSctCtrl.isCritical(), (ASN1OctetString)extnValue));
            }
            try {
                signer0 = gct.signer.borrowSigner();
            }
            catch (NoIdleSignerException ex) {
                throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
            }
            try {
                bcCert = certBuilder.build((ContentSigner)signer0.value());
            }
            finally {
                gct.signer.requiteSigner(signer0);
            }
            byte[] encodedCert = bcCert.getEncoded();
            int maxCertSize = gct.certprofile.getMaxCertSize();
            if (maxCertSize > 0 && (certSize = encodedCert.length) > maxCertSize) {
                throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, String.format("certificate exceeds the maximal allowed size: %d > %d", certSize, maxCertSize));
            }
            X509Cert cert = new X509Cert(bcCert, encodedCert);
            if (!this.verifySignature(cert)) {
                throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "could not verify the signature of generated certificate");
            }
            CertWithDbId certWithMeta = new CertWithDbId(cert);
            ret = new CertificateInfo(certWithMeta, gct.privateKey, this.caIdent, this.caCert, gct.certprofile.getIdent(), requestor.getIdent());
            if (requestor instanceof RequestorInfo.ByUserRequestorInfo) {
                ret.setUser(Integer.valueOf(((RequestorInfo.ByUserRequestorInfo)requestor).getUserId()));
            }
            ret.setReqType(reqType);
            ret.setTransactionId(transactionId);
            ret.setRequestedSubject(gct.requestedSubject);
            if (this.publisherModule.publishCert(ret) == 1) {
                throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "could not save certificate");
            }
        }
        catch (BadCertTemplateException ex) {
            throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, (Throwable)ex);
        }
        catch (OperationException ex) {
            throw ex;
        }
        catch (Throwable th) {
            LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not generate certificate");
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, th);
        }
        if (gct.warning != null) {
            ret.setWarningMessage(gct.warning);
        }
        return ret;
    }

    public IdentifiedCertprofile getX509Certprofile(String certprofileName) {
        if (certprofileName == null) {
            return null;
        }
        Set<String> profileNames = this.caManager.getCertprofilesForCa(this.caIdent.getName());
        return profileNames == null || !profileNames.contains(certprofileName) ? null : this.caManager.getIdentifiedCertprofile(certprofileName);
    }

    public RequestorInfo.CmpRequestorInfo getRequestor(X500Name requestorSender) {
        Set<CaHasRequestorEntry> requestorEntries = this.caManager.getRequestorsForCa(this.caIdent.getName());
        if (CollectionUtil.isEmpty(requestorEntries)) {
            return null;
        }
        for (CaHasRequestorEntry m : requestorEntries) {
            RequestorEntryWrapper entry = this.caManager.getRequestorWrapper(m.getRequestorIdent().getName());
            if (entry.getDbEntry().isFaulty() || !"cert".equals(entry.getDbEntry().getType()) || !entry.getCert().getCert().getSubject().equals((Object)requestorSender)) continue;
            return new RequestorInfo.CmpRequestorInfo(m, entry.getCert());
        }
        return null;
    }

    public RequestorInfo.CmpRequestorInfo getRequestor(X509Cert requestorCert) {
        Set<CaHasRequestorEntry> requestorEntries = this.caManager.getRequestorsForCa(this.caIdent.getName());
        if (CollectionUtil.isEmpty(requestorEntries)) {
            return null;
        }
        for (CaHasRequestorEntry m : requestorEntries) {
            RequestorEntryWrapper entry = this.caManager.getRequestorWrapper(m.getRequestorIdent().getName());
            if (!"cert".equals(entry.getDbEntry().getType()) || !entry.getCert().getCert().equals((Object)requestorCert)) continue;
            return new RequestorInfo.CmpRequestorInfo(m, entry.getCert());
        }
        return null;
    }

    public RequestorInfo.CmpRequestorInfo getMacRequestor(byte[] senderKID) {
        Set<CaHasRequestorEntry> requestorEntries = this.caManager.getRequestorsForCa(this.caIdent.getName());
        if (CollectionUtil.isEmpty(requestorEntries)) {
            return null;
        }
        for (CaHasRequestorEntry m : requestorEntries) {
            RequestorEntryWrapper entry = this.caManager.getRequestorWrapper(m.getRequestorIdent().getName());
            if (!"pbm".equals(entry.getDbEntry().getType()) || !entry.matchKeyId(senderKID)) continue;
            return new RequestorInfo.CmpRequestorInfo(m, entry.getPassword(), senderKID);
        }
        return null;
    }

    public CaManagerImpl getCaManager() {
        return this.caManager;
    }

    public HealthCheckResult healthCheck() {
        HealthCheckResult result = new HealthCheckResult();
        result.setName("X509CA");
        boolean healthy = true;
        ConcurrentContentSigner signer = this.caInfo.getSigner(null);
        if (signer != null) {
            boolean caSignerHealthy;
            healthy = caSignerHealthy = signer.isHealthy();
            HealthCheckResult signerHealth = new HealthCheckResult();
            signerHealth.setName("Signer");
            signerHealth.setHealthy(caSignerHealthy);
            result.addChildCheck(signerHealth);
        }
        boolean databaseHealthy = this.certstore.isHealthy();
        healthy &= databaseHealthy;
        HealthCheckResult databaseHealth = new HealthCheckResult();
        databaseHealth.setName("Database");
        databaseHealth.setHealthy(databaseHealthy);
        result.addChildCheck(databaseHealth);
        healthy &= this.crlModule.healthCheck(result);
        result.setHealthy(healthy &= this.publisherModule.healthCheck(result));
        return result;
    }

    public String getHexSha1OfCert() {
        return this.caInfo.getCaEntry().getHexSha1OfCert();
    }

    @Override
    public void close() {
        this.crlModule.close();
        this.revokerModule.close();
        ScheduledThreadPoolExecutor executor = this.caManager.getScheduledThreadPoolExecutor();
        if (executor != null) {
            executor.purge();
        }
    }

    static class OperationExceptionWithIndex
    extends OperationException {
        private static final long serialVersionUID = 1L;
        private final int index;

        public OperationExceptionWithIndex(int index, OperationException underlying) {
            super(underlying.getErrorCode(), underlying.getMessage());
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }

    static class GrantedCertTemplate {
        private final ConcurrentContentSigner signer;
        private final Extensions extensions;
        private final IdentifiedCertprofile certprofile;
        private final Date grantedNotBefore;
        private final Date grantedNotAfter;
        private final X500Name requestedSubject;
        private final SubjectPublicKeyInfo grantedPublicKey;
        private final PrivateKeyInfo privateKey;
        private final String warning;
        private X500Name grantedSubject;
        private String grantedSubjectText;

        GrantedCertTemplate(Extensions extensions, IdentifiedCertprofile certprofile, Date grantedNotBefore, Date grantedNotAfter, X500Name requestedSubject, SubjectPublicKeyInfo grantedPublicKey, PrivateKeyInfo privateKey, ConcurrentContentSigner signer, String warning) {
            this.extensions = extensions;
            this.certprofile = certprofile;
            this.grantedNotBefore = grantedNotBefore;
            this.grantedNotAfter = grantedNotAfter;
            this.requestedSubject = requestedSubject;
            this.grantedPublicKey = grantedPublicKey;
            this.privateKey = privateKey;
            this.signer = signer;
            this.warning = warning;
        }

        void setGrantedSubject(X500Name subject) {
            this.grantedSubject = subject;
            this.grantedSubjectText = X509Util.getRfc4519Name((X500Name)subject);
        }
    }
}

