/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.Closeable;
import java.math.BigInteger;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.xipki.audit.AuditEvent;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.OperationException;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.server.CaIdNameMap;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.X509CaModule;
import org.xipki.ca.server.X509PublisherModule;
import org.xipki.ca.server.db.CertStore;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.LogUtil;

public class X509RemoverModule
extends X509CaModule
implements Closeable {
    private final boolean masterMode;
    private final CertStore certstore;
    private final CaIdNameMap caIdNameMap;
    private final X509PublisherModule publisherModule;
    private ScheduledFuture<?> expiredCertsRemover;

    public X509RemoverModule(CaManagerImpl caManager, CaInfo caInfo, CertStore certstore, X509PublisherModule publisherModule) {
        super(caInfo);
        this.caIdNameMap = caManager.idNameMap();
        this.certstore = certstore;
        this.masterMode = caManager.isMasterMode();
        this.publisherModule = publisherModule;
        if (!this.masterMode) {
            return;
        }
        ScheduledThreadPoolExecutor executor = caManager.getScheduledThreadPoolExecutor();
        Random random = new Random();
        int minutesOfDay = 1440;
        this.expiredCertsRemover = executor.scheduleAtFixedRate(new ExpiredCertsRemover(), 1440 + random.nextInt(60), 1440L, TimeUnit.MINUTES);
    }

    public CertWithDbId removeCert(CertStore.SerialWithId serialNumber, String msgId) throws OperationException {
        return this.removeCert0(serialNumber.getId(), serialNumber.getSerial(), msgId);
    }

    public CertWithDbId removeCert(BigInteger serialNumber, String msgId) throws OperationException {
        return this.removeCert0(0L, serialNumber, msgId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CertWithDbId removeCert0(long certId, BigInteger serialNumber, String msgId) throws OperationException {
        if (this.caInfo.isSelfSigned() && this.caInfo.getSerialNumber().equals(serialNumber)) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "could not remove CA certificate");
        }
        AuditEvent event = this.newPerfAuditEvent("remove_cert", msgId);
        boolean successful = true;
        try {
            CertWithRevocationInfo certWithRevInfo;
            event.addEventData("serial", (Object)LogUtil.formatCsn((BigInteger)serialNumber));
            CertWithRevocationInfo certWithRevocationInfo = certWithRevInfo = certId == 0L ? this.certstore.getCertWithRevocationInfo(this.caIdent.getId(), serialNumber, this.caIdNameMap) : this.certstore.getCertWithRevocationInfo(certId, this.caIdNameMap);
            if (certWithRevInfo == null) {
                CertWithDbId certWithDbId = null;
                return certWithDbId;
            }
            CertWithDbId certToRemove = certWithRevInfo.getCert();
            boolean succ = this.publisherModule.publishCertRemoved(certToRemove);
            if (!succ) {
                CertWithDbId certWithDbId = null;
                return certWithDbId;
            }
            this.certstore.removeCert(certWithRevInfo.getCert().getCertId());
            successful = certToRemove != null;
            CertWithDbId certWithDbId = certToRemove;
            return certWithDbId;
        }
        finally {
            this.finish(event, successful);
        }
    }

    private int removeExpiredCerts0(Date expiredAtTime, AuditEvent event, String msgId) throws OperationException {
        Args.notNull((Object)expiredAtTime, (String)"expiredtime");
        if (!this.masterMode) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "CA could not remove expired certificates in slave mode");
        }
        event.addEventData("expired_at", (Object)expiredAtTime);
        int numEntries = 100;
        long expiredAt = expiredAtTime.getTime() / 1000L;
        int sum = 0;
        List<CertStore.SerialWithId> serials;
        block2: while (!CollectionUtil.isEmpty(serials = this.certstore.getExpiredUnrevokedSerialNumbers(this.caIdent, expiredAt, 100))) {
            Iterator<CertStore.SerialWithId> iterator = serials.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block2;
                CertStore.SerialWithId serial = iterator.next();
                if (this.caInfo.isSelfSigned() && this.caInfo.getSerialNumber().equals(serial.getSerial())) continue;
                try {
                    if (this.removeCert(serial, msgId) == null) continue;
                    ++sum;
                }
                catch (OperationException ex) {
                    this.LOG.info("removed {} expired certificates of CA {}", (Object)sum, (Object)this.caIdent.getName());
                    LogUtil.error((Logger)this.LOG, (Throwable)ex, (String)("could not remove expired certificate with serial" + serial.getSerial()));
                    throw ex;
                }
            }
            break;
        }
        return sum;
    }

    @Override
    public void close() {
        if (this.expiredCertsRemover != null) {
            this.expiredCertsRemover.cancel(false);
            this.expiredCertsRemover = null;
        }
    }

    private class ExpiredCertsRemover
    implements Runnable {
        private boolean inProcess;

        private ExpiredCertsRemover() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int keepDays = X509RemoverModule.this.caInfo.getKeepExpiredCertInDays();
            if (keepDays < 0) {
                return;
            }
            if (this.inProcess) {
                return;
            }
            this.inProcess = true;
            Date expiredAt = new Date(System.currentTimeMillis() - 86400000L * (long)(keepDays + 1));
            try {
                String msgId = "ca_routine";
                X509RemoverModule.this.LOG.debug("revoking expired certificates");
                AuditEvent event = X509RemoverModule.this.newPerfAuditEvent("remove_expired_certs", msgId);
                boolean successful = false;
                try {
                    int num = X509RemoverModule.this.removeExpiredCerts0(expiredAt, event, msgId);
                    X509RemoverModule.this.LOG.info("removed {} certificates expired at {} of CA {}", new Object[]{num, expiredAt, X509RemoverModule.this.caIdent});
                    successful = true;
                }
                finally {
                    X509RemoverModule.this.finish(event, successful);
                }
            }
            catch (Throwable th) {
                LogUtil.error((Logger)X509RemoverModule.this.LOG, (Throwable)th, (String)"could not remove expired certificates");
            }
            finally {
                this.inProcess = false;
            }
        }
    }
}

