/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xipki.ca.server.db.ResultRow;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.util.Args;

class QueryExecutor {
    protected final DataSourceWrapper datasource;

    QueryExecutor(DataSourceWrapper datasource) {
        this.datasource = (DataSourceWrapper)Args.notNull((Object)datasource, (String)"datasource");
    }

    protected String buildSelectFirstSql(String coreSql) {
        return this.datasource.buildSelectFirstSql(1, coreSql);
    }

    protected String buildSelectFirstSql(String orderBy, String coreSql) {
        return this.datasource.buildSelectFirstSql(1, orderBy, coreSql);
    }

    protected static SqlColumn colBool(String name, Boolean value) {
        return new SqlColumn(ColumnType.BOOL, name, value);
    }

    protected static SqlColumn colInt(String name, Integer value) {
        return new SqlColumn(ColumnType.INT, name, value);
    }

    protected static SqlColumn colLong(String name, Long value) {
        return new SqlColumn(ColumnType.LONG, name, value);
    }

    protected static SqlColumn colStr(String name, String value) {
        return new SqlColumn(ColumnType.STRING, name, value);
    }

    protected static SqlColumn colStr(String name, String value, boolean sensitive, boolean signerConf) {
        return new SqlColumn(ColumnType.STRING, name, value, sensitive, signerConf);
    }

    protected static SqlColumn2 col2Bool(Boolean value) {
        return new SqlColumn2(ColumnType.BOOL, value);
    }

    protected static SqlColumn2 col2Int(Integer value) {
        return new SqlColumn2(ColumnType.INT, value);
    }

    protected static SqlColumn2 col2Long(Long value) {
        return new SqlColumn2(ColumnType.LONG, value);
    }

    protected static SqlColumn2 col2Str(String value) {
        return new SqlColumn2(ColumnType.STRING, value);
    }

    protected static SqlColumn2 col2Timestamp(Timestamp value) {
        return new SqlColumn2(ColumnType.TIMESTAMP, value);
    }

    protected int execUpdateStmt(String sql) throws DataAccessException {
        Statement ps = this.datasource.createStatement();
        try {
            int n = ps.executeUpdate(sql);
            return n;
        }
        catch (SQLException ex) {
            throw this.datasource.translate(sql, ex);
        }
        finally {
            this.datasource.releaseResources(ps, null);
        }
    }

    protected int execUpdatePrepStmt(String sql, SqlColumn2 ... params) throws DataAccessException {
        PreparedStatement ps = this.buildPrepStmt(sql, params);
        try {
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException ex) {
            throw this.datasource.translate(sql, ex);
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    protected List<ResultRow> execQueryStmt(String sql) throws DataAccessException {
        return this.execQueryStmt(false, sql);
    }

    private List<ResultRow> execQueryStmt(boolean single, String sql) throws DataAccessException {
        Statement stmt = this.datasource.createStatement();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(sql);
            LinkedList<ResultRow> rows = new LinkedList<ResultRow>();
            while (rs.next()) {
                rows.add(new ResultRow(rs));
                if (!single) continue;
            }
            LinkedList<ResultRow> linkedList = rows;
            return linkedList;
        }
        catch (SQLException ex) {
            throw this.datasource.translate(sql, ex);
        }
        finally {
            this.datasource.releaseResources(stmt, rs);
        }
    }

    protected ResultRow execQuery1PrepStmt(String sql, SqlColumn2 ... params) throws DataAccessException {
        List<ResultRow> rows = this.execQueryPrepStmt(true, sql, params);
        return rows.isEmpty() ? null : rows.get(0);
    }

    protected List<ResultRow> execQueryPrepStmt(String sql, SqlColumn2 ... params) throws DataAccessException {
        return this.execQueryPrepStmt(false, sql, params);
    }

    private List<ResultRow> execQueryPrepStmt(boolean single, String sql, SqlColumn2 ... params) throws DataAccessException {
        PreparedStatement ps = this.buildPrepStmt(sql, params);
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            LinkedList<ResultRow> rows = new LinkedList<ResultRow>();
            while (rs.next()) {
                rows.add(new ResultRow(rs));
                if (!single) continue;
            }
            LinkedList<ResultRow> linkedList = rows;
            return linkedList;
        }
        catch (SQLException ex) {
            throw this.datasource.translate(sql, ex);
        }
        finally {
            this.datasource.releaseResources((Statement)ps, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PreparedStatement buildPrepStmt(String sql, SqlColumn2 ... columns) throws DataAccessException {
        PreparedStatement ps = null;
        boolean succ = false;
        try {
            ps = this.datasource.prepareStatement(sql);
            int index = 0;
            for (SqlColumn2 col : columns) {
                ++index;
                ColumnType type = col.type();
                Object value = col.value();
                try {
                    if (type == ColumnType.STRING) {
                        ps.setString(index, (String)value);
                        continue;
                    }
                    if (type == ColumnType.INT) {
                        if (value == null) {
                            ps.setNull(index, 4);
                            continue;
                        }
                        ps.setInt(index, (Integer)value);
                        continue;
                    }
                    if (type == ColumnType.LONG) {
                        if (value == null) {
                            ps.setNull(index, -5);
                            continue;
                        }
                        ps.setLong(index, (Long)value);
                        continue;
                    }
                    if (type == ColumnType.BOOL) {
                        if (value == null) {
                            ps.setNull(index, 4);
                            continue;
                        }
                        ps.setInt(index, (Boolean)value != false ? 1 : 0);
                        continue;
                    }
                    if (type == ColumnType.TIMESTAMP) {
                        if (value == null) {
                            ps.setNull(index, 93);
                            continue;
                        }
                        ps.setTimestamp(index, (Timestamp)value);
                        continue;
                    }
                    throw new IllegalStateException("should not reach here, unknown type " + (Object)((Object)type));
                }
                catch (SQLException ex) {
                    throw this.datasource.translate(sql, ex);
                }
            }
            succ = true;
            PreparedStatement preparedStatement = ps;
            return preparedStatement;
        }
        finally {
            if (!succ) {
                this.datasource.releaseResources((Statement)ps, null);
            }
        }
    }

    protected void notNulls(Object param1, String name1, Object param2, String name2) {
        Args.notNull((Object)param1, (String)name1);
        Args.notNull((Object)param2, (String)name2);
    }

    protected void notNulls(Object param1, String name1, Object param2, String name2, Object param3, String name3) {
        Args.notNull((Object)param1, (String)name1);
        Args.notNull((Object)param2, (String)name2);
        Args.notNull((Object)param3, (String)name3);
    }

    protected void notNulls(Object param1, String name1, Object param2, String name2, Object param3, String name3, Object param4, String name4) {
        Args.notNull((Object)param1, (String)name1);
        Args.notNull((Object)param2, (String)name2);
        Args.notNull((Object)param3, (String)name3);
        Args.notNull((Object)param4, (String)name4);
    }

    protected static class DbSchemaInfo {
        private final Map<String, String> variables = new HashMap<String, String>();

        protected DbSchemaInfo(DataSourceWrapper datasource) throws DataAccessException {
            Args.notNull((Object)datasource, (String)"datasource");
            String sql = "SELECT NAME,VALUE2 FROM DBSCHEMA";
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = datasource.createStatement();
                if (stmt == null) {
                    throw new DataAccessException("could not create statement");
                }
                rs = stmt.executeQuery("SELECT NAME,VALUE2 FROM DBSCHEMA");
                while (rs.next()) {
                    String name = rs.getString("NAME");
                    String value = rs.getString("VALUE2");
                    this.variables.put(name, value);
                }
            }
            catch (SQLException ex) {
                try {
                    throw datasource.translate("SELECT NAME,VALUE2 FROM DBSCHEMA", ex);
                }
                catch (Throwable throwable) {
                    datasource.releaseResources(stmt, rs);
                    throw throwable;
                }
            }
            datasource.releaseResources(stmt, rs);
        }

        public String variableValue(String variableName) {
            return this.variables.get(Args.notNull((Object)variableName, (String)"variableName"));
        }
    }

    protected static class SqlColumn2 {
        private final ColumnType type;
        private final Object value;

        public SqlColumn2(ColumnType type, Object value) {
            this.type = (ColumnType)((Object)Args.notNull((Object)((Object)type), (String)"type"));
            this.value = value;
        }

        public ColumnType type() {
            return this.type;
        }

        public Object value() {
            return this.value;
        }
    }

    protected static class SqlColumn {
        private final ColumnType type;
        private final String name;
        private final Object value;
        private final boolean sensitive;
        private final boolean signerConf;

        public SqlColumn(ColumnType type, String name, Object value) {
            this(type, name, value, false, false);
        }

        public SqlColumn(ColumnType type, String name, Object value, boolean sensitive, boolean signerConf) {
            this.type = (ColumnType)((Object)Args.notNull((Object)((Object)type), (String)"type"));
            this.name = (String)Args.notNull((Object)name, (String)"name");
            this.value = value;
            this.sensitive = sensitive;
            this.signerConf = signerConf;
        }

        public ColumnType type() {
            return this.type;
        }

        public String name() {
            return this.name;
        }

        public Object value() {
            return this.value;
        }

        public boolean sensitive() {
            return this.sensitive;
        }

        public boolean isSignerConf() {
            return this.signerConf;
        }
    }

    protected static enum ColumnType {
        INT,
        LONG,
        STRING,
        BOOL,
        TIMESTAMP;

    }
}

