/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.RequestorInfo;
import org.xipki.ca.api.mgmt.entry.CaHasRequestorEntry;
import org.xipki.ca.api.mgmt.entry.RequestorEntry;
import org.xipki.ca.server.RequestorEntryWrapper;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.util.Args;
import org.xipki.util.StringUtil;

class RequestorManager {
    private static final Logger LOG = LoggerFactory.getLogger(RequestorManager.class);
    private boolean requestorsInitialized;
    private final CaManagerImpl manager;

    RequestorManager(CaManagerImpl manager) {
        this.manager = (CaManagerImpl)Args.notNull((Object)manager, (String)"manager");
    }

    void reset() {
        this.requestorsInitialized = false;
    }

    void initRequestors() throws CaMgmtException {
        if (this.requestorsInitialized) {
            return;
        }
        this.manager.idNameMap.clearRequestor();
        this.manager.requestorDbEntries.clear();
        this.manager.requestors.clear();
        List names = this.manager.queryExecutor.namesFromTable("REQUESTOR");
        for (String name : names) {
            Integer id;
            if ("by-ca".equalsIgnoreCase(name)) {
                id = this.manager.queryExecutor.getRequestorId(name);
                NameId ident = new NameId(id, name);
                this.manager.byCaRequestor = new RequestorInfo.ByCaRequestorInfo(ident);
                this.manager.idNameMap.addRequestor(ident);
            } else if ("by-user".equalsIgnoreCase(name)) {
                id = this.manager.queryExecutor.getRequestorId(name);
                this.manager.byUserRequestorId = new NameId(id, name);
                this.manager.idNameMap.addRequestor(this.manager.byUserRequestorId);
            } else {
                RequestorEntry requestorDbEntry = this.manager.queryExecutor.createRequestor(name);
                this.manager.idNameMap.addRequestor(requestorDbEntry.getIdent());
                this.manager.requestorDbEntries.put(name, requestorDbEntry);
                RequestorEntryWrapper requestor = new RequestorEntryWrapper();
                requestor.setDbEntry(requestorDbEntry, this.manager.securityFactory.getPasswordResolver());
                this.manager.requestors.put(name, requestor);
            }
            LOG.info("loaded requestor {}", (Object)name);
        }
        this.requestorsInitialized = true;
    }

    void addRequestor(RequestorEntry requestorEntry) throws CaMgmtException {
        String conf;
        this.manager.assertMasterModeAndSetuped();
        Args.notNull((Object)requestorEntry, (String)"requestorEntry");
        String name = requestorEntry.getIdent().getName();
        if (this.manager.requestorDbEntries.containsKey(name)) {
            throw new CaMgmtException(StringUtil.concat((String)"Requestor named ", (String[])new String[]{name, " exists"}));
        }
        PasswordResolver pwdResolver = this.manager.securityFactory.getPasswordResolver();
        if ("pbm".equalsIgnoreCase(requestorEntry.getType()) && !StringUtil.startsWithIgnoreCase((String)(conf = requestorEntry.getConf()), (String)"PBE:")) {
            String encryptedPassword;
            try {
                encryptedPassword = pwdResolver.protectPassword("PBE", conf.toCharArray());
            }
            catch (PasswordResolverException ex) {
                throw new CaMgmtException("could not encrypt requestor " + name, (Throwable)ex);
            }
            requestorEntry = new RequestorEntry(requestorEntry.getIdent(), requestorEntry.getType(), encryptedPassword);
        }
        RequestorEntryWrapper requestor = new RequestorEntryWrapper();
        requestor.setDbEntry(requestorEntry, pwdResolver);
        this.manager.queryExecutor.addRequestor(requestorEntry);
        this.manager.idNameMap.addRequestor(requestorEntry.getIdent());
        this.manager.requestorDbEntries.put(name, requestorEntry);
        this.manager.requestors.put(name, requestor);
    }

    void removeRequestor(String name) throws CaMgmtException {
        this.manager.assertMasterModeAndSetuped();
        name = Args.toNonBlankLower((String)name, (String)"name");
        for (String caName : this.manager.caHasRequestors.keySet()) {
            boolean removeMe = false;
            for (CaHasRequestorEntry caHasRequestor : this.manager.caHasRequestors.get(caName)) {
                if (!caHasRequestor.getRequestorIdent().getName().equals(name)) continue;
                removeMe = true;
                break;
            }
            if (!removeMe) continue;
            this.removeRequestorFromCa(name, caName);
        }
        if (!this.manager.queryExecutor.deleteRowWithName(name, "REQUESTOR")) {
            throw new CaMgmtException("unknown requestor " + name);
        }
        this.manager.idNameMap.removeRequestor(this.manager.requestorDbEntries.get(name).getIdent().getId());
        this.manager.requestorDbEntries.remove(name);
        this.manager.requestors.remove(name);
        LOG.info("removed requestor '{}'", (Object)name);
    }

    void changeRequestor(String name, String type, String conf) throws CaMgmtException {
        this.manager.assertMasterModeAndSetuped();
        name = Args.toNonBlankLower((String)name, (String)"name");
        Args.notBlank((String)type, (String)"type");
        Args.notBlank((String)conf, (String)"conf");
        NameId ident = this.manager.idNameMap.getRequestor(name);
        if (ident == null) {
            throw this.manager.logAndCreateException(StringUtil.concat((String)"unknown requestor ", (String[])new String[]{name}));
        }
        RequestorEntryWrapper requestor = this.manager.queryExecutor.changeRequestor(ident, type, conf, this.manager.securityFactory.getPasswordResolver());
        this.manager.requestorDbEntries.remove(name);
        this.manager.requestors.remove(name);
        this.manager.requestorDbEntries.put(name, requestor.getDbEntry());
        this.manager.requestors.put(name, requestor);
    }

    void removeRequestorFromCa(String requestorName, String caName) throws CaMgmtException {
        this.manager.assertMasterModeAndSetuped();
        requestorName = Args.toNonBlankLower((String)requestorName, (String)"requestorName");
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        if (requestorName.equals("by-ca") || requestorName.equals("by-user")) {
            throw new CaMgmtException(StringUtil.concat((String)"removing requestor ", (String[])new String[]{requestorName, " is not permitted"}));
        }
        this.manager.queryExecutor.removeRequestorFromCa(requestorName, caName);
        if (this.manager.caHasRequestors.containsKey(caName)) {
            Set<CaHasRequestorEntry> entries = this.manager.caHasRequestors.get(caName);
            CaHasRequestorEntry entry = null;
            for (CaHasRequestorEntry m : entries) {
                if (!m.getRequestorIdent().getName().equals(requestorName)) continue;
                entry = m;
            }
            entries.remove(entry);
        }
    }

    void addRequestorToCa(CaHasRequestorEntry requestor, String caName) throws CaMgmtException {
        this.manager.assertMasterModeAndSetuped();
        Args.notNull((Object)requestor, (String)"requestor");
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        NameId requestorIdent = requestor.getRequestorIdent();
        NameId ident = this.manager.idNameMap.getRequestor(requestorIdent.getName());
        if (ident == null) {
            throw this.manager.logAndCreateException(StringUtil.concat((String)"unknown requestor ", (String[])new String[]{requestorIdent.getName()}));
        }
        NameId caIdent = this.manager.idNameMap.getCa(caName);
        if (caIdent == null) {
            String msg = StringUtil.concat((String)"unknown CA ", (String[])new String[]{caName});
            LOG.warn(msg);
            throw new CaMgmtException(msg);
        }
        requestorIdent.setId(ident.getId());
        Set<CaHasRequestorEntry> cmpRequestors = this.manager.caHasRequestors.get(caName);
        if (cmpRequestors == null) {
            cmpRequestors = new HashSet<CaHasRequestorEntry>();
            this.manager.caHasRequestors.put(caName, cmpRequestors);
        } else {
            for (CaHasRequestorEntry entry : cmpRequestors) {
                String requestorName = requestorIdent.getName();
                if (!entry.getRequestorIdent().getName().equals(requestorName)) continue;
                String msg = StringUtil.concat((String)"Requestor ", (String[])new String[]{requestorName, " already associated with CA ", caName});
                throw this.manager.logAndCreateException(msg);
            }
        }
        cmpRequestors.add(requestor);
        this.manager.queryExecutor.addRequestorToCa(requestor, caIdent);
        this.manager.caHasRequestors.get(caName).add(requestor);
    }
}

