/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.cmp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.KeySpec;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CMPObjectIdentifiers;
import org.bouncycastle.asn1.cmp.CertConfirmContent;
import org.bouncycastle.asn1.cmp.CertOrEncCert;
import org.bouncycastle.asn1.cmp.CertResponse;
import org.bouncycastle.asn1.cmp.CertifiedKeyPair;
import org.bouncycastle.asn1.cmp.ErrorMsgContent;
import org.bouncycastle.asn1.cmp.PBMParameter;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIFailureInfo;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIHeaderBuilder;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.cmp.PKIStatus;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.cms.GCMParameters;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.crmf.DhSigStatic;
import org.bouncycastle.asn1.crmf.EncryptedValue;
import org.bouncycastle.asn1.crmf.POPOSigningKey;
import org.bouncycastle.asn1.crmf.ProofOfPossession;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.cmp.CMPException;
import org.bouncycastle.cert.cmp.GeneralPKIMessage;
import org.bouncycastle.cert.cmp.ProtectedPKIMessage;
import org.bouncycastle.cert.crmf.CRMFException;
import org.bouncycastle.cert.crmf.CertificateRequestMessage;
import org.bouncycastle.cert.crmf.PKMACBuilder;
import org.bouncycastle.cert.crmf.PKMACValuesCalculator;
import org.bouncycastle.cert.crmf.jcajce.JcePKMACValuesCalculator;
import org.bouncycastle.jcajce.spec.PBKDF2KeySpec;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditStatus;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.InsufficientPermissionException;
import org.xipki.ca.api.OperationException;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CmpControl;
import org.xipki.ca.api.mgmt.PermissionConstants;
import org.xipki.ca.api.mgmt.RequestorInfo;
import org.xipki.ca.api.mgmt.entry.CertprofileEntry;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.DhpocControl;
import org.xipki.ca.server.X509Ca;
import org.xipki.ca.server.cmp.CrmfKeyWrapper;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.security.AlgorithmValidator;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.DHSigStaticKeyCertPair;
import org.xipki.security.EdECConstants;
import org.xipki.security.HashAlgo;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.cmp.CmpUtil;
import org.xipki.security.cmp.PkiStatusInfo;
import org.xipki.security.cmp.ProtectionResult;
import org.xipki.security.cmp.ProtectionVerificationResult;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.HealthCheckResult;
import org.xipki.util.LogUtil;
import org.xipki.util.RandomUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.concurrent.ConcurrentBag;
import org.xipki.util.concurrent.ConcurrentBagEntry;

abstract class BaseCmpResponder {
    private static final Logger LOG;
    private static final int PVNO_CMP2000 = 2;
    protected static final Set<String> KNOWN_GENMSG_IDS;
    private static final AlgorithmIdentifier prf_hmacWithSHA256;
    private static final ConcurrentBag<ConcurrentBagEntry<Cipher>> aesGcm_ciphers;
    private static final ConcurrentBag<ConcurrentBagEntry<SecretKeyFactory>> pbkdf2_kdfs;
    private static final Map<OperationException.ErrorCode, Integer> errorCodeToPkiFailureMap;
    private static final boolean aesGcm_ciphers_initialized;
    private static final boolean pbkdf2_kdfs_initialized;
    protected static final Set<String> kupCertExtnIds;
    private final SecurityFactory securityFactory;
    private final SecureRandom random = new SecureRandom();
    private final String caName;
    protected final CaManagerImpl caManager;
    private final KeyGenerator aesKeyGen;

    protected BaseCmpResponder(CaManagerImpl caManager, String caName) throws NoSuchAlgorithmException {
        this.caManager = caManager;
        this.caName = caName;
        this.securityFactory = caManager.getSecurityFactory();
        this.aesKeyGen = KeyGenerator.getInstance("AES");
    }

    protected abstract PKIBody cmpEnrollCert(String var1, PKIMessage var2, PKIHeaderBuilder var3, CmpControl var4, PKIHeader var5, PKIBody var6, RequestorInfo.CmpRequestorInfo var7, ASN1OctetString var8, String var9, AuditEvent var10) throws InsufficientPermissionException;

    protected abstract PKIBody cmpUnRevokeRemoveCertificates(PKIMessage var1, PKIHeaderBuilder var2, CmpControl var3, PKIHeader var4, PKIBody var5, RequestorInfo.CmpRequestorInfo var6, String var7, AuditEvent var8);

    protected abstract PKIBody cmpGeneralMsg(PKIHeaderBuilder var1, CmpControl var2, PKIHeader var3, PKIBody var4, RequestorInfo.CmpRequestorInfo var5, ASN1OctetString var6, String var7, AuditEvent var8) throws InsufficientPermissionException;

    protected abstract PKIBody confirmCertificates(ASN1OctetString var1, CertConfirmContent var2, String var3);

    protected abstract boolean revokePendingCertificates(ASN1OctetString var1, String var2);

    private ConcurrentContentSigner getSigner() {
        String name = this.getResponderName();
        return this.caManager.getSignerWrapper(name).getSigner();
    }

    private GeneralName getSender() {
        return this.caManager.getSignerWrapper(this.getResponderName()).getSubjectAsGeneralName();
    }

    private boolean intendsMe(GeneralName requestRecipient) {
        if (requestRecipient == null) {
            return false;
        }
        if (this.getSender().equals((Object)requestRecipient)) {
            return true;
        }
        if (requestRecipient.getTagNo() == 4) {
            X500Name x500Name = X500Name.getInstance((Object)requestRecipient.getName());
            if (x500Name.equals((Object)this.caManager.getSignerWrapper(this.getResponderName()).getSubject())) {
                return true;
            }
            return x500Name.equals((Object)this.getCa().getCaCert().getSubject());
        }
        return false;
    }

    public X509Ca getCa() {
        try {
            return this.caManager.getX509Ca(this.caName);
        }
        catch (CaMgmtException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public boolean isOnService() {
        boolean onService;
        try {
            onService = this.getSigner() != null;
        }
        catch (Exception ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not get responder signer");
            return false;
        }
        if (!onService) {
            return false;
        }
        CaInfo caInfo = this.getCa().getCaInfo();
        return caInfo.getStatus() == CaStatus.ACTIVE && caInfo.supportsCmp();
    }

    public HealthCheckResult healthCheck() {
        HealthCheckResult result = this.getCa().healthCheck();
        boolean healthy = result.isHealthy();
        boolean responderHealthy = this.caManager.getSignerWrapper(this.getResponderName()).getSigner().isHealthy();
        HealthCheckResult responderHealth = new HealthCheckResult();
        responderHealth.setName("Responder");
        responderHealth.setHealthy(responderHealthy);
        result.addChildCheck(responderHealth);
        result.setHealthy(healthy &= responderHealthy);
        return result;
    }

    public String getCaName() {
        return this.caName;
    }

    private String getResponderName() {
        return this.getCa().getCaInfo().getCmpResponderName();
    }

    private CmpControl getCmpControl() {
        return this.getCa().getCmpControl();
    }

    private RequestorInfo.CmpRequestorInfo getMacRequestor(byte[] senderKID) {
        return this.getCa().getMacRequestor(senderKID);
    }

    private RequestorInfo.CmpRequestorInfo getRequestor(X500Name requestorSender) {
        return this.getCa().getRequestor(requestorSender);
    }

    private static X500Name getX500Sender(PKIHeader reqHeader) {
        GeneralName requestSender = reqHeader.getSender();
        if (requestSender.getTagNo() != 4) {
            return null;
        }
        return (X500Name)requestSender.getName();
    }

    private PKIMessage processPkiMessage0(PKIMessage request, RequestorInfo requestor, ASN1OctetString tid, GeneralPKIMessage message, String msgId, Map<String, String> parameters, AuditEvent event) {
        PKIBody respBody;
        if (!(requestor instanceof RequestorInfo.CmpRequestorInfo)) {
            throw new IllegalArgumentException("unknown requestor type " + requestor.getClass().getName());
        }
        RequestorInfo.CmpRequestorInfo cmpRequestor = (RequestorInfo.CmpRequestorInfo)requestor;
        event.addEventData("requestor", (Object)cmpRequestor.getIdent().getName());
        PKIHeader reqHeader = message.getHeader();
        PKIHeaderBuilder respHeader = new PKIHeaderBuilder(reqHeader.getPvno().getValue().intValue(), this.getSender(), reqHeader.getSender());
        respHeader.setTransactionID(tid);
        ASN1OctetString senderNonce = reqHeader.getSenderNonce();
        if (senderNonce != null) {
            respHeader.setRecipNonce(senderNonce);
        }
        PKIBody reqBody = message.getBody();
        int type = reqBody.getType();
        CmpControl cmpControl = this.getCmpControl();
        try {
            if (type == 0 || type == 2 || type == 7 || type == 4 || type == 13) {
                String eventType = 2 == type ? "cr" : (0 == type ? "ir" : (7 == type ? "kur" : (4 == type ? "p10cr" : "ccr")));
                event.addEventType(eventType);
                String dfltCertprofileName = null;
                if (parameters != null) {
                    dfltCertprofileName = parameters.get("certprofile");
                }
                respBody = this.cmpEnrollCert(dfltCertprofileName, request, respHeader, cmpControl, reqHeader, reqBody, cmpRequestor, tid, msgId, event);
            } else if (type == 24) {
                event.addEventType("cert_conf");
                CertConfirmContent certConf = (CertConfirmContent)reqBody.getContent();
                respBody = this.confirmCertificates(tid, certConf, msgId);
            } else if (type == 11) {
                respBody = this.cmpUnRevokeRemoveCertificates(request, respHeader, cmpControl, reqHeader, reqBody, cmpRequestor, msgId, event);
            } else if (type == 19) {
                event.addEventType("pkiconf");
                respBody = new PKIBody(19, (ASN1Encodable)DERNull.INSTANCE);
            } else if (type == 21) {
                respBody = this.cmpGeneralMsg(respHeader, cmpControl, reqHeader, reqBody, cmpRequestor, tid, msgId, event);
            } else if (type == 23) {
                event.addEventType("error");
                this.revokePendingCertificates(tid, msgId);
                respBody = new PKIBody(19, (ASN1Encodable)DERNull.INSTANCE);
            } else {
                event.addEventType("PKIBody." + type);
                respBody = BaseCmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 32, "unsupported type " + type);
            }
        }
        catch (InsufficientPermissionException ex) {
            ErrorMsgContent emc = new ErrorMsgContent(new PKIStatusInfo(PKIStatus.rejection, new PKIFreeText(ex.getMessage()), new PKIFailureInfo(65536)));
            respBody = new PKIBody(23, (ASN1Encodable)emc);
        }
        if (respBody.getType() == 23) {
            ErrorMsgContent errorMsgContent = (ErrorMsgContent)respBody.getContent();
            PkiStatusInfo pkiStatus = new PkiStatusInfo(errorMsgContent.getPKIStatusInfo());
            event.setStatus(AuditStatus.FAILED);
            String statusString = pkiStatus.statusMessage();
            if (statusString != null) {
                event.addEventData("message", (Object)statusString);
            }
        } else if (event.getStatus() == null) {
            event.setStatus(AuditStatus.SUCCESSFUL);
        }
        return new PKIMessage(respHeader.build(), respBody);
    }

    public PKIMessage processPkiMessage(PKIMessage pkiMessage, X509Cert tlsClientCert, Map<String, String> parameters, AuditEvent event) {
        RequestorInfo.CmpRequestorInfo requestor;
        String errorStatus;
        GeneralName recipient;
        boolean intentMe;
        Args.notNull((Object)pkiMessage, (String)"pkiMessage");
        Args.notNull((Object)event, (String)"event");
        GeneralPKIMessage message = new GeneralPKIMessage(pkiMessage);
        PKIHeader reqHeader = message.getHeader();
        ASN1OctetString tid = reqHeader.getTransactionID();
        String msgId = RandomUtil.nextHexLong();
        event.addEventData("mid", (Object)msgId);
        if (tid == null) {
            byte[] randomBytes = this.randomTransactionId();
            tid = new DEROctetString(randomBytes);
        }
        String tidStr = Base64.encodeToString((byte[])tid.getOctets());
        event.addEventData("tid", (Object)tidStr);
        int reqPvno = reqHeader.getPvno().getValue().intValue();
        if (reqPvno < 2) {
            event.update(AuditLevel.INFO, AuditStatus.FAILED);
            event.addEventData("message", (Object)("unsupported version " + reqPvno));
            return this.buildErrorPkiMessage(tid, reqHeader, 131072, null);
        }
        CmpControl cmpControl = this.getCmpControl();
        Integer failureCode = null;
        String statusText = null;
        Date messageTime = null;
        if (reqHeader.getMessageTime() != null) {
            try {
                messageTime = reqHeader.getMessageTime().getDate();
            }
            catch (ParseException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("tid=" + tidStr + ": could not parse messageTime"));
            }
        }
        boolean bl = intentMe = (recipient = reqHeader.getRecipient()) == null || this.intendsMe(recipient);
        if (!intentMe) {
            LOG.warn("tid={}: I am not the intended recipient, but '{}'", (Object)tid, (Object)reqHeader.getRecipient());
            failureCode = 32;
            statusText = "I am not the intended recipient";
        } else if (messageTime == null) {
            if (cmpControl.isMessageTimeRequired()) {
                failureCode = 32768;
                statusText = "missing time-stamp";
            }
        } else {
            long currentTimeMs;
            long msgTimeMs;
            long bias;
            long messageTimeBias = cmpControl.getMessageTimeBias();
            if (messageTimeBias < 0L) {
                messageTimeBias *= -1L;
            }
            if ((bias = ((msgTimeMs = messageTime.getTime()) - (currentTimeMs = System.currentTimeMillis())) / 1000L) > messageTimeBias) {
                failureCode = 16;
                statusText = "message time is in the future";
            } else if (bias * -1L > messageTimeBias) {
                failureCode = 16;
                statusText = "message too old";
            }
        }
        if (failureCode != null) {
            event.update(AuditLevel.INFO, AuditStatus.FAILED);
            event.addEventData("message", (Object)statusText);
            return this.buildErrorPkiMessage(tid, reqHeader, failureCode, statusText);
        }
        boolean isProtected = message.hasProtection();
        if (isProtected) {
            try {
                ProtectionVerificationResult verificationResult = this.verifyProtection(tidStr, message, cmpControl);
                ProtectionResult pr = verificationResult.getProtectionResult();
                if (pr == ProtectionResult.SIGNATURE_VALID || pr == ProtectionResult.MAC_VALID) {
                    errorStatus = null;
                } else if (pr == ProtectionResult.SIGNATURE_INVALID) {
                    errorStatus = "request is protected by signature but invalid";
                } else if (pr == ProtectionResult.MAC_INVALID) {
                    errorStatus = "request is protected by MAC but invalid";
                } else if (pr == ProtectionResult.SENDER_NOT_AUTHORIZED) {
                    errorStatus = "request is protected but the requestor is not authorized";
                } else if (pr == ProtectionResult.SIGNATURE_ALGO_FORBIDDEN) {
                    errorStatus = "request is protected by signature but the algorithm is forbidden";
                } else if (pr == ProtectionResult.MAC_ALGO_FORBIDDEN) {
                    errorStatus = "request is protected by MAC but the algorithm is forbidden";
                } else {
                    throw new IllegalStateException("should not reach here, unknown ProtectionResult " + pr);
                }
                requestor = (RequestorInfo.CmpRequestorInfo)verificationResult.getRequestor();
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("tid=" + tidStr + ": could not verify the signature"));
                errorStatus = "request has invalid signature based protection";
                requestor = null;
            }
        } else if (tlsClientCert != null) {
            boolean authorized = false;
            X500Name x500Sender = BaseCmpResponder.getX500Sender(reqHeader);
            RequestorInfo.CmpRequestorInfo cmpRequestorInfo = requestor = x500Sender == null ? null : this.getRequestor(x500Sender);
            if (requestor != null && tlsClientCert.equals((Object)requestor.getCert().getCert())) {
                authorized = true;
            }
            if (authorized) {
                errorStatus = null;
            } else {
                LOG.warn("tid={}: not authorized requestor (TLS client '{}')", (Object)tid, (Object)tlsClientCert.getSubjectRfc4519Text());
                errorStatus = "requestor (TLS client certificate) is not authorized";
            }
        } else {
            errorStatus = "request has no protection";
            requestor = null;
        }
        if (errorStatus != null) {
            event.update(AuditLevel.INFO, AuditStatus.FAILED);
            event.addEventData("message", (Object)errorStatus);
            return this.buildErrorPkiMessage(tid, reqHeader, 64, errorStatus);
        }
        PKIMessage resp = this.processPkiMessage0(pkiMessage, (RequestorInfo)requestor, tid, message, msgId, parameters, event);
        if (isProtected) {
            resp = this.addProtection(resp, event, requestor);
        }
        return resp;
    }

    private byte[] randomTransactionId() {
        return this.randomBytes(10);
    }

    private byte[] randomSalt() {
        return this.randomBytes(64);
    }

    private byte[] randomBytes(int len) {
        byte[] bytes = new byte[len];
        this.random.nextBytes(bytes);
        return bytes;
    }

    private ProtectionVerificationResult verifyProtection(String tid, GeneralPKIMessage pkiMessage, CmpControl cmpControl) throws CMPException, InvalidKeyException {
        RequestorInfo.CmpRequestorInfo requestor;
        ProtectedPKIMessage protectedMsg = new ProtectedPKIMessage(pkiMessage);
        PKIHeader header = protectedMsg.getHeader();
        X500Name sender = BaseCmpResponder.getX500Sender(header);
        if (sender == null) {
            LOG.warn("tid={}: not authorized requestor 'null'", (Object)tid);
            return new ProtectionVerificationResult(null, ProtectionResult.SENDER_NOT_AUTHORIZED);
        }
        AlgorithmIdentifier protectionAlg = header.getProtectionAlg();
        if (protectedMsg.hasPasswordBasedMacProtection()) {
            SignAlgo macAlg;
            HashAlgo owfAlg;
            PBMParameter parameter = PBMParameter.getInstance((Object)pkiMessage.getHeader().getProtectionAlg().getParameters());
            try {
                owfAlg = HashAlgo.getInstance((AlgorithmIdentifier)parameter.getOwf());
            }
            catch (NoSuchAlgorithmException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex);
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            if (!cmpControl.isRequestPbmOwfPermitted(owfAlg)) {
                LOG.warn("MAC_ALGO_FORBIDDEN (PBMParameter.owf: {})", (Object)owfAlg.getJceName());
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            try {
                macAlg = SignAlgo.getInstance((AlgorithmIdentifier)parameter.getMac());
            }
            catch (NoSuchAlgorithmException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex);
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            if (!cmpControl.isRequestPbmMacPermitted(macAlg)) {
                LOG.warn("MAC_ALGO_FORBIDDEN (PBMParameter.mac: {})", (Object)macAlg.getJceName());
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            int iterationCount = parameter.getIterationCount().getValue().intValue();
            if (iterationCount < 1000) {
                LOG.warn("MAC_ALGO_FORBIDDEN (PBMParameter.iterationCount: {} < 1000)", (Object)iterationCount);
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            ASN1OctetString asn1 = header.getSenderKID();
            byte[] senderKID = asn1 == null ? null : asn1.getOctets();
            PKMACBuilder pkMacBuilder = new PKMACBuilder((PKMACValuesCalculator)new JcePKMACValuesCalculator());
            RequestorInfo.CmpRequestorInfo requestor2 = this.getMacRequestor(senderKID);
            if (requestor2 == null) {
                LOG.warn("tid={}: not authorized requestor with senderKID '{}", (Object)tid, (Object)(senderKID == null ? "null" : Hex.toHexString((byte[])senderKID)));
                return new ProtectionVerificationResult(null, ProtectionResult.SENDER_NOT_AUTHORIZED);
            }
            boolean macValid = protectedMsg.verify(pkMacBuilder, requestor2.getPassword());
            return new ProtectionVerificationResult((Object)requestor2, macValid ? ProtectionResult.MAC_VALID : ProtectionResult.MAC_INVALID);
        }
        if (!cmpControl.getSigAlgoValidator().isAlgorithmPermitted(protectionAlg)) {
            LOG.warn("SIG_ALGO_FORBIDDEN: {}", (Object)pkiMessage.getHeader().getProtectionAlg().getAlgorithm().getId());
            return new ProtectionVerificationResult(null, ProtectionResult.SIGNATURE_ALGO_FORBIDDEN);
        }
        X500Name x500Sender = BaseCmpResponder.getX500Sender(header);
        RequestorInfo.CmpRequestorInfo cmpRequestorInfo = requestor = x500Sender == null ? null : this.getRequestor(x500Sender);
        if (requestor == null) {
            LOG.warn("tid={}: not authorized requestor '{}'", (Object)tid, (Object)header.getSender());
            return new ProtectionVerificationResult(null, ProtectionResult.SENDER_NOT_AUTHORIZED);
        }
        ContentVerifierProvider verifierProvider = this.securityFactory.getContentVerifierProvider(requestor.getCert().getCert());
        if (verifierProvider == null) {
            LOG.warn("tid={}: not authorized requestor '{}'", (Object)tid, (Object)sender);
            return new ProtectionVerificationResult((Object)requestor, ProtectionResult.SENDER_NOT_AUTHORIZED);
        }
        boolean signatureValid = protectedMsg.verify(verifierProvider);
        return new ProtectionVerificationResult((Object)requestor, signatureValid ? ProtectionResult.SIGNATURE_VALID : ProtectionResult.SIGNATURE_INVALID);
    }

    private PKIMessage addProtection(PKIMessage pkiMessage, AuditEvent event, RequestorInfo.CmpRequestorInfo requestor) {
        CmpControl control = this.getCmpControl();
        try {
            if (requestor.getCert() != null) {
                return CmpUtil.addProtection((PKIMessage)pkiMessage, (ConcurrentContentSigner)this.getSigner(), (GeneralName)this.getSender(), (boolean)control.isSendResponderCert());
            }
            PBMParameter parameter = new PBMParameter(this.randomSalt(), control.getResponsePbmOwf().getAlgorithmIdentifier(), control.getResponsePbmIterationCount(), control.getResponsePbmMac().getAlgorithmIdentifier());
            return CmpUtil.addProtection((PKIMessage)pkiMessage, (char[])requestor.getPassword(), (PBMParameter)parameter, (GeneralName)this.getSender(), (byte[])requestor.getKeyId());
        }
        catch (Exception ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not add protection to the PKI message");
            PKIStatusInfo status = BaseCmpResponder.generateRejectionStatus(0x40000000, "could not sign the PKIMessage");
            event.update(AuditLevel.ERROR, AuditStatus.FAILED);
            event.addEventData("message", (Object)"could not sign the PKIMessage");
            PKIBody body = new PKIBody(23, (ASN1Encodable)new ErrorMsgContent(status));
            return new PKIMessage(pkiMessage.getHeader(), body);
        }
    }

    private PKIMessage buildErrorPkiMessage(ASN1OctetString tid, PKIHeader requestHeader, int failureCode, String statusText) {
        ASN1OctetString senderNonce;
        GeneralName respRecipient = requestHeader.getSender();
        PKIHeaderBuilder respHeader = new PKIHeaderBuilder(requestHeader.getPvno().getValue().intValue(), this.getSender(), respRecipient);
        respHeader.setMessageTime(new ASN1GeneralizedTime(new Date()));
        if (tid != null) {
            respHeader.setTransactionID(tid);
        }
        if ((senderNonce = requestHeader.getSenderNonce()) != null) {
            respHeader.setRecipNonce(senderNonce);
        }
        PKIStatusInfo status = BaseCmpResponder.generateRejectionStatus(failureCode, statusText);
        ErrorMsgContent error = new ErrorMsgContent(status);
        PKIBody body = new PKIBody(23, (ASN1Encodable)error);
        return new PKIMessage(respHeader.build(), body);
    }

    protected static PKIStatusInfo generateRejectionStatus(Integer info, String errorMessage) {
        return BaseCmpResponder.generateRejectionStatus(PKIStatus.rejection, info, errorMessage);
    }

    protected static PKIStatusInfo generateRejectionStatus(PKIStatus status, Integer info, String errorMessage) {
        PKIFreeText statusMessage = errorMessage == null ? null : new PKIFreeText(errorMessage);
        PKIFailureInfo failureInfo = info == null ? null : new PKIFailureInfo(info.intValue());
        return new PKIStatusInfo(status, statusMessage, failureInfo);
    }

    protected static int getPKiFailureInfo(OperationException ex) {
        Integer failureInfo = errorCodeToPkiFailureMap.get(ex.getErrorCode());
        return failureInfo == null ? 0x40000000 : failureInfo;
    }

    protected String getSystemInfo(RequestorInfo.CmpRequestorInfo requestor, Set<Integer> acceptVersions) throws OperationException {
        DhpocControl dhpocControl;
        X509Ca ca = this.getCa();
        CaInfo caInfo = ca.getCaInfo();
        int version = 3;
        if (acceptVersions != null && !acceptVersions.contains(version)) {
            throw new OperationException(OperationException.ErrorCode.BAD_REQUEST, "none of versions " + acceptVersions + " is supported");
        }
        JSONObject root = new JSONObject(false);
        root.put("version", (Object)version);
        LinkedList<byte[]> certchain = new LinkedList<byte[]>();
        certchain.add(caInfo.getCert().getEncoded());
        for (X509Cert m : caInfo.getCertchain()) {
            certchain.add(m.getEncoded());
        }
        root.put("caCertchain", certchain);
        JSONObject jsonCmpControl = new JSONObject(false);
        jsonCmpControl.put("rrAkiRequired", (Object)this.getCmpControl().isRrAkiRequired());
        root.put("cmpControl", (Object)jsonCmpControl);
        Set requestorProfiles = requestor.getCaHasRequestor().getProfiles();
        HashSet<String> supportedProfileNames = new HashSet<String>();
        Set<String> caProfileNames = ca.getCaManager().getCertprofilesForCa(caInfo.getIdent().getName());
        for (String string : caProfileNames) {
            if (!requestorProfiles.contains("all") && !requestorProfiles.contains(string)) continue;
            supportedProfileNames.add(string);
        }
        if (CollectionUtil.isNotEmpty(supportedProfileNames)) {
            LinkedList<JSONObject> jsonCertprofiles = new LinkedList<JSONObject>();
            root.put("certprofiles", jsonCertprofiles);
            for (String name : supportedProfileNames) {
                CertprofileEntry entry = ca.getCaManager().getCertprofile(name);
                if (entry.isFaulty()) continue;
                JSONObject jsonCertprofile = new JSONObject(false);
                jsonCertprofile.put("name", (Object)name);
                jsonCertprofile.put("type", (Object)entry.getType());
                jsonCertprofile.put("conf", (Object)entry.getConf());
                jsonCertprofiles.add(jsonCertprofile);
            }
        }
        if ((dhpocControl = ca.getCaInfo().getDhpocControl()) != null) {
            X509Cert[] x509CertArray = dhpocControl.getCertificates();
            LinkedList<byte[]> dhpocCerts = new LinkedList<byte[]>();
            for (X509Cert m : x509CertArray) {
                dhpocCerts.add(m.getEncoded());
            }
            root.put("dhpocs", dhpocCerts);
        }
        return JSON.toJSONString((Object)root, (boolean)false);
    }

    protected void checkPermission(RequestorInfo.CmpRequestorInfo requestor, int requiredPermission) throws InsufficientPermissionException {
        X509Ca ca = this.getCa();
        int permission = ca.getCaInfo().getPermission();
        if (!PermissionConstants.contains((int)permission, (int)requiredPermission)) {
            throw new InsufficientPermissionException("Permission " + PermissionConstants.getTextForCode((int)requiredPermission) + "is not permitted");
        }
        requestor.assertPermitted(requiredPermission);
    }

    protected static PKIBody buildErrorMsgPkiBody(PKIStatus pkiStatus, int failureInfo, String statusMessage) {
        PKIFreeText pkiStatusMsg = statusMessage == null ? null : new PKIFreeText(statusMessage);
        ErrorMsgContent emc = new ErrorMsgContent(new PKIStatusInfo(pkiStatus, pkiStatusMsg, new PKIFailureInfo(failureInfo)));
        return new PKIBody(23, (ASN1Encodable)emc);
    }

    protected static CertResponse buildErrCertResp(ASN1Integer certReqId, int pkiFailureInfo, String pkiStatusText) {
        return new CertResponse(certReqId, BaseCmpResponder.generateRejectionStatus(pkiFailureInfo, pkiStatusText));
    }

    protected static void addErrCertResp(List<CertResponse> resps, ASN1Integer certReqId, int pkiFailureInfo, String pkiStatusText) {
        resps.add(new CertResponse(certReqId, BaseCmpResponder.generateRejectionStatus(pkiFailureInfo, pkiStatusText)));
    }

    protected boolean verifyPopo(CertificateRequestMessage certRequest, SubjectPublicKeyInfo spki, boolean allowRaPopo) {
        SignAlgo popoAlg;
        int popType = certRequest.getProofOfPossessionType();
        if (popType == 0 && allowRaPopo) {
            return true;
        }
        if (popType != 1) {
            LOG.error("unsupported POP type: " + popType);
            return false;
        }
        ProofOfPossession pop = certRequest.toASN1Structure().getPopo();
        POPOSigningKey popoSign = POPOSigningKey.getInstance((Object)pop.getObject());
        try {
            popoAlg = SignAlgo.getInstance((AlgorithmIdentifier)popoSign.getAlgorithmIdentifier());
        }
        catch (NoSuchAlgorithmException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"Cannot parse POPO signature algorithm");
            return false;
        }
        AlgorithmValidator algoValidator = this.getCmpControl().getPopoAlgoValidator();
        if (!algoValidator.isAlgorithmPermitted(popoAlg)) {
            LOG.error("POPO signature algorithm {} not permitted", (Object)popoAlg.getJceName());
            return false;
        }
        try {
            PublicKey publicKey = this.securityFactory.generatePublicKey(spki);
            DhpocControl dhpocControl = this.getCa().getCaInfo().getDhpocControl();
            DHSigStaticKeyCertPair kaKeyAndCert = null;
            if (SignAlgo.DHPOP_X25519 == popoAlg || SignAlgo.DHPOP_X448 == popoAlg) {
                if (dhpocControl != null) {
                    DhSigStatic dhSigStatic = DhSigStatic.getInstance((Object)popoSign.getSignature().getBytes());
                    IssuerAndSerialNumber isn = dhSigStatic.getIssuerAndSerial();
                    ASN1ObjectIdentifier keyAlgOid = spki.getAlgorithm().getAlgorithm();
                    kaKeyAndCert = dhpocControl.getKeyCertPair(isn.getName(), isn.getSerialNumber().getValue(), EdECConstants.getName((ASN1ObjectIdentifier)keyAlgOid));
                }
                if (kaKeyAndCert == null) {
                    return false;
                }
            }
            ContentVerifierProvider cvp = this.securityFactory.getContentVerifierProvider(publicKey, kaKeyAndCert);
            return certRequest.isValidSigningKeyPOP(cvp);
        }
        catch (IllegalStateException | InvalidKeyException | CRMFException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            return false;
        }
    }

    protected static CertResponse postProcessException(ASN1Integer certReqId, OperationException ex) {
        OperationException.ErrorCode code = ex.getErrorCode();
        LOG.warn("generate certificate, OperationException: code={}, message={}", (Object)code.name(), (Object)ex.getErrorMessage());
        String errorMessage = code == OperationException.ErrorCode.DATABASE_FAILURE || code == OperationException.ErrorCode.SYSTEM_FAILURE ? code.name() : code.name() + ": " + ex.getErrorMessage();
        int failureInfo = BaseCmpResponder.getPKiFailureInfo(ex);
        return new CertResponse(certReqId, BaseCmpResponder.generateRejectionStatus(failureInfo, errorMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CertResponse postProcessCertInfo(ASN1Integer certReqId, RequestorInfo.CmpRequestorInfo requestor, CertificateInfo certInfo) {
        EncryptedValue encKey;
        CertOrEncCert cec;
        PKIStatusInfo statusInfo;
        block35: {
            String warningMsg = certInfo.getWarningMessage();
            statusInfo = StringUtil.isBlank((String)warningMsg) ? (certInfo.isAlreadyIssued() ? new PKIStatusInfo(PKIStatus.grantedWithMods, new PKIFreeText("ALREADY_ISSUED")) : new PKIStatusInfo(PKIStatus.granted)) : new PKIStatusInfo(PKIStatus.grantedWithMods, new PKIFreeText(warningMsg));
            cec = new CertOrEncCert(new CMPCertificate(certInfo.getCert().getCert().toBcCert().toASN1Structure()));
            if (certInfo.getPrivateKey() == null) {
                return new CertResponse(certReqId, statusInfo, new CertifiedKeyPair(cec), null);
            }
            int aesGcmTagByteLen = 16;
            int aesGcmNonceLen = 12;
            PrivateKeyInfo privKey = certInfo.getPrivateKey();
            AlgorithmIdentifier intendedAlg = privKey.getPrivateKeyAlgorithm();
            try {
                byte[] encValue;
                SecretKey key;
                if (requestor.getCert() != null) {
                    byte[] encValue2;
                    byte[] symmKeyBytes;
                    CrmfKeyWrapper wrapper;
                    PublicKey reqPub = requestor.getCert().getCert().getPublicKey();
                    if (reqPub instanceof RSAPublicKey) {
                        wrapper = new CrmfKeyWrapper.RSAOAEPAsymmetricKeyWrapper(reqPub);
                    } else if (reqPub instanceof ECPublicKey) {
                        wrapper = new CrmfKeyWrapper.ECIESAsymmetricKeyWrapper(reqPub);
                    } else {
                        String msg = "Requestors's private key can not be used for encryption";
                        LOG.error(msg);
                        return new CertResponse(certReqId, new PKIStatusInfo(PKIStatus.rejection, new PKIFreeText(msg)));
                    }
                    KeyGenerator keyGenerator = this.aesKeyGen;
                    synchronized (keyGenerator) {
                        symmKeyBytes = this.aesKeyGen.generateKey().getEncoded();
                    }
                    byte[] encSymmKey = wrapper.generateWrappedKey(symmKeyBytes);
                    AlgorithmIdentifier keyAlg = wrapper.getAlgorithmIdentifier();
                    ASN1ObjectIdentifier symmAlgOid = NISTObjectIdentifiers.id_aes128_GCM;
                    byte[] nonce = this.randomBytes(12);
                    ConcurrentBagEntry cipher0 = null;
                    if (aesGcm_ciphers_initialized) {
                        try {
                            cipher0 = (ConcurrentBagEntry)aesGcm_ciphers.borrow(5L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    Cipher dataCipher = cipher0 != null ? (Cipher)cipher0.value() : Cipher.getInstance(symmAlgOid.getId());
                    try {
                        try {
                            dataCipher.init(1, (Key)new SecretKeySpec(symmKeyBytes, "AES"), new GCMParameterSpec(128, nonce));
                        }
                        catch (InvalidAlgorithmParameterException | InvalidKeyException ex) {
                            throw new IllegalStateException(ex);
                        }
                        encValue2 = dataCipher.doFinal(privKey.getEncoded());
                    }
                    finally {
                        if (cipher0 != null) {
                            aesGcm_ciphers.requite((ConcurrentBag.IConcurrentBagEntry)cipher0);
                        }
                    }
                    GCMParameters params = new GCMParameters(nonce, 16);
                    AlgorithmIdentifier symmAlg = new AlgorithmIdentifier(symmAlgOid, (ASN1Encodable)params);
                    encKey = new EncryptedValue(intendedAlg, symmAlg, (ASN1BitString)new DERBitString(encSymmKey), keyAlg, null, (ASN1BitString)new DERBitString(encValue2));
                    break block35;
                }
                ASN1ObjectIdentifier encAlgOid = NISTObjectIdentifiers.id_aes128_GCM;
                int keysizeBits = 128;
                int iterCount = 10240;
                int nonceLen = 12;
                int tagByteLen = 16;
                byte[] nonce = this.randomBytes(12);
                byte[] pbkdfSalt = this.randomBytes(16);
                ConcurrentBagEntry keyFact0 = null;
                if (pbkdf2_kdfs_initialized) {
                    try {
                        keyFact0 = (ConcurrentBagEntry)pbkdf2_kdfs.borrow(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException dataCipher) {
                        // empty catch block
                    }
                }
                SecretKeyFactory keyFact = keyFact0 != null ? (SecretKeyFactory)keyFact0.value() : SecretKeyFactory.getInstance(PKCSObjectIdentifiers.id_PBKDF2.getId());
                try {
                    key = keyFact.generateSecret((KeySpec)new PBKDF2KeySpec(requestor.getPassword(), pbkdfSalt, 10240, 128, prf_hmacWithSHA256));
                    key = new SecretKeySpec(key.getEncoded(), "AES");
                }
                finally {
                    if (keyFact0 != null) {
                        pbkdf2_kdfs.requite((ConcurrentBag.IConcurrentBagEntry)keyFact0);
                    }
                }
                GCMParameterSpec gcmParamSpec = new GCMParameterSpec(128, nonce);
                ConcurrentBagEntry cipher0 = null;
                if (aesGcm_ciphers_initialized) {
                    try {
                        cipher0 = (ConcurrentBagEntry)aesGcm_ciphers.borrow(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                Cipher dataCipher = cipher0 != null ? (Cipher)cipher0.value() : Cipher.getInstance(encAlgOid.getId());
                try {
                    dataCipher.init(1, (Key)key, gcmParamSpec);
                    encValue = dataCipher.doFinal(privKey.getEncoded());
                }
                finally {
                    if (cipher0 != null) {
                        aesGcm_ciphers.requite((ConcurrentBag.IConcurrentBagEntry)cipher0);
                    }
                }
                AlgorithmIdentifier symmAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, (ASN1Encodable)new PBES2Parameters(new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, (ASN1Encodable)new PBKDF2Params(pbkdfSalt, 10240, 16, prf_hmacWithSHA256)), new EncryptionScheme(encAlgOid, (ASN1Encodable)new GCMParameters(nonce, 16))));
                encKey = new EncryptedValue(intendedAlg, symmAlg, null, null, null, (ASN1BitString)new DERBitString(encValue));
            }
            catch (Throwable th) {
                String msg = "error while encrypting the private key";
                LOG.error(msg);
                return new CertResponse(certReqId, new PKIStatusInfo(PKIStatus.rejection, new PKIFreeText(msg)));
            }
        }
        return new CertResponse(certReqId, statusInfo, new CertifiedKeyPair(cec, encKey, null), null);
    }

    static {
        int size;
        LOG = LoggerFactory.getLogger(BaseCmpResponder.class);
        KNOWN_GENMSG_IDS = new HashSet<String>();
        prf_hmacWithSHA256 = SignAlgo.HMAC_SHA256.getAlgorithmIdentifier();
        errorCodeToPkiFailureMap = new HashMap<OperationException.ErrorCode, Integer>(20);
        KNOWN_GENMSG_IDS.add(CMPObjectIdentifiers.it_currentCRL.getId());
        KNOWN_GENMSG_IDS.add(ObjectIdentifiers.Xipki.id_xipki_cmp_cmpGenmsg.getId());
        String oid = NISTObjectIdentifiers.id_aes128_GCM.getId();
        aesGcm_ciphers = new ConcurrentBag();
        for (int i = 0; i < 64; ++i) {
            Cipher cipher;
            try {
                cipher = Cipher.getInstance(oid);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not get Cipher of " + oid));
                break;
            }
            aesGcm_ciphers.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((Object)cipher));
        }
        boolean bl = aesGcm_ciphers_initialized = (size = aesGcm_ciphers.size()) > 0;
        if (size > 0) {
            LOG.info("initialized {} AES GCM Cipher instances", (Object)size);
        } else {
            LOG.error("could not initialize any AES GCM Cipher instance");
        }
        oid = PKCSObjectIdentifiers.id_PBKDF2.getId();
        pbkdf2_kdfs = new ConcurrentBag();
        for (int i = 0; i < 64; ++i) {
            SecretKeyFactory keyFact;
            try {
                keyFact = SecretKeyFactory.getInstance(oid);
            }
            catch (NoSuchAlgorithmException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not get SecretKeyFactory of " + oid));
                break;
            }
            pbkdf2_kdfs.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((Object)keyFact));
        }
        boolean bl2 = pbkdf2_kdfs_initialized = (size = pbkdf2_kdfs.size()) > 0;
        if (size > 0) {
            LOG.info("initialized {} PBKDF2 SecretKeyFactory instances", (Object)size);
        } else {
            LOG.error("could not initialize any PBKDF2 SecretKeyFactory instance");
        }
        kupCertExtnIds = new HashSet<String>();
        kupCertExtnIds.add(Extension.biometricInfo.getId());
        kupCertExtnIds.add(Extension.extendedKeyUsage.getId());
        kupCertExtnIds.add(Extension.keyUsage.getId());
        kupCertExtnIds.add(Extension.qCStatements.getId());
        kupCertExtnIds.add(Extension.subjectAlternativeName.getId());
        kupCertExtnIds.add(Extension.subjectInfoAccess.getId());
        errorCodeToPkiFailureMap.put(OperationException.ErrorCode.ALREADY_ISSUED, 32);
        errorCodeToPkiFailureMap.put(OperationException.ErrorCode.BAD_CERT_TEMPLATE, 0x100000);
        errorCodeToPkiFailureMap.put(OperationException.ErrorCode.BAD_REQUEST, 32);
        errorCodeToPkiFailureMap.put(OperationException.ErrorCode.CERT_REVOKED, 8192);
        errorCodeToPkiFailureMap.put(OperationException.ErrorCode.CERT_UNREVOKED, 65536);
        errorCodeToPkiFailureMap.put(OperationException.ErrorCode.BAD_POP, 16384);
        errorCodeToPkiFailureMap.put(OperationException.ErrorCode.NOT_PERMITTED, 65536);
        errorCodeToPkiFailureMap.put(OperationException.ErrorCode.INVALID_EXTENSION, 32);
        errorCodeToPkiFailureMap.put(OperationException.ErrorCode.SYSTEM_UNAVAILABLE, Integer.MIN_VALUE);
        errorCodeToPkiFailureMap.put(OperationException.ErrorCode.UNKNOWN_CERT, 8);
        errorCodeToPkiFailureMap.put(OperationException.ErrorCode.UNKNOWN_CERT_PROFILE, 0x100000);
    }
}

