/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.db;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.OperationException;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CmpControl;
import org.xipki.ca.api.mgmt.CrlControl;
import org.xipki.ca.api.mgmt.CtlogControl;
import org.xipki.ca.api.mgmt.ProtocolSupport;
import org.xipki.ca.api.mgmt.RevokeSuspendedControl;
import org.xipki.ca.api.mgmt.ScepControl;
import org.xipki.ca.api.mgmt.ValidityMode;
import org.xipki.ca.api.mgmt.entry.AddUserEntry;
import org.xipki.ca.api.mgmt.entry.CaEntry;
import org.xipki.ca.api.mgmt.entry.CaHasRequestorEntry;
import org.xipki.ca.api.mgmt.entry.CaHasUserEntry;
import org.xipki.ca.api.mgmt.entry.CertprofileEntry;
import org.xipki.ca.api.mgmt.entry.ChangeCaEntry;
import org.xipki.ca.api.mgmt.entry.ChangeUserEntry;
import org.xipki.ca.api.mgmt.entry.PublisherEntry;
import org.xipki.ca.api.mgmt.entry.RequestorEntry;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.ca.api.mgmt.entry.UserEntry;
import org.xipki.ca.server.CaIdNameMap;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.IdentifiedCertPublisher;
import org.xipki.ca.server.IdentifiedCertprofile;
import org.xipki.ca.server.PasswordHash;
import org.xipki.ca.server.RequestorEntryWrapper;
import org.xipki.ca.server.SignerEntryWrapper;
import org.xipki.ca.server.db.CaManagerQueryExecutorBase;
import org.xipki.ca.server.db.CertStore;
import org.xipki.ca.server.db.ResultRow;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.InvalidConfException;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.StringUtil;
import org.xipki.util.Validity;

public class CaManagerQueryExecutor
extends CaManagerQueryExecutorBase {
    private static final Logger LOG = LoggerFactory.getLogger(CaManagerQueryExecutor.class);
    private final String sqlSelectProfileId;
    private final String sqlSelectProfile;
    private final String sqlSelectPublisherId;
    private final String sqlSelectPublisher;
    private final String sqlSelectRequestorId;
    private final String sqlSelectRequestor;
    private final String sqlSelectSigner;
    private final String sqlSelectCaId;
    private final String sqlSelectCa;
    private final String sqlNextSelectCrlNo;
    private final String sqlSelectSystemEvent;
    private final String sqlSelectUserId;
    private final String sqlSelectUser;
    private final Map<CaManagerQueryExecutorBase.Table, AtomicLong> cachedIdMap = new HashMap<CaManagerQueryExecutorBase.Table, AtomicLong>();

    public CaManagerQueryExecutor(DataSourceWrapper datasource) {
        super(datasource);
        for (CaManagerQueryExecutorBase.Table m : CaManagerQueryExecutorBase.Table.values()) {
            this.cachedIdMap.put(m, new AtomicLong(0L));
        }
        this.sqlSelectProfileId = this.buildSelectFirstSql("ID FROM PROFILE WHERE NAME=?");
        this.sqlSelectCaId = this.buildSelectFirstSql("ID FROM CA WHERE NAME=?");
        this.sqlSelectPublisherId = this.buildSelectFirstSql("ID FROM PUBLISHER WHERE NAME=?");
        this.sqlSelectRequestorId = this.buildSelectFirstSql("ID FROM REQUESTOR WHERE NAME=?");
        this.sqlSelectUserId = this.buildSelectFirstSql("ID FROM TUSER WHERE NAME=?");
        this.sqlSelectProfile = this.buildSelectFirstSql("ID,TYPE,CONF FROM PROFILE WHERE NAME=?");
        this.sqlSelectPublisher = this.buildSelectFirstSql("ID,TYPE,CONF FROM PUBLISHER WHERE NAME=?");
        this.sqlSelectRequestor = this.buildSelectFirstSql("ID,TYPE,CONF FROM REQUESTOR WHERE NAME=?");
        this.sqlSelectSigner = this.buildSelectFirstSql("TYPE,CERT,CONF FROM SIGNER WHERE NAME=?");
        this.sqlSelectCa = this.buildSelectFirstSql("ID,SN_SIZE,NEXT_CRLNO,STATUS,MAX_VALIDITY,CERT,CERTCHAIN,SIGNER_TYPE,CMP_RESPONDER_NAME,SCEP_RESPONDER_NAME,CRL_SIGNER_NAME,CMP_CONTROL,CRL_CONTROL,SCEP_CONTROL,CTLOG_CONTROL,PROTOCOL_SUPPORT,SAVE_REQ,PERMISSION,NUM_CRLS,KEEP_EXPIRED_CERT_DAYS,EXPIRATION_PERIOD,REV_INFO,VALIDITY_MODE,CA_URIS,EXTRA_CONTROL,SIGNER_CONF,DHPOC_CONTROL,REVOKE_SUSPENDED_CONTROL FROM CA WHERE NAME=?");
        this.sqlNextSelectCrlNo = this.buildSelectFirstSql("NEXT_CRLNO FROM CA WHERE ID=?");
        this.sqlSelectSystemEvent = this.buildSelectFirstSql("EVENT_TIME,EVENT_OWNER FROM SYSTEM_EVENT WHERE NAME=?");
        this.sqlSelectUser = this.buildSelectFirstSql("ID,ACTIVE,PASSWORD FROM TUSER WHERE NAME=?");
    }

    public CertStore.SystemEvent getSystemEvent(String eventName) throws CaMgmtException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlSelectSystemEvent, CaManagerQueryExecutor.col2Str(eventName));
        return rs == null ? null : new CertStore.SystemEvent(eventName, rs.getString("EVENT_OWNER"), CaManagerQueryExecutor.getLong(rs, "EVENT_TIME"));
    }

    private void deleteSystemEvent(String eventName) throws CaMgmtException {
        this.execUpdatePrepStmt0("DELETE FROM SYSTEM_EVENT WHERE NAME=?", CaManagerQueryExecutor.col2Str(eventName));
    }

    private void addSystemEvent(CertStore.SystemEvent systemEvent) throws CaMgmtException {
        String sql = "INSERT INTO SYSTEM_EVENT (NAME,EVENT_TIME,EVENT_TIME2,EVENT_OWNER) VALUES (?,?,?,?)";
        int num = this.execUpdatePrepStmt0("INSERT INTO SYSTEM_EVENT (NAME,EVENT_TIME,EVENT_TIME2,EVENT_OWNER) VALUES (?,?,?,?)", CaManagerQueryExecutor.col2Str(systemEvent.getName()), CaManagerQueryExecutor.col2Long(systemEvent.getEventTime()), CaManagerQueryExecutor.col2Timestamp(new Timestamp(systemEvent.getEventTime() * 1000L)), CaManagerQueryExecutor.col2Str(systemEvent.getOwner()));
        if (num == 0) {
            throw new CaMgmtException("could not add system event " + systemEvent.getName());
        }
        LOG.info("added system event {}", (Object)systemEvent.getName());
    }

    public void changeSystemEvent(CertStore.SystemEvent systemEvent) throws CaMgmtException {
        this.deleteSystemEvent(systemEvent.getName());
        this.addSystemEvent(systemEvent);
    }

    public Map<String, Integer> createCaAliases() throws CaMgmtException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<ResultRow> rows = this.execQueryStmt0("SELECT NAME,CA_ID FROM CAALIAS");
        for (ResultRow m : rows) {
            map.put(m.getString("NAME"), CaManagerQueryExecutor.getInt(m, "CA_ID"));
        }
        return map;
    }

    public CertprofileEntry createCertprofile(String name) throws CaMgmtException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlSelectProfile, CaManagerQueryExecutor.col2Str(name));
        if (rs == null) {
            throw new CaMgmtException("unknown CA " + name);
        }
        return new CertprofileEntry(new NameId(Integer.valueOf(CaManagerQueryExecutor.getInt(rs, "ID")), name), rs.getString("TYPE"), rs.getString("CONF"));
    }

    public PublisherEntry createPublisher(String name) throws CaMgmtException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlSelectPublisher, CaManagerQueryExecutor.col2Str(name));
        if (rs == null) {
            throw new CaMgmtException("unkown Publisher " + name);
        }
        return new PublisherEntry(new NameId(Integer.valueOf(CaManagerQueryExecutor.getInt(rs, "ID")), name), rs.getString("TYPE"), rs.getString("CONF"));
    }

    public Integer getRequestorId(String requestorName) throws CaMgmtException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlSelectRequestorId, CaManagerQueryExecutor.col2Str(requestorName));
        return rs == null ? null : Integer.valueOf(CaManagerQueryExecutor.getInt(rs, "ID"));
    }

    public RequestorEntry createRequestor(String name) throws CaMgmtException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlSelectRequestor, CaManagerQueryExecutor.col2Str(name));
        if (rs == null) {
            throw new CaMgmtException("unknown Requestor " + name);
        }
        return new RequestorEntry(new NameId(Integer.valueOf(CaManagerQueryExecutor.getInt(rs, "ID")), name), rs.getString("TYPE"), rs.getString("CONF"));
    }

    public SignerEntry createSigner(String name) throws CaMgmtException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlSelectSigner, CaManagerQueryExecutor.col2Str(name));
        if (rs == null) {
            throw new CaMgmtException("unknown signer " + name);
        }
        return new SignerEntry(name, rs.getString("TYPE"), rs.getString("CONF"), rs.getString("CERT"));
    }

    public CaInfo createCaInfo(String name, CertStore certstore) throws CaMgmtException {
        String extraControl;
        String scepResponderName;
        String cmpResponderName;
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlSelectCa, CaManagerQueryExecutor.col2Str(name));
        if (rs == null) {
            throw new CaMgmtException("uknown CA " + name);
        }
        String caUrisText = rs.getString("CA_URIS");
        CaUris caUris = caUrisText == null ? null : CaUris.decode((String)caUrisText);
        int snSize = CaManagerQueryExecutor.getInt(rs, "SN_SIZE");
        if (snSize > 20) {
            snSize = 20;
        } else if (snSize < 1) {
            snSize = 1;
        }
        CaEntry entry = new CaEntry(new NameId(Integer.valueOf(CaManagerQueryExecutor.getInt(rs, "ID")), name), snSize, CaManagerQueryExecutor.getLong(rs, "NEXT_CRLNO"), rs.getString("SIGNER_TYPE"), rs.getString("SIGNER_CONF"), caUris, CaManagerQueryExecutor.getInt(rs, "NUM_CRLS"), CaManagerQueryExecutor.getInt(rs, "EXPIRATION_PERIOD"));
        entry.setCert(CaManagerQueryExecutor.generateCert(rs.getString("CERT")));
        entry.setDhpocControl(rs.getString("DHPOC_CONTROL"));
        String str = rs.getString("REVOKE_SUSPENDED_CONTROL");
        RevokeSuspendedControl revokeSuspended = str == null ? new RevokeSuspendedControl(false) : new RevokeSuspendedControl(str);
        entry.setRevokeSuspendedControl(revokeSuspended);
        List<X509Cert> certchain = CaManagerQueryExecutor.generateCertchain(rs.getString("CERTCHAIN"));
        if (CollectionUtil.isNotEmpty(certchain)) {
            CaUtil.buildCertChain(entry.getCert(), certchain);
            entry.setCertchain(certchain);
        }
        entry.setStatus(CaStatus.forName((String)rs.getString("STATUS")));
        entry.setMaxValidity(Validity.getInstance((String)rs.getString("MAX_VALIDITY")));
        entry.setKeepExpiredCertInDays(CaManagerQueryExecutor.getInt(rs, "KEEP_EXPIRED_CERT_DAYS"));
        String crlsignerName = rs.getString("CRL_SIGNER_NAME");
        if (StringUtil.isNotBlank((String)crlsignerName)) {
            entry.setCrlSignerName(crlsignerName);
        }
        if (StringUtil.isNotBlank((String)(cmpResponderName = rs.getString("CMP_RESPONDER_NAME")))) {
            entry.setCmpResponderName(cmpResponderName);
        }
        if (StringUtil.isNotBlank((String)(scepResponderName = rs.getString("SCEP_RESPONDER_NAME")))) {
            entry.setScepResponderName(scepResponderName);
        }
        if (StringUtil.isNotBlank((String)(extraControl = rs.getString("EXTRA_CONTROL")))) {
            entry.setExtraControl(new ConfPairs(extraControl).unmodifiable());
        }
        String cmpcontrol = rs.getString("CMP_CONTROL");
        try {
            entry.setCmpControl(new CmpControl(cmpcontrol));
        }
        catch (InvalidConfException ex) {
            throw new CaMgmtException("invalid CMP_CONTROL: " + cmpcontrol);
        }
        String crlcontrol = rs.getString("CRL_CONTROL");
        if (StringUtil.isNotBlank((String)crlcontrol)) {
            try {
                entry.setCrlControl(new CrlControl(crlcontrol));
            }
            catch (InvalidConfException ex) {
                throw new CaMgmtException("invalid CRL_CONTROL: " + crlcontrol, (Throwable)ex);
            }
        }
        String scepcontrol = rs.getString("SCEP_CONTROL");
        try {
            entry.setScepControl(new ScepControl(scepcontrol));
        }
        catch (InvalidConfException ex) {
            throw new CaMgmtException("invalid SCEP_CONTROL: " + scepcontrol, (Throwable)ex);
        }
        String ctlogControl = rs.getString("CTLOG_CONTROL");
        if (StringUtil.isNotBlank((String)ctlogControl)) {
            try {
                entry.setCtlogControl(new CtlogControl(ctlogControl));
            }
            catch (InvalidConfException ex) {
                throw new CaMgmtException("invalid CTLOG_CONTROL: " + scepcontrol, (Throwable)ex);
            }
        }
        entry.setProtocolSupport(new ProtocolSupport(rs.getString("PROTOCOL_SUPPORT")));
        entry.setSaveRequest(CaManagerQueryExecutor.getInt(rs, "SAVE_REQ") != 0);
        entry.setPermission(CaManagerQueryExecutor.getInt(rs, "PERMISSION"));
        String revInfo = rs.getString("REV_INFO");
        CertRevocationInfo revocationInfo = revInfo == null ? null : CertRevocationInfo.fromEncoded((String)revInfo);
        entry.setRevocationInfo(revocationInfo);
        String validityModeS = rs.getString("VALIDITY_MODE");
        entry.setValidityMode(validityModeS == null ? ValidityMode.STRICT : ValidityMode.forName((String)validityModeS));
        try {
            return new CaInfo(entry, certstore);
        }
        catch (OperationException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    public Set<CaHasRequestorEntry> createCaHasRequestors(NameId ca) throws CaMgmtException {
        Map<Integer, String> idNameMap = this.getIdNameMap("REQUESTOR");
        String sql = "SELECT REQUESTOR_ID,RA,PERMISSION,PROFILES FROM CA_HAS_REQUESTOR WHERE CA_ID=?";
        List<ResultRow> rows = this.execQueryPrepStmt0("SELECT REQUESTOR_ID,RA,PERMISSION,PROFILES FROM CA_HAS_REQUESTOR WHERE CA_ID=?", CaManagerQueryExecutor.col2Int(ca.getId()));
        HashSet<CaHasRequestorEntry> ret = new HashSet<CaHasRequestorEntry>();
        for (ResultRow rs : rows) {
            int id = CaManagerQueryExecutor.getInt(rs, "REQUESTOR_ID");
            String name = idNameMap.get(id);
            List list = StringUtil.split((String)rs.getString("PROFILES"), (String)",");
            HashSet profiles = list == null ? null : new HashSet(list);
            CaHasRequestorEntry entry = new CaHasRequestorEntry(new NameId(Integer.valueOf(id), name));
            entry.setRa(CaManagerQueryExecutor.getBoolean(rs, "RA"));
            entry.setPermission(CaManagerQueryExecutor.getInt(rs, "PERMISSION"));
            entry.setProfiles(profiles);
            ret.add(entry);
        }
        return ret;
    }

    public Set<Integer> createCaHasProfiles(NameId ca) throws CaMgmtException {
        return this.createCaHasEntities("CA_HAS_PROFILE", "PROFILE_ID", ca);
    }

    public Set<Integer> createCaHasPublishers(NameId ca) throws CaMgmtException {
        return this.createCaHasEntities("CA_HAS_PUBLISHER", "PUBLISHER_ID", ca);
    }

    private Set<Integer> createCaHasEntities(String table, String column, NameId ca) throws CaMgmtException {
        String sql = "SELECT " + column + " FROM " + table + " WHERE CA_ID=?";
        List<ResultRow> rows = this.execQueryPrepStmt0(sql, CaManagerQueryExecutor.col2Int(ca.getId()));
        HashSet<Integer> ret = new HashSet<Integer>();
        for (ResultRow rs : rows) {
            ret.add(CaManagerQueryExecutor.getInt(rs, column));
        }
        return ret;
    }

    private long getNextId(CaManagerQueryExecutorBase.Table table) throws CaMgmtException {
        try {
            long idInDb = this.datasource.getMax(null, table.name(), "ID");
            AtomicLong cachedId = this.cachedIdMap.get((Object)table);
            long nextId = Math.max(idInDb, cachedId.get()) + 1L;
            cachedId.set(nextId);
            return nextId;
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    public void addCa(CaEntry caEntry) throws CaMgmtException {
        Args.notNull((Object)caEntry, (String)"caEntry");
        caEntry.getIdent().setId(Integer.valueOf((int)this.getNextId(CaManagerQueryExecutorBase.Table.CA)));
        String sql = "INSERT INTO CA (ID,NAME,SUBJECT,SN_SIZE,NEXT_CRLNO,STATUS,CA_URIS,MAX_VALIDITY,CERT,CERTCHAIN,SIGNER_TYPE,CRL_SIGNER_NAME,CMP_RESPONDER_NAME,SCEP_RESPONDER_NAME,CRL_CONTROL,CMP_CONTROL,SCEP_CONTROL,CTLOG_CONTROL,PROTOCOL_SUPPORT,SAVE_REQ,PERMISSION,NUM_CRLS,EXPIRATION_PERIOD,KEEP_EXPIRED_CERT_DAYS,VALIDITY_MODE,EXTRA_CONTROL,SIGNER_CONF,DHPOC_CONTROL,REVOKE_SUSPENDED_CONTROL) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        CaUris caUris = caEntry.getCaUris();
        byte[] encodedCert = caEntry.getCert().getEncoded();
        List certchain = caEntry.getCertchain();
        String certchainStr = CollectionUtil.isEmpty((Collection)certchain) ? null : CaUtil.encodeCertchain(CaUtil.buildCertChain(caEntry.getCert(), certchain));
        CrlControl crlControl = caEntry.getCrlControl();
        CmpControl cmpControl = caEntry.getCmpControl();
        ScepControl scepControl = caEntry.getScepControl();
        CtlogControl ctlogControl = caEntry.getCtlogControl();
        ProtocolSupport protocolSupport = caEntry.getProtocoSupport();
        ConfPairs extraControl = caEntry.getExtraControl();
        String encodedExtraCtrl = extraControl == null ? null : extraControl.getEncoded();
        RevokeSuspendedControl revokeSuspended = caEntry.getRevokeSuspendedControl();
        int num = this.execUpdatePrepStmt0("INSERT INTO CA (ID,NAME,SUBJECT,SN_SIZE,NEXT_CRLNO,STATUS,CA_URIS,MAX_VALIDITY,CERT,CERTCHAIN,SIGNER_TYPE,CRL_SIGNER_NAME,CMP_RESPONDER_NAME,SCEP_RESPONDER_NAME,CRL_CONTROL,CMP_CONTROL,SCEP_CONTROL,CTLOG_CONTROL,PROTOCOL_SUPPORT,SAVE_REQ,PERMISSION,NUM_CRLS,EXPIRATION_PERIOD,KEEP_EXPIRED_CERT_DAYS,VALIDITY_MODE,EXTRA_CONTROL,SIGNER_CONF,DHPOC_CONTROL,REVOKE_SUSPENDED_CONTROL) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", CaManagerQueryExecutor.col2Int(caEntry.getIdent().getId()), CaManagerQueryExecutor.col2Str(caEntry.getIdent().getName()), CaManagerQueryExecutor.col2Str(caEntry.getSubject()), CaManagerQueryExecutor.col2Int(caEntry.getSerialNoLen()), CaManagerQueryExecutor.col2Long(caEntry.getNextCrlNumber()), CaManagerQueryExecutor.col2Str(caEntry.getStatus().getStatus()), CaManagerQueryExecutor.col2Str(caUris == null ? null : caEntry.getCaUris().getEncoded()), CaManagerQueryExecutor.col2Str(caEntry.getMaxValidity().toString()), CaManagerQueryExecutor.col2Str(Base64.encodeToString((byte[])encodedCert)), CaManagerQueryExecutor.col2Str(certchainStr), CaManagerQueryExecutor.col2Str(caEntry.getSignerType()), CaManagerQueryExecutor.col2Str(caEntry.getCrlSignerName()), CaManagerQueryExecutor.col2Str(caEntry.getCmpResponderName()), CaManagerQueryExecutor.col2Str(caEntry.getScepResponderName()), CaManagerQueryExecutor.col2Str(crlControl == null ? null : crlControl.getConf()), CaManagerQueryExecutor.col2Str(cmpControl == null ? null : cmpControl.getConf()), CaManagerQueryExecutor.col2Str(scepControl == null ? null : scepControl.getConf()), CaManagerQueryExecutor.col2Str(ctlogControl == null ? null : ctlogControl.getConf()), CaManagerQueryExecutor.col2Str(protocolSupport == null ? null : protocolSupport.getEncoded()), CaManagerQueryExecutor.col2Bool(caEntry.isSaveRequest()), CaManagerQueryExecutor.col2Int(caEntry.getPermission()), CaManagerQueryExecutor.col2Int(caEntry.getNumCrls()), CaManagerQueryExecutor.col2Int(caEntry.getExpirationPeriod()), CaManagerQueryExecutor.col2Int(caEntry.getKeepExpiredCertInDays()), CaManagerQueryExecutor.col2Str(caEntry.getValidityMode().name()), CaManagerQueryExecutor.col2Str(StringUtil.isBlank((String)encodedExtraCtrl) ? null : encodedExtraCtrl), CaManagerQueryExecutor.col2Str(caEntry.getSignerConf()), CaManagerQueryExecutor.col2Str(caEntry.getDhpocControl()), CaManagerQueryExecutor.col2Str(revokeSuspended == null ? null : revokeSuspended.getConf()));
        if (num == 0) {
            throw new CaMgmtException("could not add CA " + caEntry.getIdent());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("add CA '{}': {}", (Object)caEntry.getIdent(), (Object)caEntry.toString(false, true));
        }
    }

    public void addCaAlias(String aliasName, NameId ca) throws CaMgmtException {
        this.notNulls(aliasName, "aliasName", ca, "ca");
        String sql = "INSERT INTO CAALIAS (NAME,CA_ID) VALUES (?,?)";
        int num = this.execUpdatePrepStmt0("INSERT INTO CAALIAS (NAME,CA_ID) VALUES (?,?)", CaManagerQueryExecutor.col2Str(aliasName), CaManagerQueryExecutor.col2Int(ca.getId()));
        if (num == 0) {
            throw new CaMgmtException("could not add CA alias " + aliasName);
        }
        LOG.info("added CA alias '{}' for CA '{}'", (Object)aliasName, (Object)ca);
    }

    public void addCertprofile(CertprofileEntry dbEntry) throws CaMgmtException {
        Args.notNull((Object)dbEntry, (String)"dbEntry");
        String sql = "INSERT INTO PROFILE (ID,NAME,TYPE,CONF) VALUES (?,?,?,?)";
        dbEntry.getIdent().setId(Integer.valueOf((int)this.getNextId(CaManagerQueryExecutorBase.Table.PROFILE)));
        int num = this.execUpdatePrepStmt0("INSERT INTO PROFILE (ID,NAME,TYPE,CONF) VALUES (?,?,?,?)", CaManagerQueryExecutor.col2Int(dbEntry.getIdent().getId()), CaManagerQueryExecutor.col2Str(dbEntry.getIdent().getName()), CaManagerQueryExecutor.col2Str(dbEntry.getType()), CaManagerQueryExecutor.col2Str(dbEntry.getConf()));
        if (num == 0) {
            throw new CaMgmtException("could not add certprofile " + dbEntry.getIdent());
        }
        LOG.info("added profile '{}': {}", (Object)dbEntry.getIdent(), (Object)dbEntry);
    }

    public void addCertprofileToCa(NameId profile, NameId ca) throws CaMgmtException {
        this.notNulls(profile, "profile", ca, "ca");
        String sql = "INSERT INTO CA_HAS_PROFILE (CA_ID,PROFILE_ID) VALUES (?,?)";
        this.addEntityToCa("profile", profile, ca, "INSERT INTO CA_HAS_PROFILE (CA_ID,PROFILE_ID) VALUES (?,?)");
    }

    public void addPublisherToCa(NameId publisher, NameId ca) throws CaMgmtException {
        this.notNulls(publisher, "publisher", ca, "ca");
        String sql = "INSERT INTO CA_HAS_PUBLISHER (CA_ID,PUBLISHER_ID) VALUES (?,?)";
        this.addEntityToCa("publisher", publisher, ca, "INSERT INTO CA_HAS_PUBLISHER (CA_ID,PUBLISHER_ID) VALUES (?,?)");
    }

    private void addEntityToCa(String desc, NameId entity, NameId ca, String sql) throws CaMgmtException {
        int num = this.execUpdatePrepStmt0(sql, CaManagerQueryExecutor.col2Int(ca.getId()), CaManagerQueryExecutor.col2Int(entity.getId()));
        if (num == 0) {
            throw new CaMgmtException("could not add " + desc + " " + entity + " to CA " + ca);
        }
        LOG.info("added {} '{}' to CA '{}'", new Object[]{desc, entity, ca});
    }

    public void addRequestor(RequestorEntry dbEntry) throws CaMgmtException {
        Args.notNull((Object)dbEntry, (String)"dbEntry");
        dbEntry.getIdent().setId(Integer.valueOf((int)this.getNextId(CaManagerQueryExecutorBase.Table.REQUESTOR)));
        String sql = "INSERT INTO REQUESTOR (ID,NAME,TYPE,CONF) VALUES (?,?,?,?)";
        int num = this.execUpdatePrepStmt0("INSERT INTO REQUESTOR (ID,NAME,TYPE,CONF) VALUES (?,?,?,?)", CaManagerQueryExecutor.col2Int(dbEntry.getIdent().getId()), CaManagerQueryExecutor.col2Str(dbEntry.getIdent().getName()), CaManagerQueryExecutor.col2Str(dbEntry.getType()), CaManagerQueryExecutor.col2Str(dbEntry.getConf()));
        if (num == 0) {
            throw new CaMgmtException("could not add requestor " + dbEntry.getIdent());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("added requestor '{}': {}", (Object)dbEntry.getIdent(), (Object)dbEntry.toString(false));
        }
    }

    public void addEmbeddedRequestor(String requestorName) throws CaMgmtException {
        requestorName = requestorName.toLowerCase();
        String sql = "INSERT INTO REQUESTOR (ID,NAME,TYPE,CONF) VALUES (?,?,?,?)";
        int nextId = (int)this.getNextId(CaManagerQueryExecutorBase.Table.REQUESTOR);
        int num = this.execUpdatePrepStmt0(sql, CaManagerQueryExecutor.col2Int(nextId), CaManagerQueryExecutor.col2Str(requestorName), CaManagerQueryExecutor.col2Str("EMBEDDED"), CaManagerQueryExecutor.col2Str("DEFAULT"));
        if (num == 0) {
            throw new CaMgmtException("could not add requestor " + requestorName);
        }
        LOG.info("added requestor '{}'", (Object)requestorName);
    }

    public void addRequestorToCa(CaHasRequestorEntry requestor, NameId ca) throws CaMgmtException {
        this.notNulls(requestor, "requestor", ca, "ca");
        String sql = "INSERT INTO CA_HAS_REQUESTOR (CA_ID,REQUESTOR_ID,RA, PERMISSION,PROFILES) VALUES (?,?,?,?,?)";
        String profilesText = StringUtil.collectionAsString((Collection)requestor.getProfiles(), (String)",");
        NameId requestorIdent = requestor.getRequestorIdent();
        int num = this.execUpdatePrepStmt0("INSERT INTO CA_HAS_REQUESTOR (CA_ID,REQUESTOR_ID,RA, PERMISSION,PROFILES) VALUES (?,?,?,?,?)", CaManagerQueryExecutor.col2Int(ca.getId()), CaManagerQueryExecutor.col2Int(requestorIdent.getId()), CaManagerQueryExecutor.col2Bool(requestor.isRa()), CaManagerQueryExecutor.col2Int(requestor.getPermission()), CaManagerQueryExecutor.col2Str(profilesText));
        if (num == 0) {
            throw new CaMgmtException("could not add requestor " + requestorIdent + " to CA " + ca);
        }
        LOG.info("added requestor '{}' to CA '{}': ra: {}; permission: {}; profile: {}", new Object[]{requestorIdent, ca, requestor.isRa(), requestor.getPermission(), profilesText});
    }

    public void addPublisher(PublisherEntry dbEntry) throws CaMgmtException {
        Args.notNull((Object)dbEntry, (String)"dbEntry");
        String sql = "INSERT INTO PUBLISHER (ID,NAME,TYPE,CONF) VALUES (?,?,?,?)";
        dbEntry.getIdent().setId(Integer.valueOf((int)this.getNextId(CaManagerQueryExecutorBase.Table.PUBLISHER)));
        String name = dbEntry.getIdent().getName();
        int num = this.execUpdatePrepStmt0("INSERT INTO PUBLISHER (ID,NAME,TYPE,CONF) VALUES (?,?,?,?)", CaManagerQueryExecutor.col2Int(dbEntry.getIdent().getId()), CaManagerQueryExecutor.col2Str(name), CaManagerQueryExecutor.col2Str(dbEntry.getType()), CaManagerQueryExecutor.col2Str(dbEntry.getConf()));
        if (num == 0) {
            throw new CaMgmtException("could not add publisher " + dbEntry.getIdent());
        }
        LOG.info("added publisher '{}': {}", (Object)dbEntry.getIdent(), (Object)dbEntry);
    }

    public void changeCa(ChangeCaEntry changeCaEntry, CaEntry currentCaEntry, SecurityFactory securityFactory) throws CaMgmtException {
        this.notNulls(changeCaEntry, "changeCaEntry", securityFactory, "securityFactory");
        byte[] encodedCert = changeCaEntry.getEncodedCert();
        if (encodedCert != null) {
            boolean anyCertIssued;
            try {
                anyCertIssued = this.datasource.columnExists(null, "CERT", "CA_ID", (Object)changeCaEntry.getIdent().getId());
            }
            catch (DataAccessException ex) {
                throw new CaMgmtException((Throwable)ex);
            }
            if (anyCertIssued) {
                throw new CaMgmtException("Cannot change certificate of CA which has issued certificates");
            }
        }
        String signerType = changeCaEntry.getSignerType();
        String signerConf = changeCaEntry.getSignerConf();
        X509Cert caCert = null;
        if (signerType != null || signerConf != null || encodedCert != null || CollectionUtil.isNotEmpty((Collection)changeCaEntry.getEncodedCertchain())) {
            ResultRow rs;
            String sql;
            if (encodedCert != null) {
                caCert = CaUtil.parseCert(encodedCert);
            } else {
                sql = "SELECT CERT FROM CA WHERE ID=?";
                rs = this.execQuery1PrepStmt0("SELECT CERT FROM CA WHERE ID=?", CaManagerQueryExecutor.col2Int(changeCaEntry.getIdent().getId()));
                if (rs == null) {
                    throw new CaMgmtException("unknown CA '" + changeCaEntry.getIdent());
                }
                caCert = CaUtil.parseCert(Base64.decode((String)rs.getString("CERT")));
            }
            if (signerType != null || signerConf != null || encodedCert != null) {
                sql = "SELECT SIGNER_TYPE,SIGNER_CONF FROM CA WHERE ID=?";
                rs = this.execQuery1PrepStmt0("SELECT SIGNER_TYPE,SIGNER_CONF FROM CA WHERE ID=?", CaManagerQueryExecutor.col2Int(changeCaEntry.getIdent().getId()));
                if (rs == null) {
                    throw new CaMgmtException("unknown CA '" + changeCaEntry.getIdent());
                }
                if (signerType == null) {
                    signerType = rs.getString("SIGNER_TYPE");
                }
                signerConf = signerConf == null ? rs.getString("SIGNER_CONF") : CaUtil.canonicalizeSignerConf(signerType, signerConf, null, securityFactory);
                try {
                    List signerConfs = CaEntry.splitCaSignerConfs((String)signerConf);
                    for (CaEntry.CaSignerConf m : signerConfs) {
                        securityFactory.createSigner(signerType, new SignerConf(m.getConf()), caCert);
                    }
                }
                catch (XiSecurityException | ObjectCreationException ex) {
                    throw new CaMgmtException("could not create signer for CA '" + changeCaEntry.getIdent() + "'" + ex.getMessage(), ex);
                }
            }
        }
        String subject = null;
        String base64Cert = null;
        if (encodedCert != null) {
            try {
                subject = X509Util.parseCert((byte[])encodedCert).getIssuerRfc4519Text();
                base64Cert = Base64.encodeToString((byte[])encodedCert);
            }
            catch (CertificateException ex) {
                throw new CaMgmtException("could not parse the certificate", (Throwable)ex);
            }
        }
        String status = changeCaEntry.getStatus() == null ? null : changeCaEntry.getStatus().name();
        String maxValidity = changeCaEntry.getMaxValidity() == null ? null : changeCaEntry.getMaxValidity().toString();
        String extraControl = changeCaEntry.getExtraControl() == null ? null : new ConfPairs(changeCaEntry.getExtraControl()).getEncoded();
        String validityMode = changeCaEntry.getValidityMode() == null ? null : changeCaEntry.getValidityMode().name();
        String caUrisStr = null;
        CaUris changeUris = changeCaEntry.getCaUris();
        if (changeUris != null && (changeUris.getCacertUris() != null || changeUris.getCrlUris() != null || changeUris.getDeltaCrlUris() != null || changeUris.getOcspUris() != null)) {
            List deltaCrlUris;
            CaUris oldCaUris = currentCaEntry.getCaUris();
            List uris = changeUris.getCacertUris();
            List cacertUris = uris == null ? oldCaUris.getCacertUris() : uris;
            uris = changeUris.getOcspUris();
            List ocspUris = uris == null ? oldCaUris.getOcspUris() : uris;
            uris = changeUris.getCrlUris();
            List crlUris = uris == null ? oldCaUris.getCrlUris() : uris;
            CaUris newCaUris = new CaUris(cacertUris, ocspUris, crlUris, deltaCrlUris = (uris = changeUris.getDeltaCrlUris()) == null ? oldCaUris.getDeltaCrlUris() : uris);
            caUrisStr = newCaUris.getEncoded();
            if (caUrisStr.isEmpty()) {
                caUrisStr = "null";
            }
        }
        String protocolSupportStr = null;
        Boolean supportCmp = changeCaEntry.getSupportCmp();
        Boolean supportRest = changeCaEntry.getSupportRest();
        Boolean supportScep = changeCaEntry.getSupportScep();
        if (supportCmp != null || supportRest != null || supportScep != null) {
            ProtocolSupport oldSupport = currentCaEntry.getProtocoSupport();
            ProtocolSupport support = new ProtocolSupport(oldSupport.isCmp(), oldSupport.isRest(), oldSupport.isScep());
            if (supportCmp != null) {
                support.setCmp(supportCmp.booleanValue());
            }
            if (supportRest != null) {
                support.setRest(supportRest.booleanValue());
            }
            if (supportScep != null) {
                support.setScep(supportScep.booleanValue());
            }
            protocolSupportStr = support.getEncoded();
        }
        String certchainStr = null;
        if (changeCaEntry.getEncodedCertchain() != null) {
            List encodedCertchain = changeCaEntry.getEncodedCertchain();
            if (encodedCertchain.size() == 0) {
                certchainStr = "null";
            } else {
                List<X509Cert> certs = new LinkedList<X509Cert>();
                for (byte[] m : changeCaEntry.getEncodedCertchain()) {
                    certs.add(CaUtil.parseCert(m));
                }
                certs = CaUtil.buildCertChain(caCert, certs);
                certchainStr = CaUtil.encodeCertchain(certs);
            }
        }
        this.changeIfNotNull("CA", CaManagerQueryExecutor.colInt("ID", changeCaEntry.getIdent().getId()), CaManagerQueryExecutor.colInt("SN_SIZE", changeCaEntry.getSerialNoLen()), CaManagerQueryExecutor.colStr("STATUS", status), CaManagerQueryExecutor.colStr("SUBJECT", subject), CaManagerQueryExecutor.colStr("CERT", base64Cert), CaManagerQueryExecutor.colStr("CERTCHAIN", certchainStr), CaManagerQueryExecutor.colStr("CA_URIS", caUrisStr), CaManagerQueryExecutor.colStr("MAX_VALIDITY", maxValidity), CaManagerQueryExecutor.colStr("SIGNER_TYPE", signerType), CaManagerQueryExecutor.colStr("CRL_SIGNER_NAME", changeCaEntry.getCrlSignerName()), CaManagerQueryExecutor.colStr("CMP_RESPONDER_NAME", changeCaEntry.getCmpResponderName()), CaManagerQueryExecutor.colStr("SCEP_RESPONDER_NAME", changeCaEntry.getScepResponderName()), CaManagerQueryExecutor.colStr("CMP_CONTROL", changeCaEntry.getCmpControl()), CaManagerQueryExecutor.colStr("CRL_CONTROL", changeCaEntry.getCrlControl()), CaManagerQueryExecutor.colStr("SCEP_CONTROL", changeCaEntry.getScepControl()), CaManagerQueryExecutor.colStr("CTLOG_CONTROL", changeCaEntry.getCtlogControl()), CaManagerQueryExecutor.colStr("PROTOCOL_SUPPORT", protocolSupportStr), CaManagerQueryExecutor.colBool("SAVE_REQ", changeCaEntry.getSaveRequest()), CaManagerQueryExecutor.colInt("PERMISSION", changeCaEntry.getPermission()), CaManagerQueryExecutor.colInt("NUM_CRLS", changeCaEntry.getNumCrls()), CaManagerQueryExecutor.colInt("EXPIRATION_PERIOD", changeCaEntry.getExpirationPeriod()), CaManagerQueryExecutor.colInt("KEEP_EXPIRED_CERT_DAYS", changeCaEntry.getKeepExpiredCertInDays()), CaManagerQueryExecutor.colStr("VALIDITY_MODE", validityMode), CaManagerQueryExecutor.colStr("EXTRA_CONTROL", extraControl), CaManagerQueryExecutor.colStr("SIGNER_CONF", signerConf, false, true), CaManagerQueryExecutor.colStr("DHPOC_CONTROL", changeCaEntry.getDhpocControl(), false, true), CaManagerQueryExecutor.colStr("REVOKE_SUSPENDED_CONTROL", changeCaEntry.getRevokeSuspendedControl()));
    }

    public void commitNextCrlNoIfLess(NameId ca, long nextCrlNo) throws CaMgmtException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlNextSelectCrlNo, CaManagerQueryExecutor.col2Int(ca.getId()));
        long nextCrlNoInDb = CaManagerQueryExecutor.getLong(rs, "NEXT_CRLNO");
        if (nextCrlNoInDb < nextCrlNo) {
            this.execUpdatePrepStmt0("UPDATE CA SET NEXT_CRLNO=? WHERE ID=?", CaManagerQueryExecutor.col2Long(nextCrlNo), CaManagerQueryExecutor.col2Int(ca.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentifiedCertprofile changeCertprofile(NameId nameId, String type, String conf, CaManagerImpl certprofileManager) throws CaMgmtException {
        CertprofileEntry currentDbEntry = this.createCertprofile(nameId.getName());
        CertprofileEntry newDbEntry = new CertprofileEntry(currentDbEntry.getIdent(), CaManagerQueryExecutor.str(type, currentDbEntry.getType()), CaManagerQueryExecutor.str(conf, currentDbEntry.getConf()));
        IdentifiedCertprofile profile = certprofileManager.createCertprofile(newDbEntry);
        if (profile == null) {
            throw new CaMgmtException("could not create certprofile object");
        }
        boolean failed = true;
        try {
            this.changeIfNotNull("PROFILE", CaManagerQueryExecutor.colInt("ID", nameId.getId()), CaManagerQueryExecutor.colStr("TYPE", type), CaManagerQueryExecutor.colStr("CONF", conf));
            failed = false;
            IdentifiedCertprofile identifiedCertprofile = profile;
            return identifiedCertprofile;
        }
        finally {
            if (failed) {
                profile.close();
            }
        }
    }

    public RequestorEntryWrapper changeRequestor(NameId nameId, String type, String conf, PasswordResolver passwordResolver) throws CaMgmtException {
        Args.notNull((Object)nameId, (String)"nameId");
        RequestorEntryWrapper requestor = new RequestorEntryWrapper();
        if ("pbm".equalsIgnoreCase(type) && !StringUtil.startsWithIgnoreCase((String)conf, (String)"PBE:")) {
            try {
                conf = passwordResolver.protectPassword("PBE", conf.toCharArray());
            }
            catch (PasswordResolverException ex) {
                throw new CaMgmtException("could not encrypt password of requestor " + nameId.getName(), (Throwable)ex);
            }
        }
        requestor.setDbEntry(new RequestorEntry(nameId, type, conf), passwordResolver);
        if (requestor.getDbEntry().isFaulty()) {
            throw new CaMgmtException("invalid requestor configuration");
        }
        this.changeIfNotNull("REQUESTOR", CaManagerQueryExecutor.colInt("ID", nameId.getId()), CaManagerQueryExecutor.colStr("TYPE", type), CaManagerQueryExecutor.colStr("CONF", conf));
        return requestor;
    }

    public SignerEntryWrapper changeSigner(String name, String type, String conf, String base64Cert, CaManagerImpl signerManager, SecurityFactory securityFactory) throws CaMgmtException {
        String tmpType;
        Args.notBlank((String)name, (String)"name");
        Args.notNull((Object)signerManager, (String)"signerManager");
        SignerEntry dbEntry = this.createSigner(name);
        String string = tmpType = type == null ? dbEntry.getType() : type;
        if (conf != null) {
            conf = CaUtil.canonicalizeSignerConf(tmpType, conf, null, securityFactory);
        }
        SignerEntry newDbEntry = new SignerEntry(name, tmpType, conf == null ? dbEntry.getConf() : conf, base64Cert == null ? dbEntry.getBase64Cert() : base64Cert);
        SignerEntryWrapper responder = signerManager.createSigner(newDbEntry);
        this.changeIfNotNull("SIGNER", CaManagerQueryExecutor.colStr("NAME", name), CaManagerQueryExecutor.colStr("TYPE", type), CaManagerQueryExecutor.colStr("CERT", base64Cert), CaManagerQueryExecutor.colStr("CONF", conf, false, true));
        return responder;
    }

    public IdentifiedCertPublisher changePublisher(String name, String type, String conf, CaManagerImpl publisherManager) throws CaMgmtException {
        Args.notBlank((String)name, (String)"name");
        Args.notNull((Object)publisherManager, (String)"publisherManager");
        PublisherEntry currentDbEntry = this.createPublisher(name);
        PublisherEntry dbEntry = new PublisherEntry(currentDbEntry.getIdent(), type == null ? currentDbEntry.getType() : type, conf == null ? currentDbEntry.getConf() : conf);
        IdentifiedCertPublisher publisher = publisherManager.createPublisher(dbEntry);
        this.changeIfNotNull("PUBLISHER", CaManagerQueryExecutor.colStr("NAME", name), CaManagerQueryExecutor.colStr("TYPE", type), CaManagerQueryExecutor.colStr("CONF", conf));
        return publisher;
    }

    public void removeCa(String caName) throws CaMgmtException {
        Args.notBlank((String)caName, (String)"caName");
        String sql = "DELETE FROM CA WHERE NAME=?";
        int num = this.execUpdatePrepStmt0("DELETE FROM CA WHERE NAME=?", CaManagerQueryExecutor.col2Str(caName));
        if (num == 0) {
            throw new CaMgmtException("could not delelted CA " + caName);
        }
    }

    public void removeCaAlias(String aliasName) throws CaMgmtException {
        Args.notBlank((String)aliasName, (String)"aliasName");
        int num = this.execUpdatePrepStmt0("DELETE FROM CAALIAS WHERE NAME=?", CaManagerQueryExecutor.col2Str(aliasName));
        if (num == 0) {
            throw new CaMgmtException("could not remove CA Alias " + aliasName);
        }
    }

    public void removeCertprofileFromCa(String profileName, String caName) throws CaMgmtException {
        Args.notBlank((String)profileName, (String)"profileName");
        Args.notBlank((String)caName, (String)"caName");
        this.removeEntityFromCa("profile", profileName, caName, this.sqlSelectProfileId, "DELETE FROM CA_HAS_PROFILE WHERE CA_ID=? AND PROFILE_ID=?");
    }

    public void removeRequestorFromCa(String requestorName, String caName) throws CaMgmtException {
        Args.notBlank((String)requestorName, (String)"requestorName");
        Args.notBlank((String)caName, (String)"caName");
        this.removeEntityFromCa("requestor", requestorName, caName, this.sqlSelectRequestorId, "DELETE FROM CA_HAS_REQUESTOR WHERE CA_ID=? AND REQUESTOR_ID=?");
    }

    public void removePublisherFromCa(String publisherName, String caName) throws CaMgmtException {
        Args.notBlank((String)publisherName, (String)"publisherName");
        Args.notBlank((String)caName, (String)"caName");
        this.removeEntityFromCa("publisher", publisherName, caName, this.sqlSelectPublisherId, "DELETE FROM CA_HAS_PUBLISHER WHERE CA_ID=? AND PUBLISHER_ID=?");
    }

    public void removeUserFromCa(String username, String caName) throws CaMgmtException {
        Args.notBlank((String)username, (String)"username");
        Args.notBlank((String)caName, (String)"caName");
        this.removeEntityFromCa("user", username, caName, this.sqlSelectUserId, "DELETE FROM CA_HAS_USER WHERE CA_ID=? AND USER_ID=?");
    }

    private void removeEntityFromCa(String desc, String name, String caName, String sqlSelectId, String sqlRemove) throws CaMgmtException {
        Integer id = this.getIdForName(sqlSelectId, name);
        if (id == null) {
            throw new CaMgmtException(String.format("unknown %s %s ", desc, name));
        }
        int caId = this.getNonNullIdForName(this.sqlSelectCaId, caName);
        int num = this.execUpdatePrepStmt0(sqlRemove, CaManagerQueryExecutor.col2Int(caId), CaManagerQueryExecutor.col2Int(id));
        if (num == 0) {
            throw new CaMgmtException(String.format("could not remove %s from CA %s", name, caName));
        }
    }

    public void revokeCa(String caName, CertRevocationInfo revocationInfo) throws CaMgmtException {
        Args.notBlank((String)caName, (String)"caName");
        Args.notNull((Object)revocationInfo, (String)"revocationInfo");
        int num = this.execUpdatePrepStmt0("UPDATE CA SET REV_INFO=? WHERE NAME=?", CaManagerQueryExecutor.col2Str(revocationInfo.getEncoded()), CaManagerQueryExecutor.col2Str(caName));
        if (num == 0) {
            throw new CaMgmtException("could not revoke CA " + caName);
        }
    }

    public void addSigner(SignerEntry dbEntry) throws CaMgmtException {
        Args.notNull((Object)dbEntry, (String)"dbEntry");
        int num = this.execUpdatePrepStmt0("INSERT INTO SIGNER (NAME,TYPE,CERT,CONF) VALUES (?,?,?,?)", CaManagerQueryExecutor.col2Str(dbEntry.getName()), CaManagerQueryExecutor.col2Str(dbEntry.getType()), CaManagerQueryExecutor.col2Str(dbEntry.getBase64Cert()), CaManagerQueryExecutor.col2Str(dbEntry.getConf()));
        if (num == 0) {
            throw new CaMgmtException("could not add signer " + dbEntry.getName());
        }
        LOG.info("added signer: {}", (Object)dbEntry.toString(false, true));
    }

    public void unlockCa() throws CaMgmtException {
        int num = this.execUpdateStmt0("DELETE FROM SYSTEM_EVENT WHERE NAME='LOCK'");
        if (num == 0) {
            throw new CaMgmtException("could not unlock CA");
        }
    }

    public void unrevokeCa(String caName) throws CaMgmtException {
        Args.notBlank((String)caName, (String)"caName");
        LOG.info("Unrevoking of CA '{}'", (Object)caName);
        int num = this.execUpdatePrepStmt0("UPDATE CA SET REV_INFO=? WHERE NAME=?", CaManagerQueryExecutor.col2Str(null), CaManagerQueryExecutor.col2Str(caName));
        if (num == 0) {
            throw new CaMgmtException("could not unrevoke CA " + caName);
        }
    }

    public void addUser(AddUserEntry userEntry) throws CaMgmtException {
        Args.notNull((Object)userEntry, (String)"userEntry");
        String hashedPassword = PasswordHash.createHash(userEntry.getPassword());
        this.addUser(userEntry.getIdent().getName(), userEntry.isActive(), hashedPassword);
    }

    public void addUser(UserEntry userEntry) throws CaMgmtException {
        Args.notNull((Object)userEntry, (String)"userEntry");
        this.addUser(userEntry.getIdent().getName(), userEntry.isActive(), userEntry.getHashedPassword());
    }

    private void addUser(String name, boolean active, String hashedPassword) throws CaMgmtException {
        Integer existingId = this.getIdForName(this.sqlSelectUserId, name);
        if (existingId != null) {
            throw new CaMgmtException(StringUtil.concat((String)"user named '", (String[])new String[]{name, " ' already exists"}));
        }
        long id = this.getNextId(CaManagerQueryExecutorBase.Table.TUSER);
        int num = this.execUpdatePrepStmt0("INSERT INTO TUSER (ID,NAME,ACTIVE,PASSWORD) VALUES (?,?,?,?)", CaManagerQueryExecutor.col2Long(id), CaManagerQueryExecutor.col2Str(name), CaManagerQueryExecutor.col2Bool(active), CaManagerQueryExecutor.col2Str(hashedPassword));
        if (num == 0) {
            throw new CaMgmtException("could not add user " + name);
        }
        LOG.info("added user '{}'", (Object)name);
    }

    public void changeUser(ChangeUserEntry userEntry) throws CaMgmtException {
        String username = userEntry.getIdent().getName();
        Integer existingId = this.getIdForName(this.sqlSelectUserId, username);
        if (existingId == null) {
            throw new CaMgmtException(StringUtil.concat((String)"user '", (String[])new String[]{username, " ' does not exist"}));
        }
        userEntry.getIdent().setId(existingId);
        String password = userEntry.getPassword();
        String hashedPassword = null;
        if (password != null) {
            hashedPassword = PasswordHash.createHash(password);
        }
        this.changeIfNotNull("TUSER", CaManagerQueryExecutor.colInt("ID", existingId), CaManagerQueryExecutor.colBool("ACTIVE", userEntry.getActive()), CaManagerQueryExecutor.colStr("PASSWORD", hashedPassword, true, false));
    }

    public void addUserToCa(CaHasUserEntry user, NameId ca) throws CaMgmtException {
        this.notNulls(user, "user", ca, "ca");
        NameId userIdent = user.getUserIdent();
        Integer existingId = this.getIdForName(this.sqlSelectUserId, userIdent.getName());
        if (existingId == null) {
            throw new CaMgmtException(StringUtil.concat((String)"user '", (String[])new String[]{userIdent.getName(), " ' does not exist"}));
        }
        userIdent.setId(existingId);
        long id = this.getNextId(CaManagerQueryExecutorBase.Table.CA_HAS_USER);
        String profilesText = StringUtil.collectionAsString((Collection)user.getProfiles(), (String)",");
        int num = this.execUpdatePrepStmt0("INSERT INTO CA_HAS_USER (ID,CA_ID,USER_ID, PERMISSION,PROFILES) VALUES (?,?,?,?,?)", CaManagerQueryExecutor.col2Long(id), CaManagerQueryExecutor.col2Int(ca.getId()), CaManagerQueryExecutor.col2Int(userIdent.getId()), CaManagerQueryExecutor.col2Int(user.getPermission()), CaManagerQueryExecutor.col2Str(profilesText));
        if (num == 0) {
            throw new CaMgmtException("could not add user " + userIdent + " to CA " + ca);
        }
        LOG.info("added user '{}' to CA '{}': permission: {}; profile: {}", new Object[]{userIdent, ca, user.getPermission(), profilesText});
    }

    public Map<String, CaHasUserEntry> getCaHasUsersForUser(String user, CaIdNameMap idNameMap) throws CaMgmtException {
        Integer existingId = this.getIdForName(this.sqlSelectUserId, user);
        if (existingId == null) {
            throw new CaMgmtException(StringUtil.concat((String)"user '", (String[])new String[]{user, " ' does not exist"}));
        }
        String sql = "SELECT CA_ID,PERMISSION,PROFILES FROM CA_HAS_USER WHERE USER_ID=?";
        List<ResultRow> rows = this.execQueryPrepStmt0("SELECT CA_ID,PERMISSION,PROFILES FROM CA_HAS_USER WHERE USER_ID=?", CaManagerQueryExecutor.col2Int(existingId));
        HashMap<String, CaHasUserEntry> ret = new HashMap<String, CaHasUserEntry>();
        for (ResultRow rs : rows) {
            List list = StringUtil.split((String)rs.getString("PROFILES"), (String)",");
            HashSet profiles = list == null ? null : new HashSet(list);
            CaHasUserEntry caHasUser = new CaHasUserEntry(new NameId(existingId, user));
            caHasUser.setPermission(CaManagerQueryExecutor.getInt(rs, "PERMISSION"));
            caHasUser.setProfiles(profiles);
            int caId = CaManagerQueryExecutor.getInt(rs, "CA_ID");
            String caName = idNameMap.getCaName(caId);
            ret.put(caName, caHasUser);
        }
        return ret;
    }

    public List<CaHasUserEntry> getCaHasUsersForCa(String caName, CaIdNameMap idNameMap) throws CaMgmtException {
        NameId caIdent = idNameMap.getCa(caName);
        if (caIdent == null) {
            throw new CaMgmtException("unknown CA " + caName);
        }
        String sql = "SELECT NAME,PERMISSION,PROFILES FROM CA_HAS_USER INNER JOIN TUSER ON CA_ID=? AND TUSER.ID=CA_HAS_USER.USER_ID";
        List<ResultRow> rows = this.execQueryPrepStmt0("SELECT NAME,PERMISSION,PROFILES FROM CA_HAS_USER INNER JOIN TUSER ON CA_ID=? AND TUSER.ID=CA_HAS_USER.USER_ID", CaManagerQueryExecutor.col2Int(caIdent.getId()));
        LinkedList<CaHasUserEntry> ret = new LinkedList<CaHasUserEntry>();
        for (ResultRow rs : rows) {
            List list = StringUtil.split((String)rs.getString("PROFILES"), (String)",");
            HashSet profiles = list == null ? null : new HashSet(list);
            CaHasUserEntry caHasUser = new CaHasUserEntry(new NameId(null, rs.getString("NAME")));
            caHasUser.setPermission(CaManagerQueryExecutor.getInt(rs, "PERMISSION"));
            caHasUser.setProfiles(profiles);
            ret.add(caHasUser);
        }
        return ret;
    }

    public UserEntry getUser(String username) throws CaMgmtException {
        return this.getUser(username, false);
    }

    public UserEntry getUser(String username, boolean nullable) throws CaMgmtException {
        Args.notBlank((String)username, (String)"username");
        NameId ident = new NameId(null, username);
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlSelectUser, CaManagerQueryExecutor.col2Str(ident.getName()));
        if (rs == null) {
            if (nullable) {
                return null;
            }
            throw new CaMgmtException("unknown user " + username);
        }
        ident.setId(Integer.valueOf(CaManagerQueryExecutor.getInt(rs, "ID")));
        return new UserEntry(ident, CaManagerQueryExecutor.getBoolean(rs, "ACTIVE"), rs.getString("PASSWORD"));
    }

    private static X509Cert generateCert(String b64Cert) throws CaMgmtException {
        return b64Cert == null ? null : CaUtil.parseCert(Base64.decode((String)b64Cert));
    }

    private static List<X509Cert> generateCertchain(String encodedCertchain) throws CaMgmtException {
        if (StringUtil.isBlank((String)encodedCertchain)) {
            return null;
        }
        try {
            List certs = X509Util.listCertificates((String)encodedCertchain);
            return CollectionUtil.isEmpty((Collection)certs) ? null : certs;
        }
        catch (IOException | CertificateException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    private static boolean getBoolean(ResultRow rs, String label) {
        return rs.getBoolean(label);
    }

    private static int getInt(ResultRow rs, String label) {
        return rs.getInt(label);
    }

    private static long getLong(ResultRow rs, String label) {
        return rs.getLong(label);
    }
}

