/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.SocketException;
import java.sql.Connection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditStatus;
import org.xipki.audit.Audits;
import org.xipki.audit.PciAuditEvent;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.OperationException;
import org.xipki.ca.api.mgmt.CaManager;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CaSystemStatus;
import org.xipki.ca.api.mgmt.CertListInfo;
import org.xipki.ca.api.mgmt.CertListOrderBy;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.api.mgmt.RequestorInfo;
import org.xipki.ca.api.mgmt.entry.AddUserEntry;
import org.xipki.ca.api.mgmt.entry.CaEntry;
import org.xipki.ca.api.mgmt.entry.CaHasRequestorEntry;
import org.xipki.ca.api.mgmt.entry.CaHasUserEntry;
import org.xipki.ca.api.mgmt.entry.CertprofileEntry;
import org.xipki.ca.api.mgmt.entry.ChangeCaEntry;
import org.xipki.ca.api.mgmt.entry.ChangeUserEntry;
import org.xipki.ca.api.mgmt.entry.PublisherEntry;
import org.xipki.ca.api.mgmt.entry.RequestorEntry;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.ca.api.mgmt.entry.UserEntry;
import org.xipki.ca.api.profile.CertprofileFactoryRegister;
import org.xipki.ca.api.publisher.CertPublisherFactoryRegister;
import org.xipki.ca.server.CaIdNameMap;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.CaServerConf;
import org.xipki.ca.server.CtLogPublicKeyFinder;
import org.xipki.ca.server.IdentifiedCertPublisher;
import org.xipki.ca.server.IdentifiedCertprofile;
import org.xipki.ca.server.RequestorEntryWrapper;
import org.xipki.ca.server.RestResponder;
import org.xipki.ca.server.ScepResponder;
import org.xipki.ca.server.SignerEntryWrapper;
import org.xipki.ca.server.UniqueIdGenerator;
import org.xipki.ca.server.X509Ca;
import org.xipki.ca.server.cmp.CmpResponder;
import org.xipki.ca.server.db.CaManagerQueryExecutor;
import org.xipki.ca.server.db.CertStore;
import org.xipki.ca.server.mgmt.Ca2Manager;
import org.xipki.ca.server.mgmt.CertprofileManager;
import org.xipki.ca.server.mgmt.ConfLoader;
import org.xipki.ca.server.mgmt.PublisherManager;
import org.xipki.ca.server.mgmt.RequestorManager;
import org.xipki.ca.server.mgmt.SignerManager;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceConf;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.license.api.CmLicense;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.security.SecurityFactory;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.util.Args;
import org.xipki.util.DateUtil;
import org.xipki.util.FileOrValue;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

public class CaManagerImpl
implements CaManager,
Closeable {
    private static final Logger LOG;
    private static final String version;
    private static final String EVENT_LOCK = "LOCK";
    private static final String EVENT_CACHAGNE = "CA_CHANGE";
    final CaIdNameMap idNameMap = new CaIdNameMap();
    final Map<String, CaInfo> caInfos = new ConcurrentHashMap<String, CaInfo>();
    final Map<String, SignerEntryWrapper> signers = new ConcurrentHashMap<String, SignerEntryWrapper>();
    final Map<String, SignerEntry> signerDbEntries = new ConcurrentHashMap<String, SignerEntry>();
    final Map<String, IdentifiedCertprofile> certprofiles = new ConcurrentHashMap<String, IdentifiedCertprofile>();
    final Map<String, CertprofileEntry> certprofileDbEntries = new ConcurrentHashMap<String, CertprofileEntry>();
    final Map<String, IdentifiedCertPublisher> publishers = new ConcurrentHashMap<String, IdentifiedCertPublisher>();
    final Map<String, PublisherEntry> publisherDbEntries = new ConcurrentHashMap<String, PublisherEntry>();
    final Map<String, RequestorEntryWrapper> requestors = new ConcurrentHashMap<String, RequestorEntryWrapper>();
    final Map<String, RequestorEntry> requestorDbEntries = new ConcurrentHashMap<String, RequestorEntry>();
    final Map<String, Set<String>> caHasProfiles = new ConcurrentHashMap<String, Set<String>>();
    final Map<String, Set<String>> caHasPublishers = new ConcurrentHashMap<String, Set<String>>();
    final Map<String, Set<CaHasRequestorEntry>> caHasRequestors = new ConcurrentHashMap<String, Set<CaHasRequestorEntry>>();
    final Map<String, Integer> caAliases = new ConcurrentHashMap<String, Integer>();
    final Map<String, CmpResponder> cmpResponders = new ConcurrentHashMap<String, CmpResponder>();
    final Map<String, ScepResponder> scepResponders = new ConcurrentHashMap<String, ScepResponder>();
    final Map<String, X509Ca> x509cas = new ConcurrentHashMap<String, X509Ca>();
    final RestResponder restResponder;
    RequestorInfo byCaRequestor;
    NameId byUserRequestorId;
    boolean masterMode;
    Map<String, FileOrValue> datasourceNameConfFileMap;
    CaServerConf caServerConf;
    CertprofileFactoryRegister certprofileFactoryRegister;
    CertPublisherFactoryRegister certPublisherFactoryRegister;
    CertStore certstore;
    SecurityFactory securityFactory;
    P11CryptServiceFactory p11CryptServiceFactory;
    CaManagerQueryExecutor queryExecutor;
    private CmLicense license;
    private DataSourceWrapper datasource;
    private final String lockInstanceId;
    private boolean caLockedByMe;
    private ScheduledThreadPoolExecutor persistentScheduledThreadPoolExecutor;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private final DataSourceFactory datasourceFactory;
    private CtLogPublicKeyFinder ctLogPublicKeyFinder;
    private boolean caSystemSetuped;
    private Date lastStartTime;
    private boolean initializing;
    private final Ca2Manager ca2Manager;
    private final CertprofileManager certprofileManager;
    private final ConfLoader confLoader;
    private final PublisherManager publisherManager;
    private final RequestorManager requestorManager;
    private final SignerManager signerManager;

    public CaManagerImpl(CmLicense license) {
        LOG.info("XiPKI CA version {}", (Object)version);
        this.license = (CmLicense)Args.notNull((Object)license, (String)"license");
        this.datasourceFactory = new DataSourceFactory();
        String calockId = null;
        File calockFile = new File("calock");
        if (calockFile.exists()) {
            try {
                calockId = StringUtil.toUtf8String((byte[])IoUtil.read((File)calockFile));
            }
            catch (IOException ex) {
                LOG.error("could not read {}: {}", (Object)calockFile.getName(), (Object)ex.getMessage());
            }
        }
        if (calockId == null) {
            calockId = UUID.randomUUID().toString();
            try {
                IoUtil.save((File)calockFile, (byte[])StringUtil.toUtf8Bytes((String)calockId));
            }
            catch (IOException ex) {
                LOG.error("could not save {}: {}", (Object)calockFile.getName(), (Object)ex.getMessage());
            }
        }
        String hostAddress = null;
        try {
            hostAddress = IoUtil.getHostAddress();
        }
        catch (SocketException ex) {
            LOG.warn("could not get host address: {}", (Object)ex.getMessage());
        }
        this.lockInstanceId = hostAddress == null ? calockId : hostAddress + "/" + calockId;
        this.restResponder = new RestResponder(this);
        this.ca2Manager = new Ca2Manager(this);
        this.certprofileManager = new CertprofileManager(this);
        this.confLoader = new ConfLoader(this);
        this.publisherManager = new PublisherManager(this);
        this.requestorManager = new RequestorManager(this);
        this.signerManager = new SignerManager(this);
    }

    public SecurityFactory getSecurityFactory() {
        return this.securityFactory;
    }

    public void setSecurityFactory(SecurityFactory securityFactory) {
        this.securityFactory = securityFactory;
    }

    public P11CryptServiceFactory getP11CryptServiceFactory() {
        return this.p11CryptServiceFactory;
    }

    public void setP11CryptServiceFactory(P11CryptServiceFactory p11CryptServiceFactory) {
        this.p11CryptServiceFactory = p11CryptServiceFactory;
    }

    public boolean isMasterMode() {
        return this.masterMode;
    }

    public Set<String> getSupportedSignerTypes() {
        return this.securityFactory.getSupportedSignerTypes();
    }

    public Set<String> getSupportedCertprofileTypes() {
        return this.certprofileFactoryRegister.getSupportedTypes();
    }

    public Set<String> getSupportedPublisherTypes() {
        return this.certPublisherFactoryRegister.getSupportedTypes();
    }

    public String getTokenInfoP11(String moduleName, Integer slotIndex, boolean verbose) throws CaMgmtException {
        return this.signerManager.getTokenInfoP11(moduleName, slotIndex, verbose);
    }

    private void init() throws CaMgmtException {
        if (this.securityFactory == null) {
            throw new IllegalStateException("securityFactory is not set");
        }
        if (this.datasourceFactory == null) {
            throw new IllegalStateException("datasourceFactory is not set");
        }
        if (this.certprofileFactoryRegister == null) {
            throw new IllegalStateException("certprofileFactoryRegister is not set");
        }
        if (this.certPublisherFactoryRegister == null) {
            throw new IllegalStateException("certPublisherFactoryRegister is not set");
        }
        if (this.caServerConf == null) {
            throw new IllegalStateException("caServerConf is not set");
        }
        this.masterMode = this.caServerConf.isMaster();
        LOG.info("ca.masterMode: {}", (Object)this.masterMode);
        int shardId = this.caServerConf.getShardId();
        LOG.info("ca.shardId: {}", (Object)shardId);
        if (this.caServerConf.getCtLog() != null) {
            try {
                this.ctLogPublicKeyFinder = new CtLogPublicKeyFinder(this.caServerConf.getCtLog());
            }
            catch (Exception ex) {
                throw new CaMgmtException("could not load CtLogPublicKeyFinder: " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (this.datasourceNameConfFileMap == null) {
            this.datasourceNameConfFileMap = new ConcurrentHashMap<String, FileOrValue>();
            List<DataSourceConf> datasourceList = this.caServerConf.getDatasources();
            for (DataSourceConf dataSourceConf : datasourceList) {
                String name = dataSourceConf.getName();
                FileOrValue conf = dataSourceConf.getConf();
                this.datasourceNameConfFileMap.put(name, conf);
                if (conf.getFile() != null) {
                    LOG.info("associate datasource {} to the file {}", (Object)name, (Object)conf.getFile());
                    continue;
                }
                LOG.info("associate datasource {} to text value", (Object)name);
            }
            FileOrValue caDatasourceConf = this.datasourceNameConfFileMap.remove("ca");
            if (caDatasourceConf == null) {
                throw new CaMgmtException("no datasource named 'ca' configured");
            }
            this.datasource = this.loadDatasource("ca", caDatasourceConf);
        }
        this.queryExecutor = new CaManagerQueryExecutor(this.datasource);
        if (this.masterMode) {
            String[] embeddedNames;
            this.lockCa(true);
            List names = this.queryExecutor.namesFromTable("REQUESTOR");
            for (String embeddedName : embeddedNames = new String[]{"by-ca", "by-user"}) {
                boolean contained = false;
                for (String name : names) {
                    if (!embeddedName.equalsIgnoreCase(name)) continue;
                    contained = true;
                    break;
                }
                if (contained) continue;
                this.queryExecutor.addEmbeddedRequestor(embeddedName);
            }
        }
        long epoch = DateUtil.parseUtcTimeyyyyMMdd((String)"20100101").getTime();
        UniqueIdGenerator uniqueIdGenerator = new UniqueIdGenerator(epoch, shardId);
        try {
            this.certstore = new CertStore(this.datasource, uniqueIdGenerator);
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
        this.ca2Manager.initCaAliases();
        this.certprofileManager.initCertprofiles();
        this.publisherManager.initPublishers();
        this.requestorManager.initRequestors();
        this.signerManager.initSigners();
        this.ca2Manager.initCas();
    }

    private DataSourceWrapper loadDatasource(String datasourceName, FileOrValue datasourceConf) throws CaMgmtException {
        try {
            DataSourceWrapper datasource = this.datasourceFactory.createDataSource(datasourceName, datasourceConf, this.securityFactory.getPasswordResolver());
            Connection conn = datasource.getConnection();
            datasource.returnConnection(conn);
            LOG.info("loaded datasource.{}", (Object)datasourceName);
            return datasource;
        }
        catch (IOException | RuntimeException | DataAccessException | PasswordResolverException ex) {
            throw new CaMgmtException(StringUtil.concat((String)ex.getClass().getName(), (String[])new String[]{" while parsing datasource ", datasourceName, ": ", ex.getMessage()}), ex);
        }
    }

    public CaSystemStatus getCaSystemStatus() {
        if (this.caSystemSetuped) {
            return this.masterMode ? CaSystemStatus.STARTED_AS_MASTER : CaSystemStatus.STARTED_AS_SLAVE;
        }
        if (this.initializing) {
            return CaSystemStatus.INITIALIZING;
        }
        if (!this.caLockedByMe) {
            return CaSystemStatus.LOCK_FAILED;
        }
        return CaSystemStatus.ERROR;
    }

    private void lockCa(boolean forceRelock) throws CaMgmtException {
        CertStore.SystemEvent lockInfo = this.queryExecutor.getSystemEvent(EVENT_LOCK);
        if (lockInfo != null) {
            String lockedBy = lockInfo.getOwner();
            Date lockedAt = new Date(lockInfo.getEventTime() * 1000L);
            if (!this.lockInstanceId.equals(lockedBy)) {
                String msg = StringUtil.concat((String)"could not lock CA, it has been locked by ", (String[])new String[]{lockedBy, " since ", lockedAt.toString(), ". In general this indicates that another CA software in active mode is accessing the database or the last shutdown of CA software in active mode is abnormal."});
                throw this.logAndCreateException(msg);
            }
            if (forceRelock) {
                LOG.info("CA has been locked by me since {}, re-lock it", (Object)lockedAt);
            }
        }
        CertStore.SystemEvent newLockInfo = new CertStore.SystemEvent(EVENT_LOCK, this.lockInstanceId, System.currentTimeMillis() / 1000L);
        this.queryExecutor.changeSystemEvent(newLockInfo);
        this.caLockedByMe = true;
    }

    public void unlockCa() throws CaMgmtException {
        if (!this.masterMode) {
            throw this.logAndCreateException("could not unlock CA in slave mode");
        }
        boolean succ = false;
        try {
            this.queryExecutor.unlockCa();
            LOG.info("unlocked CA");
            succ = true;
        }
        finally {
            CaManagerImpl.auditLogPciEvent(succ, "UNLOCK");
        }
    }

    private void reset() {
        this.caSystemSetuped = false;
        this.ctLogPublicKeyFinder = null;
        this.signerManager.reset();
        this.requestorManager.reset();
        this.ca2Manager.reset();
        this.certprofileManager.reset();
        this.publisherManager.reset();
        this.shutdownScheduledThreadPoolExecutor();
    }

    public void restartCa(String name) throws CaMgmtException {
        this.ca2Manager.restartCa(name);
    }

    public void restartCaSystem() throws CaMgmtException {
        this.reset();
        boolean caSystemStarted = this.startCaSystem0();
        CaManagerImpl.auditLogPciEvent(caSystemStarted, EVENT_CACHAGNE);
        if (!caSystemStarted) {
            throw this.logAndCreateException("could not restart CA system");
        }
    }

    public void notifyCaChange() throws CaMgmtException {
        try {
            CertStore.SystemEvent systemEvent = new CertStore.SystemEvent(EVENT_CACHAGNE, this.lockInstanceId, System.currentTimeMillis() / 1000L);
            this.queryExecutor.changeSystemEvent(systemEvent);
            LOG.info("notified the change of CA system");
        }
        catch (CaMgmtException ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex, (String)"could not notify slave CAs to restart");
            throw ex;
        }
    }

    public void startCaSystem() {
        boolean caSystemStarted = false;
        try {
            caSystemStarted = this.startCaSystem0();
        }
        catch (Throwable th) {
            LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not start CA system");
        }
        if (!caSystemStarted) {
            LOG.error("could not start CA system");
        }
        CaManagerImpl.auditLogPciEvent(caSystemStarted, "START");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startCaSystem0() {
        if (this.caSystemSetuped) {
            return true;
        }
        this.initializing = true;
        this.shutdownScheduledThreadPoolExecutor();
        try {
            String name;
            LOG.info("starting CA system");
            try {
                this.init();
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex);
                boolean bl = false;
                this.initializing = false;
                if (!this.masterMode && this.persistentScheduledThreadPoolExecutor == null) {
                    this.persistentScheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
                    this.persistentScheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
                    this.persistentScheduledThreadPoolExecutor.scheduleAtFixedRate(new CaRestarter(), 300L, 300L, TimeUnit.SECONDS);
                }
                return bl;
            }
            this.lastStartTime = new Date();
            this.x509cas.clear();
            this.cmpResponders.clear();
            this.scepResponders.clear();
            this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(10);
            this.scheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
            LinkedList<String> failedCaNames = new LinkedList<String>();
            for (Map.Entry<String, CaInfo> entry : this.caInfos.entrySet()) {
                String caName = entry.getKey();
                CaStatus status = entry.getValue().getCaEntry().getStatus();
                if (CaStatus.ACTIVE != status) continue;
                if (this.ca2Manager.startCa(caName)) {
                    LOG.info("started CA {}", (Object)caName);
                    continue;
                }
                failedCaNames.add(caName);
                LOG.error("could not start CA {}", (Object)caName);
            }
            this.caSystemSetuped = true;
            StringBuilder sb = new StringBuilder();
            sb.append("started CA system");
            Set<String> caAliasNames = this.getCaAliasNames();
            HashSet<String> names = new HashSet<String>(this.getCaNames());
            if (names.size() > 0) {
                sb.append(" with following CAs: ");
                for (String aliasName : caAliasNames) {
                    name = this.getCaNameForAlias(aliasName);
                    if (name == null) continue;
                    names.remove(name);
                    sb.append(name).append(" (alias ").append(aliasName).append("), ");
                }
                for (String name2 : names) {
                    sb.append(name2).append(", ");
                }
                int len = sb.length();
                sb.delete(len - 2, len);
                this.scheduledThreadPoolExecutor.scheduleAtFixedRate(new CertsInQueuePublisher(), 120L, 120L, TimeUnit.SECONDS);
                this.scheduledThreadPoolExecutor.scheduleAtFixedRate(new UnreferencedRequstCleaner(), 60L, 86400L, TimeUnit.SECONDS);
            } else {
                sb.append(": no CA is configured");
            }
            if (!failedCaNames.isEmpty()) {
                sb.append(", and following CAs could not be started: ");
                for (String aliasName : caAliasNames) {
                    name = this.getCaNameForAlias(aliasName);
                    if (!failedCaNames.remove(name)) continue;
                    sb.append(name).append(" (alias ").append(aliasName).append("), ");
                }
                for (String name2 : failedCaNames) {
                    sb.append(name2).append(", ");
                }
                int len = sb.length();
                sb.delete(len - 2, len);
            }
            LOG.info("{}", (Object)sb);
        }
        finally {
            this.initializing = false;
            if (!this.masterMode && this.persistentScheduledThreadPoolExecutor == null) {
                this.persistentScheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
                this.persistentScheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
                this.persistentScheduledThreadPoolExecutor.scheduleAtFixedRate(new CaRestarter(), 300L, 300L, TimeUnit.SECONDS);
            }
        }
        return true;
    }

    @Override
    public void close() {
        LOG.info("stopping CA system");
        this.shutdownScheduledThreadPoolExecutor();
        if (this.persistentScheduledThreadPoolExecutor != null) {
            this.persistentScheduledThreadPoolExecutor.shutdown();
            while (!this.persistentScheduledThreadPoolExecutor.isTerminated()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    LOG.error("interrupted: {}", (Object)ex.getMessage());
                }
            }
            this.persistentScheduledThreadPoolExecutor = null;
        }
        this.ca2Manager.close();
        if (this.caLockedByMe) {
            try {
                this.unlockCa();
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not unlock CA system");
            }
        }
        if (this.datasource != null) {
            try {
                this.datasource.close();
            }
            catch (Exception ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)StringUtil.concat((String)"could not close datasource ca", (String[])new String[0]));
            }
        }
        this.publisherManager.close();
        this.certprofileManager.close();
        File caLockFile = new File("calock");
        if (caLockFile.exists()) {
            caLockFile.delete();
        }
        CaManagerImpl.auditLogPciEvent(true, "SHUTDOWN");
        LOG.info("stopped CA system");
    }

    public CmpResponder getX509CaResponder(String name) {
        return this.cmpResponders.get(Args.toNonBlankLower((String)name, (String)"name"));
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return this.scheduledThreadPoolExecutor;
    }

    public Set<String> getCertprofileNames() {
        return this.certprofileDbEntries.keySet();
    }

    public Set<String> getPublisherNames() {
        return this.publisherDbEntries.keySet();
    }

    public Set<String> getRequestorNames() {
        return this.requestorDbEntries.keySet();
    }

    public Set<String> getSignerNames() {
        return this.signerDbEntries.keySet();
    }

    public Set<String> getCaNames() {
        return this.caInfos.keySet();
    }

    public Set<String> getSuccessfulCaNames() {
        return this.ca2Manager.getSuccessfulCaNames();
    }

    public Set<String> getFailedCaNames() {
        return this.ca2Manager.getFailedCaNames();
    }

    public Set<String> getInactiveCaNames() {
        return this.ca2Manager.getInactiveCaNames();
    }

    public void commitNextCrlNo(NameId ca, long nextCrlNo) throws OperationException {
        this.ca2Manager.commitNextCrlNo(ca, nextCrlNo);
    }

    public RequestorInfo.ByUserRequestorInfo createByUserRequestor(CaHasUserEntry caHasUser) throws OperationException {
        if (this.byUserRequestorId == null) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_UNAVAILABLE, "CA system has not been initialized yet");
        }
        return new RequestorInfo.ByUserRequestorInfo(this.byUserRequestorId, caHasUser);
    }

    public void addCa(CaEntry caEntry) throws CaMgmtException {
        this.ca2Manager.addCa(caEntry);
    }

    public CaEntry getCa(String name) {
        CaInfo caInfo = this.caInfos.get(Args.toNonBlankLower((String)name, (String)"name"));
        return caInfo == null ? null : caInfo.getCaEntry();
    }

    public void changeCa(ChangeCaEntry entry) throws CaMgmtException {
        this.ca2Manager.changeCa(entry);
    }

    public void removeCertprofileFromCa(String profileName, String caName) throws CaMgmtException {
        this.certprofileManager.removeCertprofileFromCa(profileName, caName);
    }

    public void addCertprofileToCa(String profileName, String caName) throws CaMgmtException {
        this.certprofileManager.addCertprofileToCa(profileName, caName);
    }

    public void removePublisherFromCa(String publisherName, String caName) throws CaMgmtException {
        this.publisherManager.removePublisherFromCa(publisherName, caName);
    }

    public void addPublisherToCa(String publisherName, String caName) throws CaMgmtException {
        this.publisherManager.addPublisherToCa(publisherName, caName);
    }

    public Set<String> getCertprofilesForCa(String caName) {
        return this.caHasProfiles.get(Args.toNonBlankLower((String)caName, (String)"caName"));
    }

    public Set<CaHasRequestorEntry> getRequestorsForCa(String caName) {
        return this.caHasRequestors.get(Args.toNonBlankLower((String)caName, (String)"caName"));
    }

    public RequestorEntry getRequestor(String name) {
        return this.requestorDbEntries.get(Args.toNonBlankLower((String)name, (String)"name"));
    }

    public RequestorEntryWrapper getRequestorWrapper(String name) {
        return this.requestors.get(Args.toNonBlankLower((String)name, (String)"name"));
    }

    public void addRequestor(RequestorEntry requestorEntry) throws CaMgmtException {
        this.requestorManager.addRequestor(requestorEntry);
    }

    public void removeRequestor(String name) throws CaMgmtException {
        this.requestorManager.removeRequestor(name);
    }

    public void changeRequestor(String name, String type, String conf) throws CaMgmtException {
        this.requestorManager.changeRequestor(name, type, conf);
    }

    public void removeRequestorFromCa(String requestorName, String caName) throws CaMgmtException {
        this.requestorManager.removeRequestorFromCa(requestorName, caName);
    }

    public void addRequestorToCa(CaHasRequestorEntry requestor, String caName) throws CaMgmtException {
        this.requestorManager.addRequestorToCa(requestor, caName);
    }

    public void removeUserFromCa(String userName, String caName) throws CaMgmtException {
        userName = Args.toNonBlankLower((String)userName, (String)"userName");
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        this.assertMasterModeAndSetuped();
        this.queryExecutor.removeUserFromCa(userName, caName);
    }

    public void addUserToCa(CaHasUserEntry user, String caName) throws CaMgmtException {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        this.assertMasterModeAndSetuped();
        X509Ca ca = this.getX509Ca(caName);
        if (ca == null) {
            throw this.logAndCreateException(StringUtil.concat((String)"unknown CA ", (String[])new String[]{caName}));
        }
        this.queryExecutor.addUserToCa(user, ca.getCaIdent());
    }

    public Map<String, CaHasUserEntry> getCaHasUsersForUser(String user) throws CaMgmtException {
        return this.queryExecutor.getCaHasUsersForUser(Args.notBlank((String)user, (String)"user"), this.idNameMap);
    }

    public CertprofileEntry getCertprofile(String name) {
        return this.certprofileDbEntries.get(name.toLowerCase());
    }

    public void removeCertprofile(String name) throws CaMgmtException {
        this.certprofileManager.removeCertprofile(name);
    }

    public void changeCertprofile(String name, String type, String conf) throws CaMgmtException {
        this.certprofileManager.changeCertprofile(name, type, conf);
    }

    public void addCertprofile(CertprofileEntry certprofileEntry) throws CaMgmtException {
        this.certprofileManager.addCertprofile(certprofileEntry);
    }

    public void addSigner(SignerEntry signerEntry) throws CaMgmtException {
        this.signerManager.addSigner(signerEntry);
    }

    public void removeSigner(String name) throws CaMgmtException {
        this.signerManager.removeSigner(name);
    }

    public void changeSigner(String name, String type, String conf, String base64Cert) throws CaMgmtException {
        this.signerManager.changeSigner(name, type, conf, base64Cert);
    }

    public SignerEntry getSigner(String name) {
        return this.signerDbEntries.get(Args.toNonBlankLower((String)name, (String)"name"));
    }

    public SignerEntryWrapper getSignerWrapper(String name) {
        return this.signers.get(Args.toNonBlankLower((String)name, (String)"name"));
    }

    public void addPublisher(PublisherEntry entry) throws CaMgmtException {
        this.publisherManager.addPublisher(entry);
    }

    public List<PublisherEntry> getPublishersForCa(String caName) {
        return this.publisherManager.getPublishersForCa(caName);
    }

    public PublisherEntry getPublisher(String name) {
        return this.publisherDbEntries.get(Args.toNonBlankLower((String)name, (String)"name"));
    }

    public void removePublisher(String name) throws CaMgmtException {
        this.publisherManager.removePublisher(name);
    }

    public void changePublisher(String name, String type, String conf) throws CaMgmtException {
        this.publisherManager.changePublisher(name, type, conf);
    }

    public CaServerConf getCaServerConf() {
        return this.caServerConf;
    }

    public void setCaServerConf(CaServerConf caServerConf) {
        this.caServerConf = (CaServerConf)((Object)Args.notNull((Object)((Object)caServerConf), (String)"caServerConf"));
    }

    public void addCaAlias(String aliasName, String caName) throws CaMgmtException {
        this.ca2Manager.addCaAlias(aliasName, caName);
    }

    public void removeCaAlias(String name) throws CaMgmtException {
        this.ca2Manager.removeCaAlias(name);
    }

    public String getCaNameForAlias(String aliasName) {
        return this.ca2Manager.getCaNameForAlias(aliasName);
    }

    public Set<String> getAliasesForCa(String caName) {
        return this.ca2Manager.getAliasesForCa(caName);
    }

    public Set<String> getCaAliasNames() {
        return this.caAliases.keySet();
    }

    public X509Cert getCaCert(String caName) {
        return this.ca2Manager.getCaCert(caName);
    }

    public List<X509Cert> getCaCertchain(String caName) {
        return this.ca2Manager.getCaCertchain(caName);
    }

    public void removeCa(String name) throws CaMgmtException {
        this.ca2Manager.removeCa(name);
    }

    public void republishCertificates(String caName, List<String> publisherNames, int numThreads) throws CaMgmtException {
        this.publisherManager.republishCertificates(caName, publisherNames, numThreads);
    }

    public void revokeCa(String caName, CertRevocationInfo revocationInfo) throws CaMgmtException {
        this.ca2Manager.revokeCa(caName, revocationInfo);
    }

    public void unrevokeCa(String caName) throws CaMgmtException {
        this.ca2Manager.unrevokeCa(caName);
    }

    public void setCertprofileFactoryRegister(CertprofileFactoryRegister register) {
        this.certprofileFactoryRegister = register;
    }

    public void setCertPublisherFactoryRegister(CertPublisherFactoryRegister register) {
        this.certPublisherFactoryRegister = register;
    }

    static void auditLogPciEvent(boolean successful, String eventType) {
        PciAuditEvent event = new PciAuditEvent(new Date());
        event.setUserId("CA-SYSTEM");
        event.setEventType(eventType);
        event.setAffectedResource("CORE");
        event.setStatus((successful ? AuditStatus.SUCCESSFUL : AuditStatus.FAILED).name());
        event.setLevel(successful ? AuditLevel.INFO : AuditLevel.ERROR);
        Audits.getAuditService().logEvent(event);
    }

    public void clearPublishQueue(String caName, List<String> publisherNames) throws CaMgmtException {
        this.ca2Manager.clearPublishQueue(caName, publisherNames);
    }

    private void shutdownScheduledThreadPoolExecutor() {
        if (this.scheduledThreadPoolExecutor == null) {
            return;
        }
        this.scheduledThreadPoolExecutor.shutdown();
        while (!this.scheduledThreadPoolExecutor.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                LOG.error("interrupted: {}", (Object)ex.getMessage());
            }
        }
        this.scheduledThreadPoolExecutor = null;
    }

    public void revokeCertificate(String caName, BigInteger serialNumber, CrlReason reason, Date invalidityTime) throws CaMgmtException {
        this.ca2Manager.revokeCertificate(caName, serialNumber, reason, invalidityTime);
    }

    public void unrevokeCertificate(String caName, BigInteger serialNumber) throws CaMgmtException {
        this.ca2Manager.unrevokeCertificate(caName, serialNumber);
    }

    public void removeCertificate(String caName, BigInteger serialNumber) throws CaMgmtException {
        this.ca2Manager.removeCertificate(caName, serialNumber);
    }

    public X509Cert generateCertificate(String caName, String profileName, byte[] encodedCsr, Date notBefore, Date notAfter) throws CaMgmtException {
        return this.ca2Manager.generateCertificate(caName, profileName, encodedCsr, notBefore, notAfter);
    }

    public X509Ca getX509Ca(String name) throws CaMgmtException {
        return this.ca2Manager.getX509Ca(name);
    }

    public X509Ca getX509Ca(NameId ident) throws CaMgmtException {
        return this.ca2Manager.getX509Ca(ident);
    }

    public IdentifiedCertprofile getIdentifiedCertprofile(String profileName) {
        profileName = Args.toNonBlankLower((String)profileName, (String)"profileName");
        return this.certprofiles.get(profileName);
    }

    public List<IdentifiedCertPublisher> getIdentifiedPublishersForCa(String caName) {
        return this.publisherManager.getIdentifiedPublishersForCa(caName);
    }

    public X509Cert generateRootCa(CaEntry caEntry, String profileName, String subject, String serialNumber) throws CaMgmtException {
        return this.ca2Manager.generateRootCa(caEntry, profileName, subject, serialNumber);
    }

    void assertMasterModeAndSetuped() throws CaMgmtException {
        if (!this.masterMode) {
            throw new CaMgmtException("operation not allowed in slave mode");
        }
        if (!this.caSystemSetuped) {
            throw new CaMgmtException("CA system is not initialized yet.");
        }
    }

    public SignerEntryWrapper createSigner(SignerEntry entry) throws CaMgmtException {
        return this.signerManager.createSigner(entry);
    }

    public IdentifiedCertprofile createCertprofile(CertprofileEntry entry) throws CaMgmtException {
        return this.certprofileManager.createCertprofile(entry);
    }

    public IdentifiedCertPublisher createPublisher(PublisherEntry entry) throws CaMgmtException {
        return this.publisherManager.createPublisher(entry);
    }

    public void addUser(AddUserEntry addUserEntry) throws CaMgmtException {
        this.assertMasterModeAndSetuped();
        this.queryExecutor.addUser(addUserEntry);
    }

    public void changeUser(ChangeUserEntry changeUserEntry) throws CaMgmtException {
        this.assertMasterModeAndSetuped();
        this.queryExecutor.changeUser(changeUserEntry);
    }

    public void removeUser(String username) throws CaMgmtException {
        username = Args.toNonBlankLower((String)username, (String)"username");
        this.assertMasterModeAndSetuped();
        if (!this.queryExecutor.deleteRowWithName(username, "TUSER")) {
            throw new CaMgmtException("unknown user " + username);
        }
    }

    public UserEntry getUser(String username) throws CaMgmtException {
        return this.queryExecutor.getUser(username.toLowerCase());
    }

    public CaIdNameMap idNameMap() {
        return this.idNameMap;
    }

    public X509CRLHolder generateCrlOnDemand(String caName) throws CaMgmtException {
        return this.ca2Manager.generateCrlOnDemand(caName);
    }

    public X509CRLHolder getCrl(String caName, BigInteger crlNumber) throws CaMgmtException {
        return this.ca2Manager.getCrl(caName, crlNumber);
    }

    public X509CRLHolder getCurrentCrl(String caName) throws CaMgmtException {
        return this.ca2Manager.getCurrentCrl(caName);
    }

    public ScepResponder getScepResponder(String name) {
        name = Args.toNonBlankLower((String)name, (String)"name");
        return this.scepResponders.get(name);
    }

    public CertWithRevocationInfo getCert(String caName, BigInteger serialNumber) throws CaMgmtException {
        return this.ca2Manager.getCert(caName, serialNumber);
    }

    public CertWithRevocationInfo getCert(X500Name issuer, BigInteger serialNumber) throws CaMgmtException {
        return this.ca2Manager.getCert(issuer, serialNumber);
    }

    public byte[] getCertRequest(String caName, BigInteger serialNumber) throws CaMgmtException {
        return this.ca2Manager.getCertRequest(caName, serialNumber);
    }

    public List<CertListInfo> listCertificates(String caName, X500Name subjectPattern, Date validFrom, Date validTo, CertListOrderBy orderBy, int numEntries) throws CaMgmtException {
        return this.ca2Manager.listCertificates(caName, subjectPattern, validFrom, validTo, orderBy, numEntries);
    }

    public void refreshTokenForSignerType(String signerType) throws CaMgmtException {
        try {
            this.securityFactory.refreshTokenForSignerType(signerType);
        }
        catch (XiSecurityException ex) {
            throw new CaMgmtException("could not refresh token for signer type " + signerType + ": " + ex.getMessage(), (Throwable)ex);
        }
    }

    public Map<String, X509Cert> loadConf(InputStream zippedConfStream) throws CaMgmtException {
        return this.confLoader.loadConf(zippedConfStream);
    }

    public InputStream exportConf(List<String> caNames) throws CaMgmtException, IOException {
        return this.confLoader.exportConf(caNames);
    }

    public CtLogPublicKeyFinder getCtLogPublicKeyFinder() {
        return this.ctLogPublicKeyFinder;
    }

    public RestResponder getRestResponder() {
        return this.restResponder;
    }

    public CmLicense getLicense() {
        return this.license;
    }

    CaMgmtException logAndCreateException(String msg) {
        LOG.error(msg);
        return new CaMgmtException(msg);
    }

    static {
        String ver;
        LOG = LoggerFactory.getLogger(CaManagerImpl.class);
        try {
            ver = StringUtil.toUtf8String((byte[])IoUtil.read((InputStream)CaManagerImpl.class.getResourceAsStream("/version"))).trim();
        }
        catch (Exception ex) {
            ver = "UNKNOWN";
        }
        version = ver;
    }

    private class CaRestarter
    implements Runnable {
        private boolean inProcess;

        private CaRestarter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.inProcess) {
                return;
            }
            this.inProcess = true;
            try {
                CertStore.SystemEvent event = CaManagerImpl.this.queryExecutor.getSystemEvent(CaManagerImpl.EVENT_CACHAGNE);
                long caChangedTime = event == null ? 0L : event.getEventTime();
                LOG.info("check the restart CA system event: changed at={}, lastStartTime={}", (Object)new Date(caChangedTime * 1000L), (Object)CaManagerImpl.this.lastStartTime);
                if (caChangedTime > CaManagerImpl.this.lastStartTime.getTime() / 1000L) {
                    LOG.info("received event to restart CA");
                    CaManagerImpl.this.restartCaSystem();
                } else {
                    LOG.debug("received no event to restart CA");
                }
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"ScheduledCaRestarter");
            }
            finally {
                this.inProcess = false;
            }
        }
    }

    private class UnreferencedRequstCleaner
    implements Runnable {
        private boolean inProcess;

        private UnreferencedRequstCleaner() {
        }

        @Override
        public void run() {
            if (this.inProcess) {
                return;
            }
            this.inProcess = true;
            try {
                try {
                    CaManagerImpl.this.certstore.deleteUnreferencedRequests();
                    LOG.info("deleted unreferenced requests");
                }
                catch (Throwable th) {
                    LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not delete unreferenced requests");
                }
            }
            finally {
                this.inProcess = false;
            }
        }
    }

    private class CertsInQueuePublisher
    implements Runnable {
        private boolean inProcess;

        private CertsInQueuePublisher() {
        }

        @Override
        public void run() {
            if (this.inProcess || !CaManagerImpl.this.caSystemSetuped) {
                return;
            }
            this.inProcess = true;
            try {
                CaManagerImpl.this.ca2Manager.pulishCertsInQueue();
            }
            finally {
                this.inProcess = false;
            }
        }
    }
}

