/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CertprofileValidator;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.entry.CertprofileEntry;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.server.IdentifiedCertprofile;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.util.Args;
import org.xipki.util.LogUtil;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.StringUtil;

class CertprofileManager {
    private static final Logger LOG = LoggerFactory.getLogger(CertprofileManager.class);
    private boolean certprofilesInitialized;
    private final CaManagerImpl manager;

    CertprofileManager(CaManagerImpl manager) {
        this.manager = (CaManagerImpl)Args.notNull((Object)manager, (String)"manager");
    }

    void reset() {
        this.certprofilesInitialized = false;
    }

    void close() {
        for (String name : this.manager.certprofiles.keySet()) {
            IdentifiedCertprofile certprofile = this.manager.certprofiles.get(name);
            this.shutdownCertprofile(certprofile);
        }
    }

    void initCertprofiles() throws CaMgmtException {
        if (this.certprofilesInitialized) {
            return;
        }
        for (String name : this.manager.certprofiles.keySet()) {
            this.shutdownCertprofile(this.manager.certprofiles.get(name));
        }
        this.manager.certprofileDbEntries.clear();
        this.manager.idNameMap.clearCertprofile();
        this.manager.certprofiles.clear();
        List names = this.manager.queryExecutor.namesFromTable("PROFILE");
        for (String name : names) {
            CertprofileEntry dbEntry = this.manager.queryExecutor.createCertprofile(name);
            this.manager.idNameMap.addCertprofile(dbEntry.getIdent());
            dbEntry.setFaulty(true);
            this.manager.certprofileDbEntries.put(name, dbEntry);
            IdentifiedCertprofile profile = this.createCertprofile(dbEntry);
            dbEntry.setFaulty(false);
            this.manager.certprofiles.put(name, profile);
            LOG.info("loaded certprofile {}", (Object)name);
        }
        this.certprofilesInitialized = true;
    }

    void removeCertprofileFromCa(String profileName, String caName) throws CaMgmtException {
        Set<String> set;
        this.manager.assertMasterModeAndSetuped();
        profileName = Args.toNonBlankLower((String)profileName, (String)"profileName");
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        this.manager.queryExecutor.removeCertprofileFromCa(profileName, caName);
        if (this.manager.caHasProfiles.containsKey(caName) && (set = this.manager.caHasProfiles.get(caName)) != null) {
            set.remove(profileName);
        }
    }

    void addCertprofileToCa(String profileName, String caName) throws CaMgmtException {
        this.manager.assertMasterModeAndSetuped();
        profileName = Args.toNonBlankLower((String)profileName, (String)"profileName");
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        NameId ident = this.manager.idNameMap.getCertprofile(profileName);
        if (ident == null) {
            throw this.manager.logAndCreateException(StringUtil.concat((String)"unknown Certprofile ", (String[])new String[]{profileName}));
        }
        NameId caIdent = this.manager.idNameMap.getCa(caName);
        if (caIdent == null) {
            throw this.manager.logAndCreateException(StringUtil.concat((String)"unknown CA ", (String[])new String[]{caName}));
        }
        Set<String> set = this.manager.caHasProfiles.get(caName);
        if (set == null) {
            set = new HashSet<String>();
            this.manager.caHasProfiles.put(caName, set);
        } else if (set.contains(profileName)) {
            throw this.manager.logAndCreateException(StringUtil.concat((String)"Certprofile ", (String[])new String[]{profileName, " already associated with CA ", caName}));
        }
        if (!this.manager.certprofiles.containsKey(profileName)) {
            throw new CaMgmtException(StringUtil.concat((String)"certprofile '", (String[])new String[]{profileName, "' is faulty"}));
        }
        this.manager.queryExecutor.addCertprofileToCa(ident, caIdent);
        set.add(profileName);
    }

    void removeCertprofile(String name) throws CaMgmtException {
        this.manager.assertMasterModeAndSetuped();
        name = Args.toNonBlankLower((String)name, (String)"name");
        for (String caName : this.manager.caHasProfiles.keySet()) {
            if (!this.manager.caHasProfiles.get(caName).contains(name)) continue;
            this.removeCertprofileFromCa(name, caName);
        }
        boolean bo = this.manager.queryExecutor.deleteRowWithName(name, "PROFILE");
        if (!bo) {
            throw new CaMgmtException("unknown profile " + name);
        }
        LOG.info("removed profile '{}'", (Object)name);
        this.manager.idNameMap.removeCertprofile(this.manager.certprofileDbEntries.get(name).getIdent().getId());
        this.manager.certprofileDbEntries.remove(name);
        IdentifiedCertprofile profile = this.manager.certprofiles.remove(name);
        this.shutdownCertprofile(profile);
    }

    void changeCertprofile(String name, String type, String conf) throws CaMgmtException {
        this.manager.assertMasterModeAndSetuped();
        name = Args.toNonBlankLower((String)name, (String)"name");
        if (type == null && conf == null) {
            throw new IllegalArgumentException("type and conf cannot be both null");
        }
        NameId ident = this.manager.idNameMap.getCertprofile(name);
        if (ident == null) {
            throw this.manager.logAndCreateException(StringUtil.concat((String)"unknown Certprofile ", (String[])new String[]{name}));
        }
        if (type != null) {
            type = type.toLowerCase();
        }
        IdentifiedCertprofile profile = this.manager.queryExecutor.changeCertprofile(ident, type, conf, this.manager);
        this.manager.certprofileDbEntries.remove(name);
        IdentifiedCertprofile oldProfile = this.manager.certprofiles.remove(name);
        this.manager.certprofileDbEntries.put(name, profile.getDbEntry());
        this.manager.certprofiles.put(name, profile);
        if (oldProfile != null) {
            this.shutdownCertprofile(oldProfile);
        }
    }

    void addCertprofile(CertprofileEntry certprofileEntry) throws CaMgmtException {
        this.manager.assertMasterModeAndSetuped();
        Args.notNull((Object)certprofileEntry, (String)"certprofileEntry");
        String name = certprofileEntry.getIdent().getName();
        if (this.manager.certprofileDbEntries.containsKey(name)) {
            throw new CaMgmtException(StringUtil.concat((String)"Certprofile named ", (String[])new String[]{name, " exists"}));
        }
        certprofileEntry.setFaulty(true);
        IdentifiedCertprofile profile = this.createCertprofile(certprofileEntry);
        if (profile == null) {
            throw new CaMgmtException("could not create Certprofile object");
        }
        certprofileEntry.setFaulty(false);
        this.manager.certprofiles.put(name, profile);
        this.manager.queryExecutor.addCertprofile(certprofileEntry);
        this.manager.idNameMap.addCertprofile(certprofileEntry.getIdent());
        this.manager.certprofileDbEntries.put(name, certprofileEntry);
    }

    void shutdownCertprofile(IdentifiedCertprofile profile) {
        if (profile == null) {
            return;
        }
        try {
            profile.close();
        }
        catch (Exception ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("could not shutdown Certprofile " + profile.getIdent()));
        }
    }

    IdentifiedCertprofile createCertprofile(CertprofileEntry entry) throws CaMgmtException {
        Args.notNull((Object)entry, (String)"entry");
        String type = entry.getType();
        if (!this.manager.certprofileFactoryRegister.canCreateProfile(type)) {
            throw new CaMgmtException("unsupported cert profile type " + type);
        }
        try {
            Certprofile profile = this.manager.certprofileFactoryRegister.newCertprofile(type);
            IdentifiedCertprofile identifiedCertprofile = new IdentifiedCertprofile(entry, profile);
            try {
                CertprofileValidator.validate((Certprofile)profile);
            }
            catch (CertprofileException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("validating certprofile " + entry.getIdent().getName() + " failed"));
            }
            return identifiedCertprofile;
        }
        catch (CertprofileException | ObjectCreationException ex) {
            String msg = "could not initialize Certprofile " + entry.getIdent();
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
            throw new CaMgmtException(msg, ex);
        }
    }
}

