/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.OperationException;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.entry.PublisherEntry;
import org.xipki.ca.api.publisher.CertPublisher;
import org.xipki.ca.api.publisher.CertPublisherException;
import org.xipki.ca.server.CaIdNameMap;
import org.xipki.ca.server.IdentifiedCertPublisher;
import org.xipki.ca.server.X509Ca;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.StringUtil;

class PublisherManager {
    private static final Logger LOG = LoggerFactory.getLogger(PublisherManager.class);
    private boolean publishersInitialized;
    private final CaManagerImpl manager;

    PublisherManager(CaManagerImpl manager) {
        this.manager = (CaManagerImpl)Args.notNull((Object)manager, (String)"manager");
    }

    void reset() {
        this.publishersInitialized = false;
    }

    void close() {
        Map<String, IdentifiedCertPublisher> publishers = this.manager.publishers;
        if (publishers != null) {
            for (Map.Entry<String, IdentifiedCertPublisher> entry : publishers.entrySet()) {
                IdentifiedCertPublisher publisher = entry.getValue();
                this.shutdownPublisher(publisher);
            }
        }
    }

    void initPublishers() throws CaMgmtException {
        if (this.publishersInitialized) {
            return;
        }
        Map<String, IdentifiedCertPublisher> publishers = this.manager.publishers;
        for (Map.Entry<String, IdentifiedCertPublisher> entry : publishers.entrySet()) {
            this.shutdownPublisher(entry.getValue());
        }
        publishers.clear();
        this.manager.publisherDbEntries.clear();
        this.manager.idNameMap.clearPublisher();
        List names = this.manager.queryExecutor.namesFromTable("PUBLISHER");
        for (String name : names) {
            PublisherEntry dbEntry = this.manager.queryExecutor.createPublisher(name);
            this.manager.idNameMap.addPublisher(dbEntry.getIdent());
            dbEntry.setFaulty(true);
            this.manager.publisherDbEntries.put(name, dbEntry);
            IdentifiedCertPublisher publisher = this.createPublisher(dbEntry);
            dbEntry.setFaulty(false);
            publishers.put(name, publisher);
            LOG.info("loaded publisher {}", (Object)name);
        }
        this.publishersInitialized = true;
    }

    void removePublisherFromCa(String publisherName, String caName) throws CaMgmtException {
        this.manager.assertMasterModeAndSetuped();
        publisherName = Args.toNonBlankLower((String)publisherName, (String)"publisherName");
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        this.manager.queryExecutor.removePublisherFromCa(publisherName, caName);
        Set<String> publisherNames = this.manager.caHasPublishers.get(caName);
        if (publisherNames != null) {
            publisherNames.remove(publisherName);
        }
    }

    void addPublisherToCa(String publisherName, String caName) throws CaMgmtException {
        this.manager.assertMasterModeAndSetuped();
        publisherName = Args.toNonBlankLower((String)publisherName, (String)"publisherName");
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        CaIdNameMap idNameMap = this.manager.idNameMap;
        NameId ident = idNameMap.getPublisher(publisherName);
        if (ident == null) {
            throw this.manager.logAndCreateException(StringUtil.concat((String)"unknown publisher ", (String[])new String[]{publisherName}));
        }
        NameId caIdent = idNameMap.getCa(caName);
        if (caIdent == null) {
            throw this.manager.logAndCreateException(StringUtil.concat((String)"unknown CA ", (String[])new String[]{caName}));
        }
        Set<String> publisherNames = this.manager.caHasPublishers.get(caName);
        if (publisherNames == null) {
            publisherNames = new HashSet<String>();
            this.manager.caHasPublishers.put(caName, publisherNames);
        } else if (publisherNames.contains(publisherName)) {
            String msg = StringUtil.concat((String)"publisher ", (String[])new String[]{publisherName, " already associated with CA ", caName});
            throw this.manager.logAndCreateException(msg);
        }
        IdentifiedCertPublisher publisher = this.manager.publishers.get(publisherName);
        if (publisher == null) {
            throw new CaMgmtException(StringUtil.concat((String)"publisher '", (String[])new String[]{publisherName, "' is faulty"}));
        }
        this.manager.queryExecutor.addPublisherToCa(idNameMap.getPublisher(publisherName), caIdent);
        publisherNames.add(publisherName);
        this.manager.caHasPublishers.get(caName).add(publisherName);
        publisher.caAdded(this.manager.caInfos.get(caName).getCert());
    }

    void addPublisher(PublisherEntry entry) throws CaMgmtException {
        this.manager.assertMasterModeAndSetuped();
        Args.notNull((Object)entry, (String)"entry");
        String name = entry.getIdent().getName();
        if (this.manager.publisherDbEntries.containsKey(name)) {
            throw new CaMgmtException(StringUtil.concat((String)"Publisher named ", (String[])new String[]{name, " exists"}));
        }
        entry.setFaulty(true);
        IdentifiedCertPublisher publisher = this.createPublisher(entry);
        entry.setFaulty(false);
        this.manager.queryExecutor.addPublisher(entry);
        this.manager.publishers.put(name, publisher);
        this.manager.idNameMap.addPublisher(entry.getIdent());
        this.manager.publisherDbEntries.put(name, entry);
    }

    List<PublisherEntry> getPublishersForCa(String caName) {
        Set<String> publisherNames = this.manager.caHasPublishers.get(caName = Args.toNonBlankLower((String)caName, (String)"caName"));
        if (publisherNames == null) {
            return Collections.emptyList();
        }
        ArrayList<PublisherEntry> ret = new ArrayList<PublisherEntry>(publisherNames.size());
        for (String publisherName : publisherNames) {
            ret.add(this.manager.publisherDbEntries.get(publisherName));
        }
        return ret;
    }

    PublisherEntry getPublisher(String name) {
        name = Args.toNonBlankLower((String)name, (String)"name");
        return this.manager.publisherDbEntries.get(name);
    }

    void removePublisher(String name) throws CaMgmtException {
        this.manager.assertMasterModeAndSetuped();
        name = Args.toNonBlankLower((String)name, (String)"name");
        for (String caName : this.manager.caHasPublishers.keySet()) {
            if (!this.manager.caHasPublishers.get(caName).contains(name)) continue;
            this.removePublisherFromCa(name, caName);
        }
        boolean bo = this.manager.queryExecutor.deleteRowWithName(name, "PUBLISHER");
        if (!bo) {
            throw new CaMgmtException("unknown publisher " + name);
        }
        LOG.info("removed publisher '{}'", (Object)name);
        this.manager.publisherDbEntries.remove(name);
        IdentifiedCertPublisher publisher = this.manager.publishers.remove(name);
        this.shutdownPublisher(publisher);
    }

    void changePublisher(String name, String type, String conf) throws CaMgmtException {
        this.manager.assertMasterModeAndSetuped();
        name = Args.toNonBlankLower((String)name, (String)"name");
        if (type == null && conf == null) {
            throw new IllegalArgumentException("nothing to change");
        }
        if (type != null) {
            type = type.toLowerCase();
        }
        IdentifiedCertPublisher publisher = this.manager.queryExecutor.changePublisher(name, type, conf, this.manager);
        IdentifiedCertPublisher oldPublisher = this.manager.publishers.remove(name);
        this.shutdownPublisher(oldPublisher);
        this.manager.publisherDbEntries.put(name, publisher.getDbEntry());
        this.manager.publishers.put(name, publisher);
    }

    void republishCertificates(String caName, List<String> publisherNames, int numThreads) throws CaMgmtException {
        this.manager.assertMasterModeAndSetuped();
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        Args.positive((int)numThreads, (String)"numThreads");
        X509Ca ca = this.manager.x509cas.get(caName);
        if (ca == null) {
            throw new CaMgmtException(StringUtil.concat((String)"could not find CA named ", (String[])new String[]{caName}));
        }
        if (!ca.republishCerts(publisherNames = CollectionUtil.toLowerCaseList(publisherNames), numThreads)) {
            throw new CaMgmtException(StringUtil.concat((String)"republishing certificates of CA ", (String[])new String[]{caName, " failed"}));
        }
    }

    void clearPublishQueue(String caName, List<String> publisherNames) throws CaMgmtException {
        publisherNames = CollectionUtil.toLowerCaseList(publisherNames);
        if (caName == null) {
            if (CollectionUtil.isNotEmpty((Collection)publisherNames)) {
                throw new IllegalArgumentException("non-empty publisherNames is not allowed");
            }
            try {
                this.manager.certstore.clearPublishQueue(null, null);
            }
            catch (OperationException ex) {
                throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
            }
            return;
        }
        X509Ca ca = this.manager.x509cas.get(caName = caName.toLowerCase());
        if (ca == null) {
            throw new CaMgmtException(StringUtil.concat((String)"could not find CA named ", (String[])new String[]{caName}));
        }
        ca.clearPublishQueue(publisherNames);
    }

    List<IdentifiedCertPublisher> getIdentifiedPublishersForCa(String caName) {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        LinkedList<IdentifiedCertPublisher> ret = new LinkedList<IdentifiedCertPublisher>();
        Set<String> publisherNames = this.manager.caHasPublishers.get(caName);
        if (publisherNames == null) {
            return ret;
        }
        for (String publisherName : publisherNames) {
            IdentifiedCertPublisher publisher = this.manager.publishers.get(publisherName);
            ret.add(publisher);
        }
        return ret;
    }

    void shutdownPublisher(IdentifiedCertPublisher publisher) {
        if (publisher == null) {
            return;
        }
        try {
            publisher.close();
        }
        catch (Exception ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("could not shutdown CertPublisher " + publisher.getIdent()));
        }
    }

    IdentifiedCertPublisher createPublisher(PublisherEntry entry) throws CaMgmtException {
        Args.notNull((Object)entry, (String)"entry");
        String type = entry.getType();
        try {
            if (!this.manager.certPublisherFactoryRegister.canCreatePublisher(type)) {
                throw new CaMgmtException("unsupported publisher type " + type);
            }
            CertPublisher publisher = this.manager.certPublisherFactoryRegister.newPublisher(type);
            IdentifiedCertPublisher ret = new IdentifiedCertPublisher(entry, publisher);
            ret.initialize(this.manager.securityFactory.getPasswordResolver(), this.manager.datasourceNameConfFileMap);
            return ret;
        }
        catch (RuntimeException | CertPublisherException | ObjectCreationException ex) {
            String msg = "invalid configuration for the publisher " + entry.getIdent();
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
            throw new CaMgmtException(msg, ex);
        }
    }
}

