/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.xipki.util.Args;

class RandomSerialNumberGenerator {
    private static int[] AND_MASKS = new int[]{255, 1, 3, 7, 15, 31, 63, 127};
    private static int[] OR_MASKS = new int[]{128, 1, 2, 4, 8, 16, 32, 64};
    private static RandomSerialNumberGenerator instance;
    private final SecureRandom random = new SecureRandom();

    private RandomSerialNumberGenerator() {
    }

    public BigInteger nextSerialNumber(int bitLen) {
        BigInteger bi;
        BigInteger threeBi;
        BigInteger diff;
        int nafWeight;
        Args.range((int)bitLen, (String)"bitlen", (int)71, (int)159);
        byte[] rdnBytes = new byte[(bitLen + 7) / 8];
        int ci = bitLen % 8;
        int minWeight = bitLen >>> 2;
        do {
            this.random.nextBytes(rdnBytes);
            if (ci != 0) {
                rdnBytes[0] = (byte)(rdnBytes[0] & AND_MASKS[ci]);
            }
            rdnBytes[0] = (byte)(rdnBytes[0] | OR_MASKS[ci]);
        } while ((nafWeight = (diff = (threeBi = (bi = new BigInteger(1, rdnBytes)).shiftLeft(1).add(bi)).xor(bi)).bitCount()) < minWeight);
        return bi;
    }

    public static synchronized RandomSerialNumberGenerator getInstance() {
        if (instance == null) {
            instance = new RandomSerialNumberGenerator();
        }
        return instance;
    }
}

