/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.BadCertTemplateException;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.OperationException;
import org.xipki.ca.api.PublicCaInfo;
import org.xipki.ca.api.mgmt.MgmtEntry;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.ExtensionValue;
import org.xipki.ca.api.profile.ExtensionValues;
import org.xipki.ca.server.IdentifiedCertprofile;
import org.xipki.security.ConcurrentBagEntrySigner;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.NoIdleSignerException;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.InvalidConfException;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.Validity;

class SelfSignedCertBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SelfSignedCertBuilder.class);

    private SelfSignedCertBuilder() {
    }

    public static GenerateSelfSignedResult generateSelfSigned(SecurityFactory securityFactory, String signerType, String signerConf, IdentifiedCertprofile certprofile, CertificationRequest csr, BigInteger serialNumber, CaUris caUris, ConfPairs extraControl) throws OperationException, InvalidConfException {
        ConcurrentContentSigner signer;
        ConfPairs keyValues;
        String keystoreConf;
        Args.notNull((Object)securityFactory, (String)"securityFactory");
        Args.notBlank((String)signerType, (String)"signerType");
        Args.notNull((Object)certprofile, (String)"certprofile");
        Args.notNull((Object)csr, (String)"csr");
        Args.notNull((Object)serialNumber, (String)"serialNumber");
        if (serialNumber.compareTo(BigInteger.ZERO) != 1) {
            throw new IllegalArgumentException("serialNumber may not be non-positive: " + serialNumber);
        }
        Certprofile.CertLevel level = certprofile.getCertLevel();
        if (Certprofile.CertLevel.RootCA != level) {
            throw new IllegalArgumentException("certprofile is not of level " + Certprofile.CertLevel.RootCA);
        }
        if (!securityFactory.verifyPopo(csr, null)) {
            throw new InvalidConfException("could not validate POP for the CSR");
        }
        if (("pkcs12".equalsIgnoreCase(signerType) || "jks".equalsIgnoreCase(signerType)) && (keystoreConf = (keyValues = new ConfPairs(signerConf)).value("keystore")) == null) {
            throw new InvalidConfException("required parameter 'keystore' for types PKCS12 and JKS, is not specified");
        }
        try {
            List signerConfs = MgmtEntry.Ca.splitCaSignerConfs((String)signerConf);
            List<String> restrictedSigAlgos = certprofile.getSignatureAlgorithms();
            String thisSignerConf = null;
            if (CollectionUtil.isEmpty(restrictedSigAlgos)) {
                thisSignerConf = ((String[])signerConfs.get(0))[1];
            } else {
                for (String algo : restrictedSigAlgos) {
                    for (String[] m : signerConfs) {
                        if (!m[0].equals(algo)) continue;
                        thisSignerConf = m[1];
                        break;
                    }
                    if (thisSignerConf == null) continue;
                    break;
                }
            }
            if (thisSignerConf == null) {
                throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "CA does not support any signature algorithm restricted by the cert profile");
            }
            signer = securityFactory.createSigner(signerType, new SignerConf(thisSignerConf), (X509Certificate[])null);
        }
        catch (XiSecurityException | ObjectCreationException ex) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, ex);
        }
        X509Certificate newCert = SelfSignedCertBuilder.generateCertificate(signer, certprofile, csr, serialNumber, caUris, extraControl);
        return new GenerateSelfSignedResult(signerConf, newCert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate generateCertificate(ConcurrentContentSigner signer, IdentifiedCertprofile certprofile, CertificationRequest csr, BigInteger serialNumber, CaUris caUris, ConfPairs extraControl) throws OperationException {
        Validity validity;
        Certprofile.SubjectInfo subjectInfo;
        PublicKey csrPublicKey;
        SubjectPublicKeyInfo publicKeyInfo;
        try {
            publicKeyInfo = X509Util.toRfc3279Style((SubjectPublicKeyInfo)csr.getCertificationRequestInfo().getSubjectPublicKeyInfo());
        }
        catch (InvalidKeySpecException ex) {
            LOG.warn("SecurityUtil.toRfc3279Style", (Throwable)ex);
            throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, (Throwable)ex);
        }
        PublicKey signerPublicKey = signer.getPublicKey();
        try {
            csrPublicKey = KeyUtil.generatePublicKey((SubjectPublicKeyInfo)publicKeyInfo);
        }
        catch (InvalidKeySpecException ex) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, ex.getMessage());
        }
        if (!signerPublicKey.equals(csrPublicKey)) {
            throw new OperationException(OperationException.ErrorCode.BAD_REQUEST, "Public keys of the signer's token and of CSR are different");
        }
        try {
            certprofile.checkPublicKey(publicKeyInfo);
        }
        catch (CertprofileException ex) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "exception in cert profile " + certprofile.getIdent());
        }
        catch (BadCertTemplateException ex) {
            LOG.warn("certprofile.checkPublicKey", (Throwable)ex);
            throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, (Throwable)ex);
        }
        X500Name requestedSubject = csr.getCertificationRequestInfo().getSubject();
        try {
            subjectInfo = certprofile.getSubject(requestedSubject);
        }
        catch (CertprofileException ex) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, "exception in cert profile " + certprofile.getIdent());
        }
        catch (BadCertTemplateException ex) {
            LOG.warn("certprofile.getSubject", (Throwable)ex);
            throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, (Throwable)ex);
        }
        Date notBefore = certprofile.getNotBefore(null);
        if (notBefore == null) {
            notBefore = new Date();
        }
        if ((validity = certprofile.getValidity()) == null) {
            throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, "no validity specified in the profile " + certprofile.getIdent());
        }
        Date notAfter = validity.add(notBefore);
        X500Name grantedSubject = subjectInfo.getGrantedSubject();
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(grantedSubject, serialNumber, notBefore, notAfter, grantedSubject, publicKeyInfo);
        PublicCaInfo publicCaInfo = new PublicCaInfo(grantedSubject, serialNumber, null, null, caUris, extraControl);
        Extensions extensions = null;
        ASN1Set attrs = csr.getCertificationRequestInfo().getAttributes();
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute attr = Attribute.getInstance((Object)attrs.getObjectAt(i));
            if (!PKCSObjectIdentifiers.pkcs_9_at_extensionRequest.equals((Object)attr.getAttrType())) continue;
            extensions = Extensions.getInstance((Object)attr.getAttributeValues()[0]);
        }
        try {
            X509CertificateHolder certHolder;
            SelfSignedCertBuilder.addExtensions(certBuilder, certprofile, requestedSubject, grantedSubject, extensions, publicKeyInfo, publicCaInfo, notBefore, notAfter);
            ConcurrentBagEntrySigner signer0 = signer.borrowSigner();
            try {
                certHolder = certBuilder.build((ContentSigner)signer0.value());
            }
            finally {
                signer.requiteSigner(signer0);
            }
            Certificate bcCert = certHolder.toASN1Structure();
            return X509Util.parseCert((byte[])bcCert.getEncoded());
        }
        catch (BadCertTemplateException ex) {
            throw new OperationException(OperationException.ErrorCode.BAD_CERT_TEMPLATE, (Throwable)ex);
        }
        catch (IOException | CertificateException | CertprofileException | NoIdleSignerException ex) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, ex);
        }
    }

    private static void addExtensions(X509v3CertificateBuilder certBuilder, IdentifiedCertprofile profile, X500Name requestedSubject, X500Name grantedSubject, Extensions extensions, SubjectPublicKeyInfo requestedPublicKeyInfo, PublicCaInfo publicCaInfo, Date notBefore, Date notAfter) throws CertprofileException, IOException, BadCertTemplateException {
        ExtensionValues extensionTuples = profile.getExtensions(requestedSubject, grantedSubject, extensions, requestedPublicKeyInfo, publicCaInfo, null, notBefore, notAfter);
        if (extensionTuples == null) {
            return;
        }
        for (ASN1ObjectIdentifier extType : extensionTuples.getExtensionTypes()) {
            ExtensionValue extValue = extensionTuples.getExtensionValue(extType);
            certBuilder.addExtension(extType, extValue.isCritical(), extValue.getValue());
        }
    }

    static class GenerateSelfSignedResult {
        private final String signerConf;
        private final X509Certificate cert;

        GenerateSelfSignedResult(String signerConf, X509Certificate cert) {
            this.signerConf = signerConf;
            this.cert = cert;
        }

        String getSignerConf() {
            return this.signerConf;
        }

        X509Certificate getCert() {
            return this.cert;
        }
    }
}

