/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.SocketException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditStatus;
import org.xipki.audit.Audits;
import org.xipki.audit.PciAuditEvent;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.OperationException;
import org.xipki.ca.api.RequestType;
import org.xipki.ca.api.mgmt.CaConf;
import org.xipki.ca.api.mgmt.CaConfType;
import org.xipki.ca.api.mgmt.CaManager;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CaSystemStatus;
import org.xipki.ca.api.mgmt.CertListInfo;
import org.xipki.ca.api.mgmt.CertListOrderBy;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.api.mgmt.CtlogControl;
import org.xipki.ca.api.mgmt.MgmtEntry;
import org.xipki.ca.api.mgmt.PermissionConstants;
import org.xipki.ca.api.mgmt.RequestorInfo;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.CertprofileFactoryRegister;
import org.xipki.ca.api.publisher.CertPublisher;
import org.xipki.ca.api.publisher.CertPublisherException;
import org.xipki.ca.api.publisher.CertPublisherFactoryRegister;
import org.xipki.ca.server.CaIdNameMap;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.CaManagerQueryExecutor;
import org.xipki.ca.server.CaServerConf;
import org.xipki.ca.server.CertStore;
import org.xipki.ca.server.CertTemplateData;
import org.xipki.ca.server.CtLogClient;
import org.xipki.ca.server.CtLogPublicKeyFinder;
import org.xipki.ca.server.IdentifiedCertPublisher;
import org.xipki.ca.server.IdentifiedCertprofile;
import org.xipki.ca.server.PasswordHash;
import org.xipki.ca.server.RandomSerialNumberGenerator;
import org.xipki.ca.server.RequestorEntryWrapper;
import org.xipki.ca.server.RestResponder;
import org.xipki.ca.server.ScepResponder;
import org.xipki.ca.server.SelfSignedCertBuilder;
import org.xipki.ca.server.SignerEntryWrapper;
import org.xipki.ca.server.UniqueIdGenerator;
import org.xipki.ca.server.X509Ca;
import org.xipki.ca.server.cmp.CmpResponder;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceConf;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.CrlReason;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.DateUtil;
import org.xipki.util.FileOrBinary;
import org.xipki.util.FileOrValue;
import org.xipki.util.InvalidConfException;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.StringUtil;
import org.xipki.util.http.SslContextConf;

public class CaManagerImpl
implements CaManager,
Closeable {
    private static final Logger LOG;
    private static final String version;
    private static final String EVENT_LOCK = "LOCK";
    private static final String EVENT_CACHAGNE = "CA_CHANGE";
    private final String lockInstanceId;
    private final CaIdNameMap idNameMap = new CaIdNameMap();
    private RequestorInfo byCaRequestor;
    private NameId byUserRequestorId;
    private boolean caLockedByMe;
    private boolean masterMode;
    private Map<String, FileOrValue> datasourceNameConfFileMap;
    private final Map<String, CaInfo> caInfos = new ConcurrentHashMap<String, CaInfo>();
    private Map<String, SignerEntryWrapper> signers = new ConcurrentHashMap<String, SignerEntryWrapper>();
    private Map<String, MgmtEntry.Signer> signerDbEntries = new ConcurrentHashMap<String, MgmtEntry.Signer>();
    private final Map<String, IdentifiedCertprofile> certprofiles = new ConcurrentHashMap<String, IdentifiedCertprofile>();
    private final Map<String, MgmtEntry.Certprofile> certprofileDbEntries = new ConcurrentHashMap<String, MgmtEntry.Certprofile>();
    private final Map<String, IdentifiedCertPublisher> publishers = new ConcurrentHashMap<String, IdentifiedCertPublisher>();
    private final Map<String, MgmtEntry.Publisher> publisherDbEntries = new ConcurrentHashMap<String, MgmtEntry.Publisher>();
    private final Map<String, RequestorEntryWrapper> requestors = new ConcurrentHashMap<String, RequestorEntryWrapper>();
    private final Map<String, MgmtEntry.Requestor> requestorDbEntries = new ConcurrentHashMap<String, MgmtEntry.Requestor>();
    private final Map<String, Set<String>> caHasProfiles = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Set<String>> caHasPublishers = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Set<MgmtEntry.CaHasRequestor>> caHasRequestors = new ConcurrentHashMap<String, Set<MgmtEntry.CaHasRequestor>>();
    private final Map<String, Integer> caAliases = new ConcurrentHashMap<String, Integer>();
    private ScheduledThreadPoolExecutor persistentScheduledThreadPoolExecutor;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private final Map<String, CmpResponder> cmpResponders = new ConcurrentHashMap<String, CmpResponder>();
    private final Map<String, ScepResponder> scepResponders = new ConcurrentHashMap<String, ScepResponder>();
    private final Map<String, X509Ca> x509cas = new ConcurrentHashMap<String, X509Ca>();
    private final DataSourceFactory datasourceFactory;
    private final RestResponder restResponder;
    private CtLogPublicKeyFinder ctLogPublicKeyFinder;
    private CaServerConf caServerConf;
    private boolean caSystemSetuped;
    private boolean signerInitialized;
    private boolean requestorsInitialized;
    private boolean caAliasesInitialized;
    private boolean certprofilesInitialized;
    private boolean publishersInitialized;
    private boolean casInitialized;
    private Date lastStartTime;
    private CertprofileFactoryRegister certprofileFactoryRegister;
    private CertPublisherFactoryRegister certPublisherFactoryRegister;
    private DataSourceWrapper datasource;
    private CertStore certstore;
    private SecurityFactory securityFactory;
    private CaManagerQueryExecutor queryExecutor;
    private boolean initializing;

    public CaManagerImpl() {
        LOG.info("XiPKI CA version {}", (Object)version);
        this.datasourceFactory = new DataSourceFactory();
        String calockId = null;
        File caLockFile = new File("calock");
        if (caLockFile.exists()) {
            try {
                calockId = new String(IoUtil.read((File)caLockFile));
            }
            catch (IOException ex) {
                LOG.error("could not read {}: {}", (Object)caLockFile.getName(), (Object)ex.getMessage());
            }
        }
        if (calockId == null) {
            calockId = UUID.randomUUID().toString();
            try {
                IoUtil.save((File)caLockFile, (byte[])StringUtil.toUtf8Bytes((String)calockId));
            }
            catch (IOException ex) {
                LOG.error("could not save {}: {}", (Object)caLockFile.getName(), (Object)ex.getMessage());
            }
        }
        String hostAddress = null;
        try {
            hostAddress = IoUtil.getHostAddress();
        }
        catch (SocketException ex) {
            LOG.warn("could not get host address: {}", (Object)ex.getMessage());
        }
        this.lockInstanceId = hostAddress == null ? calockId : hostAddress + "/" + calockId;
        this.restResponder = new RestResponder(this);
    }

    public SecurityFactory getSecurityFactory() {
        return this.securityFactory;
    }

    public void setSecurityFactory(SecurityFactory securityFactory) {
        this.securityFactory = securityFactory;
    }

    public DataSourceFactory getDataSourceFactory() {
        return this.datasourceFactory;
    }

    public boolean isMasterMode() {
        return this.masterMode;
    }

    public Set<String> getSupportedSignerTypes() {
        return this.securityFactory.getSupportedSignerTypes();
    }

    public Set<String> getSupportedCertprofileTypes() {
        return this.certprofileFactoryRegister.getSupportedTypes();
    }

    public Set<String> getSupportedPublisherTypes() {
        return this.certPublisherFactoryRegister.getSupportedTypes();
    }

    private void init() throws CaMgmtException {
        if (this.securityFactory == null) {
            throw new IllegalStateException("securityFactory is not set");
        }
        if (this.datasourceFactory == null) {
            throw new IllegalStateException("datasourceFactory is not set");
        }
        if (this.certprofileFactoryRegister == null) {
            throw new IllegalStateException("certprofileFactoryRegister is not set");
        }
        if (this.certPublisherFactoryRegister == null) {
            throw new IllegalStateException("certPublisherFactoryRegister is not set");
        }
        if (this.caServerConf == null) {
            throw new IllegalStateException("caServerConf is not set");
        }
        this.masterMode = this.caServerConf.isMaster();
        LOG.info("ca.masterMode: {}", (Object)this.masterMode);
        int shardId = this.caServerConf.getShardId();
        LOG.info("ca.shardId: {}", (Object)shardId);
        if (this.caServerConf.getCtLog() != null) {
            try {
                this.ctLogPublicKeyFinder = new CtLogPublicKeyFinder(this.caServerConf.getCtLog());
            }
            catch (Exception ex) {
                throw new CaMgmtException("could not load CtLogPublicKeyFinder: " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (this.datasourceNameConfFileMap == null) {
            this.datasourceNameConfFileMap = new ConcurrentHashMap<String, FileOrValue>();
            List<DataSourceConf> datasourceList = this.caServerConf.getDatasources();
            for (DataSourceConf datasource : datasourceList) {
                this.datasourceNameConfFileMap.put(datasource.getName(), datasource.getConf());
            }
            FileOrValue caDatasourceConf = this.datasourceNameConfFileMap.remove("ca");
            if (caDatasourceConf == null) {
                throw new CaMgmtException("no datasource named 'ca' configured");
            }
            this.datasource = this.loadDatasource("ca", caDatasourceConf);
        }
        this.queryExecutor = new CaManagerQueryExecutor(this.datasource);
        if (this.masterMode) {
            this.lockCa(true);
            this.queryExecutor.addRequestorIfNeeded("by-ca");
            this.queryExecutor.addRequestorIfNeeded("by-user");
        }
        long epoch = DateUtil.parseUtcTimeyyyyMMdd((String)"20100101").getTime();
        UniqueIdGenerator idGen = new UniqueIdGenerator(epoch, shardId);
        try {
            this.certstore = new CertStore(this.datasource, idGen);
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
        this.initCaAliases();
        this.initCertprofiles();
        this.initPublishers();
        this.initRequestors();
        this.initSigners();
        this.initCas();
    }

    private DataSourceWrapper loadDatasource(String datasourceName, FileOrValue datasourceConf) throws CaMgmtException {
        try {
            DataSourceWrapper datasource = this.datasourceFactory.createDataSource(datasourceName, datasourceConf, this.securityFactory.getPasswordResolver());
            Connection conn = datasource.getConnection();
            datasource.returnConnection(conn);
            LOG.info("loaded datasource.{}", (Object)datasourceName);
            return datasource;
        }
        catch (IOException | RuntimeException | DataAccessException | PasswordResolverException ex) {
            throw new CaMgmtException(CaManagerImpl.concat(ex.getClass().getName(), " while parsing datasource ", datasourceName, ": ", ex.getMessage()), ex);
        }
    }

    public CaSystemStatus getCaSystemStatus() {
        if (this.caSystemSetuped) {
            return this.masterMode ? CaSystemStatus.STARTED_AS_MASTER : CaSystemStatus.STARTED_AS_SLAVE;
        }
        if (this.initializing) {
            return CaSystemStatus.INITIALIZING;
        }
        if (!this.caLockedByMe) {
            return CaSystemStatus.LOCK_FAILED;
        }
        return CaSystemStatus.ERROR;
    }

    private void lockCa(boolean forceRelock) throws CaMgmtException {
        CaManagerQueryExecutor.SystemEvent lockInfo = this.queryExecutor.getSystemEvent(EVENT_LOCK);
        if (lockInfo != null) {
            String lockedBy = lockInfo.getOwner();
            Date lockedAt = new Date(lockInfo.getEventTime() * 1000L);
            if (!this.lockInstanceId.equals(lockedBy)) {
                String msg = CaManagerImpl.concat("could not lock CA, it has been locked by ", lockedBy, " since ", lockedAt.toString(), ". In general this indicates that another CA software in active mode is accessing the database or the last shutdown of CA software in active mode is abnormal.");
                throw CaManagerImpl.logAndCreateException(msg);
            }
            if (forceRelock) {
                LOG.info("CA has been locked by me since {}, re-lock it", (Object)lockedAt);
            }
        }
        CaManagerQueryExecutor.SystemEvent newLockInfo = new CaManagerQueryExecutor.SystemEvent(EVENT_LOCK, this.lockInstanceId, System.currentTimeMillis() / 1000L);
        this.queryExecutor.changeSystemEvent(newLockInfo);
        this.caLockedByMe = true;
    }

    public void unlockCa() throws CaMgmtException {
        if (!this.masterMode) {
            throw CaManagerImpl.logAndCreateException("could not unlock CA in slave mode");
        }
        boolean succ = false;
        try {
            this.queryExecutor.unlockCa();
            LOG.info("unlocked CA");
            succ = true;
        }
        finally {
            this.auditLogPciEvent(succ, "UNLOCK");
        }
    }

    private void reset() {
        this.caSystemSetuped = false;
        this.signerInitialized = false;
        this.requestorsInitialized = false;
        this.caAliasesInitialized = false;
        this.certprofilesInitialized = false;
        this.publishersInitialized = false;
        this.casInitialized = false;
        this.ctLogPublicKeyFinder = null;
        this.shutdownScheduledThreadPoolExecutor();
    }

    public void restartCa(String name) throws CaMgmtException {
        name = Args.toNonBlankLower((String)name, (String)"name");
        this.assertMasterModeAndSetuped();
        NameId ident = this.idNameMap.getCa(name);
        if (ident == null) {
            throw new CaMgmtException("Unknown CA " + name);
        }
        if (this.createCa(name)) {
            CaInfo caInfo = this.caInfos.get(name);
            if (CaStatus.ACTIVE != caInfo.getCaEntry().getStatus()) {
                return;
            }
            if (this.startCa(name)) {
                LOG.info("started CA {}", (Object)name);
            } else {
                LOG.error("could not start CA {}", (Object)name);
            }
        } else {
            LOG.error("could not create CA {}", (Object)name);
        }
    }

    public void restartCaSystem() throws CaMgmtException {
        this.reset();
        boolean caSystemStarted = this.startCaSystem0();
        this.auditLogPciEvent(caSystemStarted, EVENT_CACHAGNE);
        if (!caSystemStarted) {
            throw CaManagerImpl.logAndCreateException("could not restart CA system");
        }
    }

    public void notifyCaChange() throws CaMgmtException {
        try {
            CaManagerQueryExecutor.SystemEvent systemEvent = new CaManagerQueryExecutor.SystemEvent(EVENT_CACHAGNE, this.lockInstanceId, System.currentTimeMillis() / 1000L);
            this.queryExecutor.changeSystemEvent(systemEvent);
            LOG.info("notified the change of CA system");
        }
        catch (CaMgmtException ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex, (String)"could not notify slave CAs to restart");
            throw ex;
        }
    }

    public void startCaSystem() {
        boolean caSystemStarted = false;
        try {
            caSystemStarted = this.startCaSystem0();
        }
        catch (Throwable th) {
            LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not start CA system");
        }
        if (!caSystemStarted) {
            LOG.error("could not start CA system");
        }
        this.auditLogPciEvent(caSystemStarted, "START");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startCaSystem0() {
        if (this.caSystemSetuped) {
            return true;
        }
        this.initializing = true;
        this.shutdownScheduledThreadPoolExecutor();
        try {
            String name;
            LOG.info("starting CA system");
            try {
                this.init();
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex);
                boolean bl = false;
                this.initializing = false;
                if (!this.masterMode && this.persistentScheduledThreadPoolExecutor == null) {
                    this.persistentScheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
                    this.persistentScheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
                    this.persistentScheduledThreadPoolExecutor.scheduleAtFixedRate(new CaRestarter(), 300L, 300L, TimeUnit.SECONDS);
                }
                return bl;
            }
            this.lastStartTime = new Date();
            this.x509cas.clear();
            this.cmpResponders.clear();
            this.scepResponders.clear();
            this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(10);
            this.scheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
            LinkedList<String> startedCaNames = new LinkedList<String>();
            LinkedList<String> failedCaNames = new LinkedList<String>();
            for (String caName : this.caInfos.keySet()) {
                CaStatus status = this.caInfos.get(caName).getCaEntry().getStatus();
                if (CaStatus.ACTIVE != status) continue;
                if (this.startCa(caName)) {
                    startedCaNames.add(caName);
                    LOG.info("started CA {}", (Object)caName);
                    continue;
                }
                failedCaNames.add(caName);
                LOG.error("could not start CA {}", (Object)caName);
            }
            this.caSystemSetuped = true;
            StringBuilder sb = new StringBuilder();
            sb.append("started CA system");
            Set<String> caAliasNames = this.getCaAliasNames();
            HashSet<String> names = new HashSet<String>(this.getCaNames());
            if (names.size() > 0) {
                sb.append(" with following CAs: ");
                for (String aliasName : caAliasNames) {
                    name = this.getCaNameForAlias(aliasName);
                    names.remove(name);
                    if (name == null) continue;
                    sb.append(name).append(" (alias ").append(aliasName).append("), ");
                }
                for (String name2 : names) {
                    sb.append(name2).append(", ");
                }
                int len = sb.length();
                sb.delete(len - 2, len);
                this.scheduledThreadPoolExecutor.scheduleAtFixedRate(new CertsInQueuePublisher(), 120L, 120L, TimeUnit.SECONDS);
                this.scheduledThreadPoolExecutor.scheduleAtFixedRate(new UnreferencedRequstCleaner(), 60L, 86400L, TimeUnit.SECONDS);
            } else {
                sb.append(": no CA is configured");
            }
            if (!failedCaNames.isEmpty()) {
                sb.append(", and following CAs could not be started: ");
                for (String aliasName : caAliasNames) {
                    name = this.getCaNameForAlias(aliasName);
                    if (!failedCaNames.remove(name)) continue;
                    sb.append(name).append(" (alias ").append(aliasName).append("), ");
                }
                for (String name2 : failedCaNames) {
                    sb.append(name2).append(", ");
                }
                int len = sb.length();
                sb.delete(len - 2, len);
            }
            LOG.info("{}", (Object)sb);
        }
        finally {
            this.initializing = false;
            if (!this.masterMode && this.persistentScheduledThreadPoolExecutor == null) {
                this.persistentScheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
                this.persistentScheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
                this.persistentScheduledThreadPoolExecutor.scheduleAtFixedRate(new CaRestarter(), 300L, 300L, TimeUnit.SECONDS);
            }
        }
        return true;
    }

    private boolean startCa(String caName) {
        CmpResponder caResponder;
        X509Ca ca;
        CaInfo caEntry = this.caInfos.get(caName);
        CtlogControl ctlogControl = caEntry.getCaEntry().getCtlogControl();
        CtLogClient ctlogClient = null;
        if (ctlogControl != null && ctlogControl.isEnabled()) {
            SslContextConf ctxConf;
            String name = ctlogControl.getSslContextName();
            if (name == null) {
                ctxConf = null;
            } else {
                ctxConf = this.caServerConf.getSslContextConf(name);
                if (ctxConf == null) {
                    LOG.error(CaManagerImpl.concat("getSslContextConf (ca=", caName, "): found no SslContext named " + name));
                    return false;
                }
                try {
                    ctxConf.getSslContext();
                }
                catch (ObjectCreationException ex) {
                    LOG.error(CaManagerImpl.concat("startCa (ca=", caName, "): could not initialize SslContext named " + name));
                    return false;
                }
            }
            ctlogClient = new CtLogClient(ctlogControl.getServers(), ctxConf);
        }
        try {
            ca = new X509Ca(this, caEntry, this.certstore, ctlogClient);
        }
        catch (OperationException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)CaManagerImpl.concat("X509CA.<init> (ca=", caName, ")"));
            return false;
        }
        this.x509cas.put(caName, ca);
        try {
            caResponder = new CmpResponder(this, caName);
        }
        catch (NoSuchAlgorithmException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)CaManagerImpl.concat("CmpResponder.<init> (ca=", caName, ")"));
            return false;
        }
        this.cmpResponders.put(caName, caResponder);
        if (caEntry.getScepResponderName() != null) {
            try {
                this.scepResponders.put(caName, new ScepResponder(this, caEntry.getCaEntry()));
            }
            catch (CaMgmtException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)CaManagerImpl.concat("ScepResponder.<init> (ca=", caName, ")"));
                return false;
            }
        }
        return true;
    }

    @Override
    public void close() {
        File caLockFile;
        LOG.info("stopping CA system");
        this.shutdownScheduledThreadPoolExecutor();
        if (this.persistentScheduledThreadPoolExecutor != null) {
            this.persistentScheduledThreadPoolExecutor.shutdown();
            while (!this.persistentScheduledThreadPoolExecutor.isTerminated()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    LOG.error("interrupted: {}", (Object)ex.getMessage());
                }
            }
            this.persistentScheduledThreadPoolExecutor = null;
        }
        for (String caName : this.x509cas.keySet()) {
            X509Ca ca = this.x509cas.get(caName);
            try {
                ca.close();
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)CaManagerImpl.concat("could not call ca.close() for CA ", caName));
            }
        }
        if (this.caLockedByMe) {
            try {
                this.unlockCa();
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not unlock CA system");
            }
        }
        if (this.datasource != null) {
            try {
                this.datasource.close();
            }
            catch (Exception ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)CaManagerImpl.concat("could not close datasource ca", new String[0]));
            }
        }
        if (this.publishers != null) {
            for (String name : this.publishers.keySet()) {
                IdentifiedCertPublisher publisher = this.publishers.get(name);
                this.shutdownPublisher(publisher);
            }
        }
        if (this.certprofiles != null) {
            for (String name : this.certprofiles.keySet()) {
                IdentifiedCertprofile certprofile = this.certprofiles.get(name);
                this.shutdownCertprofile(certprofile);
            }
        }
        if ((caLockFile = new File("calock")).exists()) {
            caLockFile.delete();
        }
        this.auditLogPciEvent(true, "SHUTDOWN");
        LOG.info("stopped CA system");
    }

    public CmpResponder getX509CaResponder(String name) {
        return this.cmpResponders.get(Args.toNonBlankLower((String)name, (String)"name"));
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return this.scheduledThreadPoolExecutor;
    }

    public Set<String> getCertprofileNames() {
        return this.certprofileDbEntries.keySet();
    }

    public Set<String> getPublisherNames() {
        return this.publisherDbEntries.keySet();
    }

    public Set<String> getRequestorNames() {
        return this.requestorDbEntries.keySet();
    }

    public Set<String> getSignerNames() {
        return this.signerDbEntries.keySet();
    }

    public Set<String> getCaNames() {
        return this.caInfos.keySet();
    }

    public Set<String> getSuccessfulCaNames() {
        HashSet<String> ret = new HashSet<String>();
        for (String name : this.x509cas.keySet()) {
            if (CaStatus.ACTIVE != this.caInfos.get(name).getStatus()) continue;
            ret.add(name);
        }
        return ret;
    }

    public Set<String> getFailedCaNames() {
        HashSet<String> ret = new HashSet<String>();
        for (String name : this.caInfos.keySet()) {
            if (CaStatus.ACTIVE != this.caInfos.get(name).getStatus() || this.x509cas.containsKey(name)) continue;
            ret.add(name);
        }
        return ret;
    }

    public Set<String> getInactiveCaNames() {
        HashSet<String> ret = new HashSet<String>();
        for (String name : this.caInfos.keySet()) {
            if (CaStatus.INACTIVE != this.caInfos.get(name).getStatus()) continue;
            ret.add(name);
        }
        return ret;
    }

    private void initRequestors() throws CaMgmtException {
        if (this.requestorsInitialized) {
            return;
        }
        this.idNameMap.clearRequestor();
        this.requestorDbEntries.clear();
        this.requestors.clear();
        List<String> names = this.queryExecutor.namesFromTable("REQUESTOR");
        for (String name : names) {
            Integer id;
            if ("by-ca".equals(name)) {
                id = this.queryExecutor.getRequestorId(name);
                NameId ident = new NameId(id, name);
                this.byCaRequestor = new RequestorInfo.ByCaRequestorInfo(ident);
                this.idNameMap.addRequestor(ident);
            } else if ("by-user".equals(name)) {
                id = this.queryExecutor.getRequestorId(name);
                this.byUserRequestorId = new NameId(id, name);
                this.idNameMap.addRequestor(this.byUserRequestorId);
            } else {
                MgmtEntry.Requestor requestorDbEntry = this.queryExecutor.createRequestor(name);
                if (requestorDbEntry == null) {
                    LOG.error("could not load requestor {}", (Object)name);
                    continue;
                }
                this.idNameMap.addRequestor(requestorDbEntry.getIdent());
                this.requestorDbEntries.put(name, requestorDbEntry);
                RequestorEntryWrapper requestor = new RequestorEntryWrapper();
                requestor.setDbEntry(requestorDbEntry, this.securityFactory.getPasswordResolver());
                this.requestors.put(name, requestor);
            }
            LOG.info("loaded requestor {}", (Object)name);
        }
        this.requestorsInitialized = true;
    }

    private void initSigners() throws CaMgmtException {
        if (this.signerInitialized) {
            return;
        }
        this.signerDbEntries.clear();
        this.signers.clear();
        List<String> names = this.queryExecutor.namesFromTable("SIGNER");
        for (String name : names) {
            MgmtEntry.Signer entry = this.queryExecutor.createSigner(name);
            if (entry == null) {
                LOG.error("could not initialize signer '{}'", (Object)name);
                continue;
            }
            entry.setConfFaulty(true);
            this.signerDbEntries.put(name, entry);
            SignerEntryWrapper signer = this.createSigner(entry);
            if (signer != null) {
                entry.setConfFaulty(false);
                this.signers.put(name, signer);
                LOG.info("loaded signer {}", (Object)name);
                continue;
            }
            LOG.error("could not load signer {}", (Object)name);
        }
        this.signerInitialized = true;
    }

    private void initCaAliases() throws CaMgmtException {
        if (this.caAliasesInitialized) {
            return;
        }
        Map<String, Integer> map = this.queryExecutor.createCaAliases();
        this.caAliases.clear();
        for (String aliasName : map.keySet()) {
            this.caAliases.put(aliasName, map.get(aliasName));
        }
        LOG.info("caAliases: {}", this.caAliases);
        this.caAliasesInitialized = true;
    }

    private void initCertprofiles() throws CaMgmtException {
        if (this.certprofilesInitialized) {
            return;
        }
        for (String name : this.certprofiles.keySet()) {
            this.shutdownCertprofile(this.certprofiles.get(name));
        }
        this.certprofileDbEntries.clear();
        this.idNameMap.clearCertprofile();
        this.certprofiles.clear();
        List<String> names = this.queryExecutor.namesFromTable("PROFILE");
        for (String name : names) {
            MgmtEntry.Certprofile dbEntry = this.queryExecutor.createCertprofile(name);
            if (dbEntry == null) {
                LOG.error("could not initialize Certprofile '{}'", (Object)name);
                continue;
            }
            this.idNameMap.addCertprofile(dbEntry.getIdent());
            dbEntry.setFaulty(true);
            this.certprofileDbEntries.put(name, dbEntry);
            IdentifiedCertprofile profile = this.createCertprofile(dbEntry);
            if (profile != null) {
                dbEntry.setFaulty(false);
                this.certprofiles.put(name, profile);
                LOG.info("loaded certprofile {}", (Object)name);
                continue;
            }
            LOG.error("could not load certprofile {}", (Object)name);
        }
        this.certprofilesInitialized = true;
    }

    private void initPublishers() throws CaMgmtException {
        if (this.publishersInitialized) {
            return;
        }
        for (String name : this.publishers.keySet()) {
            this.shutdownPublisher(this.publishers.get(name));
        }
        this.publishers.clear();
        this.publisherDbEntries.clear();
        this.idNameMap.clearPublisher();
        List<String> names = this.queryExecutor.namesFromTable("PUBLISHER");
        for (String name : names) {
            MgmtEntry.Publisher dbEntry = this.queryExecutor.createPublisher(name);
            if (dbEntry == null) {
                LOG.error("could not initialize publisher '{}'", (Object)name);
                continue;
            }
            this.idNameMap.addPublisher(dbEntry.getIdent());
            dbEntry.setFaulty(true);
            this.publisherDbEntries.put(name, dbEntry);
            IdentifiedCertPublisher publisher = this.createPublisher(dbEntry);
            if (publisher != null) {
                dbEntry.setFaulty(false);
                this.publishers.put(name, publisher);
                LOG.info("loaded publisher {}", (Object)name);
                continue;
            }
            LOG.error("could not load publisher {}", (Object)name);
        }
        this.publishersInitialized = true;
    }

    private void initCas() throws CaMgmtException {
        if (this.casInitialized) {
            return;
        }
        this.caInfos.clear();
        this.caHasRequestors.clear();
        this.caHasPublishers.clear();
        this.caHasProfiles.clear();
        this.idNameMap.clearCa();
        List<String> names = this.queryExecutor.namesFromTable("CA");
        for (String name : names) {
            this.createCa(name);
        }
        this.casInitialized = true;
    }

    private boolean createCa(String name) throws CaMgmtException {
        this.caInfos.remove(name);
        this.idNameMap.removeCa(name);
        this.caHasProfiles.remove(name);
        this.caHasPublishers.remove(name);
        this.caHasRequestors.remove(name);
        X509Ca oldCa = this.x509cas.remove(name);
        this.cmpResponders.remove(name);
        this.scepResponders.remove(name);
        if (oldCa != null) {
            oldCa.close();
        }
        CaInfo ca = this.queryExecutor.createCaInfo(name, this.masterMode, this.certstore);
        LOG.info("created CA {}: {}", (Object)name, (Object)ca.toString(false));
        this.caInfos.put(name, ca);
        this.idNameMap.addCa(ca.getIdent());
        Set<MgmtEntry.CaHasRequestor> caReqEntries = this.queryExecutor.createCaHasRequestors(ca.getIdent());
        this.caHasRequestors.put(name, caReqEntries);
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (MgmtEntry.CaHasRequestor entry : caReqEntries) {
                sb.append("\n    ").append(entry);
            }
            LOG.info("CA {} is associated requestors:{}", (Object)name, (Object)sb);
        }
        Set<Integer> profileIds = this.queryExecutor.createCaHasProfiles(ca.getIdent());
        HashSet<String> profileNames = new HashSet<String>();
        for (Integer id : profileIds) {
            profileNames.add(this.idNameMap.getCertprofileName(id));
        }
        this.caHasProfiles.put(name, profileNames);
        LOG.info("CA {} is associated with profiles: {}", (Object)name, profileNames);
        Set<Integer> publisherIds = this.queryExecutor.createCaHasPublishers(ca.getIdent());
        HashSet<String> publisherNames = new HashSet<String>();
        for (Integer id : publisherIds) {
            publisherNames.add(this.idNameMap.getPublisherName(id));
        }
        this.caHasPublishers.put(name, publisherNames);
        LOG.info("CA {} is associated with publishers: {}", (Object)name, publisherNames);
        return true;
    }

    public void commitNextCrlNo(NameId ca, long nextCrlNo) throws OperationException {
        try {
            this.queryExecutor.commitNextCrlNoIfLess(ca, nextCrlNo);
        }
        catch (CaMgmtException ex) {
            if (ex.getCause() instanceof DataAccessException) {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, ex.getMessage());
            }
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, ex.getMessage());
        }
        catch (RuntimeException ex) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, ex.getMessage());
        }
    }

    public RequestorInfo.ByUserRequestorInfo createByUserRequestor(MgmtEntry.CaHasUser caHasUser) {
        return new RequestorInfo.ByUserRequestorInfo(this.byUserRequestorId, caHasUser);
    }

    public void addCa(MgmtEntry.Ca caEntry) throws CaMgmtException {
        String newSignerConf;
        Args.notNull((Object)caEntry, (String)"caEntry");
        this.assertMasterModeAndSetuped();
        NameId ident = caEntry.getIdent();
        String name = ident.getName();
        if (this.caInfos.containsKey(name)) {
            throw new CaMgmtException(CaManagerImpl.concat("CA named ", name, " exists"));
        }
        String origSignerConf = caEntry.getSignerConf();
        if (!origSignerConf.equals(newSignerConf = CaManagerImpl.canonicalizeSignerConf(caEntry.getSignerType(), origSignerConf, null, this.securityFactory))) {
            caEntry.setSignerConf(newSignerConf);
        }
        try {
            List signerConfs = MgmtEntry.Ca.splitCaSignerConfs((String)caEntry.getSignerConf());
            for (String[] m : signerConfs) {
                SignerConf signerConf = new SignerConf(m[1]);
                ConcurrentContentSigner signer = this.securityFactory.createSigner(caEntry.getSignerType(), signerConf, caEntry.getCert());
                if (caEntry.getCert() != null) continue;
                if (signer.getCertificate() == null) {
                    throw new CaMgmtException("CA signer without certificate is not allowed");
                }
                caEntry.setCert(signer.getCertificate());
            }
        }
        catch (XiSecurityException | ObjectCreationException ex) {
            throw new CaMgmtException(CaManagerImpl.concat("could not create signer for new CA ", name, ": ", ex.getMessage()), ex);
        }
        this.queryExecutor.addCa(caEntry);
        if (this.createCa(name)) {
            if (this.startCa(name)) {
                LOG.info("started CA {}", (Object)name);
            } else {
                LOG.error("could not start CA {}", (Object)name);
            }
        } else {
            LOG.error("could not create CA {}", (Object)name);
        }
    }

    public MgmtEntry.Ca getCa(String name) {
        CaInfo caInfo = this.caInfos.get(Args.toNonBlankLower((String)name, (String)"name"));
        return caInfo == null ? null : caInfo.getCaEntry();
    }

    public void changeCa(MgmtEntry.ChangeCa entry) throws CaMgmtException {
        Args.notNull((Object)entry, (String)"entry");
        this.assertMasterModeAndSetuped();
        String name = entry.getIdent().getName();
        NameId ident = this.idNameMap.getCa(name);
        if (ident == null) {
            throw new CaMgmtException("Unknown CA " + name);
        }
        entry.getIdent().setId(ident.getId());
        this.queryExecutor.changeCa(entry, this.caInfos.get(name).getCaEntry(), this.securityFactory);
        if (this.createCa(name)) {
            CaInfo caInfo = this.caInfos.get(name);
            if (CaStatus.ACTIVE != caInfo.getCaEntry().getStatus()) {
                return;
            }
            if (this.startCa(name)) {
                LOG.info("started CA {}", (Object)name);
            } else {
                LOG.error("could not start CA {}", (Object)name);
            }
        } else {
            LOG.error("could not create CA {}", (Object)name);
        }
    }

    public void removeCertprofileFromCa(String profileName, String caName) throws CaMgmtException {
        Set<String> set;
        profileName = Args.toNonBlankLower((String)profileName, (String)"profileName");
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        this.assertMasterModeAndSetuped();
        this.queryExecutor.removeCertprofileFromCa(profileName, caName);
        if (this.caHasProfiles.containsKey(caName) && (set = this.caHasProfiles.get(caName)) != null) {
            set.remove(profileName);
        }
    }

    public void addCertprofileToCa(String profileName, String caName) throws CaMgmtException {
        profileName = Args.toNonBlankLower((String)profileName, (String)"profileName");
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        this.assertMasterModeAndSetuped();
        NameId ident = this.idNameMap.getCertprofile(profileName);
        if (ident == null) {
            throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("unknown Certprofile ", profileName));
        }
        NameId caIdent = this.idNameMap.getCa(caName);
        if (caIdent == null) {
            throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("unknown CA ", caName));
        }
        Set<String> set = this.caHasProfiles.get(caName);
        if (set == null) {
            set = new HashSet<String>();
            this.caHasProfiles.put(caName, set);
        } else if (set.contains(profileName)) {
            throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("Certprofile ", profileName, " already associated with CA ", caName));
        }
        if (!this.certprofiles.containsKey(profileName)) {
            throw new CaMgmtException(CaManagerImpl.concat("certprofile '", profileName, "' is faulty"));
        }
        this.queryExecutor.addCertprofileToCa(ident, caIdent);
        set.add(profileName);
    }

    public void removePublisherFromCa(String publisherName, String caName) throws CaMgmtException {
        publisherName = Args.toNonBlankLower((String)publisherName, (String)"publisherName");
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        this.assertMasterModeAndSetuped();
        this.queryExecutor.removePublisherFromCa(publisherName, caName);
        Set<String> publisherNames = this.caHasPublishers.get(caName);
        if (publisherNames != null) {
            publisherNames.remove(publisherName);
        }
    }

    public void addPublisherToCa(String publisherName, String caName) throws CaMgmtException {
        publisherName = Args.toNonBlankLower((String)publisherName, (String)"publisherName");
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        this.assertMasterModeAndSetuped();
        NameId ident = this.idNameMap.getPublisher(publisherName);
        if (ident == null) {
            throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("unknown publisher ", publisherName));
        }
        NameId caIdent = this.idNameMap.getCa(caName);
        if (caIdent == null) {
            throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("unknown CA ", caName));
        }
        Set<String> publisherNames = this.caHasPublishers.get(caName);
        if (publisherNames == null) {
            publisherNames = new HashSet<String>();
            this.caHasPublishers.put(caName, publisherNames);
        } else if (publisherNames.contains(publisherName)) {
            String msg = CaManagerImpl.concat("publisher ", publisherName, " already associated with CA ", caName);
            throw CaManagerImpl.logAndCreateException(msg);
        }
        IdentifiedCertPublisher publisher = this.publishers.get(publisherName);
        if (publisher == null) {
            throw new CaMgmtException(CaManagerImpl.concat("publisher '", publisherName, "' is faulty"));
        }
        this.queryExecutor.addPublisherToCa(this.idNameMap.getPublisher(publisherName), caIdent);
        publisherNames.add(publisherName);
        this.caHasPublishers.get(caName).add(publisherName);
        publisher.caAdded(this.caInfos.get(caName).getCert());
    }

    public Set<String> getCertprofilesForCa(String caName) {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        return this.caHasProfiles.get(caName);
    }

    public Set<MgmtEntry.CaHasRequestor> getRequestorsForCa(String caName) {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        return this.caHasRequestors.get(caName);
    }

    public MgmtEntry.Requestor getRequestor(String name) {
        return this.requestorDbEntries.get(Args.toNonBlankLower((String)name, (String)"name"));
    }

    public RequestorEntryWrapper getRequestorWrapper(String name) {
        return this.requestors.get(Args.toNonBlankLower((String)name, (String)"name"));
    }

    public void addRequestor(MgmtEntry.Requestor requestorEntry) throws CaMgmtException {
        String conf;
        Args.notNull((Object)requestorEntry, (String)"requestorEntry");
        this.assertMasterModeAndSetuped();
        String name = requestorEntry.getIdent().getName();
        if (this.requestorDbEntries.containsKey(name)) {
            throw new CaMgmtException(CaManagerImpl.concat("Requestor named ", name, " exists"));
        }
        PasswordResolver pwdResolver = this.securityFactory.getPasswordResolver();
        if ("pbm".equalsIgnoreCase(requestorEntry.getType()) && !StringUtil.startsWithIgnoreCase((String)(conf = requestorEntry.getConf()), (String)"PBE:")) {
            String encryptedPassword;
            try {
                encryptedPassword = pwdResolver.protectPassword("PBE", conf.toCharArray());
            }
            catch (PasswordResolverException ex) {
                throw new CaMgmtException("could not encrypt requestor " + name, (Throwable)ex);
            }
            requestorEntry = new MgmtEntry.Requestor(requestorEntry.getIdent(), requestorEntry.getType(), encryptedPassword);
        }
        RequestorEntryWrapper requestor = new RequestorEntryWrapper();
        requestor.setDbEntry(requestorEntry, pwdResolver);
        this.queryExecutor.addRequestor(requestorEntry);
        this.idNameMap.addRequestor(requestorEntry.getIdent());
        this.requestorDbEntries.put(name, requestorEntry);
        this.requestors.put(name, requestor);
    }

    public void removeRequestor(String name) throws CaMgmtException {
        name = Args.toNonBlankLower((String)name, (String)"name");
        this.assertMasterModeAndSetuped();
        for (String caName : this.caHasRequestors.keySet()) {
            boolean removeMe = false;
            for (MgmtEntry.CaHasRequestor caHasRequestor : this.caHasRequestors.get(caName)) {
                if (!caHasRequestor.getRequestorIdent().getName().equals(name)) continue;
                removeMe = true;
                break;
            }
            if (!removeMe) continue;
            this.removeRequestorFromCa(name, caName);
        }
        if (!this.queryExecutor.deleteRowWithName(name, "REQUESTOR")) {
            throw new CaMgmtException("unknown requestor " + name);
        }
        this.idNameMap.removeRequestor(this.requestorDbEntries.get(name).getIdent().getId());
        this.requestorDbEntries.remove(name);
        this.requestors.remove(name);
        LOG.info("removed requestor '{}'", (Object)name);
    }

    public void changeRequestor(String name, String type, String conf) throws CaMgmtException {
        name = Args.toNonBlankLower((String)name, (String)"name");
        Args.notBlank((String)type, (String)"type");
        Args.notBlank((String)conf, (String)"conf");
        this.assertMasterModeAndSetuped();
        NameId ident = this.idNameMap.getRequestor(name);
        if (ident == null) {
            throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("unknown requestor ", name));
        }
        RequestorEntryWrapper requestor = this.queryExecutor.changeRequestor(ident, type, conf, this.securityFactory.getPasswordResolver());
        this.requestorDbEntries.remove(name);
        this.requestors.remove(name);
        this.requestorDbEntries.put(name, requestor.getDbEntry());
        this.requestors.put(name, requestor);
    }

    public void removeRequestorFromCa(String requestorName, String caName) throws CaMgmtException {
        requestorName = Args.toNonBlankLower((String)requestorName, (String)"requestorName");
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        this.assertMasterModeAndSetuped();
        if (requestorName.equals("by-ca") || requestorName.equals("by-user")) {
            throw new CaMgmtException(CaManagerImpl.concat("removing requestor ", requestorName, " is not permitted"));
        }
        this.queryExecutor.removeRequestorFromCa(requestorName, caName);
        if (this.caHasRequestors.containsKey(caName)) {
            Set<MgmtEntry.CaHasRequestor> entries = this.caHasRequestors.get(caName);
            MgmtEntry.CaHasRequestor entry = null;
            for (MgmtEntry.CaHasRequestor m : entries) {
                if (!m.getRequestorIdent().getName().equals(requestorName)) continue;
                entry = m;
            }
            entries.remove(entry);
        }
    }

    public void addRequestorToCa(MgmtEntry.CaHasRequestor requestor, String caName) throws CaMgmtException {
        Args.notNull((Object)requestor, (String)"requestor");
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        this.assertMasterModeAndSetuped();
        NameId requestorIdent = requestor.getRequestorIdent();
        NameId ident = this.idNameMap.getRequestor(requestorIdent.getName());
        if (ident == null) {
            throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("unknown requestor ", requestorIdent.getName()));
        }
        NameId caIdent = this.idNameMap.getCa(caName);
        if (caIdent == null) {
            String msg = CaManagerImpl.concat("unknown CA ", caName);
            LOG.warn(msg);
            throw new CaMgmtException(msg);
        }
        requestorIdent.setId(ident.getId());
        Set<MgmtEntry.CaHasRequestor> cmpRequestors = this.caHasRequestors.get(caName);
        if (cmpRequestors == null) {
            cmpRequestors = new HashSet<MgmtEntry.CaHasRequestor>();
            this.caHasRequestors.put(caName, cmpRequestors);
        } else {
            for (MgmtEntry.CaHasRequestor entry : cmpRequestors) {
                String requestorName = requestorIdent.getName();
                if (!entry.getRequestorIdent().getName().equals(requestorName)) continue;
                String msg = CaManagerImpl.concat("Requestor ", requestorName, " already associated with CA ", caName);
                throw CaManagerImpl.logAndCreateException(msg);
            }
        }
        cmpRequestors.add(requestor);
        this.queryExecutor.addRequestorToCa(requestor, caIdent);
        this.caHasRequestors.get(caName).add(requestor);
    }

    public void removeUserFromCa(String userName, String caName) throws CaMgmtException {
        userName = Args.toNonBlankLower((String)userName, (String)"userName");
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        this.assertMasterModeAndSetuped();
        this.queryExecutor.removeUserFromCa(userName, caName);
    }

    public void addUserToCa(MgmtEntry.CaHasUser user, String caName) throws CaMgmtException {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        this.assertMasterModeAndSetuped();
        X509Ca ca = this.getX509Ca(caName);
        if (ca == null) {
            throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("unknown CA ", caName));
        }
        this.queryExecutor.addUserToCa(user, ca.getCaIdent());
    }

    public Map<String, MgmtEntry.CaHasUser> getCaHasUsersForUser(String user) throws CaMgmtException {
        Args.notBlank((String)user, (String)"user");
        return this.queryExecutor.getCaHasUsersForUser(user, this.idNameMap);
    }

    public MgmtEntry.Certprofile getCertprofile(String name) {
        return this.certprofileDbEntries.get(name.toLowerCase());
    }

    public void removeCertprofile(String name) throws CaMgmtException {
        name = Args.toNonBlankLower((String)name, (String)"name");
        this.assertMasterModeAndSetuped();
        for (String caName : this.caHasProfiles.keySet()) {
            if (!this.caHasProfiles.get(caName).contains(name)) continue;
            this.removeCertprofileFromCa(name, caName);
        }
        boolean bo = this.queryExecutor.deleteRowWithName(name, "PROFILE");
        if (!bo) {
            throw new CaMgmtException("unknown profile " + name);
        }
        LOG.info("removed profile '{}'", (Object)name);
        this.idNameMap.removeCertprofile(this.certprofileDbEntries.get(name).getIdent().getId());
        this.certprofileDbEntries.remove(name);
        IdentifiedCertprofile profile = this.certprofiles.remove(name);
        this.shutdownCertprofile(profile);
    }

    public void changeCertprofile(String name, String type, String conf) throws CaMgmtException {
        name = Args.toNonBlankLower((String)name, (String)"name");
        if (type == null && conf == null) {
            throw new IllegalArgumentException("type and conf cannot be both null");
        }
        NameId ident = this.idNameMap.getCertprofile(name);
        if (ident == null) {
            throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("unknown Certprofile ", name));
        }
        if (type != null) {
            type = type.toLowerCase();
        }
        this.assertMasterModeAndSetuped();
        IdentifiedCertprofile profile = this.queryExecutor.changeCertprofile(ident, type, conf, this);
        this.certprofileDbEntries.remove(name);
        IdentifiedCertprofile oldProfile = this.certprofiles.remove(name);
        this.certprofileDbEntries.put(name, profile.getDbEntry());
        this.certprofiles.put(name, profile);
        if (oldProfile != null) {
            this.shutdownCertprofile(oldProfile);
        }
    }

    public void addCertprofile(MgmtEntry.Certprofile certprofileEntry) throws CaMgmtException {
        Args.notNull((Object)certprofileEntry, (String)"certprofileEntry");
        this.assertMasterModeAndSetuped();
        String name = certprofileEntry.getIdent().getName();
        if (this.certprofileDbEntries.containsKey(name)) {
            throw new CaMgmtException(CaManagerImpl.concat("Certprofile named ", name, " exists"));
        }
        certprofileEntry.setFaulty(true);
        IdentifiedCertprofile profile = this.createCertprofile(certprofileEntry);
        if (profile == null) {
            throw new CaMgmtException("could not create Certprofile object");
        }
        certprofileEntry.setFaulty(false);
        this.certprofiles.put(name, profile);
        this.queryExecutor.addCertprofile(certprofileEntry);
        this.idNameMap.addCertprofile(certprofileEntry.getIdent());
        this.certprofileDbEntries.put(name, certprofileEntry);
    }

    public void addSigner(MgmtEntry.Signer signerEntry) throws CaMgmtException {
        String newConf;
        Args.notNull((Object)signerEntry, (String)"signerEntry");
        this.assertMasterModeAndSetuped();
        String name = signerEntry.getName();
        if (this.signerDbEntries.containsKey(name)) {
            throw new CaMgmtException(CaManagerImpl.concat("Signer named ", name, " exists"));
        }
        String conf = signerEntry.getConf();
        if (conf != null && !conf.equals(newConf = CaManagerImpl.canonicalizeSignerConf(signerEntry.getType(), conf, null, this.securityFactory))) {
            signerEntry.setConf(newConf);
        }
        SignerEntryWrapper signer = this.createSigner(signerEntry);
        this.queryExecutor.addSigner(signerEntry);
        this.signers.put(name, signer);
        this.signerDbEntries.put(name, signerEntry);
    }

    public void removeSigner(String name) throws CaMgmtException {
        name = Args.toNonBlankLower((String)name, (String)"name");
        this.assertMasterModeAndSetuped();
        boolean bo = this.queryExecutor.deleteRowWithName(name, "SIGNER");
        if (!bo) {
            throw new CaMgmtException("unknown signer " + name);
        }
        for (String caName : this.caInfos.keySet()) {
            CaInfo caInfo = this.caInfos.get(caName);
            if (name.equals(caInfo.getCmpResponderName())) {
                caInfo.setCmpResponderName(null);
            }
            if (name.equals(caInfo.getScepResponderName())) {
                caInfo.setScepResponderName(null);
            }
            if (!name.equals(caInfo.getCrlSignerName())) continue;
            caInfo.setCrlSignerName(null);
        }
        this.signerDbEntries.remove(name);
        this.signers.remove(name);
        LOG.info("removed signer '{}'", (Object)name);
    }

    public void changeSigner(String name, String type, String conf, String base64Cert) throws CaMgmtException {
        name = Args.toNonBlankLower((String)name, (String)"name");
        this.assertMasterModeAndSetuped();
        if (type == null && conf == null && base64Cert == null) {
            throw new IllegalArgumentException("nothing to change");
        }
        if (type != null) {
            type = type.toLowerCase();
        }
        SignerEntryWrapper newResponder = this.queryExecutor.changeSigner(name, type, conf, base64Cert, this, this.securityFactory);
        this.signers.remove(name);
        this.signerDbEntries.remove(name);
        this.signerDbEntries.put(name, newResponder.getDbEntry());
        this.signers.put(name, newResponder);
        for (String caName : this.scepResponders.keySet()) {
            if (!this.getCa(caName).getScepResponderName().equals(name)) continue;
            this.scepResponders.get(caName).setResponder(newResponder);
        }
    }

    public MgmtEntry.Signer getSigner(String name) {
        return this.signerDbEntries.get(Args.toNonBlankLower((String)name, (String)"name"));
    }

    public SignerEntryWrapper getSignerWrapper(String name) {
        return this.signers.get(Args.toNonBlankLower((String)name, (String)"name"));
    }

    public void addPublisher(MgmtEntry.Publisher entry) throws CaMgmtException {
        Args.notNull((Object)entry, (String)"entry");
        this.assertMasterModeAndSetuped();
        String name = entry.getIdent().getName();
        if (this.publisherDbEntries.containsKey(name)) {
            throw new CaMgmtException(CaManagerImpl.concat("Publisher named ", name, " exists"));
        }
        entry.setFaulty(true);
        IdentifiedCertPublisher publisher = this.createPublisher(entry);
        entry.setFaulty(false);
        this.queryExecutor.addPublisher(entry);
        this.publishers.put(name, publisher);
        this.idNameMap.addPublisher(entry.getIdent());
        this.publisherDbEntries.put(name, entry);
    }

    public List<MgmtEntry.Publisher> getPublishersForCa(String caName) {
        Set<String> publisherNames = this.caHasPublishers.get(caName = Args.toNonBlankLower((String)caName, (String)"caName"));
        if (publisherNames == null) {
            return Collections.emptyList();
        }
        ArrayList<MgmtEntry.Publisher> ret = new ArrayList<MgmtEntry.Publisher>(publisherNames.size());
        for (String publisherName : publisherNames) {
            ret.add(this.publisherDbEntries.get(publisherName));
        }
        return ret;
    }

    public MgmtEntry.Publisher getPublisher(String name) {
        name = Args.toNonBlankLower((String)name, (String)"name");
        return this.publisherDbEntries.get(name);
    }

    public void removePublisher(String name) throws CaMgmtException {
        name = Args.toNonBlankLower((String)name, (String)"name");
        this.assertMasterModeAndSetuped();
        for (String caName : this.caHasPublishers.keySet()) {
            if (!this.caHasPublishers.get(caName).contains(name)) continue;
            this.removePublisherFromCa(name, caName);
        }
        boolean bo = this.queryExecutor.deleteRowWithName(name, "PUBLISHER");
        if (!bo) {
            throw new CaMgmtException("unknown publisher " + name);
        }
        LOG.info("removed publisher '{}'", (Object)name);
        this.publisherDbEntries.remove(name);
        IdentifiedCertPublisher publisher = this.publishers.remove(name);
        this.shutdownPublisher(publisher);
    }

    public void changePublisher(String name, String type, String conf) throws CaMgmtException {
        name = Args.toNonBlankLower((String)name, (String)"name");
        this.assertMasterModeAndSetuped();
        if (type == null && conf == null) {
            throw new IllegalArgumentException("nothing to change");
        }
        if (type != null) {
            type = type.toLowerCase();
        }
        IdentifiedCertPublisher publisher = this.queryExecutor.changePublisher(name, type, conf, this);
        IdentifiedCertPublisher oldPublisher = this.publishers.remove(name);
        this.shutdownPublisher(oldPublisher);
        this.publisherDbEntries.put(name, publisher.getDbEntry());
        this.publishers.put(name, publisher);
    }

    public CaServerConf getCaServerConf() {
        return this.caServerConf;
    }

    public void setCaServerConf(CaServerConf caServerConf) {
        this.caServerConf = (CaServerConf)((Object)Args.notNull((Object)((Object)caServerConf), (String)"caServerConf"));
    }

    public void addCaAlias(String aliasName, String caName) throws CaMgmtException {
        aliasName = Args.toNonBlankLower((String)aliasName, (String)"aliasName");
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        this.assertMasterModeAndSetuped();
        X509Ca ca = this.x509cas.get(caName);
        if (ca == null) {
            throw new CaMgmtException("unknown CA " + caName);
        }
        if (this.caAliases.get(aliasName) != null) {
            throw new CaMgmtException("unknown CA alias " + aliasName);
        }
        this.queryExecutor.addCaAlias(aliasName, ca.getCaIdent());
        this.caAliases.put(aliasName, ca.getCaIdent().getId());
    }

    public void removeCaAlias(String name) throws CaMgmtException {
        name = Args.toNonBlankLower((String)name, (String)"name");
        this.assertMasterModeAndSetuped();
        this.queryExecutor.removeCaAlias(name);
        this.caAliases.remove(name);
    }

    public String getCaNameForAlias(String aliasName) {
        aliasName = Args.toNonBlankLower((String)aliasName, (String)"aliasName");
        Integer caId = this.caAliases.get(aliasName);
        for (String name : this.x509cas.keySet()) {
            X509Ca ca = this.x509cas.get(name);
            if (!ca.getCaIdent().getId().equals(caId)) continue;
            return ca.getCaIdent().getName();
        }
        return null;
    }

    public Set<String> getAliasesForCa(String caName) {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        HashSet<String> aliases = new HashSet<String>();
        X509Ca ca = this.x509cas.get(caName);
        if (ca == null) {
            return aliases;
        }
        NameId caIdent = ca.getCaIdent();
        for (String alias : this.caAliases.keySet()) {
            Integer thisCaId = this.caAliases.get(alias);
            if (!caIdent.getId().equals(thisCaId)) continue;
            aliases.add(alias);
        }
        return aliases;
    }

    public Set<String> getCaAliasNames() {
        return this.caAliases.keySet();
    }

    public X509Cert getCaCert(String caName) {
        X509Ca ca = this.x509cas.get(caName = Args.toNonBlankLower((String)caName, (String)"caName"));
        return ca == null ? null : ca.getCaInfo().getCert();
    }

    public List<X509Cert> getCaCertchain(String caName) {
        X509Ca ca = this.x509cas.get(caName = Args.toNonBlankLower((String)caName, (String)"caName"));
        return ca == null ? null : ca.getCaInfo().getCertchain();
    }

    public void removeCa(String name) throws CaMgmtException {
        name = Args.toNonBlankLower((String)name, (String)"name");
        this.assertMasterModeAndSetuped();
        this.queryExecutor.removeCa(name);
        LOG.info("removed CA '{}'", (Object)name);
        this.caInfos.remove(name);
        this.idNameMap.removeCa(name);
        this.idNameMap.removeCa(name);
        this.caHasProfiles.remove(name);
        this.caHasPublishers.remove(name);
        this.caHasRequestors.remove(name);
        X509Ca ca = this.x509cas.remove(name);
        this.cmpResponders.remove(name);
        this.scepResponders.remove(name);
        if (ca != null) {
            ca.close();
        }
    }

    public void republishCertificates(String caName, List<String> publisherNames, int numThreads) throws CaMgmtException {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        Args.positive((int)numThreads, (String)"numThreads");
        this.assertMasterModeAndSetuped();
        X509Ca ca = this.x509cas.get(caName);
        if (ca == null) {
            throw new CaMgmtException(CaManagerImpl.concat("could not find CA named ", caName));
        }
        if (!ca.republishCerts(publisherNames = CollectionUtil.toLowerCaseList(publisherNames), numThreads)) {
            throw new CaMgmtException(CaManagerImpl.concat("republishing certificates of CA ", caName, " failed"));
        }
    }

    public void revokeCa(String caName, CertRevocationInfo revocationInfo) throws CaMgmtException {
        CrlReason currentReason;
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        Args.notNull((Object)revocationInfo, (String)"revocationInfo");
        this.assertMasterModeAndSetuped();
        if (!this.x509cas.containsKey(caName)) {
            throw new CaMgmtException(CaManagerImpl.concat("unkown CA ", caName));
        }
        LOG.info("revoking CA '{}'", (Object)caName);
        X509Ca ca = this.x509cas.get(caName);
        CertRevocationInfo currentRevInfo = ca.getCaInfo().getRevocationInfo();
        if (currentRevInfo != null && (currentReason = currentRevInfo.getReason()) != CrlReason.CERTIFICATE_HOLD) {
            throw new CaMgmtException(CaManagerImpl.concat("CA ", caName, " has been revoked with reason ", currentReason.name()));
        }
        this.queryExecutor.revokeCa(caName, revocationInfo);
        try {
            ca.revokeCa(revocationInfo, "ca_mgmt");
        }
        catch (OperationException ex) {
            throw new CaMgmtException(CaManagerImpl.concat("could not revoke CA ", ex.getMessage()), (Throwable)ex);
        }
        LOG.info("revoked CA '{}'", (Object)caName);
        this.auditLogPciEvent(true, CaManagerImpl.concat("REVOKE CA ", caName));
    }

    public void unrevokeCa(String caName) throws CaMgmtException {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        this.assertMasterModeAndSetuped();
        if (!this.x509cas.containsKey(caName)) {
            throw new CaMgmtException(CaManagerImpl.concat("could not find CA named ", caName));
        }
        LOG.info("unrevoking of CA '{}'", (Object)caName);
        this.queryExecutor.unrevokeCa(caName);
        X509Ca ca = this.x509cas.get(caName);
        try {
            ca.unrevokeCa("ca_mgmt");
        }
        catch (OperationException ex) {
            throw new CaMgmtException(CaManagerImpl.concat("could not unrevoke CA " + caName + ": ", ex.getMessage()), (Throwable)ex);
        }
        LOG.info("unrevoked CA '{}'", (Object)caName);
        this.auditLogPciEvent(true, CaManagerImpl.concat("UNREVOKE CA ", caName));
    }

    public void setCertprofileFactoryRegister(CertprofileFactoryRegister register) {
        this.certprofileFactoryRegister = register;
    }

    public void setCertPublisherFactoryRegister(CertPublisherFactoryRegister register) {
        this.certPublisherFactoryRegister = register;
    }

    private void auditLogPciEvent(boolean successful, String eventType) {
        PciAuditEvent event = new PciAuditEvent(new Date());
        event.setUserId("CA-SYSTEM");
        event.setEventType(eventType);
        event.setAffectedResource("CORE");
        if (successful) {
            event.setStatus(AuditStatus.SUCCESSFUL.name());
            event.setLevel(AuditLevel.INFO);
        } else {
            event.setStatus(AuditStatus.FAILED.name());
            event.setLevel(AuditLevel.ERROR);
        }
        Audits.getAuditService().logEvent(event);
    }

    public void clearPublishQueue(String caName, List<String> publisherNames) throws CaMgmtException {
        this.assertMasterModeAndSetuped();
        publisherNames = CollectionUtil.toLowerCaseList(publisherNames);
        if (caName == null) {
            if (CollectionUtil.isNotEmpty((Collection)publisherNames)) {
                throw new IllegalArgumentException("non-empty publisherNames is not allowed");
            }
            try {
                this.certstore.clearPublishQueue(null, null);
            }
            catch (OperationException ex) {
                throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
            }
            return;
        }
        X509Ca ca = this.x509cas.get(caName = caName.toLowerCase());
        if (ca == null) {
            throw new CaMgmtException(CaManagerImpl.concat("could not find CA named ", caName));
        }
        ca.clearPublishQueue(publisherNames);
    }

    private void shutdownScheduledThreadPoolExecutor() {
        if (this.scheduledThreadPoolExecutor == null) {
            return;
        }
        this.scheduledThreadPoolExecutor.shutdown();
        while (!this.scheduledThreadPoolExecutor.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                LOG.error("interrupted: {}", (Object)ex.getMessage());
            }
        }
        this.scheduledThreadPoolExecutor = null;
    }

    public void revokeCertificate(String caName, BigInteger serialNumber, CrlReason reason, Date invalidityTime) throws CaMgmtException {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        Args.notNull((Object)serialNumber, (String)"serialNumber");
        this.assertMasterModeAndSetuped();
        X509Ca ca = this.getX509Ca(caName);
        try {
            if (ca.revokeCert(serialNumber, reason, invalidityTime, "ca_mgmt") == null) {
                throw new CaMgmtException("could not revoke non-existing certificate");
            }
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void unrevokeCertificate(String caName, BigInteger serialNumber) throws CaMgmtException {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        Args.notNull((Object)serialNumber, (String)"serialNumber");
        X509Ca ca = this.getX509Ca(caName);
        try {
            if (ca.unrevokeCert(serialNumber, "ca_mgmt") == null) {
                throw new CaMgmtException("could not unrevoke non-existing certificate");
            }
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void removeCertificate(String caName, BigInteger serialNumber) throws CaMgmtException {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        Args.notNull((Object)serialNumber, (String)"serialNumber");
        this.assertMasterModeAndSetuped();
        X509Ca ca = this.getX509Ca(caName);
        if (ca == null) {
            throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("unknown CA ", caName));
        }
        try {
            if (ca.removeCert(serialNumber, "ca_mgmt") == null) {
                throw new CaMgmtException("could not remove certificate");
            }
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    public X509Cert generateCertificate(String caName, String profileName, byte[] encodedCsr, Date notBefore, Date notAfter) throws CaMgmtException {
        CertificateInfo certInfo;
        CertificationRequest csr;
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        profileName = Args.toNonBlankLower((String)profileName, (String)"profileName");
        Args.notNull((Object)encodedCsr, (String)"encodedCsr");
        AuditEvent event = new AuditEvent(new Date());
        event.setApplicationName("ca");
        event.setName("perf");
        event.addEventType("CAMGMT_CRL_GEN_ONDEMAND");
        X509Ca ca = this.getX509Ca(caName);
        try {
            csr = X509Util.parseCsr((byte[])encodedCsr);
        }
        catch (Exception ex) {
            throw new CaMgmtException(CaManagerImpl.concat("invalid CSR request. ERROR: ", ex.getMessage()));
        }
        if (!ca.verifyCsr(csr)) {
            throw new CaMgmtException("could not validate POP for the CSR");
        }
        CertificationRequestInfo certTemp = csr.getCertificationRequestInfo();
        Extensions extensions = null;
        ASN1Set attrs = certTemp.getAttributes();
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute attr = Attribute.getInstance((Object)attrs.getObjectAt(i));
            if (!PKCSObjectIdentifiers.pkcs_9_at_extensionRequest.equals((ASN1Primitive)attr.getAttrType())) continue;
            extensions = Extensions.getInstance((Object)attr.getAttributeValues()[0]);
        }
        X500Name subject = certTemp.getSubject();
        SubjectPublicKeyInfo publicKeyInfo = certTemp.getSubjectPublicKeyInfo();
        CertTemplateData certTemplateData = new CertTemplateData(subject, publicKeyInfo, notBefore, notAfter, extensions, profileName);
        try {
            certInfo = ca.generateCert(certTemplateData, this.byCaRequestor, RequestType.CA, (byte[])null, "ca_mgmt");
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
        if (ca.getCaInfo().isSaveRequest()) {
            try {
                long dbId = ca.addRequest(encodedCsr);
                ca.addRequestCert(dbId, certInfo.getCert().getCertId());
            }
            catch (OperationException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)"could not save request");
            }
        }
        return certInfo.getCert().getCert();
    }

    public X509Ca getX509Ca(String name) throws CaMgmtException {
        X509Ca ca = this.x509cas.get(name = Args.toNonBlankLower((String)name, (String)"name"));
        if (ca == null) {
            throw new CaMgmtException("unknown CA " + name);
        }
        return ca;
    }

    public X509Ca getX509Ca(NameId ident) throws CaMgmtException {
        Args.notNull((Object)ident, (String)"ident");
        X509Ca ca = this.x509cas.get(ident.getName());
        if (ca == null) {
            throw new CaMgmtException("unknown CA " + ident);
        }
        return ca;
    }

    public IdentifiedCertprofile getIdentifiedCertprofile(String profileName) {
        profileName = Args.toNonBlankLower((String)profileName, (String)"profileName");
        return this.certprofiles.get(profileName);
    }

    public List<IdentifiedCertPublisher> getIdentifiedPublishersForCa(String caName) {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        LinkedList<IdentifiedCertPublisher> ret = new LinkedList<IdentifiedCertPublisher>();
        Set<String> publisherNames = this.caHasPublishers.get(caName);
        if (publisherNames == null) {
            return ret;
        }
        for (String publisherName : publisherNames) {
            IdentifiedCertPublisher publisher = this.publishers.get(publisherName);
            ret.add(publisher);
        }
        return ret;
    }

    public X509Cert generateRootCa(MgmtEntry.Ca caEntry, String profileName, byte[] encodedCsr, BigInteger serialNumber) throws CaMgmtException {
        SelfSignedCertBuilder.GenerateSelfSignedResult result;
        CertificationRequest csr;
        Args.notNull((Object)caEntry, (String)"caEntry");
        profileName = Args.toNonBlankLower((String)profileName, (String)"profileName");
        Args.notNull((Object)encodedCsr, (String)"encodedCsr");
        int numCrls = caEntry.getNumCrls();
        String signerType = caEntry.getSignerType();
        this.assertMasterModeAndSetuped();
        if (numCrls < 0) {
            System.err.println("invalid numCrls: " + numCrls);
            return null;
        }
        int expirationPeriod = caEntry.getExpirationPeriod();
        if (expirationPeriod < 0) {
            System.err.println("invalid expirationPeriod: " + expirationPeriod);
            return null;
        }
        try {
            csr = X509Util.parseCsr((byte[])encodedCsr);
        }
        catch (Exception ex) {
            System.err.println("invalid encodedCsr");
            return null;
        }
        IdentifiedCertprofile certprofile = this.getIdentifiedCertprofile(profileName);
        if (certprofile == null) {
            throw new CaMgmtException(CaManagerImpl.concat("unknown certprofile ", profileName));
        }
        BigInteger serialOfThisCert = serialNumber != null ? serialNumber : RandomSerialNumberGenerator.getInstance().nextSerialNumber(caEntry.getSerialNoLen());
        try {
            result = SelfSignedCertBuilder.generateSelfSigned(this.securityFactory, signerType, caEntry.getSignerConf(), certprofile, csr, serialOfThisCert, caEntry.getCaUris(), caEntry.getExtraControl());
        }
        catch (OperationException | InvalidConfException ex) {
            throw new CaMgmtException(CaManagerImpl.concat(ex.getClass().getName(), ": ", ex.getMessage()), ex);
        }
        String signerConf = result.getSignerConf();
        X509Cert caCert = result.getCert();
        if ("PKCS12".equalsIgnoreCase(signerType) || "JCEKS".equalsIgnoreCase(signerType)) {
            try {
                signerConf = CaManagerImpl.canonicalizeSignerConf(signerType, signerConf, new X509Cert[]{caCert}, this.securityFactory);
            }
            catch (Exception ex) {
                throw new CaMgmtException(CaManagerImpl.concat(ex.getClass().getName(), ": ", ex.getMessage()), (Throwable)ex);
            }
        }
        String name = caEntry.getIdent().getName();
        long nextCrlNumber = caEntry.getNextCrlNumber();
        MgmtEntry.Ca entry = new MgmtEntry.Ca(new NameId(null, name), caEntry.getSerialNoLen(), nextCrlNumber, signerType, signerConf, caEntry.getCaUris(), numCrls, expirationPeriod);
        entry.setCert(caCert);
        entry.setCmpControl(caEntry.getCmpControl());
        entry.setCrlControl(caEntry.getCrlControl());
        entry.setScepControl(caEntry.getScepControl());
        entry.setCmpResponderName(caEntry.getCmpResponderName());
        entry.setScepResponderName(caEntry.getScepResponderName());
        entry.setCrlSignerName(caEntry.getCrlSignerName());
        entry.setExtraControl(caEntry.getExtraControl());
        entry.setKeepExpiredCertInDays(caEntry.getKeepExpiredCertInDays());
        entry.setMaxValidity(caEntry.getMaxValidity());
        entry.setPermission(caEntry.getPermission());
        entry.setProtocolSupport(caEntry.getProtocoSupport());
        entry.setSaveRequest(caEntry.isSaveRequest());
        entry.setStatus(caEntry.getStatus());
        entry.setValidityMode(caEntry.getValidityMode());
        this.addCa(entry);
        return caCert;
    }

    private void assertMasterModeAndSetuped() throws CaMgmtException {
        if (!this.masterMode) {
            throw new CaMgmtException("operation not allowed in slave mode");
        }
        if (!this.caSystemSetuped) {
            throw new CaMgmtException("CA system is not initialized yet.");
        }
    }

    void shutdownCertprofile(IdentifiedCertprofile profile) {
        if (profile == null) {
            return;
        }
        try {
            profile.close();
        }
        catch (Exception ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("could not shutdown Certprofile " + profile.getIdent()));
        }
    }

    void shutdownPublisher(IdentifiedCertPublisher publisher) {
        if (publisher == null) {
            return;
        }
        try {
            publisher.close();
        }
        catch (Exception ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("could not shutdown CertPublisher " + publisher.getIdent()));
        }
    }

    SignerEntryWrapper createSigner(MgmtEntry.Signer entry) throws CaMgmtException {
        Args.notNull((Object)entry, (String)"entry");
        SignerEntryWrapper ret = new SignerEntryWrapper();
        ret.setDbEntry(entry);
        try {
            ret.initSigner(this.securityFactory);
        }
        catch (ObjectCreationException ex) {
            String message = "createSigner";
            LOG.debug("createSigner", (Throwable)ex);
            throw new CaMgmtException(ex.getMessage());
        }
        return ret;
    }

    IdentifiedCertprofile createCertprofile(MgmtEntry.Certprofile entry) throws CaMgmtException {
        Args.notNull((Object)entry, (String)"entry");
        String type = entry.getType();
        if (!this.certprofileFactoryRegister.canCreateProfile(type)) {
            throw new CaMgmtException("unsupported cert profile type " + type);
        }
        try {
            Certprofile profile = this.certprofileFactoryRegister.newCertprofile(type);
            return new IdentifiedCertprofile(entry, profile);
        }
        catch (CertprofileException | ObjectCreationException ex) {
            String msg = "could not initialize Certprofile " + entry.getIdent();
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
            throw new CaMgmtException(msg, ex);
        }
    }

    IdentifiedCertPublisher createPublisher(MgmtEntry.Publisher entry) throws CaMgmtException {
        Args.notNull((Object)entry, (String)"entry");
        String type = entry.getType();
        try {
            if (!this.certPublisherFactoryRegister.canCreatePublisher(type)) {
                throw new CaMgmtException("unsupported publisher type " + type);
            }
            CertPublisher publisher = this.certPublisherFactoryRegister.newPublisher(type);
            IdentifiedCertPublisher ret = new IdentifiedCertPublisher(entry, publisher);
            ret.initialize(this.securityFactory.getPasswordResolver(), this.datasourceNameConfFileMap);
            return ret;
        }
        catch (RuntimeException | CertPublisherException | ObjectCreationException ex) {
            String msg = "invalid configuration for the publisher " + entry.getIdent();
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
            throw new CaMgmtException(msg, ex);
        }
    }

    public void addUser(MgmtEntry.AddUser addUserEntry) throws CaMgmtException {
        this.assertMasterModeAndSetuped();
        this.queryExecutor.addUser(addUserEntry);
    }

    public void changeUser(MgmtEntry.ChangeUser changeUserEntry) throws CaMgmtException {
        this.assertMasterModeAndSetuped();
        this.queryExecutor.changeUser(changeUserEntry);
    }

    public void removeUser(String username) throws CaMgmtException {
        username = Args.toNonBlankLower((String)username, (String)"username");
        this.assertMasterModeAndSetuped();
        if (!this.queryExecutor.deleteRowWithName(username, "TUSER")) {
            throw new CaMgmtException("unknown user " + username);
        }
    }

    public MgmtEntry.User getUser(String username) throws CaMgmtException {
        return this.queryExecutor.getUser(username.toLowerCase());
    }

    CaIdNameMap idNameMap() {
        return this.idNameMap;
    }

    public X509CRLHolder generateCrlOnDemand(String caName) throws CaMgmtException {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        X509Ca ca = this.getX509Ca(caName);
        try {
            return ca.generateCrlOnDemand("ca_mgmt");
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    public X509CRLHolder getCrl(String caName, BigInteger crlNumber) throws CaMgmtException {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        Args.notNull((Object)crlNumber, (String)"crlNumber");
        X509Ca ca = this.getX509Ca(caName);
        try {
            X509CRLHolder crl = ca.getCrl(crlNumber);
            if (crl == null) {
                LOG.warn("found no CRL for CA {} and crlNumber {}", (Object)caName, (Object)crlNumber);
            }
            return crl;
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    public X509CRLHolder getCurrentCrl(String caName) throws CaMgmtException {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        X509Ca ca = this.getX509Ca(caName);
        try {
            X509CRLHolder crl = ca.getCurrentCrl();
            if (crl == null) {
                LOG.warn("found no CRL for CA {}", (Object)caName);
            }
            return crl;
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    public ScepResponder getScepResponder(String name) {
        name = Args.toNonBlankLower((String)name, (String)"name");
        return this.scepResponders == null ? null : this.scepResponders.get(name);
    }

    static String canonicalizeSignerConf(String keystoreType, String signerConf, X509Cert[] certChain, SecurityFactory securityFactory) throws CaMgmtException {
        byte[] ksBytes;
        if (!signerConf.contains("file:") && !signerConf.contains("base64:")) {
            return signerConf;
        }
        ConfPairs pairs = new ConfPairs(signerConf);
        String algo = pairs.value("algo");
        if (algo != null) {
            try {
                algo = AlgorithmUtil.canonicalizeSignatureAlgo((String)algo);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new CaMgmtException("Unknown signature algo: " + ex.getMessage(), (Throwable)ex);
            }
            pairs.putPair("algo", algo);
        }
        String keystoreConf = pairs.value("keystore");
        String passwordHint = pairs.value("password");
        String keyLabel = pairs.value("key-label");
        if (StringUtil.startsWithIgnoreCase((String)keystoreConf, (String)"file:")) {
            String keystoreFile = keystoreConf.substring("file:".length());
            try {
                ksBytes = IoUtil.read((String)keystoreFile);
            }
            catch (IOException ex) {
                throw new CaMgmtException("IOException: " + ex.getMessage(), (Throwable)ex);
            }
        } else if (StringUtil.startsWithIgnoreCase((String)keystoreConf, (String)"base64:")) {
            ksBytes = Base64.decode((String)keystoreConf.substring("base64:".length()));
        } else {
            return signerConf;
        }
        try {
            char[] password = securityFactory.getPasswordResolver().resolvePassword(passwordHint);
            ksBytes = securityFactory.extractMinimalKeyStore(keystoreType, ksBytes, keyLabel, password, certChain);
        }
        catch (KeyStoreException ex) {
            throw new CaMgmtException("KeyStoreException: " + ex.getMessage(), (Throwable)ex);
        }
        catch (PasswordResolverException ex) {
            throw new CaMgmtException("PasswordResolverException: " + ex.getMessage(), (Throwable)ex);
        }
        pairs.putPair("keystore", "base64:" + Base64.encodeToString((byte[])ksBytes));
        return pairs.getEncoded();
    }

    public CertWithRevocationInfo getCert(String caName, BigInteger serialNumber) throws CaMgmtException {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        Args.notNull((Object)serialNumber, (String)"serialNumber");
        X509Ca ca = this.getX509Ca(caName);
        try {
            return ca.getCertWithRevocationInfo(serialNumber);
        }
        catch (CertificateException | OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), ex);
        }
    }

    public CertWithRevocationInfo getCert(X500Name issuer, BigInteger serialNumber) throws CaMgmtException {
        Args.notNull((Object)issuer, (String)"issuer");
        Args.notNull((Object)serialNumber, (String)"serialNumber");
        NameId caId = null;
        for (String name : this.caInfos.keySet()) {
            CaInfo ca = this.caInfos.get(name);
            if (!issuer.equals((Object)this.caInfos.get(name).getCert().getSubject())) continue;
            caId = ca.getIdent();
            break;
        }
        if (caId == null) {
            return null;
        }
        try {
            return this.certstore.getCertWithRevocationInfo(caId.getId(), serialNumber, this.idNameMap);
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    public byte[] getCertRequest(String caName, BigInteger serialNumber) throws CaMgmtException {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        Args.notNull((Object)serialNumber, (String)"serialNumber");
        X509Ca ca = this.getX509Ca(caName);
        try {
            return ca.getCertRequest(serialNumber);
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    public List<CertListInfo> listCertificates(String caName, X500Name subjectPattern, Date validFrom, Date validTo, CertListOrderBy orderBy, int numEntries) throws CaMgmtException {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        Args.range((int)numEntries, (String)"numEntries", (int)1, (int)1000);
        X509Ca ca = this.getX509Ca(caName);
        try {
            return ca.listCerts(subjectPattern, validFrom, validTo, orderBy, numEntries);
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void refreshTokenForSignerType(String signerType) throws CaMgmtException {
        try {
            this.securityFactory.refreshTokenForSignerType(signerType);
        }
        catch (XiSecurityException ex) {
            throw new CaMgmtException("could not refresh token for signer type " + signerType + ": " + ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, X509Cert> loadConf(InputStream zippedConfStream) throws CaMgmtException {
        MgmtEntry.Requestor entryB;
        MgmtEntry.Requestor entry;
        CaConf conf;
        Args.notNull((Object)zippedConfStream, (String)"zippedConfStream");
        this.assertMasterModeAndSetuped();
        try {
            conf = new CaConf(zippedConfStream, this.securityFactory);
        }
        catch (IOException | InvalidConfException ex) {
            throw new CaMgmtException("could not parse the CA configuration", ex);
        }
        catch (RuntimeException ex) {
            throw new CaMgmtException("caught RuntimeException while parsing the CA configuration", (Throwable)ex);
        }
        HashMap<String, X509Cert> generatedRootCerts = new HashMap<String, X509Cert>(2);
        for (String name : conf.getSignerNames()) {
            MgmtEntry.Signer entry2 = conf.getSigner(name);
            MgmtEntry.Signer entryB2 = this.signerDbEntries.get(name);
            if (entryB2 != null) {
                if (!entry2.equals((Object)entryB2)) throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("signer ", name, " existed, could not re-added it"));
                LOG.info("ignore existed signer {}", (Object)name);
                continue;
            }
            try {
                this.addSigner(entry2);
                LOG.info("added signer {}", (Object)name);
            }
            catch (CaMgmtException ex) {
                String msg = CaManagerImpl.concat("could not add signer ", name);
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                throw new CaMgmtException(msg);
            }
        }
        boolean ignoreId = true;
        for (String name : conf.getRequestorNames()) {
            entry = conf.getRequestor(name);
            entryB = this.requestorDbEntries.get(name);
            if (entryB != null) {
                if (!entry.equals(entryB, true)) throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("CMP requestor ", name, " existed, could not re-added it"));
                LOG.info("ignore existed CMP requestor {}", (Object)name);
                continue;
            }
            try {
                this.addRequestor(entry);
                LOG.info("added CMP requestor {}", (Object)name);
            }
            catch (CaMgmtException ex) {
                String msg = CaManagerImpl.concat("could not add CMP requestor ", name);
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                throw new CaMgmtException(msg);
            }
        }
        for (String name : conf.getPublisherNames()) {
            entry = conf.getPublisher(name);
            entryB = this.publisherDbEntries.get(name);
            if (entryB != null) {
                if (!entry.equals((MgmtEntry.Publisher)entryB, true)) throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("publisher ", name, " existed, could not re-added it"));
                LOG.info("ignore existed publisher {}", (Object)name);
                continue;
            }
            try {
                this.addPublisher((MgmtEntry.Publisher)entry);
                LOG.info("added publisher {}", (Object)name);
            }
            catch (CaMgmtException ex) {
                String msg = "could not add publisher " + name;
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                throw new CaMgmtException(msg);
            }
        }
        for (String name : conf.getCertprofileNames()) {
            entry = conf.getCertprofile(name);
            entryB = this.certprofileDbEntries.get(name);
            if (entryB != null) {
                if (!entry.equals((MgmtEntry.Certprofile)entryB, true)) throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("certprofile ", name, " existed, could not re-added it"));
                LOG.info("ignore existed certprofile {}", (Object)name);
                continue;
            }
            try {
                this.addCertprofile((MgmtEntry.Certprofile)entry);
                LOG.info("added certprofile {}", (Object)name);
            }
            catch (CaMgmtException ex) {
                String msg = CaManagerImpl.concat("could not add certprofile ", name);
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                throw new CaMgmtException(msg);
            }
        }
        for (String name : conf.getUserNames()) {
            Object obj = conf.getUser(name);
            entryB = this.queryExecutor.getUser(name, true);
            if (entryB != null) {
                MgmtEntry.User entry3;
                boolean equals = false;
                if (obj instanceof MgmtEntry.User) {
                    entry3 = (MgmtEntry.User)obj;
                    equals = entry3.equals((MgmtEntry.User)entryB, true);
                } else {
                    entry3 = (MgmtEntry.AddUser)obj;
                    equals = PasswordHash.validatePassword(entry3.getPassword(), entryB.getHashedPassword());
                }
                if (!equals) throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("user ", name, " existed, could not re-added it"));
                LOG.info("ignore existed user {}", (Object)name);
                continue;
            }
            try {
                if (obj instanceof MgmtEntry.User) {
                    this.queryExecutor.addUser((MgmtEntry.User)obj);
                } else {
                    this.queryExecutor.addUser((MgmtEntry.AddUser)obj);
                }
                LOG.info("added user {}", (Object)name);
            }
            catch (CaMgmtException ex) {
                String msg = CaManagerImpl.concat("could not add user ", name);
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                throw new CaMgmtException(msg);
            }
        }
        for (String caName : conf.getCaNames()) {
            String msg;
            CaConf.SingleCa scc = conf.getCa(caName);
            CaConf.GenSelfIssued genSelfIssued = scc.getGenSelfIssued();
            MgmtEntry.Ca caEntry = scc.getCaEntry();
            if (caEntry != null) {
                if (this.caInfos.containsKey(caName)) {
                    MgmtEntry.Ca entryB3 = this.caInfos.get(caName).getCaEntry();
                    if (caEntry.getCert() == null && genSelfIssued != null) {
                        ConcurrentContentSigner signer;
                        SignerConf signerConf = new SignerConf(caEntry.getSignerConf());
                        try {
                            signer = this.securityFactory.createSigner(caEntry.getSignerType(), signerConf, (X509Cert)null);
                        }
                        catch (ObjectCreationException ex) {
                            throw new CaMgmtException(CaManagerImpl.concat("could not create signer for CA ", caName), (Throwable)ex);
                        }
                        caEntry.setCert(signer.getCertificate());
                    }
                    if (!caEntry.equals(entryB3, true, true)) throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("CA ", caName, " existed, could not re-added it"));
                    LOG.info("ignore existing CA {}", (Object)caName);
                } else if (genSelfIssued != null) {
                    X509Cert cert = this.generateRootCa(caEntry, genSelfIssued.getProfile(), genSelfIssued.getCsr(), genSelfIssued.getSerialNumber());
                    LOG.info("generated root CA {}", (Object)caName);
                    generatedRootCerts.put(caName, cert);
                } else {
                    try {
                        this.addCa(caEntry);
                        LOG.info("added CA {}", (Object)caName);
                    }
                    catch (CaMgmtException ex) {
                        String msg2 = CaManagerImpl.concat("could not add CA ", caName);
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg2);
                        throw new CaMgmtException(msg2);
                    }
                }
            }
            if (scc.getAliases() != null) {
                Set<String> aliasesB = this.getAliasesForCa(caName);
                for (String aliasName : scc.getAliases()) {
                    if (aliasesB != null && aliasesB.contains(aliasName)) {
                        LOG.info("ignored adding existing CA alias {} to CA {}", (Object)aliasName, (Object)caName);
                        continue;
                    }
                    try {
                        this.addCaAlias(aliasName, caName);
                        LOG.info("associated alias {} to CA {}", (Object)aliasName, (Object)caName);
                    }
                    catch (CaMgmtException ex) {
                        msg = CaManagerImpl.concat("could not associate alias ", aliasName, " to CA ", caName);
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                        throw new CaMgmtException(msg);
                    }
                }
            }
            if (scc.getProfileNames() != null) {
                Set<String> profilesB = this.caHasProfiles.get(caName);
                for (String profileName : scc.getProfileNames()) {
                    if (profilesB != null && profilesB.contains(profileName)) {
                        LOG.info("ignored adding certprofile {} to CA {}", (Object)profileName, (Object)caName);
                        continue;
                    }
                    try {
                        this.addCertprofileToCa(profileName, caName);
                        LOG.info("added certprofile {} to CA {}", (Object)profileName, (Object)caName);
                    }
                    catch (CaMgmtException ex) {
                        msg = CaManagerImpl.concat("could not add certprofile ", profileName, " to CA ", caName);
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                        throw new CaMgmtException(msg);
                    }
                }
            }
            if (scc.getPublisherNames() != null) {
                Set<String> publishersB = this.caHasPublishers.get(caName);
                for (String publisherName : scc.getPublisherNames()) {
                    if (publishersB != null && publishersB.contains(publisherName)) {
                        LOG.info("ignored adding publisher {} to CA {}", (Object)publisherName, (Object)caName);
                        continue;
                    }
                    try {
                        this.addPublisherToCa(publisherName, caName);
                        LOG.info("added publisher {} to CA {}", (Object)publisherName, (Object)caName);
                    }
                    catch (CaMgmtException ex) {
                        msg = CaManagerImpl.concat("could not add publisher ", publisherName, " to CA ", caName);
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                        throw new CaMgmtException(msg);
                    }
                }
            }
            if (scc.getRequestors() != null) {
                Set<MgmtEntry.CaHasRequestor> requestorsB = this.caHasRequestors.get(caName);
                for (MgmtEntry.CaHasRequestor requestor : scc.getRequestors()) {
                    String requestorName = requestor.getRequestorIdent().getName();
                    MgmtEntry.CaHasRequestor requestorB = null;
                    if (requestorsB != null) {
                        for (MgmtEntry.CaHasRequestor caHasRequestor : requestorsB) {
                            if (!caHasRequestor.getRequestorIdent().getName().equals(requestorName)) continue;
                            requestorB = caHasRequestor;
                            break;
                        }
                    }
                    if (requestorB != null) {
                        if (!requestor.equals(requestorB, true)) throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("could not add requestor ", requestorName, " to CA", caName));
                        LOG.info("ignored adding requestor {} to CA {}", (Object)requestorName, (Object)caName);
                        continue;
                    }
                    try {
                        this.addRequestorToCa(requestor, caName);
                        LOG.info("added publisher {} to CA {}", (Object)requestorName, (Object)caName);
                    }
                    catch (CaMgmtException ex) {
                        String string = CaManagerImpl.concat("could not add requestor ", requestorName, " to CA ", caName);
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)string);
                        throw new CaMgmtException(string);
                    }
                }
            }
            if (scc.getUsers() == null) continue;
            List<MgmtEntry.CaHasUser> usersB = this.queryExecutor.getCaHasUsersForCa(caName, this.idNameMap);
            for (MgmtEntry.CaHasUser user : scc.getUsers()) {
                String userName = user.getUserIdent().getName();
                MgmtEntry.CaHasUser userB = null;
                if (usersB != null) {
                    for (MgmtEntry.CaHasUser caHasUser : usersB) {
                        if (!caHasUser.getUserIdent().getName().equals(userName)) continue;
                        userB = caHasUser;
                        break;
                    }
                }
                if (userB != null) {
                    if (!user.equals(userB, true)) throw CaManagerImpl.logAndCreateException(CaManagerImpl.concat("could not add user ", userName, " to CA", caName));
                    LOG.info("ignored adding user {} to CA {}", (Object)userName, (Object)caName);
                    continue;
                }
                try {
                    this.addUserToCa(user, caName);
                    LOG.info("added user {} to CA {}", (Object)userName, (Object)caName);
                }
                catch (CaMgmtException ex) {
                    String string = CaManagerImpl.concat("could not add user ", userName, " to CA ", caName);
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)string);
                    throw new CaMgmtException(string);
                }
            }
        }
        if (generatedRootCerts.isEmpty()) {
            return null;
        }
        HashMap<String, X509Cert> hashMap = generatedRootCerts;
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream exportConf(List<String> caNames) throws CaMgmtException, IOException {
        ArrayList<String> tmpCaNames;
        this.assertMasterModeAndSetuped();
        if (caNames != null) {
            tmpCaNames = new ArrayList<String>(caNames.size());
            for (String name : caNames) {
                if (!this.x509cas.containsKey(name = name.toLowerCase())) continue;
                tmpCaNames.add(name);
            }
            caNames = tmpCaNames;
        } else {
            tmpCaNames = new ArrayList(this.x509cas.size());
            for (String name : this.x509cas.keySet()) {
                tmpCaNames.add(name);
            }
            caNames = tmpCaNames;
        }
        ByteArrayOutputStream bytesStream = new ByteArrayOutputStream(0x100000);
        ZipOutputStream zipStream = new ZipOutputStream(bytesStream);
        zipStream.setLevel(1);
        CaConfType.CaSystem root = new CaConfType.CaSystem();
        try {
            CaConfType.NameTypeConf conf;
            MgmtEntry.Requestor entry;
            LinkedList<Object> list;
            HashSet<String> includeSignerNames = new HashSet<String>();
            HashSet<String> includeRequestorNames = new HashSet<String>();
            HashSet<String> includeProfileNames = new HashSet<String>();
            HashSet<String> includePublisherNames = new HashSet<String>();
            HashSet<String> includeCrlSignerNames = new HashSet<String>();
            HashSet<String> includeUserNames = new HashSet<String>();
            LinkedList<CaConfType.User> users = new LinkedList<CaConfType.User>();
            root.setUsers(users);
            if (CollectionUtil.isNotEmpty(caNames)) {
                list = new LinkedList<Object>();
                for (String name : this.x509cas.keySet()) {
                    List<MgmtEntry.CaHasUser> caHasUsers;
                    Set<MgmtEntry.CaHasRequestor> requestors;
                    if (!caNames.contains(name)) continue;
                    CaConfType.Ca ca = new CaConfType.Ca();
                    ca.setName(name);
                    Set<String> strs = this.getAliasesForCa(name);
                    if (CollectionUtil.isNotEmpty(strs)) {
                        ca.setAliases(new ArrayList<String>(strs));
                    }
                    if (CollectionUtil.isNotEmpty(requestors = this.caHasRequestors.get(name))) {
                        ca.setRequestors(new ArrayList());
                        for (MgmtEntry.CaHasRequestor caHasRequestor : requestors) {
                            String requestorName = caHasRequestor.getRequestorIdent().getName();
                            includeRequestorNames.add(requestorName);
                            CaConfType.CaHasRequestor chr = new CaConfType.CaHasRequestor();
                            chr.setRequestorName(requestorName);
                            chr.setRa(caHasRequestor.isRa());
                            chr.setProfiles(new ArrayList(caHasRequestor.getProfiles()));
                            chr.setPermissions(CaManagerImpl.getPermissions(caHasRequestor.getPermission()));
                            ca.getRequestors().add(chr);
                        }
                    }
                    if (CollectionUtil.isNotEmpty(caHasUsers = this.queryExecutor.getCaHasUsersForCa(name, this.idNameMap))) {
                        ca.setUsers(new ArrayList());
                        for (MgmtEntry.CaHasUser m2 : caHasUsers) {
                            String username = m2.getUserIdent().getName();
                            CaConfType.CaHasUser chu = new CaConfType.CaHasUser();
                            chu.setUserName(username);
                            chu.setProfiles(new ArrayList(m2.getProfiles()));
                            chu.setPermissions(CaManagerImpl.getPermissions(m2.getPermission()));
                            ca.getUsers().add(chu);
                            if (includeUserNames.contains(username)) continue;
                            MgmtEntry.User userEntry = this.queryExecutor.getUser(username);
                            CaConfType.User userType = new CaConfType.User();
                            if (!userEntry.isActive()) {
                                userType.setActive(Boolean.FALSE);
                            }
                            userType.setName(username);
                            userType.setHashedPassword(userEntry.getHashedPassword());
                            users.add(userType);
                            includeUserNames.add(username);
                        }
                    }
                    if (CollectionUtil.isNotEmpty(strs = this.caHasProfiles.get(name))) {
                        includeProfileNames.addAll(strs);
                        ca.setProfiles(new ArrayList<String>(strs));
                    }
                    if (CollectionUtil.isNotEmpty(strs = this.caHasPublishers.get(name))) {
                        includePublisherNames.addAll(strs);
                        ca.setPublishers(new ArrayList<String>(strs));
                    }
                    CaConfType.CaInfo caInfo = new CaConfType.CaInfo();
                    ca.setCaInfo(caInfo);
                    MgmtEntry.Ca entry2 = this.x509cas.get(name).getCaInfo().getCaEntry();
                    CaUris caUris = entry2.getCaUris();
                    if (caUris != null) {
                        CaConfType.CaUris caUrisType = new CaConfType.CaUris();
                        caUrisType.setCacertUris(caUris.getCacertUris());
                        caUrisType.setOcspUris(caUris.getOcspUris());
                        caUrisType.setCrlUris(caUris.getCrlUris());
                        caUrisType.setDeltacrlUris(caUris.getDeltaCrlUris());
                        caInfo.setCaUris(caUrisType);
                    }
                    byte[] certBytes = entry2.getCert().getEncoded();
                    caInfo.setCert(CaManagerImpl.createFileOrBinary(zipStream, certBytes, CaManagerImpl.concat("files/ca-", name, "-cert.der")));
                    List certchain = entry2.getCertchain();
                    if (CollectionUtil.isNotEmpty((Collection)certchain)) {
                        LinkedList<FileOrBinary> ccList = new LinkedList<FileOrBinary>();
                        for (int i = 0; i < certchain.size(); ++i) {
                            certBytes = ((X509Cert)certchain.get(i)).getEncoded();
                            ccList.add(CaManagerImpl.createFileOrBinary(zipStream, certBytes, CaManagerImpl.concat("files/ca-", name, "-certchain-" + i + ".der")));
                        }
                        caInfo.setCertchain(ccList);
                    }
                    if (entry2.getCmpControl() != null) {
                        caInfo.setCmpControl(new HashMap(new ConfPairs(entry2.getCmpControl().getConf()).asMap()));
                    }
                    if (entry2.getCmpResponderName() != null) {
                        includeSignerNames.add(entry2.getCmpResponderName());
                        caInfo.setCmpResponderName(entry2.getCmpResponderName());
                    }
                    if (entry2.getCrlControl() != null) {
                        caInfo.setCrlControl(new HashMap(new ConfPairs(entry2.getCrlControl().getConf()).asMap()));
                    }
                    if (entry2.getCrlSignerName() != null) {
                        includeCrlSignerNames.add(entry2.getCrlSignerName());
                        caInfo.setCrlSignerName(entry2.getCrlSignerName());
                    }
                    if (entry2.getCtlogControl() != null) {
                        caInfo.setCtlogControl(new HashMap(new ConfPairs(entry2.getCtlogControl().getConf()).asMap()));
                    }
                    if (entry2.getDhpocControl() != null) {
                        FileOrValue fv = CaManagerImpl.createFileOrValue(zipStream, entry2.getDhpocControl(), CaManagerImpl.concat("files/ca-", name, "-dhpoc.conf"));
                        caInfo.setDhpocControl(fv);
                    }
                    caInfo.setExpirationPeriod(Integer.valueOf(entry2.getExpirationPeriod()));
                    if (entry2.getExtraControl() != null) {
                        caInfo.setExtraControl(entry2.getExtraControl().asMap());
                    }
                    caInfo.setKeepExpiredCertDays(Integer.valueOf(entry2.getKeepExpiredCertInDays()));
                    caInfo.setMaxValidity(entry2.getMaxValidity().toString());
                    caInfo.setNextCrlNo(entry2.getNextCrlNumber());
                    caInfo.setNumCrls(Integer.valueOf(entry2.getNumCrls()));
                    caInfo.setPermissions(CaManagerImpl.getPermissions(entry2.getPermission()));
                    caInfo.setProtocolSupport(StringUtil.splitAsSet((String)entry2.getProtocoSupport().getEncoded(), (String)","));
                    if (entry2.getRevokeSuspendedControl() != null) {
                        caInfo.setRevokeSuspendedControl(new HashMap(new ConfPairs(entry2.getRevokeSuspendedControl().getConf()).asMap()));
                    }
                    caInfo.setSaveReq(entry2.isSaveRequest());
                    if (entry2.getScepControl() != null) {
                        caInfo.setScepControl(new HashMap(new ConfPairs(entry2.getScepControl().getConf()).asMap()));
                    }
                    if (entry2.getScepResponderName() != null) {
                        includeSignerNames.add(entry2.getScepResponderName());
                        caInfo.setScepResponderName(entry2.getScepResponderName());
                    }
                    caInfo.setSignerConf(CaManagerImpl.createFileOrValue(zipStream, entry2.getSignerConf(), CaManagerImpl.concat("files/ca-", name, "-signerconf.conf")));
                    caInfo.setSignerType(entry2.getSignerType());
                    caInfo.setSnSize(entry2.getSerialNoLen());
                    caInfo.setStatus(entry2.getStatus().getStatus());
                    caInfo.setValidityMode(entry2.getValidityMode().name());
                    list.add(ca);
                }
                if (!list.isEmpty()) {
                    root.setCas(list);
                }
            }
            if (users.isEmpty()) {
                root.setUsers(null);
            }
            if (CollectionUtil.isNotEmpty(this.requestorDbEntries)) {
                list = new LinkedList();
                for (String name : this.requestorDbEntries.keySet()) {
                    if (!includeRequestorNames.contains(name)) continue;
                    entry = this.requestorDbEntries.get(name);
                    CaConfType.Requestor type = new CaConfType.Requestor();
                    type.setName(name);
                    type.setType(entry.getType());
                    if ("cert".equalsIgnoreCase(entry.getType())) {
                        FileOrBinary fob = CaManagerImpl.createFileOrBinary(zipStream, Base64.decode((String)entry.getConf()), CaManagerImpl.concat("files/requestor-", name, ".der"));
                        type.setBinaryConf(fob);
                    } else {
                        FileOrValue fov = CaManagerImpl.createFileOrValue(zipStream, entry.getConf(), CaManagerImpl.concat("files/requestor-", name, ".conf"));
                        type.setConf(fov);
                    }
                    list.add(type);
                }
                if (!list.isEmpty()) {
                    root.setRequestors(list);
                }
            }
            if (CollectionUtil.isNotEmpty(this.publisherDbEntries)) {
                list = new LinkedList();
                for (String name : this.publisherDbEntries.keySet()) {
                    if (!includePublisherNames.contains(name)) continue;
                    entry = this.publisherDbEntries.get(name);
                    conf = new CaConfType.NameTypeConf();
                    conf.setName(name);
                    conf.setType(entry.getType());
                    conf.setConf(CaManagerImpl.createFileOrValue(zipStream, entry.getConf(), CaManagerImpl.concat("files/publisher-", name, ".conf")));
                    list.add(conf);
                }
                if (!list.isEmpty()) {
                    root.setPublishers(list);
                }
            }
            if (CollectionUtil.isNotEmpty(this.certprofileDbEntries)) {
                list = new LinkedList();
                for (String name : this.certprofileDbEntries.keySet()) {
                    if (!includeProfileNames.contains(name)) continue;
                    entry = this.certprofileDbEntries.get(name);
                    conf = new CaConfType.NameTypeConf();
                    conf.setName(name);
                    conf.setType(entry.getType());
                    conf.setConf(CaManagerImpl.createFileOrValue(zipStream, entry.getConf(), CaManagerImpl.concat("files/certprofile-", name, ".conf")));
                    list.add(conf);
                }
                if (!list.isEmpty()) {
                    root.setProfiles(list);
                }
            }
            if (CollectionUtil.isNotEmpty(this.signerDbEntries)) {
                list = new LinkedList();
                for (String name : this.signerDbEntries.keySet()) {
                    if (!includeSignerNames.contains(name)) continue;
                    entry = this.signerDbEntries.get(name);
                    conf = new CaConfType.Signer();
                    conf.setName(name);
                    conf.setType(entry.getType());
                    conf.setConf(CaManagerImpl.createFileOrValue(zipStream, entry.getConf(), CaManagerImpl.concat("files/signer-", name, ".conf")));
                    conf.setCert(CaManagerImpl.createFileOrBase64Value(zipStream, entry.getBase64Cert(), CaManagerImpl.concat("files/signer-", name, ".der")));
                    list.add(conf);
                }
                if (!list.isEmpty()) {
                    root.setSigners(list);
                }
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                root.validate();
                JSON.writeJSONString((OutputStream)bout, (Object)root, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
            }
            catch (InvalidConfException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not marshal CAConf");
                throw new CaMgmtException(CaManagerImpl.concat("could not marshal CAConf: ", ex.getMessage()), (Throwable)ex);
            }
            finally {
                bout.flush();
            }
            zipStream.putNextEntry(new ZipEntry("caconf.json"));
            try {
                zipStream.write(bout.toByteArray());
            }
            finally {
                zipStream.closeEntry();
            }
        }
        finally {
            zipStream.flush();
            zipStream.close();
        }
        return new ByteArrayInputStream(bytesStream.toByteArray());
    }

    public CtLogPublicKeyFinder getCtLogPublicKeyFinder() {
        return this.ctLogPublicKeyFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileOrValue createFileOrValue(ZipOutputStream zipStream, String content, String fileName) throws IOException {
        if (StringUtil.isBlank((String)content)) {
            return null;
        }
        FileOrValue ret = new FileOrValue();
        if (content.length() < 256) {
            ret.setValue(content);
        } else {
            ret.setFile(fileName);
            ZipEntry certZipEntry = new ZipEntry(fileName);
            zipStream.putNextEntry(certZipEntry);
            try {
                zipStream.write(StringUtil.toUtf8Bytes((String)content));
            }
            finally {
                zipStream.closeEntry();
            }
        }
        return ret;
    }

    private static FileOrBinary createFileOrBase64Value(ZipOutputStream zipStream, String b64Content, String fileName) throws IOException {
        if (StringUtil.isBlank((String)b64Content)) {
            return null;
        }
        return CaManagerImpl.createFileOrBinary(zipStream, Base64.decode((String)b64Content), fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileOrBinary createFileOrBinary(ZipOutputStream zipStream, byte[] content, String fileName) throws IOException {
        if (content == null || content.length == 0) {
            return null;
        }
        FileOrBinary ret = new FileOrBinary();
        if (content.length < 256) {
            ret.setBinary(content);
        } else {
            ret.setFile(fileName);
            ZipEntry certZipEntry = new ZipEntry(fileName);
            zipStream.putNextEntry(certZipEntry);
            try {
                zipStream.write(content);
            }
            finally {
                zipStream.closeEntry();
            }
        }
        return ret;
    }

    public RestResponder getRestResponder() {
        return this.restResponder;
    }

    private static String concat(String s1, String ... strs) {
        return StringUtil.concat((String)s1, (String[])strs);
    }

    private static CaMgmtException logAndCreateException(String msg) {
        LOG.error(msg);
        return new CaMgmtException(msg);
    }

    private static List<String> getPermissions(int permission) {
        LinkedList<String> list = new LinkedList<String>();
        if (511 == permission) {
            list.add(PermissionConstants.getTextForCode((int)permission));
        } else {
            for (Integer code : PermissionConstants.getPermissions()) {
                if ((permission & code) == 0) continue;
                list.add(PermissionConstants.getTextForCode((int)code));
            }
        }
        return list;
    }

    static {
        String ver;
        LOG = LoggerFactory.getLogger(CaManagerImpl.class);
        try {
            ver = new String(IoUtil.read((InputStream)CaManagerImpl.class.getResourceAsStream("/version"))).trim();
        }
        catch (Exception ex) {
            ver = "UNKNOWN";
        }
        version = ver;
    }

    private class CaRestarter
    implements Runnable {
        private boolean inProcess;

        private CaRestarter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.inProcess) {
                return;
            }
            this.inProcess = true;
            try {
                CaManagerQueryExecutor.SystemEvent event = CaManagerImpl.this.queryExecutor.getSystemEvent(CaManagerImpl.EVENT_CACHAGNE);
                long caChangedTime = event == null ? 0L : event.getEventTime();
                LOG.info("check the restart CA system event: changed at={}, lastStartTime={}", (Object)new Date(caChangedTime * 1000L), (Object)CaManagerImpl.this.lastStartTime);
                if (caChangedTime > CaManagerImpl.this.lastStartTime.getTime() / 1000L) {
                    LOG.info("received event to restart CA");
                    CaManagerImpl.this.restartCaSystem();
                } else {
                    LOG.debug("received no event to restart CA");
                }
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"ScheduledCaRestarter");
            }
            finally {
                this.inProcess = false;
            }
        }
    }

    private class UnreferencedRequstCleaner
    implements Runnable {
        private boolean inProcess;

        private UnreferencedRequstCleaner() {
        }

        @Override
        public void run() {
            if (this.inProcess) {
                return;
            }
            this.inProcess = true;
            try {
                try {
                    CaManagerImpl.this.certstore.deleteUnreferencedRequests();
                    LOG.info("deleted unreferenced requests");
                }
                catch (Throwable th) {
                    LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not delete unreferenced requests");
                }
            }
            finally {
                this.inProcess = false;
            }
        }
    }

    private class CertsInQueuePublisher
    implements Runnable {
        private boolean inProcess;

        private CertsInQueuePublisher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.inProcess || !CaManagerImpl.this.caSystemSetuped) {
                return;
            }
            this.inProcess = true;
            try {
                LOG.debug("publishing certificates in PUBLISHQUEUE");
                for (String name : CaManagerImpl.this.x509cas.keySet()) {
                    X509Ca ca = (X509Ca)CaManagerImpl.this.x509cas.get(name);
                    boolean bo = ca.publishCertsInQueue();
                    if (bo) {
                        LOG.info(" published certificates of CA {} in PUBLISHQUEUE", (Object)name);
                        continue;
                    }
                    LOG.error("publishing certificates of CA {} in PUBLISHQUEUE failed", (Object)name);
                }
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not publish CertsInQueue");
            }
            finally {
                this.inProcess = false;
            }
        }
    }
}

