/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.OperationException;
import org.xipki.ca.api.RequestType;
import org.xipki.ca.api.mgmt.CertListInfo;
import org.xipki.ca.api.mgmt.CertListOrderBy;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.api.mgmt.MgmtEntry;
import org.xipki.ca.server.CaIdNameMap;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.CertRevInfoWithSerial;
import org.xipki.ca.server.PasswordHash;
import org.xipki.ca.server.UniqueIdGenerator;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.security.HashAlgo;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.LogUtil;
import org.xipki.util.LruCache;
import org.xipki.util.StringUtil;

public class CertStore {
    private static final Logger LOG = LoggerFactory.getLogger(CertStore.class);
    private static final String SQL_ADD_CERT_V4 = "INSERT INTO CERT (ID,LUPDATE,SN,SUBJECT,FP_S,FP_RS,NBEFORE,NAFTER,REV,PID,CA_ID,RID,UID,EE,RTYPE,TID,SHA1,REQ_SUBJECT,CRL_SCOPE,CERT,FP_K) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,0)";
    private static final String SQL_ADD_CERT = "INSERT INTO CERT (ID,LUPDATE,SN,SUBJECT,FP_S,FP_RS,NBEFORE,NAFTER,REV,PID,CA_ID,RID,UID,EE,RTYPE,TID,SHA1,REQ_SUBJECT,CRL_SCOPE,CERT) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SQL_REVOKE_CERT = "UPDATE CERT SET LUPDATE=?,REV=?,RT=?,RIT=?,RR=? WHERE ID=?";
    private static final String SQL_REVOKE_SUSPENDED_CERT = "UPDATE CERT SET LUPDATE=?,RR=? WHERE ID=?";
    private static final String SQL_INSERT_PUBLISHQUEUE = "INSERT INTO PUBLISHQUEUE (PID,CA_ID,CID) VALUES (?,?,?)";
    private static final String SQL_REMOVE_PUBLISHQUEUE = "DELETE FROM PUBLISHQUEUE WHERE PID=? AND CID=?";
    private static final String SQL_MAXID_DELTACRL_CACHE = "SELECT MAX(ID) FROM DELTACRL_CACHE WHERE CA_ID=?";
    private static final String SQL_CLEAR_DELTACRL_CACHE = "DELETE FROM DELTACRL_CACHE WHERE ID<? AND CA_ID=?";
    private static final String SQL_MAX_CRLNO = "SELECT MAX(CRL_NO) FROM CRL WHERE CA_ID=?";
    private static final String SQL_MAX_FULL_CRLNO = "SELECT MAX(CRL_NO) FROM CRL WHERE CA_ID=? AND DELTACRL = 0";
    private static final String SQL_MAX_THISUPDAATE_CRL = "SELECT MAX(THISUPDATE) FROM CRL WHERE CA_ID=? AND DELTACRL=?";
    private static final String SQL_ADD_CRL = "INSERT INTO CRL (ID,CA_ID,CRL_NO,THISUPDATE,NEXTUPDATE,DELTACRL,BASECRL_NO,CRL_SCOPE,CRL) VALUES (?,?,?,?,?,?,?,?,?)";
    private static final String SQL_ADD_DELTACRL_CACHE = "INSERT INTO DELTACRL_CACHE (ID,CA_ID,SN) VALUES (?,?,?)";
    private static final String SQL_REMOVE_CERT = "DELETE FROM CERT WHERE CA_ID=? AND SN=?";
    private static final String SQL_DELETE_UNREFERENCED_REQUEST = "DELETE FROM REQUEST WHERE ID NOT IN (SELECT req.RID FROM REQCERT req)";
    private static final String SQL_ADD_REQUEST = "INSERT INTO REQUEST (ID,LUPDATE,DATA) VALUES(?,?,?)";
    private static final String SQL_ADD_REQCERT = "INSERT INTO REQCERT (ID,RID,CID) VALUES(?,?,?)";
    private final String sqlCaHasCrl;
    private final String sqlCertForId;
    private final String sqlCertWithRevInfo;
    private final String sqlCertInfo;
    private final String sqlCertprofileForCertId;
    private final String sqlActiveUserInfoForName;
    private final String sqlActiveUserNameForId;
    private final String sqlCaHasUser;
    private final String sqlKnowsCertForSerial;
    private final String sqlRevForId;
    private final String sqlCertStatusForSubjectFp;
    private final String sqlCertforSubjectIssued;
    private final String sqlLatestSerialForSubjectLike;
    private final String sqlCrl;
    private final String sqlCrlWithNo;
    private final String sqlReqIdForSerial;
    private final String sqlReqForId;
    private final LruCache<Integer, String> cacheSqlCidFromPublishQueue = new LruCache(5);
    private final LruCache<Integer, String> cacheSqlExpiredSerials = new LruCache(5);
    private final LruCache<Integer, String> cacheSqlSuspendedSerials = new LruCache(5);
    private final LruCache<Integer, String> cacheSqlDeltaCrlCacheIds = new LruCache(5);
    private final LruCache<Integer, String> cacheSqlRevokedCerts = new LruCache(5);
    private final LruCache<Integer, String> cacheSqlRevokedCertsWithEe = new LruCache(5);
    private final LruCache<Integer, String> cacheSqlSerials = new LruCache(5);
    private final LruCache<Integer, String> cacheSqlSerialsRevoked = new LruCache(5);
    private final DataSourceWrapper datasource;
    private final int dbSchemaVersion;
    private final int maxX500nameLen;
    private final UniqueIdGenerator idGenerator;

    public CertStore(DataSourceWrapper datasource, UniqueIdGenerator idGenerator) throws DataAccessException {
        this.datasource = (DataSourceWrapper)Args.notNull((Object)datasource, (String)"datasource");
        this.idGenerator = (UniqueIdGenerator)Args.notNull((Object)idGenerator, (String)"idGenerator");
        DbSchemaInfo dbSchemaInfo = new DbSchemaInfo(datasource);
        this.dbSchemaVersion = Integer.parseInt(dbSchemaInfo.variableValue("VERSION"));
        this.maxX500nameLen = Integer.parseInt(dbSchemaInfo.variableValue("X500NAME_MAXLEN"));
        this.sqlCaHasCrl = this.buildSelectFirstSql("ID FROM CRL WHERE CA_ID=?");
        this.sqlCertForId = this.buildSelectFirstSql("PID,RID,REV,RR,RT,RIT,CERT FROM CERT WHERE ID=?");
        this.sqlCertWithRevInfo = this.buildSelectFirstSql("ID,REV,RR,RT,RIT,PID,CERT FROM CERT WHERE CA_ID=? AND SN=?");
        this.sqlCertInfo = this.buildSelectFirstSql("PID,RID,REV,RR,RT,RIT,CERT FROM CERT WHERE CA_ID=? AND SN=?");
        this.sqlCertprofileForCertId = this.buildSelectFirstSql("PID FROM CERT WHERE ID=? AND CA_ID=?");
        this.sqlActiveUserInfoForName = this.buildSelectFirstSql("ID,PASSWORD FROM TUSER WHERE NAME=? AND ACTIVE=1");
        this.sqlActiveUserNameForId = this.buildSelectFirstSql("NAME FROM TUSER WHERE ID=? AND ACTIVE=1");
        this.sqlCaHasUser = this.buildSelectFirstSql("PERMISSION,PROFILES FROM CA_HAS_USER WHERE CA_ID=? AND USER_ID=?");
        this.sqlKnowsCertForSerial = this.buildSelectFirstSql("UID FROM CERT WHERE SN=? AND CA_ID=?");
        this.sqlRevForId = this.buildSelectFirstSql("SN,EE,REV,RR,RT,RIT FROM CERT WHERE ID=?");
        this.sqlCertStatusForSubjectFp = this.buildSelectFirstSql("REV FROM CERT WHERE FP_S=? AND CA_ID=?");
        this.sqlCertforSubjectIssued = this.buildSelectFirstSql("ID FROM CERT WHERE CA_ID=? AND FP_S=?");
        this.sqlReqIdForSerial = this.buildSelectFirstSql("REQCERT.RID as REQ_ID FROM REQCERT INNER JOIN CERT ON CERT.CA_ID=? AND CERT.SN=? AND REQCERT.CID=CERT.ID");
        this.sqlReqForId = this.buildSelectFirstSql("DATA FROM REQUEST WHERE ID=?");
        this.sqlLatestSerialForSubjectLike = datasource.buildSelectFirstSql(1, "NBEFORE DESC", "SUBJECT FROM CERT WHERE SUBJECT LIKE ?");
        this.sqlCrl = datasource.buildSelectFirstSql(1, "THISUPDATE DESC", "THISUPDATE,CRL FROM CRL WHERE CA_ID=?");
        this.sqlCrlWithNo = datasource.buildSelectFirstSql(1, "THISUPDATE DESC", "THISUPDATE,CRL FROM CRL WHERE CA_ID=? AND CRL_NO=?");
    }

    private String buildSelectFirstSql(String coreSql) {
        return this.datasource.buildSelectFirstSql(1, coreSql);
    }

    public boolean addCert(CertificateInfo certInfo) {
        Args.notNull((Object)certInfo, (String)"certInfo");
        try {
            this.addCert(certInfo.getIssuer(), certInfo.getCert(), certInfo.getProfile(), certInfo.getRequestor(), certInfo.getUser(), certInfo.getReqType(), certInfo.getTransactionId(), certInfo.getRequestedSubject());
        }
        catch (Exception ex) {
            LOG.error("could not save certificate {}: {}. Message: {}", new Object[]{certInfo.getCert().getCert().getSubject(), Base64.encodeToString((byte[])certInfo.getCert().getCert().getEncoded(), (boolean)true), ex.getMessage()});
            LOG.debug("error", (Throwable)ex);
            return false;
        }
        return true;
    }

    private void addCert(NameId ca, CertWithDbId certificate, NameId certprofile, NameId requestor, Integer userId, RequestType reqType, byte[] transactionId, X500Name reqSubject) throws DataAccessException, OperationException {
        Args.notNull((Object)ca, (String)"ca");
        Args.notNull((Object)certificate, (String)"certificate");
        Args.notNull((Object)certprofile, (String)"certprofile");
        Args.notNull((Object)requestor, (String)"requestor");
        long certId = this.idGenerator.nextId();
        String subjectText = X509Util.cutText((String)certificate.getCert().getSubjectRfc4519Text(), (int)this.maxX500nameLen);
        long fpSubject = X509Util.fpCanonicalizedName((X500Name)certificate.getCert().getSubject());
        String reqSubjectText = null;
        Long fpReqSubject = null;
        if (reqSubject != null) {
            fpReqSubject = X509Util.fpCanonicalizedName((X500Name)reqSubject);
            if (fpSubject == fpReqSubject) {
                fpReqSubject = null;
            } else {
                reqSubjectText = X509Util.cutX500Name((X500Name)CaUtil.sortX509Name(reqSubject), (int)this.maxX500nameLen);
            }
        }
        byte[] encodedCert = certificate.getCert().getEncoded();
        String b64FpCert = this.base64Fp(encodedCert);
        String b64Cert = Base64.encodeToString((byte[])encodedCert);
        String tid = transactionId == null ? null : Base64.encodeToString((byte[])transactionId);
        String sql = this.dbSchemaVersion < 5 ? SQL_ADD_CERT_V4 : SQL_ADD_CERT;
        PreparedStatement ps = this.borrowPreparedStatement(sql);
        try {
            X509Cert cert = certificate.getCert();
            int idx = 1;
            ps.setLong(idx++, certId);
            ps.setLong(idx++, System.currentTimeMillis() / 1000L);
            ps.setString(idx++, cert.getSerialNumber().toString(16));
            ps.setString(idx++, subjectText);
            ps.setLong(idx++, fpSubject);
            CertStore.setLong(ps, idx++, fpReqSubject);
            ps.setLong(idx++, cert.getNotBefore().getTime() / 1000L);
            ps.setLong(idx++, cert.getNotAfter().getTime() / 1000L);
            CertStore.setBoolean(ps, idx++, false);
            ps.setInt(idx++, certprofile.getId());
            ps.setInt(idx++, ca.getId());
            CertStore.setInt(ps, idx++, requestor.getId());
            CertStore.setInt(ps, idx++, userId);
            boolean isEeCert = cert.getBasicConstraints() == -1;
            ps.setInt(idx++, isEeCert ? 1 : 0);
            ps.setInt(idx++, reqType.getCode());
            ps.setString(idx++, tid);
            ps.setString(idx++, b64FpCert);
            ps.setString(idx++, reqSubjectText);
            ps.setInt(idx++, 0);
            ps.setString(idx++, b64Cert);
            ps.executeUpdate();
            certificate.setCertId(Long.valueOf(certId));
        }
        catch (SQLException ex) {
            throw this.datasource.translate(sql, ex);
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    public void addToPublishQueue(NameId publisher, long certId, NameId ca) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        String sql = SQL_INSERT_PUBLISHQUEUE;
        PreparedStatement ps = this.borrowPreparedStatement(SQL_INSERT_PUBLISHQUEUE);
        try {
            ps.setInt(1, publisher.getId());
            ps.setInt(2, ca.getId());
            ps.setLong(3, certId);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(SQL_INSERT_PUBLISHQUEUE, ex).getMessage());
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    public void removeFromPublishQueue(NameId publisher, long certId) throws OperationException {
        String sql = SQL_REMOVE_PUBLISHQUEUE;
        PreparedStatement ps = this.borrowPreparedStatement(SQL_REMOVE_PUBLISHQUEUE);
        try {
            ps.setInt(1, publisher.getId());
            ps.setLong(2, certId);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(SQL_REMOVE_PUBLISHQUEUE, ex).getMessage());
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    public long getMaxIdOfDeltaCrlCache(NameId ca) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        String sql = SQL_MAXID_DELTACRL_CACHE;
        PreparedStatement ps = this.borrowPreparedStatement(SQL_MAXID_DELTACRL_CACHE);
        try {
            ps.setInt(1, ca.getId());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                long l = 0L;
                return l;
            }
            long l = rs.getLong(1);
            return l;
        }
        catch (SQLException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(SQL_MAXID_DELTACRL_CACHE, ex).getMessage());
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    public void clearDeltaCrlCache(NameId ca, long maxId) throws OperationException {
        String sql = SQL_CLEAR_DELTACRL_CACHE;
        PreparedStatement ps = this.borrowPreparedStatement(SQL_CLEAR_DELTACRL_CACHE);
        try {
            ps.setLong(1, maxId + 1L);
            ps.setInt(2, ca.getId());
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(SQL_CLEAR_DELTACRL_CACHE, ex).getMessage());
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    public void clearPublishQueue(NameId ca, NameId publisher) throws OperationException {
        StringBuilder sqlBuilder = new StringBuilder(80);
        sqlBuilder.append("DELETE FROM PUBLISHQUEUE");
        if (ca != null || publisher != null) {
            sqlBuilder.append(" WHERE");
            if (ca != null) {
                sqlBuilder.append(" CA_ID=?");
                if (publisher != null) {
                    sqlBuilder.append(" AND");
                }
            }
            if (publisher != null) {
                sqlBuilder.append(" PID=?");
            }
        }
        String sql = sqlBuilder.toString();
        PreparedStatement ps = this.borrowPreparedStatement(sql);
        try {
            int idx = 1;
            if (ca != null) {
                ps.setInt(idx++, ca.getId());
            }
            if (publisher != null) {
                ps.setInt(idx++, publisher.getId());
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    public long getMaxFullCrlNumber(NameId ca) throws OperationException {
        return this.getMaxCrlNumber(ca, SQL_MAX_FULL_CRLNO);
    }

    public long getMaxCrlNumber(NameId ca) throws OperationException {
        return this.getMaxCrlNumber(ca, SQL_MAX_CRLNO);
    }

    private long getMaxCrlNumber(NameId ca, String sql) throws OperationException {
        long l;
        PreparedStatement ps;
        ResultSet rs;
        block5: {
            Args.notNull((Object)ca, (String)"ca");
            rs = null;
            ps = this.borrowPreparedStatement(sql);
            ps.setInt(1, ca.getId());
            rs = ps.executeQuery();
            if (rs.next()) break block5;
            long l2 = 0L;
            this.datasource.releaseResources((Statement)ps, rs);
            return l2;
        }
        try {
            long maxCrlNumber = rs.getLong(1);
            l = maxCrlNumber < 0L ? 0L : maxCrlNumber;
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return l;
    }

    public long getThisUpdateOfCurrentCrl(NameId ca, boolean deltaCrl) throws OperationException {
        long l;
        PreparedStatement ps;
        ResultSet rs;
        block5: {
            Args.notNull((Object)ca, (String)"ca");
            String sql = SQL_MAX_THISUPDAATE_CRL;
            rs = null;
            ps = this.borrowPreparedStatement(SQL_MAX_THISUPDAATE_CRL);
            ps.setInt(1, ca.getId());
            CertStore.setBoolean(ps, 2, deltaCrl);
            rs = ps.executeQuery();
            if (rs.next()) break block5;
            long l2 = 0L;
            this.datasource.releaseResources((Statement)ps, rs);
            return l2;
        }
        try {
            l = rs.getLong(1);
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(SQL_MAX_THISUPDAATE_CRL, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return l;
    }

    public boolean hasCrl(NameId ca) throws OperationException {
        boolean bl;
        Args.notNull((Object)ca, (String)"ca");
        String sql = this.sqlCaHasCrl;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.borrowPreparedStatement(sql);
            ps.setInt(1, ca.getId());
            rs = ps.executeQuery();
            bl = rs.next();
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return bl;
    }

    public void addCrl(NameId ca, X509CRLHolder crl) throws OperationException, CRLException {
        String b64Crl;
        long currentMaxCrlId;
        Args.notNull((Object)ca, (String)"ca");
        Args.notNull((Object)crl, (String)"crl");
        Extensions extns = crl.getExtensions();
        byte[] extnValue = X509Util.getCoreExtValue((Extensions)extns, (ASN1ObjectIdentifier)Extension.cRLNumber);
        Long crlNumber = null;
        if (extnValue != null) {
            crlNumber = ASN1Integer.getInstance((Object)extnValue).getPositiveValue().longValue();
        }
        extnValue = X509Util.getCoreExtValue((Extensions)extns, (ASN1ObjectIdentifier)Extension.deltaCRLIndicator);
        Long baseCrlNumber = null;
        if (extnValue != null) {
            baseCrlNumber = ASN1Integer.getInstance((Object)extnValue).getPositiveValue().longValue();
        }
        String sql = SQL_ADD_CRL;
        try {
            currentMaxCrlId = this.datasource.getMax(null, "CRL", "ID");
        }
        catch (DataAccessException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, ex.getMessage());
        }
        long crlId = currentMaxCrlId + 1L;
        try {
            b64Crl = Base64.encodeToString((byte[])crl.getEncoded());
        }
        catch (IOException ex) {
            throw new CRLException(ex.getMessage(), ex);
        }
        PreparedStatement ps = null;
        try {
            ps = this.borrowPreparedStatement(SQL_ADD_CRL);
            int idx = 1;
            ps.setLong(idx++, crlId);
            ps.setInt(idx++, ca.getId());
            CertStore.setLong(ps, idx++, crlNumber);
            Date date = crl.getThisUpdate();
            ps.setLong(idx++, date.getTime() / 1000L);
            CertStore.setDateSeconds(ps, idx++, crl.getNextUpdate());
            CertStore.setBoolean(ps, idx++, baseCrlNumber != null);
            CertStore.setLong(ps, idx++, baseCrlNumber);
            ps.setInt(idx++, 0);
            ps.setString(idx++, b64Crl);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(SQL_ADD_CRL, ex).getMessage());
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    public CertWithRevocationInfo revokeCert(NameId ca, BigInteger serialNumber, CertRevocationInfo revInfo, boolean force, boolean publishToDeltaCrlCache, CaIdNameMap idNameMap) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        Args.notNull((Object)serialNumber, (String)"serialNumber");
        Args.notNull((Object)revInfo, (String)"revInfo");
        CertWithRevocationInfo certWithRevInfo = this.getCertWithRevocationInfo(ca.getId(), serialNumber, idNameMap);
        if (certWithRevInfo == null) {
            LOG.warn("certificate with CA={} and serialNumber={} does not exist", (Object)ca.getName(), (Object)LogUtil.formatCsn((BigInteger)serialNumber));
            return null;
        }
        CertRevocationInfo currentRevInfo = certWithRevInfo.getRevInfo();
        if (currentRevInfo != null) {
            CrlReason currentReason = currentRevInfo.getReason();
            if (currentReason == CrlReason.CERTIFICATE_HOLD) {
                if (revInfo.getReason() == CrlReason.CERTIFICATE_HOLD) {
                    throw new OperationException(OperationException.ErrorCode.CERT_REVOKED, "certificate already revoked with the requested reason " + currentReason.getDescription());
                }
                revInfo.setRevocationTime(currentRevInfo.getRevocationTime());
                revInfo.setInvalidityTime(currentRevInfo.getInvalidityTime());
            } else if (!force) {
                throw new OperationException(OperationException.ErrorCode.CERT_REVOKED, "certificate already revoked with reason " + currentReason.getDescription());
            }
        }
        Long invTimeSeconds = null;
        if (revInfo.getInvalidityTime() != null) {
            invTimeSeconds = revInfo.getInvalidityTime().getTime() / 1000L;
        }
        PreparedStatement ps = this.borrowPreparedStatement(SQL_REVOKE_CERT);
        try {
            int idx = 1;
            ps.setLong(idx++, System.currentTimeMillis() / 1000L);
            CertStore.setBoolean(ps, idx++, true);
            ps.setLong(idx++, revInfo.getRevocationTime().getTime() / 1000L);
            CertStore.setLong(ps, idx++, invTimeSeconds);
            ps.setInt(idx++, revInfo.getReason().getCode());
            ps.setLong(idx++, certWithRevInfo.getCert().getCertId());
            int count = ps.executeUpdate();
            if (count != 1) {
                String message = count > 1 ? count + " rows modified, but exactly one is expected" : "no row is modified, but exactly one is expected";
                throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, message);
            }
        }
        catch (SQLException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(SQL_REVOKE_CERT, ex).getMessage());
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
        if (publishToDeltaCrlCache) {
            this.publishToDeltaCrlCache(ca, certWithRevInfo.getCert().getCert().getSerialNumber());
        }
        certWithRevInfo.setRevInfo(revInfo);
        return certWithRevInfo;
    }

    public CertWithRevocationInfo revokeSuspendedCert(NameId ca, BigInteger serialNumber, CrlReason reason, boolean publishToDeltaCrlCache, CaIdNameMap idNameMap) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        Args.notNull((Object)serialNumber, (String)"serialNumber");
        Args.notNull((Object)reason, (String)"reason");
        CertWithRevocationInfo certWithRevInfo = this.getCertWithRevocationInfo(ca.getId(), serialNumber, idNameMap);
        if (certWithRevInfo == null) {
            LOG.warn("certificate with CA={} and serialNumber={} does not exist", (Object)ca.getName(), (Object)LogUtil.formatCsn((BigInteger)serialNumber));
            return null;
        }
        CertRevocationInfo currentRevInfo = certWithRevInfo.getRevInfo();
        if (currentRevInfo == null) {
            throw new OperationException(OperationException.ErrorCode.CERT_UNREVOKED, "certificate is not revoked");
        }
        CrlReason currentReason = currentRevInfo.getReason();
        if (currentReason != CrlReason.CERTIFICATE_HOLD) {
            throw new OperationException(OperationException.ErrorCode.CERT_REVOKED, "certificate is revoked but not with reason " + CrlReason.CERTIFICATE_HOLD.getDescription());
        }
        PreparedStatement ps = this.borrowPreparedStatement(SQL_REVOKE_SUSPENDED_CERT);
        try {
            int idx = 1;
            ps.setLong(idx++, System.currentTimeMillis() / 1000L);
            ps.setInt(idx++, reason.getCode());
            ps.setLong(idx++, certWithRevInfo.getCert().getCertId());
            int count = ps.executeUpdate();
            if (count != 1) {
                String message = count > 1 ? count + " rows modified, but exactly one is expected" : "no row is modified, but exactly one is expected";
                throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, message);
            }
        }
        catch (SQLException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(SQL_REVOKE_CERT, ex).getMessage());
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
        if (publishToDeltaCrlCache) {
            this.publishToDeltaCrlCache(ca, certWithRevInfo.getCert().getCert().getSerialNumber());
        }
        currentRevInfo.setReason(reason);
        return certWithRevInfo;
    }

    public CertWithDbId unrevokeCert(NameId ca, BigInteger serialNumber, boolean force, boolean publishToDeltaCrlCache, CaIdNameMap idNamMap) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        Args.notNull((Object)serialNumber, (String)"serialNumber");
        CertWithRevocationInfo certWithRevInfo = this.getCertWithRevocationInfo(ca.getId(), serialNumber, idNamMap);
        if (certWithRevInfo == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("certificate with CA={} and serialNumber={} does not exist", (Object)ca.getName(), (Object)LogUtil.formatCsn((BigInteger)serialNumber));
            }
            return null;
        }
        CertRevocationInfo currentRevInfo = certWithRevInfo.getRevInfo();
        if (currentRevInfo == null) {
            throw new OperationException(OperationException.ErrorCode.CERT_UNREVOKED, "certificate is not revoked");
        }
        CrlReason currentReason = currentRevInfo.getReason();
        if (!force && currentReason != CrlReason.CERTIFICATE_HOLD) {
            throw new OperationException(OperationException.ErrorCode.NOT_PERMITTED, "could not unrevoke certificate revoked with reason " + currentReason.getDescription());
        }
        String sql = SQL_REVOKE_CERT;
        PreparedStatement ps = this.borrowPreparedStatement(SQL_REVOKE_CERT);
        try {
            int idx = 1;
            ps.setLong(idx++, System.currentTimeMillis() / 1000L);
            CertStore.setBoolean(ps, idx++, false);
            ps.setNull(idx++, 4);
            ps.setNull(idx++, 4);
            ps.setNull(idx++, 4);
            ps.setLong(idx++, certWithRevInfo.getCert().getCertId());
            int count = ps.executeUpdate();
            if (count != 1) {
                String message = count > 1 ? count + " rows modified, but exactly one is expected" : "no row is modified, but exactly one is expected";
                throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, message);
            }
        }
        catch (SQLException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(SQL_REVOKE_CERT, ex).getMessage());
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
        if (publishToDeltaCrlCache) {
            this.publishToDeltaCrlCache(ca, certWithRevInfo.getCert().getCert().getSerialNumber());
        }
        return certWithRevInfo.getCert();
    }

    private void publishToDeltaCrlCache(NameId ca, BigInteger serialNumber) throws OperationException {
        Args.notNull((Object)serialNumber, (String)"serialNumber");
        String sql = SQL_ADD_DELTACRL_CACHE;
        PreparedStatement ps = null;
        try {
            long id = this.idGenerator.nextId();
            ps = this.borrowPreparedStatement(SQL_ADD_DELTACRL_CACHE);
            ps.setLong(1, id);
            ps.setInt(2, ca.getId());
            ps.setString(3, serialNumber.toString(16));
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(SQL_ADD_DELTACRL_CACHE, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources(ps, null);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, null);
    }

    public void removeCert(NameId ca, BigInteger serialNumber) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        Args.notNull((Object)serialNumber, (String)"serialNumber");
        String sql = SQL_REMOVE_CERT;
        PreparedStatement ps = this.borrowPreparedStatement(SQL_REMOVE_CERT);
        try {
            ps.setInt(1, ca.getId());
            ps.setString(2, serialNumber.toString(16));
            int count = ps.executeUpdate();
            if (count != 1) {
                String message = count > 1 ? count + " rows modified, but exactly one is expected" : "no row is modified, but exactly one is expected";
                throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, message);
            }
        }
        catch (SQLException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(SQL_REMOVE_CERT, ex).getMessage());
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    public List<Long> getPublishQueueEntries(NameId ca, NameId publisher, int numEntries) throws OperationException {
        ArrayList<Long> arrayList;
        String sql = this.getSqlCidFromPublishQueue(numEntries);
        ResultSet rs = null;
        PreparedStatement ps = this.borrowPreparedStatement(sql);
        try {
            ps.setInt(1, publisher.getId());
            ps.setInt(2, ca.getId());
            rs = ps.executeQuery();
            ArrayList<Long> ret = new ArrayList<Long>();
            while (rs.next() && ret.size() < numEntries) {
                long certId = rs.getLong("CID");
                if (ret.contains(certId)) continue;
                ret.add(certId);
            }
            arrayList = ret;
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return arrayList;
    }

    public long getCountOfCerts(NameId ca, boolean onlyRevoked) throws OperationException {
        long l;
        String sql = onlyRevoked ? "SELECT COUNT(*) FROM CERT WHERE CA_ID=? AND REV=1" : "SELECT COUNT(*) FROM CERT WHERE CA_ID=?";
        ResultSet rs = null;
        PreparedStatement ps = this.borrowPreparedStatement(sql);
        try {
            ps.setInt(1, ca.getId());
            rs = ps.executeQuery();
            rs.next();
            l = rs.getLong(1);
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return l;
    }

    public List<SerialWithId> getSerialNumbers(NameId ca, long startId, int numEntries, boolean onlyRevoked) throws OperationException {
        ArrayList<SerialWithId> arrayList;
        Args.notNull((Object)ca, (String)"ca");
        Args.positive((int)numEntries, (String)"numEntries");
        String sql = this.getSqlSerials(numEntries, onlyRevoked);
        ResultSet rs = null;
        PreparedStatement ps = this.borrowPreparedStatement(sql);
        try {
            ps.setLong(1, startId - 1L);
            ps.setInt(2, ca.getId());
            rs = ps.executeQuery();
            ArrayList<SerialWithId> ret = new ArrayList<SerialWithId>();
            while (rs.next() && ret.size() < numEntries) {
                long id = rs.getLong("ID");
                String serial = rs.getString("SN");
                ret.add(new SerialWithId(id, new BigInteger(serial, 16)));
            }
            arrayList = ret;
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return arrayList;
    }

    public List<SerialWithId> getSerialNumbers(NameId ca, Date notExpiredAt, long startId, int numEntries, boolean onlyRevoked, boolean onlyCaCerts, boolean onlyUserCerts) throws OperationException {
        ArrayList<SerialWithId> arrayList;
        Args.notNull((Object)ca, (String)"ca");
        Args.positive((int)numEntries, (String)"numEntries");
        if (onlyCaCerts && onlyUserCerts) {
            throw new IllegalArgumentException("onlyCaCerts and onlyUserCerts cannot be both of true");
        }
        boolean withEe = onlyCaCerts || onlyUserCerts;
        String sql = this.getSqlSerials(numEntries, notExpiredAt, onlyRevoked, withEe);
        ResultSet rs = null;
        PreparedStatement ps = this.borrowPreparedStatement(sql);
        try {
            int idx = 1;
            ps.setLong(idx++, startId - 1L);
            ps.setInt(idx++, ca.getId());
            if (notExpiredAt != null) {
                ps.setLong(idx++, notExpiredAt.getTime() / 1000L + 1L);
            }
            if (withEe) {
                CertStore.setBoolean(ps, idx++, onlyUserCerts);
            }
            rs = ps.executeQuery();
            ArrayList<SerialWithId> ret = new ArrayList<SerialWithId>();
            while (rs.next() && ret.size() < numEntries) {
                long id = rs.getLong("ID");
                String serial = rs.getString("SN");
                ret.add(new SerialWithId(id, new BigInteger(serial, 16)));
            }
            arrayList = ret;
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return arrayList;
    }

    public List<BigInteger> getExpiredSerialNumbers(NameId ca, long expiredAt, int numEntries) throws OperationException {
        ArrayList<BigInteger> arrayList;
        Args.notNull((Object)ca, (String)"ca");
        Args.positive((int)numEntries, (String)"numEntries");
        String sql = this.getSqlExpiredSerials(numEntries);
        ResultSet rs = null;
        PreparedStatement ps = this.borrowPreparedStatement(sql);
        try {
            ps.setInt(1, ca.getId());
            ps.setLong(2, expiredAt);
            rs = ps.executeQuery();
            ArrayList<BigInteger> ret = new ArrayList<BigInteger>();
            while (rs.next() && ret.size() < numEntries) {
                String serial = rs.getString("SN");
                ret.add(new BigInteger(serial, 16));
            }
            arrayList = ret;
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return arrayList;
    }

    public List<BigInteger> getSuspendedCertSerials(NameId ca, long latestLastUpdate, int numEntries) throws OperationException {
        ArrayList<BigInteger> arrayList;
        Args.notNull((Object)ca, (String)"ca");
        Args.positive((int)numEntries, (String)"numEntries");
        String sql = this.getSqlSuspendedSerials(numEntries);
        ResultSet rs = null;
        PreparedStatement ps = this.borrowPreparedStatement(sql);
        try {
            ps.setInt(1, ca.getId());
            ps.setLong(2, latestLastUpdate + 1L);
            ps.setInt(3, CrlReason.CERTIFICATE_HOLD.getCode());
            rs = ps.executeQuery();
            ArrayList<BigInteger> ret = new ArrayList<BigInteger>();
            while (rs.next() && ret.size() < numEntries) {
                String str = rs.getString("SN");
                ret.add(new BigInteger(str, 16));
            }
            arrayList = ret;
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return arrayList;
    }

    public byte[] getEncodedCrl(NameId ca, BigInteger crlNumber) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        String sql = crlNumber == null ? this.sqlCrl : this.sqlCrlWithNo;
        ResultSet rs = null;
        PreparedStatement ps = this.borrowPreparedStatement(sql);
        String b64Crl = null;
        try {
            int idx = 1;
            ps.setInt(idx++, ca.getId());
            if (crlNumber != null) {
                ps.setLong(idx++, crlNumber.longValue());
            }
            rs = ps.executeQuery();
            long currentThisUpdate = 0L;
            while (rs.next()) {
                long thisUpdate = rs.getLong("THISUPDATE");
                if (thisUpdate < currentThisUpdate) continue;
                b64Crl = rs.getString("CRL");
                currentThisUpdate = thisUpdate;
            }
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return b64Crl == null ? null : Base64.decodeFast(b64Crl);
    }

    public int cleanupCrls(NameId ca, int numCrls) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        Args.positive((int)numCrls, (String)"numCrls");
        String sql = "SELECT CRL_NO FROM CRL WHERE CA_ID=? AND DELTACRL=?";
        PreparedStatement ps = this.borrowPreparedStatement(sql);
        LinkedList<Integer> crlNumbers = new LinkedList<Integer>();
        ResultSet rs = null;
        try {
            ps.setInt(1, ca.getId());
            CertStore.setBoolean(ps, 2, false);
            rs = ps.executeQuery();
            while (rs.next()) {
                int crlNumber = rs.getInt("CRL_NO");
                crlNumbers.add(crlNumber);
            }
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        int size = crlNumbers.size();
        Collections.sort(crlNumbers);
        int numCrlsToDelete = size - numCrls;
        if (numCrlsToDelete < 1) {
            return 0;
        }
        int crlNumber = (Integer)crlNumbers.get(numCrlsToDelete - 1);
        sql = "DELETE FROM CRL WHERE CA_ID=? AND CRL_NO<?";
        ps = this.borrowPreparedStatement(sql);
        try {
            int idx = 1;
            ps.setInt(idx++, ca.getId());
            ps.setInt(idx++, crlNumber + 1);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
        return numCrlsToDelete;
    }

    public CertificateInfo getCertForId(NameId ca, X509Cert caCert, long certId, CaIdNameMap idNameMap) throws OperationException, CertificateException {
        boolean revoked;
        int requestorId;
        int certprofileId;
        String b64Cert;
        Args.notNull((Object)ca, (String)"ca");
        Args.notNull((Object)caCert, (String)"caCert");
        Args.notNull((Object)idNameMap, (String)"idNameMap");
        String sql = this.sqlCertForId;
        int revReason = 0;
        long revTime = 0L;
        long revInvTime = 0L;
        ResultSet rs = null;
        PreparedStatement ps = this.borrowPreparedStatement(sql);
        try {
            ps.setLong(1, certId);
            rs = ps.executeQuery();
            if (!rs.next()) {
                CertificateInfo certificateInfo = null;
                return certificateInfo;
            }
            b64Cert = rs.getString("CERT");
            certprofileId = rs.getInt("PID");
            requestorId = rs.getInt("RID");
            revoked = rs.getBoolean("REV");
            if (revoked) {
                revReason = rs.getInt("RR");
                revTime = rs.getLong("RT");
                revInvTime = rs.getLong("RIT");
            }
        }
        catch (SQLException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
        }
        finally {
            this.datasource.releaseResources((Statement)ps, rs);
        }
        byte[] encodedCert = Base64.decodeFast((String)b64Cert);
        X509Cert cert = X509Util.parseCert((byte[])encodedCert);
        CertWithDbId certWithMeta = new CertWithDbId(cert);
        certWithMeta.setCertId(Long.valueOf(certId));
        CertificateInfo certInfo = new CertificateInfo(certWithMeta, null, ca, caCert, idNameMap.getCertprofile(certprofileId), idNameMap.getRequestor(requestorId));
        if (!revoked) {
            return certInfo;
        }
        Date invalidityTime = revInvTime == 0L || revInvTime == revTime ? null : new Date(revInvTime * 1000L);
        CertRevocationInfo revInfo = new CertRevocationInfo(revReason, new Date(revTime * 1000L), invalidityTime);
        certInfo.setRevocationInfo(revInfo);
        return certInfo;
    }

    public CertWithRevocationInfo getCertWithRevocationInfo(int caId, BigInteger serial, CaIdNameMap idNameMap) throws OperationException {
        X509Cert cert;
        boolean revoked;
        String b64Cert;
        long certId;
        Args.notNull((Object)serial, (String)"serial");
        Args.notNull((Object)idNameMap, (String)"idNameMap");
        String sql = this.sqlCertWithRevInfo;
        int revReason = 0;
        long revTime = 0L;
        long revInvTime = 0L;
        int certprofileId = 0;
        ResultSet rs = null;
        PreparedStatement ps = this.borrowPreparedStatement(sql);
        try {
            int idx = 1;
            ps.setInt(idx++, caId);
            ps.setString(idx++, serial.toString(16));
            rs = ps.executeQuery();
            if (!rs.next()) {
                CertWithRevocationInfo certWithRevocationInfo = null;
                return certWithRevocationInfo;
            }
            certId = rs.getLong("ID");
            b64Cert = rs.getString("CERT");
            certprofileId = rs.getInt("PID");
            revoked = rs.getBoolean("REV");
            if (revoked) {
                revReason = rs.getInt("RR");
                revTime = rs.getLong("RT");
                revInvTime = rs.getLong("RIT");
            }
        }
        catch (SQLException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
        byte[] encodedCert = Base64.decodeFast((String)b64Cert);
        try {
            cert = X509Util.parseCert((byte[])encodedCert);
        }
        catch (CertificateException ex) {
            throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
        }
        CertRevocationInfo revInfo = null;
        if (revoked) {
            Date invalidityTime = revInvTime == 0L ? null : new Date(1000L * revInvTime);
            revInfo = new CertRevocationInfo(revReason, new Date(1000L * revTime), invalidityTime);
        }
        CertWithDbId certWithMeta = new CertWithDbId(cert);
        certWithMeta.setCertId(Long.valueOf(certId));
        String profileName = idNameMap.getCertprofileName(certprofileId);
        CertWithRevocationInfo ret = new CertWithRevocationInfo();
        ret.setCertprofile(profileName);
        ret.setCert(certWithMeta);
        ret.setRevInfo(revInfo);
        return ret;
    }

    public CertificateInfo getCertInfo(NameId ca, X509Cert caCert, BigInteger serial, CaIdNameMap idNameMap) throws OperationException, CertificateException {
        boolean revoked;
        int requestorId;
        int certprofileId;
        String b64Cert;
        PreparedStatement ps;
        ResultSet rs;
        long revInvTime;
        long revTime;
        int revReason;
        String sql;
        block7: {
            Args.notNull((Object)ca, (String)"ca");
            Args.notNull((Object)caCert, (String)"caCert");
            Args.notNull((Object)idNameMap, (String)"idNameMap");
            Args.notNull((Object)serial, (String)"serial");
            sql = this.sqlCertInfo;
            revReason = 0;
            revTime = 0L;
            revInvTime = 0L;
            rs = null;
            ps = this.borrowPreparedStatement(sql);
            int idx = 1;
            ps.setInt(idx++, ca.getId());
            ps.setString(idx++, serial.toString(16));
            rs = ps.executeQuery();
            if (rs.next()) break block7;
            CertificateInfo certificateInfo = null;
            this.datasource.releaseResources((Statement)ps, rs);
            return certificateInfo;
        }
        try {
            b64Cert = rs.getString("CERT");
            certprofileId = rs.getInt("PID");
            requestorId = rs.getInt("RID");
            revoked = rs.getBoolean("REV");
            if (revoked) {
                revReason = rs.getInt("RR");
                revTime = rs.getLong("RT");
                revInvTime = rs.getLong("RIT");
            }
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        byte[] encodedCert = Base64.decodeFast((String)b64Cert);
        X509Cert cert = X509Util.parseCert((byte[])encodedCert);
        CertWithDbId certWithMeta = new CertWithDbId(cert);
        CertificateInfo certInfo = new CertificateInfo(certWithMeta, null, ca, caCert, idNameMap.getCertprofile(certprofileId), idNameMap.getRequestor(requestorId));
        if (!revoked) {
            return certInfo;
        }
        Date invalidityTime = revInvTime == 0L ? null : new Date(revInvTime * 1000L);
        CertRevocationInfo revInfo = new CertRevocationInfo(revReason, new Date(revTime * 1000L), invalidityTime);
        certInfo.setRevocationInfo(revInfo);
        return certInfo;
    }

    public Integer getCertprofileForCertId(NameId ca, long cid) throws OperationException {
        Integer n;
        PreparedStatement ps;
        ResultSet rs;
        String sql;
        block5: {
            Args.notNull((Object)ca, (String)"ca");
            sql = this.sqlCertprofileForCertId;
            rs = null;
            ps = this.borrowPreparedStatement(sql);
            ps.setLong(1, cid);
            ps.setInt(2, ca.getId());
            rs = ps.executeQuery();
            if (rs.next()) break block5;
            Integer n2 = null;
            this.datasource.releaseResources((Statement)ps, rs);
            return n2;
        }
        try {
            n = rs.getInt("PID");
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return n;
    }

    public List<X509Cert> getCert(X500Name subjectName, byte[] transactionId) throws OperationException {
        String sql = transactionId != null ? "SELECT CERT FROM CERT WHERE TID=? AND (FP_S=? OR FP_RS=?)" : "SELECT CERT FROM CERT WHERE FP_S=? OR FP_RS=?";
        long fpSubject = X509Util.fpCanonicalizedName((X500Name)subjectName);
        LinkedList<X509Cert> certs = new LinkedList<X509Cert>();
        ResultSet rs = null;
        PreparedStatement ps = this.borrowPreparedStatement(sql);
        try {
            int idx = 1;
            if (transactionId != null) {
                ps.setString(idx++, Base64.encodeToString((byte[])transactionId));
            }
            ps.setLong(idx++, fpSubject);
            ps.setLong(idx++, fpSubject);
            rs = ps.executeQuery();
            while (rs.next()) {
                X509Cert cert;
                String b64Cert = rs.getString("CERT");
                byte[] encodedCert = Base64.decodeFast((String)b64Cert);
                try {
                    cert = X509Util.parseCert((byte[])encodedCert);
                }
                catch (CertificateException ex) {
                    throw new OperationException(OperationException.ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
                }
                certs.add(cert);
            }
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return certs;
    }

    public byte[] getCertRequest(NameId ca, BigInteger serialNumber) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        Args.notNull((Object)serialNumber, (String)"serialNumber");
        String sql = this.sqlReqIdForSerial;
        ResultSet rs = null;
        PreparedStatement ps = this.borrowPreparedStatement(sql);
        Long reqId = null;
        try {
            ps.setInt(1, ca.getId());
            ps.setString(2, serialNumber.toString(16));
            rs = ps.executeQuery();
            if (rs.next()) {
                reqId = rs.getLong("REQ_ID");
            }
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        if (reqId == null) {
            return null;
        }
        String b64Req = null;
        sql = this.sqlReqForId;
        ps = this.borrowPreparedStatement(sql);
        try {
            ps.setLong(1, reqId);
            rs = ps.executeQuery();
            if (rs.next()) {
                b64Req = rs.getString("DATA");
            }
        }
        catch (SQLException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
        }
        finally {
            this.datasource.releaseResources((Statement)ps, rs);
        }
        return b64Req == null ? null : Base64.decodeFast((String)b64Req);
    }

    public List<CertListInfo> listCerts(NameId ca, X500Name subjectPattern, Date validFrom, Date validTo, CertListOrderBy orderBy, int numEntries) throws OperationException {
        LinkedList<CertListInfo> linkedList;
        Args.notNull((Object)ca, (String)"ca");
        Args.positive((int)numEntries, (String)"numEntries");
        StringBuilder sb = new StringBuilder(200);
        sb.append("SN,NBEFORE,NAFTER,SUBJECT FROM CERT WHERE CA_ID=?");
        Integer idxNotBefore = null;
        Integer idxNotAfter = null;
        Integer idxSubject = null;
        int idx = 2;
        if (validFrom != null) {
            idxNotBefore = idx++;
            sb.append(" AND NBEFORE<?");
        }
        if (validTo != null) {
            idxNotAfter = idx++;
            sb.append(" AND NAFTER>?");
        }
        String subjectLike = null;
        if (subjectPattern != null) {
            idxSubject = idx++;
            sb.append(" AND SUBJECT LIKE ?");
            StringBuilder buffer = new StringBuilder(100);
            buffer.append("%");
            RDN[] rdns = subjectPattern.getRDNs();
            for (int i = 0; i < rdns.length; ++i) {
                X500Name rdnName = new X500Name(new RDN[]{rdns[i]});
                String rdnStr = X509Util.getRfc4519Name((X500Name)rdnName);
                if (rdnStr.indexOf(37) != -1) {
                    throw new OperationException(OperationException.ErrorCode.BAD_REQUEST, "the character '%' is not allowed in subjectPattern");
                }
                if (rdnStr.indexOf(42) != -1) {
                    rdnStr = rdnStr.replace('*', '%');
                }
                buffer.append(rdnStr);
                buffer.append("%");
            }
            subjectLike = buffer.toString();
        }
        String sortByStr = null;
        if (orderBy != null) {
            switch (orderBy) {
                case NOT_BEFORE: {
                    sortByStr = "NBEFORE";
                    break;
                }
                case NOT_BEFORE_DESC: {
                    sortByStr = "NBEFORE DESC";
                    break;
                }
                case NOT_AFTER: {
                    sortByStr = "NAFTER";
                    break;
                }
                case NOT_AFTER_DESC: {
                    sortByStr = "NAFTER DESC";
                    break;
                }
                case SUBJECT: {
                    sortByStr = "SUBJECT";
                    break;
                }
                case SUBJECT_DESC: {
                    sortByStr = "SUBJECT DESC";
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown CertListOrderBy " + orderBy);
                }
            }
        }
        String sql = this.datasource.buildSelectFirstSql(numEntries, sortByStr, sb.toString());
        ResultSet rs = null;
        PreparedStatement ps = this.borrowPreparedStatement(sql);
        try {
            ps.setInt(1, ca.getId());
            if (idxNotBefore != null) {
                long time = validFrom.getTime() / 1000L;
                ps.setLong(idxNotBefore, time - 1L);
            }
            if (idxNotAfter != null) {
                long time = validTo.getTime() / 1000L;
                ps.setLong(idxNotAfter, time);
            }
            if (idxSubject != null) {
                ps.setString(idxSubject, subjectLike);
            }
            rs = ps.executeQuery();
            LinkedList<CertListInfo> ret = new LinkedList<CertListInfo>();
            while (rs.next()) {
                CertListInfo info = new CertListInfo(new BigInteger(rs.getString("SN"), 16), rs.getString("SUBJECT"), new Date(rs.getLong("NBEFORE") * 1000L), new Date(rs.getLong("NAFTER") * 1000L));
                ret.add(info);
            }
            linkedList = ret;
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return linkedList;
    }

    public NameId authenticateUser(String user, byte[] password) throws OperationException {
        String expPasswordText;
        int id;
        String sql = this.sqlActiveUserInfoForName;
        ResultSet rs = null;
        PreparedStatement ps = this.borrowPreparedStatement(sql);
        try {
            ps.setString(1, user);
            rs = ps.executeQuery();
            if (!rs.next()) {
                NameId nameId = null;
                return nameId;
            }
            id = rs.getInt("ID");
            expPasswordText = rs.getString("PASSWORD");
        }
        catch (SQLException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
        }
        finally {
            this.datasource.releaseResources((Statement)ps, rs);
        }
        if (StringUtil.isBlank((String)expPasswordText)) {
            return null;
        }
        boolean valid = PasswordHash.validatePassword(password, expPasswordText);
        return valid ? new NameId(Integer.valueOf(id), user) : null;
    }

    public String getUsername(int id) throws OperationException {
        String sql = this.sqlActiveUserNameForId;
        ResultSet rs = null;
        PreparedStatement ps = this.borrowPreparedStatement(sql);
        try {
            ps.setInt(1, id);
            rs = ps.executeQuery();
            if (!rs.next()) {
                String string = null;
                return string;
            }
            String string = rs.getString("NAME");
            return string;
        }
        catch (SQLException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
        }
        finally {
            this.datasource.releaseResources((Statement)ps, rs);
        }
    }

    public MgmtEntry.CaHasUser getCaHasUser(NameId ca, NameId user) throws OperationException {
        MgmtEntry.CaHasUser caHasUser;
        PreparedStatement ps;
        ResultSet rs;
        String sql;
        block5: {
            sql = this.sqlCaHasUser;
            rs = null;
            ps = this.borrowPreparedStatement(sql);
            ps.setInt(1, ca.getId());
            ps.setInt(2, user.getId());
            rs = ps.executeQuery();
            if (rs.next()) break block5;
            MgmtEntry.CaHasUser caHasUser2 = null;
            this.datasource.releaseResources((Statement)ps, rs);
            return caHasUser2;
        }
        try {
            List list = StringUtil.split((String)rs.getString("PROFILES"), (String)",");
            HashSet profiles = list == null ? null : new HashSet(list);
            MgmtEntry.CaHasUser entry = new MgmtEntry.CaHasUser(user);
            entry.setPermission(rs.getInt("PERMISSION"));
            entry.setProfiles(profiles);
            caHasUser = entry;
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return caHasUser;
    }

    public KnowCertResult knowsCertForSerial(NameId ca, BigInteger serial) throws OperationException {
        KnowCertResult knowCertResult;
        PreparedStatement ps;
        ResultSet rs;
        String sql;
        block5: {
            Args.notNull((Object)serial, (String)"serial");
            sql = this.sqlKnowsCertForSerial;
            rs = null;
            ps = this.borrowPreparedStatement(sql);
            ps.setString(1, serial.toString(16));
            ps.setInt(2, ca.getId());
            rs = ps.executeQuery();
            if (rs.next()) break block5;
            KnowCertResult knowCertResult2 = KnowCertResult.UNKNOWN;
            this.datasource.releaseResources((Statement)ps, rs);
            return knowCertResult2;
        }
        try {
            int userId = rs.getInt("UID");
            knowCertResult = new KnowCertResult(true, userId);
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return knowCertResult;
    }

    public List<CertRevInfoWithSerial> getRevokedCerts(NameId ca, Date notExpiredAt, long startId, int numEntries, boolean onlyCaCerts, boolean onlyUserCerts) throws OperationException {
        LinkedList<CertRevInfoWithSerial> linkedList;
        Args.notNull((Object)ca, (String)"ca");
        Args.notNull((Object)notExpiredAt, (String)"notExpiredAt");
        Args.positive((int)numEntries, (String)"numEntries");
        if (onlyCaCerts && onlyUserCerts) {
            throw new IllegalArgumentException("onlyCaCerts and onlyUserCerts cannot be both of true");
        }
        boolean withEe = onlyCaCerts || onlyUserCerts;
        String sql = this.getSqlRevokedCerts(numEntries, withEe);
        ResultSet rs = null;
        PreparedStatement ps = this.borrowPreparedStatement(sql);
        try {
            int idx = 1;
            ps.setLong(idx++, startId - 1L);
            ps.setInt(idx++, ca.getId());
            ps.setLong(idx++, notExpiredAt.getTime() / 1000L + 1L);
            if (withEe) {
                CertStore.setBoolean(ps, idx++, onlyUserCerts);
            }
            rs = ps.executeQuery();
            LinkedList<CertRevInfoWithSerial> ret = new LinkedList<CertRevInfoWithSerial>();
            while (rs.next()) {
                long revInvalidityTime = rs.getLong("RIT");
                Date invalidityTime = revInvalidityTime == 0L ? null : new Date(1000L * revInvalidityTime);
                CertRevInfoWithSerial revInfo = new CertRevInfoWithSerial(rs.getLong("ID"), new BigInteger(rs.getString("SN"), 16), rs.getInt("RR"), new Date(1000L * rs.getLong("RT")), invalidityTime);
                ret.add(revInfo);
            }
            linkedList = ret;
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return linkedList;
    }

    public List<CertRevInfoWithSerial> getCertsForDeltaCrl(NameId ca, long startId, int numEntries, boolean onlyCaCerts, boolean onlyUserCerts) throws OperationException {
        Args.notNull((Object)ca, (String)"ca");
        Args.positive((int)numEntries, (String)"numEntries");
        String sql = this.getSqlDeltaCrlCacheIds(numEntries);
        LinkedList<Long> ids = new LinkedList<Long>();
        ResultSet rs = null;
        PreparedStatement ps = this.borrowPreparedStatement(sql);
        try {
            ps.setLong(1, startId - 1L);
            ps.setInt(2, ca.getId());
            rs = ps.executeQuery();
            while (rs.next()) {
                long id = rs.getLong("ID");
                ids.add(id);
            }
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        sql = this.sqlRevForId;
        ps = this.borrowPreparedStatement(sql);
        ArrayList<CertRevInfoWithSerial> ret = new ArrayList<CertRevInfoWithSerial>();
        for (Long id : ids) {
            try {
                CertRevInfoWithSerial revInfo;
                ps.setLong(1, id);
                rs = ps.executeQuery();
                if (!rs.next()) continue;
                int ee = rs.getInt("EE");
                if (onlyCaCerts ? ee != 0 : onlyUserCerts && ee != 1) continue;
                String serial = rs.getString("SN");
                boolean revoked = rs.getBoolean("REVOEKD");
                if (revoked) {
                    long revInvTime = rs.getLong("RIT");
                    Date invalidityTime = revInvTime == 0L ? null : new Date(1000L * revInvTime);
                    revInfo = new CertRevInfoWithSerial((long)id, new BigInteger(serial, 16), rs.getInt("RR"), new Date(1000L * rs.getLong("RT")), invalidityTime);
                } else {
                    revInfo = new CertRevInfoWithSerial((long)id, new BigInteger(serial, 16), CrlReason.REMOVE_FROM_CRL.getCode(), new Date(1000L * rs.getLong("LUPDATE")), null);
                }
                ret.add(revInfo);
            }
            catch (SQLException ex) {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
            }
            finally {
                this.datasource.releaseResources(null, rs);
            }
        }
        return ret;
    }

    public CertStatus getCertStatusForSubject(NameId ca, X500Name subject) throws OperationException {
        long subjectFp = X509Util.fpCanonicalizedName((X500Name)subject);
        return this.getCertStatusForSubjectFp(ca, subjectFp);
    }

    private CertStatus getCertStatusForSubjectFp(NameId ca, long subjectFp) throws OperationException {
        CertStatus certStatus;
        PreparedStatement ps;
        ResultSet rs;
        String sql;
        block5: {
            Args.notNull((Object)ca, (String)"ca");
            sql = this.sqlCertStatusForSubjectFp;
            rs = null;
            ps = this.borrowPreparedStatement(sql);
            ps.setLong(1, subjectFp);
            ps.setInt(2, ca.getId());
            rs = ps.executeQuery();
            if (rs.next()) break block5;
            CertStatus certStatus2 = CertStatus.UNKNOWN;
            this.datasource.releaseResources((Statement)ps, rs);
            return certStatus2;
        }
        try {
            certStatus = rs.getBoolean("REV") ? CertStatus.REVOKED : CertStatus.GOOD;
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return certStatus;
    }

    public boolean isCertForSubjectIssued(NameId ca, long subjectFp) throws OperationException {
        boolean bl;
        Args.notNull((Object)ca, (String)"ca");
        String sql = this.sqlCertforSubjectIssued;
        ResultSet rs = null;
        PreparedStatement ps = this.borrowPreparedStatement(sql);
        try {
            ps.setInt(1, ca.getId());
            ps.setLong(2, subjectFp);
            rs = ps.executeQuery();
            bl = rs.next();
        }
        catch (SQLException ex) {
            try {
                throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(sql, ex).getMessage());
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return bl;
    }

    private String base64Fp(byte[] data) {
        return HashAlgo.SHA1.base64Hash((byte[][])new byte[][]{data});
    }

    private PreparedStatement borrowPreparedStatement(String sqlQuery) throws OperationException {
        try {
            return this.datasource.prepareStatement(sqlQuery);
        }
        catch (DataAccessException ex) {
            LOG.debug("DataAccessException", (Throwable)ex);
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHealthy() {
        String sql = "SELECT ID FROM CA";
        try {
            PreparedStatement ps = this.borrowPreparedStatement("SELECT ID FROM CA");
            ResultSet rs = null;
            try {
                rs = ps.executeQuery();
            }
            finally {
                this.datasource.releaseResources((Statement)ps, rs);
            }
            return true;
        }
        catch (Exception ex) {
            LOG.error("isHealthy(). {}: {}", (Object)ex.getClass().getName(), (Object)ex.getMessage());
            LOG.debug("isHealthy()", (Throwable)ex);
            return false;
        }
    }

    public String getLatestSerialNumber(X500Name nameWithSn) throws OperationException {
        String subjectStr;
        RDN[] rdns1 = nameWithSn.getRDNs();
        RDN[] rdns2 = new RDN[rdns1.length];
        for (int i = 0; i < rdns1.length; ++i) {
            RDN rdn = rdns1[i];
            rdns2[i] = rdn.getFirst().getType().equals((ASN1Primitive)ObjectIdentifiers.DN.serialNumber) ? new RDN(ObjectIdentifiers.DN.serialNumber, (ASN1Encodable)new DERPrintableString("%")) : rdn;
        }
        String namePattern = X509Util.getRfc4519Name((X500Name)new X500Name(rdns2));
        String sql = this.sqlLatestSerialForSubjectLike;
        ResultSet rs = null;
        PreparedStatement ps = this.borrowPreparedStatement(sql);
        try {
            ps.setString(1, namePattern);
            rs = ps.executeQuery();
            if (!rs.next()) {
                String string = null;
                return string;
            }
            subjectStr = rs.getString("SUBJECT");
        }
        catch (SQLException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, ex.getMessage());
        }
        finally {
            this.datasource.releaseResources((Statement)ps, rs);
        }
        X500Name lastName = new X500Name(subjectStr);
        RDN[] rdns = lastName.getRDNs(ObjectIdentifiers.DN.serialNumber);
        if (rdns == null || rdns.length == 0) {
            return null;
        }
        return X509Util.rdnValueToString((ASN1Encodable)rdns[0].getFirst().getValue());
    }

    public void deleteUnreferencedRequests() throws OperationException {
        String sql = SQL_DELETE_UNREFERENCED_REQUEST;
        PreparedStatement ps = this.borrowPreparedStatement(SQL_DELETE_UNREFERENCED_REQUEST);
        ResultSet rs = null;
        try {
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(SQL_DELETE_UNREFERENCED_REQUEST, ex).getMessage());
        }
        finally {
            this.datasource.releaseResources((Statement)ps, rs);
        }
    }

    public long addRequest(byte[] request) throws OperationException {
        Args.notNull((Object)request, (String)"request");
        long id = this.idGenerator.nextId();
        long currentTimeSeconds = System.currentTimeMillis() / 1000L;
        String b64Request = Base64.encodeToString((byte[])request);
        String sql = SQL_ADD_REQUEST;
        PreparedStatement ps = this.borrowPreparedStatement(SQL_ADD_REQUEST);
        try {
            ps.setLong(1, id);
            ps.setLong(2, currentTimeSeconds);
            ps.setString(3, b64Request);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(SQL_ADD_REQUEST, ex).getMessage());
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
        return id;
    }

    public void addRequestCert(long requestId, long certId) throws OperationException {
        String sql = SQL_ADD_REQCERT;
        long id = this.idGenerator.nextId();
        PreparedStatement ps = this.borrowPreparedStatement(SQL_ADD_REQCERT);
        try {
            ps.setLong(1, id);
            ps.setLong(2, requestId);
            ps.setLong(3, certId);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new OperationException(OperationException.ErrorCode.DATABASE_FAILURE, this.datasource.translate(SQL_ADD_REQCERT, ex).getMessage());
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    private String getSqlCidFromPublishQueue(int numEntries) {
        String sql = (String)this.cacheSqlCidFromPublishQueue.get((Object)numEntries);
        if (sql == null) {
            sql = this.datasource.buildSelectFirstSql(numEntries, "CID ASC", "CID FROM PUBLISHQUEUE WHERE PID=? AND CA_ID=?");
            this.cacheSqlCidFromPublishQueue.put((Object)numEntries, (Object)sql);
        }
        return sql;
    }

    private String getSqlExpiredSerials(int numEntries) {
        String sql = (String)this.cacheSqlExpiredSerials.get((Object)numEntries);
        if (sql == null) {
            sql = this.datasource.buildSelectFirstSql(numEntries, "SN FROM CERT WHERE CA_ID=? AND NAFTER<?");
            this.cacheSqlExpiredSerials.put((Object)numEntries, (Object)sql);
        }
        return sql;
    }

    private String getSqlSuspendedSerials(int numEntries) {
        String sql = (String)this.cacheSqlSuspendedSerials.get((Object)numEntries);
        if (sql == null) {
            sql = this.datasource.buildSelectFirstSql(numEntries, "SN FROM CERT WHERE CA_ID=? AND LUPDATE<? AND RR=?");
            this.cacheSqlSuspendedSerials.put((Object)numEntries, (Object)sql);
        }
        return sql;
    }

    private String getSqlDeltaCrlCacheIds(int numEntries) {
        String sql = (String)this.cacheSqlDeltaCrlCacheIds.get((Object)numEntries);
        if (sql == null) {
            sql = this.datasource.buildSelectFirstSql(numEntries, "ID ASC", "ID FROM DELTACRL_CACHE WHERE ID>? AND CA_ID=?");
            this.cacheSqlDeltaCrlCacheIds.put((Object)numEntries, (Object)sql);
        }
        return sql;
    }

    private String getSqlRevokedCerts(int numEntries, boolean withEe) {
        LruCache<Integer, String> cache = withEe ? this.cacheSqlRevokedCertsWithEe : this.cacheSqlRevokedCerts;
        String sql = (String)cache.get((Object)numEntries);
        if (sql == null) {
            String coreSql = "ID,SN,RR,RT,RIT FROM CERT WHERE ID>? AND CA_ID=? AND REV=1 AND NAFTER>?";
            if (withEe) {
                coreSql = coreSql + " AND EE=?";
            }
            sql = this.datasource.buildSelectFirstSql(numEntries, "ID ASC", coreSql);
            cache.put((Object)numEntries, (Object)sql);
        }
        return sql;
    }

    private String getSqlSerials(int numEntries, boolean onlyRevoked) {
        LruCache<Integer, String> cache = onlyRevoked ? this.cacheSqlSerialsRevoked : this.cacheSqlSerials;
        String sql = (String)cache.get((Object)numEntries);
        if (sql == null) {
            String coreSql = "ID,SN FROM CERT WHERE ID>? AND CA_ID=?";
            if (onlyRevoked) {
                coreSql = coreSql + "AND REV=1";
            }
            sql = this.datasource.buildSelectFirstSql(numEntries, "ID ASC", coreSql);
            cache.put((Object)numEntries, (Object)sql);
        }
        return sql;
    }

    private String getSqlSerials(int numEntries, Date notExpiredAt, boolean onlyRevoked, boolean withEe) {
        String sql = StringUtil.concat((String)"ID,SN FROM CERT WHERE ID>? AND CA_ID=?", (String[])new String[]{notExpiredAt != null ? " AND NAFTER>?" : "", onlyRevoked ? " AND REV=1" : "", withEe ? " AND EE=?" : ""});
        return this.datasource.buildSelectFirstSql(numEntries, "ID ASC", sql);
    }

    private static void setBoolean(PreparedStatement ps, int index, boolean value) throws SQLException {
        ps.setInt(index, value ? 1 : 0);
    }

    private static void setLong(PreparedStatement ps, int index, Long value) throws SQLException {
        if (value != null) {
            ps.setLong(index, value);
        } else {
            ps.setNull(index, -5);
        }
    }

    private static void setInt(PreparedStatement ps, int index, Integer value) throws SQLException {
        if (value != null) {
            ps.setInt(index, value);
        } else {
            ps.setNull(index, 4);
        }
    }

    private static void setDateSeconds(PreparedStatement ps, int index, Date date) throws SQLException {
        if (date != null) {
            ps.setLong(index, date.getTime() / 1000L);
        } else {
            ps.setNull(index, -5);
        }
    }

    static class SerialWithId {
        private long id;
        private BigInteger serial;

        public SerialWithId(long id, BigInteger serial) {
            this.id = id;
            this.serial = serial;
        }

        public BigInteger getSerial() {
            return this.serial;
        }

        public long getId() {
            return this.id;
        }
    }

    static class KnowCertResult {
        public static final KnowCertResult UNKNOWN = new KnowCertResult(false, null);
        private final boolean known;
        private final Integer userId;

        public KnowCertResult(boolean known, Integer userId) {
            this.known = known;
            this.userId = userId;
        }

        public boolean isKnown() {
            return this.known;
        }

        public Integer getUserId() {
            return this.userId;
        }
    }

    private class DbSchemaInfo {
        private final Map<String, String> variables = new HashMap<String, String>();

        public DbSchemaInfo(DataSourceWrapper datasource) throws DataAccessException {
            Args.notNull((Object)datasource, (String)"datasource");
            String sql = "SELECT NAME,VALUE2 FROM DBSCHEMA";
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = datasource.createStatement();
                if (stmt == null) {
                    throw new DataAccessException("could not create statement");
                }
                rs = stmt.executeQuery("SELECT NAME,VALUE2 FROM DBSCHEMA");
                while (rs.next()) {
                    String name = rs.getString("NAME");
                    String value = rs.getString("VALUE2");
                    this.variables.put(name, value);
                }
            }
            catch (SQLException ex) {
                try {
                    throw datasource.translate("SELECT NAME,VALUE2 FROM DBSCHEMA", ex);
                }
                catch (Throwable throwable) {
                    datasource.releaseResources(stmt, rs);
                    throw throwable;
                }
            }
            datasource.releaseResources(stmt, rs);
        }

        public String variableValue(String variableName) {
            return this.variables.get(Args.notNull((Object)variableName, (String)"variableName"));
        }
    }

    static enum CertStatus {
        UNKNOWN,
        REVOKED,
        GOOD;

    }
}

