/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.IOException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertificateException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.OperationException;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CmpControl;
import org.xipki.ca.api.mgmt.CrlControl;
import org.xipki.ca.api.mgmt.CtlogControl;
import org.xipki.ca.api.mgmt.MgmtEntry;
import org.xipki.ca.api.mgmt.ProtocolSupport;
import org.xipki.ca.api.mgmt.RevokeSuspendedControl;
import org.xipki.ca.api.mgmt.ScepControl;
import org.xipki.ca.api.mgmt.ValidityMode;
import org.xipki.ca.server.CaIdNameMap;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.CaManagerImpl;
import org.xipki.ca.server.CertStore;
import org.xipki.ca.server.IdentifiedCertPublisher;
import org.xipki.ca.server.IdentifiedCertprofile;
import org.xipki.ca.server.PasswordHash;
import org.xipki.ca.server.RequestorEntryWrapper;
import org.xipki.ca.server.SignerEntryWrapper;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.InvalidConfException;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.StringUtil;
import org.xipki.util.Validity;

class CaManagerQueryExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(CaManagerQueryExecutor.class);
    private static final ColumnType INT = ColumnType.INT;
    private static final ColumnType BOOL = ColumnType.BOOL;
    private static final ColumnType STRING = ColumnType.STRING;
    private final DataSourceWrapper datasource;
    private final String sqlSelectProfileId;
    private final String sqlSelectProfile;
    private final String sqlSelectPublisherId;
    private final String sqlSelectPublisher;
    private final String sqlSelectRequestorId;
    private final String sqlSelectRequestor;
    private final String sqlSelectSigner;
    private final String sqlSelectCaId;
    private final String sqlSelectCa;
    private final String sqlNextSelectCrlNo;
    private final String sqlSelectSystemEvent;
    private final String sqlSelectUserId;
    private final String sqlSelectUser;

    CaManagerQueryExecutor(DataSourceWrapper datasource) {
        this.datasource = (DataSourceWrapper)Args.notNull((Object)datasource, (String)"datasource");
        this.sqlSelectProfileId = this.buildSelectFirstSql("ID FROM PROFILE WHERE NAME=?");
        this.sqlSelectProfile = this.buildSelectFirstSql("ID,TYPE,CONF FROM PROFILE WHERE NAME=?");
        this.sqlSelectPublisherId = this.buildSelectFirstSql("ID FROM PUBLISHER WHERE NAME=?");
        this.sqlSelectPublisher = this.buildSelectFirstSql("ID,TYPE,CONF FROM PUBLISHER WHERE NAME=?");
        this.sqlSelectRequestorId = this.buildSelectFirstSql("ID FROM REQUESTOR WHERE NAME=?");
        this.sqlSelectRequestor = this.buildSelectFirstSql("ID,TYPE,CONF FROM REQUESTOR WHERE NAME=?");
        this.sqlSelectSigner = this.buildSelectFirstSql("TYPE,CERT,CONF FROM SIGNER WHERE NAME=?");
        this.sqlSelectCaId = this.buildSelectFirstSql("ID FROM CA WHERE NAME=?");
        this.sqlSelectCa = this.buildSelectFirstSql("ID,SN_SIZE,NEXT_CRLNO,STATUS,MAX_VALIDITY,CERT,CERTCHAIN,SIGNER_TYPE,CMP_RESPONDER_NAME,SCEP_RESPONDER_NAME,CRL_SIGNER_NAME,CMP_CONTROL,CRL_CONTROL,SCEP_CONTROL,CTLOG_CONTROL,PROTOCOL_SUPPORT,SAVE_REQ,PERMISSION,NUM_CRLS,KEEP_EXPIRED_CERT_DAYS,EXPIRATION_PERIOD,REV_INFO,VALIDITY_MODE,CA_URIS,EXTRA_CONTROL,SIGNER_CONF,DHPOC_CONTROL,REVOKE_SUSPENDED_CONTROL FROM CA WHERE NAME=?");
        this.sqlNextSelectCrlNo = this.buildSelectFirstSql("NEXT_CRLNO FROM CA WHERE ID=?");
        this.sqlSelectSystemEvent = this.buildSelectFirstSql("EVENT_TIME,EVENT_OWNER FROM SYSTEM_EVENT WHERE NAME=?");
        this.sqlSelectUserId = this.buildSelectFirstSql("ID FROM TUSER WHERE NAME=?");
        this.sqlSelectUser = this.buildSelectFirstSql("ID,ACTIVE,PASSWORD FROM TUSER WHERE NAME=?");
    }

    private String buildSelectFirstSql(String coreSql) {
        return this.datasource.buildSelectFirstSql(1, coreSql);
    }

    private X509Cert generateCert(String b64Cert) throws CaMgmtException {
        if (b64Cert == null) {
            return null;
        }
        return CaManagerQueryExecutor.parseCert(Base64.decode((String)b64Cert));
    }

    private List<X509Cert> generateCertchain(String encodedCertchain) throws CaMgmtException {
        if (StringUtil.isBlank((String)encodedCertchain)) {
            return null;
        }
        try {
            List certs = X509Util.listCertificates((String)encodedCertchain);
            return CollectionUtil.isEmpty((Collection)certs) ? null : certs;
        }
        catch (IOException | CertificateException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    private Statement createStatement() throws CaMgmtException {
        try {
            return this.datasource.createStatement();
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    private PreparedStatement prepareStatement(String sql) throws CaMgmtException {
        try {
            return this.datasource.prepareStatement(sql);
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    SystemEvent getSystemEvent(String eventName) throws CaMgmtException {
        SystemEvent systemEvent;
        ResultSet rs;
        PreparedStatement ps;
        String sql;
        block5: {
            sql = this.sqlSelectSystemEvent;
            ps = null;
            rs = null;
            ps = this.prepareStatement(sql);
            ps.setString(1, eventName);
            rs = ps.executeQuery();
            if (rs.next()) break block5;
            SystemEvent systemEvent2 = null;
            this.datasource.releaseResources((Statement)ps, rs);
            return systemEvent2;
        }
        try {
            systemEvent = new SystemEvent(eventName, rs.getString("EVENT_OWNER"), rs.getLong("EVENT_TIME"));
        }
        catch (SQLException ex) {
            try {
                throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex));
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return systemEvent;
    }

    private void deleteSystemEvent(String eventName) throws CaMgmtException {
        String sql = "DELETE FROM SYSTEM_EVENT WHERE NAME=?";
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement("DELETE FROM SYSTEM_EVENT WHERE NAME=?");
            ps.setString(1, eventName);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate("DELETE FROM SYSTEM_EVENT WHERE NAME=?", ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    private void addSystemEvent(SystemEvent systemEvent) throws CaMgmtException {
        String sql = "INSERT INTO SYSTEM_EVENT (NAME,EVENT_TIME,EVENT_TIME2,EVENT_OWNER) VALUES (?,?,?,?)";
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement("INSERT INTO SYSTEM_EVENT (NAME,EVENT_TIME,EVENT_TIME2,EVENT_OWNER) VALUES (?,?,?,?)");
            ps.setString(1, systemEvent.getName());
            ps.setLong(2, systemEvent.getEventTime());
            ps.setTimestamp(3, new Timestamp(systemEvent.getEventTime() * 1000L));
            ps.setString(4, systemEvent.getOwner());
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not add system event " + systemEvent.getName());
            }
            LOG.info("added system event {}", (Object)systemEvent.getName());
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate("INSERT INTO SYSTEM_EVENT (NAME,EVENT_TIME,EVENT_TIME2,EVENT_OWNER) VALUES (?,?,?,?)", ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    void changeSystemEvent(SystemEvent systemEvent) throws CaMgmtException {
        this.deleteSystemEvent(systemEvent.getName());
        this.addSystemEvent(systemEvent);
    }

    Map<String, Integer> createCaAliases() throws CaMgmtException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String sql = "SELECT NAME,CA_ID FROM CAALIAS";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT NAME,CA_ID FROM CAALIAS");
            while (rs.next()) {
                map.put(rs.getString("NAME"), rs.getInt("CA_ID"));
            }
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate("SELECT NAME,CA_ID FROM CAALIAS", ex));
        }
        finally {
            this.datasource.releaseResources(stmt, rs);
        }
        return map;
    }

    MgmtEntry.Certprofile createCertprofile(String name) throws CaMgmtException {
        MgmtEntry.Certprofile certprofile;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = this.sqlSelectProfile;
        try {
            stmt = this.prepareStatement(sql);
            stmt.setString(1, name);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new CaMgmtException("unknown CA " + name);
            }
            certprofile = new MgmtEntry.Certprofile(new NameId(Integer.valueOf(rs.getInt("ID")), name), rs.getString("TYPE"), rs.getString("CONF"));
        }
        catch (SQLException ex) {
            try {
                throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex));
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)stmt, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)stmt, rs);
        return certprofile;
    }

    List<String> namesFromTable(String table) throws CaMgmtException {
        String sql = CaManagerQueryExecutor.concat("SELECT NAME FROM ", table);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery(sql);
            LinkedList<String> names = new LinkedList<String>();
            while (rs.next()) {
                String name = rs.getString("NAME");
                if (!StringUtil.isNotBlank((String)name)) continue;
                names.add(name);
            }
            LinkedList<String> linkedList = names;
            return linkedList;
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex));
        }
        finally {
            this.datasource.releaseResources(stmt, rs);
        }
    }

    MgmtEntry.Publisher createPublisher(String name) throws CaMgmtException {
        MgmtEntry.Publisher publisher;
        String sql = this.sqlSelectPublisher;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement(sql);
            stmt.setString(1, name);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new CaMgmtException("unkown Publisher " + name);
            }
            publisher = new MgmtEntry.Publisher(new NameId(Integer.valueOf(rs.getInt("ID")), name), rs.getString("TYPE"), rs.getString("CONF"));
        }
        catch (SQLException ex) {
            try {
                throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex));
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)stmt, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)stmt, rs);
        return publisher;
    }

    Integer getRequestorId(String requestorName) throws CaMgmtException {
        Integer n;
        ResultSet rs;
        PreparedStatement stmt;
        String sql;
        block5: {
            sql = this.sqlSelectRequestorId;
            stmt = null;
            rs = null;
            stmt = this.prepareStatement(sql);
            stmt.setString(1, requestorName);
            rs = stmt.executeQuery();
            if (rs.next()) break block5;
            Integer n2 = null;
            this.datasource.releaseResources((Statement)stmt, rs);
            return n2;
        }
        try {
            n = rs.getInt("ID");
        }
        catch (SQLException ex) {
            try {
                throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex));
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)stmt, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)stmt, rs);
        return n;
    }

    MgmtEntry.Requestor createRequestor(String name) throws CaMgmtException {
        MgmtEntry.Requestor requestor;
        String sql = this.sqlSelectRequestor;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement(sql);
            stmt.setString(1, name);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new CaMgmtException("unknown Requestor " + name);
            }
            requestor = new MgmtEntry.Requestor(new NameId(Integer.valueOf(rs.getInt("ID")), name), rs.getString("TYPE"), rs.getString("CONF"));
        }
        catch (SQLException ex) {
            try {
                throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex));
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)stmt, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)stmt, rs);
        return requestor;
    }

    MgmtEntry.Signer createSigner(String name) throws CaMgmtException {
        MgmtEntry.Signer signer;
        String sql = this.sqlSelectSigner;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement(sql);
            stmt.setString(1, name);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new CaMgmtException("unknown signer " + name);
            }
            signer = new MgmtEntry.Signer(name, rs.getString("TYPE"), rs.getString("CONF"), rs.getString("CERT"));
        }
        catch (SQLException ex) {
            try {
                throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex));
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)stmt, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)stmt, rs);
        return signer;
    }

    /*
     * Loose catch block
     */
    CaInfo createCaInfo(String name, boolean masterMode, CertStore certstore) throws CaMgmtException {
        String extraControl;
        String scepResponderName;
        String cmpResponderName;
        String sql = this.sqlSelectCa;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        stmt = this.prepareStatement(sql);
        stmt.setString(1, name);
        rs = stmt.executeQuery();
        if (!rs.next()) {
            throw new CaMgmtException("uknown CA " + name);
        }
        String caUrisText = rs.getString("CA_URIS");
        CaUris caUris = caUrisText == null ? null : CaUris.decode((String)caUrisText);
        int snSize = rs.getInt("SN_SIZE");
        if (snSize > 20) {
            snSize = 20;
        } else if (snSize < 9) {
            snSize = 9;
        }
        MgmtEntry.Ca entry = new MgmtEntry.Ca(new NameId(Integer.valueOf(rs.getInt("ID")), name), snSize, rs.getLong("NEXT_CRLNO"), rs.getString("SIGNER_TYPE"), rs.getString("SIGNER_CONF"), caUris, rs.getInt("NUM_CRLS"), rs.getInt("EXPIRATION_PERIOD"));
        entry.setCert(this.generateCert(rs.getString("CERT")));
        entry.setDhpocControl(rs.getString("DHPOC_CONTROL"));
        String str = rs.getString("REVOKE_SUSPENDED_CONTROL");
        RevokeSuspendedControl revokeSuspended = str == null ? new RevokeSuspendedControl(false) : new RevokeSuspendedControl(str);
        entry.setRevokeSuspendedControl(revokeSuspended);
        List<X509Cert> certchain = this.generateCertchain(rs.getString("CERTCHAIN"));
        if (CollectionUtil.isNotEmpty(certchain)) {
            CaManagerQueryExecutor.buildCertChain(entry.getCert(), certchain);
            entry.setCertchain(certchain);
        }
        entry.setStatus(CaStatus.forName((String)rs.getString("STATUS")));
        entry.setMaxValidity(Validity.getInstance((String)rs.getString("MAX_VALIDITY")));
        entry.setKeepExpiredCertInDays(rs.getInt("KEEP_EXPIRED_CERT_DAYS"));
        String crlsignerName = rs.getString("CRL_SIGNER_NAME");
        if (StringUtil.isNotBlank((String)crlsignerName)) {
            entry.setCrlSignerName(crlsignerName);
        }
        if (StringUtil.isNotBlank((String)(cmpResponderName = rs.getString("CMP_RESPONDER_NAME")))) {
            entry.setCmpResponderName(cmpResponderName);
        }
        if (StringUtil.isNotBlank((String)(scepResponderName = rs.getString("SCEP_RESPONDER_NAME")))) {
            entry.setScepResponderName(scepResponderName);
        }
        if (StringUtil.isNotBlank((String)(extraControl = rs.getString("EXTRA_CONTROL")))) {
            entry.setExtraControl(new ConfPairs(extraControl).unmodifiable());
        }
        String cmpcontrol = rs.getString("CMP_CONTROL");
        try {
            entry.setCmpControl(new CmpControl(cmpcontrol));
        }
        catch (InvalidConfException ex) {
            throw new CaMgmtException("invalid CMP_CONTROL: " + cmpcontrol);
        }
        String crlcontrol = rs.getString("CRL_CONTROL");
        if (StringUtil.isNotBlank((String)crlcontrol)) {
            try {
                entry.setCrlControl(new CrlControl(crlcontrol));
            }
            catch (InvalidConfException ex) {
                throw new CaMgmtException("invalid CRL_CONTROL: " + crlcontrol, (Throwable)ex);
            }
        }
        String scepcontrol = rs.getString("SCEP_CONTROL");
        try {
            entry.setScepControl(new ScepControl(scepcontrol));
        }
        catch (InvalidConfException ex) {
            throw new CaMgmtException("invalid SCEP_CONTROL: " + scepcontrol, (Throwable)ex);
        }
        String ctlogControl = rs.getString("CTLOG_CONTROL");
        if (StringUtil.isNotBlank((String)ctlogControl)) {
            try {
                entry.setCtlogControl(new CtlogControl(ctlogControl));
            }
            catch (InvalidConfException ex) {
                throw new CaMgmtException("invalid CTLOG_CONTROL: " + scepcontrol, (Throwable)ex);
            }
        }
        entry.setProtocolSupport(new ProtocolSupport(rs.getString("PROTOCOL_SUPPORT")));
        entry.setSaveRequest(rs.getInt("SAVE_REQ") != 0);
        entry.setPermission(rs.getInt("PERMISSION"));
        String revInfo = rs.getString("REV_INFO");
        CertRevocationInfo revocationInfo = revInfo == null ? null : CertRevocationInfo.fromEncoded((String)revInfo);
        entry.setRevocationInfo(revocationInfo);
        String validityModeS = rs.getString("VALIDITY_MODE");
        entry.setValidityMode(validityModeS == null ? ValidityMode.STRICT : ValidityMode.forName((String)validityModeS));
        CaInfo caInfo = new CaInfo(entry, certstore);
        this.datasource.releaseResources((Statement)stmt, rs);
        return caInfo;
        {
            catch (OperationException ex) {
                try {
                    try {
                        throw new CaMgmtException((Throwable)ex);
                    }
                    catch (SQLException ex2) {
                        throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex2));
                    }
                }
                catch (Throwable throwable) {
                    this.datasource.releaseResources((Statement)stmt, rs);
                    throw throwable;
                }
            }
        }
    }

    Set<MgmtEntry.CaHasRequestor> createCaHasRequestors(NameId ca) throws CaMgmtException {
        HashSet<MgmtEntry.CaHasRequestor> hashSet;
        Map<Integer, String> idNameMap = this.getIdNameMap("REQUESTOR");
        String sql = "SELECT REQUESTOR_ID,RA,PERMISSION,PROFILES FROM CA_HAS_REQUESTOR WHERE CA_ID=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement("SELECT REQUESTOR_ID,RA,PERMISSION,PROFILES FROM CA_HAS_REQUESTOR WHERE CA_ID=?");
            stmt.setInt(1, ca.getId());
            rs = stmt.executeQuery();
            HashSet<MgmtEntry.CaHasRequestor> ret = new HashSet<MgmtEntry.CaHasRequestor>();
            while (rs.next()) {
                int id = rs.getInt("REQUESTOR_ID");
                String name = idNameMap.get(id);
                List list = StringUtil.split((String)rs.getString("PROFILES"), (String)",");
                HashSet profiles = list == null ? null : new HashSet(list);
                MgmtEntry.CaHasRequestor entry = new MgmtEntry.CaHasRequestor(new NameId(Integer.valueOf(id), name));
                entry.setRa(rs.getBoolean("RA"));
                entry.setPermission(rs.getInt("PERMISSION"));
                entry.setProfiles(profiles);
                ret.add(entry);
            }
            hashSet = ret;
        }
        catch (SQLException ex) {
            try {
                throw new CaMgmtException((Throwable)this.datasource.translate("SELECT REQUESTOR_ID,RA,PERMISSION,PROFILES FROM CA_HAS_REQUESTOR WHERE CA_ID=?", ex));
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)stmt, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)stmt, rs);
        return hashSet;
    }

    Set<Integer> createCaHasProfiles(NameId ca) throws CaMgmtException {
        HashSet<Integer> hashSet;
        String sql = "SELECT PROFILE_ID FROM CA_HAS_PROFILE WHERE CA_ID=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement("SELECT PROFILE_ID FROM CA_HAS_PROFILE WHERE CA_ID=?");
            stmt.setInt(1, ca.getId());
            rs = stmt.executeQuery();
            HashSet<Integer> ret = new HashSet<Integer>();
            while (rs.next()) {
                ret.add(rs.getInt("PROFILE_ID"));
            }
            hashSet = ret;
        }
        catch (SQLException ex) {
            try {
                throw new CaMgmtException((Throwable)this.datasource.translate("SELECT PROFILE_ID FROM CA_HAS_PROFILE WHERE CA_ID=?", ex));
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)stmt, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)stmt, rs);
        return hashSet;
    }

    Set<Integer> createCaHasPublishers(NameId ca) throws CaMgmtException {
        HashSet<Integer> hashSet;
        String sql = "SELECT PUBLISHER_ID FROM CA_HAS_PUBLISHER WHERE CA_ID=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement("SELECT PUBLISHER_ID FROM CA_HAS_PUBLISHER WHERE CA_ID=?");
            stmt.setInt(1, ca.getId());
            rs = stmt.executeQuery();
            HashSet<Integer> ret = new HashSet<Integer>();
            while (rs.next()) {
                ret.add(rs.getInt("PUBLISHER_ID"));
            }
            hashSet = ret;
        }
        catch (SQLException ex) {
            try {
                throw new CaMgmtException((Throwable)this.datasource.translate("SELECT PUBLISHER_ID FROM CA_HAS_PUBLISHER WHERE CA_ID=?", ex));
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)stmt, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)stmt, rs);
        return hashSet;
    }

    boolean deleteRowWithName(String name, String table) throws CaMgmtException {
        return this.deleteRowWithName(name, table, false);
    }

    private boolean deleteRowWithName(String name, String table, boolean force) throws CaMgmtException {
        String sql = CaManagerQueryExecutor.concat("DELETE FROM ", table, " WHERE NAME=?");
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(sql);
            ps.setString(1, name);
            boolean bl = ps.executeUpdate() > 0;
            return bl;
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    void addCa(MgmtEntry.Ca caEntry) throws CaMgmtException {
        Args.notNull((Object)caEntry, (String)"caEntry");
        try {
            int id = (int)this.datasource.getMax(null, "CA", "ID");
            caEntry.getIdent().setId(Integer.valueOf(id + 1));
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
        String sql = "INSERT INTO CA (ID,NAME,SUBJECT,SN_SIZE,NEXT_CRLNO,STATUS,CA_URIS,MAX_VALIDITY,CERT,CERTCHAIN,SIGNER_TYPE,CRL_SIGNER_NAME,CMP_RESPONDER_NAME,SCEP_RESPONDER_NAME,CRL_CONTROL,CMP_CONTROL,SCEP_CONTROL,CTLOG_CONTROL,PROTOCOL_SUPPORT,SAVE_REQ,PERMISSION,NUM_CRLS,EXPIRATION_PERIOD,KEEP_EXPIRED_CERT_DAYS,VALIDITY_MODE,EXTRA_CONTROL,SIGNER_CONF,DHPOC_CONTROL,REVOKE_SUSPENDED_CONTROL) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement("INSERT INTO CA (ID,NAME,SUBJECT,SN_SIZE,NEXT_CRLNO,STATUS,CA_URIS,MAX_VALIDITY,CERT,CERTCHAIN,SIGNER_TYPE,CRL_SIGNER_NAME,CMP_RESPONDER_NAME,SCEP_RESPONDER_NAME,CRL_CONTROL,CMP_CONTROL,SCEP_CONTROL,CTLOG_CONTROL,PROTOCOL_SUPPORT,SAVE_REQ,PERMISSION,NUM_CRLS,EXPIRATION_PERIOD,KEEP_EXPIRED_CERT_DAYS,VALIDITY_MODE,EXTRA_CONTROL,SIGNER_CONF,DHPOC_CONTROL,REVOKE_SUSPENDED_CONTROL) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            int idx = 1;
            ps.setInt(idx++, caEntry.getIdent().getId());
            ps.setString(idx++, caEntry.getIdent().getName());
            ps.setString(idx++, caEntry.getSubject());
            ps.setInt(idx++, caEntry.getSerialNoLen());
            ps.setLong(idx++, caEntry.getNextCrlNumber());
            ps.setString(idx++, caEntry.getStatus().getStatus());
            CaUris caUris = caEntry.getCaUris();
            ps.setString(idx++, caUris == null ? null : caEntry.getCaUris().getEncoded());
            ps.setString(idx++, caEntry.getMaxValidity().toString());
            byte[] encodedCert = caEntry.getCert().getEncoded();
            ps.setString(idx++, Base64.encodeToString((byte[])encodedCert));
            List<X509Cert> certchain = caEntry.getCertchain();
            if (CollectionUtil.isEmpty((Collection)certchain)) {
                ps.setString(idx++, null);
            } else {
                certchain = CaManagerQueryExecutor.buildCertChain(caEntry.getCert(), certchain);
                ps.setString(idx++, CaManagerQueryExecutor.encodeCertchain(certchain));
            }
            ps.setString(idx++, caEntry.getSignerType());
            ps.setString(idx++, caEntry.getCrlSignerName());
            ps.setString(idx++, caEntry.getCmpResponderName());
            ps.setString(idx++, caEntry.getScepResponderName());
            CrlControl crlControl = caEntry.getCrlControl();
            ps.setString(idx++, crlControl == null ? null : crlControl.getConf());
            CmpControl cmpControl = caEntry.getCmpControl();
            ps.setString(idx++, cmpControl == null ? null : cmpControl.getConf());
            ScepControl scepControl = caEntry.getScepControl();
            ps.setString(idx++, scepControl == null ? null : scepControl.getConf());
            CtlogControl ctlogControl = caEntry.getCtlogControl();
            ps.setString(idx++, ctlogControl == null ? null : ctlogControl.getConf());
            ProtocolSupport protocolSupport = caEntry.getProtocoSupport();
            ps.setString(idx++, protocolSupport == null ? null : protocolSupport.getEncoded());
            CaManagerQueryExecutor.setBoolean(ps, idx++, caEntry.isSaveRequest());
            ps.setInt(idx++, caEntry.getPermission());
            ps.setInt(idx++, caEntry.getNumCrls());
            ps.setInt(idx++, caEntry.getExpirationPeriod());
            ps.setInt(idx++, caEntry.getKeepExpiredCertInDays());
            ps.setString(idx++, caEntry.getValidityMode().name());
            ConfPairs extraControl = caEntry.getExtraControl();
            String encodedExtraCtrl = extraControl == null ? null : extraControl.getEncoded();
            ps.setString(idx++, StringUtil.isBlank((String)encodedExtraCtrl) ? null : encodedExtraCtrl);
            ps.setString(idx++, caEntry.getSignerConf());
            ps.setString(idx++, caEntry.getDhpocControl());
            RevokeSuspendedControl revokeSuspended = caEntry.getRevokeSuspendedControl();
            ps.setString(idx++, revokeSuspended == null ? null : revokeSuspended.getConf());
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not add CA " + caEntry.getIdent());
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("add CA '{}': {}", (Object)caEntry.getIdent(), (Object)caEntry.toString(false, true));
            }
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate("INSERT INTO CA (ID,NAME,SUBJECT,SN_SIZE,NEXT_CRLNO,STATUS,CA_URIS,MAX_VALIDITY,CERT,CERTCHAIN,SIGNER_TYPE,CRL_SIGNER_NAME,CMP_RESPONDER_NAME,SCEP_RESPONDER_NAME,CRL_CONTROL,CMP_CONTROL,SCEP_CONTROL,CTLOG_CONTROL,PROTOCOL_SUPPORT,SAVE_REQ,PERMISSION,NUM_CRLS,EXPIRATION_PERIOD,KEEP_EXPIRED_CERT_DAYS,VALIDITY_MODE,EXTRA_CONTROL,SIGNER_CONF,DHPOC_CONTROL,REVOKE_SUSPENDED_CONTROL) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    void addCaAlias(String aliasName, NameId ca) throws CaMgmtException {
        Args.notNull((Object)aliasName, (String)"aliasName");
        Args.notNull((Object)ca, (String)"ca");
        String sql = "INSERT INTO CAALIAS (NAME,CA_ID) VALUES (?,?)";
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement("INSERT INTO CAALIAS (NAME,CA_ID) VALUES (?,?)");
            ps.setString(1, aliasName);
            ps.setInt(2, ca.getId());
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not add CA alias " + aliasName);
            }
            LOG.info("added CA alias '{}' for CA '{}'", (Object)aliasName, (Object)ca);
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate("INSERT INTO CAALIAS (NAME,CA_ID) VALUES (?,?)", ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    void addCertprofile(MgmtEntry.Certprofile dbEntry) throws CaMgmtException {
        Args.notNull((Object)dbEntry, (String)"dbEntry");
        String sql = "INSERT INTO PROFILE (ID,NAME,TYPE,CONF) VALUES (?,?,?,?)";
        try {
            int id = (int)this.datasource.getMax(null, "PROFILE", "ID");
            dbEntry.getIdent().setId(Integer.valueOf(id + 1));
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement("INSERT INTO PROFILE (ID,NAME,TYPE,CONF) VALUES (?,?,?,?)");
            int idx = 1;
            ps.setInt(idx++, dbEntry.getIdent().getId());
            ps.setString(idx++, dbEntry.getIdent().getName());
            ps.setString(idx++, dbEntry.getType());
            String conf = dbEntry.getConf();
            ps.setString(idx++, conf);
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not add certprofile " + dbEntry.getIdent());
            }
            LOG.info("added profile '{}': {}", (Object)dbEntry.getIdent(), (Object)dbEntry);
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate("INSERT INTO PROFILE (ID,NAME,TYPE,CONF) VALUES (?,?,?,?)", ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    void addCertprofileToCa(NameId profile, NameId ca) throws CaMgmtException {
        Args.notNull((Object)profile, (String)"profile");
        Args.notNull((Object)ca, (String)"ca");
        String sql = "INSERT INTO CA_HAS_PROFILE (CA_ID,PROFILE_ID) VALUES (?,?)";
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement("INSERT INTO CA_HAS_PROFILE (CA_ID,PROFILE_ID) VALUES (?,?)");
            ps.setInt(1, ca.getId());
            ps.setInt(2, profile.getId());
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not add profile " + profile + " to CA " + ca);
            }
            LOG.info("added profile '{}' to CA '{}'", (Object)profile, (Object)ca);
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate("INSERT INTO CA_HAS_PROFILE (CA_ID,PROFILE_ID) VALUES (?,?)", ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    void addRequestor(MgmtEntry.Requestor dbEntry) throws CaMgmtException {
        Args.notNull((Object)dbEntry, (String)"dbEntry");
        try {
            int id = (int)this.datasource.getMax(null, "REQUESTOR", "ID");
            dbEntry.getIdent().setId(Integer.valueOf(id + 1));
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
        String sql = "INSERT INTO REQUESTOR (ID,NAME,TYPE,CONF) VALUES (?,?,?,?)";
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement("INSERT INTO REQUESTOR (ID,NAME,TYPE,CONF) VALUES (?,?,?,?)");
            ps.setInt(1, dbEntry.getIdent().getId());
            ps.setString(2, dbEntry.getIdent().getName());
            ps.setString(3, dbEntry.getType());
            ps.setString(4, dbEntry.getConf());
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not add requestor " + dbEntry.getIdent());
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("added requestor '{}': {}", (Object)dbEntry.getIdent(), (Object)dbEntry.toString(false));
            }
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate("INSERT INTO REQUESTOR (ID,NAME,TYPE,CONF) VALUES (?,?,?,?)", ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addEmbeddedRequestor(String requestorName) throws CaMgmtException {
        requestorName = requestorName.toLowerCase();
        String sql = this.sqlSelectRequestorId;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            int id = (int)this.datasource.getMax(null, "REQUESTOR", "ID");
            sql = "INSERT INTO REQUESTOR (ID,NAME,TYPE,CONF) VALUES (?,?,?,?)";
            stmt = this.prepareStatement(sql);
            stmt.setInt(1, id + 1);
            stmt.setString(2, requestorName);
            stmt.setString(3, "EMBEDDED");
            stmt.setString(4, "DEFAULT");
            stmt.executeUpdate();
            LOG.info("added requestor '{}'", (Object)requestorName);
        }
        catch (SQLException ex) {
            try {
                throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex));
                catch (DataAccessException ex2) {
                    throw new CaMgmtException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)stmt, rs);
    }

    void addRequestorToCa(MgmtEntry.CaHasRequestor requestor, NameId ca) throws CaMgmtException {
        Args.notNull((Object)requestor, (String)"requestor");
        Args.notNull((Object)ca, (String)"ca");
        NameId requestorIdent = requestor.getRequestorIdent();
        PreparedStatement ps = null;
        String sql = "INSERT INTO CA_HAS_REQUESTOR (CA_ID,REQUESTOR_ID,RA, PERMISSION,PROFILES) VALUES (?,?,?,?,?)";
        try {
            ps = this.prepareStatement("INSERT INTO CA_HAS_REQUESTOR (CA_ID,REQUESTOR_ID,RA, PERMISSION,PROFILES) VALUES (?,?,?,?,?)");
            int idx = 1;
            ps.setInt(idx++, ca.getId());
            ps.setInt(idx++, requestorIdent.getId());
            CaManagerQueryExecutor.setBoolean(ps, idx++, requestor.isRa());
            ps.setInt(idx++, requestor.getPermission());
            String profilesText = StringUtil.collectionAsString((Collection)requestor.getProfiles(), (String)",");
            ps.setString(idx++, profilesText);
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not add requestor " + requestorIdent + " to CA " + ca);
            }
            LOG.info("added requestor '{}' to CA '{}': ra: {}; permission: {}; profile: {}", new Object[]{requestorIdent, ca, requestor.isRa(), requestor.getPermission(), profilesText});
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate("INSERT INTO CA_HAS_REQUESTOR (CA_ID,REQUESTOR_ID,RA, PERMISSION,PROFILES) VALUES (?,?,?,?,?)", ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    void addPublisher(MgmtEntry.Publisher dbEntry) throws CaMgmtException {
        Args.notNull((Object)dbEntry, (String)"dbEntry");
        String sql = "INSERT INTO PUBLISHER (ID,NAME,TYPE,CONF) VALUES (?,?,?,?)";
        try {
            int id = (int)this.datasource.getMax(null, "PUBLISHER", "ID");
            dbEntry.getIdent().setId(Integer.valueOf(id + 1));
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
        String name = dbEntry.getIdent().getName();
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement("INSERT INTO PUBLISHER (ID,NAME,TYPE,CONF) VALUES (?,?,?,?)");
            int idx = 1;
            ps.setInt(idx++, dbEntry.getIdent().getId());
            ps.setString(idx++, name);
            ps.setString(idx++, dbEntry.getType());
            String conf = dbEntry.getConf();
            ps.setString(idx++, conf);
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not add publisher " + dbEntry.getIdent());
            }
            LOG.info("added publisher '{}': {}", (Object)dbEntry.getIdent(), (Object)dbEntry);
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate("INSERT INTO PUBLISHER (ID,NAME,TYPE,CONF) VALUES (?,?,?,?)", ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    void addPublisherToCa(NameId publisher, NameId ca) throws CaMgmtException {
        String sql = "INSERT INTO CA_HAS_PUBLISHER (CA_ID,PUBLISHER_ID) VALUES (?,?)";
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement("INSERT INTO CA_HAS_PUBLISHER (CA_ID,PUBLISHER_ID) VALUES (?,?)");
            ps.setInt(1, ca.getId());
            ps.setInt(2, publisher.getId());
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not add publisher " + publisher + " to CA " + ca);
            }
            LOG.info("added publisher '{}' to CA '{}'", (Object)publisher, (Object)ca);
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate("INSERT INTO CA_HAS_PUBLISHER (CA_ID,PUBLISHER_ID) VALUES (?,?)", ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void changeCa(MgmtEntry.ChangeCa changeCaEntry, MgmtEntry.Ca currentCaEntry, SecurityFactory securityFactory) throws CaMgmtException {
        Args.notNull((Object)changeCaEntry, (String)"changeCaEntry");
        Args.notNull((Object)securityFactory, (String)"securityFactory");
        byte[] encodedCert = changeCaEntry.getEncodedCert();
        if (encodedCert != null) {
            boolean anyCertIssued;
            try {
                anyCertIssued = this.datasource.columnExists(null, "CERT", "CA_ID", (Object)changeCaEntry.getIdent().getId());
            }
            catch (DataAccessException ex) {
                throw new CaMgmtException((Throwable)ex);
            }
            if (anyCertIssued) {
                throw new CaMgmtException("Cannot change certificate of CA which has issued certificates");
            }
        }
        String signerType = changeCaEntry.getSignerType();
        String signerConf = changeCaEntry.getSignerConf();
        X509Cert caCert = null;
        if (signerType != null || signerConf != null || encodedCert != null || CollectionUtil.isNotEmpty((Collection)changeCaEntry.getEncodedCertchain())) {
            ResultSet rs;
            PreparedStatement stmt;
            String sql;
            if (encodedCert != null) {
                caCert = CaManagerQueryExecutor.parseCert(encodedCert);
            } else {
                sql = "SELECT CERT FROM CA WHERE ID=?";
                stmt = null;
                rs = null;
                try {
                    stmt = this.prepareStatement("SELECT CERT FROM CA WHERE ID=?");
                    stmt.setInt(1, changeCaEntry.getIdent().getId());
                    rs = stmt.executeQuery();
                    if (!rs.next()) {
                        throw new CaMgmtException("unknown CA '" + changeCaEntry.getIdent());
                    }
                    caCert = CaManagerQueryExecutor.parseCert(Base64.decode((String)rs.getString("CERT")));
                }
                catch (SQLException ex) {
                    try {
                        throw new CaMgmtException((Throwable)this.datasource.translate("SELECT CERT FROM CA WHERE ID=?", ex));
                    }
                    catch (Throwable throwable) {
                        this.datasource.releaseResources((Statement)stmt, rs);
                        throw throwable;
                    }
                }
                this.datasource.releaseResources((Statement)stmt, rs);
            }
            if (signerType != null || signerConf != null || encodedCert != null) {
                sql = "SELECT SIGNER_TYPE,SIGNER_CONF FROM CA WHERE ID=?";
                stmt = null;
                rs = null;
                try {
                    stmt = this.prepareStatement("SELECT SIGNER_TYPE,SIGNER_CONF FROM CA WHERE ID=?");
                    stmt.setInt(1, changeCaEntry.getIdent().getId());
                    rs = stmt.executeQuery();
                    if (!rs.next()) {
                        throw new CaMgmtException("unknown CA '" + changeCaEntry.getIdent());
                    }
                    if (signerType == null) {
                        signerType = rs.getString("SIGNER_TYPE");
                    }
                    signerConf = signerConf == null ? rs.getString("SIGNER_CONF") : CaManagerImpl.canonicalizeSignerConf(signerType, signerConf, null, securityFactory);
                    try {
                        List signerConfs = MgmtEntry.Ca.splitCaSignerConfs((String)signerConf);
                        for (String[] m : signerConfs) {
                            securityFactory.createSigner(signerType, new SignerConf(m[1]), caCert);
                        }
                    }
                    catch (XiSecurityException | ObjectCreationException ex) {
                        throw new CaMgmtException("could not create signer for CA '" + changeCaEntry.getIdent() + "'" + ex.getMessage(), ex);
                    }
                }
                catch (SQLException ex) {
                    try {
                        throw new CaMgmtException((Throwable)this.datasource.translate("SELECT SIGNER_TYPE,SIGNER_CONF FROM CA WHERE ID=?", ex));
                    }
                    catch (Throwable throwable) {
                        this.datasource.releaseResources((Statement)stmt, rs);
                        throw throwable;
                    }
                }
                this.datasource.releaseResources((Statement)stmt, rs);
            }
        }
        String subject = null;
        String base64Cert = null;
        if (encodedCert != null) {
            try {
                subject = X509Util.parseCert((byte[])encodedCert).getIssuerRfc4519Text();
                base64Cert = Base64.encodeToString((byte[])encodedCert);
            }
            catch (CertificateException ex) {
                throw new CaMgmtException("could not parse the certificate", (Throwable)ex);
            }
        }
        String status = changeCaEntry.getStatus() == null ? null : changeCaEntry.getStatus().name();
        String maxValidity = changeCaEntry.getMaxValidity() == null ? null : changeCaEntry.getMaxValidity().toString();
        String extraControl = changeCaEntry.getExtraControl() == null ? null : changeCaEntry.getExtraControl().getEncoded();
        String validityMode = changeCaEntry.getValidityMode() == null ? null : changeCaEntry.getValidityMode().name();
        String caUrisStr = null;
        CaUris changeUris = changeCaEntry.getCaUris();
        if (changeUris != null && (changeUris.getCacertUris() != null || changeUris.getCrlUris() != null || changeUris.getDeltaCrlUris() != null || changeUris.getOcspUris() != null)) {
            List deltaCrlUris;
            CaUris oldCaUris = currentCaEntry.getCaUris();
            List uris = changeUris.getCacertUris();
            List cacertUris = uris == null ? oldCaUris.getCacertUris() : uris;
            uris = changeUris.getOcspUris();
            List ocspUris = uris == null ? oldCaUris.getOcspUris() : uris;
            uris = changeUris.getCrlUris();
            List crlUris = uris == null ? oldCaUris.getCrlUris() : uris;
            CaUris newCaUris = new CaUris(cacertUris, ocspUris, crlUris, deltaCrlUris = (uris = changeUris.getDeltaCrlUris()) == null ? oldCaUris.getDeltaCrlUris() : uris);
            caUrisStr = newCaUris.getEncoded();
            if (caUrisStr.isEmpty()) {
                caUrisStr = "null";
            }
        }
        String protocolSupportStr = null;
        Boolean supportCmp = changeCaEntry.getSupportCmp();
        Boolean supportRest = changeCaEntry.getSupportRest();
        Boolean supportScep = changeCaEntry.getSupportScep();
        if (supportCmp != null || supportRest != null || supportScep != null) {
            ProtocolSupport oldSupport = currentCaEntry.getProtocoSupport();
            ProtocolSupport support = new ProtocolSupport(oldSupport.isCmp(), oldSupport.isRest(), oldSupport.isScep());
            if (supportCmp != null) {
                support.setCmp(supportCmp.booleanValue());
            }
            if (supportRest != null) {
                support.setRest(supportRest.booleanValue());
            }
            if (supportScep != null) {
                support.setScep(supportScep.booleanValue());
            }
            protocolSupportStr = support.getEncoded();
        }
        String certchainStr = null;
        if (changeCaEntry.getEncodedCertchain() != null) {
            List encodedCertchain = changeCaEntry.getEncodedCertchain();
            if (encodedCertchain.size() == 0) {
                certchainStr = "null";
            } else {
                List<X509Cert> certs = new LinkedList<X509Cert>();
                for (byte[] m : changeCaEntry.getEncodedCertchain()) {
                    certs.add(CaManagerQueryExecutor.parseCert(m));
                }
                certs = CaManagerQueryExecutor.buildCertChain(caCert, certs);
                certchainStr = CaManagerQueryExecutor.encodeCertchain(certs);
            }
        }
        this.changeIfNotNull("CA", CaManagerQueryExecutor.col(INT, "ID", changeCaEntry.getIdent().getId()), CaManagerQueryExecutor.col(INT, "SN_SIZE", changeCaEntry.getSerialNoLen()), CaManagerQueryExecutor.col(STRING, "STATUS", status), CaManagerQueryExecutor.col(STRING, "SUBJECT", subject), CaManagerQueryExecutor.col(STRING, "CERT", base64Cert), CaManagerQueryExecutor.col(STRING, "CERTCHAIN", certchainStr), CaManagerQueryExecutor.col(STRING, "CA_URIS", caUrisStr), CaManagerQueryExecutor.col(STRING, "MAX_VALIDITY", maxValidity), CaManagerQueryExecutor.col(STRING, "SIGNER_TYPE", signerType), CaManagerQueryExecutor.col(STRING, "CRL_SIGNER_NAME", changeCaEntry.getCrlSignerName()), CaManagerQueryExecutor.col(STRING, "CMP_RESPONDER_NAME", changeCaEntry.getCmpResponderName()), CaManagerQueryExecutor.col(STRING, "SCEP_RESPONDER_NAME", changeCaEntry.getScepResponderName()), CaManagerQueryExecutor.col(STRING, "CMP_CONTROL", changeCaEntry.getCmpControl()), CaManagerQueryExecutor.col(STRING, "CRL_CONTROL", changeCaEntry.getCrlControl()), CaManagerQueryExecutor.col(STRING, "SCEP_CONTROL", changeCaEntry.getScepControl()), CaManagerQueryExecutor.col(STRING, "CTLOG_CONTROL", changeCaEntry.getCtlogControl()), CaManagerQueryExecutor.col(STRING, "PROTOCOL_SUPPORT", protocolSupportStr), CaManagerQueryExecutor.col(BOOL, "SAVE_REQ", changeCaEntry.getSaveRequest()), CaManagerQueryExecutor.col(INT, "PERMISSION", changeCaEntry.getPermission()), CaManagerQueryExecutor.col(INT, "NUM_CRLS", changeCaEntry.getNumCrls()), CaManagerQueryExecutor.col(INT, "EXPIRATION_PERIOD", changeCaEntry.getExpirationPeriod()), CaManagerQueryExecutor.col(INT, "KEEP_EXPIRED_CERT_DAYS", changeCaEntry.getKeepExpiredCertInDays()), CaManagerQueryExecutor.col(STRING, "VALIDITY_MODE", validityMode), CaManagerQueryExecutor.col(STRING, "EXTRA_CONTROL", extraControl), CaManagerQueryExecutor.col(STRING, "SIGNER_CONF", signerConf, false, true), CaManagerQueryExecutor.col(STRING, "DHPOC_CONTROL", changeCaEntry.getDhpocControl(), false, true), CaManagerQueryExecutor.col(STRING, "REVOKE_SUSPENDED_CONTROL", changeCaEntry.getRevokeSuspendedControl()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitNextCrlNoIfLess(NameId ca, long nextCrlNo) throws CaMgmtException {
        PreparedStatement ps;
        block8: {
            ps = null;
            try {
                long nextCrlNoInDb;
                String sql = this.sqlNextSelectCrlNo;
                ResultSet rs = null;
                try {
                    ps = this.prepareStatement(sql);
                    ps.setInt(1, ca.getId());
                    rs = ps.executeQuery();
                    rs.next();
                    nextCrlNoInDb = rs.getLong("NEXT_CRLNO");
                }
                catch (SQLException ex) {
                    try {
                        throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex));
                    }
                    catch (Throwable throwable) {
                        this.datasource.releaseResources((Statement)ps, rs);
                        throw throwable;
                    }
                }
                this.datasource.releaseResources((Statement)ps, rs);
                if (nextCrlNoInDb >= nextCrlNo) break block8;
                String updateSql = "UPDATE CA SET NEXT_CRLNO=? WHERE ID=?";
                try {
                    ps = this.prepareStatement("UPDATE CA SET NEXT_CRLNO=? WHERE ID=?");
                    ps.setLong(1, nextCrlNo);
                    ps.setInt(2, ca.getId());
                    ps.executeUpdate();
                }
                catch (SQLException ex) {
                    throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex));
                }
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources(ps, null);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IdentifiedCertprofile changeCertprofile(NameId nameId, String type, String conf, CaManagerImpl caManager) throws CaMgmtException {
        MgmtEntry.Certprofile currentDbEntry = this.createCertprofile(nameId.getName());
        MgmtEntry.Certprofile newDbEntry = new MgmtEntry.Certprofile(currentDbEntry.getIdent(), CaManagerQueryExecutor.str(type, currentDbEntry.getType()), CaManagerQueryExecutor.str(conf, currentDbEntry.getConf()));
        IdentifiedCertprofile profile = caManager.createCertprofile(newDbEntry);
        if (profile == null) {
            throw new CaMgmtException("could not create certprofile object");
        }
        boolean failed = true;
        try {
            this.changeIfNotNull("PROFILE", CaManagerQueryExecutor.col(INT, "ID", nameId.getId()), CaManagerQueryExecutor.col(STRING, "TYPE", type), CaManagerQueryExecutor.col(STRING, "CONF", conf));
            failed = false;
            IdentifiedCertprofile identifiedCertprofile = profile;
            return identifiedCertprofile;
        }
        finally {
            if (failed) {
                profile.close();
            }
        }
    }

    private static SqlColumn col(ColumnType type, String name, Object value) {
        return new SqlColumn(type, name, value);
    }

    private static SqlColumn col(ColumnType type, String name, Object value, boolean sensitive, boolean signerConf) {
        return new SqlColumn(type, name, value, sensitive, signerConf);
    }

    private static String str(String sa, String sb) {
        return sa != null ? CaManagerQueryExecutor.getRealString(sa) : sb;
    }

    private void changeIfNotNull(String tableName, SqlColumn whereColumn, SqlColumn ... columns) throws CaMgmtException {
        StringBuilder buf = new StringBuilder("UPDATE ");
        buf.append(tableName).append(" SET ");
        boolean noAction = true;
        for (SqlColumn col : columns) {
            if (col.getValue() == null) continue;
            noAction = false;
            buf.append(col.getName()).append("=?,");
        }
        if (noAction) {
            throw new IllegalArgumentException("nothing to change");
        }
        buf.deleteCharAt(buf.length() - 1);
        buf.append(" WHERE ").append(whereColumn.getName()).append("=?");
        String sql = buf.toString();
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(sql);
            HashMap<String, String> changedColumns = new HashMap<String, String>();
            int index = 1;
            for (SqlColumn col : columns) {
                if (col.getValue() == null) continue;
                this.setColumn(changedColumns, ps, index, col);
                ++index;
            }
            this.setColumn(null, ps, index, whereColumn);
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not update table " + tableName);
            }
            LOG.info("updated table {} WHERE {}={}: {}", new Object[]{tableName, whereColumn.getName(), whereColumn.getValue(), changedColumns});
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    private void setColumn(Map<String, String> changedColumns, PreparedStatement ps, int index, SqlColumn column) throws SQLException {
        String valText;
        String name = column.getName();
        ColumnType type = column.getType();
        Object value = column.getValue();
        boolean sensitive = column.isSensitive();
        if (type == STRING) {
            String val = CaManagerQueryExecutor.getRealString((String)value);
            ps.setString(index, val);
            valText = val;
            if (val != null && column.isSignerConf() && (valText = SignerConf.eraseSensitiveData((String)valText)).length() > 100) {
                valText = StringUtil.concat((String)valText.substring(0, 97), (String[])new String[]{"..."});
            }
        } else if (type == ColumnType.INT) {
            if (value == null) {
                ps.setNull(index, 4);
                valText = "null";
            } else {
                int val = (Integer)value;
                ps.setInt(index, val);
                valText = Integer.toString(val);
            }
        } else if (type == ColumnType.BOOL) {
            if (value == null) {
                ps.setNull(index, 4);
                valText = "null";
            } else {
                int val = (Boolean)value != false ? 1 : 0;
                ps.setInt(index, val);
                valText = Integer.toString(val);
            }
        } else {
            throw new IllegalStateException("should not reach here, unknown type " + (Object)((Object)column.getType()));
        }
        if (changedColumns != null) {
            changedColumns.put(name, sensitive ? "*****" : valText);
        }
    }

    RequestorEntryWrapper changeRequestor(NameId nameId, String type, String conf, PasswordResolver passwordResolver) throws CaMgmtException {
        Args.notNull((Object)nameId, (String)"nameId");
        RequestorEntryWrapper requestor = new RequestorEntryWrapper();
        if ("pbm".equalsIgnoreCase(type) && !StringUtil.startsWithIgnoreCase((String)conf, (String)"PBE:")) {
            try {
                conf = passwordResolver.protectPassword("PBE", conf.toCharArray());
            }
            catch (PasswordResolverException ex) {
                throw new CaMgmtException("could not encrypt requestor " + nameId.getName(), (Throwable)ex);
            }
        }
        requestor.setDbEntry(new MgmtEntry.Requestor(nameId, type, conf), passwordResolver);
        if (requestor.getDbEntry().isFaulty()) {
            throw new CaMgmtException("invalid requestor configuration");
        }
        this.changeIfNotNull("REQUESTOR", CaManagerQueryExecutor.col(INT, "ID", nameId.getId()), CaManagerQueryExecutor.col(STRING, "TYPE", type), CaManagerQueryExecutor.col(STRING, "CONF", conf));
        return requestor;
    }

    SignerEntryWrapper changeSigner(String name, String type, String conf, String base64Cert, CaManagerImpl caManager, SecurityFactory securityFactory) throws CaMgmtException {
        String tmpType;
        Args.notBlank((String)name, (String)"name");
        Args.notNull((Object)caManager, (String)"caManager");
        MgmtEntry.Signer dbEntry = this.createSigner(name);
        String string = tmpType = type == null ? dbEntry.getType() : type;
        if (conf != null) {
            conf = CaManagerImpl.canonicalizeSignerConf(tmpType, conf, null, securityFactory);
        }
        MgmtEntry.Signer newDbEntry = new MgmtEntry.Signer(name, tmpType, conf == null ? dbEntry.getConf() : conf, base64Cert == null ? dbEntry.getBase64Cert() : base64Cert);
        SignerEntryWrapper responder = caManager.createSigner(newDbEntry);
        this.changeIfNotNull("SIGNER", CaManagerQueryExecutor.col(STRING, "NAME", name), CaManagerQueryExecutor.col(STRING, "TYPE", type), CaManagerQueryExecutor.col(STRING, "CERT", base64Cert), CaManagerQueryExecutor.col(STRING, "CONF", conf, false, true));
        return responder;
    }

    IdentifiedCertPublisher changePublisher(String name, String type, String conf, CaManagerImpl caManager) throws CaMgmtException {
        Args.notBlank((String)name, (String)"name");
        Args.notNull((Object)caManager, (String)"caManager");
        MgmtEntry.Publisher currentDbEntry = this.createPublisher(name);
        MgmtEntry.Publisher dbEntry = new MgmtEntry.Publisher(currentDbEntry.getIdent(), type == null ? currentDbEntry.getType() : type, conf == null ? currentDbEntry.getConf() : conf);
        IdentifiedCertPublisher publisher = caManager.createPublisher(dbEntry);
        this.changeIfNotNull("PUBLISHER", CaManagerQueryExecutor.col(STRING, "NAME", name), CaManagerQueryExecutor.col(STRING, "TYPE", type), CaManagerQueryExecutor.col(STRING, "CONF", conf));
        return publisher;
    }

    void removeCa(String caName) throws CaMgmtException {
        Args.notBlank((String)caName, (String)"caName");
        String sql = "DELETE FROM CA WHERE NAME=?";
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement("DELETE FROM CA WHERE NAME=?");
            ps.setString(1, caName);
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not delelted CA " + caName);
            }
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate("DELETE FROM CA WHERE NAME=?", ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    void removeCaAlias(String aliasName) throws CaMgmtException {
        Args.notBlank((String)aliasName, (String)"aliasName");
        String sql = "DELETE FROM CAALIAS WHERE NAME=?";
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement("DELETE FROM CAALIAS WHERE NAME=?");
            ps.setString(1, aliasName);
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not remove CA Alias " + aliasName);
            }
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate("DELETE FROM CAALIAS WHERE NAME=?", ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    void removeCertprofileFromCa(String profileName, String caName) throws CaMgmtException {
        Args.notBlank((String)profileName, (String)"profileName");
        Args.notBlank((String)caName, (String)"caName");
        int caId = this.getNonNullIdForName(this.sqlSelectCaId, caName);
        int profileId = this.getNonNullIdForName(this.sqlSelectProfileId, profileName);
        String sql = "DELETE FROM CA_HAS_PROFILE WHERE CA_ID=? AND PROFILE_ID=?";
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement("DELETE FROM CA_HAS_PROFILE WHERE CA_ID=? AND PROFILE_ID=?");
            ps.setInt(1, caId);
            ps.setInt(2, profileId);
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not remove profile " + profileName + " from CA " + caName);
            }
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate("DELETE FROM CA_HAS_PROFILE WHERE CA_ID=? AND PROFILE_ID=?", ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    void removeRequestorFromCa(String requestorName, String caName) throws CaMgmtException {
        Args.notBlank((String)requestorName, (String)"requestorName");
        Args.notBlank((String)caName, (String)"caName");
        int caId = this.getNonNullIdForName(this.sqlSelectCaId, caName);
        int requestorId = this.getNonNullIdForName(this.sqlSelectRequestorId, requestorName);
        String sql = "DELETE FROM CA_HAS_REQUESTOR WHERE CA_ID=? AND REQUESTOR_ID=?";
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement("DELETE FROM CA_HAS_REQUESTOR WHERE CA_ID=? AND REQUESTOR_ID=?");
            ps.setInt(1, caId);
            ps.setInt(2, requestorId);
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not remove requestor " + requestorName + " from CA " + caName);
            }
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate("DELETE FROM CA_HAS_REQUESTOR WHERE CA_ID=? AND REQUESTOR_ID=?", ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    void removePublisherFromCa(String publisherName, String caName) throws CaMgmtException {
        Args.notBlank((String)publisherName, (String)"publisherName");
        Args.notBlank((String)caName, (String)"caName");
        int caId = this.getNonNullIdForName(this.sqlSelectCaId, caName);
        int publisherId = this.getNonNullIdForName(this.sqlSelectPublisherId, publisherName);
        String sql = "DELETE FROM CA_HAS_PUBLISHER WHERE CA_ID=? AND PUBLISHER_ID=?";
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement("DELETE FROM CA_HAS_PUBLISHER WHERE CA_ID=? AND PUBLISHER_ID=?");
            ps.setInt(1, caId);
            ps.setInt(2, publisherId);
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not remove publisher " + publisherName + " from CA " + caName);
            }
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate("DELETE FROM CA_HAS_PUBLISHER WHERE CA_ID=? AND PUBLISHER_ID=?", ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    void revokeCa(String caName, CertRevocationInfo revocationInfo) throws CaMgmtException {
        Args.notBlank((String)caName, (String)"caName");
        Args.notNull((Object)revocationInfo, (String)"revocationInfo");
        String sql = "UPDATE CA SET REV_INFO=? WHERE NAME=?";
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(sql);
            ps.setString(1, revocationInfo.getEncoded());
            ps.setString(2, caName);
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not revoke CA " + caName);
            }
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    void addSigner(MgmtEntry.Signer dbEntry) throws CaMgmtException {
        Args.notNull((Object)dbEntry, (String)"dbEntry");
        String sql = "INSERT INTO SIGNER (NAME,TYPE,CERT,CONF) VALUES (?,?,?,?)";
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement("INSERT INTO SIGNER (NAME,TYPE,CERT,CONF) VALUES (?,?,?,?)");
            int idx = 1;
            ps.setString(idx++, dbEntry.getName());
            ps.setString(idx++, dbEntry.getType());
            ps.setString(idx++, dbEntry.getBase64Cert());
            ps.setString(idx++, dbEntry.getConf());
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not add signer " + dbEntry.getName());
            }
            LOG.info("added signer: {}", (Object)dbEntry.toString(false, true));
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate("INSERT INTO SIGNER (NAME,TYPE,CERT,CONF) VALUES (?,?,?,?)", ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    void unlockCa() throws CaMgmtException {
        String sql = "DELETE FROM SYSTEM_EVENT WHERE NAME='LOCK'";
        Statement stmt = null;
        try {
            stmt = this.createStatement();
            stmt.execute("DELETE FROM SYSTEM_EVENT WHERE NAME='LOCK'");
            if (stmt.getUpdateCount() == 0) {
                throw new CaMgmtException("could not unlock CA");
            }
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate("DELETE FROM SYSTEM_EVENT WHERE NAME='LOCK'", ex));
        }
        finally {
            this.datasource.releaseResources(stmt, null);
        }
    }

    void unrevokeCa(String caName) throws CaMgmtException {
        Args.notBlank((String)caName, (String)"caName");
        LOG.info("Unrevoking of CA '{}'", (Object)caName);
        String sql = "UPDATE CA SET REV_INFO=? WHERE NAME=?";
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement("UPDATE CA SET REV_INFO=? WHERE NAME=?");
            ps.setNull(1, 12);
            ps.setString(2, caName);
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not unrevoke CA " + caName);
            }
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate("UPDATE CA SET REV_INFO=? WHERE NAME=?", ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    void addUser(MgmtEntry.AddUser userEntry) throws CaMgmtException {
        Args.notNull((Object)userEntry, (String)"userEntry");
        String hashedPassword = PasswordHash.createHash(userEntry.getPassword());
        this.addUser(userEntry.getIdent().getName(), userEntry.isActive(), hashedPassword);
    }

    void addUser(MgmtEntry.User userEntry) throws CaMgmtException {
        Args.notNull((Object)userEntry, (String)"userEntry");
        this.addUser(userEntry.getIdent().getName(), userEntry.isActive(), userEntry.getHashedPassword());
    }

    private void addUser(String name, boolean active, String hashedPassword) throws CaMgmtException {
        long id;
        Integer existingId = this.getIdForName(this.sqlSelectUserId, name);
        if (existingId != null) {
            throw new CaMgmtException(CaManagerQueryExecutor.concat("user named '", name, " ' already exists"));
        }
        try {
            long maxId = this.datasource.getMax(null, "TUSER", "ID");
            id = maxId + 1L;
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
        String sql = "INSERT INTO TUSER (ID,NAME,ACTIVE,PASSWORD) VALUES (?,?,?,?)";
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement("INSERT INTO TUSER (ID,NAME,ACTIVE,PASSWORD) VALUES (?,?,?,?)");
            int idx = 1;
            ps.setLong(idx++, id);
            ps.setString(idx++, name);
            CaManagerQueryExecutor.setBoolean(ps, idx++, active);
            ps.setString(idx++, hashedPassword);
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not add user " + name);
            }
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate("INSERT INTO TUSER (ID,NAME,ACTIVE,PASSWORD) VALUES (?,?,?,?)", ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
        LOG.info("added user '{}'", (Object)name);
    }

    void changeUser(MgmtEntry.ChangeUser userEntry) throws CaMgmtException {
        String username = userEntry.getIdent().getName();
        Integer existingId = this.getIdForName(this.sqlSelectUserId, username);
        if (existingId == null) {
            throw new CaMgmtException(CaManagerQueryExecutor.concat("user '", username, " ' does not exist"));
        }
        userEntry.getIdent().setId(existingId);
        String password = userEntry.getPassword();
        String hashedPassword = null;
        if (password != null) {
            hashedPassword = PasswordHash.createHash(password);
        }
        this.changeIfNotNull("TUSER", CaManagerQueryExecutor.col(INT, "ID", existingId), CaManagerQueryExecutor.col(BOOL, "ACTIVE", userEntry.getActive()), CaManagerQueryExecutor.col(STRING, "PASSWORD", hashedPassword, true, false));
    }

    void removeUserFromCa(String username, String caName) throws CaMgmtException {
        Integer id = this.getIdForName(this.sqlSelectUserId, username);
        if (id == null) {
            throw new CaMgmtException("unknown user " + username);
        }
        int caId = this.getNonNullIdForName(this.sqlSelectCaId, caName);
        String sql = "DELETE FROM CA_HAS_USER WHERE CA_ID=? AND USER_ID=?";
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement("DELETE FROM CA_HAS_USER WHERE CA_ID=? AND USER_ID=?");
            ps.setInt(1, caId);
            ps.setInt(2, id);
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not remove user " + username + " from CA " + caName);
            }
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate("DELETE FROM CA_HAS_USER WHERE CA_ID=? AND USER_ID=?", ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    void addUserToCa(MgmtEntry.CaHasUser user, NameId ca) throws CaMgmtException {
        long maxId;
        Args.notNull((Object)user, (String)"user");
        Args.notNull((Object)ca, (String)"ca");
        NameId userIdent = user.getUserIdent();
        Integer existingId = this.getIdForName(this.sqlSelectUserId, userIdent.getName());
        if (existingId == null) {
            throw new CaMgmtException(CaManagerQueryExecutor.concat("user '", userIdent.getName(), " ' does not exist"));
        }
        userIdent.setId(existingId);
        PreparedStatement ps = null;
        String sql = "INSERT INTO CA_HAS_USER (ID,CA_ID,USER_ID, PERMISSION,PROFILES) VALUES (?,?,?,?,?)";
        try {
            maxId = this.datasource.getMax(null, "CA_HAS_USER", "ID");
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
        try {
            ps = this.prepareStatement("INSERT INTO CA_HAS_USER (ID,CA_ID,USER_ID, PERMISSION,PROFILES) VALUES (?,?,?,?,?)");
            int idx = 1;
            ps.setLong(idx++, maxId + 1L);
            ps.setInt(idx++, ca.getId());
            ps.setInt(idx++, userIdent.getId());
            ps.setInt(idx++, user.getPermission());
            String profilesText = StringUtil.collectionAsString((Collection)user.getProfiles(), (String)",");
            ps.setString(idx++, profilesText);
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not add user " + userIdent + " to CA " + ca);
            }
            LOG.info("added user '{}' to CA '{}': permission: {}; profile: {}", new Object[]{userIdent, ca, user.getPermission(), profilesText});
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate("INSERT INTO CA_HAS_USER (ID,CA_ID,USER_ID, PERMISSION,PROFILES) VALUES (?,?,?,?,?)", ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    Map<String, MgmtEntry.CaHasUser> getCaHasUsersForUser(String user, CaIdNameMap idNameMap) throws CaMgmtException {
        HashMap<String, MgmtEntry.CaHasUser> hashMap;
        Integer existingId = this.getIdForName(this.sqlSelectUserId, user);
        if (existingId == null) {
            throw new CaMgmtException(CaManagerQueryExecutor.concat("user '", user, " ' does not exist"));
        }
        String sql = "SELECT CA_ID,PERMISSION,PROFILES FROM CA_HAS_USER WHERE USER_ID=?";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.prepareStatement("SELECT CA_ID,PERMISSION,PROFILES FROM CA_HAS_USER WHERE USER_ID=?");
            ps.setInt(1, existingId);
            rs = ps.executeQuery();
            HashMap<String, MgmtEntry.CaHasUser> ret = new HashMap<String, MgmtEntry.CaHasUser>();
            while (rs.next()) {
                List list = StringUtil.split((String)rs.getString("PROFILES"), (String)",");
                HashSet profiles = list == null ? null : new HashSet(list);
                MgmtEntry.CaHasUser caHasUser = new MgmtEntry.CaHasUser(new NameId(existingId, user));
                caHasUser.setPermission(rs.getInt("PERMISSION"));
                caHasUser.setProfiles(profiles);
                int caId = rs.getInt("CA_ID");
                String caName = idNameMap.getCaName(caId);
                ret.put(caName, caHasUser);
            }
            hashMap = ret;
        }
        catch (SQLException ex) {
            try {
                throw new CaMgmtException((Throwable)this.datasource.translate("SELECT CA_ID,PERMISSION,PROFILES FROM CA_HAS_USER WHERE USER_ID=?", ex));
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return hashMap;
    }

    List<MgmtEntry.CaHasUser> getCaHasUsersForCa(String caName, CaIdNameMap idNameMap) throws CaMgmtException {
        LinkedList<MgmtEntry.CaHasUser> linkedList;
        NameId caIdent = idNameMap.getCa(caName);
        if (caIdent == null) {
            throw new CaMgmtException("unknown CA " + caName);
        }
        String sql = "SELECT NAME,PERMISSION,PROFILES FROM CA_HAS_USER INNER JOIN TUSER ON CA_ID=? AND TUSER.ID=CA_HAS_USER.USER_ID";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.prepareStatement("SELECT NAME,PERMISSION,PROFILES FROM CA_HAS_USER INNER JOIN TUSER ON CA_ID=? AND TUSER.ID=CA_HAS_USER.USER_ID");
            ps.setInt(1, caIdent.getId());
            rs = ps.executeQuery();
            LinkedList<MgmtEntry.CaHasUser> ret = new LinkedList<MgmtEntry.CaHasUser>();
            while (rs.next()) {
                List list = StringUtil.split((String)rs.getString("PROFILES"), (String)",");
                HashSet profiles = list == null ? null : new HashSet(list);
                MgmtEntry.CaHasUser caHasUser = new MgmtEntry.CaHasUser(new NameId(null, rs.getString("NAME")));
                caHasUser.setPermission(rs.getInt("PERMISSION"));
                caHasUser.setProfiles(profiles);
                ret.add(caHasUser);
            }
            linkedList = ret;
        }
        catch (SQLException ex) {
            try {
                throw new CaMgmtException((Throwable)this.datasource.translate("SELECT NAME,PERMISSION,PROFILES FROM CA_HAS_USER INNER JOIN TUSER ON CA_ID=? AND TUSER.ID=CA_HAS_USER.USER_ID", ex));
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return linkedList;
    }

    MgmtEntry.User getUser(String username) throws CaMgmtException {
        return this.getUser(username, false);
    }

    /*
     * Unable to fully structure code
     */
    MgmtEntry.User getUser(String username, boolean nullable) throws CaMgmtException {
        block5: {
            Args.notBlank((String)username, (String)"username");
            ident = new NameId(null, username);
            sql = this.sqlSelectUser;
            rs = null;
            ps = null;
            ps = this.prepareStatement(sql);
            idx = 1;
            ps.setString(idx++, ident.getName());
            rs = ps.executeQuery();
            if (rs.next()) ** GOTO lbl20
            if (!nullable) break block5;
            var8_9 = null;
            this.datasource.releaseResources((Statement)ps, rs);
            return var8_9;
        }
        try {
            throw new CaMgmtException("unknown user " + username);
lbl20:
            // 1 sources

            ident.setId(Integer.valueOf(rs.getInt("ID")));
            var8_10 = new MgmtEntry.User(ident, rs.getBoolean("ACTIVE"), rs.getString("PASSWORD"));
        }
        catch (SQLException ex) {
            try {
                throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex));
            }
            catch (Throwable var9_11) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw var9_11;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return var8_10;
    }

    private static void setBoolean(PreparedStatement ps, int index, boolean bo) throws SQLException {
        ps.setInt(index, bo ? 1 : 0);
    }

    private static String getRealString(String str) {
        return "null".equalsIgnoreCase(str) ? null : str;
    }

    private static String encodeCertchain(List<X509Cert> certs) throws CaMgmtException {
        try {
            return X509Util.encodeCertificates((X509Cert[])certs.toArray(new X509Cert[0]));
        }
        catch (IOException | CertificateException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    private static List<X509Cert> buildCertChain(X509Cert targetCert, List<X509Cert> certs) throws CaMgmtException {
        X509Cert[] certchain;
        try {
            certchain = X509Util.buildCertPath((X509Cert)targetCert, certs, (boolean)false);
        }
        catch (CertPathBuilderException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
        if (certchain == null || certs.size() != certchain.length) {
            throw new CaMgmtException("could not build certchain containing all specified certs");
        }
        return Arrays.asList(certchain);
    }

    private static X509Cert parseCert(byte[] encodedCert) throws CaMgmtException {
        try {
            return X509Util.parseCert((byte[])encodedCert);
        }
        catch (CertificateException ex) {
            throw new CaMgmtException("could not parse certificate", (Throwable)ex);
        }
    }

    private int getNonNullIdForName(String sql, String name) throws CaMgmtException {
        Integer id = this.getIdForName(sql, name);
        if (id != null) {
            return id;
        }
        throw new CaMgmtException(CaManagerQueryExecutor.concat("Found no entry named ", name));
    }

    private Integer getIdForName(String sql, String name) throws CaMgmtException {
        Integer n;
        ResultSet rs;
        PreparedStatement ps;
        block5: {
            ps = null;
            rs = null;
            ps = this.prepareStatement(sql);
            ps.setString(1, name);
            rs = ps.executeQuery();
            if (rs.next()) break block5;
            Integer n2 = null;
            this.datasource.releaseResources((Statement)ps, rs);
            return n2;
        }
        try {
            n = rs.getInt("ID");
        }
        catch (SQLException ex) {
            try {
                throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex));
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return n;
    }

    private Map<Integer, String> getIdNameMap(String tableName) throws CaMgmtException {
        String sql = CaManagerQueryExecutor.concat("SELECT ID,NAME FROM ", tableName);
        Statement ps = null;
        ResultSet rs = null;
        HashMap<Integer, String> ret = new HashMap<Integer, String>();
        try {
            ps = this.createStatement();
            rs = ps.executeQuery(sql);
            while (rs.next()) {
                ret.put(rs.getInt("ID"), rs.getString("NAME"));
            }
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex));
        }
        finally {
            this.datasource.releaseResources(ps, rs);
        }
        return ret;
    }

    private static String concat(String s1, String ... strs) {
        return StringUtil.concat((String)s1, (String[])strs);
    }

    static class SystemEvent {
        private final String name;
        private final String owner;
        private final long eventTime;

        SystemEvent(String name, String owner, long eventTime) {
            this.name = Args.notBlank((String)name, (String)"name");
            this.owner = Args.notBlank((String)owner, (String)"owner");
            this.eventTime = eventTime;
        }

        public String getName() {
            return this.name;
        }

        public String getOwner() {
            return this.owner;
        }

        public long getEventTime() {
            return this.eventTime;
        }
    }

    private static class SqlColumn {
        private ColumnType type;
        private String name;
        private Object value;
        private boolean sensitive;
        private boolean signerConf;

        public SqlColumn(ColumnType type, String name, Object value) {
            this(type, name, value, false, false);
        }

        public SqlColumn(ColumnType type, String name, Object value, boolean sensitive, boolean signerConf) {
            this.type = (ColumnType)((Object)Args.notNull((Object)((Object)type), (String)"type"));
            this.name = (String)Args.notNull((Object)name, (String)"name");
            this.value = value;
            this.sensitive = sensitive;
            this.signerConf = signerConf;
        }

        public ColumnType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isSensitive() {
            return this.sensitive;
        }

        public boolean isSignerConf() {
            return this.signerConf;
        }
    }

    private static enum ColumnType {
        INT,
        STRING,
        BOOL;

    }
}

