/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.ExtensionValue;
import org.xipki.ca.api.profile.ExtensionValues;
import org.xipki.ca.api.profile.SubjectDnSpec;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.FileOrBinary;
import org.xipki.util.FileOrValue;
import org.xipki.util.IoUtil;
import org.xipki.util.PermissionConstants;
import org.xipki.util.StringUtil;

public class CaUtil {
    private static final ASN1ObjectIdentifier id_ce = new ASN1ObjectIdentifier("2.5.29");
    private static final List<ASN1ObjectIdentifier> SORTED_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(Extension.subjectKeyIdentifier, Extension.authorityKeyIdentifier, Extension.basicConstraints, Extension.keyUsage, Extension.extendedKeyUsage, Extension.privateKeyUsagePeriod, Extension.subjectAlternativeName, Extension.issuerAlternativeName, Extension.authorityInfoAccess, Extension.cRLDistributionPoints, Extension.freshestCRL, Extension.certificatePolicies, Extension.qCStatements, Extension.nameConstraints, Extension.policyConstraints, Extension.policyMappings, Extension.subjectInfoAccess, Extension.subjectDirectoryAttributes));

    private CaUtil() {
    }

    public static void addExtensions(ExtensionValues extensionValues, X509v3CertificateBuilder certBuilder) throws CertIOException {
        ExtensionValue value;
        if (extensionValues == null) {
            return;
        }
        for (ASN1ObjectIdentifier type : SORTED_EXTENSIONS) {
            value = extensionValues.removeExtensionTuple(type);
            if (value == null) continue;
            certBuilder.addExtension(type, value.isCritical(), value.getValue());
        }
        for (ASN1ObjectIdentifier type : new HashSet(extensionValues.getExtensionTypes())) {
            if (!type.on(id_ce)) continue;
            value = extensionValues.removeExtensionTuple(type);
            certBuilder.addExtension(type, value.isCritical(), value.getValue());
        }
        for (ASN1ObjectIdentifier type : new HashSet(extensionValues.getExtensionTypes())) {
            if (type.on(ObjectIdentifiers.id_pen)) continue;
            value = extensionValues.removeExtensionTuple(type);
            certBuilder.addExtension(type, value.isCritical(), value.getValue());
        }
        for (ASN1ObjectIdentifier type : new HashSet(extensionValues.getExtensionTypes())) {
            value = extensionValues.removeExtensionTuple(type);
            certBuilder.addExtension(type, value.isCritical(), value.getValue());
        }
    }

    @SafeVarargs
    public static <T> List<T> asModifiableList(T ... a) {
        ArrayList<T> list = new ArrayList<T>(a.length);
        list.addAll(Arrays.asList(a));
        return list;
    }

    @SafeVarargs
    public static <T> void addAll(List<T> list, T ... a) {
        list.addAll(Arrays.asList(a));
    }

    public static BasicConstraints createBasicConstraints(Certprofile.CertLevel level, Integer pathLen) {
        return level == Certprofile.CertLevel.EndEntity ? new BasicConstraints(false) : (pathLen != null ? new BasicConstraints(pathLen.intValue()) : new BasicConstraints(true));
    }

    public static AuthorityInformationAccess createAuthorityInformationAccess(List<String> caIssuerUris, List<String> ocspUris) {
        GeneralName gn;
        if (CollectionUtil.isEmpty(caIssuerUris) && CollectionUtil.isEmpty(ocspUris)) {
            throw new IllegalArgumentException("caIssuerUris and ospUris may not be both empty");
        }
        ASN1EncodableVector accessDescriptions = new ASN1EncodableVector();
        if (CollectionUtil.isNotEmpty(caIssuerUris)) {
            for (String uri : caIssuerUris) {
                gn = new GeneralName(6, uri);
                accessDescriptions.add((ASN1Encodable)new AccessDescription(X509ObjectIdentifiers.id_ad_caIssuers, gn));
            }
        }
        if (CollectionUtil.isNotEmpty(ocspUris)) {
            for (String uri : ocspUris) {
                gn = new GeneralName(6, uri);
                accessDescriptions.add((ASN1Encodable)new AccessDescription(X509ObjectIdentifiers.id_ad_ocsp, gn));
            }
        }
        return AuthorityInformationAccess.getInstance((Object)new DERSequence(accessDescriptions));
    }

    public static CRLDistPoint createCrlDistributionPoints(List<String> crlUris, X500Name caSubject, X500Name crlSignerSubject) {
        Args.notEmpty(crlUris, (String)"crlUris");
        int size = crlUris.size();
        DistributionPoint[] points = new DistributionPoint[1];
        GeneralName[] names = new GeneralName[size];
        for (int i = 0; i < size; ++i) {
            names[i] = new GeneralName(6, crlUris.get(i));
        }
        DistributionPointName pointName = new DistributionPointName(new GeneralNames(names));
        GeneralNames crlIssuer = null;
        if (crlSignerSubject != null && !crlSignerSubject.equals((Object)caSubject)) {
            GeneralName crlIssuerName = new GeneralName(crlSignerSubject);
            crlIssuer = new GeneralNames(crlIssuerName);
        }
        points[0] = new DistributionPoint(pointName, null, crlIssuer);
        return new CRLDistPoint(points);
    }

    public static X500Name sortX509Name(X500Name name) {
        RDN[] requestedRdns = ((X500Name)Args.notNull((Object)name, (String)"name")).getRDNs();
        LinkedList<RDN> rdns = new LinkedList<RDN>();
        List sortedDNs = SubjectDnSpec.getForwardDNs();
        for (ASN1ObjectIdentifier type : sortedDNs) {
            RDN[] thisRdns = CaUtil.getRdns(requestedRdns, type);
            if (thisRdns == null || thisRdns.length == 0) continue;
            rdns.addAll(Arrays.asList(thisRdns));
        }
        return new X500Name(rdns.toArray(new RDN[0]));
    }

    private static RDN[] getRdns(RDN[] rdns, ASN1ObjectIdentifier type) {
        Args.notNull((Object)rdns, (String)"rdns");
        Args.notNull((Object)type, (String)"type");
        ArrayList<RDN> ret = new ArrayList<RDN>(1);
        for (RDN rdn : rdns) {
            if (!rdn.getFirst().getType().equals((ASN1Primitive)type)) continue;
            ret.add(rdn);
        }
        return CollectionUtil.isEmpty(ret) ? null : ret.toArray(new RDN[0]);
    }

    public static String canonicalizeSignerConf(String signerConf) throws CaMgmtException {
        byte[] ksBytes;
        String keystoreConf;
        if (!signerConf.contains("file:") && !signerConf.contains("base64:")) {
            return signerConf;
        }
        ConfPairs pairs = new ConfPairs(signerConf);
        String algo = pairs.value("algo");
        if (algo != null) {
            try {
                algo = SignAlgo.getInstance((String)algo).getJceName();
            }
            catch (NoSuchAlgorithmException ex) {
                throw new CaMgmtException((Throwable)ex);
            }
            pairs.putPair("algo", algo);
        }
        if (StringUtil.startsWithIgnoreCase((String)(keystoreConf = pairs.value("keystore")), (String)"file:")) {
            String keystoreFile = keystoreConf.substring("file:".length());
            try {
                ksBytes = IoUtil.read((String)keystoreFile, (boolean)true);
            }
            catch (IOException ex) {
                throw new CaMgmtException("IOException: " + ex.getMessage(), (Throwable)ex);
            }
        } else if (StringUtil.startsWithIgnoreCase((String)keystoreConf, (String)"base64:")) {
            ksBytes = Base64.decode((String)keystoreConf.substring("base64:".length()));
        } else {
            return signerConf;
        }
        pairs.putPair("keystore", "base64:" + Base64.encodeToString((byte[])ksBytes));
        return pairs.getEncoded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileOrValue createFileOrValue(ZipOutputStream zipStream, String content, String fileName) throws IOException {
        if (StringUtil.isBlank((String)content)) {
            return null;
        }
        FileOrValue ret = new FileOrValue();
        if (content.length() < 256) {
            ret.setValue(content);
        } else {
            ret.setFile(fileName);
            ZipEntry certZipEntry = new ZipEntry(fileName);
            zipStream.putNextEntry(certZipEntry);
            try {
                zipStream.write(StringUtil.toUtf8Bytes((String)content));
            }
            finally {
                zipStream.closeEntry();
            }
        }
        return ret;
    }

    public static FileOrBinary createFileOrBase64Value(ZipOutputStream zipStream, String b64Content, String fileName) throws IOException {
        if (StringUtil.isBlank((String)b64Content)) {
            return null;
        }
        return CaUtil.createFileOrBinary(zipStream, Base64.decode((String)b64Content), fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileOrBinary createFileOrBinary(ZipOutputStream zipStream, byte[] content, String fileName) throws IOException {
        if (content == null || content.length == 0) {
            return null;
        }
        FileOrBinary ret = new FileOrBinary();
        if (content.length < 256) {
            ret.setBinary(content);
        } else {
            ret.setFile(fileName);
            ZipEntry certZipEntry = new ZipEntry(fileName);
            zipStream.putNextEntry(certZipEntry);
            try {
                zipStream.write(content);
            }
            finally {
                zipStream.closeEntry();
            }
        }
        return ret;
    }

    public static List<String> getPermissions(int permission) {
        LinkedList<String> list = new LinkedList<String>();
        if (511 == permission) {
            list.add(PermissionConstants.getTextForCode((int)permission));
        } else {
            for (Integer code : PermissionConstants.getPermissions()) {
                if ((permission & code) == 0) continue;
                list.add(PermissionConstants.getTextForCode((int)code));
            }
        }
        return list;
    }

    public static String encodeCertchain(List<X509Cert> certs) throws CaMgmtException {
        try {
            return X509Util.encodeCertificates((X509Cert[])certs.toArray(new X509Cert[0]));
        }
        catch (IOException | CertificateException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    public static List<X509Cert> buildCertChain(X509Cert targetCert, List<X509Cert> certs) throws CaMgmtException {
        X509Cert[] certchain;
        try {
            certchain = X509Util.buildCertPath((X509Cert)targetCert, certs, (boolean)false);
        }
        catch (CertPathBuilderException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
        if (certchain == null || certs.size() != certchain.length) {
            throw new CaMgmtException("could not build certchain containing all specified certs");
        }
        return Arrays.asList(certchain);
    }

    public static X509Cert parseCert(byte[] encodedCert) throws CaMgmtException {
        try {
            return X509Util.parseCert((byte[])encodedCert);
        }
        catch (CertificateException ex) {
            throw new CaMgmtException("could not parse certificate", (Throwable)ex);
        }
    }

    public static X500Name removeEmptyRdns(X500Name name) {
        RDN[] rdns = name.getRDNs();
        ArrayList<RDN> tmpRdns = new ArrayList<RDN>(rdns.length);
        boolean changed = false;
        for (RDN rdn : rdns) {
            String textValue = X509Util.rdnValueToString((ASN1Encodable)rdn.getFirst().getValue());
            if (StringUtil.isBlank((String)textValue)) {
                changed = true;
                continue;
            }
            tmpRdns.add(rdn);
        }
        return changed ? new X500Name(tmpRdns.toArray(new RDN[0])) : name;
    }
}

