/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.math.BigInteger;
import java.util.Date;
import org.xipki.security.CrlReason;
import org.xipki.util.Args;

public class CertRevInfoWithSerial
implements Comparable<CertRevInfoWithSerial> {
    private final long id;
    private final BigInteger serial;
    private CrlReason reason;
    private Date revocationTime;
    private Date invalidityTime;

    public CertRevInfoWithSerial(long id, BigInteger serial, CrlReason reason, Date revocationTime, Date invalidityTime) {
        this.reason = (CrlReason)Args.notNull((Object)reason, (String)"reason");
        this.revocationTime = (Date)Args.notNull((Object)revocationTime, (String)"revocationTime");
        this.invalidityTime = invalidityTime;
        this.id = id;
        this.serial = (BigInteger)Args.notNull((Object)serial, (String)"serial");
    }

    public CertRevInfoWithSerial(long id, BigInteger serial, int reasonCode, Date revocationTime, Date invalidityTime) {
        this(id, serial, CrlReason.forReasonCode((int)reasonCode), revocationTime, invalidityTime);
    }

    public BigInteger getSerial() {
        return this.serial;
    }

    public long getId() {
        return this.id;
    }

    public CrlReason getReason() {
        return this.reason;
    }

    public Date getRevocationTime() {
        if (this.revocationTime == null) {
            this.revocationTime = new Date();
        }
        return this.revocationTime;
    }

    public Date getInvalidityTime() {
        return this.invalidityTime;
    }

    @Override
    public int compareTo(CertRevInfoWithSerial other) {
        return this.serial.compareTo(other.serial);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CertRevInfoWithSerial)) {
            return false;
        }
        CertRevInfoWithSerial o = (CertRevInfoWithSerial)obj;
        return this.id == o.id && this.serial.equals(o.serial);
    }

    public int hashCode() {
        return this.serial.intValue() + 37 * (int)this.id;
    }
}

