/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.xipki.ca.api.profile.BaseCertprofile;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.ExtensionValue;
import org.xipki.ca.api.profile.ExtensionValues;
import org.xipki.ca.api.profile.SubjectDnSpec;
import org.xipki.security.KeyUsage;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.util.CollectionUtil;
import org.xipki.util.exception.BadCertTemplateException;

public class CertprofileUtil {
    public static Certprofile.SubjectInfo getSubject(Certprofile certprofile, X500Name requestedSubject) throws CertprofileException, BadCertTemplateException {
        ASN1ObjectIdentifier[] countryOids;
        Certprofile.SubjectInfo subjectInfo = certprofile.getSubject(requestedSubject);
        if (certprofile.getCertDomain() == Certprofile.CertDomain.CABForumBR) {
            X500Name subject = subjectInfo.getGrantedSubject();
            if (certprofile.getCertLevel() == Certprofile.CertLevel.EndEntity) {
                ASN1ObjectIdentifier[] includeSubjectFields;
                CertificatePolicies policies = certprofile.getCertificatePolicies();
                ASN1ObjectIdentifier policyId = null;
                if (policies != null) {
                    for (PolicyInformation m : policies.getPolicyInformation()) {
                        ASN1ObjectIdentifier pid = m.getPolicyIdentifier();
                        if (!ObjectIdentifiers.BaseRequirements.id_domain_validated.equals((ASN1Primitive)pid) && !ObjectIdentifiers.BaseRequirements.id_organization_validated.equals((ASN1Primitive)pid) && !ObjectIdentifiers.BaseRequirements.id_individual_validated.equals((ASN1Primitive)pid)) continue;
                        policyId = pid;
                        break;
                    }
                }
                if (CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.street) && !CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.O) && !CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.givenName) && !CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.surname)) {
                    throw new BadCertTemplateException("subject:street is prohibited if the subject:organizationName field, subject:givenName, and subject:surname field are absent.");
                }
                if (CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.localityName)) {
                    if (!(CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.O) || CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.givenName) || CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                        throw new BadCertTemplateException("subject:localityName is prohibited if the subject:organizationName field, subject:givenName, and subject:surname field are absent.");
                    }
                } else if (!CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.ST) && (CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.O) || CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.givenName) || CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                    throw new BadCertTemplateException("subject:localityName is required if the subject:organizationName field, subject:givenName field, or subject:surname field are present and the subject:stateOrProvinceName field is absent.");
                }
                if (CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.ST)) {
                    if (!(CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.O) || CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.givenName) || CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                        throw new BadCertTemplateException("subject:stateOrProvinceName is prohibited if the subject:organizationName field, subject:givenName, and subject:surname field are absent.");
                    }
                } else if (!CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.localityName) && (CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.O) || CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.givenName) || CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                    throw new BadCertTemplateException("subject:stateOrProvinceName is required if the subject:organizationName field, subject:givenName field, or subject:surname field are present and the subject:localityName field is absent.");
                }
                if (CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.postalCode) && !CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.O) && !CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.givenName) && !CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.surname)) {
                    throw new BadCertTemplateException("subject:postalCode is prohibited if the subject:organizationName field, subject:givenName, and subject:surname field are absent.");
                }
                if (!CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.C) && (CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.O) || CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.givenName) || CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                    throw new BadCertTemplateException("subject:countryCode is required if the subject:organizationName field, subject:givenName, and subject:surname field are present");
                }
                if (ObjectIdentifiers.BaseRequirements.id_domain_validated.equals((ASN1Primitive)policyId)) {
                    ASN1ObjectIdentifier[] excludeSubjectFields;
                    for (ASN1ObjectIdentifier m : excludeSubjectFields = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.O, ObjectIdentifiers.DN.givenName, ObjectIdentifiers.DN.surname, ObjectIdentifiers.DN.street, ObjectIdentifiers.DN.localityName, ObjectIdentifiers.DN.ST, ObjectIdentifiers.DN.postalCode}) {
                        if (!CertprofileUtil.containsRdn(subject, m)) continue;
                        throw new BadCertTemplateException("subject " + ObjectIdentifiers.getName((ASN1ObjectIdentifier)m) + " is prohibited in domain validated certificate");
                    }
                } else if (ObjectIdentifiers.BaseRequirements.id_organization_validated.equals((ASN1Primitive)policyId)) {
                    for (ASN1ObjectIdentifier m : includeSubjectFields = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.O, ObjectIdentifiers.DN.C}) {
                        if (CertprofileUtil.containsRdn(subject, m)) continue;
                        throw new BadCertTemplateException("subject " + ObjectIdentifiers.getName((ASN1ObjectIdentifier)m) + " is required in organization validated certificate");
                    }
                    if (!CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.localityName) && !CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.ST)) {
                        throw new BadCertTemplateException("at least one of subject:localityName and subject:stateOrProvinceName is required in organization validated certificate");
                    }
                } else if (ObjectIdentifiers.BaseRequirements.id_individual_validated.equals((ASN1Primitive)policyId)) {
                    for (ASN1ObjectIdentifier m : includeSubjectFields = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.C}) {
                        if (CertprofileUtil.containsRdn(subject, m)) continue;
                        throw new BadCertTemplateException("subject " + ObjectIdentifiers.getName((ASN1ObjectIdentifier)m) + " is required in individual validated certificate");
                    }
                    if (!(CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.O) || CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.givenName) && CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.surname))) {
                        throw new BadCertTemplateException("at least one of subject:organizationName and (subject:givenName, subject:surName) is required in individual validated certificate");
                    }
                    if (!CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.localityName) && !CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.ST)) {
                        throw new BadCertTemplateException("at least one of subject:localityName and subject:stateOrProvinceName is required in individual validated certificate");
                    }
                }
            } else {
                ASN1ObjectIdentifier[] requiredTypes;
                for (ASN1ObjectIdentifier m : requiredTypes = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.CN, ObjectIdentifiers.DN.O, ObjectIdentifiers.DN.C}) {
                    if (CertprofileUtil.containsRdn(subject, ObjectIdentifiers.DN.CN)) continue;
                    throw new BadCertTemplateException("missing " + ObjectIdentifiers.getName((ASN1ObjectIdentifier)m) + " in subject");
                }
            }
        }
        for (ASN1ObjectIdentifier oid : countryOids = new ASN1ObjectIdentifier[]{ObjectIdentifiers.DN.C, ObjectIdentifiers.DN.countryOfCitizenship, ObjectIdentifiers.DN.countryOfResidence, ObjectIdentifiers.DN.jurisdictionOfIncorporationCountryName}) {
            RDN[] countryRdns = subjectInfo.getGrantedSubject().getRDNs(oid);
            if (countryRdns == null) continue;
            for (RDN rdn : countryRdns) {
                String textValue = IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue());
                if (SubjectDnSpec.isValidCountryAreaCode((String)textValue)) continue;
                String name = ObjectIdentifiers.getName((ASN1ObjectIdentifier)oid);
                if (name == null) {
                    name = oid.getId();
                }
                throw new BadCertTemplateException("invalid country/area code '" + textValue + "' in subject attribute " + name);
            }
        }
        return subjectInfo;
    }

    static boolean containsRdn(X500Name name, ASN1ObjectIdentifier rdnType) {
        RDN[] rdns = name.getRDNs(rdnType);
        return rdns != null && rdns.length > 0;
    }

    static void addRequestedKeyusage(Set<KeyUsage> usages, Map<ASN1ObjectIdentifier, Extension> requestedExtensions, Set<Certprofile.KeyUsageControl> usageOccs) {
        Extension extension = requestedExtensions.get(Extension.keyUsage);
        if (extension == null) {
            return;
        }
        org.bouncycastle.asn1.x509.KeyUsage reqKeyUsage = org.bouncycastle.asn1.x509.KeyUsage.getInstance((Object)extension.getParsedValue());
        for (Certprofile.KeyUsageControl k : usageOccs) {
            if (k.isRequired() || !reqKeyUsage.hasUsages(k.getKeyUsage().getBcUsage())) continue;
            usages.add(k.getKeyUsage());
        }
    }

    static void addRequestedExtKeyusage(List<ASN1ObjectIdentifier> usages, Map<ASN1ObjectIdentifier, Extension> requestedExtensions, Set<Certprofile.ExtKeyUsageControl> usageOccs) {
        Extension extension = requestedExtensions.get(Extension.extendedKeyUsage);
        if (extension == null) {
            return;
        }
        ExtendedKeyUsage reqKeyUsage = ExtendedKeyUsage.getInstance((Object)extension.getParsedValue());
        for (Certprofile.ExtKeyUsageControl k : usageOccs) {
            if (k.isRequired() || !reqKeyUsage.hasKeyPurposeId(KeyPurposeId.getInstance((Object)k.getExtKeyUsage()))) continue;
            usages.add(k.getExtKeyUsage());
        }
    }

    static ASN1Sequence createSubjectInfoAccess(Map<ASN1ObjectIdentifier, Extension> requestedExtensions, Map<ASN1ObjectIdentifier, Set<Certprofile.GeneralNameMode>> modes) throws BadCertTemplateException {
        if (modes == null) {
            return null;
        }
        Extension extn = requestedExtensions.get(Extension.subjectInfoAccess);
        if (extn == null) {
            return null;
        }
        ASN1Encodable extValue = extn.getParsedValue();
        if (extValue == null) {
            return null;
        }
        ASN1Sequence reqSeq = ASN1Sequence.getInstance((Object)extValue);
        int size = reqSeq.size();
        ASN1EncodableVector vec = new ASN1EncodableVector();
        for (int i = 0; i < size; ++i) {
            AccessDescription ad = AccessDescription.getInstance((Object)reqSeq.getObjectAt(i));
            ASN1ObjectIdentifier accessMethod = ad.getAccessMethod();
            Set<Certprofile.GeneralNameMode> generalNameModes = modes.get(accessMethod);
            if (generalNameModes == null) {
                throw new BadCertTemplateException("subjectInfoAccess.accessMethod " + accessMethod.getId() + " is not allowed");
            }
            GeneralName accessLocation = BaseCertprofile.createGeneralName((GeneralName)ad.getAccessLocation(), generalNameModes);
            vec.add((ASN1Encodable)new AccessDescription(accessMethod, accessLocation));
        }
        return vec.size() > 0 ? new DERSequence(vec) : null;
    }

    static void addExtension(ExtensionValues values, ASN1ObjectIdentifier extType, ExtensionValue extValue, Certprofile.ExtensionControl extControl) throws CertprofileException {
        if (extValue != null) {
            values.addExtension(extType, extValue);
        } else if (extControl.isRequired()) {
            String description = ObjectIdentifiers.getName((ASN1ObjectIdentifier)extType);
            if (description == null) {
                description = extType.getId();
            }
            throw new CertprofileException("could not add required extension " + description);
        }
    }

    static void addExtension(ExtensionValues values, ASN1ObjectIdentifier extType, ASN1Encodable extValue, Certprofile.ExtensionControl extControl) throws CertprofileException {
        if (extValue != null) {
            values.addExtension(extType, extControl.isCritical(), extValue);
        } else if (extControl.isRequired()) {
            String description = ObjectIdentifiers.getName((ASN1ObjectIdentifier)extType);
            if (description == null) {
                description = extType.getId();
            }
            throw new CertprofileException("could not add required extension " + description);
        }
    }

    static String toString(Set<ASN1ObjectIdentifier> oids) {
        if (oids == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (ASN1ObjectIdentifier oid : oids) {
            String name = ObjectIdentifiers.getName((ASN1ObjectIdentifier)oid);
            if (name != null) {
                sb.append(name);
                sb.append(" (").append(oid.getId()).append(")");
            } else {
                sb.append(oid.getId());
            }
            sb.append(", ");
        }
        if (CollectionUtil.isNotEmpty(oids)) {
            int len = sb.length();
            sb.delete(len - 2, len);
        }
        sb.append("]");
        return sb.toString();
    }
}

