/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.slf4j.Logger;
import org.xipki.audit.AuditEvent;
import org.xipki.ca.api.PublicCaInfo;
import org.xipki.ca.api.mgmt.CrlControl;
import org.xipki.ca.api.mgmt.RequestorInfo;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.CertRevInfoWithSerial;
import org.xipki.ca.server.SignerEntryWrapper;
import org.xipki.ca.server.X509CaModule;
import org.xipki.ca.server.X509PublisherModule;
import org.xipki.ca.server.db.CertStore;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.security.ConcurrentBagEntrySigner;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.CrlReason;
import org.xipki.security.KeyUsage;
import org.xipki.security.NoIdleSignerException;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.DateUtil;
import org.xipki.util.HourMinute;
import org.xipki.util.LogUtil;
import org.xipki.util.exception.ErrorCode;
import org.xipki.util.exception.OperationException;

public class X509CrlModule
extends X509CaModule
implements Closeable {
    private final X509Cert caCert;
    private final CertStore certstore;
    private final CaManagerImpl caManager;
    private final AtomicBoolean crlGenInProcess = new AtomicBoolean(false);
    private ScheduledFuture<?> crlGenerationService;
    private final X509PublisherModule publisher;

    public X509CrlModule(CaManagerImpl caManager, CaInfo caInfo, CertStore certstore, X509PublisherModule publisher) throws OperationException {
        super(caInfo);
        X509Cert crlSignerCert;
        this.publisher = publisher;
        this.caManager = (CaManagerImpl)Args.notNull((Object)caManager, (String)"caManager");
        this.caCert = caInfo.getCert();
        this.certstore = (CertStore)Args.notNull((Object)certstore, (String)"certstore");
        if (caInfo.getCrlControl() != null && !(crlSignerCert = caInfo.getCrlSignerName() != null ? this.getCrlSigner().getDbEntry().getCertificate() : this.caCert).hasKeyusage(KeyUsage.cRLSign)) {
            String msg = "CRL signer does not have keyusage cRLSign";
            this.LOG.error("CRL signer does not have keyusage cRLSign");
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, "CRL signer does not have keyusage cRLSign");
        }
        if (!caManager.isMasterMode()) {
            return;
        }
        Random random = new Random();
        ScheduledThreadPoolExecutor executor = caManager.getScheduledThreadPoolExecutor();
        this.crlGenerationService = executor.scheduleAtFixedRate(new CrlGenerationService(), 60 + random.nextInt(60), 60L, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        if (this.crlGenerationService != null) {
            this.crlGenerationService.cancel(false);
            this.crlGenerationService = null;
        }
    }

    public X509CRLHolder getCurrentCrl(RequestorInfo requstor) throws OperationException {
        return this.getCrl(requstor, null);
    }

    public X509CRLHolder getCrl(RequestorInfo requestor, BigInteger crlNumber) throws OperationException {
        this.LOG.info("     START getCrl: ca={}, crlNumber={}", (Object)this.caIdent.getName(), (Object)crlNumber);
        boolean successful = false;
        AuditEvent event = this.newAuditEvent(crlNumber == null ? "download_crl" : "download_crl4number", requestor);
        if (crlNumber != null) {
            event.addEventData("crl_number", (Object)crlNumber);
        }
        try {
            byte[] encodedCrl = this.certstore.getEncodedCrl(this.caIdent, crlNumber);
            if (encodedCrl == null) {
                X509CRLHolder x509CRLHolder = null;
                return x509CRLHolder;
            }
            X509CRLHolder crl = X509Util.parseCrl((byte[])encodedCrl);
            successful = true;
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info("SUCCESSFUL getCrl: ca={}, thisUpdate={}", (Object)this.caIdent.getName(), (Object)crl.getThisUpdate());
            }
            X509CRLHolder x509CRLHolder = crl;
            return x509CRLHolder;
        }
        finally {
            if (!successful) {
                this.LOG.info("    FAILED getCrl: ca={}", (Object)this.caIdent.getName());
            }
            this.finish(event, successful);
        }
    }

    public CertificateList getBcCurrentCrl(RequestorInfo requestor) throws OperationException {
        return this.getBcCrl(requestor, null);
    }

    public CertificateList getBcCrl(RequestorInfo requestor, BigInteger crlNumber) throws OperationException {
        this.LOG.info("     START getCrl: ca={}, crlNumber={}", (Object)this.caIdent.getName(), (Object)crlNumber);
        boolean successful = false;
        AuditEvent event0 = this.newAuditEvent(crlNumber == null ? "download_crl" : "download_crl4number", requestor);
        if (crlNumber != null) {
            event0.addEventData("crl_number", (Object)crlNumber);
        }
        try {
            byte[] encodedCrl = this.certstore.getEncodedCrl(this.caIdent, crlNumber);
            if (encodedCrl == null) {
                CertificateList certificateList = null;
                return certificateList;
            }
            CertificateList crl = CertificateList.getInstance((Object)encodedCrl);
            successful = true;
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info("SUCCESSFUL getCrl: ca={}, thisUpdate={}", (Object)this.caIdent.getName(), (Object)crl.getThisUpdate().getTime());
            }
            CertificateList certificateList = crl;
            return certificateList;
        }
        finally {
            if (!successful) {
                this.LOG.info("    FAILED getCrl: ca={}", (Object)this.caIdent.getName());
            }
            this.finish(event0, successful);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupCrlsWithoutException() {
        try {
            int numCrls = this.caInfo.getNumCrls();
            this.LOG.info("     START cleanupCrls: ca={}, numCrls={}", (Object)this.caIdent.getName(), (Object)numCrls);
            AuditEvent event0 = this.newAuditEvent("cleanup_crl", null);
            boolean succ = false;
            try {
                int num = numCrls <= 0 ? 0 : this.certstore.cleanupCrls(this.caIdent, this.caInfo.getNumCrls());
                succ = true;
                event0.addEventData("num", (Object)num);
                this.LOG.info("SUCCESSFUL cleanupCrls: ca={}, num={}", (Object)this.caIdent.getName(), (Object)num);
            }
            finally {
                if (!succ) {
                    this.LOG.info("    FAILED cleanupCrls: ca={}", (Object)this.caIdent.getName());
                }
                this.finish(event0, succ);
            }
        }
        catch (Throwable th) {
            this.LOG.warn("could not cleanup CRLs.{}: {}", (Object)th.getClass().getName(), (Object)th.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509CRLHolder generateCrlOnDemand(RequestorInfo requestor) throws OperationException {
        CrlControl control = this.caInfo.getCrlControl();
        if (control == null) {
            throw new OperationException(ErrorCode.NOT_PERMITTED, "CA could not generate CRL");
        }
        if (this.crlGenInProcess.get()) {
            throw new OperationException(ErrorCode.SYSTEM_UNAVAILABLE, "TRY_LATER");
        }
        this.crlGenInProcess.set(true);
        try {
            Date thisUpdate = new Date();
            Date nearestScheduledIssueTime = this.getScheduledCrlGenTimeNotAfter(thisUpdate);
            int intervals = !control.isExtendedNextUpdate() && control.getDeltaCrlIntervals() > 0 ? control.getDeltaCrlIntervals() : control.getFullCrlIntervals();
            Date nextUpdate = new Date(nearestScheduledIssueTime.getTime() + (long)intervals * control.getIntervalMillis());
            nextUpdate = control.getOverlap().add(nextUpdate);
            X509CRLHolder x509CRLHolder = this.generateCrl(requestor, false, thisUpdate, nextUpdate);
            return x509CRLHolder;
        }
        finally {
            this.crlGenInProcess.set(false);
        }
    }

    private X509CRLHolder generateCrl(RequestorInfo requestor, boolean deltaCrl, Date thisUpdate, Date nextUpdate) throws OperationException {
        AuditEvent event = this.newAuditEvent("gen_crl", requestor);
        try {
            X509CRLHolder ret = this.generateCrl0(deltaCrl, thisUpdate, nextUpdate, event);
            this.finish(event, true);
            return ret;
        }
        catch (OperationException ex) {
            this.finish(event, false);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509CRLHolder generateCrl0(boolean deltaCrl, Date thisUpdate, Date nextUpdate, AuditEvent event) throws OperationException {
        CrlControl control = this.caInfo.getCrlControl();
        if (control == null) {
            throw new OperationException(ErrorCode.NOT_PERMITTED, "CRL generation is not allowed");
        }
        BigInteger baseCrlNumber = null;
        if (deltaCrl && (baseCrlNumber = this.caInfo.getMaxFullCrlNumber()) == null) {
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, "Should not happen. No FullCRL is available while generating DeltaCRL");
        }
        this.LOG.info("     START generateCrl: ca={}, deltaCRL={}, nextUpdate={}, baseCRLNumber={}", new Object[]{this.caIdent.getName(), deltaCrl, nextUpdate, deltaCrl ? baseCrlNumber : "-"});
        event.addEventData("crl_type", (Object)(deltaCrl ? "DELTA_CRL" : "FULL_CRL"));
        if (nextUpdate == null) {
            event.addEventData("next_update", (Object)"null");
        } else {
            event.addEventData("next_update", (Object)DateUtil.toUtcTimeyyyyMMddhhmmss((Date)nextUpdate));
            if (nextUpdate.getTime() - thisUpdate.getTime() < 600000L) {
                throw new OperationException(ErrorCode.CRL_FAILURE, "nextUpdate and thisUpdate are too close");
            }
        }
        boolean successful = false;
        try {
            X509CRLHolder crl;
            ConcurrentBagEntrySigner concurrentBagEntrySigner;
            SignerEntryWrapper crlSigner = this.getCrlSigner();
            PublicCaInfo pci = this.caInfo.getPublicCaInfo();
            boolean indirectCrl = crlSigner != null;
            X500Name crlIssuer = indirectCrl ? crlSigner.getSubject() : pci.getSubject();
            X509v2CRLBuilder crlBuilder = new X509v2CRLBuilder(crlIssuer, thisUpdate);
            if (nextUpdate != null) {
                crlBuilder.setNextUpdate(nextUpdate);
            }
            int numEntries = 100;
            CrlControl crlControl = this.caInfo.getCrlControl();
            boolean withExpiredCerts = crlControl.isIncludeExpiredcerts();
            Date notExpiredAt = withExpiredCerts ? new Date(0L) : new Date(thisUpdate.getTime() - 600000L);
            List<Object> allRevInfos = new LinkedList();
            if (deltaCrl) {
                allRevInfos = this.certstore.getCertsForDeltaCrl(this.caIdent, baseCrlNumber, notExpiredAt);
            } else {
                List<CertRevInfoWithSerial> list;
                long startId = 1L;
                do {
                    list = this.certstore.getRevokedCerts(this.caIdent, notExpiredAt, startId, 100);
                    allRevInfos.addAll(list);
                    long maxId = 1L;
                    for (CertRevInfoWithSerial revInfo : list) {
                        if (revInfo.getId() <= maxId) continue;
                        maxId = revInfo.getId();
                    }
                    startId = maxId + 1L;
                } while (list.size() >= 100);
                list.clear();
            }
            if (indirectCrl && allRevInfos.isEmpty()) {
                Extensions extensions = new Extensions(X509CrlModule.createCertificateIssuerExtension(pci.getSubject()));
                crlBuilder.addCRLEntry(BigInteger.ZERO, new Date(0L), extensions);
                this.LOG.debug("added cert ca={} serial=0 to the indirect CRL", (Object)this.caIdent);
            } else {
                Collections.sort(allRevInfos);
                boolean isFirstCrlEntry = true;
                for (CertRevInfoWithSerial certRevInfoWithSerial : allRevInfos) {
                    Extension ext;
                    CrlReason reason = certRevInfoWithSerial.getReason();
                    if (crlControl.isExcludeReason() && reason != CrlReason.REMOVE_FROM_CRL) {
                        reason = CrlReason.UNSPECIFIED;
                    }
                    Date revocationTime = certRevInfoWithSerial.getRevocationTime();
                    Date invalidityTime = certRevInfoWithSerial.getInvalidityTime();
                    switch (crlControl.getInvalidityDateMode()) {
                        case forbidden: {
                            invalidityTime = null;
                            break;
                        }
                        case optional: {
                            break;
                        }
                        case required: {
                            if (invalidityTime != null) break;
                            invalidityTime = revocationTime;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unknown TripleState " + crlControl.getInvalidityDateMode());
                        }
                    }
                    BigInteger serial = certRevInfoWithSerial.getSerial();
                    this.LOG.debug("added cert ca={} serial={} to CRL", (Object)this.caIdent, (Object)serial);
                    if (!indirectCrl || !isFirstCrlEntry) {
                        if (invalidityTime != null) {
                            crlBuilder.addCRLEntry(serial, revocationTime, reason.getCode(), invalidityTime);
                            continue;
                        }
                        crlBuilder.addCRLEntry(serial, revocationTime, reason.getCode());
                        continue;
                    }
                    ArrayList<Extension> extensions = new ArrayList<Extension>(3);
                    if (reason != CrlReason.UNSPECIFIED) {
                        ext = X509CrlModule.createReasonExtension(reason.getCode());
                        extensions.add(ext);
                    }
                    if (invalidityTime != null) {
                        ext = X509CrlModule.createInvalidityDateExtension(invalidityTime);
                        extensions.add(ext);
                    }
                    ext = X509CrlModule.createCertificateIssuerExtension(pci.getSubject());
                    extensions.add(ext);
                    crlBuilder.addCRLEntry(serial, revocationTime, new Extensions(extensions.toArray(new Extension[0])));
                    isFirstCrlEntry = false;
                }
                allRevInfos.clear();
            }
            BigInteger crlNumber = this.caInfo.nextCrlNumber();
            event.addEventData("crl_number", (Object)crlNumber);
            if (baseCrlNumber != null) {
                event.addEventData("basecrl_number", (Object)baseCrlNumber);
            }
            try {
                byte[] akiValues = indirectCrl ? crlSigner.getSigner().getCertificate().getSubjectKeyId() : pci.getSubjectKeyIdentifer();
                AuthorityKeyIdentifier authorityKeyIdentifier = new AuthorityKeyIdentifier(akiValues);
                crlBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)authorityKeyIdentifier);
                crlBuilder.addExtension(Extension.cRLNumber, false, (ASN1Encodable)new ASN1Integer(crlNumber));
                if (indirectCrl) {
                    IssuingDistributionPoint idp = new IssuingDistributionPoint(null, false, false, null, true, false);
                    crlBuilder.addExtension(Extension.issuingDistributionPoint, true, (ASN1Encodable)idp);
                }
                if (deltaCrl) {
                    crlBuilder.addExtension(Extension.deltaCRLIndicator, true, (ASN1Encodable)new ASN1Integer(baseCrlNumber));
                }
                List deltaCrlUris = pci.getCaUris().getDeltaCrlUris();
                if (control.getDeltaCrlIntervals() > 0 && CollectionUtil.isNotEmpty((Collection)deltaCrlUris)) {
                    CRLDistPoint cdp = CaUtil.createCrlDistributionPoints(deltaCrlUris, pci.getSubject(), crlIssuer);
                    crlBuilder.addExtension(Extension.freshestCRL, false, (ASN1Encodable)cdp);
                }
                if (withExpiredCerts) {
                    DERGeneralizedTime statusSince = new DERGeneralizedTime(this.caCert.getNotBefore());
                    crlBuilder.addExtension(Extension.expiredCertsOnCRL, false, (ASN1Encodable)statusSince);
                }
            }
            catch (CertIOException ex) {
                LogUtil.error((Logger)this.LOG, (Throwable)ex, (String)"crlBuilder.addExtension");
                throw new OperationException(ErrorCode.INVALID_EXTENSION, (Throwable)ex);
            }
            ConcurrentContentSigner concurrentSigner = crlSigner == null ? this.caInfo.getSigner(null) : crlSigner.getSigner();
            try {
                concurrentBagEntrySigner = concurrentSigner.borrowSigner();
            }
            catch (NoIdleSignerException ex) {
                throw new OperationException(ErrorCode.SYSTEM_FAILURE, "NoIdleSignerException: " + ex.getMessage());
            }
            try {
                crl = crlBuilder.build((ContentSigner)concurrentBagEntrySigner.value());
            }
            finally {
                concurrentSigner.requiteSigner(concurrentBagEntrySigner);
            }
            this.caInfo.setNextCrlNumber(crlNumber.longValue() + 1L);
            this.caManager.commitNextCrlNo(this.caIdent, this.caInfo.getNextCrlNumber());
            this.publisher.publishCrl(crl);
            successful = true;
            this.LOG.info("SUCCESSFUL generateCrl: ca={}, crlNumber={}, thisUpdate={}", new Object[]{this.caIdent.getName(), crlNumber, crl.getThisUpdate()});
            if (!deltaCrl) {
                this.cleanupCrlsWithoutException();
            }
            X509CRLHolder x509CRLHolder = crl;
            return x509CRLHolder;
        }
        finally {
            if (!successful) {
                this.LOG.info("    FAILED generateCrl: ca={}", (Object)this.caIdent.getName());
            }
        }
    }

    private Date getScheduledCrlGenTimeNotAfter(Date date) {
        long time = date.getTime();
        long epochDaysInMillis = time / 86400000L * 86400000L;
        long minutesInDay = (time - epochDaysInMillis) / 60000L;
        int intervalMinutes = this.caInfo.getCrlControl().getIntervalHours() * 60;
        HourMinute hm = this.caInfo.getCrlControl().getIntervalDayTime();
        int hmInMinutes = hm.getHour() * 60 + hm.getMinute();
        if (minutesInDay == (long)hmInMinutes) {
            return new Date(epochDaysInMillis + (long)hmInMinutes * 60000L);
        }
        if (minutesInDay < (long)hmInMinutes) {
            return new Date(epochDaysInMillis + (long)(hmInMinutes - intervalMinutes) * 60000L);
        }
        int i = 0;
        while (minutesInDay >= (long)hmInMinutes + ((long)i + 1L) * (long)intervalMinutes) {
            ++i;
        }
        return new Date(epochDaysInMillis + (long)(hmInMinutes + i * intervalMinutes) * 60000L);
    }

    SignerEntryWrapper getCrlSigner() {
        if (this.caInfo.getCrlControl() == null) {
            return null;
        }
        String crlSignerName = this.caInfo.getCrlSignerName();
        if (crlSignerName == null) {
            return null;
        }
        return this.caManager.getSignerWrapper(crlSignerName);
    }

    boolean healthy() {
        SignerEntryWrapper signer = this.getCrlSigner();
        if (signer != null && signer.getSigner() != null) {
            return signer.isHealthy();
        }
        return true;
    }

    private static Extension createReasonExtension(int reasonCode) {
        CRLReason crlReason = CRLReason.lookup((int)reasonCode);
        try {
            return new Extension(Extension.reasonCode, false, crlReason.getEncoded());
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("error encoding reason: " + ex.getMessage(), ex);
        }
    }

    private static Extension createInvalidityDateExtension(Date invalidityDate) {
        try {
            ASN1GeneralizedTime asnTime = new ASN1GeneralizedTime(invalidityDate);
            return new Extension(Extension.invalidityDate, false, asnTime.getEncoded());
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("error encoding reason: " + ex.getMessage(), ex);
        }
    }

    private static Extension createCertificateIssuerExtension(X500Name certificateIssuer) {
        try {
            GeneralNames generalNames = new GeneralNames(new GeneralName(certificateIssuer));
            return new Extension(Extension.certificateIssuer, true, generalNames.getEncoded());
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("error encoding reason: " + ex.getMessage(), ex);
        }
    }

    private class CrlGenerationService
    implements Runnable {
        private CrlGenerationService() {
        }

        @Override
        public void run() {
            CrlControl crlControl = X509CrlModule.this.caInfo.getCrlControl();
            if (crlControl == null) {
                return;
            }
            if (X509CrlModule.this.crlGenInProcess.get()) {
                return;
            }
            X509CrlModule.this.crlGenInProcess.set(true);
            try {
                this.run0();
            }
            catch (Throwable th) {
                LogUtil.error((Logger)X509CrlModule.this.LOG, (Throwable)th);
            }
            finally {
                X509CrlModule.this.crlGenInProcess.set(false);
            }
        }

        private void run0() throws OperationException {
            long lastIssueTimeOfDeltaCrl;
            long lastIssueTime;
            Date nearestScheduledCrlIssueTime;
            Date nextScheduledCrlIssueTime;
            CrlControl control = X509CrlModule.this.caInfo.getCrlControl();
            long lastIssueTimeOfFullCrl = X509CrlModule.this.certstore.getThisUpdateOfCurrentCrl(X509CrlModule.this.caIdent, false);
            Date now = new Date();
            boolean createFullCrlNow = false;
            if (lastIssueTimeOfFullCrl == 0L) {
                createFullCrlNow = true;
            } else {
                Date nearestScheduledCrlIssueTime2 = X509CrlModule.this.getScheduledCrlGenTimeNotAfter(new Date(lastIssueTimeOfFullCrl * 1000L));
                Date nextScheduledCrlIssueTime2 = new Date(nearestScheduledCrlIssueTime2.getTime() + (long)control.getFullCrlIntervals() * control.getIntervalMillis());
                if (!nextScheduledCrlIssueTime2.after(now)) {
                    createFullCrlNow = true;
                }
            }
            boolean createDeltaCrlNow = false;
            if (control.getDeltaCrlIntervals() > 0 && !createFullCrlNow && !(nextScheduledCrlIssueTime = new Date((nearestScheduledCrlIssueTime = X509CrlModule.this.getScheduledCrlGenTimeNotAfter(new Date((lastIssueTime = Math.max(lastIssueTimeOfDeltaCrl = X509CrlModule.this.certstore.getThisUpdateOfCurrentCrl(X509CrlModule.this.caIdent, true), lastIssueTimeOfFullCrl)) * 1000L))).getTime() + (long)control.getDeltaCrlIntervals() * control.getIntervalMillis())).after(now)) {
                createDeltaCrlNow = true;
            }
            if (!createFullCrlNow && !createDeltaCrlNow) {
                X509CrlModule.this.LOG.debug("No CRL is needed to be created");
                return;
            }
            int intervals = createDeltaCrlNow ? control.getDeltaCrlIntervals() : (!control.isExtendedNextUpdate() && control.getDeltaCrlIntervals() > 0 ? control.getDeltaCrlIntervals() : control.getFullCrlIntervals());
            Date scheduledCrlGenTime = X509CrlModule.this.getScheduledCrlGenTimeNotAfter(now);
            Date nextUpdate = new Date(scheduledCrlGenTime.getTime() + (long)intervals * control.getIntervalMillis());
            nextUpdate = control.getOverlap().add(nextUpdate);
            try {
                X509CrlModule.this.generateCrl(null, createDeltaCrlNow, now, nextUpdate);
            }
            catch (Throwable th) {
                LogUtil.error((Logger)X509CrlModule.this.LOG, (Throwable)th);
            }
        }
    }
}

