/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.server.db.QueryExecutor;
import org.xipki.ca.server.db.ResultRow;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.SignerConf;
import org.xipki.util.StringUtil;

class CaManagerQueryExecutorBase
extends QueryExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(QueryExecutor.class);
    protected int dbSchemaVersion;

    CaManagerQueryExecutorBase(DataSourceWrapper datasource) throws CaMgmtException {
        super(datasource);
        try {
            QueryExecutor.DbSchemaInfo dbSchemaInfo = new QueryExecutor.DbSchemaInfo(datasource);
            this.dbSchemaVersion = Integer.parseInt(dbSchemaInfo.variableValue("VERSION"));
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
        if (this.dbSchemaVersion < 7) {
            throw new CaMgmtException("DB version < 7 is not supported: " + this.dbSchemaVersion);
        }
    }

    public int getDbSchemaVersion() {
        return this.dbSchemaVersion;
    }

    @Override
    protected String buildSelectFirstSql(String coreSql) {
        return this.datasource.buildSelectFirstSql(1, coreSql);
    }

    private Statement createStatement() throws CaMgmtException {
        try {
            return this.datasource.createStatement();
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    private PreparedStatement prepareStatement(String sql) throws CaMgmtException {
        try {
            return this.datasource.prepareStatement(sql);
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    public List<String> namesFromTable(String table) throws CaMgmtException {
        String sql = StringUtil.concat((String)"SELECT NAME FROM ", (String[])new String[]{table});
        List<ResultRow> rows = this.execQueryStmt0(sql);
        LinkedList<String> names = new LinkedList<String>();
        for (ResultRow rs : rows) {
            String name = rs.getString("NAME");
            if (!StringUtil.isNotBlank((String)name)) continue;
            names.add(name);
        }
        return names;
    }

    public boolean deleteRowWithName(String name, String table) throws CaMgmtException {
        String sql = StringUtil.concat((String)"DELETE FROM ", (String[])new String[]{table, " WHERE NAME=?"});
        int num = this.execUpdatePrepStmt0(sql, CaManagerQueryExecutorBase.col2Str(name));
        return num > 0;
    }

    protected static String str(String sa, String sb) {
        return sa != null ? CaManagerQueryExecutorBase.getRealString(sa) : sb;
    }

    protected int execUpdateStmt0(String sql) throws CaMgmtException {
        try {
            return this.execUpdateStmt(sql);
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    protected int execUpdatePrepStmt0(String sql, QueryExecutor.SqlColumn2 ... params) throws CaMgmtException {
        try {
            return this.execUpdatePrepStmt(sql, params);
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    protected List<ResultRow> execQueryStmt0(String sql) throws CaMgmtException {
        try {
            return this.execQueryStmt(sql);
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    protected ResultRow execQuery1PrepStmt0(String sql, QueryExecutor.SqlColumn2 ... params) throws CaMgmtException {
        try {
            return this.execQuery1PrepStmt(sql, params);
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    protected List<ResultRow> execQueryPrepStmt0(String sql, QueryExecutor.SqlColumn2 ... params) throws CaMgmtException {
        try {
            return this.execQueryPrepStmt(sql, params);
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    protected PreparedStatement buildPrepStmt0(String sql, QueryExecutor.SqlColumn2 ... columns) throws CaMgmtException {
        try {
            return this.buildPrepStmt(sql, columns);
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    protected void changeIfNotNull(String tableName, QueryExecutor.SqlColumn whereColumn, QueryExecutor.SqlColumn ... columns) throws CaMgmtException {
        StringBuilder buf = new StringBuilder("UPDATE ");
        buf.append(tableName).append(" SET ");
        boolean noAction = true;
        for (QueryExecutor.SqlColumn col : columns) {
            if (col.value() == null) continue;
            noAction = false;
            buf.append(col.name()).append("=?,");
        }
        if (noAction) {
            throw new IllegalArgumentException("nothing to change");
        }
        buf.deleteCharAt(buf.length() - 1);
        buf.append(" WHERE ").append(whereColumn.name()).append("=?");
        String sql = buf.toString();
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(sql);
            HashMap<String, String> changedColumns = new HashMap<String, String>();
            int index = 1;
            for (QueryExecutor.SqlColumn col : columns) {
                if (col.value() == null) continue;
                this.setColumn(changedColumns, ps, index, col);
                ++index;
            }
            this.setColumn(null, ps, index, whereColumn);
            if (ps.executeUpdate() == 0) {
                throw new CaMgmtException("could not update table " + tableName);
            }
            LOG.info("updated table {} WHERE {}={}: {}", new Object[]{tableName, whereColumn.name(), whereColumn.value(), changedColumns});
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    private void setColumn(Map<String, String> changedColumns, PreparedStatement ps, int index, QueryExecutor.SqlColumn column) throws SQLException {
        String valText;
        String name = column.name();
        QueryExecutor.ColumnType type = column.type();
        Object value = column.value();
        boolean sensitive = column.sensitive();
        if (type == QueryExecutor.ColumnType.STRING) {
            String val = CaManagerQueryExecutorBase.getRealString((String)value);
            ps.setString(index, val);
            valText = val;
            if (val != null && column.isSignerConf() && (valText = SignerConf.eraseSensitiveData((String)valText)).length() > 100) {
                valText = StringUtil.concat((String)valText.substring(0, 97), (String[])new String[]{"..."});
            }
        } else if (type == QueryExecutor.ColumnType.INT) {
            if (value == null) {
                ps.setNull(index, 4);
                valText = "null";
            } else {
                int val = (Integer)value;
                ps.setInt(index, val);
                valText = Integer.toString(val);
            }
        } else if (type == QueryExecutor.ColumnType.LONG) {
            if (value == null) {
                ps.setNull(index, -5);
                valText = "null";
            } else {
                long val = (Long)value;
                ps.setLong(index, val);
                valText = Long.toString(val);
            }
        } else if (type == QueryExecutor.ColumnType.BOOL) {
            if (value == null) {
                ps.setNull(index, 4);
                valText = "null";
            } else {
                int val = (Boolean)value != false ? 1 : 0;
                ps.setInt(index, val);
                valText = Integer.toString(val);
            }
        } else if (type == QueryExecutor.ColumnType.TIMESTAMP) {
            if (value == null) {
                ps.setNull(index, 93);
                valText = "null";
            } else {
                Timestamp val = (Timestamp)value;
                ps.setTimestamp(index, val);
                valText = val.toString();
            }
        } else {
            throw new IllegalStateException("should not reach here, unknown type " + (Object)((Object)column.type()));
        }
        if (changedColumns != null) {
            changedColumns.put(name, sensitive ? "*****" : valText);
        }
    }

    private static String getRealString(String str) {
        return "null".equalsIgnoreCase(str) ? null : str;
    }

    protected int getNonNullIdForName(String sql, String name) throws CaMgmtException {
        Integer id = this.getIdForName(sql, name);
        if (id != null) {
            return id;
        }
        throw new CaMgmtException(StringUtil.concat((String)"Found no entry named ", (String[])new String[]{name}));
    }

    protected Integer getIdForName(String sql, String name) throws CaMgmtException {
        Integer n;
        ResultSet rs;
        PreparedStatement ps;
        block5: {
            ps = null;
            rs = null;
            ps = this.prepareStatement(sql);
            ps.setString(1, name);
            rs = ps.executeQuery();
            if (rs.next()) break block5;
            Integer n2 = null;
            this.datasource.releaseResources((Statement)ps, rs);
            return n2;
        }
        try {
            n = rs.getInt("ID");
        }
        catch (SQLException ex) {
            try {
                throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex));
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, rs);
        return n;
    }

    protected Map<Integer, String> getIdNameMap(String tableName) throws CaMgmtException {
        String sql = StringUtil.concat((String)"SELECT ID,NAME FROM ", (String[])new String[]{tableName});
        Statement ps = null;
        ResultSet rs = null;
        HashMap<Integer, String> ret = new HashMap<Integer, String>();
        try {
            ps = this.createStatement();
            rs = ps.executeQuery(sql);
            while (rs.next()) {
                ret.put(rs.getInt("ID"), rs.getString("NAME"));
            }
        }
        catch (SQLException ex) {
            throw new CaMgmtException((Throwable)this.datasource.translate(sql, ex));
        }
        finally {
            this.datasource.releaseResources(ps, rs);
        }
        return ret;
    }

    protected static enum Table {
        REQUESTOR,
        PUBLISHER,
        PROFILE,
        CA;

    }
}

