/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.db;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.server.db.QueryExecutor;
import org.xipki.ca.server.db.ResultRow;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.HashAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Hex;
import org.xipki.util.SqlUtil;
import org.xipki.util.exception.ErrorCode;
import org.xipki.util.exception.OperationException;

public class CertStoreBase
extends QueryExecutor {
    protected final String SQL_ADD_CERT;
    protected static final String SQL_REVOKE_CERT = "UPDATE CERT SET LUPDATE=?,REV=?,RT=?,RIT=?,RR=? WHERE ID=?";
    protected static final String SQL_REVOKE_SUSPENDED_CERT = "UPDATE CERT SET LUPDATE=?,RR=? WHERE ID=?";
    protected static final String SQL_INSERT_PUBLISHQUEUE = SqlUtil.buildInsertSql((String)"PUBLISHQUEUE", (String)"PID,CA_ID,CID");
    protected static final String SQL_REMOVE_PUBLISHQUEUE = "DELETE FROM PUBLISHQUEUE WHERE PID=? AND CID=?";
    protected static final String SQL_MAX_CRLNO = "SELECT MAX(CRL_NO) FROM CRL WHERE CA_ID=?";
    protected static final String SQL_MAX_FULL_CRLNO = "SELECT MAX(CRL_NO) FROM CRL WHERE CA_ID=? AND DELTACRL = 0";
    protected static final String SQL_MAX_THISUPDAATE_CRL = "SELECT MAX(THISUPDATE) FROM CRL WHERE CA_ID=? AND DELTACRL=?";
    protected final String SQL_ADD_CRL;
    protected static final String SQL_REMOVE_CERT_FOR_ID = "DELETE FROM CERT WHERE ID=?";
    protected final int dbSchemaVersion;
    protected final int maxX500nameLen;
    protected final String keypairEncAlg = "AES/GCM/NoPadding";
    protected final int keypairEncAlgId = 1;
    protected String keypairEncProvider;
    protected String keypairEncKeyId;
    protected SecretKey keypairEncKey;

    protected CertStoreBase(DataSourceWrapper datasource, PasswordResolver passwordResolver) throws DataAccessException, CaMgmtException {
        super(datasource);
        QueryExecutor.DbSchemaInfo dbSchemaInfo = new QueryExecutor.DbSchemaInfo(datasource);
        String vendor = dbSchemaInfo.variableValue("VENDOR");
        if (vendor != null && !vendor.equalsIgnoreCase("XIPKI")) {
            throw new CaMgmtException("unsupported vendor " + vendor);
        }
        this.dbSchemaVersion = Integer.parseInt(dbSchemaInfo.variableValue("VERSION"));
        if (this.dbSchemaVersion < 7) {
            throw new CaMgmtException("dbSchemaVersion < 7 unsupported: " + this.dbSchemaVersion);
        }
        this.maxX500nameLen = Integer.parseInt(dbSchemaInfo.variableValue("X500NAME_MAXLEN"));
        this.SQL_ADD_CERT = SqlUtil.buildInsertSql((String)"CERT", (String)"ID,LUPDATE,SN,SUBJECT,FP_S,FP_RS,FP_SAN,NBEFORE,NAFTER,REV,PID,CA_ID,RID,EE,TID,SHA1,REQ_SUBJECT,CRL_SCOPE,CERT,PRIVATE_KEY");
        this.SQL_ADD_CRL = SqlUtil.buildInsertSql((String)"CRL", (String)"ID,CA_ID,CRL_NO,THISUPDATE,NEXTUPDATE,DELTACRL,BASECRL_NO,CRL_SCOPE,SHA1,CRL");
        this.updateDbInfo(passwordResolver);
    }

    public void updateDbInfo(PasswordResolver passwordResolver) throws DataAccessException, CaMgmtException {
        QueryExecutor.DbSchemaInfo dbSchemaInfo = new QueryExecutor.DbSchemaInfo(this.datasource);
        String str = dbSchemaInfo.variableValue("KEYPAIR_ENC_KEY");
        if (str != null) {
            try {
                char[] keyChars = passwordResolver.resolvePassword(str);
                byte[] encodedEncKey = Hex.decode((char[])keyChars);
                int n = encodedEncKey.length;
                if (n != 16 && n != 24 && n != 32) {
                    throw new CaMgmtException("error resolving KEYPAIR_ENC_KEY");
                }
                this.keypairEncKey = new SecretKeySpec(encodedEncKey, "AES");
                this.keypairEncKeyId = Hex.encode((byte[])Arrays.copyOf(HashAlgo.SHA1.hash((byte[][])new byte[][]{encodedEncKey}), 8));
            }
            catch (PasswordResolverException ex) {
                throw new CaMgmtException("error resolving KEYPAIR_ENC_KEY", (Throwable)ex);
            }
            try {
                Cipher.getInstance("AES/GCM/NoPadding", "SunJCE");
                this.keypairEncProvider = "SunJCE";
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException ex) {
                try {
                    Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
                    this.keypairEncProvider = cipher.getProvider().getName();
                }
                catch (NoSuchAlgorithmException | NoSuchPaddingException ex2) {
                    throw new IllegalStateException("Unsupported cipher AES/GCM/NoPadding");
                }
            }
        }
    }

    protected static CertRevocationInfo buildCertRevInfo(ResultRow rs) {
        boolean revoked = rs.getBoolean("REV");
        if (!revoked) {
            return null;
        }
        long revTime = rs.getLong("RT");
        long revInvTime = rs.getLong("RIT");
        Date invalidityTime = revInvTime == 0L ? null : new Date(revInvTime * 1000L);
        return new CertRevocationInfo(rs.getInt("RR"), new Date(revTime * 1000L), invalidityTime);
    }

    protected long getMax(String table, String column) throws OperationException {
        try {
            return this.datasource.getMax(null, table, column);
        }
        catch (DataAccessException ex) {
            throw new OperationException(ErrorCode.DATABASE_FAILURE, ex.getMessage());
        }
    }

    protected int execUpdateStmt0(String sql) throws OperationException {
        try {
            return this.execUpdateStmt(sql);
        }
        catch (DataAccessException ex) {
            throw new OperationException(ErrorCode.DATABASE_FAILURE, (Throwable)ex);
        }
    }

    protected int execUpdatePrepStmt0(String sql, QueryExecutor.SqlColumn2 ... params) throws OperationException {
        try {
            return this.execUpdatePrepStmt(sql, params);
        }
        catch (DataAccessException ex) {
            throw new OperationException(ErrorCode.DATABASE_FAILURE, (Throwable)ex);
        }
    }

    protected ResultRow execQuery1PrepStmt0(String sql, QueryExecutor.SqlColumn2 ... params) throws OperationException {
        try {
            return this.execQuery1PrepStmt(sql, params);
        }
        catch (DataAccessException ex) {
            throw new OperationException(ErrorCode.DATABASE_FAILURE, (Throwable)ex);
        }
    }

    protected List<ResultRow> execQueryPrepStmt0(String sql, QueryExecutor.SqlColumn2 ... params) throws OperationException {
        try {
            return this.execQueryPrepStmt(sql, params);
        }
        catch (DataAccessException ex) {
            throw new OperationException(ErrorCode.DATABASE_FAILURE, (Throwable)ex);
        }
    }

    protected PreparedStatement buildPrepStmt0(String sql, QueryExecutor.SqlColumn2 ... columns) throws OperationException {
        try {
            return this.buildPrepStmt(sql, columns);
        }
        catch (DataAccessException ex) {
            throw new OperationException(ErrorCode.DATABASE_FAILURE, (Throwable)ex);
        }
    }

    protected long execQueryLongPrepStmt(String sql, QueryExecutor.SqlColumn2 ... params) throws OperationException {
        PreparedStatement ps = this.buildPrepStmt0(sql, params);
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            long l = rs.next() ? rs.getLong(1) : 0L;
            return l;
        }
        catch (SQLException ex) {
            throw new OperationException(ErrorCode.DATABASE_FAILURE, (Throwable)this.datasource.translate(sql, ex));
        }
        finally {
            this.datasource.releaseResources((Statement)ps, rs);
        }
    }

    protected PreparedStatement prepareStatement(String sqlQuery) throws OperationException {
        try {
            return this.datasource.prepareStatement(sqlQuery);
        }
        catch (DataAccessException ex) {
            throw new OperationException(ErrorCode.DATABASE_FAILURE, (Throwable)ex);
        }
    }

    protected static String buildArraySql(DataSourceWrapper datasource, String prefix, int num) {
        StringBuilder sb = new StringBuilder(prefix.length() + num * 2);
        sb.append(prefix).append(" IN (?");
        for (int i = 1; i < num; ++i) {
            sb.append(",?");
        }
        sb.append(")");
        return datasource.buildSelectFirstSql(num, sb.toString());
    }

    protected static X509Cert parseCert(byte[] encodedCert) throws OperationException {
        try {
            return X509Util.parseCert((byte[])encodedCert);
        }
        catch (CertificateException ex) {
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
        }
    }
}

