/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.db;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

class ResultRow {
    private final Map<String, Object> columns = new HashMap<String, Object>();

    ResultRow(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int count = metaData.getColumnCount();
        for (int index = 1; index <= count; ++index) {
            Object value;
            String label = metaData.getColumnLabel(index);
            int itype = metaData.getColumnType(index);
            switch (itype) {
                case -7: 
                case 16: {
                    value = rs.getBoolean(index);
                    break;
                }
                case -6: 
                case 4: 
                case 5: {
                    value = rs.getInt(index);
                    break;
                }
                case -5: {
                    value = rs.getLong(index);
                    break;
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    value = rs.getString(index);
                    break;
                }
                case 2005: 
                case 2011: {
                    Clob clob = rs.getClob(index);
                    value = clob == null ? null : clob.getSubString(1L, (int)clob.length());
                    break;
                }
                case 93: 
                case 2014: {
                    value = rs.getTimestamp(index);
                    break;
                }
                case 91: {
                    value = rs.getDate(index);
                    break;
                }
                case 92: {
                    value = rs.getTime(index);
                    break;
                }
                case 7: {
                    value = Float.valueOf(rs.getFloat(index));
                    break;
                }
                case 6: 
                case 8: {
                    value = rs.getDouble(index);
                    break;
                }
                case 2: 
                case 3: {
                    value = rs.getBigDecimal(index);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    value = rs.getBytes(index);
                    break;
                }
                case 2004: {
                    Blob blob = rs.getBlob(index);
                    value = blob == null ? null : blob.getBytes(1L, (int)blob.length());
                    break;
                }
                default: {
                    throw new SQLException("unknown data type " + itype);
                }
            }
            this.columns.put(label.toUpperCase(), value);
        }
    }

    int getInt(String label) {
        Object obj = this.columns.get(label.toUpperCase());
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Long) {
            return (int)((Long)obj).longValue();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1 : 0;
        }
        throw new IllegalArgumentException("cannot convert " + obj.getClass().getName() + " to int");
    }

    boolean getBoolean(String label) {
        Object obj = this.columns.get(label.toUpperCase());
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Integer) {
            return (Integer)obj != 0;
        }
        if (obj instanceof Long) {
            return (Long)obj != 0L;
        }
        throw new IllegalArgumentException("cannot convert " + obj.getClass().getName() + " to boolean");
    }

    long getLong(String label) {
        Object obj = this.columns.get(label.toUpperCase());
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).intValue();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1L : 0L;
        }
        throw new IllegalArgumentException("cannot convert " + obj.getClass().getName() + " to long");
    }

    String getString(String label) {
        Object obj = this.columns.get(label.toUpperCase());
        if (obj == null) {
            return null;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? "TRUE" : "FALSE";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }

    Timestamp getTimestamp(String label) {
        Object obj = this.columns.get(label.toUpperCase());
        if (obj == null) {
            return null;
        }
        if (obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        throw new IllegalArgumentException("cannot convert " + obj.getClass().getName() + " to Timestamp");
    }

    byte[] getBytes(String label) {
        Object obj = this.columns.get(label.toUpperCase());
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        throw new IllegalArgumentException("cannot convert " + obj.getClass().getName() + " to byte[]");
    }

    Time getTime(String label) {
        Object obj = this.columns.get(label.toUpperCase());
        if (obj == null) {
            return null;
        }
        if (obj instanceof Time) {
            return (Time)obj;
        }
        throw new IllegalArgumentException("cannot convert " + obj.getClass().getName() + " to Time");
    }

    Date getDate(String label) {
        Object obj = this.columns.get(label.toUpperCase());
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        throw new IllegalArgumentException("cannot convert " + obj.getClass().getName() + " to Date");
    }

    float getFloat(String label) {
        Object obj = this.columns.get(label.toUpperCase());
        if (obj == null) {
            return 0.0f;
        }
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        if (obj instanceof Double) {
            return (float)((Double)obj).doubleValue();
        }
        throw new IllegalArgumentException("cannot convert " + obj.getClass().getName() + " to float");
    }

    double getDouble(String label) {
        Object obj = this.columns.get(label.toUpperCase());
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        throw new IllegalArgumentException("cannot convert " + obj.getClass().getName() + " to double");
    }

    BigDecimal getBigDecimal(String label) {
        Object obj = this.columns.get(label.toUpperCase());
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        throw new IllegalArgumentException("cannot convert " + obj.getClass().getName() + " to BigDecimal");
    }
}

