/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.mgmt.CaConf;
import org.xipki.ca.api.mgmt.CaConfType;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.entry.CaEntry;
import org.xipki.ca.api.mgmt.entry.CaHasRequestorEntry;
import org.xipki.ca.api.mgmt.entry.CertprofileEntry;
import org.xipki.ca.api.mgmt.entry.KeypairGenEntry;
import org.xipki.ca.api.mgmt.entry.PublisherEntry;
import org.xipki.ca.api.mgmt.entry.RequestorEntry;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.FileOrBinary;
import org.xipki.util.FileOrValue;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.exception.ObjectCreationException;

class ConfLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ConfLoader.class);
    CaManagerImpl manager;

    ConfLoader(CaManagerImpl manager) {
        this.manager = (CaManagerImpl)Args.notNull((Object)manager, (String)"manager");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Map<String, X509Cert> loadConf(InputStream zippedConfStream) throws CaMgmtException {
        RequestorEntry entryB;
        RequestorEntry entry;
        KeypairGenEntry entryB2;
        KeypairGenEntry entry2;
        CaConf conf;
        this.manager.assertMasterModeAndSetuped();
        Args.notNull((Object)zippedConfStream, (String)"zippedConfStream");
        SecurityFactory securityFactory = this.manager.securityFactory;
        try {
            conf = new CaConf(zippedConfStream, securityFactory);
        }
        catch (IOException | InvalidConfException ex) {
            throw new CaMgmtException("could not parse the CA configuration", ex);
        }
        catch (RuntimeException ex) {
            throw new CaMgmtException("caught RuntimeException while parsing the CA configuration", (Throwable)ex);
        }
        HashMap<String, X509Cert> generatedRootCerts = new HashMap<String, X509Cert>(2);
        for (String dbSchemaName : conf.getDbSchemaNames()) {
            this.manager.addDbSchema(dbSchemaName, conf.getDbSchema(dbSchemaName));
        }
        for (String name : conf.getKeypairGenNames()) {
            entry2 = conf.getKeypairGen(name);
            entryB2 = this.manager.keypairGenDbEntries.get(name);
            if (entryB2 != null) {
                if (!entry2.equals((Object)entryB2)) throw ConfLoader.logAndCreateException(StringUtil.concat((String)"keypairGen ", (String[])new String[]{name, " existed, could not re-added it"}));
                LOG.info("ignore existed keypairGen {}", (Object)name);
                continue;
            }
            try {
                this.manager.addKeypairGen(entry2);
                LOG.info("added keypairGen {}", (Object)name);
            }
            catch (CaMgmtException ex) {
                String msg = StringUtil.concat((String)"could not add keypairGen ", (String[])new String[]{name});
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                throw new CaMgmtException(msg);
            }
        }
        for (String name : conf.getSignerNames()) {
            entry2 = conf.getSigner(name);
            entryB2 = this.manager.signerDbEntries.get(name);
            if (entryB2 != null) {
                if (!entry2.equals((Object)entryB2)) throw ConfLoader.logAndCreateException(StringUtil.concat((String)"signer ", (String[])new String[]{name, " existed, could not re-added it"}));
                LOG.info("ignore existed signer {}", (Object)name);
                continue;
            }
            try {
                this.manager.addSigner((SignerEntry)entry2);
                LOG.info("added signer {}", (Object)name);
            }
            catch (CaMgmtException ex) {
                String msg = StringUtil.concat((String)"could not add signer ", (String[])new String[]{name});
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                throw new CaMgmtException(msg);
            }
        }
        boolean ignoreId = true;
        for (String name : conf.getRequestorNames()) {
            entry = conf.getRequestor(name);
            entryB = this.manager.getRequestor(name);
            if (entryB != null) {
                if (!entry.equals(entryB, true)) throw ConfLoader.logAndCreateException(StringUtil.concat((String)"cert-based requestor ", (String[])new String[]{name, " existed, could not re-added it"}));
                LOG.info("ignore existed cert-based requestor {}", (Object)name);
                continue;
            }
            try {
                this.manager.addRequestor(entry);
                LOG.info("added cert-based requestor {}", (Object)name);
            }
            catch (CaMgmtException ex) {
                String msg = StringUtil.concat((String)"could not add cert-based requestor ", (String[])new String[]{name});
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                throw new CaMgmtException(msg);
            }
        }
        for (String name : conf.getPublisherNames()) {
            entry = conf.getPublisher(name);
            entryB = this.manager.getPublisher(name);
            if (entryB != null) {
                if (!entry.equals((PublisherEntry)entryB, true)) throw ConfLoader.logAndCreateException(StringUtil.concat((String)"publisher ", (String[])new String[]{name, " existed, could not re-added it"}));
                LOG.info("ignore existed publisher {}", (Object)name);
                continue;
            }
            try {
                this.manager.addPublisher((PublisherEntry)entry);
                LOG.info("added publisher {}", (Object)name);
            }
            catch (CaMgmtException ex) {
                String msg = "could not add publisher " + name;
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                throw new CaMgmtException(msg);
            }
        }
        for (String name : conf.getCertprofileNames()) {
            entry = conf.getCertprofile(name);
            entryB = this.manager.getCertprofile(name);
            if (entryB != null) {
                if (!entry.equals((CertprofileEntry)entryB, true)) throw ConfLoader.logAndCreateException(StringUtil.concat((String)"certprofile ", (String[])new String[]{name, " existed, could not re-added it"}));
                LOG.info("ignore existed certprofile {}", (Object)name);
                continue;
            }
            try {
                this.manager.addCertprofile((CertprofileEntry)entry);
                LOG.info("added certprofile {}", (Object)name);
            }
            catch (CaMgmtException ex) {
                String msg = StringUtil.concat((String)"could not add certprofile ", (String[])new String[]{name});
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                throw new CaMgmtException(msg);
            }
        }
        for (String caName : conf.getCaNames()) {
            String msg;
            CaConf.SingleCa scc = conf.getCa(caName);
            CaConf.GenSelfIssued genSelfIssued = scc.getGenSelfIssued();
            CaEntry caEntry = scc.getCaEntry();
            if (caEntry != null) {
                if (this.manager.caInfos.containsKey(caName)) {
                    CaEntry entryB3 = this.manager.caInfos.get(caName).getCaEntry();
                    if (caEntry.getCert() == null && genSelfIssued != null) {
                        ConcurrentContentSigner signer;
                        SignerConf signerConf = new SignerConf(caEntry.getSignerConf());
                        try {
                            signer = securityFactory.createSigner(caEntry.getSignerType(), signerConf, (X509Cert)null);
                        }
                        catch (ObjectCreationException ex) {
                            throw new CaMgmtException(StringUtil.concat((String)"could not create signer for CA ", (String[])new String[]{caName}), (Throwable)ex);
                        }
                        caEntry.setCert(signer.getCertificate());
                    }
                    if (!caEntry.equals(entryB3, true, true)) throw ConfLoader.logAndCreateException(StringUtil.concat((String)"CA ", (String[])new String[]{caName, " existed, could not re-added it"}));
                    LOG.info("ignore existing CA {}", (Object)caName);
                } else if (genSelfIssued != null) {
                    X509Cert cert = this.manager.generateRootCa(caEntry, genSelfIssued.getProfile(), genSelfIssued.getSubject(), genSelfIssued.getSerialNumber(), genSelfIssued.getNotBefore(), genSelfIssued.getNotAfter());
                    LOG.info("generated root CA {}", (Object)caName);
                    generatedRootCerts.put(caName, cert);
                } else {
                    try {
                        this.manager.addCa(caEntry);
                        LOG.info("added CA {}", (Object)caName);
                    }
                    catch (CaMgmtException ex) {
                        String msg2 = StringUtil.concat((String)"could not add CA ", (String[])new String[]{caName});
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg2);
                        throw new CaMgmtException(msg2);
                    }
                }
            }
            if (scc.getAliases() != null) {
                Set<String> aliasesB = this.manager.getAliasesForCa(caName);
                for (String aliasName : scc.getAliases()) {
                    if (aliasesB != null && aliasesB.contains(aliasName)) {
                        LOG.info("ignored adding existing CA alias {} to CA {}", (Object)aliasName, (Object)caName);
                        continue;
                    }
                    try {
                        this.manager.addCaAlias(aliasName, caName);
                        LOG.info("associated alias {} to CA {}", (Object)aliasName, (Object)caName);
                    }
                    catch (CaMgmtException ex) {
                        msg = StringUtil.concat((String)"could not associate alias ", (String[])new String[]{aliasName, " to CA ", caName});
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                        throw new CaMgmtException(msg);
                    }
                }
            }
            if (scc.getProfileNames() != null) {
                Set<String> profilesB = this.manager.caHasProfiles.get(caName);
                for (String profileName : scc.getProfileNames()) {
                    if (profilesB != null && profilesB.contains(profileName)) {
                        LOG.info("ignored adding certprofile {} to CA {}", (Object)profileName, (Object)caName);
                        continue;
                    }
                    try {
                        this.manager.addCertprofileToCa(profileName, caName);
                        LOG.info("added certprofile {} to CA {}", (Object)profileName, (Object)caName);
                    }
                    catch (CaMgmtException ex) {
                        msg = StringUtil.concat((String)"could not add certprofile ", (String[])new String[]{profileName, " to CA ", caName});
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                        throw new CaMgmtException(msg);
                    }
                }
            }
            if (scc.getPublisherNames() != null) {
                Set<String> publishersB = this.manager.caHasPublishers.get(caName);
                for (String publisherName : scc.getPublisherNames()) {
                    if (publishersB != null && publishersB.contains(publisherName)) {
                        LOG.info("ignored adding publisher {} to CA {}", (Object)publisherName, (Object)caName);
                        continue;
                    }
                    try {
                        this.manager.addPublisherToCa(publisherName, caName);
                        LOG.info("added publisher {} to CA {}", (Object)publisherName, (Object)caName);
                    }
                    catch (CaMgmtException ex) {
                        msg = StringUtil.concat((String)"could not add publisher ", (String[])new String[]{publisherName, " to CA ", caName});
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                        throw new CaMgmtException(msg);
                    }
                }
            }
            if (scc.getRequestors() == null) continue;
            Set<CaHasRequestorEntry> requestorsB = this.manager.caHasRequestors.get(caName);
            for (CaHasRequestorEntry requestor : scc.getRequestors()) {
                String requestorName = requestor.getRequestorIdent().getName();
                CaHasRequestorEntry requestorB = null;
                if (requestorsB != null) {
                    for (CaHasRequestorEntry m : requestorsB) {
                        if (!m.getRequestorIdent().getName().equals(requestorName)) continue;
                        requestorB = m;
                        break;
                    }
                }
                if (requestorB != null) {
                    if (!requestor.equals(requestorB, true)) throw ConfLoader.logAndCreateException(StringUtil.concat((String)"could not add requestor ", (String[])new String[]{requestorName, " to CA", caName}));
                    LOG.info("ignored adding requestor {} to CA {}", (Object)requestorName, (Object)caName);
                    continue;
                }
                try {
                    this.manager.addRequestorToCa(requestor, caName);
                    LOG.info("added publisher {} to CA {}", (Object)requestorName, (Object)caName);
                }
                catch (CaMgmtException ex) {
                    String msg3 = StringUtil.concat((String)"could not add requestor ", (String[])new String[]{requestorName, " to CA ", caName});
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg3);
                    throw new CaMgmtException(msg3);
                }
            }
        }
        if (generatedRootCerts.isEmpty()) {
            return null;
        }
        HashMap<String, X509Cert> hashMap = generatedRootCerts;
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream exportConf(List<String> caNames) throws CaMgmtException, IOException {
        this.manager.assertMasterModeAndSetuped();
        if (caNames != null) {
            ArrayList<String> tmpCaNames = new ArrayList<String>(caNames.size());
            for (String name : caNames) {
                if (!this.manager.x509cas.containsKey(name = name.toLowerCase())) continue;
                tmpCaNames.add(name);
            }
            caNames = tmpCaNames;
        } else {
            caNames = new ArrayList<String>(this.manager.x509cas.keySet());
        }
        ByteArrayOutputStream bytesStream = new ByteArrayOutputStream(0x100000);
        ZipOutputStream zipStream = new ZipOutputStream(bytesStream);
        zipStream.setLevel(1);
        CaConfType.CaSystem root = new CaConfType.CaSystem();
        try {
            CaConfType.NameTypeConf conf;
            RequestorEntry entry;
            LinkedList<Object> list;
            root.setDbSchemas(this.manager.getDbSchemas());
            if (CollectionUtil.isNotEmpty(caNames)) {
                list = new LinkedList<Object>();
                for (String name : this.manager.x509cas.keySet()) {
                    Set<CaHasRequestorEntry> requestors;
                    if (!caNames.contains(name)) continue;
                    CaConfType.Ca ca = new CaConfType.Ca();
                    ca.setName(name);
                    Set<String> strs = this.manager.getAliasesForCa(name);
                    if (CollectionUtil.isNotEmpty(strs)) {
                        ca.setAliases(new ArrayList<String>(strs));
                    }
                    if (CollectionUtil.isNotEmpty(requestors = this.manager.caHasRequestors.get(name))) {
                        ca.setRequestors(new ArrayList());
                        for (CaHasRequestorEntry m : requestors) {
                            String requestorName = m.getRequestorIdent().getName();
                            CaConfType.CaHasRequestor chr = new CaConfType.CaHasRequestor();
                            chr.setRequestorName(requestorName);
                            chr.setProfiles(new ArrayList(m.getProfiles()));
                            chr.setPermissions(CaUtil.getPermissions(m.getPermission()));
                            ca.getRequestors().add(chr);
                        }
                    }
                    if (CollectionUtil.isNotEmpty(strs = this.manager.caHasProfiles.get(name))) {
                        ca.setProfiles(new ArrayList<String>(strs));
                    }
                    if (CollectionUtil.isNotEmpty(strs = this.manager.caHasPublishers.get(name))) {
                        ca.setPublishers(new ArrayList<String>(strs));
                    }
                    CaConfType.CaInfo caInfoType = new CaConfType.CaInfo();
                    ca.setCaInfo(caInfoType);
                    CaEntry entry2 = this.manager.x509cas.get(name).getCaInfo().getCaEntry();
                    CaUris caUris = entry2.getCaUris();
                    if (caUris != null) {
                        CaConfType.CaUris caUrisType = new CaConfType.CaUris();
                        caUrisType.setCacertUris(caUris.getCacertUris());
                        caUrisType.setOcspUris(caUris.getOcspUris());
                        caUrisType.setCrlUris(caUris.getCrlUris());
                        caUrisType.setDeltacrlUris(caUris.getDeltaCrlUris());
                        caInfoType.setCaUris(caUrisType);
                    }
                    byte[] certBytes = entry2.getCert().getEncoded();
                    caInfoType.setCert(CaUtil.createFileOrBinary(zipStream, certBytes, StringUtil.concat((String)"files/ca-", (String[])new String[]{name, "-cert.der"})));
                    List certchain = entry2.getCertchain();
                    if (CollectionUtil.isNotEmpty((Collection)certchain)) {
                        LinkedList<FileOrBinary> ccList = new LinkedList<FileOrBinary>();
                        for (int i = 0; i < certchain.size(); ++i) {
                            certBytes = ((X509Cert)certchain.get(i)).getEncoded();
                            ccList.add(CaUtil.createFileOrBinary(zipStream, certBytes, StringUtil.concat((String)"files/ca-", (String[])new String[]{name, "-certchain-" + i + ".der"})));
                        }
                        caInfoType.setCertchain(ccList);
                    }
                    if (entry2.getCrlControl() != null) {
                        caInfoType.setCrlControl(new HashMap(new ConfPairs(entry2.getCrlControl().getConf()).asMap()));
                    }
                    if (entry2.getCrlSignerName() != null) {
                        caInfoType.setCrlSignerName(entry2.getCrlSignerName());
                    }
                    if (entry2.getCtlogControl() != null) {
                        caInfoType.setCtlogControl(new HashMap(new ConfPairs(entry2.getCtlogControl().getConf()).asMap()));
                    }
                    caInfoType.setExpirationPeriod(Integer.valueOf(entry2.getExpirationPeriod()));
                    if (entry2.getExtraControl() != null) {
                        caInfoType.setExtraControl(entry2.getExtraControl().asMap());
                    }
                    caInfoType.setKeepExpiredCertDays(Integer.valueOf(entry2.getKeepExpiredCertInDays()));
                    caInfoType.setMaxValidity(entry2.getMaxValidity().toString());
                    caInfoType.setNextCrlNo(entry2.getNextCrlNumber());
                    caInfoType.setNumCrls(Integer.valueOf(entry2.getNumCrls()));
                    caInfoType.setPermissions(CaUtil.getPermissions(entry2.getPermission()));
                    if (entry2.getRevokeSuspendedControl() != null) {
                        caInfoType.setRevokeSuspendedControl(new HashMap(new ConfPairs(entry2.getRevokeSuspendedControl().getConf()).asMap()));
                    }
                    caInfoType.setSaveCert(entry2.isSaveCert());
                    caInfoType.setSaveKeyPair(entry2.isSaveKeypair());
                    if (entry2.getKeypairGenNames() != null) {
                        caInfoType.setKeypairGenNames(entry2.getKeypairGenNames());
                    }
                    caInfoType.setSignerConf(CaUtil.createFileOrValue(zipStream, entry2.getSignerConf(), StringUtil.concat((String)"files/ca-", (String[])new String[]{name, "-signerconf.conf"})));
                    caInfoType.setSignerType(entry2.getSignerType());
                    caInfoType.setSnSize(entry2.getSerialNoLen());
                    caInfoType.setStatus(entry2.getStatus().getStatus());
                    caInfoType.setValidityMode(entry2.getValidityMode().name());
                    list.add(ca);
                }
                if (!list.isEmpty()) {
                    root.setCas(list);
                }
            }
            if (CollectionUtil.isNotEmpty(this.manager.requestorDbEntries)) {
                list = new LinkedList();
                for (String name : this.manager.requestorDbEntries.keySet()) {
                    entry = this.manager.requestorDbEntries.get(name);
                    CaConfType.Requestor type = new CaConfType.Requestor();
                    type.setName(name);
                    type.setType(entry.getType());
                    if ("cert".equalsIgnoreCase(entry.getType())) {
                        FileOrBinary fob = CaUtil.createFileOrBinary(zipStream, Base64.decode((String)entry.getConf()), StringUtil.concat((String)"files/requestor-", (String[])new String[]{name, ".der"}));
                        type.setBinaryConf(fob);
                    } else {
                        FileOrValue fov = CaUtil.createFileOrValue(zipStream, entry.getConf(), StringUtil.concat((String)"files/requestor-", (String[])new String[]{name, ".conf"}));
                        type.setConf(fov);
                    }
                    list.add(type);
                }
                if (!list.isEmpty()) {
                    root.setRequestors(list);
                }
            }
            if (CollectionUtil.isNotEmpty(this.manager.publisherDbEntries)) {
                list = new LinkedList();
                for (String name : this.manager.publisherDbEntries.keySet()) {
                    entry = this.manager.publisherDbEntries.get(name);
                    conf = new CaConfType.NameTypeConf();
                    conf.setName(name);
                    conf.setType(entry.getType());
                    conf.setConf(CaUtil.createFileOrValue(zipStream, entry.getConf(), StringUtil.concat((String)"files/publisher-", (String[])new String[]{name, ".conf"})));
                    list.add(conf);
                }
                if (!list.isEmpty()) {
                    root.setPublishers(list);
                }
            }
            if (CollectionUtil.isNotEmpty(this.manager.certprofileDbEntries)) {
                list = new LinkedList();
                for (String name : this.manager.certprofileDbEntries.keySet()) {
                    entry = this.manager.certprofileDbEntries.get(name);
                    conf = new CaConfType.NameTypeConf();
                    conf.setName(name);
                    conf.setType(entry.getType());
                    conf.setConf(CaUtil.createFileOrValue(zipStream, entry.getConf(), StringUtil.concat((String)"files/certprofile-", (String[])new String[]{name, ".conf"})));
                    list.add(conf);
                }
                if (!list.isEmpty()) {
                    root.setProfiles(list);
                }
            }
            if (CollectionUtil.isNotEmpty(this.manager.signerDbEntries)) {
                list = new LinkedList();
                for (String name : this.manager.signerDbEntries.keySet()) {
                    entry = this.manager.signerDbEntries.get(name);
                    conf = new CaConfType.Signer();
                    conf.setName(name);
                    conf.setType(entry.getType());
                    conf.setConf(CaUtil.createFileOrValue(zipStream, entry.getConf(), StringUtil.concat((String)"files/signer-", (String[])new String[]{name, ".conf"})));
                    conf.setCert(CaUtil.createFileOrBase64Value(zipStream, entry.getBase64Cert(), StringUtil.concat((String)"files/signer-", (String[])new String[]{name, ".der"})));
                    list.add(conf);
                }
                if (!list.isEmpty()) {
                    root.setSigners(list);
                }
            }
            if (CollectionUtil.isNotEmpty(this.manager.keypairGenDbEntries)) {
                list = new LinkedList();
                for (String name : this.manager.keypairGenDbEntries.keySet()) {
                    entry = this.manager.keypairGenDbEntries.get(name);
                    conf = new CaConfType.NameTypeConf();
                    conf.setName(name);
                    conf.setType(entry.getType());
                    if (entry.getConf() != null) {
                        FileOrValue fv = new FileOrValue();
                        fv.setValue(entry.getConf());
                        conf.setConf(fv);
                    }
                    list.add(conf);
                }
                if (!list.isEmpty()) {
                    root.setKeypairGens(list);
                }
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                root.validate();
                JSON.writeJSONString((OutputStream)bout, (Object)root, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
            }
            catch (InvalidConfException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not marshal CAConf");
                throw new CaMgmtException(StringUtil.concat((String)"could not marshal CAConf: ", (String[])new String[]{ex.getMessage()}), (Throwable)ex);
            }
            finally {
                bout.flush();
            }
            zipStream.putNextEntry(new ZipEntry("caconf.json"));
            try {
                zipStream.write(bout.toByteArray());
            }
            finally {
                zipStream.closeEntry();
            }
        }
        finally {
            zipStream.flush();
            zipStream.close();
        }
        return new ByteArrayInputStream(bytesStream.toByteArray());
    }

    private static CaMgmtException logAndCreateException(String msg) {
        LOG.error(msg);
        return new CaMgmtException(msg);
    }
}

