/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.PublicCaInfo;
import org.xipki.ca.api.mgmt.entry.CaEntry;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.ExtensionValues;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.IdentifiedCertprofile;
import org.xipki.security.ConcurrentBagEntrySigner;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.NoIdleSignerException;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignAlgo;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.StringUtil;
import org.xipki.util.Validity;
import org.xipki.util.exception.BadCertTemplateException;
import org.xipki.util.exception.ErrorCode;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.exception.ObjectCreationException;
import org.xipki.util.exception.OperationException;

class SelfSignedCertBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SelfSignedCertBuilder.class);

    private SelfSignedCertBuilder() {
    }

    public static GenerateSelfSignedResult generateSelfSigned(SecurityFactory securityFactory, String signerType, String signerConf, IdentifiedCertprofile certprofile, String subject, BigInteger serialNumber, CaUris caUris, ConfPairs extraControl, Date notBefore, Date notAfter) throws OperationException, InvalidConfException {
        ConcurrentContentSigner signer;
        ConfPairs keyValues;
        String keystoreConf;
        Args.notNull((Object)securityFactory, (String)"securityFactory");
        Args.notBlank((String)signerType, (String)"signerType");
        Args.notNull((Object)certprofile, (String)"certprofile");
        Args.notBlank((String)subject, (String)"subject");
        Args.notNull((Object)serialNumber, (String)"serialNumber");
        if (serialNumber.signum() != 1) {
            throw new IllegalArgumentException("serialNumber may not be non-positive: " + serialNumber);
        }
        Certprofile.CertLevel level = certprofile.getCertLevel();
        if (Certprofile.CertLevel.RootCA != level) {
            throw new IllegalArgumentException("certprofile is not of level " + Certprofile.CertLevel.RootCA);
        }
        if (StringUtil.orEqualsIgnoreCase((String)signerType, (String[])new String[]{"PKCS12", "JCEKS"}) && (keystoreConf = (keyValues = new ConfPairs(signerConf)).value("keystore")) == null) {
            throw new InvalidConfException("required parameter 'keystore' for types PKCS12 and JCEKS, is not specified");
        }
        try {
            List signerConfs = CaEntry.splitCaSignerConfs((String)signerConf);
            List<SignAlgo> restrictedSigAlgos = certprofile.getSignatureAlgorithms();
            String thisSignerConf = null;
            if (CollectionUtil.isEmpty(restrictedSigAlgos)) {
                thisSignerConf = ((CaEntry.CaSignerConf)signerConfs.get(0)).getConf();
            } else {
                for (SignAlgo algo : restrictedSigAlgos) {
                    for (CaEntry.CaSignerConf m : signerConfs) {
                        if (m.getAlgo() != algo) continue;
                        thisSignerConf = m.getConf();
                        break;
                    }
                    if (thisSignerConf == null) continue;
                    break;
                }
            }
            if (thisSignerConf == null) {
                throw new OperationException(ErrorCode.SYSTEM_FAILURE, "CA does not support any signature algorithm restricted by the cert profile");
            }
            signer = securityFactory.createSigner(signerType, new SignerConf(thisSignerConf), (X509Cert[])null);
        }
        catch (XiSecurityException | ObjectCreationException ex) {
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, ex);
        }
        X509Cert newCert = SelfSignedCertBuilder.generateCertificate(signer, certprofile, subject, serialNumber, caUris, extraControl, notBefore, notAfter);
        return new GenerateSelfSignedResult(signerConf, newCert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Cert generateCertificate(ConcurrentContentSigner signer, IdentifiedCertprofile certprofile, String subject, BigInteger serialNumber, CaUris caUris, ConfPairs extraControl, Date notBefore, Date notAfter) throws OperationException {
        Validity validity;
        Certprofile.SubjectInfo subjectInfo;
        PublicKey csrPublicKey;
        SubjectPublicKeyInfo publicKeyInfo;
        try {
            publicKeyInfo = KeyUtil.createSubjectPublicKeyInfo((PublicKey)signer.getPublicKey());
        }
        catch (InvalidKeyException ex) {
            LOG.warn("KeyUtil.createSubjectPublicKeyInfo", (Throwable)ex);
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
        }
        try {
            publicKeyInfo = X509Util.toRfc3279Style((SubjectPublicKeyInfo)publicKeyInfo);
        }
        catch (InvalidKeySpecException ex) {
            LOG.warn("SecurityUtil.toRfc3279Style", (Throwable)ex);
            throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, (Throwable)ex);
        }
        PublicKey signerPublicKey = signer.getPublicKey();
        try {
            csrPublicKey = KeyUtil.generatePublicKey((SubjectPublicKeyInfo)publicKeyInfo);
        }
        catch (InvalidKeySpecException ex) {
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, ex.getMessage());
        }
        if (!signerPublicKey.equals(csrPublicKey)) {
            throw new OperationException(ErrorCode.BAD_REQUEST, "Public keys of the signer's token and of CSR are different");
        }
        try {
            certprofile.checkPublicKey(publicKeyInfo);
        }
        catch (CertprofileException ex) {
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, "exception in cert profile " + certprofile.getIdent());
        }
        catch (BadCertTemplateException ex) {
            LOG.warn("certprofile.checkPublicKey", (Throwable)ex);
            throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, (Throwable)ex);
        }
        X500Name requestedSubject = new X500Name(subject);
        try {
            subjectInfo = certprofile.getSubject(requestedSubject, publicKeyInfo);
        }
        catch (CertprofileException ex) {
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, "exception in cert profile " + certprofile.getIdent());
        }
        catch (BadCertTemplateException ex) {
            LOG.warn("certprofile.getSubject", (Throwable)ex);
            throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, (Throwable)ex);
        }
        notBefore = certprofile.getNotBefore(notBefore);
        if (notBefore == null) {
            notBefore = new Date();
        }
        if ((validity = certprofile.getValidity()) == null) {
            throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, "no validity specified in the profile " + certprofile.getIdent());
        }
        Date maxNotAfter = validity.add(notBefore);
        if (notAfter == null) {
            notAfter = maxNotAfter;
        } else if (notAfter.after(maxNotAfter)) {
            notAfter = maxNotAfter;
        }
        X500Name grantedSubject = subjectInfo.getGrantedSubject();
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(grantedSubject, serialNumber, notBefore, notAfter, grantedSubject, publicKeyInfo);
        try {
            X509CertificateHolder certHolder;
            SubjectKeyIdentifier ski = certprofile.getSubjectKeyIdentifier(publicKeyInfo);
            PublicCaInfo publicCaInfo = new PublicCaInfo(grantedSubject, grantedSubject, serialNumber, null, ski.getKeyIdentifier(), caUris, extraControl);
            ExtensionValues extensionTuples = certprofile.getExtensions(requestedSubject, grantedSubject, null, publicKeyInfo, publicCaInfo, null, notBefore, notAfter);
            CaUtil.addExtensions(extensionTuples, certBuilder);
            ConcurrentBagEntrySigner signer0 = signer.borrowSigner();
            try {
                certHolder = certBuilder.build((ContentSigner)signer0.value());
            }
            finally {
                signer.requiteSigner(signer0);
            }
            return new X509Cert(certHolder);
        }
        catch (BadCertTemplateException ex) {
            throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, (Throwable)ex);
        }
        catch (IOException | CertprofileException | NoIdleSignerException ex) {
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, ex);
        }
    }

    static class GenerateSelfSignedResult {
        private final String signerConf;
        private final X509Cert cert;

        GenerateSelfSignedResult(String signerConf, X509Cert cert) {
            this.signerConf = signerConf;
            this.cert = cert;
        }

        String getSignerConf() {
            return this.signerConf;
        }

        X509Cert getCert() {
            return this.cert;
        }
    }
}

