/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.PublicCaInfo;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CrlControl;
import org.xipki.ca.api.mgmt.CtlogControl;
import org.xipki.ca.api.mgmt.RevokeSuspendedControl;
import org.xipki.ca.api.mgmt.ValidityMode;
import org.xipki.ca.api.mgmt.entry.CaConfColumn;
import org.xipki.ca.api.mgmt.entry.CaEntry;
import org.xipki.ca.server.RandomSerialNumberGenerator;
import org.xipki.ca.server.db.CertStore;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.EdECConstants;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignAlgo;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.LogUtil;
import org.xipki.util.PermissionConstants;
import org.xipki.util.Validity;
import org.xipki.util.exception.OperationException;

public class CaInfo {
    private static final Logger LOG = LoggerFactory.getLogger(CaInfo.class);
    private static final long MS_PER_DAY = 86400000L;
    private final CaEntry caEntry;
    private final CaConfColumn caConfColumn;
    private final long noNewCertificateAfter;
    private final BigInteger serialNumber;
    private final Date notBefore;
    private final Date notAfter;
    private final boolean selfSigned;
    private final CMPCertificate certInCmpFormat;
    private final PublicCaInfo publicCaInfo;
    private final List<X509Cert> certchain;
    private final List<CMPCertificate> certchainInCmpFormat;
    private final CertStore certStore;
    private final RandomSerialNumberGenerator randomSnGenerator;
    private final String caKeyspec;
    private final AlgorithmIdentifier caKeyAlgId;
    private Map<SignAlgo, ConcurrentContentSigner> signers;
    private ConcurrentContentSigner dfltSigner;
    private final ConfPairs extraControl;

    public CaInfo(CaEntry caEntry, CaConfColumn caConfColumn, CertStore certStore) throws OperationException {
        this.caEntry = (CaEntry)Args.notNull((Object)caEntry, (String)"caEntry");
        this.caConfColumn = (CaConfColumn)Args.notNull((Object)caConfColumn, (String)"caConfColumn");
        this.certStore = (CertStore)Args.notNull((Object)certStore, (String)"certStore");
        X509Cert cert = caEntry.getCert();
        this.notBefore = cert.getNotBefore();
        this.notAfter = cert.getNotAfter();
        this.serialNumber = cert.getSerialNumber();
        this.selfSigned = cert.isSelfSigned();
        this.certInCmpFormat = new CMPCertificate(cert.toBcCert().toASN1Structure());
        this.publicCaInfo = new PublicCaInfo(cert, caEntry.getCaUris(), caEntry.getExtraControl());
        List certs = caEntry.getCertchain();
        if (certs == null || certs.isEmpty()) {
            this.certchain = Collections.emptyList();
            this.certchainInCmpFormat = Collections.emptyList();
        } else {
            this.certchain = new ArrayList<X509Cert>(certs);
            this.certchainInCmpFormat = new ArrayList<CMPCertificate>(certs.size());
            for (X509Cert c : certs) {
                this.certchainInCmpFormat.add(new CMPCertificate(c.toBcCert().toASN1Structure()));
            }
        }
        this.noNewCertificateAfter = this.notAfter.getTime() - 86400000L * (long)caEntry.getExpirationPeriod();
        this.randomSnGenerator = RandomSerialNumberGenerator.getInstance();
        this.extraControl = caEntry.getExtraControl();
        this.caKeyAlgId = cert.toBcCert().getSubjectPublicKeyInfo().getAlgorithm();
        ASN1ObjectIdentifier caKeyAlgOid = this.caKeyAlgId.getAlgorithm();
        if (caKeyAlgOid.equals((ASN1Primitive)PKCSObjectIdentifiers.rsaEncryption)) {
            RSAPublicKey pubKey = (RSAPublicKey)cert.getPublicKey();
            this.caKeyspec = "RSA/" + pubKey.getModulus().bitLength();
        } else if (caKeyAlgOid.equals((ASN1Primitive)X9ObjectIdentifiers.id_ecPublicKey)) {
            ASN1ObjectIdentifier curveOid = ASN1ObjectIdentifier.getInstance((Object)this.caKeyAlgId.getParameters());
            this.caKeyspec = "EC/" + curveOid.getId();
        } else if (caKeyAlgOid.equals((ASN1Primitive)X9ObjectIdentifiers.id_dsa)) {
            ASN1Sequence seq = DERSequence.getInstance((Object)this.caKeyAlgId.getParameters());
            BigInteger p = ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue();
            BigInteger q = ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getValue();
            this.caKeyspec = "DSA/" + p.bitLength() + "/" + q.bitLength();
        } else if (caKeyAlgOid.equals((ASN1Primitive)EdECConstants.id_ED25519)) {
            this.caKeyspec = "ED25519";
        } else if (caKeyAlgOid.equals((ASN1Primitive)EdECConstants.id_ED448)) {
            this.caKeyspec = "ED448";
        } else {
            throw new IllegalStateException("unknown key algorithm " + caKeyAlgOid.getId());
        }
    }

    public String getCaKeyspec() {
        return this.caKeyspec;
    }

    public AlgorithmIdentifier getCaKeyAlgId() {
        return this.caKeyAlgId;
    }

    public long getNextCrlNumber() {
        return this.caEntry.getNextCrlNumber();
    }

    public void setNextCrlNumber(long crlNumber) {
        this.caEntry.setNextCrlNumber(crlNumber);
    }

    public PublicCaInfo getPublicCaInfo() {
        return this.publicCaInfo;
    }

    public String getSubject() {
        return this.caEntry.getSubject();
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public boolean isSelfSigned() {
        return this.selfSigned;
    }

    public CMPCertificate getCertInCmpFormat() {
        return this.certInCmpFormat;
    }

    public long getNoNewCertificateAfter() {
        return this.noNewCertificateAfter;
    }

    public CaEntry getCaEntry() {
        return this.caEntry;
    }

    public CaConfColumn getCaConfColumn() {
        return this.caConfColumn;
    }

    public int getPathLenConstraint() {
        return this.caEntry.getPathLenConstraint();
    }

    public NameId getIdent() {
        return this.caEntry.getIdent();
    }

    public CaUris getCaUris() {
        return this.caEntry.getCaUris();
    }

    public Validity getMaxValidity() {
        return this.caEntry.getMaxValidity();
    }

    public X509Cert getCert() {
        return this.publicCaInfo.getCaCert();
    }

    public List<X509Cert> getCertchain() {
        return this.certchain;
    }

    public List<CMPCertificate> getCertchainInCmpFormat() {
        return this.certchainInCmpFormat;
    }

    public String getCrlSignerName() {
        return this.caEntry.getCrlSignerName();
    }

    public void setCrlSignerName(String crlSignerName) {
        this.caEntry.setCrlSignerName(crlSignerName);
    }

    public CrlControl getCrlControl() {
        return this.caEntry.getCrlControl();
    }

    public CtlogControl getCtlogControl() {
        return this.caEntry.getCtlogControl();
    }

    public List<String> getKeypairGenNames() {
        return this.caEntry.getKeypairGenNames();
    }

    public ConfPairs getExtraControl() {
        return this.extraControl;
    }

    public int getNumCrls() {
        return this.caEntry.getNumCrls();
    }

    public CaStatus getStatus() {
        return this.caEntry.getStatus();
    }

    public void setStatus(CaStatus status) {
        this.caEntry.setStatus(status);
    }

    public String toString() {
        return this.caEntry.toString(false);
    }

    public String toString(boolean verbose) {
        return this.caEntry.toString(verbose);
    }

    public boolean isSaveCert() {
        return this.caEntry.isSaveCert();
    }

    public boolean isSaveKeypair() {
        return this.caEntry.isSaveKeypair();
    }

    public String getHexSha1OfCert() {
        return this.caEntry.getHexSha1OfCert();
    }

    public ValidityMode getValidityMode() {
        return this.caEntry.getValidityMode();
    }

    public int getPermission() {
        return this.caEntry.getPermission();
    }

    public void setPermission(int permission) {
        this.caEntry.setPermission(permission);
    }

    public CertRevocationInfo getRevocationInfo() {
        return this.caEntry.getRevocationInfo();
    }

    public void setRevocationInfo(CertRevocationInfo revocationInfo) {
        this.caEntry.setRevocationInfo(revocationInfo);
    }

    public int getKeepExpiredCertInDays() {
        return this.caEntry.getKeepExpiredCertInDays();
    }

    public BigInteger nextSerial() {
        return this.randomSnGenerator.nextSerialNumber(this.caEntry.getSerialNoLen());
    }

    public BigInteger nextCrlNumber() throws OperationException {
        long currentMaxNo;
        long crlNo = this.caEntry.getNextCrlNumber();
        if (crlNo <= (currentMaxNo = this.certStore.getMaxCrlNumber(this.caEntry.getIdent()))) {
            crlNo = currentMaxNo + 1L;
        }
        this.caEntry.setNextCrlNumber(crlNo + 1L);
        return BigInteger.valueOf(crlNo);
    }

    public BigInteger getMaxFullCrlNumber() throws OperationException {
        long crlNumber = this.certStore.getMaxFullCrlNumber(this.caEntry.getIdent());
        return crlNumber == 0L ? null : BigInteger.valueOf(crlNumber);
    }

    public ConcurrentContentSigner getSigner(List<SignAlgo> algos) {
        if (CollectionUtil.isEmpty(algos)) {
            return this.dfltSigner;
        }
        for (SignAlgo m : algos) {
            if (!this.signers.containsKey(m)) continue;
            return this.signers.get(m);
        }
        return null;
    }

    public boolean initSigner(SecurityFactory securityFactory) throws XiSecurityException {
        if (this.signers != null) {
            return true;
        }
        this.dfltSigner = null;
        List signerConfs = CaEntry.splitCaSignerConfs((String)this.caEntry.getSignerConf());
        HashMap<SignAlgo, ConcurrentContentSigner> tmpSigners = new HashMap<SignAlgo, ConcurrentContentSigner>();
        for (CaEntry.CaSignerConf m : signerConfs) {
            SignerConf signerConf = new SignerConf(m.getConf());
            try {
                ConcurrentContentSigner signer = securityFactory.createSigner(this.caEntry.getSignerType(), signerConf, this.caEntry.getCert());
                if (this.dfltSigner == null) {
                    this.dfltSigner = signer;
                }
                tmpSigners.put(m.getAlgo(), signer);
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)("could not initialize the CA signer for CA " + this.caEntry.getIdent().getName()));
                for (ConcurrentContentSigner ccs : tmpSigners.values()) {
                    try {
                        ccs.close();
                    }
                    catch (IOException ex) {
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not close ConcurrentContentSigner " + ccs.getName()));
                    }
                }
                tmpSigners.clear();
                throw new XiSecurityException("could not initialize the CA signer");
            }
        }
        this.signers = Collections.unmodifiableMap(tmpSigners);
        return true;
    }

    public boolean isSignerRequired() {
        int permission = this.caEntry.getPermission();
        return PermissionConstants.contains((int)permission, (int)128) || PermissionConstants.contains((int)permission, (int)1) || PermissionConstants.contains((int)permission, (int)32) || PermissionConstants.contains((int)permission, (int)16);
    }

    public RevokeSuspendedControl revokeSuspendedCertsControl() {
        return this.caEntry.getRevokeSuspendedControl();
    }
}

