/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.ValidityMode;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.KeypairGenControl;
import org.xipki.ca.api.profile.NotAfterMode;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.CertTemplateData;
import org.xipki.ca.server.IdentifiedCertprofile;
import org.xipki.ca.server.X509Ca;
import org.xipki.ca.server.db.CertStore;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.KeypairGenerator;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.RSABrokenKey;
import org.xipki.security.util.X509Util;
import org.xipki.util.LogUtil;
import org.xipki.util.Validity;
import org.xipki.util.exception.BadCertTemplateException;
import org.xipki.util.exception.ErrorCode;
import org.xipki.util.exception.OperationException;

class GrandCertTemplateBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(GrandCertTemplateBuilder.class);
    private static final long MAX_CERT_TIME_MS = 253402300799000L;
    private static final Date MAX_CERT_TIME = new Date(253402300799000L);
    private static final long MS_PER_10MINUTES = 300000L;
    private final ASN1ObjectIdentifier keyAlgOidByImplicitCA;
    private final String keyspecByImplicitCA;
    private final CertStore certstore;
    private final CaInfo caInfo;

    GrandCertTemplateBuilder(CaInfo caInfo, CertStore certstore) {
        this.caInfo = caInfo;
        this.certstore = certstore;
        this.keyspecByImplicitCA = caInfo.getCaKeyspec();
        this.keyAlgOidByImplicitCA = caInfo.getCaKeyAlgId().getAlgorithm();
    }

    X509Ca.GrantedCertTemplate create(boolean batch, IdentifiedCertprofile certprofile, CertTemplateData certTemplate, List<KeypairGenerator> keypairGenerators) throws OperationException {
        Date grantedNotAfter;
        X500Name grantedSubject;
        Certprofile.SubjectInfo subjectInfo;
        if (this.caInfo.getRevocationInfo() != null) {
            throw new OperationException(ErrorCode.NOT_PERMITTED, "CA is revoked");
        }
        if (certprofile == null) {
            throw new OperationException(ErrorCode.UNKNOWN_CERT_PROFILE, "unknown cert profile " + certTemplate.getCertprofileName());
        }
        ConcurrentContentSigner signer = this.caInfo.getSigner(certprofile.getSignatureAlgorithms());
        if (signer == null) {
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, "CA does not support any signature algorithm restricted by the cert profile");
        }
        NameId certprofileIdent = certprofile.getIdent();
        if (certprofile.getVersion() != Certprofile.X509CertVersion.v3) {
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, "unknown cert version " + certprofile.getVersion());
        }
        switch (certprofile.getCertLevel()) {
            case RootCA: {
                throw new OperationException(ErrorCode.NOT_PERMITTED, "CA is not allowed to generate Root CA certificate");
            }
            case SubCA: 
            case CROSS: {
                boolean allowed;
                Integer reqPathlen = certprofile.getPathLenBasicConstraint();
                int caPathLen = this.caInfo.getPathLenConstraint();
                boolean bl = allowed = reqPathlen == null && caPathLen == Integer.MAX_VALUE || reqPathlen != null && reqPathlen < caPathLen;
                if (allowed) break;
                throw new OperationException(ErrorCode.NOT_PERMITTED, "invalid BasicConstraint.pathLenConstraint");
            }
        }
        boolean forCrossCert = certTemplate.isForCrossCert();
        X500Name requestedSubject = forCrossCert ? certTemplate.getSubject() : CaUtil.removeEmptyRdns(certTemplate.getSubject());
        Date reqNotBefore = certTemplate.getNotBefore();
        Date grantedNotBefore = certprofile.getNotBefore(reqNotBefore);
        long currentMillis = System.currentTimeMillis();
        if (currentMillis - grantedNotBefore.getTime() > 300000L) {
            grantedNotBefore = new Date(currentMillis - 300000L);
        }
        long time = this.caInfo.getNoNewCertificateAfter();
        if (grantedNotBefore.getTime() > time) {
            throw new OperationException(ErrorCode.NOT_PERMITTED, "CA is not permitted to issue certificate after " + new Date(time));
        }
        if (grantedNotBefore.before(this.caInfo.getNotBefore())) {
            grantedNotBefore = this.caInfo.getNotBefore();
        }
        PrivateKeyInfo privateKey = null;
        SubjectPublicKeyInfo grantedPublicKeyInfo = certTemplate.getPublicKeyInfo();
        if (grantedPublicKeyInfo != null) {
            try {
                grantedPublicKeyInfo = X509Util.toRfc3279Style((SubjectPublicKeyInfo)certTemplate.getPublicKeyInfo());
            }
            catch (InvalidKeySpecException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)"invalid SubjectPublicKeyInfo");
                throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, "invalid SubjectPublicKeyInfo");
            }
            if (grantedPublicKeyInfo.getAlgorithm().getAlgorithm().equals((ASN1Primitive)PKCSObjectIdentifiers.rsaEncryption)) {
                try {
                    ASN1Sequence seq = ASN1Sequence.getInstance((Object)grantedPublicKeyInfo.getPublicKeyData().getOctets());
                    if (seq.size() != 2) {
                        throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, "invalid format of RSA public key");
                    }
                    BigInteger modulus = ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getPositiveValue();
                    if (RSABrokenKey.isAffected((BigInteger)modulus)) {
                        throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, "RSA public key is too weak");
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, "invalid format of RSA public key");
                }
            }
        } else {
            if (certTemplate.isServerkeygen()) {
                byte[] publicKeyData;
                String keyType;
                ASN1ObjectIdentifier keyAlgOid;
                String keyspec;
                KeypairGenControl kg = certprofile.getKeypairGenControl();
                if (kg == null || kg instanceof KeypairGenControl.ForbiddenKeypairGenControl) {
                    throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, "no public key is specified");
                }
                if (kg instanceof KeypairGenControl.InheritCAKeypairGenControl) {
                    keyspec = this.keyspecByImplicitCA;
                    keyAlgOid = this.keyAlgOidByImplicitCA;
                } else {
                    keyspec = kg.getKeyspec();
                    keyAlgOid = kg.getKeyAlgorithmOid();
                }
                KeypairGenerator keypairGenerator = null;
                if (keypairGenerators != null) {
                    for (KeypairGenerator m : keypairGenerators) {
                        if (!m.supports(keyspec)) continue;
                        keypairGenerator = m;
                        break;
                    }
                }
                if (keypairGenerator == null) {
                    throw new OperationException(ErrorCode.SYSTEM_FAILURE, "found no keypair generator for keyspec " + keyspec);
                }
                String name = keypairGenerator.getName();
                try {
                    privateKey = keypairGenerator.generateKeypair(keyspec);
                    LOG.info("generated keypair {} with generator {}", (Object)keyspec, (Object)name);
                }
                catch (XiSecurityException ex) {
                    String msg = "error generating keypair " + keyspec + " using generator " + name;
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                    throw new OperationException(ErrorCode.SYSTEM_FAILURE, msg);
                }
                if (!privateKey.getPrivateKeyAlgorithm().getAlgorithm().equals((ASN1Primitive)keyAlgOid)) {
                    ASN1BitString asn1PublicKeyData = privateKey.getPublicKeyData();
                    try {
                        privateKey = new PrivateKeyInfo(new AlgorithmIdentifier(keyAlgOid, privateKey.getPrivateKeyAlgorithm().getParameters()), (ASN1Encodable)privateKey.getPrivateKey().toASN1Primitive(), privateKey.getAttributes(), asn1PublicKeyData == null ? null : asn1PublicKeyData.getOctets());
                    }
                    catch (IOException ex) {
                        throw new OperationException(ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
                    }
                }
                switch (keyType = keyspec.split("/")[0].toUpperCase(Locale.ROOT)) {
                    case "RSA": {
                        RSAPrivateKey sk = RSAPrivateKey.getInstance((Object)privateKey.getPrivateKey().getOctets());
                        try {
                            publicKeyData = new RSAPublicKey(sk.getModulus(), sk.getPublicExponent()).getEncoded();
                            break;
                        }
                        catch (IOException ex) {
                            throw new OperationException(ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
                        }
                    }
                    case "EC": {
                        ECPrivateKey sk = ECPrivateKey.getInstance((Object)privateKey.getPrivateKey().getOctets());
                        publicKeyData = sk.getPublicKey().getBytes();
                        break;
                    }
                    case "DSA": 
                    case "ED25519": 
                    case "ED448": 
                    case "X25519": 
                    case "X448": {
                        publicKeyData = privateKey.getPublicKeyData().getBytes();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unknown key type " + keyType);
                    }
                }
                grantedPublicKeyInfo = new SubjectPublicKeyInfo(privateKey.getPrivateKeyAlgorithm(), publicKeyData);
                try {
                    grantedPublicKeyInfo = X509Util.toRfc3279Style((SubjectPublicKeyInfo)grantedPublicKeyInfo);
                }
                catch (InvalidKeySpecException ex) {
                    throw new OperationException(ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
                }
            }
            throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, "no public key is specified");
        }
        try {
            grantedPublicKeyInfo = certprofile.checkPublicKey(grantedPublicKeyInfo);
        }
        catch (CertprofileException ex) {
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, "exception in cert profile " + certprofileIdent);
        }
        catch (BadCertTemplateException ex) {
            throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, (Throwable)ex);
        }
        StringBuilder msgBuilder = new StringBuilder();
        try {
            subjectInfo = certprofile.getSubject(requestedSubject, grantedPublicKeyInfo);
        }
        catch (CertprofileException ex) {
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, "exception in cert profile " + certprofileIdent);
        }
        catch (BadCertTemplateException ex) {
            throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, (Throwable)ex);
        }
        if (forCrossCert) {
            if (!X509Util.canonicalizName((X500Name)subjectInfo.getGrantedSubject()).equals(X509Util.canonicalizName((X500Name)requestedSubject))) {
                throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, "subject did not match the certificate profile");
            }
            grantedSubject = requestedSubject;
        } else {
            grantedSubject = subjectInfo.getGrantedSubject();
            if (subjectInfo.getWarning() != null) {
                msgBuilder.append(", ").append(subjectInfo.getWarning());
            }
        }
        ASN1ObjectIdentifier[] attrTypes = grantedSubject.getAttributeTypes();
        if (attrTypes == null || attrTypes.length == 0) {
            throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, "empty subject is not permitted");
        }
        if (X509Util.canonicalizName((X500Name)grantedSubject).equals(this.caInfo.getPublicCaInfo().getC14nSubject())) {
            throw new OperationException(ErrorCode.ALREADY_ISSUED, "certificate with the same subject as CA is not allowed");
        }
        if (certprofile.hasNoWellDefinedExpirationDate()) {
            grantedNotAfter = MAX_CERT_TIME;
        } else {
            Validity validity = certprofile.getValidity();
            if (validity == null) {
                validity = this.caInfo.getMaxValidity();
            } else if (validity.compareTo(this.caInfo.getMaxValidity()) > 0) {
                validity = this.caInfo.getMaxValidity();
            }
            Date maxNotAfter = validity.add(grantedNotBefore);
            if (maxNotAfter.getTime() > 253402300799000L) {
                maxNotAfter = MAX_CERT_TIME;
            }
            if ((grantedNotAfter = certTemplate.getNotAfter()) != null) {
                if (grantedNotAfter.after(maxNotAfter)) {
                    grantedNotAfter = maxNotAfter;
                    msgBuilder.append(", notAfter modified");
                }
            } else {
                grantedNotAfter = maxNotAfter;
            }
            if (grantedNotAfter.after(this.caInfo.getNotAfter())) {
                ValidityMode caMode = this.caInfo.getValidityMode();
                NotAfterMode profileMode = certprofile.getNotAfterMode();
                if (profileMode == null) {
                    profileMode = NotAfterMode.BY_CA;
                }
                if (profileMode == NotAfterMode.STRICT) {
                    throw new OperationException(ErrorCode.NOT_PERMITTED, "notAfter outside of CA's validity is not permitted by the CertProfile");
                }
                if (caMode == ValidityMode.STRICT) {
                    throw new OperationException(ErrorCode.NOT_PERMITTED, "notAfter outside of CA's validity is not permitted by the CA");
                }
                if (caMode == ValidityMode.CUTOFF) {
                    grantedNotAfter = this.caInfo.getNotAfter();
                } else if (caMode == ValidityMode.LAX) {
                    if (profileMode == NotAfterMode.CUTOFF) {
                        grantedNotAfter = this.caInfo.getNotAfter();
                    }
                } else {
                    throw new IllegalStateException("should not reach here, CA ValidityMode " + caMode + " CertProfile NotAfterMode " + profileMode);
                }
            }
        }
        String warning = null;
        if (msgBuilder.length() > 2) {
            warning = msgBuilder.substring(2);
        }
        X509Ca.GrantedCertTemplate gct = new X509Ca.GrantedCertTemplate(batch, certTemplate.getCertReqId(), certTemplate.getExtensions(), certprofile, grantedNotBefore, grantedNotAfter, requestedSubject, grantedPublicKeyInfo, privateKey, signer, warning);
        gct.setGrantedSubject(grantedSubject);
        return gct;
    }
}

