/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.Closeable;
import java.math.BigInteger;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.api.mgmt.RequestorInfo;
import org.xipki.ca.api.mgmt.RevokeSuspendedControl;
import org.xipki.ca.server.CaIdNameMap;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.X509CaModule;
import org.xipki.ca.server.X509PublisherModule;
import org.xipki.ca.server.db.CertStore;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.DateUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.Validity;
import org.xipki.util.exception.ErrorCode;
import org.xipki.util.exception.OperationException;

public class X509RevokerModule
extends X509CaModule
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(X509RevokerModule.class);
    private final boolean masterMode;
    private final CertStore certstore;
    private final CaIdNameMap caIdNameMap;
    private final X509PublisherModule publisherModule;
    private ScheduledFuture<?> suspendedCertsRevoker;

    public X509RevokerModule(CaManagerImpl caManager, CaInfo caInfo, CertStore certstore, X509PublisherModule publisherModule) {
        super(caInfo);
        this.caIdNameMap = caManager.idNameMap();
        this.certstore = certstore;
        this.masterMode = caManager.isMasterMode();
        this.publisherModule = publisherModule;
        if (!this.masterMode) {
            return;
        }
        ScheduledThreadPoolExecutor executor = caManager.getScheduledThreadPoolExecutor();
        Random random = new Random();
        this.suspendedCertsRevoker = executor.scheduleAtFixedRate(new SuspendedCertsRevoker(), random.nextInt(60), 60L, TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertWithRevocationInfo revokeCert(BigInteger serialNumber, CrlReason reason, Date invalidityTime, AuditEvent event) throws OperationException {
        if (this.caInfo.isSelfSigned() && this.caInfo.getSerialNumber().equals(serialNumber)) {
            throw new OperationException(ErrorCode.NOT_PERMITTED, "insufficient permission to revoke CA certificate");
        }
        if (reason == null) {
            reason = CrlReason.UNSPECIFIED;
        }
        switch (reason) {
            case CA_COMPROMISE: 
            case AA_COMPROMISE: 
            case REMOVE_FROM_CRL: {
                throw new OperationException(ErrorCode.NOT_PERMITTED, "insufficient permission to revoke certificate with reason " + reason.getDescription());
            }
            case UNSPECIFIED: 
            case KEY_COMPROMISE: 
            case AFFILIATION_CHANGED: 
            case SUPERSEDED: 
            case CESSATION_OF_OPERATION: 
            case CERTIFICATE_HOLD: 
            case PRIVILEGE_WITHDRAWN: {
                break;
            }
            default: {
                throw new IllegalStateException("unknown CRL reason " + reason);
            }
        }
        boolean successful = true;
        try {
            CertWithRevocationInfo ret = this.revokeCertificate0(serialNumber, reason, invalidityTime, false, event);
            successful = ret != null;
            CertWithRevocationInfo certWithRevocationInfo = ret;
            return certWithRevocationInfo;
        }
        finally {
            this.setEventStatus(event, successful);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertWithDbId unsuspendCert(BigInteger serialNumber, AuditEvent event) throws OperationException {
        if (this.caInfo.isSelfSigned() && this.caInfo.getSerialNumber().equals(serialNumber)) {
            throw new OperationException(ErrorCode.NOT_PERMITTED, "insufficient permission to unsuspend CA certificate");
        }
        boolean successful = false;
        try {
            CertWithDbId ret = this.unsuspendCert0(serialNumber, false, event);
            successful = true;
            CertWithDbId certWithDbId = ret;
            return certWithDbId;
        }
        finally {
            this.setEventStatus(event, successful);
        }
    }

    private CertWithRevocationInfo revokeCertificate0(BigInteger serialNumber, CrlReason reason, Date invalidityTime, boolean force, AuditEvent event) throws OperationException {
        String hexSerial = LogUtil.formatCsn((BigInteger)serialNumber);
        event.addEventData("serial", (Object)hexSerial);
        event.addEventData("reason", (Object)reason.getDescription());
        if (invalidityTime != null) {
            event.addEventData("invalidity_time", (Object)DateUtil.toUtcTimeyyyyMMddhhmmss((Date)invalidityTime));
        }
        LOG.info("     START revokeCertificate: ca={}, serialNumber={}, reason={}, invalidityTime={}", new Object[]{this.caIdent.getName(), hexSerial, reason.getDescription(), invalidityTime});
        CertRevocationInfo revInfo = new CertRevocationInfo(reason, new Date(), invalidityTime);
        CertWithRevocationInfo revokedCert = this.certstore.revokeCert(this.caIdent, serialNumber, revInfo, force, this.caIdNameMap);
        if (revokedCert == null) {
            return null;
        }
        this.publisherModule.publishCertRevoked(revokedCert);
        if (LOG.isInfoEnabled()) {
            LOG.info("SUCCESSFUL revokeCertificate: ca={}, serialNumber={}, reason={}, invalidityTime={}, revocationResult=REVOKED", new Object[]{this.caIdent.getName(), hexSerial, reason.getDescription(), invalidityTime});
        }
        return revokedCert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CertWithRevocationInfo revokeSuspendedCert(CertStore.SerialWithId serialNumber, CrlReason reason) throws OperationException {
        boolean successful = false;
        AuditEvent event = this.newAuditEvent("revoke_suspended_cert", null);
        try {
            CertWithRevocationInfo ret = this.revokeSuspendedCert0(serialNumber, reason, event);
            successful = ret != null;
            CertWithRevocationInfo certWithRevocationInfo = ret;
            return certWithRevocationInfo;
        }
        finally {
            this.finish(event, successful);
        }
    }

    private CertWithRevocationInfo revokeSuspendedCert0(CertStore.SerialWithId serialNumber, CrlReason reason, AuditEvent event) throws OperationException {
        CertWithRevocationInfo revokedCert;
        String hexSerial = LogUtil.formatCsn((BigInteger)serialNumber.getSerial());
        event.addEventData("serial", (Object)hexSerial);
        event.addEventData("reason", (Object)reason.getDescription());
        if (LOG.isInfoEnabled()) {
            LOG.info("     START revokeSuspendedCert: ca={}, serialNumber={}, reason={}", new Object[]{this.caIdent.getName(), hexSerial, reason.getDescription()});
        }
        if ((revokedCert = this.certstore.revokeSuspendedCert(this.caIdent, serialNumber, reason, this.caIdNameMap)) == null) {
            return null;
        }
        this.publisherModule.publishCertRevoked(revokedCert);
        if (LOG.isInfoEnabled()) {
            LOG.info("SUCCESSFUL revokeSuspendedCert: ca={}, serialNumber={}, reason={}", new Object[]{this.caIdent.getName(), hexSerial, reason.getDescription()});
        }
        return revokedCert;
    }

    private CertWithDbId unsuspendCert0(BigInteger serialNumber, boolean force, AuditEvent event) throws OperationException {
        String hexSerial = LogUtil.formatCsn((BigInteger)serialNumber);
        event.addEventData("serial", (Object)hexSerial);
        LOG.info("     START unsuspendertificate: ca={}, serialNumber={}", (Object)this.caIdent.getName(), (Object)hexSerial);
        CertWithDbId unrevokedCert = this.certstore.unsuspendCert(this.caIdent, serialNumber, force, this.caIdNameMap);
        if (unrevokedCert == null) {
            return null;
        }
        this.publisherModule.publishCertUnrevoked(unrevokedCert);
        LOG.info("SUCCESSFUL unsuspendCertificate: ca={}, serialNumber={}", (Object)this.caIdent.getName(), (Object)hexSerial);
        return unrevokedCert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeCa(RequestorInfo requestor, CertRevocationInfo revocationInfo) throws OperationException {
        boolean succ;
        Args.notNull((Object)revocationInfo, (String)"revocationInfo");
        this.caInfo.setRevocationInfo(revocationInfo);
        if (this.caInfo.isSelfSigned()) {
            AuditEvent event = this.newAuditEvent(revocationInfo.getReason() == CrlReason.CERTIFICATE_HOLD ? "revoke_ca" : "revoke_ca", requestor);
            boolean successful = true;
            try {
                CertWithRevocationInfo ret = this.revokeCertificate0(this.caInfo.getSerialNumber(), revocationInfo.getReason(), revocationInfo.getInvalidityTime(), true, event);
                successful = ret != null;
            }
            finally {
                this.finish(event, successful);
            }
        }
        if (!(succ = this.publisherModule.publishCaRevoked(revocationInfo))) {
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, "could not publish event caRevoked of CA " + this.caIdent + " to at least one publisher");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unrevokeCa(RequestorInfo requestor) throws OperationException {
        boolean succ;
        this.caInfo.setRevocationInfo(null);
        if (this.caInfo.isSelfSigned()) {
            AuditEvent event = this.newAuditEvent("unrevoke_ca", requestor);
            boolean successful = false;
            try {
                this.unsuspendCert0(this.caInfo.getSerialNumber(), true, event);
                successful = true;
            }
            finally {
                this.finish(event, successful);
            }
        }
        if (!(succ = this.publisherModule.publishCaUnrevoked())) {
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, "could not event caUnrevoked of CA " + this.caIdent + " to at least one publisher");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int revokeSuspendedCerts() throws OperationException {
        LOG.debug("revoking suspended certificates");
        AuditEvent event = this.newAuditEvent("revoke_suspended_cert", null);
        boolean successful = false;
        try {
            int num = this.revokeSuspendedCerts0();
            LOG.info("revoked {} suspended certificates of CA {}", (Object)num, (Object)this.caIdent.getName());
            successful = true;
            int n = num;
            return n;
        }
        finally {
            this.finish(event, successful);
        }
    }

    private int revokeSuspendedCerts0() throws OperationException {
        long ms;
        if (!this.masterMode) {
            throw new OperationException(ErrorCode.NOT_PERMITTED, "CA could not remove expired certificates in slave mode");
        }
        int numEntries = 100;
        RevokeSuspendedControl control = this.caInfo.revokeSuspendedCertsControl();
        Validity val = control.getUnchangedSince();
        int validity = val.getValidity();
        Validity.Unit unit = val.getUnit();
        long l = unit == Validity.Unit.MINUTE ? (long)validity * 60000L : (unit == Validity.Unit.HOUR ? (long)validity * 3600000L : (unit == Validity.Unit.DAY ? (long)validity * 86400000L : (unit == Validity.Unit.WEEK ? (long)validity * 604800000L : (ms = unit == Validity.Unit.YEAR ? (long)(validity * 365) * 86400000L : -1L))));
        if (ms == -1L) {
            throw new IllegalStateException("should not reach here, unknown Validity Unit " + val.getUnit());
        }
        long latestLastUpdatedAt = (System.currentTimeMillis() - ms) / 1000L;
        CrlReason reason = control.getTargetReason();
        int sum = 0;
        List<CertStore.SerialWithId> serials;
        block2: while (!CollectionUtil.isEmpty(serials = this.certstore.getSuspendedCertSerials(this.caIdent, latestLastUpdatedAt, 100))) {
            Iterator<CertStore.SerialWithId> iterator = serials.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block2;
                CertStore.SerialWithId serial = iterator.next();
                try {
                    boolean revoked = this.revokeSuspendedCert(serial, reason) != null;
                    if (!revoked) continue;
                    ++sum;
                }
                catch (OperationException ex) {
                    LOG.info("revoked {} suspended certificates of CA {}", (Object)sum, (Object)this.caIdent.getName());
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not revoke suspended certificate with serial" + serial));
                    throw ex;
                }
            }
            break;
        }
        return sum;
    }

    @Override
    public void close() {
        if (this.suspendedCertsRevoker != null) {
            this.suspendedCertsRevoker.cancel(false);
            this.suspendedCertsRevoker = null;
        }
    }

    private class SuspendedCertsRevoker
    implements Runnable {
        private boolean inProcess;

        private SuspendedCertsRevoker() {
        }

        @Override
        public void run() {
            if (X509RevokerModule.this.caInfo.revokeSuspendedCertsControl() == null || !X509RevokerModule.this.caInfo.revokeSuspendedCertsControl().isEnabled()) {
                return;
            }
            if (this.inProcess) {
                return;
            }
            this.inProcess = true;
            try {
                LOG.debug("revoking suspended certificates");
                int num = X509RevokerModule.this.revokeSuspendedCerts();
                if (num == 0) {
                    LOG.debug("revoked {} suspended certificates of CA '{}'", (Object)num, (Object)X509RevokerModule.this.caIdent);
                } else {
                    LOG.info("revoked {} suspended certificates of CA '{}'", (Object)num, (Object)X509RevokerModule.this.caIdent);
                }
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not revoke suspended certificates");
            }
            finally {
                this.inProcess = false;
            }
        }
    }
}

