/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.entry.ChangeCaEntry;
import org.xipki.ca.api.mgmt.entry.KeypairGenEntry;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.KeypairGenEntryWrapper;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.util.Args;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.ObjectCreationException;

class KeypairGenManager {
    private static final Logger LOG = LoggerFactory.getLogger(KeypairGenManager.class);
    private boolean keypairGenInitialized;
    private final CaManagerImpl manager;

    KeypairGenManager(CaManagerImpl manager) {
        this.manager = manager;
    }

    void reset() {
        this.keypairGenInitialized = false;
    }

    void initKeypairGens() throws CaMgmtException {
        if (this.keypairGenInitialized) {
            return;
        }
        this.manager.keypairGenDbEntries.clear();
        this.manager.keypairGens.clear();
        int dbSchemaVersion = this.manager.getDbSchemaVersion();
        if (dbSchemaVersion < 7) {
            throw new CaMgmtException("dbSchemaVersion < 7 unsupported: " + dbSchemaVersion);
        }
        List names = this.manager.queryExecutor.namesFromTable("KEYPAIR_GEN");
        ArrayList<KeypairGenEntry> entries = new ArrayList<KeypairGenEntry>(names.size());
        for (String name : names) {
            entries.add(this.manager.queryExecutor.createKeypairGen(name));
        }
        for (KeypairGenEntry entry : entries) {
            String name = entry.getName();
            this.manager.keypairGenDbEntries.put(name, entry);
            KeypairGenEntryWrapper gen = this.createKeypairGen(entry);
            this.manager.keypairGens.put(name, gen);
            LOG.info("loaded keypair generation {}", (Object)name);
        }
        this.keypairGenInitialized = true;
    }

    void addKeypairGen(KeypairGenEntry keypairGenEntry) throws CaMgmtException {
        Args.notNull((Object)keypairGenEntry, (String)"keypairGenEntry");
        if ("software".equalsIgnoreCase(keypairGenEntry.getName())) {
            throw new CaMgmtException("Adding keypair generation 'software' is not allowed");
        }
        this.manager.assertMasterMode();
        String name = keypairGenEntry.getName();
        if (this.manager.keypairGenDbEntries.containsKey(name)) {
            throw new CaMgmtException(StringUtil.concat((String)"keypair generation named ", (String[])new String[]{name, " exists"}));
        }
        KeypairGenEntryWrapper gen = this.createKeypairGen(keypairGenEntry);
        this.manager.queryExecutor.addKeypairGen(keypairGenEntry);
        this.manager.keypairGens.put(name, gen);
        this.manager.keypairGenDbEntries.put(name, keypairGenEntry);
    }

    void removeKeypairGen(String name) throws CaMgmtException {
        this.manager.assertMasterMode();
        name = Args.toNonBlankLower((String)name, (String)"name");
        boolean bo = this.manager.queryExecutor.deleteRowWithName(name, "KEYPAIR_GEN");
        if (!bo) {
            throw new CaMgmtException("unknown keypair generation " + name);
        }
        for (String caName : this.manager.caInfos.keySet()) {
            CaInfo caInfo = this.manager.caInfos.get(caName);
            List<String> names = caInfo.getKeypairGenNames();
            if (names == null || !names.contains(name)) continue;
            ChangeCaEntry changeCaEntry = new ChangeCaEntry(caInfo.getIdent());
            ArrayList<String> newNames = new ArrayList<String>(names);
            newNames.remove(name);
            changeCaEntry.setKeypairGenNames(newNames);
            this.manager.queryExecutor.changeCa(changeCaEntry, caInfo.getCaEntry(), caInfo.getCaConfColumn(), this.manager.securityFactory);
            caInfo.getKeypairGenNames().remove(name);
        }
        this.manager.keypairGenDbEntries.remove(name);
        this.manager.keypairGens.remove(name);
        LOG.info("removed keypair generation '{}'", (Object)name);
    }

    void changeKeypairGen(String name, String type, String conf) throws CaMgmtException {
        this.manager.assertMasterMode();
        name = Args.toNonBlankLower((String)name, (String)"name");
        if (type == null && conf == null) {
            throw new IllegalArgumentException("nothing to change");
        }
        if (type != null) {
            type = type.toLowerCase();
        }
        KeypairGenEntryWrapper newKeypairGen = this.manager.queryExecutor.changeKeypairGen(name, type, conf, this.manager);
        this.manager.keypairGens.remove(name);
        this.manager.keypairGenDbEntries.remove(name);
        this.manager.keypairGenDbEntries.put(name, newKeypairGen.getDbEntry());
        this.manager.keypairGens.put(name, newKeypairGen);
    }

    KeypairGenEntryWrapper createKeypairGen(KeypairGenEntry entry) throws CaMgmtException {
        Args.notNull((Object)entry, (String)"entry");
        KeypairGenEntryWrapper ret = new KeypairGenEntryWrapper();
        ret.setDbEntry(entry);
        try {
            ret.init(this.manager.securityFactory, this.manager.shardId, this.manager.datasourceNameConfFileMap);
        }
        catch (ObjectCreationException ex) {
            String message = "error createKeypairGen";
            LOG.debug("error createKeypairGen", (Throwable)ex);
            throw new CaMgmtException(ex.getMessage());
        }
        return ret;
    }
}

