/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.util.Map;
import org.xipki.ca.api.mgmt.entry.KeypairGenEntry;
import org.xipki.ca.server.keypool.KeypoolKeypairGenerator;
import org.xipki.security.KeypairGenerator;
import org.xipki.security.SecurityFactory;
import org.xipki.security.XiSecurityException;
import org.xipki.util.Args;
import org.xipki.util.FileOrValue;
import org.xipki.util.exception.ObjectCreationException;

public class KeypairGenEntryWrapper {
    private KeypairGenEntry dbEntry;
    private KeypairGenerator generator;

    public void setDbEntry(KeypairGenEntry dbEntry) {
        this.dbEntry = (KeypairGenEntry)Args.notNull((Object)dbEntry, (String)"dbEntry");
    }

    public void init(SecurityFactory securityFactory, int shardId, Map<String, FileOrValue> datasourceConfs) throws ObjectCreationException {
        Args.notNull((Object)securityFactory, (String)"securityFactory");
        this.dbEntry.setFaulty(true);
        if ("KEYPOOL".equalsIgnoreCase(this.dbEntry.getType())) {
            this.generator = new KeypoolKeypairGenerator();
            ((KeypoolKeypairGenerator)this.generator).setShardId(shardId);
            ((KeypoolKeypairGenerator)this.generator).setDatasourceConfs(datasourceConfs);
            try {
                this.generator.initialize(this.dbEntry.getConf(), securityFactory.getPasswordResolver());
            }
            catch (XiSecurityException ex) {
                throw new ObjectCreationException("error initializing keypair generator " + this.dbEntry.getName(), (Throwable)ex);
            }
        } else {
            this.generator = securityFactory.createKeypairGenerator(this.dbEntry.getType(), this.dbEntry.getConf());
        }
        this.generator.setName(this.dbEntry.getName());
        this.dbEntry.setFaulty(false);
    }

    public KeypairGenEntry getDbEntry() {
        return this.dbEntry;
    }

    public KeypairGenerator getGenerator() {
        return this.generator;
    }

    public boolean isHealthy() {
        return this.generator != null && this.generator.isHealthy();
    }
}

