/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.math.BigInteger;
import java.time.Clock;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.security.HashAlgo;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;

class PendingCertificatePool {
    private final Map<String, Set<MyEntry>> map = new HashMap<String, Set<MyEntry>>();

    PendingCertificatePool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCertificate(String transactionId, BigInteger certReqId, CertificateInfo certInfo, long waitForConfirmTill) {
        Args.notNull((Object)transactionId, (String)"transactionId");
        Args.notNull((Object)certInfo, (String)"certInfo");
        if (certInfo.isAlreadyIssued()) {
            return;
        }
        MyEntry myEntry = new MyEntry(certReqId, waitForConfirmTill, certInfo);
        Map<String, Set<MyEntry>> map = this.map;
        synchronized (map) {
            Set entries = this.map.computeIfAbsent(transactionId, k -> new HashSet());
            entries.add(myEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CertificateInfo removeCertificate(String transactionId, BigInteger certReqId, byte[] certHash) {
        Args.notBlank((String)transactionId, (String)"transactionId");
        Args.notNull((Object)certReqId, (String)"certReqId");
        Args.notNull((Object)certHash, (String)"certHash");
        MyEntry retEntry = null;
        Map<String, Set<MyEntry>> map = this.map;
        synchronized (map) {
            Set<MyEntry> entries = this.map.get(transactionId);
            if (entries == null) {
                return null;
            }
            for (MyEntry entry : entries) {
                if (!certReqId.equals(entry.certReqId)) continue;
                retEntry = entry;
                break;
            }
            if (retEntry != null && Arrays.equals(certHash, retEntry.certHash)) {
                entries.remove(retEntry);
                if (CollectionUtil.isEmpty(entries)) {
                    this.map.remove(transactionId);
                }
            }
        }
        return retEntry == null ? null : retEntry.certInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<CertificateInfo> removeCertificates(String transactionId) {
        Set<MyEntry> entries;
        Args.notNull((Object)transactionId, (String)"transactionId");
        Map<String, Set<MyEntry>> map = this.map;
        synchronized (map) {
            entries = this.map.remove(transactionId);
        }
        if (entries == null) {
            return null;
        }
        HashSet<CertificateInfo> ret = new HashSet<CertificateInfo>();
        for (MyEntry myEntry : entries) {
            ret.add(myEntry.certInfo);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<CertificateInfo> removeConfirmTimeoutedCertificates() {
        Map<String, Set<MyEntry>> map = this.map;
        synchronized (map) {
            if (CollectionUtil.isEmpty(this.map)) {
                return null;
            }
            long now = Clock.systemUTC().millis();
            HashSet<CertificateInfo> ret = new HashSet<CertificateInfo>();
            for (Map.Entry<String, Set<MyEntry>> entry0 : this.map.entrySet()) {
                Set<MyEntry> entries = entry0.getValue();
                for (MyEntry entry : entries) {
                    if (entry.waitForConfirmTill >= now) continue;
                    ret.add(entry.certInfo);
                }
            }
            return ret;
        }
    }

    private static class MyEntry {
        private final BigInteger certReqId;
        private final long waitForConfirmTill;
        private final CertificateInfo certInfo;
        private final byte[] certHash;

        MyEntry(BigInteger certReqId, long waitForConfirmTill, CertificateInfo certInfo) {
            this.certReqId = (BigInteger)Args.notNull((Object)certReqId, (String)"certReqId");
            this.certInfo = (CertificateInfo)Args.notNull((Object)certInfo, (String)"certInfo");
            this.waitForConfirmTill = waitForConfirmTill;
            this.certHash = HashAlgo.SHA1.hash((byte[][])new byte[][]{certInfo.getCert().getCert().getEncoded()});
        }

        public int hashCode() {
            return this.certReqId.hashCode() + 961 * (int)this.waitForConfirmTill + 31 * this.certInfo.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MyEntry)) {
                return false;
            }
            MyEntry another = (MyEntry)obj;
            return this.certReqId.equals(another.certReqId) && this.certInfo.equals(another.certInfo);
        }
    }
}

