/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.security.cert.CertificateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.mgmt.entry.RequestorEntry;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

public class RequestorEntryWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(RequestorEntryWrapper.class);
    private RequestorEntry dbEntry;
    private CertWithDbId cert;

    public void setDbEntry(RequestorEntry dbEntry) {
        this.dbEntry = (RequestorEntry)Args.notNull((Object)dbEntry, (String)"dbEntry");
        String type = dbEntry.getType();
        String conf = dbEntry.getConf();
        dbEntry.setFaulty(true);
        if ("cert".equalsIgnoreCase(type)) {
            try {
                dbEntry.setFaulty(false);
                this.cert = new CertWithDbId(X509Util.parseCert((byte[])StringUtil.toUtf8Bytes((String)conf)));
            }
            catch (CertificateException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("error while parsing certificate of requestor" + dbEntry.getIdent()));
            }
        }
    }

    public CertWithDbId getCert() {
        return this.cert;
    }

    public RequestorEntry getDbEntry() {
        return this.dbEntry;
    }
}

