/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditService;
import org.xipki.audit.AuditStatus;
import org.xipki.audit.Audits;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.RequestorInfo;
import org.xipki.ca.server.CaInfo;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;

public abstract class X509CaModule {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected final NameId caIdent;
    protected final CaInfo caInfo;
    protected final X509Cert caCert;
    protected final List<byte[]> encodedCaCertChain;

    public X509CaModule(CaInfo caInfo) {
        this.caInfo = (CaInfo)Args.notNull((Object)caInfo, (String)"caInfo");
        this.caIdent = caInfo.getIdent();
        this.caCert = caInfo.getCert();
        this.encodedCaCertChain = new ArrayList<byte[]>(2);
        this.encodedCaCertChain.add(this.caCert.getEncoded());
        if (caInfo.getCertchain() != null) {
            for (X509Cert c : caInfo.getCertchain()) {
                this.encodedCaCertChain.add(c.getEncoded());
            }
        }
    }

    protected static AuditService auditService() {
        return Audits.getAuditService();
    }

    protected AuditEvent newAuditEvent(String eventType, RequestorInfo requestor) {
        Args.notNull((Object)eventType, (String)"eventType");
        AuditEvent event = new AuditEvent();
        event.setApplicationName("ca");
        event.setEventData("ca", (Object)this.caIdent.getName());
        event.setEventType(eventType);
        if (requestor != null) {
            event.setEventData("requestor", (Object)requestor.getIdent().getName());
        }
        return event;
    }

    protected void setEventStatus(AuditEvent event, boolean successful) {
        event.setLevel(successful ? AuditLevel.INFO : AuditLevel.ERROR);
        event.setStatus(successful ? AuditStatus.SUCCESSFUL : AuditStatus.FAILED);
    }

    protected void finish(AuditEvent event, boolean successful) {
        this.setEventStatus(event, successful);
        event.finish();
        X509CaModule.auditService().logEvent(event);
        event.log(this.LOG);
    }

    protected boolean verifySignature(X509Cert cert) {
        Args.notNull((Object)cert, (String)"cert");
        PublicKey caPublicKey = this.caCert.getPublicKey();
        try {
            cert.verify(caPublicKey);
            return true;
        }
        catch (Exception ex) {
            this.LOG.debug("{} while verifying signature: {}", (Object)ex.getClass().getName(), (Object)ex.getMessage());
            return false;
        }
    }
}

