/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.db;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CrlControl;
import org.xipki.ca.api.mgmt.CtlogControl;
import org.xipki.ca.api.mgmt.RevokeSuspendedControl;
import org.xipki.ca.api.mgmt.entry.CaConfColumn;
import org.xipki.ca.api.mgmt.entry.CaEntry;
import org.xipki.ca.api.mgmt.entry.CaHasRequestorEntry;
import org.xipki.ca.api.mgmt.entry.CertprofileEntry;
import org.xipki.ca.api.mgmt.entry.ChangeCaEntry;
import org.xipki.ca.api.mgmt.entry.KeypairGenEntry;
import org.xipki.ca.api.mgmt.entry.PublisherEntry;
import org.xipki.ca.api.mgmt.entry.RequestorEntry;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.IdentifiedCertPublisher;
import org.xipki.ca.server.IdentifiedCertprofile;
import org.xipki.ca.server.KeypairGenEntryWrapper;
import org.xipki.ca.server.RequestorEntryWrapper;
import org.xipki.ca.server.SignerEntryWrapper;
import org.xipki.ca.server.db.CaManagerQueryExecutorBase;
import org.xipki.ca.server.db.CertStore;
import org.xipki.ca.server.db.QueryExecutor;
import org.xipki.ca.server.db.ResultRow;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.password.PasswordResolver;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.SqlUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.ObjectCreationException;
import org.xipki.util.exception.OperationException;

public class CaManagerQueryExecutor
extends CaManagerQueryExecutorBase {
    private static final Logger LOG = LoggerFactory.getLogger(CaManagerQueryExecutor.class);
    private final String sqlSelectProfileId;
    private final String sqlSelectProfile;
    private final String sqlSelectPublisherId;
    private final String sqlSelectPublisher;
    private final String sqlSelectRequestorId;
    private final String sqlSelectRequestor;
    private final String sqlSelectSigner;
    private final String sqlSelectKeypairGen;
    private final String sqlSelectCaId;
    private final String sqlSelectCa;
    private final String sqlNextSelectCrlNo;
    private final String sqlSelectSystemEvent;
    private final Map<CaManagerQueryExecutorBase.Table, AtomicLong> cachedIdMap = new HashMap<CaManagerQueryExecutorBase.Table, AtomicLong>();

    public CaManagerQueryExecutor(DataSourceWrapper datasource) throws CaMgmtException {
        super(datasource);
        for (CaManagerQueryExecutorBase.Table m : CaManagerQueryExecutorBase.Table.values()) {
            this.cachedIdMap.put(m, new AtomicLong(0L));
        }
        this.sqlSelectProfileId = this.buildSelectFirstSql("ID FROM PROFILE WHERE NAME=?");
        this.sqlSelectCaId = this.buildSelectFirstSql("ID FROM CA WHERE NAME=?");
        this.sqlSelectPublisherId = this.buildSelectFirstSql("ID FROM PUBLISHER WHERE NAME=?");
        this.sqlSelectRequestorId = this.buildSelectFirstSql("ID FROM REQUESTOR WHERE NAME=?");
        this.sqlSelectProfile = this.buildSelectFirstSql("ID,TYPE,CONF FROM PROFILE WHERE NAME=?");
        this.sqlSelectPublisher = this.buildSelectFirstSql("ID,TYPE,CONF FROM PUBLISHER WHERE NAME=?");
        this.sqlSelectRequestor = this.buildSelectFirstSql("ID,TYPE,CONF FROM REQUESTOR WHERE NAME=?");
        this.sqlSelectSigner = this.buildSelectFirstSql("TYPE,CERT,CONF FROM SIGNER WHERE NAME=?");
        this.sqlSelectKeypairGen = this.buildSelectFirstSql("TYPE,CONF FROM KEYPAIR_GEN WHERE NAME=?");
        this.sqlSelectCa = this.buildSelectFirstSql("ID,STATUS,NEXT_CRLNO,CRL_SIGNER_NAME,SUBJECT,REV_INFO,SIGNER_TYPE,SIGNER_CONF,CERT,CERTCHAIN,CONF FROM CA WHERE NAME=?");
        this.sqlNextSelectCrlNo = this.buildSelectFirstSql("NEXT_CRLNO FROM CA WHERE ID=?");
        this.sqlSelectSystemEvent = this.buildSelectFirstSql("EVENT_TIME,EVENT_OWNER FROM SYSTEM_EVENT WHERE NAME=?");
    }

    public CertStore.SystemEvent getSystemEvent(String eventName) throws CaMgmtException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlSelectSystemEvent, CaManagerQueryExecutor.col2Str(eventName));
        return rs == null ? null : new CertStore.SystemEvent(eventName, rs.getString("EVENT_OWNER"), CaManagerQueryExecutor.getLong(rs, "EVENT_TIME"));
    }

    private void deleteSystemEvent(String eventName) throws CaMgmtException {
        this.execUpdatePrepStmt0("DELETE FROM SYSTEM_EVENT WHERE NAME=?", CaManagerQueryExecutor.col2Str(eventName));
    }

    private void addSystemEvent(CertStore.SystemEvent systemEvent) throws CaMgmtException {
        String sql = SqlUtil.buildInsertSql((String)"SYSTEM_EVENT", (String)"NAME,EVENT_TIME,EVENT_TIME2,EVENT_OWNER");
        int num = this.execUpdatePrepStmt0(sql, CaManagerQueryExecutor.col2Str(systemEvent.getName()), CaManagerQueryExecutor.col2Long(systemEvent.getEventTime()), CaManagerQueryExecutor.col2Timestamp(new Timestamp(systemEvent.getEventTime() * 1000L)), CaManagerQueryExecutor.col2Str(systemEvent.getOwner()));
        if (num == 0) {
            throw new CaMgmtException("could not add system event " + systemEvent.getName());
        }
        LOG.info("added system event {}", (Object)systemEvent.getName());
    }

    public void changeSystemEvent(CertStore.SystemEvent systemEvent) throws CaMgmtException {
        this.deleteSystemEvent(systemEvent.getName());
        this.addSystemEvent(systemEvent);
    }

    public Map<String, Integer> createCaAliases() throws CaMgmtException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<ResultRow> rows = this.execQueryStmt0("SELECT NAME,CA_ID FROM CAALIAS");
        for (ResultRow m : rows) {
            map.put(m.getString("NAME"), CaManagerQueryExecutor.getInt(m, "CA_ID"));
        }
        return map;
    }

    public CertprofileEntry createCertprofile(String name) throws CaMgmtException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlSelectProfile, CaManagerQueryExecutor.col2Str(name));
        if (rs == null) {
            throw new CaMgmtException("unknown CA " + name);
        }
        return new CertprofileEntry(new NameId(Integer.valueOf(CaManagerQueryExecutor.getInt(rs, "ID")), name), rs.getString("TYPE"), rs.getString("CONF"));
    }

    public PublisherEntry createPublisher(String name) throws CaMgmtException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlSelectPublisher, CaManagerQueryExecutor.col2Str(name));
        if (rs == null) {
            throw new CaMgmtException("unkown Publisher " + name);
        }
        return new PublisherEntry(new NameId(Integer.valueOf(CaManagerQueryExecutor.getInt(rs, "ID")), name), rs.getString("TYPE"), rs.getString("CONF"));
    }

    public Integer getRequestorId(String requestorName) throws CaMgmtException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlSelectRequestorId, CaManagerQueryExecutor.col2Str(requestorName));
        return rs == null ? null : Integer.valueOf(CaManagerQueryExecutor.getInt(rs, "ID"));
    }

    public RequestorEntry createRequestor(String name) throws CaMgmtException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlSelectRequestor, CaManagerQueryExecutor.col2Str(name));
        if (rs == null) {
            throw new CaMgmtException("unknown Requestor " + name);
        }
        return new RequestorEntry(new NameId(Integer.valueOf(CaManagerQueryExecutor.getInt(rs, "ID")), name), rs.getString("TYPE"), rs.getString("CONF"));
    }

    public SignerEntry createSigner(String name) throws CaMgmtException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlSelectSigner, CaManagerQueryExecutor.col2Str(name));
        if (rs == null) {
            throw new CaMgmtException("unknown signer " + name);
        }
        return new SignerEntry(name, rs.getString("TYPE"), rs.getString("CONF"), rs.getString("CERT"));
    }

    public KeypairGenEntry createKeypairGen(String name) throws CaMgmtException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlSelectKeypairGen, CaManagerQueryExecutor.col2Str(name));
        if (rs == null) {
            throw new CaMgmtException("unknown keypair generation " + name);
        }
        return new KeypairGenEntry(name, rs.getString("TYPE"), rs.getString("CONF"));
    }

    public CaInfo createCaInfo(String name, CertStore certstore) throws CaMgmtException {
        String revInfo;
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlSelectCa, CaManagerQueryExecutor.col2Str(name));
        if (rs == null) {
            throw new CaMgmtException("unknown CA " + name);
        }
        String encodedConf = rs.getString("CONF");
        CaConfColumn conf = CaConfColumn.decode((String)encodedConf);
        CaEntry entry = new CaEntry(new NameId(Integer.valueOf(CaManagerQueryExecutor.getInt(rs, "ID")), name), conf.snSize(), CaManagerQueryExecutor.getLong(rs, "NEXT_CRLNO"), rs.getString("SIGNER_TYPE"), rs.getString("SIGNER_CONF"), conf.caUris(), conf.getNumCrls(), conf.getExpirationPeriod());
        entry.setCert(CaManagerQueryExecutor.generateCert(rs.getString("CERT")));
        List<X509Cert> certchain = CaManagerQueryExecutor.generateCertchain(rs.getString("CERTCHAIN"));
        if (CollectionUtil.isNotEmpty(certchain)) {
            CaUtil.buildCertChain(entry.getCert(), certchain);
            entry.setCertchain(certchain);
        }
        entry.setStatus(CaStatus.forName((String)rs.getString("STATUS")));
        String crlsignerName = rs.getString("CRL_SIGNER_NAME");
        if (StringUtil.isNotBlank((String)crlsignerName)) {
            entry.setCrlSignerName(crlsignerName);
        }
        CertRevocationInfo revocationInfo = (revInfo = rs.getString("REV_INFO")) == null ? null : CertRevocationInfo.fromEncoded((String)revInfo);
        entry.setRevocationInfo(revocationInfo);
        conf.fillCaEntry(entry);
        try {
            return new CaInfo(entry, conf, certstore);
        }
        catch (OperationException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    public Set<CaHasRequestorEntry> createCaHasRequestors(NameId ca) throws CaMgmtException {
        Map<Integer, String> idNameMap = this.getIdNameMap("REQUESTOR");
        String sql = "SELECT REQUESTOR_ID,PERMISSION,PROFILES FROM CA_HAS_REQUESTOR WHERE CA_ID=?";
        List<ResultRow> rows = this.execQueryPrepStmt0("SELECT REQUESTOR_ID,PERMISSION,PROFILES FROM CA_HAS_REQUESTOR WHERE CA_ID=?", CaManagerQueryExecutor.col2Int(ca.getId()));
        HashSet<CaHasRequestorEntry> ret = new HashSet<CaHasRequestorEntry>();
        for (ResultRow rs : rows) {
            int id = CaManagerQueryExecutor.getInt(rs, "REQUESTOR_ID");
            String name = idNameMap.get(id);
            List list = StringUtil.split((String)rs.getString("PROFILES"), (String)",");
            HashSet profiles = list == null ? null : new HashSet(list);
            CaHasRequestorEntry entry = new CaHasRequestorEntry(new NameId(Integer.valueOf(id), name));
            entry.setPermission(CaManagerQueryExecutor.getInt(rs, "PERMISSION"));
            entry.setProfiles(profiles);
            ret.add(entry);
        }
        return ret;
    }

    public Set<Integer> createCaHasProfiles(NameId ca) throws CaMgmtException {
        return this.createCaHasEntities("CA_HAS_PROFILE", "PROFILE_ID", ca);
    }

    public Set<Integer> createCaHasPublishers(NameId ca) throws CaMgmtException {
        return this.createCaHasEntities("CA_HAS_PUBLISHER", "PUBLISHER_ID", ca);
    }

    private Set<Integer> createCaHasEntities(String table, String column, NameId ca) throws CaMgmtException {
        String sql = "SELECT " + column + " FROM " + table + " WHERE CA_ID=?";
        List<ResultRow> rows = this.execQueryPrepStmt0(sql, CaManagerQueryExecutor.col2Int(ca.getId()));
        HashSet<Integer> ret = new HashSet<Integer>();
        for (ResultRow rs : rows) {
            ret.add(CaManagerQueryExecutor.getInt(rs, column));
        }
        return ret;
    }

    private long getNextId(CaManagerQueryExecutorBase.Table table) throws CaMgmtException {
        try {
            long idInDb = this.datasource.getMax(null, table.name(), "ID");
            AtomicLong cachedId = this.cachedIdMap.get((Object)table);
            long nextId = Math.max(idInDb, cachedId.get()) + 1L;
            cachedId.set(nextId);
            return nextId;
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    public void addCa(CaEntry caEntry) throws CaMgmtException {
        RevokeSuspendedControl revokeSuspended;
        ConfPairs extraControl;
        CtlogControl ctlogControl;
        CrlControl crlControl;
        Args.notNull((Object)caEntry, (String)"caEntry");
        caEntry.getIdent().setId(Integer.valueOf((int)this.getNextId(CaManagerQueryExecutorBase.Table.CA)));
        String colNames = "ID,NAME,STATUS,NEXT_CRLNO,CRL_SIGNER_NAME,SUBJECT,SIGNER_TYPE,SIGNER_CONF,CERT,CERTCHAIN,CONF";
        String sql = SqlUtil.buildInsertSql((String)"CA", (String)colNames);
        byte[] encodedCert = caEntry.getCert().getEncoded();
        List certchain = caEntry.getCertchain();
        String certchainStr = CollectionUtil.isEmpty((Collection)certchain) ? null : CaUtil.encodeCertchain(CaUtil.buildCertChain(caEntry.getCert(), certchain));
        List<QueryExecutor.SqlColumn2> cols = CaUtil.asModifiableList(CaManagerQueryExecutor.col2Int(caEntry.getIdent().getId()), CaManagerQueryExecutor.col2Str(caEntry.getIdent().getName()), CaManagerQueryExecutor.col2Str(caEntry.getStatus().getStatus()), CaManagerQueryExecutor.col2Long(caEntry.getNextCrlNumber()), CaManagerQueryExecutor.col2Str(caEntry.getCrlSignerName()), CaManagerQueryExecutor.col2Str(caEntry.getSubject()), CaManagerQueryExecutor.col2Str(caEntry.getSignerType()), CaManagerQueryExecutor.col2Str(caEntry.getSignerConf()), CaManagerQueryExecutor.col2Str(Base64.encodeToString((byte[])encodedCert)), CaManagerQueryExecutor.col2Str(certchainStr));
        CaConfColumn cc = new CaConfColumn();
        CaUris caUris = caEntry.getCaUris();
        if (caUris != null) {
            cc.setCacertUris(caUris.getCacertUris());
            cc.setCrlUris(caUris.getCrlUris());
            cc.setDeltaCrlUris(caUris.getDeltaCrlUris());
            cc.setOcspUris(caUris.getOcspUris());
        }
        if ((crlControl = caEntry.getCrlControl()) != null) {
            cc.setCrlControl(crlControl.getConfPairs().asMap());
        }
        if ((ctlogControl = caEntry.getCtlogControl()) != null) {
            cc.setCtlogControl(ctlogControl.getConfPairs().asMap());
        }
        if ((extraControl = caEntry.getExtraControl()) != null) {
            cc.setExtraControl(extraControl.asMap());
        }
        if ((revokeSuspended = caEntry.getRevokeSuspendedControl()) != null) {
            cc.setRevokeSuspendedControl(revokeSuspended.getConfPairs().asMap());
        }
        cc.setSnSize(caEntry.getSerialNoLen());
        if (caEntry.getMaxValidity() != null) {
            cc.setMaxValidity(caEntry.getMaxValidity().toString());
        }
        cc.setKeypairGenNames(caEntry.getKeypairGenNames());
        cc.setSaveCert(caEntry.isSaveCert());
        cc.setSaveKeypair(caEntry.isSaveKeypair());
        cc.setPermission(caEntry.getPermission());
        cc.setNumCrls(caEntry.getNumCrls());
        cc.setExpirationPeriod(caEntry.getExpirationPeriod());
        cc.setKeepExpiredCertDays(caEntry.getKeepExpiredCertInDays());
        if (caEntry.getValidityMode() != null) {
            cc.setValidityMode(caEntry.getValidityMode().name());
        }
        cols.add(CaManagerQueryExecutor.col2Str(cc.encode()));
        int num = this.execUpdatePrepStmt0(sql, cols.toArray(new QueryExecutor.SqlColumn2[0]));
        if (num == 0) {
            throw new CaMgmtException("could not add CA " + caEntry.getIdent());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("add CA '{}': {}", (Object)caEntry.getIdent(), (Object)caEntry.toString(false, true));
        }
    }

    public void addCaAlias(String aliasName, NameId ca) throws CaMgmtException {
        this.notNulls(aliasName, "aliasName", ca, "ca");
        String sql = SqlUtil.buildInsertSql((String)"CAALIAS", (String)"NAME,CA_ID");
        int num = this.execUpdatePrepStmt0(sql, CaManagerQueryExecutor.col2Str(aliasName), CaManagerQueryExecutor.col2Int(ca.getId()));
        if (num == 0) {
            throw new CaMgmtException("could not add CA alias " + aliasName);
        }
        LOG.info("added CA alias '{}' for CA '{}'", (Object)aliasName, (Object)ca);
    }

    public void addCertprofile(CertprofileEntry dbEntry) throws CaMgmtException {
        Args.notNull((Object)dbEntry, (String)"dbEntry");
        String sql = SqlUtil.buildInsertSql((String)"PROFILE", (String)"ID,NAME,TYPE,CONF");
        dbEntry.getIdent().setId(Integer.valueOf((int)this.getNextId(CaManagerQueryExecutorBase.Table.PROFILE)));
        int num = this.execUpdatePrepStmt0(sql, CaManagerQueryExecutor.col2Int(dbEntry.getIdent().getId()), CaManagerQueryExecutor.col2Str(dbEntry.getIdent().getName()), CaManagerQueryExecutor.col2Str(dbEntry.getType()), CaManagerQueryExecutor.col2Str(dbEntry.getConf()));
        if (num == 0) {
            throw new CaMgmtException("could not add certprofile " + dbEntry.getIdent());
        }
        LOG.info("added profile '{}': {}", (Object)dbEntry.getIdent(), (Object)dbEntry);
    }

    public void addCertprofileToCa(NameId profile, NameId ca) throws CaMgmtException {
        this.notNulls(profile, "profile", ca, "ca");
        String sql = SqlUtil.buildInsertSql((String)"CA_HAS_PROFILE", (String)"CA_ID,PROFILE_ID");
        this.addEntityToCa("profile", profile, ca, sql);
    }

    public void addPublisherToCa(NameId publisher, NameId ca) throws CaMgmtException {
        this.notNulls(publisher, "publisher", ca, "ca");
        String sql = SqlUtil.buildInsertSql((String)"CA_HAS_PUBLISHER", (String)"CA_ID,PUBLISHER_ID");
        this.addEntityToCa("publisher", publisher, ca, sql);
    }

    private void addEntityToCa(String desc, NameId entity, NameId ca, String sql) throws CaMgmtException {
        int num = this.execUpdatePrepStmt0(sql, CaManagerQueryExecutor.col2Int(ca.getId()), CaManagerQueryExecutor.col2Int(entity.getId()));
        if (num == 0) {
            throw new CaMgmtException("could not add " + desc + " " + entity + " to CA " + ca);
        }
        LOG.info("added {} '{}' to CA '{}'", new Object[]{desc, entity, ca});
    }

    public void addRequestor(RequestorEntry dbEntry) throws CaMgmtException {
        Args.notNull((Object)dbEntry, (String)"dbEntry");
        dbEntry.getIdent().setId(Integer.valueOf((int)this.getNextId(CaManagerQueryExecutorBase.Table.REQUESTOR)));
        String sql = SqlUtil.buildInsertSql((String)"REQUESTOR", (String)"ID,NAME,TYPE,CONF");
        int num = this.execUpdatePrepStmt0(sql, CaManagerQueryExecutor.col2Int(dbEntry.getIdent().getId()), CaManagerQueryExecutor.col2Str(dbEntry.getIdent().getName()), CaManagerQueryExecutor.col2Str(dbEntry.getType()), CaManagerQueryExecutor.col2Str(dbEntry.getConf()));
        if (num == 0) {
            throw new CaMgmtException("could not add requestor " + dbEntry.getIdent());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("added requestor '{}': {}", (Object)dbEntry.getIdent(), (Object)dbEntry.toString(false));
        }
    }

    public void addEmbeddedRequestor(String requestorName) throws CaMgmtException {
        requestorName = requestorName.toLowerCase();
        String sql = SqlUtil.buildInsertSql((String)"REQUESTOR", (String)"ID,NAME,TYPE,CONF");
        int nextId = (int)this.getNextId(CaManagerQueryExecutorBase.Table.REQUESTOR);
        int num = this.execUpdatePrepStmt0(sql, CaManagerQueryExecutor.col2Int(nextId), CaManagerQueryExecutor.col2Str(requestorName), CaManagerQueryExecutor.col2Str("EMBEDDED"), CaManagerQueryExecutor.col2Str("DEFAULT"));
        if (num == 0) {
            throw new CaMgmtException("could not add requestor " + requestorName);
        }
        LOG.info("added requestor '{}'", (Object)requestorName);
    }

    public void addRequestorToCa(CaHasRequestorEntry requestor, NameId ca) throws CaMgmtException {
        this.notNulls(requestor, "requestor", ca, "ca");
        String sql = SqlUtil.buildInsertSql((String)"CA_HAS_REQUESTOR", (String)"CA_ID,REQUESTOR_ID,PERMISSION,PROFILES");
        String profilesText = StringUtil.collectionAsString((Collection)requestor.getProfiles(), (String)",");
        NameId requestorIdent = requestor.getRequestorIdent();
        int num = this.execUpdatePrepStmt0(sql, CaManagerQueryExecutor.col2Int(ca.getId()), CaManagerQueryExecutor.col2Int(requestorIdent.getId()), CaManagerQueryExecutor.col2Int(requestor.getPermission()), CaManagerQueryExecutor.col2Str(profilesText));
        if (num == 0) {
            throw new CaMgmtException("could not add requestor " + requestorIdent + " to CA " + ca);
        }
        LOG.info("added requestor '{}' to CA '{}': ermission: {}; profile: {}", new Object[]{requestorIdent, ca, requestor.getPermission(), profilesText});
    }

    public void addPublisher(PublisherEntry dbEntry) throws CaMgmtException {
        Args.notNull((Object)dbEntry, (String)"dbEntry");
        String sql = SqlUtil.buildInsertSql((String)"PUBLISHER", (String)"ID,NAME,TYPE,CONF");
        dbEntry.getIdent().setId(Integer.valueOf((int)this.getNextId(CaManagerQueryExecutorBase.Table.PUBLISHER)));
        String name = dbEntry.getIdent().getName();
        int num = this.execUpdatePrepStmt0(sql, CaManagerQueryExecutor.col2Int(dbEntry.getIdent().getId()), CaManagerQueryExecutor.col2Str(name), CaManagerQueryExecutor.col2Str(dbEntry.getType()), CaManagerQueryExecutor.col2Str(dbEntry.getConf()));
        if (num == 0) {
            throw new CaMgmtException("could not add publisher " + dbEntry.getIdent());
        }
        LOG.info("added publisher '{}': {}", (Object)dbEntry.getIdent(), (Object)dbEntry);
    }

    public void changeCa(ChangeCaEntry changeCaEntry, CaEntry currentCaEntry, CaConfColumn currentCaConfColumn, SecurityFactory securityFactory) throws CaMgmtException {
        this.notNulls(changeCaEntry, "changeCaEntry", securityFactory, "securityFactory");
        byte[] encodedCert = changeCaEntry.getEncodedCert();
        if (encodedCert != null) {
            boolean anyCertIssued;
            try {
                anyCertIssued = this.datasource.columnExists(null, "CERT", "CA_ID", (Object)changeCaEntry.getIdent().getId());
            }
            catch (DataAccessException ex) {
                throw new CaMgmtException((Throwable)ex);
            }
            if (anyCertIssued) {
                throw new CaMgmtException("Cannot change certificate of CA which has issued certificates");
            }
        }
        String signerType = changeCaEntry.getSignerType();
        String signerConf = changeCaEntry.getSignerConf();
        X509Cert caCert = null;
        if (signerType != null || signerConf != null || encodedCert != null || CollectionUtil.isNotEmpty((Collection)changeCaEntry.getEncodedCertchain())) {
            ResultRow rs;
            String sql;
            if (encodedCert != null) {
                caCert = CaUtil.parseCert(encodedCert);
            } else {
                sql = "SELECT CERT FROM CA WHERE ID=?";
                rs = this.execQuery1PrepStmt0("SELECT CERT FROM CA WHERE ID=?", CaManagerQueryExecutor.col2Int(changeCaEntry.getIdent().getId()));
                if (rs == null) {
                    throw new CaMgmtException("unknown CA '" + changeCaEntry.getIdent());
                }
                caCert = CaUtil.parseCert(Base64.decode((String)rs.getString("CERT")));
            }
            if (signerType != null || signerConf != null || encodedCert != null) {
                sql = "SELECT SIGNER_TYPE,SIGNER_CONF FROM CA WHERE ID=?";
                rs = this.execQuery1PrepStmt0("SELECT SIGNER_TYPE,SIGNER_CONF FROM CA WHERE ID=?", CaManagerQueryExecutor.col2Int(changeCaEntry.getIdent().getId()));
                if (rs == null) {
                    throw new CaMgmtException("unknown CA '" + changeCaEntry.getIdent());
                }
                if (signerType == null) {
                    signerType = rs.getString("SIGNER_TYPE");
                }
                signerConf = signerConf == null ? rs.getString("SIGNER_CONF") : CaUtil.canonicalizeSignerConf(signerConf);
                try {
                    List signerConfs = CaEntry.splitCaSignerConfs((String)signerConf);
                    for (CaEntry.CaSignerConf m : signerConfs) {
                        ConcurrentContentSigner ignored = securityFactory.createSigner(signerType, new SignerConf(m.getConf()), caCert);
                        if (ignored == null) continue;
                        ignored.close();
                    }
                }
                catch (IOException | XiSecurityException | ObjectCreationException ex) {
                    throw new CaMgmtException("could not create signer for CA '" + changeCaEntry.getIdent() + "'" + ex.getMessage(), ex);
                }
            }
        }
        String subject = null;
        String base64Cert = null;
        if (encodedCert != null) {
            try {
                subject = X509Util.parseCert((byte[])encodedCert).getIssuerText();
                base64Cert = Base64.encodeToString((byte[])encodedCert);
            }
            catch (CertificateException ex) {
                throw new CaMgmtException("could not parse the certificate", (Throwable)ex);
            }
        }
        String certchainStr = null;
        if (changeCaEntry.getEncodedCertchain() != null) {
            List encodedCertchain = changeCaEntry.getEncodedCertchain();
            if (encodedCertchain.size() == 0) {
                certchainStr = "null";
            } else {
                List<X509Cert> certs = new LinkedList<X509Cert>();
                for (byte[] m : changeCaEntry.getEncodedCertchain()) {
                    certs.add(CaUtil.parseCert(m));
                }
                certs = CaUtil.buildCertChain(caCert, certs);
                certchainStr = CaUtil.encodeCertchain(certs);
            }
        }
        String status = changeCaEntry.getStatus() == null ? null : changeCaEntry.getStatus().name();
        List<QueryExecutor.SqlColumn> cols = CaUtil.asModifiableList(CaManagerQueryExecutor.colStr("STATUS", status), CaManagerQueryExecutor.colStr("CRL_SIGNER_NAME", changeCaEntry.getCrlSignerName()), CaManagerQueryExecutor.colStr("SUBJECT", subject), CaManagerQueryExecutor.colStr("SIGNER_TYPE", signerType), CaManagerQueryExecutor.colStr("SIGNER_CONF", signerConf, false, true), CaManagerQueryExecutor.colStr("CERT", base64Cert), CaManagerQueryExecutor.colStr("CERTCHAIN", certchainStr));
        cols.add(this.buildChangeCaConfColumn(changeCaEntry, currentCaConfColumn));
        this.changeIfNotNull("CA", CaManagerQueryExecutor.colInt("ID", changeCaEntry.getIdent().getId()), cols.toArray(new QueryExecutor.SqlColumn[0]));
    }

    private QueryExecutor.SqlColumn buildChangeCaConfColumn(ChangeCaEntry changeCaEntry, CaConfColumn currentCaConfColumn) {
        Integer i;
        Boolean b;
        List names;
        CaUris changeUris;
        String str;
        CaConfColumn newCC = currentCaConfColumn.clone();
        if (changeCaEntry.getMaxValidity() != null) {
            newCC.setMaxValidity(changeCaEntry.getMaxValidity().toString());
        }
        if ((str = changeCaEntry.getExtraControl()) != null) {
            newCC.setExtraControl("null".equalsIgnoreCase(str) ? null : new ConfPairs(str).asMap());
        }
        if (changeCaEntry.getValidityMode() != null) {
            newCC.setValidityMode(changeCaEntry.getValidityMode().name());
        }
        if ((changeUris = changeCaEntry.getCaUris()) != null) {
            List uris = changeUris.getCacertUris();
            if (uris != null) {
                newCC.setCacertUris(uris.isEmpty() ? null : uris);
            }
            if ((uris = changeUris.getCrlUris()) != null) {
                newCC.setCrlUris(uris.isEmpty() ? null : uris);
            }
            if ((uris = changeUris.getDeltaCrlUris()) != null) {
                newCC.setDeltaCrlUris(uris.isEmpty() ? null : uris);
            }
            if ((uris = changeUris.getOcspUris()) != null) {
                newCC.setOcspUris(uris.isEmpty() ? null : uris);
            }
        }
        if ((names = changeCaEntry.getKeypairGenNames()) != null) {
            newCC.setKeypairGenNames(names.isEmpty() || ((String)names.get(0)).equalsIgnoreCase("null") ? null : names);
        }
        if (changeCaEntry.getSerialNoLen() != null) {
            newCC.setSnSize(changeCaEntry.getSerialNoLen().intValue());
        }
        if ((str = changeCaEntry.getCrlControl()) != null) {
            newCC.setCrlControl("null".equalsIgnoreCase(str) ? null : new ConfPairs(str).asMap());
        }
        if ((str = changeCaEntry.getCtlogControl()) != null) {
            newCC.setCtlogControl("null".equalsIgnoreCase(str) ? null : new ConfPairs(str).asMap());
        }
        if ((b = changeCaEntry.getSaveCert()) != null) {
            newCC.setSaveCert(b.booleanValue());
        }
        if ((b = changeCaEntry.getSaveKeypair()) != null) {
            newCC.setSaveKeypair(b.booleanValue());
        }
        if ((i = changeCaEntry.getPermission()) != null) {
            newCC.setPermission(i.intValue());
        }
        if ((i = changeCaEntry.getNumCrls()) != null) {
            newCC.setNumCrls(i.intValue());
        }
        if ((i = changeCaEntry.getExpirationPeriod()) != null) {
            newCC.setExpirationPeriod(i.intValue());
        }
        if ((i = changeCaEntry.getKeepExpiredCertInDays()) != null) {
            newCC.setKeepExpiredCertDays(i.intValue());
        }
        if ((str = changeCaEntry.getRevokeSuspendedControl()) != null) {
            newCC.setRevokeSuspendedControl("null".equalsIgnoreCase(str) ? null : new ConfPairs(str).asMap());
        }
        String encodedConf = newCC.encode();
        boolean confIsSensitive = false;
        String encodedOrigConf = currentCaConfColumn.encode();
        if (encodedConf.equals(encodedOrigConf)) {
            encodedConf = null;
        } else if (encodedConf.contains("password")) {
            confIsSensitive = true;
        }
        return CaManagerQueryExecutor.colStr("CONF", encodedConf, confIsSensitive, false);
    }

    public void commitNextCrlNoIfLess(NameId ca, long nextCrlNo) throws CaMgmtException {
        ResultRow rs = this.execQuery1PrepStmt0(this.sqlNextSelectCrlNo, CaManagerQueryExecutor.col2Int(ca.getId()));
        long nextCrlNoInDb = CaManagerQueryExecutor.getLong(rs, "NEXT_CRLNO");
        if (nextCrlNoInDb < nextCrlNo) {
            this.execUpdatePrepStmt0("UPDATE CA SET NEXT_CRLNO=? WHERE ID=?", CaManagerQueryExecutor.col2Long(nextCrlNo), CaManagerQueryExecutor.col2Int(ca.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentifiedCertprofile changeCertprofile(NameId nameId, String type, String conf, CaManagerImpl certprofileManager) throws CaMgmtException {
        CertprofileEntry currentDbEntry = this.createCertprofile(nameId.getName());
        CertprofileEntry newDbEntry = new CertprofileEntry(currentDbEntry.getIdent(), CaManagerQueryExecutor.str(type, currentDbEntry.getType()), CaManagerQueryExecutor.str(conf, currentDbEntry.getConf()));
        IdentifiedCertprofile profile = certprofileManager.createCertprofile(newDbEntry);
        if (profile == null) {
            throw new CaMgmtException("could not create certprofile object");
        }
        boolean failed = true;
        try {
            this.changeIfNotNull("PROFILE", CaManagerQueryExecutor.colInt("ID", nameId.getId()), CaManagerQueryExecutor.colStr("TYPE", type), CaManagerQueryExecutor.colStr("CONF", conf));
            failed = false;
            IdentifiedCertprofile identifiedCertprofile = profile;
            return identifiedCertprofile;
        }
        finally {
            if (failed) {
                profile.close();
            }
        }
    }

    public RequestorEntryWrapper changeRequestor(NameId nameId, String type, String conf, PasswordResolver passwordResolver) throws CaMgmtException {
        Args.notNull((Object)nameId, (String)"nameId");
        RequestorEntryWrapper requestor = new RequestorEntryWrapper();
        requestor.setDbEntry(new RequestorEntry(nameId, type, conf));
        if (requestor.getDbEntry().isFaulty()) {
            throw new CaMgmtException("invalid requestor configuration");
        }
        this.changeIfNotNull("REQUESTOR", CaManagerQueryExecutor.colInt("ID", nameId.getId()), CaManagerQueryExecutor.colStr("TYPE", type), CaManagerQueryExecutor.colStr("CONF", conf));
        return requestor;
    }

    public SignerEntryWrapper changeSigner(String name, String type, String conf, String base64Cert, CaManagerImpl signerManager) throws CaMgmtException {
        String tmpType;
        Args.notBlank((String)name, (String)"name");
        Args.notNull((Object)signerManager, (String)"signerManager");
        SignerEntry dbEntry = this.createSigner(name);
        String string = tmpType = type == null ? dbEntry.getType() : type;
        if (conf != null) {
            conf = CaUtil.canonicalizeSignerConf(conf);
        }
        SignerEntry newDbEntry = new SignerEntry(name, tmpType, conf == null ? dbEntry.getConf() : conf, base64Cert == null ? dbEntry.getBase64Cert() : base64Cert);
        SignerEntryWrapper signer = signerManager.createSigner(newDbEntry);
        this.changeIfNotNull("SIGNER", CaManagerQueryExecutor.colStr("NAME", name), CaManagerQueryExecutor.colStr("TYPE", type), CaManagerQueryExecutor.colStr("CERT", base64Cert), CaManagerQueryExecutor.colStr("CONF", conf, false, true));
        return signer;
    }

    public KeypairGenEntryWrapper changeKeypairGen(String name, String type, String conf, CaManagerImpl manager) throws CaMgmtException {
        Args.notBlank((String)name, (String)"name");
        Args.notNull((Object)manager, (String)"manager");
        KeypairGenEntry dbEntry = this.createKeypairGen(name);
        String tmpType = type == null ? dbEntry.getType() : type;
        KeypairGenEntry newDbEntry = new KeypairGenEntry(name, tmpType, conf == null ? dbEntry.getConf() : conf);
        KeypairGenEntryWrapper wrapper = manager.createKeypairGenerator(newDbEntry);
        this.changeIfNotNull("KEYPAIR_GEN", CaManagerQueryExecutor.colStr("NAME", name), CaManagerQueryExecutor.colStr("TYPE", type), CaManagerQueryExecutor.colStr("CONF", conf, true, false));
        return wrapper;
    }

    public IdentifiedCertPublisher changePublisher(String name, String type, String conf, CaManagerImpl publisherManager) throws CaMgmtException {
        Args.notBlank((String)name, (String)"name");
        Args.notNull((Object)publisherManager, (String)"publisherManager");
        PublisherEntry currentDbEntry = this.createPublisher(name);
        PublisherEntry dbEntry = new PublisherEntry(currentDbEntry.getIdent(), type == null ? currentDbEntry.getType() : type, conf == null ? currentDbEntry.getConf() : conf);
        IdentifiedCertPublisher publisher = publisherManager.createPublisher(dbEntry);
        this.changeIfNotNull("PUBLISHER", CaManagerQueryExecutor.colStr("NAME", name), CaManagerQueryExecutor.colStr("TYPE", type), CaManagerQueryExecutor.colStr("CONF", conf));
        return publisher;
    }

    public void removeCa(String caName) throws CaMgmtException {
        Args.notBlank((String)caName, (String)"caName");
        String sql = "DELETE FROM CA WHERE NAME=?";
        int num = this.execUpdatePrepStmt0("DELETE FROM CA WHERE NAME=?", CaManagerQueryExecutor.col2Str(caName));
        if (num == 0) {
            throw new CaMgmtException("could not delete CA " + caName);
        }
    }

    public void removeCaAlias(String aliasName) throws CaMgmtException {
        Args.notBlank((String)aliasName, (String)"aliasName");
        int num = this.execUpdatePrepStmt0("DELETE FROM CAALIAS WHERE NAME=?", CaManagerQueryExecutor.col2Str(aliasName));
        if (num == 0) {
            throw new CaMgmtException("could not remove CA Alias " + aliasName);
        }
    }

    public void removeCertprofileFromCa(String profileName, String caName) throws CaMgmtException {
        Args.notBlank((String)profileName, (String)"profileName");
        Args.notBlank((String)caName, (String)"caName");
        this.removeEntityFromCa("profile", profileName, caName, this.sqlSelectProfileId, "DELETE FROM CA_HAS_PROFILE WHERE CA_ID=? AND PROFILE_ID=?");
    }

    public void removeRequestorFromCa(String requestorName, String caName) throws CaMgmtException {
        Args.notBlank((String)requestorName, (String)"requestorName");
        Args.notBlank((String)caName, (String)"caName");
        this.removeEntityFromCa("requestor", requestorName, caName, this.sqlSelectRequestorId, "DELETE FROM CA_HAS_REQUESTOR WHERE CA_ID=? AND REQUESTOR_ID=?");
    }

    public void removePublisherFromCa(String publisherName, String caName) throws CaMgmtException {
        Args.notBlank((String)publisherName, (String)"publisherName");
        Args.notBlank((String)caName, (String)"caName");
        this.removeEntityFromCa("publisher", publisherName, caName, this.sqlSelectPublisherId, "DELETE FROM CA_HAS_PUBLISHER WHERE CA_ID=? AND PUBLISHER_ID=?");
    }

    public void removeDbSchema(String name) throws CaMgmtException {
        Args.notBlank((String)name, (String)"name");
        String sql = "DELETE FROM DBSCHEMA WHERE NAME=?";
        int num = this.execUpdatePrepStmt0("DELETE FROM DBSCHEMA WHERE NAME=?", CaManagerQueryExecutor.col2Str(name));
        if (num == 0) {
            throw new CaMgmtException("could not delete DBSCHEMA " + name);
        }
    }

    private void removeEntityFromCa(String desc, String name, String caName, String sqlSelectId, String sqlRemove) throws CaMgmtException {
        Integer id = this.getIdForName(sqlSelectId, name);
        if (id == null) {
            throw new CaMgmtException(String.format("unknown %s %s ", desc, name));
        }
        int caId = this.getNonNullIdForName(this.sqlSelectCaId, caName);
        int num = this.execUpdatePrepStmt0(sqlRemove, CaManagerQueryExecutor.col2Int(caId), CaManagerQueryExecutor.col2Int(id));
        if (num == 0) {
            throw new CaMgmtException(String.format("could not remove %s from CA %s", name, caName));
        }
    }

    public void revokeCa(String caName, CertRevocationInfo revocationInfo) throws CaMgmtException {
        Args.notBlank((String)caName, (String)"caName");
        Args.notNull((Object)revocationInfo, (String)"revocationInfo");
        int num = this.execUpdatePrepStmt0("UPDATE CA SET REV_INFO=? WHERE NAME=?", CaManagerQueryExecutor.col2Str(revocationInfo.getEncoded()), CaManagerQueryExecutor.col2Str(caName));
        if (num == 0) {
            throw new CaMgmtException("could not revoke CA " + caName);
        }
    }

    public void addKeypairGen(KeypairGenEntry dbEntry) throws CaMgmtException {
        Args.notNull((Object)dbEntry, (String)"dbEntry");
        int num = this.execUpdatePrepStmt0("INSERT INTO KEYPAIR_GEN (NAME,TYPE,CONF) VALUES (?,?,?)", CaManagerQueryExecutor.col2Str(dbEntry.getName()), CaManagerQueryExecutor.col2Str(dbEntry.getType()), CaManagerQueryExecutor.col2Str(dbEntry.getConf()));
        if (num == 0) {
            throw new CaMgmtException("could not add keypair generation " + dbEntry.getName());
        }
        LOG.info("added keypair generation: {}", (Object)dbEntry.toString(true));
    }

    public void addSigner(SignerEntry dbEntry) throws CaMgmtException {
        Args.notNull((Object)dbEntry, (String)"dbEntry");
        int num = this.execUpdatePrepStmt0(SqlUtil.buildInsertSql((String)"SIGNER", (String)"NAME,TYPE,CERT,CONF"), CaManagerQueryExecutor.col2Str(dbEntry.getName()), CaManagerQueryExecutor.col2Str(dbEntry.getType()), CaManagerQueryExecutor.col2Str(dbEntry.getBase64Cert()), CaManagerQueryExecutor.col2Str(dbEntry.getConf()));
        if (num == 0) {
            throw new CaMgmtException("could not add signer " + dbEntry.getName());
        }
        LOG.info("added signer: {}", (Object)dbEntry.toString(false, true));
    }

    public void unlockCa() throws CaMgmtException {
        int num = this.execUpdateStmt0("DELETE FROM SYSTEM_EVENT WHERE NAME='LOCK'");
        if (num == 0) {
            throw new CaMgmtException("could not unlock CA");
        }
    }

    public void unrevokeCa(String caName) throws CaMgmtException {
        Args.notBlank((String)caName, (String)"caName");
        LOG.info("Unrevoking of CA '{}'", (Object)caName);
        int num = this.execUpdatePrepStmt0("UPDATE CA SET REV_INFO=? WHERE NAME=?", CaManagerQueryExecutor.col2Str(null), CaManagerQueryExecutor.col2Str(caName));
        if (num == 0) {
            throw new CaMgmtException("could not unrevoke CA " + caName);
        }
    }

    public void addDbSchema(String name, String value) throws CaMgmtException {
        String sql = SqlUtil.buildInsertSql((String)"DBSCHEMA", (String)"NAME,VALUE2");
        int num = this.execUpdatePrepStmt0(sql, CaManagerQueryExecutor.col2Str(name), CaManagerQueryExecutor.col2Str(value));
        if (num == 0) {
            throw new CaMgmtException("could not add DBSCHEMA " + name);
        }
        LOG.info("added DBSCHEMA '{}'", (Object)name);
    }

    public void changeDbSchema(String name, String value) throws CaMgmtException {
        String sql = "UPDATE DBSCHEMA SET VALUE2=? WHERE NAME=?";
        int num = this.execUpdatePrepStmt0(sql, CaManagerQueryExecutor.col2Str(value), CaManagerQueryExecutor.col2Str(name));
        if (num == 0) {
            throw new CaMgmtException("could not update DBSCHEMA " + name);
        }
        LOG.info("added DBSCHEMA '{}'", (Object)name);
    }

    public Map<String, String> getDbSchemas() throws CaMgmtException {
        QueryExecutor.DbSchemaInfo dbi;
        try {
            dbi = new QueryExecutor.DbSchemaInfo(this.datasource);
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
        Set<String> names = dbi.getVariableNames();
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String name : names) {
            ret.put(name, dbi.variableValue(name));
        }
        return ret;
    }

    private static X509Cert generateCert(String b64Cert) throws CaMgmtException {
        return b64Cert == null ? null : CaUtil.parseCert(Base64.decode((String)b64Cert));
    }

    private static List<X509Cert> generateCertchain(String encodedCertchain) throws CaMgmtException {
        if (StringUtil.isBlank((String)encodedCertchain)) {
            return null;
        }
        try {
            List certs = X509Util.listCertificates((String)encodedCertchain);
            return CollectionUtil.isEmpty((Collection)certs) ? null : certs;
        }
        catch (IOException | CertificateException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    private static boolean getBoolean(ResultRow rs, String label) {
        return rs.getBoolean(label);
    }

    private static int getInt(ResultRow rs, String label) {
        return rs.getInt(label);
    }

    private static long getLong(ResultRow rs, String label) {
        return rs.getLong(label);
    }
}

