/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.keypool;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.sql.Connection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.server.keypool.KeypoolQueryExecutor;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.KeypairGenerator;
import org.xipki.security.XiSecurityException;
import org.xipki.util.Args;
import org.xipki.util.ConfPairs;
import org.xipki.util.FileOrValue;
import org.xipki.util.StringUtil;

public class KeypoolKeypairGenerator
extends KeypairGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(KeypoolKeypairGenerator.class);
    private int shardId;
    private KeypoolQueryExecutor queryExecutor;
    private SecretKey aes128key;
    private SecretKey aes192key;
    private SecretKey aes256key;
    private Cipher cipher;
    private Map<String, FileOrValue> datasourceConfs;
    private final Map<String, Integer> keyspecToId = new HashMap<String, Integer>();

    public void setShardId(int shardId) {
        this.shardId = shardId;
    }

    public int getShardId() {
        return this.shardId;
    }

    public KeypoolQueryExecutor getQueryExecutor() {
        return this.queryExecutor;
    }

    public void setQueryExecutor(KeypoolQueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }

    public Map<String, FileOrValue> getDatasourceConfs() {
        return this.datasourceConfs;
    }

    public void setDatasourceConfs(Map<String, FileOrValue> datasourceConfs) {
        this.datasourceConfs = datasourceConfs;
    }

    protected void initialize0(ConfPairs conf, PasswordResolver passwordResolver) throws XiSecurityException {
        Args.notNull((Object)conf, (String)"conf");
        String datasourceName = conf.value("datasource");
        FileOrValue datasourceConf = null;
        if (datasourceName != null) {
            datasourceConf = this.datasourceConfs.get(datasourceName);
        }
        if (datasourceConf == null) {
            throw new XiSecurityException("no datasource named '" + datasourceName + "' is specified");
        }
        DataSourceWrapper datasource = KeypoolKeypairGenerator.loadDatasource(datasourceName, datasourceConf, passwordResolver);
        try {
            this.queryExecutor = new KeypoolQueryExecutor(datasource, this.shardId);
            this.keyspecToId.clear();
            this.keyspecToId.putAll(this.queryExecutor.getKeyspecs());
            HashSet<String> set = new HashSet<String>();
            for (String m : this.keyspecs) {
                if (!this.keyspecToId.containsKey(m)) continue;
                set.add(m);
            }
            this.keyspecs.clear();
            this.keyspecs.addAll(set);
        }
        catch (DataAccessException ex) {
            throw new XiSecurityException(ex.getMessage(), (Throwable)ex);
        }
        String password = conf.value("password");
        if (StringUtil.isBlank((String)password)) {
            throw new IllegalArgumentException("property password not defined");
        }
        try {
            int[] keyLengths;
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            char[] passwordChars = password.toCharArray();
            for (int keyLength : keyLengths = new int[]{128, 192, 256}) {
                PBEKeySpec spec = new PBEKeySpec(passwordChars, "ENC".getBytes(StandardCharsets.UTF_8), 10000, keyLength);
                SecretKeySpec key = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
                if (keyLength == 128) {
                    this.aes128key = key;
                    continue;
                }
                if (keyLength == 192) {
                    this.aes192key = key;
                    continue;
                }
                this.aes256key = key;
            }
            this.cipher = Cipher.getInstance("AES/GCM/NoPadding");
        }
        catch (Exception ex) {
            throw new IllegalStateException("could not initialize Cipher", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PrivateKeyInfo generateKeypair(String keyspec) throws XiSecurityException {
        byte[] plain;
        SecretKey key;
        CipherData cd;
        Integer keyspecId = this.keyspecToId.get(keyspec);
        if (keyspecId == null) {
            return null;
        }
        Integer n = keyspecId;
        synchronized (n) {
            try {
                cd = this.queryExecutor.nextKeyData(keyspecId);
            }
            catch (DataAccessException ex) {
                throw new XiSecurityException((Throwable)ex);
            }
        }
        if (cd == null) {
            throw new XiSecurityException("found no keypair of spec " + keyspec + " in the keypool");
        }
        GCMParameterSpec spec = new GCMParameterSpec(128, cd.encMeta);
        if (cd.encAlg == 1) {
            key = this.aes128key;
        } else if (cd.encAlg == 2) {
            key = this.aes192key;
        } else if (cd.encAlg == 3) {
            key = this.aes256key;
        } else {
            throw new XiSecurityException("unknown encryption algorithm " + cd.encAlg);
        }
        try {
            this.cipher.init(2, (Key)key, spec);
            plain = this.cipher.doFinal(cd.cipherText);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException ex) {
            throw new XiSecurityException("error decrypting ciphertext", (Throwable)ex);
        }
        return PrivateKeyInfo.getInstance((Object)plain);
    }

    public boolean isHealthy() {
        return this.queryExecutor != null && this.queryExecutor.isHealthy();
    }

    public void close() throws IOException {
        this.queryExecutor.close();
    }

    private static DataSourceWrapper loadDatasource(String datasourceName, FileOrValue datasourceConf, PasswordResolver passwordResolver) throws XiSecurityException {
        try {
            DataSourceWrapper datasource = new DataSourceFactory().createDataSource(datasourceName, datasourceConf, passwordResolver);
            Connection conn = datasource.getConnection();
            datasource.returnConnection(conn);
            LOG.info("loaded datasource.{}", (Object)datasourceName);
            return datasource;
        }
        catch (IOException | RuntimeException | DataAccessException | PasswordResolverException ex) {
            throw new XiSecurityException(ex.getClass().getName() + " while parsing datasource " + datasourceName + ": " + ex.getMessage(), ex);
        }
    }

    static class CipherData {
        int encAlg;
        byte[] encMeta;
        byte[] cipherText;

        CipherData() {
        }
    }
}

