/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.keypool;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.server.keypool.KeypoolKeypairGenerator;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.LogUtil;

class KeypoolQueryExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(KeypoolQueryExecutor.class);
    private final DataSourceWrapper datasource;
    private final String sqlGetKeyData;

    KeypoolQueryExecutor(DataSourceWrapper datasource, int shardId) throws DataAccessException {
        this.datasource = (DataSourceWrapper)Args.notNull((Object)datasource, (String)"datasource");
        this.sqlGetKeyData = datasource.buildSelectFirstSql(1, "ID,ENC_ALG,ENC_META,DATA FROM KEYPOOL WHERE SHARD_ID=" + shardId + " AND KID=?");
    }

    void close() {
        if (this.datasource != null) {
            this.datasource.close();
        }
    }

    Map<String, Integer> getKeyspecs() throws DataAccessException {
        String sql = "SELECT ID,KEYSPEC FROM KEYSPEC";
        Statement ps = this.datasource.createStatement();
        ResultSet rs = null;
        HashMap<String, Integer> rv = new HashMap<String, Integer>();
        try {
            rs = ps.executeQuery("SELECT ID,KEYSPEC FROM KEYSPEC");
            while (rs.next()) {
                rv.put(rs.getString("KEYSPEC").toUpperCase(Locale.ROOT), rs.getInt("ID"));
            }
            HashMap<String, Integer> hashMap = rv;
            return hashMap;
        }
        catch (SQLException ex) {
            throw this.datasource.translate("SELECT ID,KEYSPEC FROM KEYSPEC", ex);
        }
        finally {
            this.datasource.releaseResources(ps, rs);
        }
    }

    KeypoolKeypairGenerator.CipherData nextKeyData(int keyspecId) throws DataAccessException {
        String sql = this.sqlGetKeyData;
        PreparedStatement ps = this.datasource.prepareStatement(sql);
        ResultSet rs = null;
        try {
            ps.setInt(1, keyspecId);
            rs = ps.executeQuery();
            if (!rs.next()) {
                KeypoolKeypairGenerator.CipherData cipherData = null;
                return cipherData;
            }
            int id = rs.getInt("ID");
            KeypoolKeypairGenerator.CipherData cd = new KeypoolKeypairGenerator.CipherData();
            cd.encAlg = rs.getInt("ENC_ALG");
            cd.encMeta = Base64.decodeFast((String)rs.getString("ENC_META"));
            cd.cipherText = Base64.decodeFast((String)rs.getString("DATA"));
            this.datasource.releaseResources((Statement)ps, rs);
            ps = null;
            rs = null;
            String sqlDeleteKeyData = "DELETE FROM KEYPOOL WHERE ID=?";
            ps = this.datasource.prepareStatement("DELETE FROM KEYPOOL WHERE ID=?");
            ps.setInt(1, id);
            ps.executeUpdate();
            KeypoolKeypairGenerator.CipherData cipherData = cd;
            return cipherData;
        }
        catch (SQLException ex) {
            throw this.datasource.translate(sql, ex);
        }
        finally {
            this.datasource.releaseResources((Statement)ps, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isHealthy() {
        String sql = "SELECT ID FROM KEYSPEC";
        try {
            ResultSet rs = null;
            PreparedStatement ps = this.datasource.prepareStatement("SELECT ID FROM KEYSPEC");
            try {
                rs = ps.executeQuery();
            }
            finally {
                this.datasource.releaseResources((Statement)ps, rs);
            }
            return true;
        }
        catch (Exception ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            return false;
        }
    }
}

