/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.SocketException;
import java.sql.Connection;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditStatus;
import org.xipki.audit.Audits;
import org.xipki.audit.PciAuditEvent;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaManager;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CaSystemStatus;
import org.xipki.ca.api.mgmt.CertListInfo;
import org.xipki.ca.api.mgmt.CertListOrderBy;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.api.mgmt.RequestorInfo;
import org.xipki.ca.api.mgmt.entry.CaEntry;
import org.xipki.ca.api.mgmt.entry.CaHasRequestorEntry;
import org.xipki.ca.api.mgmt.entry.CertprofileEntry;
import org.xipki.ca.api.mgmt.entry.ChangeCaEntry;
import org.xipki.ca.api.mgmt.entry.KeypairGenEntry;
import org.xipki.ca.api.mgmt.entry.PublisherEntry;
import org.xipki.ca.api.mgmt.entry.RequestorEntry;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.ca.api.profile.CertprofileFactoryRegister;
import org.xipki.ca.api.publisher.CertPublisherFactoryRegister;
import org.xipki.ca.sdk.CertprofileInfoResponse;
import org.xipki.ca.server.CaIdNameMap;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.CaServerConf;
import org.xipki.ca.server.CtLogPublicKeyFinder;
import org.xipki.ca.server.IdentifiedCertPublisher;
import org.xipki.ca.server.IdentifiedCertprofile;
import org.xipki.ca.server.KeypairGenEntryWrapper;
import org.xipki.ca.server.RequestorEntryWrapper;
import org.xipki.ca.server.SignerEntryWrapper;
import org.xipki.ca.server.UniqueIdGenerator;
import org.xipki.ca.server.X509Ca;
import org.xipki.ca.server.db.CaManagerQueryExecutor;
import org.xipki.ca.server.db.CertStore;
import org.xipki.ca.server.mgmt.Ca2Manager;
import org.xipki.ca.server.mgmt.CertprofileManager;
import org.xipki.ca.server.mgmt.ConfLoader;
import org.xipki.ca.server.mgmt.KeypairGenManager;
import org.xipki.ca.server.mgmt.PublisherManager;
import org.xipki.ca.server.mgmt.RequestorManager;
import org.xipki.ca.server.mgmt.SignerManager;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceConf;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.license.api.CmLicense;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.security.KeyCertBytesPair;
import org.xipki.security.KeypairGenerator;
import org.xipki.security.SecurityFactory;
import org.xipki.security.X509Cert;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.util.Args;
import org.xipki.util.FileOrValue;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.OperationException;

public class CaManagerImpl
implements CaManager,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(CaManagerImpl.class);
    private static final String version = StringUtil.getVersion(CaManagerImpl.class);
    private static final String EVENT_LOCK = "LOCK";
    private static final String EVENT_CACHAGNE = "CA_CHANGE";
    final CaIdNameMap idNameMap = new CaIdNameMap();
    final Map<String, CaInfo> caInfos = new ConcurrentHashMap<String, CaInfo>();
    final Map<String, SignerEntryWrapper> signers = new ConcurrentHashMap<String, SignerEntryWrapper>();
    final Map<String, SignerEntry> signerDbEntries = new ConcurrentHashMap<String, SignerEntry>();
    final Map<String, IdentifiedCertprofile> certprofiles = new ConcurrentHashMap<String, IdentifiedCertprofile>();
    final Map<String, CertprofileEntry> certprofileDbEntries = new ConcurrentHashMap<String, CertprofileEntry>();
    final Map<String, IdentifiedCertPublisher> publishers = new ConcurrentHashMap<String, IdentifiedCertPublisher>();
    final Map<String, PublisherEntry> publisherDbEntries = new ConcurrentHashMap<String, PublisherEntry>();
    final Map<String, RequestorEntryWrapper> requestors = new ConcurrentHashMap<String, RequestorEntryWrapper>();
    final Map<String, RequestorEntry> requestorDbEntries = new ConcurrentHashMap<String, RequestorEntry>();
    final Map<String, KeypairGenEntryWrapper> keypairGens = new ConcurrentHashMap<String, KeypairGenEntryWrapper>();
    final Map<String, KeypairGenEntry> keypairGenDbEntries = new ConcurrentHashMap<String, KeypairGenEntry>();
    final Map<String, Set<String>> caHasProfiles = new ConcurrentHashMap<String, Set<String>>();
    final Map<String, Set<String>> caHasPublishers = new ConcurrentHashMap<String, Set<String>>();
    final Map<String, Set<CaHasRequestorEntry>> caHasRequestors = new ConcurrentHashMap<String, Set<CaHasRequestorEntry>>();
    final Map<String, Integer> caAliases = new ConcurrentHashMap<String, Integer>();
    final Map<String, X509Ca> x509cas = new ConcurrentHashMap<String, X509Ca>();
    RequestorInfo byCaRequestor;
    boolean masterMode;
    boolean noLock;
    int shardId;
    Map<String, FileOrValue> datasourceNameConfFileMap;
    CaServerConf caServerConf;
    CertprofileFactoryRegister certprofileFactoryRegister;
    CertPublisherFactoryRegister certPublisherFactoryRegister;
    CertStore certstore;
    SecurityFactory securityFactory;
    P11CryptServiceFactory p11CryptServiceFactory;
    CaManagerQueryExecutor queryExecutor;
    private final CmLicense license;
    private DataSourceWrapper datasource;
    private final String lockInstanceId;
    private boolean caLockedByMe;
    private ScheduledThreadPoolExecutor persistentScheduledThreadPoolExecutor;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private final DataSourceFactory datasourceFactory;
    private CtLogPublicKeyFinder ctLogPublicKeyFinder;
    private boolean caSystemSetuped;
    private Instant lastStartTime;
    private boolean initializing;
    private final Ca2Manager ca2Manager;
    private final CertprofileManager certprofileManager;
    private final ConfLoader confLoader;
    private final PublisherManager publisherManager;
    private final RequestorManager requestorManager;
    private final SignerManager signerManager;
    private final KeypairGenManager keypairGenManager;

    public CaManagerImpl(CmLicense license) {
        LOG.info("XiPKI CA version {}", (Object)version);
        this.license = (CmLicense)Args.notNull((Object)license, (String)"license");
        this.datasourceFactory = new DataSourceFactory();
        String calockId = null;
        File calockFile = new File("calock");
        if (calockFile.exists()) {
            try {
                calockId = StringUtil.toUtf8String((byte[])IoUtil.read((File)calockFile));
            }
            catch (IOException ex) {
                LOG.error("could not read {}: {}", (Object)calockFile.getName(), (Object)ex.getMessage());
            }
        }
        if (calockId == null) {
            calockId = UUID.randomUUID().toString();
            try {
                IoUtil.save((File)calockFile, (byte[])StringUtil.toUtf8Bytes((String)calockId));
            }
            catch (IOException ex) {
                LOG.error("could not save {}: {}", (Object)calockFile.getName(), (Object)ex.getMessage());
            }
        }
        String hostAddress = null;
        try {
            hostAddress = IoUtil.getHostAddress();
        }
        catch (SocketException ex) {
            LOG.warn("could not get host address: {}", (Object)ex.getMessage());
        }
        this.lockInstanceId = hostAddress == null ? calockId : hostAddress + "/" + calockId;
        this.ca2Manager = new Ca2Manager(this);
        this.certprofileManager = new CertprofileManager(this);
        this.confLoader = new ConfLoader(this);
        this.publisherManager = new PublisherManager(this);
        this.requestorManager = new RequestorManager(this);
        this.signerManager = new SignerManager(this);
        this.keypairGenManager = new KeypairGenManager(this);
    }

    public int getShardId() {
        return this.shardId;
    }

    public SecurityFactory getSecurityFactory() {
        return this.securityFactory;
    }

    public void setSecurityFactory(SecurityFactory securityFactory) {
        this.securityFactory = securityFactory;
    }

    public P11CryptServiceFactory getP11CryptServiceFactory() {
        return this.p11CryptServiceFactory;
    }

    public void setP11CryptServiceFactory(P11CryptServiceFactory p11CryptServiceFactory) {
        this.p11CryptServiceFactory = p11CryptServiceFactory;
    }

    public boolean isMasterMode() {
        return this.masterMode;
    }

    public Set<String> getSupportedSignerTypes() {
        return this.securityFactory.getSupportedSignerTypes();
    }

    public Set<String> getSupportedCertprofileTypes() {
        return this.certprofileFactoryRegister.getSupportedTypes();
    }

    public Set<String> getSupportedPublisherTypes() {
        return this.certPublisherFactoryRegister.getSupportedTypes();
    }

    public String getTokenInfoP11(String moduleName, Integer slotIndex, boolean verbose) throws CaMgmtException {
        return this.signerManager.getTokenInfoP11(moduleName, slotIndex, verbose);
    }

    private void init() throws CaMgmtException {
        if (this.securityFactory == null) {
            throw new IllegalStateException("securityFactory is not set");
        }
        if (this.datasourceFactory == null) {
            throw new IllegalStateException("datasourceFactory is not set");
        }
        if (this.certprofileFactoryRegister == null) {
            throw new IllegalStateException("certprofileFactoryRegister is not set");
        }
        if (this.certPublisherFactoryRegister == null) {
            throw new IllegalStateException("certPublisherFactoryRegister is not set");
        }
        if (this.caServerConf == null) {
            throw new IllegalStateException("caServerConf is not set");
        }
        this.masterMode = this.caServerConf.isMaster();
        LOG.info("ca.masterMode: {}", (Object)this.masterMode);
        this.noLock = this.caServerConf.isNoLock();
        LOG.info("ca.noLock: {}", (Object)this.noLock);
        this.shardId = this.caServerConf.getShardId();
        LOG.info("ca.shardId: {}", (Object)this.shardId);
        this.caServerConf.initSsl();
        if (this.caServerConf.getCtLog() != null) {
            try {
                this.ctLogPublicKeyFinder = new CtLogPublicKeyFinder(this.caServerConf.getCtLog());
            }
            catch (Exception ex) {
                throw new CaMgmtException("could not load CtLogPublicKeyFinder: " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (this.datasourceNameConfFileMap == null) {
            this.datasourceNameConfFileMap = new ConcurrentHashMap<String, FileOrValue>();
            List<DataSourceConf> datasourceList = this.caServerConf.getDatasources();
            for (DataSourceConf dataSourceConf : datasourceList) {
                String name = dataSourceConf.getName();
                FileOrValue conf = dataSourceConf.getConf();
                this.datasourceNameConfFileMap.put(name, conf);
                if (conf.getFile() != null) {
                    LOG.info("associate datasource {} to the file {}", (Object)name, (Object)conf.getFile());
                    continue;
                }
                LOG.info("associate datasource {} to text value", (Object)name);
            }
            FileOrValue caDatasourceConf = this.datasourceNameConfFileMap.remove("ca");
            if (caDatasourceConf == null) {
                throw new CaMgmtException("no datasource named 'ca' configured");
            }
            this.datasource = this.loadDatasource("ca", caDatasourceConf);
        }
        this.queryExecutor = new CaManagerQueryExecutor(this.datasource);
        if (this.masterMode) {
            String[] embeddedNames;
            if (!this.noLock) {
                this.lockCa();
            }
            List names = this.queryExecutor.namesFromTable("REQUESTOR");
            for (String embeddedName : embeddedNames = new String[]{"by-ca"}) {
                boolean contained = false;
                for (String name : names) {
                    if (!embeddedName.equalsIgnoreCase(name)) continue;
                    contained = true;
                    break;
                }
                if (contained) continue;
                this.queryExecutor.addEmbeddedRequestor(embeddedName);
            }
        }
        long epochSecond = ZonedDateTime.of(2010, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC).toEpochSecond();
        UniqueIdGenerator uniqueIdGenerator = new UniqueIdGenerator(epochSecond, this.shardId);
        boolean initSucc = true;
        try {
            this.certstore = new CertStore(this.datasource, uniqueIdGenerator, this.securityFactory.getPasswordResolver());
        }
        catch (DataAccessException ex) {
            initSucc = false;
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error constructing CertStore");
        }
        try {
            this.ca2Manager.initCaAliases();
        }
        catch (CaMgmtException ex) {
            initSucc = false;
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error initCaAliases");
        }
        try {
            this.certprofileManager.initCertprofiles();
        }
        catch (CaMgmtException ex) {
            initSucc = false;
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error initCertprofiles");
        }
        try {
            this.publisherManager.initPublishers();
        }
        catch (CaMgmtException ex) {
            initSucc = false;
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error initPublishers");
        }
        try {
            this.requestorManager.initRequestors();
        }
        catch (CaMgmtException ex) {
            initSucc = false;
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error initRequestors");
        }
        try {
            this.signerManager.initSigners();
        }
        catch (CaMgmtException ex) {
            initSucc = false;
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error initSigners");
        }
        try {
            this.keypairGenManager.initKeypairGens();
        }
        catch (CaMgmtException ex) {
            initSucc = false;
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error initKeypairGens");
        }
        try {
            this.ca2Manager.initCas();
        }
        catch (CaMgmtException ex) {
            initSucc = false;
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error initCas");
        }
        if (!initSucc) {
            throw new CaMgmtException("error initializing CA system");
        }
    }

    public int getDbSchemaVersion() {
        return this.queryExecutor.getDbSchemaVersion();
    }

    private DataSourceWrapper loadDatasource(String datasourceName, FileOrValue datasourceConf) throws CaMgmtException {
        try {
            DataSourceWrapper datasource = this.datasourceFactory.createDataSource(datasourceName, datasourceConf, this.securityFactory.getPasswordResolver());
            Connection conn = datasource.getConnection();
            datasource.returnConnection(conn);
            LOG.info("loaded datasource.{}", (Object)datasourceName);
            return datasource;
        }
        catch (IOException | RuntimeException | DataAccessException | PasswordResolverException ex) {
            throw new CaMgmtException(StringUtil.concat((String)ex.getClass().getName(), (String[])new String[]{" while parsing datasource ", datasourceName, ": ", ex.getMessage()}), ex);
        }
    }

    public CaSystemStatus getCaSystemStatus() {
        if (this.caSystemSetuped) {
            return this.masterMode ? CaSystemStatus.STARTED_AS_MASTER : CaSystemStatus.STARTED_AS_SLAVE;
        }
        if (this.initializing) {
            return CaSystemStatus.INITIALIZING;
        }
        if (!this.caLockedByMe) {
            return CaSystemStatus.LOCK_FAILED;
        }
        return CaSystemStatus.ERROR;
    }

    private void lockCa() throws CaMgmtException {
        CertStore.SystemEvent lockInfo = this.queryExecutor.getSystemEvent(EVENT_LOCK);
        if (lockInfo != null) {
            String lockedBy = lockInfo.getOwner();
            Instant lockedAt = Instant.ofEpochSecond(lockInfo.getEventTime());
            if (!this.lockInstanceId.equals(lockedBy)) {
                String msg = StringUtil.concat((String)"could not lock CA, it has been locked by ", (String[])new String[]{lockedBy, " since ", lockedAt.toString(), ". In general this indicates that another CA software in master mode is accessing the database or the last shutdown of CA software in master mode is abnormal. If you know what you do, you can unlock it executing the ca:unlock command."});
                throw this.logAndCreateException(msg);
            }
            LOG.info("CA has been locked by me since {}, re-lock it", (Object)lockedAt);
        }
        CertStore.SystemEvent newLockInfo = new CertStore.SystemEvent(EVENT_LOCK, this.lockInstanceId, Instant.now().getEpochSecond());
        this.queryExecutor.changeSystemEvent(newLockInfo);
        this.caLockedByMe = true;
    }

    public void unlockCa() throws CaMgmtException {
        if (!this.masterMode) {
            throw this.logAndCreateException("could not unlock CA in slave mode");
        }
        boolean succ = false;
        try {
            this.queryExecutor.unlockCa();
            LOG.info("unlocked CA");
            succ = true;
        }
        finally {
            CaManagerImpl.auditLogPciEvent(succ, "UNLOCK");
        }
    }

    private void reset() {
        this.caSystemSetuped = false;
        this.ctLogPublicKeyFinder = null;
        this.signerManager.reset();
        this.requestorManager.reset();
        this.ca2Manager.reset();
        this.certprofileManager.reset();
        this.publisherManager.reset();
        this.keypairGenManager.reset();
        this.shutdownScheduledThreadPoolExecutor();
    }

    public void restartCa(String name) throws CaMgmtException {
        this.ca2Manager.restartCa(name);
    }

    public void restartCaSystem() throws CaMgmtException {
        this.reset();
        boolean caSystemStarted = this.startCaSystem0();
        CaManagerImpl.auditLogPciEvent(caSystemStarted, EVENT_CACHAGNE);
        if (!caSystemStarted) {
            throw this.logAndCreateException("could not restart CA system");
        }
    }

    public void notifyCaChange() throws CaMgmtException {
        try {
            CertStore.SystemEvent systemEvent = new CertStore.SystemEvent(EVENT_CACHAGNE, this.lockInstanceId, Instant.now().getEpochSecond());
            this.queryExecutor.changeSystemEvent(systemEvent);
            LOG.info("notified the change of CA system");
        }
        catch (CaMgmtException ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex, (String)"could not notify slave CAs to restart");
            throw ex;
        }
    }

    public void addDbSchema(String name, String value) throws CaMgmtException {
        CaManagerImpl.checkModificationOfDbSchema(name);
        this.queryExecutor.addDbSchema(name, value);
        try {
            this.certstore.updateDbInfo(this.securityFactory.getPasswordResolver());
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    public void changeDbSchema(String name, String value) throws CaMgmtException {
        CaManagerImpl.checkModificationOfDbSchema(name);
        this.queryExecutor.changeDbSchema(name, value);
        try {
            this.certstore.updateDbInfo(this.securityFactory.getPasswordResolver());
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    public void removeDbSchema(String name) throws CaMgmtException {
        CaManagerImpl.checkModificationOfDbSchema(name);
        this.queryExecutor.removeDbSchema(name);
        try {
            this.certstore.updateDbInfo(this.securityFactory.getPasswordResolver());
        }
        catch (DataAccessException ex) {
            throw new CaMgmtException((Throwable)ex);
        }
    }

    public Map<String, String> getDbSchemas() throws CaMgmtException {
        Map<String, String> all = this.queryExecutor.getDbSchemas();
        HashMap<String, String> noReserved = new HashMap<String, String>(all.size() * 5 / 4);
        block8: for (Map.Entry<String, String> entry : all.entrySet()) {
            switch (entry.getKey()) {
                case "VERSION": 
                case "VENDOR": 
                case "X500NAME_MAXLEN": {
                    continue block8;
                }
            }
            noReserved.put(entry.getKey(), entry.getValue());
        }
        return noReserved;
    }

    private static void checkModificationOfDbSchema(String name) throws CaMgmtException {
        if (StringUtil.orEqualsIgnoreCase((String)name, (String[])new String[]{"VERSION", "VENDOR", "X500NAME_MAXLEN"})) {
            throw new CaMgmtException("modification of reserved DBSCHEMA " + name + " is not allowed");
        }
    }

    public void startCaSystem() {
        boolean caSystemStarted = false;
        try {
            caSystemStarted = this.startCaSystem0();
        }
        catch (Throwable th) {
            LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not start CA system");
        }
        if (!caSystemStarted) {
            LOG.error("could not start CA system");
        }
        CaManagerImpl.auditLogPciEvent(caSystemStarted, "START");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startCaSystem0() {
        if (this.caSystemSetuped) {
            return true;
        }
        this.initializing = true;
        this.shutdownScheduledThreadPoolExecutor();
        try {
            String name;
            LOG.info("starting CA system");
            try {
                this.init();
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error initializing CA system");
                boolean bl = false;
                this.initializing = false;
                if (!this.masterMode && this.persistentScheduledThreadPoolExecutor == null) {
                    this.persistentScheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
                    this.persistentScheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
                    this.persistentScheduledThreadPoolExecutor.scheduleAtFixedRate(new CaRestarter(), 300L, 300L, TimeUnit.SECONDS);
                }
                return bl;
            }
            this.lastStartTime = Instant.now();
            this.x509cas.clear();
            this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(10);
            this.scheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
            LinkedList<String> failedCaNames = new LinkedList<String>();
            for (Map.Entry<String, CaInfo> entry : this.caInfos.entrySet()) {
                String caName = entry.getKey();
                CaStatus status = entry.getValue().getStatus();
                if (CaStatus.ACTIVE != status) continue;
                if (this.ca2Manager.startCa(caName)) {
                    LOG.info("started CA {}", (Object)caName);
                    continue;
                }
                failedCaNames.add(caName);
                LOG.error("could not start CA {}", (Object)caName);
            }
            this.caSystemSetuped = true;
            StringBuilder sb = new StringBuilder();
            sb.append("started CA system");
            Set<String> caAliasNames = this.getCaAliasNames();
            HashSet<String> names = new HashSet<String>(this.getCaNames());
            if (names.size() > 0) {
                sb.append(" with following CAs: ");
                for (String aliasName : caAliasNames) {
                    name = this.getCaNameForAlias(aliasName);
                    if (name == null) continue;
                    names.remove(name);
                    sb.append(name).append(" (alias ").append(aliasName).append("), ");
                }
                for (String name2 : names) {
                    sb.append(name2).append(", ");
                }
                int len = sb.length();
                sb.delete(len - 2, len);
                this.scheduledThreadPoolExecutor.scheduleAtFixedRate(new CertsInQueuePublisher(), 120L, 120L, TimeUnit.SECONDS);
            } else {
                sb.append(": no CA is configured");
            }
            if (!failedCaNames.isEmpty()) {
                sb.append(", and following CAs could not be started: ");
                for (String aliasName : caAliasNames) {
                    name = this.getCaNameForAlias(aliasName);
                    if (!failedCaNames.remove(name)) continue;
                    sb.append(name).append(" (alias ").append(aliasName).append("), ");
                }
                for (String name2 : failedCaNames) {
                    sb.append(name2).append(", ");
                }
                int len = sb.length();
                sb.delete(len - 2, len);
            }
            LOG.info("{}", (Object)sb);
        }
        finally {
            this.initializing = false;
            if (!this.masterMode && this.persistentScheduledThreadPoolExecutor == null) {
                this.persistentScheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
                this.persistentScheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
                this.persistentScheduledThreadPoolExecutor.scheduleAtFixedRate(new CaRestarter(), 300L, 300L, TimeUnit.SECONDS);
            }
        }
        return true;
    }

    @Override
    public void close() {
        LOG.info("stopping CA system");
        this.shutdownScheduledThreadPoolExecutor();
        if (this.persistentScheduledThreadPoolExecutor != null) {
            this.persistentScheduledThreadPoolExecutor.shutdown();
            while (!this.persistentScheduledThreadPoolExecutor.isTerminated()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    LOG.error("interrupted: {}", (Object)ex.getMessage());
                }
            }
            this.persistentScheduledThreadPoolExecutor = null;
        }
        this.ca2Manager.close();
        if (this.caLockedByMe) {
            try {
                this.unlockCa();
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not unlock CA system");
            }
        }
        if (this.datasource != null) {
            try {
                this.datasource.close();
            }
            catch (Exception ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)StringUtil.concat((String)"could not close datasource ca", (String[])new String[0]));
            }
        }
        this.publisherManager.close();
        this.certprofileManager.close();
        File caLockFile = new File("calock");
        if (caLockFile.exists()) {
            caLockFile.delete();
        }
        CaManagerImpl.auditLogPciEvent(true, "SHUTDOWN");
        LOG.info("stopped CA system");
        try {
            Audits.getAuditService().close();
        }
        catch (Exception ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex, (String)StringUtil.concat((String)"could not close audit service", (String[])new String[0]));
        }
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return this.scheduledThreadPoolExecutor;
    }

    public Set<String> getCertprofileNames() {
        return this.certprofileDbEntries.keySet();
    }

    public Set<String> getKeypairGenNames() {
        return this.keypairGenDbEntries.keySet();
    }

    public Set<String> getPublisherNames() {
        return this.publisherDbEntries.keySet();
    }

    public Set<String> getRequestorNames() {
        return this.requestorDbEntries.keySet();
    }

    public Set<String> getSignerNames() {
        return this.signerDbEntries.keySet();
    }

    public Set<String> getCaNames() {
        return this.caInfos.keySet();
    }

    public Set<String> getSuccessfulCaNames() {
        return this.ca2Manager.getSuccessfulCaNames();
    }

    public Set<String> getFailedCaNames() {
        return this.ca2Manager.getFailedCaNames();
    }

    public Set<String> getInactiveCaNames() {
        return this.ca2Manager.getInactiveCaNames();
    }

    public void commitNextCrlNo(NameId ca, long nextCrlNo) throws OperationException {
        this.ca2Manager.commitNextCrlNo(ca, nextCrlNo);
    }

    public void addCa(CaEntry caEntry) throws CaMgmtException {
        this.ca2Manager.addCa(caEntry);
    }

    public CaEntry getCa(String name) {
        CaInfo caInfo = this.caInfos.get(Args.toNonBlankLower((String)name, (String)"name"));
        return caInfo == null ? null : caInfo.getCaEntry();
    }

    public void changeCa(ChangeCaEntry entry) throws CaMgmtException {
        this.ca2Manager.changeCa(entry);
    }

    public void removeCertprofileFromCa(String profileName, String caName) throws CaMgmtException {
        this.certprofileManager.removeCertprofileFromCa(profileName, caName);
    }

    public void addCertprofileToCa(String profileName, String caName) throws CaMgmtException {
        this.certprofileManager.addCertprofileToCa(profileName, caName);
    }

    public void removePublisherFromCa(String publisherName, String caName) throws CaMgmtException {
        this.publisherManager.removePublisherFromCa(publisherName, caName);
    }

    public void addPublisherToCa(String publisherName, String caName) throws CaMgmtException {
        this.publisherManager.addPublisherToCa(publisherName, caName);
    }

    public Set<String> getCertprofilesForCa(String caName) {
        return this.caHasProfiles.get(Args.toNonBlankLower((String)caName, (String)"caName"));
    }

    public Set<CaHasRequestorEntry> getRequestorsForCa(String caName) {
        return this.caHasRequestors.get(Args.toNonBlankLower((String)caName, (String)"caName"));
    }

    public RequestorEntry getRequestor(String name) {
        return this.requestorDbEntries.get(Args.toNonBlankLower((String)name, (String)"name"));
    }

    public RequestorEntryWrapper getRequestorWrapper(String name) {
        return this.requestors.get(Args.toNonBlankLower((String)name, (String)"name"));
    }

    public void addRequestor(RequestorEntry requestorEntry) throws CaMgmtException {
        this.requestorManager.addRequestor(requestorEntry);
    }

    public void removeRequestor(String name) throws CaMgmtException {
        this.requestorManager.removeRequestor(name);
    }

    public void changeRequestor(String name, String type, String conf) throws CaMgmtException {
        this.requestorManager.changeRequestor(name, type, conf);
    }

    public void removeRequestorFromCa(String requestorName, String caName) throws CaMgmtException {
        this.requestorManager.removeRequestorFromCa(requestorName, caName);
    }

    public void addRequestorToCa(CaHasRequestorEntry requestor, String caName) throws CaMgmtException {
        this.requestorManager.addRequestorToCa(requestor, caName);
    }

    public CertprofileEntry getCertprofile(String name) {
        return this.certprofileDbEntries.get(name.toLowerCase());
    }

    public void removeCertprofile(String name) throws CaMgmtException {
        this.certprofileManager.removeCertprofile(name);
    }

    public void changeCertprofile(String name, String type, String conf) throws CaMgmtException {
        this.certprofileManager.changeCertprofile(name, type, conf);
    }

    public void addCertprofile(CertprofileEntry certprofileEntry) throws CaMgmtException {
        this.certprofileManager.addCertprofile(certprofileEntry);
    }

    public CertprofileInfoResponse getCertprofileInfo(String profileName) throws OperationException {
        return this.certprofileManager.getCertprofileInfo(profileName);
    }

    public KeypairGenEntry getKeypairGen(String name) {
        return this.keypairGenDbEntries.get(name);
    }

    public void removeKeypairGen(String name) throws CaMgmtException {
        this.keypairGenManager.removeKeypairGen(name);
    }

    public void changeKeypairGen(String name, String type, String conf) throws CaMgmtException {
        this.keypairGenManager.changeKeypairGen(name, type, conf);
    }

    public void addKeypairGen(KeypairGenEntry keypairGenEntry) throws CaMgmtException {
        this.keypairGenManager.addKeypairGen(keypairGenEntry);
    }

    public void addSigner(SignerEntry signerEntry) throws CaMgmtException {
        this.signerManager.addSigner(signerEntry);
    }

    public void removeSigner(String name) throws CaMgmtException {
        this.signerManager.removeSigner(name);
    }

    public void changeSigner(String name, String type, String conf, String base64Cert) throws CaMgmtException {
        this.signerManager.changeSigner(name, type, conf, base64Cert);
    }

    public SignerEntry getSigner(String name) {
        return this.signerDbEntries.get(Args.toNonBlankLower((String)name, (String)"name"));
    }

    public SignerEntryWrapper getSignerWrapper(String name) {
        return this.signers.get(Args.toNonBlankLower((String)name, (String)"name"));
    }

    public void addPublisher(PublisherEntry entry) throws CaMgmtException {
        this.publisherManager.addPublisher(entry);
    }

    public List<PublisherEntry> getPublishersForCa(String caName) {
        return this.publisherManager.getPublishersForCa(caName);
    }

    public PublisherEntry getPublisher(String name) {
        return this.publisherDbEntries.get(Args.toNonBlankLower((String)name, (String)"name"));
    }

    public void removePublisher(String name) throws CaMgmtException {
        this.publisherManager.removePublisher(name);
    }

    public void changePublisher(String name, String type, String conf) throws CaMgmtException {
        this.publisherManager.changePublisher(name, type, conf);
    }

    public void setCaServerConf(CaServerConf caServerConf) {
        this.caServerConf = (CaServerConf)((Object)Args.notNull((Object)((Object)caServerConf), (String)"caServerConf"));
    }

    public void addCaAlias(String aliasName, String caName) throws CaMgmtException {
        this.ca2Manager.addCaAlias(aliasName, caName);
    }

    public void removeCaAlias(String name) throws CaMgmtException {
        this.ca2Manager.removeCaAlias(name);
    }

    public String getCaNameForAlias(String aliasName) {
        return this.ca2Manager.getCaNameForAlias(aliasName);
    }

    public Set<String> getAliasesForCa(String caName) {
        return this.ca2Manager.getAliasesForCa(caName);
    }

    public Set<String> getCaAliasNames() {
        return this.caAliases.keySet();
    }

    public void removeCa(String name) throws CaMgmtException {
        this.ca2Manager.removeCa(name);
    }

    public void republishCertificates(String caName, List<String> publisherNames, int numThreads) throws CaMgmtException {
        this.publisherManager.republishCertificates(caName, publisherNames, numThreads);
    }

    public void revokeCa(String caName, CertRevocationInfo revocationInfo) throws CaMgmtException {
        this.ca2Manager.revokeCa(caName, revocationInfo);
    }

    public void unrevokeCa(String caName) throws CaMgmtException {
        this.ca2Manager.unrevokeCa(caName);
    }

    public void setCertprofileFactoryRegister(CertprofileFactoryRegister register) {
        this.certprofileFactoryRegister = register;
    }

    public void setCertPublisherFactoryRegister(CertPublisherFactoryRegister register) {
        this.certPublisherFactoryRegister = register;
    }

    static void auditLogPciEvent(boolean successful, String eventType) {
        PciAuditEvent event = new PciAuditEvent();
        event.setUserId("CA-SYSTEM");
        event.setEventType(eventType);
        event.setAffectedResource("CORE");
        event.setStatus((successful ? AuditStatus.SUCCESSFUL : AuditStatus.FAILED).name());
        event.setLevel(successful ? AuditLevel.INFO : AuditLevel.ERROR);
        Audits.getAuditService().logEvent(event);
    }

    public void clearPublishQueue(String caName, List<String> publisherNames) throws CaMgmtException {
        this.ca2Manager.clearPublishQueue(caName, publisherNames);
    }

    private void shutdownScheduledThreadPoolExecutor() {
        if (this.scheduledThreadPoolExecutor == null) {
            return;
        }
        this.scheduledThreadPoolExecutor.shutdown();
        this.scheduledThreadPoolExecutor = null;
    }

    public void revokeCertificate(String caName, BigInteger serialNumber, CrlReason reason, Instant invalidityTime) throws CaMgmtException {
        this.ca2Manager.revokeCertificate(caName, serialNumber, reason, invalidityTime);
    }

    public void unsuspendCertificate(String caName, BigInteger serialNumber) throws CaMgmtException {
        this.ca2Manager.unsuspendCertificate(caName, serialNumber);
    }

    public void removeCertificate(String caName, BigInteger serialNumber) throws CaMgmtException {
        this.ca2Manager.removeCertificate(caName, serialNumber);
    }

    public X509Cert generateCertificate(String caName, String profileName, byte[] encodedCsr, Instant notBefore, Instant notAfter) throws CaMgmtException {
        return this.ca2Manager.generateCertificate(caName, profileName, encodedCsr, notBefore, notAfter);
    }

    public X509Cert generateCrossCertificate(String caName, String profileName, byte[] encodedCsr, byte[] encodedTargetCert, Instant notBefore, Instant notAfter) throws CaMgmtException {
        return this.ca2Manager.generateCrossCertificate(caName, profileName, encodedCsr, encodedTargetCert, notBefore, notAfter);
    }

    public KeyCertBytesPair generateKeyCert(String caName, String profileName, String subject, Instant notBefore, Instant notAfter) throws CaMgmtException {
        return this.ca2Manager.generateKeyCert(caName, profileName, subject, notBefore, notAfter);
    }

    public X509Ca getX509Ca(String name) throws CaMgmtException {
        return this.ca2Manager.getX509Ca(name);
    }

    public KeypairGenerator getKeypairGenerator(String keypairGenName) {
        KeypairGenEntryWrapper keypairGen = this.keypairGens.get(keypairGenName = Args.toNonBlankLower((String)keypairGenName, (String)"keypairGenName"));
        return keypairGen == null ? null : keypairGen.getGenerator();
    }

    public IdentifiedCertprofile getIdentifiedCertprofile(String profileName) {
        return this.certprofiles.get(Args.toNonBlankLower((String)profileName, (String)"profileName"));
    }

    public List<IdentifiedCertPublisher> getIdentifiedPublishersForCa(String caName) {
        return this.publisherManager.getIdentifiedPublishersForCa(caName);
    }

    public X509Cert generateRootCa(CaEntry caEntry, String profileName, String subject, String serialNumber, Instant notBefore, Instant notAfter) throws CaMgmtException {
        return this.ca2Manager.generateRootCa(caEntry, profileName, subject, serialNumber, notBefore, notAfter);
    }

    void assertMasterMode() throws CaMgmtException {
        if (!this.masterMode) {
            throw new CaMgmtException("operation not allowed in slave mode");
        }
    }

    void assertMasterModeAndSetuped() throws CaMgmtException {
        this.assertMasterMode();
        if (!this.caSystemSetuped) {
            throw new CaMgmtException("CA system is not initialized yet.");
        }
    }

    public SignerEntryWrapper createSigner(SignerEntry entry) throws CaMgmtException {
        return this.signerManager.createSigner(entry);
    }

    public IdentifiedCertprofile createCertprofile(CertprofileEntry entry) throws CaMgmtException {
        return this.certprofileManager.createCertprofile(entry);
    }

    public IdentifiedCertPublisher createPublisher(PublisherEntry entry) throws CaMgmtException {
        return this.publisherManager.createPublisher(entry);
    }

    public KeypairGenEntryWrapper createKeypairGenerator(KeypairGenEntry entry) throws CaMgmtException {
        return this.keypairGenManager.createKeypairGen(entry);
    }

    public CaIdNameMap idNameMap() {
        return this.idNameMap;
    }

    public X509CRLHolder generateCrlOnDemand(String caName) throws CaMgmtException {
        return this.ca2Manager.generateCrlOnDemand(caName);
    }

    public X509CRLHolder getCrl(String caName, BigInteger crlNumber) throws CaMgmtException {
        return this.ca2Manager.getCrl(caName, crlNumber);
    }

    public X509CRLHolder getCurrentCrl(String caName) throws CaMgmtException {
        return this.ca2Manager.getCurrentCrl(caName);
    }

    public CertWithRevocationInfo getCert(String caName, BigInteger serialNumber) throws CaMgmtException {
        return this.ca2Manager.getCert(caName, serialNumber);
    }

    public CertWithRevocationInfo getCert(X500Name issuer, BigInteger serialNumber) throws CaMgmtException {
        return this.ca2Manager.getCert(issuer, serialNumber);
    }

    public List<CertListInfo> listCertificates(String caName, X500Name subjectPattern, Instant validFrom, Instant validTo, CertListOrderBy orderBy, int numEntries) throws CaMgmtException {
        return this.ca2Manager.listCertificates(caName, subjectPattern, validFrom, validTo, orderBy, numEntries);
    }

    public Map<String, X509Cert> loadConf(InputStream zippedConfStream) throws CaMgmtException {
        return this.confLoader.loadConf(zippedConfStream);
    }

    public InputStream exportConf(List<String> caNames) throws CaMgmtException, IOException {
        return this.confLoader.exportConf(caNames);
    }

    public CtLogPublicKeyFinder getCtLogPublicKeyFinder() {
        return this.ctLogPublicKeyFinder;
    }

    public CmLicense getLicense() {
        return this.license;
    }

    CaMgmtException logAndCreateException(String msg) {
        LOG.error(msg);
        return new CaMgmtException(msg);
    }

    private class CaRestarter
    implements Runnable {
        private boolean inProcess;

        private CaRestarter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.inProcess) {
                return;
            }
            this.inProcess = true;
            try {
                CertStore.SystemEvent event = CaManagerImpl.this.queryExecutor.getSystemEvent(CaManagerImpl.EVENT_CACHAGNE);
                long caChangedTime = event == null ? 0L : event.getEventTime();
                LOG.info("check the restart CA system event: changed at={}, lastStartTime={}", (Object)Instant.ofEpochSecond(caChangedTime), (Object)CaManagerImpl.this.lastStartTime);
                if (caChangedTime > CaManagerImpl.this.lastStartTime.getEpochSecond()) {
                    LOG.info("received event to restart CA");
                    CaManagerImpl.this.restartCaSystem();
                } else {
                    LOG.debug("received no event to restart CA");
                }
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"ScheduledCaRestarter");
            }
            finally {
                this.inProcess = false;
            }
        }
    }

    private class CertsInQueuePublisher
    implements Runnable {
        private boolean inProcess;

        private CertsInQueuePublisher() {
        }

        @Override
        public void run() {
            if (this.inProcess || !CaManagerImpl.this.caSystemSetuped) {
                return;
            }
            this.inProcess = true;
            try {
                CaManagerImpl.this.ca2Manager.pulishCertsInQueue();
            }
            finally {
                this.inProcess = false;
            }
        }
    }
}

