/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.SignerEntryWrapper;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotId;
import org.xipki.util.Args;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.ObjectCreationException;

class SignerManager {
    private static final Logger LOG = LoggerFactory.getLogger(SignerManager.class);
    private boolean signerInitialized;
    private final CaManagerImpl manager;

    SignerManager(CaManagerImpl manager) {
        this.manager = manager;
    }

    void reset() {
        this.signerInitialized = false;
    }

    void initSigners() throws CaMgmtException {
        if (this.signerInitialized) {
            return;
        }
        this.manager.signerDbEntries.clear();
        this.manager.signers.clear();
        List names = this.manager.queryExecutor.namesFromTable("SIGNER");
        for (String name : names) {
            SignerEntry entry = this.manager.queryExecutor.createSigner(name);
            entry.setConfFaulty(true);
            this.manager.signerDbEntries.put(name, entry);
            SignerEntryWrapper signer = this.createSigner(entry);
            entry.setConfFaulty(false);
            this.manager.signers.put(name, signer);
            LOG.info("loaded signer {}", (Object)name);
        }
        this.signerInitialized = true;
    }

    void addSigner(SignerEntry signerEntry) throws CaMgmtException {
        String newConf;
        this.manager.assertMasterMode();
        Args.notNull((Object)signerEntry, (String)"signerEntry");
        String name = signerEntry.getName();
        if (this.manager.signerDbEntries.containsKey(name)) {
            throw new CaMgmtException(StringUtil.concat((String)"Signer named ", (String[])new String[]{name, " exists"}));
        }
        String conf = signerEntry.getConf();
        if (conf != null && !conf.equals(newConf = CaUtil.canonicalizeSignerConf(conf))) {
            signerEntry.setConf(newConf);
        }
        SignerEntryWrapper signer = this.createSigner(signerEntry);
        this.manager.queryExecutor.addSigner(signerEntry);
        this.manager.signers.put(name, signer);
        this.manager.signerDbEntries.put(name, signerEntry);
    }

    void removeSigner(String name) throws CaMgmtException {
        this.manager.assertMasterMode();
        name = Args.toNonBlankLower((String)name, (String)"name");
        boolean bo = this.manager.queryExecutor.deleteRowWithName(name, "SIGNER");
        if (!bo) {
            throw new CaMgmtException("unknown signer " + name);
        }
        for (String caName : this.manager.caInfos.keySet()) {
            CaInfo caInfo = this.manager.caInfos.get(caName);
            if (!name.equals(caInfo.getCrlSignerName())) continue;
            caInfo.setCrlSignerName(null);
        }
        this.manager.signerDbEntries.remove(name);
        this.manager.signers.remove(name);
        LOG.info("removed signer '{}'", (Object)name);
    }

    void changeSigner(String name, String type, String conf, String base64Cert) throws CaMgmtException {
        this.manager.assertMasterMode();
        name = Args.toNonBlankLower((String)name, (String)"name");
        if (type == null && conf == null && base64Cert == null) {
            throw new IllegalArgumentException("nothing to change");
        }
        if (type != null) {
            type = type.toLowerCase();
        }
        SignerEntryWrapper newResponder = this.manager.queryExecutor.changeSigner(name, type, conf, base64Cert, this.manager);
        this.manager.signers.remove(name);
        this.manager.signerDbEntries.remove(name);
        this.manager.signerDbEntries.put(name, newResponder.getDbEntry());
        this.manager.signers.put(name, newResponder);
    }

    SignerEntryWrapper createSigner(SignerEntry entry) throws CaMgmtException {
        Args.notNull((Object)entry, (String)"entry");
        SignerEntryWrapper ret = new SignerEntryWrapper();
        ret.setDbEntry(entry);
        try {
            ret.initSigner(this.manager.securityFactory);
        }
        catch (ObjectCreationException ex) {
            String message = "error createSigner";
            LOG.debug("error createSigner", (Throwable)ex);
            throw new CaMgmtException(ex.getMessage());
        }
        return ret;
    }

    String getTokenInfoP11(String moduleName, Integer slotIndex, boolean verbose) throws CaMgmtException {
        StringBuilder sb = new StringBuilder();
        String NL = "\n";
        try {
            P11CryptService p11Service = this.manager.p11CryptServiceFactory.getP11CryptService(moduleName);
            if (p11Service == null) {
                throw new CaMgmtException("undefined module " + moduleName);
            }
            P11Module module = p11Service.getModule();
            sb.append("module: ").append(moduleName).append("\n");
            sb.append(module.getDescription()).append("\n");
            List slots = module.getSlotIds();
            if (slotIndex == null) {
                this.output(sb, slots);
            } else {
                P11SlotId slotId = module.getSlotIdForIndex(slotIndex.intValue());
                P11Slot slot = module.getSlot(slotId);
                sb.append("Details of slot\n");
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                slot.showDetails((OutputStream)bout, null, verbose);
                bout.flush();
                sb.append(StringUtil.toUtf8String((byte[])bout.toByteArray())).append("\n");
            }
        }
        catch (IOException | TokenException | XiSecurityException ex) {
            throw new CaMgmtException(ex);
        }
        return sb.toString();
    }

    private void output(StringBuilder sb, List<P11SlotId> slots) {
        int n = slots.size();
        if (n == 0 || n == 1) {
            String numText = n == 0 ? "no" : "1";
            sb.append(numText).append(" slot is configured\n");
        } else {
            sb.append(n).append(" slots are configured\n");
        }
        for (P11SlotId slotId : slots) {
            sb.append("\tslot[").append(slotId.getIndex()).append("]: ").append(slotId.getId()).append("\n");
        }
    }
}

